# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, Optional
from d361api.models.project_protection import ProjectProtection
from typing import Optional, Set
from typing_extensions import Self

class Language(BaseModel):
    """
    Language
    """ # noqa: E501
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    set_as_default: Optional[StrictBool] = None
    hidden: Optional[StrictBool] = None
    enable_rtl: Optional[StrictBool] = None
    site_protection_level: Optional[ProjectProtection] = None
    is_inheritance_disabled: Optional[StrictBool] = None
    has_inheritance_disabled_categories_or_articles: Optional[StrictBool] = None
    country_flag_code: Optional[StrictStr] = None
    display_name: Optional[StrictStr] = None
    is_home_page_enabled: Optional[StrictBool] = None
    version_display_name: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "name", "code", "set_as_default", "hidden", "enable_rtl", "site_protection_level", "is_inheritance_disabled", "has_inheritance_disabled_categories_or_articles", "country_flag_code", "display_name", "is_home_page_enabled", "version_display_name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Language from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if code (nullable) is None
        # and model_fields_set contains the field
        if self.code is None and "code" in self.model_fields_set:
            _dict['code'] = None

        # set to None if country_flag_code (nullable) is None
        # and model_fields_set contains the field
        if self.country_flag_code is None and "country_flag_code" in self.model_fields_set:
            _dict['country_flag_code'] = None

        # set to None if display_name (nullable) is None
        # and model_fields_set contains the field
        if self.display_name is None and "display_name" in self.model_fields_set:
            _dict['display_name'] = None

        # set to None if version_display_name (nullable) is None
        # and model_fields_set contains the field
        if self.version_display_name is None and "version_display_name" in self.model_fields_set:
            _dict['version_display_name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Language from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "code": obj.get("code"),
            "set_as_default": obj.get("set_as_default"),
            "hidden": obj.get("hidden"),
            "enable_rtl": obj.get("enable_rtl"),
            "site_protection_level": obj.get("site_protection_level"),
            "is_inheritance_disabled": obj.get("is_inheritance_disabled"),
            "has_inheritance_disabled_categories_or_articles": obj.get("has_inheritance_disabled_categories_or_articles"),
            "country_flag_code": obj.get("country_flag_code"),
            "display_name": obj.get("display_name"),
            "is_home_page_enabled": obj.get("is_home_page_enabled"),
            "version_display_name": obj.get("version_display_name")
        })
        return _obj


