# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from d361api.models.tags_meta_data_customer import TagsMetaDataCustomer
from typing import Optional, Set
from typing_extensions import Self

class MediaFilesMetaDataCustomer(BaseModel):
    """
    MediaFilesMetaDataCustomer
    """ # noqa: E501
    id: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The file ID")
    file_name: Optional[StrictStr] = Field(default=None, description="The file name")
    file_type: Optional[StrictStr] = Field(default=None, description="The file tyoe")
    file_url: Optional[StrictStr] = Field(default=None, description="The file URL")
    updated_on: Optional[datetime] = Field(default=None, description="The date file was modified")
    updated_by: Optional[StrictStr] = Field(default=None, description="The ID of the user who uploaded the file")
    size: Optional[StrictStr] = Field(default=None, description="The file size")
    tags: Optional[List[TagsMetaDataCustomer]] = Field(default=None, description="The tags associated with file")
    is_starred: Optional[StrictBool] = Field(default=None, description="This denotes the file is starred or not")
    __properties: ClassVar[List[str]] = ["id", "file_name", "file_type", "file_url", "updated_on", "updated_by", "size", "tags", "is_starred"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MediaFilesMetaDataCustomer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        # set to None if file_name (nullable) is None
        # and model_fields_set contains the field
        if self.file_name is None and "file_name" in self.model_fields_set:
            _dict['file_name'] = None

        # set to None if file_type (nullable) is None
        # and model_fields_set contains the field
        if self.file_type is None and "file_type" in self.model_fields_set:
            _dict['file_type'] = None

        # set to None if file_url (nullable) is None
        # and model_fields_set contains the field
        if self.file_url is None and "file_url" in self.model_fields_set:
            _dict['file_url'] = None

        # set to None if updated_by (nullable) is None
        # and model_fields_set contains the field
        if self.updated_by is None and "updated_by" in self.model_fields_set:
            _dict['updated_by'] = None

        # set to None if size (nullable) is None
        # and model_fields_set contains the field
        if self.size is None and "size" in self.model_fields_set:
            _dict['size'] = None

        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['tags'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MediaFilesMetaDataCustomer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "file_name": obj.get("file_name"),
            "file_type": obj.get("file_type"),
            "file_url": obj.get("file_url"),
            "updated_on": obj.get("updated_on"),
            "updated_by": obj.get("updated_by"),
            "size": obj.get("size"),
            "tags": [TagsMetaDataCustomer.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "is_starred": obj.get("is_starred")
        })
        return _obj


