# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from d361api.models.media_files_meta_data_customer import MediaFilesMetaDataCustomer
from d361api.models.media_folders_data_customer import MediaFoldersDataCustomer
from typing import Optional, Set
from typing_extensions import Self

class MediaFolderViewMetaDataCustomer(BaseModel):
    """
    MediaFolderViewMetaDataCustomer
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The ID of the folder in Drive")
    title: Optional[StrictStr] = Field(default=None, description="This  folder title")
    order: Optional[StrictInt] = Field(default=None, description="The order of the folder")
    parent_folder_id: Optional[StrictStr] = Field(default=None, description="The parent folder ID")
    files: Optional[List[MediaFilesMetaDataCustomer]] = Field(default=None, description="The files associated to the folder")
    icon: Optional[StrictStr] = Field(default=None, description="The icon of the folder")
    items_count: Optional[StrictInt] = Field(default=None, description="Subfolder count in the folder")
    updated_on: Optional[datetime] = Field(default=None, description="The date the folder was created")
    updated_by: Optional[StrictStr] = Field(default=None, description="The ID of the user that created the folder")
    is_starred: Optional[StrictBool] = Field(default=None, description="This denotes the folder is starred or not")
    folder_color: Optional[StrictStr] = Field(default=None, description="The folder color")
    files_count: Optional[StrictInt] = Field(default=None, description="The folder file count")
    sub_folders: Optional[List[MediaFoldersDataCustomer]] = Field(default=None, description="Sub folders of the media folder")
    __properties: ClassVar[List[str]] = ["id", "title", "order", "parent_folder_id", "files", "icon", "items_count", "updated_on", "updated_by", "is_starred", "folder_color", "files_count", "sub_folders"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MediaFolderViewMetaDataCustomer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in files (list)
        _items = []
        if self.files:
            for _item_files in self.files:
                if _item_files:
                    _items.append(_item_files.to_dict())
            _dict['files'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in sub_folders (list)
        _items = []
        if self.sub_folders:
            for _item_sub_folders in self.sub_folders:
                if _item_sub_folders:
                    _items.append(_item_sub_folders.to_dict())
            _dict['sub_folders'] = _items
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if parent_folder_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_folder_id is None and "parent_folder_id" in self.model_fields_set:
            _dict['parent_folder_id'] = None

        # set to None if files (nullable) is None
        # and model_fields_set contains the field
        if self.files is None and "files" in self.model_fields_set:
            _dict['files'] = None

        # set to None if icon (nullable) is None
        # and model_fields_set contains the field
        if self.icon is None and "icon" in self.model_fields_set:
            _dict['icon'] = None

        # set to None if updated_by (nullable) is None
        # and model_fields_set contains the field
        if self.updated_by is None and "updated_by" in self.model_fields_set:
            _dict['updated_by'] = None

        # set to None if folder_color (nullable) is None
        # and model_fields_set contains the field
        if self.folder_color is None and "folder_color" in self.model_fields_set:
            _dict['folder_color'] = None

        # set to None if sub_folders (nullable) is None
        # and model_fields_set contains the field
        if self.sub_folders is None and "sub_folders" in self.model_fields_set:
            _dict['sub_folders'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MediaFolderViewMetaDataCustomer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "title": obj.get("title"),
            "order": obj.get("order"),
            "parent_folder_id": obj.get("parent_folder_id"),
            "files": [MediaFilesMetaDataCustomer.from_dict(_item) for _item in obj["files"]] if obj.get("files") is not None else None,
            "icon": obj.get("icon"),
            "items_count": obj.get("items_count"),
            "updated_on": obj.get("updated_on"),
            "updated_by": obj.get("updated_by"),
            "is_starred": obj.get("is_starred"),
            "folder_color": obj.get("folder_color"),
            "files_count": obj.get("files_count"),
            "sub_folders": [MediaFoldersDataCustomer.from_dict(_item) for _item in obj["sub_folders"]] if obj.get("sub_folders") is not None else None
        })
        return _obj


