# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class MediaFoldersDataCustomer(BaseModel):
    """
    MediaFoldersDataCustomer
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="This is the folder Id")
    title: Optional[StrictStr] = Field(default=None, description="This is the folder title")
    parent_folder_id: Optional[StrictStr] = Field(default=None, description="The parent folder ID")
    sub_folders: Optional[List[MediaFoldersDataCustomer]] = Field(default=None, description="The sub folders in the parent")
    items_count: Optional[StrictInt] = Field(default=None, description="The items in the folder")
    updated_by: Optional[StrictStr] = Field(default=None, description="The ID of the user that created the folder")
    updated_on: Optional[datetime] = Field(default=None, description="The date the folder was created")
    order: Optional[StrictInt] = Field(default=None, description="The order of the folder")
    is_starred: Optional[StrictBool] = Field(default=None, description="This denotes the folder is starred or not")
    __properties: ClassVar[List[str]] = ["id", "title", "parent_folder_id", "sub_folders", "items_count", "updated_by", "updated_on", "order", "is_starred"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MediaFoldersDataCustomer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in sub_folders (list)
        _items = []
        if self.sub_folders:
            for _item_sub_folders in self.sub_folders:
                if _item_sub_folders:
                    _items.append(_item_sub_folders.to_dict())
            _dict['sub_folders'] = _items
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if parent_folder_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_folder_id is None and "parent_folder_id" in self.model_fields_set:
            _dict['parent_folder_id'] = None

        # set to None if sub_folders (nullable) is None
        # and model_fields_set contains the field
        if self.sub_folders is None and "sub_folders" in self.model_fields_set:
            _dict['sub_folders'] = None

        # set to None if updated_by (nullable) is None
        # and model_fields_set contains the field
        if self.updated_by is None and "updated_by" in self.model_fields_set:
            _dict['updated_by'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MediaFoldersDataCustomer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "title": obj.get("title"),
            "parent_folder_id": obj.get("parent_folder_id"),
            "sub_folders": [MediaFoldersDataCustomer.from_dict(_item) for _item in obj["sub_folders"]] if obj.get("sub_folders") is not None else None,
            "items_count": obj.get("items_count"),
            "updated_by": obj.get("updated_by"),
            "updated_on": obj.get("updated_on"),
            "order": obj.get("order"),
            "is_starred": obj.get("is_starred")
        })
        return _obj

# TODO: Rewrite to not use raise_errors
MediaFoldersDataCustomer.model_rebuild(raise_errors=False)

