# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, Optional
from d361api.models.ai_additional_feedback_info import AIAdditionalFeedbackInfo
from d361api.models.feedback_sub_type import FeedbackSubType
from typing import Optional, Set
from typing_extensions import Self

class PublicAPIAIFeedbackRequest(BaseModel):
    """
    PublicAPIAIFeedbackRequest
    """ # noqa: E501
    entity_id: Optional[StrictStr] = Field(default=None, description="Analytics ID returned by the ask-eddy response. Required to associate feedback with an ask-eddy query.")
    is_liked: Optional[StrictBool] = Field(default=None, description="Set to `true` if the user liked the AI response, and `false` if the user disliked the response.")
    comments: Optional[StrictStr] = Field(default=None, description="Optional user-provided feedback or suggestions about the AI response.")
    notify_me_about_changes: Optional[StrictBool] = Field(default=None, description="Set to `true` if the user wants to be notified when there is a response to their feedback.")
    feedback_provider_email: Optional[StrictStr] = Field(default=None, description="Email address of the user submitting the feedback. Required if `notify_me_about_changes` is set to `true`.")
    additional_feedback_info: Optional[AIAdditionalFeedbackInfo] = Field(default=None, description="Additional details about the user’s feedback. Helps categorize user feedback and respond effectively.")
    feedback_sub_type: Optional[FeedbackSubType] = Field(default=None, description="Set to `0` if the user did not receive a response to their query. Set to `1` if they received a response but were not satisfied with it.")
    __properties: ClassVar[List[str]] = ["entity_id", "is_liked", "comments", "notify_me_about_changes", "feedback_provider_email", "additional_feedback_info", "feedback_sub_type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PublicAPIAIFeedbackRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of additional_feedback_info
        if self.additional_feedback_info:
            _dict['additional_feedback_info'] = self.additional_feedback_info.to_dict()
        # set to None if entity_id (nullable) is None
        # and model_fields_set contains the field
        if self.entity_id is None and "entity_id" in self.model_fields_set:
            _dict['entity_id'] = None

        # set to None if comments (nullable) is None
        # and model_fields_set contains the field
        if self.comments is None and "comments" in self.model_fields_set:
            _dict['comments'] = None

        # set to None if feedback_provider_email (nullable) is None
        # and model_fields_set contains the field
        if self.feedback_provider_email is None and "feedback_provider_email" in self.model_fields_set:
            _dict['feedback_provider_email'] = None

        # set to None if additional_feedback_info (nullable) is None
        # and model_fields_set contains the field
        if self.additional_feedback_info is None and "additional_feedback_info" in self.model_fields_set:
            _dict['additional_feedback_info'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PublicAPIAIFeedbackRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "entity_id": obj.get("entity_id"),
            "is_liked": obj.get("is_liked"),
            "comments": obj.get("comments"),
            "notify_me_about_changes": obj.get("notify_me_about_changes"),
            "feedback_provider_email": obj.get("feedback_provider_email"),
            "additional_feedback_info": AIAdditionalFeedbackInfo.from_dict(obj["additional_feedback_info"]) if obj.get("additional_feedback_info") is not None else None,
            "feedback_sub_type": obj.get("feedback_sub_type")
        })
        return _obj


