# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from d361api.models.article_content_type import ArticleContentType
from d361api.models.article_status_indicator import ArticleStatusIndicator
from typing import Optional, Set
from typing_extensions import Self

class UpdateArticleSettingsRequest(BaseModel):
    """
    UpdateArticleSettingsRequest
    """ # noqa: E501
    slug: Optional[StrictStr] = Field(default=None, description="The slug of the article")
    seo_title: Optional[StrictStr] = Field(default=None, description="The SEO title of the article")
    description: Optional[StrictStr] = Field(default=None, description="The SEO description of the article")
    allow_comments: Optional[StrictBool] = Field(default=None, description="Enable or disable the commenting on the article. **true** - Commenting will be enabled; **false** - Commenting will be disabled")
    show_table_of_contents: Optional[StrictBool] = Field(default=None, description="Enable or disable the Table of Contents (TOC) for the article in the knowledge base. **true** - TOC will be enabled; **false** - TOC will be disabled")
    tags: Optional[List[StrictStr]] = Field(default=None, description="Custom article tags")
    status_indicator: Optional[ArticleStatusIndicator] = Field(default=None, description="Article status in the knowledge base. 0 - None; 1 - New; 2 - Updated; 3 - Custom")
    status_indicator_expiry_date: Optional[datetime] = Field(default=None, description="The date-time when the public article status is removed")
    exclude_from_search: Optional[StrictBool] = Field(default=None, description="**true** - The article will not appear in search results in the knowledge base; **false** - The article will appear in search results in the knowledge base")
    exclude_from_ai_search: Optional[StrictBool] = Field(default=None, description="**true** - The Eddy-AI assistant will not fetch information from this article; **false** - The Eddy-AI assistant will not exclude this article while fetching information")
    related_articles: Optional[List[StrictStr]] = Field(default=None, description="The list of related article IDs to show in the knowledge base")
    content_type: Optional[ArticleContentType] = Field(default=None, description="0 - Markdown; 1 - WYSIWYG(HTML); 2 - Advanced WYSIWYG")
    is_acknowledgement_enabled: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["slug", "seo_title", "description", "allow_comments", "show_table_of_contents", "tags", "status_indicator", "status_indicator_expiry_date", "exclude_from_search", "exclude_from_ai_search", "related_articles", "content_type", "is_acknowledgement_enabled"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateArticleSettingsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if slug (nullable) is None
        # and model_fields_set contains the field
        if self.slug is None and "slug" in self.model_fields_set:
            _dict['slug'] = None

        # set to None if seo_title (nullable) is None
        # and model_fields_set contains the field
        if self.seo_title is None and "seo_title" in self.model_fields_set:
            _dict['seo_title'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['tags'] = None

        # set to None if status_indicator_expiry_date (nullable) is None
        # and model_fields_set contains the field
        if self.status_indicator_expiry_date is None and "status_indicator_expiry_date" in self.model_fields_set:
            _dict['status_indicator_expiry_date'] = None

        # set to None if related_articles (nullable) is None
        # and model_fields_set contains the field
        if self.related_articles is None and "related_articles" in self.model_fields_set:
            _dict['related_articles'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateArticleSettingsRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "slug": obj.get("slug"),
            "seo_title": obj.get("seo_title"),
            "description": obj.get("description"),
            "allow_comments": obj.get("allow_comments"),
            "show_table_of_contents": obj.get("show_table_of_contents"),
            "tags": obj.get("tags"),
            "status_indicator": obj.get("status_indicator"),
            "status_indicator_expiry_date": obj.get("status_indicator_expiry_date"),
            "exclude_from_search": obj.get("exclude_from_search"),
            "exclude_from_ai_search": obj.get("exclude_from_ai_search"),
            "related_articles": obj.get("related_articles"),
            "content_type": obj.get("content_type"),
            "is_acknowledgement_enabled": obj.get("is_acknowledgement_enabled")
        })
        return _obj


