# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, Optional
from typing import Optional, Set
from typing_extensions import Self

class UpdateCategoryRequest(BaseModel):
    """
    UpdateCategoryRequest
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="The name of the category")
    order: Optional[StrictInt] = Field(default=None, description="The position of the category. By default, it will be added at the end of the parent category.")
    parent_category_id: Optional[StrictStr] = Field(default=None, description="The ID of the category where the category will be moved. By default, it will be created at the first level.")
    hidden: Optional[StrictBool] = Field(default=None, description="Visibility status of the category. **true** - Category will be hidden; **false** - Category will be shown")
    icon: Optional[StrictStr] = Field(default=None, description="The icon of the category. Specify the Unicode icon. Example: 📜 (Windows 10 - Win key + . or Mac ⌃-⌘-Space Bar to open emoji menu)")
    language: Optional[StrictStr] = Field(default=None, description="Language code of the category. If language is not specified, the category would be updated in the default language.")
    __properties: ClassVar[List[str]] = ["name", "order", "parent_category_id", "hidden", "icon", "language"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateCategoryRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if parent_category_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_category_id is None and "parent_category_id" in self.model_fields_set:
            _dict['parent_category_id'] = None

        # set to None if icon (nullable) is None
        # and model_fields_set contains the field
        if self.icon is None and "icon" in self.model_fields_set:
            _dict['icon'] = None

        # set to None if language (nullable) is None
        # and model_fields_set contains the field
        if self.language is None and "language" in self.model_fields_set:
            _dict['language'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateCategoryRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "order": obj.get("order"),
            "parent_category_id": obj.get("parent_category_id"),
            "hidden": obj.get("hidden"),
            "icon": obj.get("icon"),
            "language": obj.get("language")
        })
        return _obj


