# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, Optional
from d361api.models.data_source_type import DataSourceType
from typing import Optional, Set
from typing_extensions import Self

class VectorSearchReferenceArticles(BaseModel):
    """
    VectorSearchReferenceArticles
    """ # noqa: E501
    id: Optional[StrictStr] = None
    citation_id: Optional[StrictStr] = None
    category_id: Optional[StrictStr] = None
    category_title: Optional[StrictStr] = None
    category_slug: Optional[StrictStr] = None
    version_name: Optional[StrictStr] = None
    version_slug: Optional[StrictStr] = None
    article_id: Optional[StrictStr] = None
    article_title: Optional[StrictStr] = None
    article_slug: Optional[StrictStr] = None
    version_display_name: Optional[StrictStr] = None
    language_code: Optional[StrictStr] = None
    data_source_type: Optional[DataSourceType] = None
    external_source_link: Optional[StrictStr] = None
    external_source_name: Optional[StrictStr] = None
    external_source_id: Optional[StrictStr] = None
    is_attachment: Optional[StrictBool] = None
    attachment_url: Optional[StrictStr] = None
    attachment_title: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "citation_id", "category_id", "category_title", "category_slug", "version_name", "version_slug", "article_id", "article_title", "article_slug", "version_display_name", "language_code", "data_source_type", "external_source_link", "external_source_name", "external_source_id", "is_attachment", "attachment_url", "attachment_title"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VectorSearchReferenceArticles from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if citation_id (nullable) is None
        # and model_fields_set contains the field
        if self.citation_id is None and "citation_id" in self.model_fields_set:
            _dict['citation_id'] = None

        # set to None if category_id (nullable) is None
        # and model_fields_set contains the field
        if self.category_id is None and "category_id" in self.model_fields_set:
            _dict['category_id'] = None

        # set to None if category_title (nullable) is None
        # and model_fields_set contains the field
        if self.category_title is None and "category_title" in self.model_fields_set:
            _dict['category_title'] = None

        # set to None if category_slug (nullable) is None
        # and model_fields_set contains the field
        if self.category_slug is None and "category_slug" in self.model_fields_set:
            _dict['category_slug'] = None

        # set to None if version_name (nullable) is None
        # and model_fields_set contains the field
        if self.version_name is None and "version_name" in self.model_fields_set:
            _dict['version_name'] = None

        # set to None if version_slug (nullable) is None
        # and model_fields_set contains the field
        if self.version_slug is None and "version_slug" in self.model_fields_set:
            _dict['version_slug'] = None

        # set to None if article_id (nullable) is None
        # and model_fields_set contains the field
        if self.article_id is None and "article_id" in self.model_fields_set:
            _dict['article_id'] = None

        # set to None if article_title (nullable) is None
        # and model_fields_set contains the field
        if self.article_title is None and "article_title" in self.model_fields_set:
            _dict['article_title'] = None

        # set to None if article_slug (nullable) is None
        # and model_fields_set contains the field
        if self.article_slug is None and "article_slug" in self.model_fields_set:
            _dict['article_slug'] = None

        # set to None if version_display_name (nullable) is None
        # and model_fields_set contains the field
        if self.version_display_name is None and "version_display_name" in self.model_fields_set:
            _dict['version_display_name'] = None

        # set to None if language_code (nullable) is None
        # and model_fields_set contains the field
        if self.language_code is None and "language_code" in self.model_fields_set:
            _dict['language_code'] = None

        # set to None if external_source_link (nullable) is None
        # and model_fields_set contains the field
        if self.external_source_link is None and "external_source_link" in self.model_fields_set:
            _dict['external_source_link'] = None

        # set to None if external_source_name (nullable) is None
        # and model_fields_set contains the field
        if self.external_source_name is None and "external_source_name" in self.model_fields_set:
            _dict['external_source_name'] = None

        # set to None if external_source_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_source_id is None and "external_source_id" in self.model_fields_set:
            _dict['external_source_id'] = None

        # set to None if attachment_url (nullable) is None
        # and model_fields_set contains the field
        if self.attachment_url is None and "attachment_url" in self.model_fields_set:
            _dict['attachment_url'] = None

        # set to None if attachment_title (nullable) is None
        # and model_fields_set contains the field
        if self.attachment_title is None and "attachment_title" in self.model_fields_set:
            _dict['attachment_title'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VectorSearchReferenceArticles from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "citation_id": obj.get("citation_id"),
            "category_id": obj.get("category_id"),
            "category_title": obj.get("category_title"),
            "category_slug": obj.get("category_slug"),
            "version_name": obj.get("version_name"),
            "version_slug": obj.get("version_slug"),
            "article_id": obj.get("article_id"),
            "article_title": obj.get("article_title"),
            "article_slug": obj.get("article_slug"),
            "version_display_name": obj.get("version_display_name"),
            "language_code": obj.get("language_code"),
            "data_source_type": obj.get("data_source_type"),
            "external_source_link": obj.get("external_source_link"),
            "external_source_name": obj.get("external_source_name"),
            "external_source_id": obj.get("external_source_id"),
            "is_attachment": obj.get("is_attachment"),
            "attachment_url": obj.get("attachment_url"),
            "attachment_title": obj.get("attachment_title")
        })
        return _obj


