"""
Compatibility module for ImportDocumemtationLogMessageType.

This module provides a compatibility import for the model that is actually located
in d361api.d361api.import_documemtation_log_message_type.
"""

try:
    from d361api.d361api.import_documemtation_log_message_type import ImportDocumemtationLogMessageType
    __all__ = ['ImportDocumemtationLogMessageType']
except ImportError:
    # If direct import fails, try to get it from main d361api module
    try:
        import d361api
        ImportDocumemtationLogMessageType = getattr(d361api, 'ImportDocumemtationLogMessageType', None)
        if ImportDocumemtationLogMessageType is None:
            raise ImportError(f"Could not find ImportDocumemtationLogMessageType in d361api module")
        __all__ = ['ImportDocumemtationLogMessageType']
    except (ImportError, AttributeError) as e:
        import warnings
        warnings.warn(f"Failed to import ImportDocumemtationLogMessageType: {e}", ImportWarning)
        __all__ = []
