# Combined Documentation

## Table of Contents

- [What is Document360?](#document360-getting-started)
- [Sign up to Document360](#sign-up-to-document-360)
- [System and browser requirements](#system-and-browser-requirements)
- [Project dashboard](#document360-my-projects)
- [Top-right menu overview](#top-right-menu-overview)
- [Creating a project in Document360](#creating-a-project)
- [Dashboard](#dashboard)
- [Multilingual Knowledge bases](#getting-started-with-multi-lingual-knowledge-base)
- [Creating a sandbox project](#creating-a-sandbox-project)
- [Document360 security and infrastructure](#quick-summary-of-the-security-and-infrastructure-aspects)
- [X-Frame options](#x-frame-options)
- [Content security policy](#content-security-policy)
- [CSP and Whitelisting guidelines for Document360 widget](#csp-guidelines-for-document360-widget)
- [Bot management](#bot-management)
- [Fair usage policy for bot management](#fair-usage-policy-for-bot-management)
- [Editor choices in Document360](#using-the-text-editor)
- [Elements of the editor](#elements-of-the-editor)
- [Markdown editor](#markdown-editor-overview)
- [Basic Markdown syntax](#markdown-basics)
- [WYSIWYG editor](#wysiwyg-editor)
- [Advanced WYSIWYG editor](#advanced-wysiwyg-editor)
- [Advanced WYSIWYG editor basics](#advanced-wysiwyg-editor-basics)
- [Movable blocks in Advanced WYSIWYG editor](#movable-blocks-in-advanced-wysiwyg-editor)
- [Conditional content blocks in Advanced WYSIWYG editor](#conditional-content-blocks)
- [Tables in Advanced WYSIWYG editor](#tables-in-advanced-wysiwyg-editor)
- [Image formatting in the Advanced WYSIWYG editor](#image-formatting-in-the-advanced-wysiwyg-editor)
- [Tabs in the Advanced WYSIWYG editor](#tabs-in-the-advanced-wysiwyg-editor)
- [Categories and subcategories](#categories-and-subcategories)
- [Managing categories](#managing-categories)
- [Category types](#category-types)
- [Mapping a category with a folder in Drive](#assigning-drive-folder-for-a-category)
- [Downloading category and article in KB site](#downloading-category-and-article-in-kb-site)
- [Managing articles](#managing-articles)
- [Word .docx files](#article-import-from-word-files)
- [Publishing an article](#publishing-an-article)
- [Reviewing an article using Inline comments](#reviewing-an-article-inline-comments)
- [Adding images to articles](#adding-images-to-articles)
- [Adding videos in articles](#adding-videos-in-articles)
- [Adding files to article](#adding-files-to-articles)
- [Adding hyperlinks](#linking-to-other-articles)
- [Code blocks](#code-blocks)
- [Adding private notes](#private-notes)
- [Embedding Stream videos in articles](#embedding-microsoft-streams-video-in-articles)
- [Embedding Google forms in articles](#embedding-google-forms-in-article)
- [Embedding a Draw.io diagram](#embedding-a-drawio-diagram)
- [All articles - Overview page](#all-articles-overview-page)
- [Using filters in All articles page](#filter-bulk-operations)
- [Export All articles list](#export-bulk-operations)
- [Article review reminder](#review-reminders)
- [Article SEO](#article-seo)
- [Excluding articles from search engines](#excluding-articles-from-searches)
- [Change the URL of an article](#changing-the-url-of-an-article)
- [Article tags](#article-tags)
- [Add article labels](#adding-article-labels)
- [Related articles](#related-articles)
- [Featured image](#featured-image)
- [Attachments](#attachments)
- [Status indicator](#status-indicator)
- [Article status](#article-status)
- [Preferences](#preferences)
- [Show/hide table of contents for an article](#showhide-table-of-contents-for-an-article)
- [Mark as deprecated](#marking-articles-as-deprecated)
- [Update article contributors](#updating-article-contributors)
- [Schedule publishing](#schedule-publishing)
- [Discussion feed](#article-discussion-feed)
- [Revision history](#revision-history)
- [Article analytics](#article-analytics)
- [Security - Article access control](#article-access-control-knowledge-base-site)
- [Health check metrics](#health-check-metrics)
- [Readability score](#readability-score)
- [Sitemap](#sitemap-generator)
- [Public article comments](#public-comments)
- [Robots.txt](#robotstxt)
- [Read receipt](#read-receipt)
- [Share articles via private link](#share-articles-via-private-link)
- [Eddy AI customization](#ai-customization)
- [AI machine translation](#ai-machine-translation)
- [Eddy AI trust page](#eddy-ai-trust-page)
- [AI writer suite](#ai-writer-suite)
- [AI writer](#ai-writer)
- [AI FAQ generator](#ai-faq-generator)
- [AI title recommender](#ai-title-recommender)
- [AI SEO description generator](#seo-description-generator)
- [AI tag recommender](#ai-tag-recommender)
- [AI related articles recommender](#ai-related-articles-recommender)
- [AI Chart generator](#ai-chart-generator)
- [AI alt text generator](#ai-alt-text-generator)
- [AI search suite](#ai-search-suite)
- [AI assistive search (Ask Eddy AI)](#ai-assistive-search-ask-eddy)
- [AI dynamic related articles recommendation](#ai-dynamic-related-articles-recommendation)
- [AI Chatbot](#ai-chatbot)
- [Securing Chatbot authentication using JWT](#securing-chatbot-authentication-using-jwt)
- [Styling the Chatbot](#styling-the-chatbot)
- [Adding external sources for AI Assistive search](#eddy-ai-federated-search)
- [AI article summarizer](#ai-article-summarizer)
- [Ask Eddy AI API](#ask-eddy-ai-api)
- [Enhancing accessibility with our read out loud feature](#text-to-voice-functionality)
- [AI premium suite](#ai-premium-suite)
- [AI glossary generator](#ai-glossary-generator)
- [How to write GenAI friendly content](#how-to-write-genai-friendly-content)
- [Prompt engineering tips](#prompt-engineering-tips)
- [File management](#drive)
- [Adding folders and files](#adding-folders-and-files)
- [Folder actions in Drive](#folder-actions-in-drive)
- [File actions in Drive](#file-actions-in-drive)
- [All files overview](#all-content-overview)
- [Recent, Starred, and Recycle bin files](#recycle-bin-recent-and-starred-files)
- [Workflow designer](#workflow-designer)
- [Managing workflow status](#managing-workflow-status)
- [Workflow assignment](#workflow-assignment)
- [Templates](#article-templates)
- [Variables](#variables)
- [Snippet](#snippets)
- [Glossary](#glossary)
- [Adding glossary terms](#adding-glossary-term)
- [Inserting glossary term in an article](#adding-glossary-term-in-articles)
- [Managing glossary terms](#editing-and-deleting-glossary-term)
- [Managing the glossary landing page](#glossary-overview-page)
- [Feedback manager](#feedback-manager-overview)
- [Custom pages](#custom-pages)
- [Tags](#tags)
- [Manage tags page overview](#tag-manager-overview-page)
- [Adding a new tag](#adding-a-new-tag)
- [Tag groups page overview](#tag-groups-overview)
- [Manage tag dependencies](#tag-dependency-viewer)
- [Find and replace](#find-and-replace)
- [SEO descriptions](#seo-descriptions)
- [Exporting your Document360 project as a ZIP file](#export-documentation-as-zip)
- [Importing a Document360 project ZIP file](#import-a-documentation-project)
- [Migrating documentation from other platforms](#migrating-documentation-from-another-knowledge-base-platform)
- [Designing a PDF template](#pdf-design-templates)
- [Compiling content for PDF](#compliling-content-for-pdf)
- [Analytics](#analytics)
- [Articles analytics](#articles-analytics)
- [Eddy AI search analytics](#eddy-ai-search-analytics)
- [Search analytics](#analytics-search)
- [Reader analytics](#reader-analytics)
- [Team accounts analytics](#analytics-team-accounts)
- [Feedback analytics](#feedback)
- [Links status analytics](#links-status)
- [Ticket deflector analytics](#ticket-deflector-overview)
- [Managing API documentation](#manage-api-documentation)
- [Edit, Clone, and Delete widget](#edit-clone-and-delete)
- [Managing and customizing the Knowledge base widget](#managing-and-customizing-the-knowledge-base-widget)
- [URL Mapping](#url-mapping)
- [Customizing the Knowledge base widget using Custom CSS/JavaScript](#customizing-the-kb-widget-using-custom-css-javascript)
- [FAQ - Knowledge base widget](#faq-knowledge-base-widget)
- [Knowledge base site 2.0](#knowledge-base-site-20)
- [Customize site](#customize-site)
- [KB site 2.0 migration](#kb-site-20-migration)
- [Web Content Accessibility Guidelines (WCAG)](#web-content-accessibility-guidelines-wcag)
- [Header - Primary navigation](#header-primary-navigation)
- [Header - Secondary navigation](#header-secondary-navigation)
- [Footer](#footer-navigation)
- [Custom footer](#custom-footer)
- [RSS Feeds](#rss-feeds)
- [Main pages](#main-pages)
- [Hero section](#hero-section)
- [Rich text blocks](#text-block)
- [Multicolumn card section](#text-columns-block)
- [Image with text block](#image-and-text)
- [Custom code section](#html-block)
- [Knowledge base categories block](#knowledge-base-categories)
- [Widgets block](#widgets)
- [Error pages](#error-pages)
- [404 page](#404-page)
- [Access denied page](#access-denied-page)
- [Unauthorized page](#unauthorized-page)
- [IP restriction page](#ip-restriction-page)
- [Custom CSS & JavaScript](#custom-css-javascript)
- [CSS Snippets](#css-snippets)
- [Callout styles](#callout-styles)
- [Body font style](#body-font-style)
- [Image alignment](#image-alignment)
- [Header font style](#header-font-style)
- [Table style](#table-style)
- [Article redirect rule](#article-redirect-rules)
- [Article settings & SEO](#configuring-the-article-settings)
- [Article header](#article-header)
- [Site header-What's new](#document-header)
- [Follow articles and categories](#follow-articles-and-categories)
- [Search in Knowledge base site](#search-in-knowledge-base-site)
- [Liking or disliking an article](#liking-or-disliking-an-article)
- [Smart bars](#smart-bar)
- [Cookie consent](#cookie-consent)
- [Accessing the ticket deflectors in portal](#accessing-the-ticket-deflectors)
- [Adding a new ticket deflector](#adding-a-new-ticket-deflector)
- [Integrations in Document360](#integrations-getting-started)
- [Code inclusion and exclusion conditions](#advanced-insertion-rules-in-integration)
- [LiveChat](#livechat)
- [Olark](#olark)
- [Freshchat](#freshchat)
- [Crisp](#crisp)
- [Chatra](#chatra)
- [Doorbell](#door-bell)
- [Gorgias](#gorgias)
- [Belco](#belco)
- [Sunshine Conversations](#sunshine)
- [Kommunicate](#kommunicate)
- [Google Analytics](#google-analytics-integration)
- [Google Analytics (GA4)](#google-analytics-new)
- [Google Tag Manager](#google-tag-manager)
- [Heap](#heap)
- [Segment](#segment-integration)
- [Hotjar](#hotjar)
- [Amplitude](#amplitude)
- [FullStory](#fullstory)
- [Mixpanel](#mixpanel)
- [VWO](#vwo)
- [Freshmarketer](#freshmarketer)
- [ZOHO PageSense](#zoho-page-sense)
- [GoSquared](#gosquared)
- [Commento](#commento)
- [Disqus](#disqus)
- [Document360 Extensions - Getting started](#all-extensions)
- [Freshdesk](#freshdesk)
- [Freshservice](#freshservice)
- [Zendesk](#zendesk)
- [Intercom](#intercom-integration)
- [Salesforce](#salesforce)
- [Cases page](#cases-page)
- [Slack](#slack)
- [Microsoft Teams](#microsoft-teams)
- [Drift](#drift)
- [Zapier - Setup guide](#zapier-setup-guide)
- [Integrating Google Docs with Document360](#google-docs-document360-integration)
- [Integrating Google Sheets with Document360](#document360-with-google-sheets-integration)
- [Integrating Document360 with Google Drive](#google-drive-document360)
- [Integrating Trello with Document360](#document360-with-trello-integration)
- [Integrating GitHub with Document360](#github-document360)
- [Integrating Confluence Server with Document360](#confluence-document360)
- [Integrating Zoho CRM with Document360](#zoho-crm-document360)
- [Integrating Pipedrive with Document360](#pipedrive-document360)
- [Integrating Hubspot with Document360](#hubspot-document360)
- [Integrating Asana with Document360](#asana-document360)
- [Integrating Monday.com with Document360](#mondaycom-document360)
- [Integrating Typeform with Document360](#typeform-document360)
- [Integrating Gmail with Document360](#document360-gmail)
- [Integrating Mailchimp with Document360](#document360-mailchimp)
- [Make - Setup guide](#make-setup-guide)
- [Integrating Asana with Document360](#asana-and-document360-integration)
- [Integrating Monday.com with Document360](#monday-document360-integration)
- [Integrating Typeform with Document360](#typeform-and-document360-integration)
- [Integrating Google Docs with Document360](#google-docs-and-document360-integration)
- [Integrating Jira with Document360](#jira-and-document360-integration)
- [Chrome](#chrome-extension)
- [Crowdin](#crowdin)
- [Phrase](#phrase)
- [General project settings](#general-project-settings)
- [Team auditing](#team-auditing)
- [Localization - Getting started](#localization-getting-started)
- [Setting up a Multi-lingual knowledge base](#setting-up-a-multi-lingual-knowledge-base)
- [Localization variables](#localization-variables)
- [Workspaces](#workspaces)
- [Backup and restore](#backup-restore)
- [Notifications](#notifications)
- [Webhook notification channel](#webhook-notification-channel)
- [Slack notification channel](#slack-notification-channel)
- [Microsoft Teams notification channel](#microsoft-teams-notification-channel)
- [SMTP notification channel](#smtp-email-notification-channel)
- [Notification mapping](#notification-mapping)
- [Notification history](#notification-history)
- [Email domain](#send-notifications-from-custom-email-domain)
- [How to use Postman?](#how-to-use-postman)
- [How to use Swagger?](#how-to-use-swagger)
- [Portal search](#full-portal-search)
- [Article-portal search](#article-full-portal-search)
- [Drive-portal search](#drive-full-portal-search)
- [Users & groups-portal search](#users-groups-full-portal-search)
- [Tags-portal search](#tags-full-portal-search)
- [Settings-portal search](#settings-full-portal-search)
- [Custom domain mapping](#custom-domain-mapping)
- [Hosting Document360 on a sub-directory](#document360-on-a-sub-folder)
- [Nginx server - Subfolder hosting](#nginx-server)
- [ASP.NET Core server](#aspnet-core-server)
- [Microsoft - IIS server](#microsoft-iis-server)
- [Apache HTTP server](#apache-http-server)
- [Readers self registration](#reader-self-registration)
- [Managing reviewer accounts](#managing-reviewer-accounts)
- [Account locked](#account-locked)
- [Block inheritance](#block-inheritance)
- [IP restriction](#ip-restriction)
- [Single Sign-On (SSO)](#single-sign-on-sso)
- [Login using SSO - Knowledge base portal](#login-using-sso-knowledge-base-portal)
- [Login using SSO - Knowledge base site](#login-using-sso-knowledge-base-site)
- [Inviting or Adding SSO users](#inviting-or-adding-sso-users)
- [Mapping an existing SSO configuration to other projects](#mapping-an-existing-sso-configuration-to-other-projects)
- [Disable Document360 login page](#disable-document360-login-page)
- [Auto assign reader group](#auto-assign-reader-group)
- [Convert to SSO account](#convert-to-sso-account)
- [Sign out idle SSO team account](#team-account-idle-timeout)
- [SAML](#saml)
- [SAML SSO with Okta](#saml-sso-with-okta)
- [SAML SSO with Entra](#saml-sso-with-entra)
- [SAML SSO with Google](#google-sso-saml-configuration)
- [SAML SSO with OneLogin](#saml-sso-with-onelogin)
- [SAML SSO with ADFS](#saml-sso-with-adfs)
- [SAML SSO with other configurations](#saml-sso-with-other-configurations)
- [Identity Provider (IdP) initiated sign in](#idp-initiated-login)
- [Removing a configured SAML SSO](#removing-a-configured-saml-sso)
- [OpenID](#openid)
- [Okta with OpenID SSO](#okta-with-openid-sso)
- [Auth0 with OpenID SSO](#auth0-with-openid-sso)
- [ADFS with OpenID SSO](#adfs-with-openid-sso)
- [Other configurations with OpenID SSO](#other-configurations-with-openid-sso)
- [Removing a configured OpenID SSO](#removing-a-configured-openid-sso)
- [Setting up JWT SSO](#configuring-the-jwt-sso)
- [JWT reader groups](#jwt-reader-groups)
- [How to enlarge the pdf preview in the article?](#how-to-enlarge-the-pdf-preview-in-the-article)
- [How to change the color of the hyperlinks in Dark mode?](#how-to-change-the-color-of-the-hyperlinks-in-dark-mode)
- [How to change the highlighted search result color in articles?](#how-to-change-the-highlighted-search-result-color-in-articles)
- [How to hide the project's workspace dropdown in the Knowledge base site?](#how-to-hide-the-project-versions-dropdown-in-the-knowledge-base-site)
- [How to add a vertical scrollbar to the code blocks?](#how-to-add-a-vertical-scrollbar-to-the-code-blocks)
- [How to set the default height and width of the embedded PDF?](#how-to-set-the-default-height-and-width-of-the-embedded-pdf)
- [How to make the table border bold in knowledge base?](#how-to-make-the-table-border-bold-in-knowledge-base)
- [How to vertically align table contents at the top in the Knowledge base?](#how-to-vertically-align-table-contents-at-the-top-in-the-knowledge-base)
- [How to restrict the readers from copying the content?](#how-to-restrict-the-readers-from-copying-the-content)
- [How to keep dark mode for the Knowledge base site by default?](#how-to-keep-dark-mode-for-the-knowledge-base-site-by-default)
- [How to center align the text in Markdown?](#how-to-center-align-the-text-in-markdown)
- [How to change the color of the text in Markdown?](#how-to-change-the-color-of-the-text-in-markdown)
- [How to change the language name text in code blocks?](#how-to-change-the-language-name-text-in-code-blocks)
- [How to change the callouts color in dark mode?](#how-to-change-the-callouts-color-in-dark-mode)
- [How to center align the heading in the articles?](#how-to-center-align-the-heading-in-the-articles)
- [How to change the color of the table header?](#how-to-change-the-color-of-the-table-header)
- [How to add accordion in Markdown?](#how-to-add-accordion-in-markdown)
- [How to add extra space in Markdown?](#how-to-add-extra-space-in-markdown)
- [How to align the image in Markdown?](#how-to-align-the-image-in-markdown)
- [How to add a background image for a text content?](#how-to-add-a-background-image-for-a-text-content)
- [How to change the color of the table of contents?](#how-to-change-the-color-of-the-table-of-contents)
- [How to sort the contents of a table?](#how-to-sort-the-contents-of-a-table)
- [How to customize the hyperlink size?](#how-to-customize-the-hyperlink)
- [How to make all links open in new tab?](#how-to-make-all-links-open-in-new-tab)
- [How to set a default featured image in knowledge base?](#how-to-set-a-default-featured-image-in-knowledge-base)
- [How to add shadows to an image in Markdown?](#how-to-add-shadows-to-an-image-in-markdown)
- [How to add borders to an image in Markdown?](#how-to-add-borders-to-an-image-in-markdown)
- [How to embed YouTube Shorts?](#embed-youtube-shorts)
- [How to embed a Loom video?](#how-to-embed-loom-video)
- [How to embed an Excel file?](#how-to-embed-an-excel-file)
- [How to change the color of Feedback buttons?](#how-to-change-the-color-of-feedback-buttons)
- [How to hide footer in mobile view?](#how-to-hide-footer-in-mobile-view)
- [How to change the hover color of the header options?](#how-to-change-the-hover-color-of-the-header-options)
- [How to move the related articles above the feedback section?](#how-to-move-the-related-articles-above-the-feedback-section)
- [How to hide the change password option for readers?](#how-to-hide-the-change-password-option-for-readers)
- [How to hide the category manager?](#how-to-hide-the-category-manager)
- [How to configure a custom font in the knowledge base?](#how-to-configure-a-custom-font-in-the-knowledge-base)
- [How to hide the left navigation bar in the knowledge base site?](#how-to-hide-the-left-navigation-bar-in-knowledge-base-site)
- [Plans and pricing](#plans-and-pricing)
- [Upgrading your subscription plan](#upgrading-your-plan)
- [Downgrading your subscription plan](#downgrading-your-plan)
- [Purchasing add-ons](#add-ons)
- [Upgrading from trial version](#upgrading-from-trial-version)
- [Changing payment information](#changing-payment-information)
- [February 2025 - 11.1.2](#february-2025-1112)
- [January 2025 - 11.01.1](#january-2025-1111)
- [December 2024 - 10.12.1](#december-2024-10121)
- [November 2024 - 10.11.1](#november-2024-10111)
- [October 2024 - 10.10.1](#october-2024-10101)
- [September 2024 - 10.9.1](#september-2024-1091)
- [September 2024 - 10.8.2](#september-2024-1082)
- [August 2024 - 10.8.1](#august-2024-1081)
- [July 2024 - 10.7.1](#july-2024-1071)
- [July 2024 - 10.6.2](#july-2024-1062)
- [June 2024 - 10.6.1](#june-2024-1061)
- [June 2024 - 10.5.2](#june-2024-1052)
- [May 2024 - 10.5.1](#may-2024-1051)
- [May 2024 - 10.4.2](#may-2024-1042)
- [April 2024 - 10.4.1](#1041-release-note)
- [April 2024 - Minor release](#april-2024-minor-release)
- [March 2024](#march-2024)
- [February 2024](#february-2024)
- [January 2024](#january-2024)
- [December 2023](#december-2023)
- [November 2023](#november-2023)
- [August 2023](#august-3)
- [July 2023](#july-2)
- [June 2023](#june-3)
- [May 2023](#may-1)
- [April 2023](#april-3)
- [March 2023](#march-4)
- [February 2023](#february-3)
- [January 2023](#january-2)
- [December 2022](#december-2022-release-note)
- [November 2022](#november-2022-release-note)
- [October 2022](#october-2022-release-note)
- [September 2022](#september-2022-release-note)
- [August 2022](#august-2022-release-note)
- [July 2022](#july-2022-release-note)
- [June 2022](#june-2022-release-notes)
- [May 2022](#may-2022-release-note)
- [April 2022](#april-2022-release-note)
- [March 2022](#march-2022-release-note)
- [February 2022](#february-2022-release-note)
- [January 2022](#january-2022-release-note)
- [December 2021](#december-2021-release-note)
- [November 2021](#november-2021-release-note)
- [October 2021](#october-2021-release-note)
- [September 2021](#september-2021-release-note)
- [August 2021](#august-2021-release-notes)
- [July 2021](#july-2021-release-note)
- [June 2021](#june-2021-release-note)
- [May 2021](#may-2021-release-note)
- [April 2021](#april-2021-release-note)
- [March 2021](#march-2021-release-note)
- [February 2021](#february-2021-release-note)
- [January 2021](#january-2021-release-note)
- [November 2020](#november-2020-release-note)
- [October 2020](#october-2020-release-note)
- [August 2020](#august-2020-release-note)
- [June 2020](#june-2020-release-note)
- [May 2020](#may-2020-release-note)
- [April 2020](#april-2020-release-note)
- [March 2020](#march-2020-release-note)
- [February 2020](#february-2020-release-note)
- [January 2020](#january-2020)
- [December 2019](#december)
- [November 2019](#november)
- [October 2019](#october)
- [September 2019](#september-2019)
- [August 2019](#august)
- [July 2019](#july)
- [June 2019](#june)
- [May 2019](#may-2019)
- [April 2019](#april-2019)
- [March 2019](#march)
- [February 2019](#february)
- [January 2019](#january-2019)
- [Support ticket](#support-ticket)
- [Generating a HAR file](#document360-support-generating-a-har-file)

---

<a id="document360-getting-started"></a>

## What is Document360?

Here is an overview and a navigation guide to help you get started with your Document360 experience.

### What is Document360?

**Document360** is a Knowledge management platform that allows you to create and curate a self-service public, private, or mixed access Knowledge base.

When using Document360, you'll interact with several key interfaces:

* #### [My Projects](/help/docs/document360-getting-started#my-projects)
* #### [Knowledge base portal](/help/docs/document360-getting-started#knowledge-base-portal)
* #### [Knowledge base site](/help/docs/document360-getting-started#knowledge-base-site)
* #### [Document360 AI - Eddy AI](/help/docs/ai-features)
* #### [Resources](/help/docs/document360-getting-started#other-resources)

---

## My projects

The **project dashboard** is the first thing you see when logging in to [**Document360**](https://portal.document360.io). The dashboard features all the projects you own, projects associated with a team account, and projects associated with a reader.  
Here, each project will have a visibility tag to indicate the type of project (public, private, or mixed).

![1_Screenshot-My_projects](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-My_projects.png "My-Projects.png")

---

## Knowledge base portal

The **Knowledge base portal** is where you can:

* **Create** Category, Articles, and Templates
* **Manage** files, team accounts, and readers
* **Set up** branding, domain, security, and more for the Knowledge base site

  ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenShot-What_is_Document360.png)

Here are some elements you'll find on the knowledge base portal:

1. Dashboard
2. Documentation
3. API Documentation
4. Analytics
5. Widgets
6. Drive
7. Settings
8. Search
9. Open Site

> NOTE
>
> Anything created and/or configured on the Knowledge base portal will affect what an end-user or reader would see on the Knowledge base site.

### 1. Dashboard

This page provides an overview of your entire project and serves as a hub for contributors. In the **Overview** section, Team accounts can access information such as created articles, published articles, drafts, and the performance insights of published articles (views, reads, likes, and dislikes). You can use the filter option to select the time frame. You can also view other project-related information including **Recently seen**, **Team accounts**, **Readers**, **Drive capacity**, **Broken links**, **No result searches** and **Last backed up** date.

![3_Screenshot-Knowledge_base_portal_dashboard_overview](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Knowledge_base_portal_dashboard_overview.png)

In the **My contribution** section, the user can view their contributions to the project, article performance metrics, workflow assignments, review reminders, feedback, and broken links.

![Document360 dashboard showing article metrics summary with number of articles created, published or drafted, and an area to display assigned tasks.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Knowledge_base_portal_dashboard_my_contribution.png)

---

### 2. Documentation

The **Documentation** page is where you'll create and maintain the tree-view folder structure of categories that will keep your articles organized. Start a knowledge base by creating a Category and then populate them with Subcategory and Articles.

Drag and drop categories and articles to reorder, hide, rename, and delete them using the More options () menu that appears when you hover your mouse over any item on the Category manager (left navigation pane).

![ocument360 user interface showing navigation menus for managing articles, workflow assignments, starred items, recycle bin, site builder, content tools, and categories/articles hierarchy.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_Screenshot-Knowledge_base_portal_documentation_view.png)

#### a. All articles

The **All articles** section allows you to perform bulk operations (publish, hide, move, delete, etc.) on multiple articles at once, saving time compared to performing these actions individually on each article.

![Document360's 'All articles' interface showing a list of articles with editing options like publish, hide, move, delete, review reminder, and live status, as well as features for reusing content through templates, variables, snippets, and a glossary.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/6_Screenshot-Knowledge_base_portal_documentation_view_all_articles.png)

#### b. Workflow assignments

The Workflow assignments section gives you an idea about what the team is currently working on, and any recently published articles.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/7_Screenshot-Knowledge_base_portal_documentation_view_workflow_assignments.png)

Any articles that you are assigned will show up on this page. You can filter articles based on the following workflow statuses: **Draft**, **In review**, or **Published**. If you missed the review due date for any article, it will appear under the **Overdue** category.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/7.1_Screenshot-Knowledge_base_portal_workflow_assignments_page.png)

#### c. Starred

The Starred section contains the articles you marked as favorites. This allows quick access to important articles.

![Document360's 'Starred' interface showing a list of articles with the respective tags and article status, along with an arrow pointing at 'Starred' on the left navigation panel](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/8_Screenshot-Knowledge_base_portal_documentation_view_starred.png)

#### d. Recycle bin

The Recycle bin section includes a list of articles and categories deleted in the past 30 days. You can restore the deleted categories and articles in the available time frame.

![Document360's 'Recycle bin' interface showing an empty recycle bin, along with an arrow pointing at 'Recycle bin' on the left navigation panel](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/9_Screenshot-Knowledge_base_portal_documentation_view_recycle_bin.png)

#### e. Site builder

You can personalize the look and feel of your knowledge base site from the **Site builder** section.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/10_Screenshot-Knowledge_base_portal_documentation_view_site_builder.png)

You can choose the desired logo and icon for your knowledge base site. From this section, you can also customize the brand colors, font, and styling of the site.

#### f. Content tools

The **Content tools**, as the name implies, contain all the necessary tools to manage your article and project content.

![5_Screenshot-Knowledge_base_portal_Content_tools](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/11_Screenshot-Knowledge_base_portal_documentation_view_content_tools.png)

You can manage the following features from this menu.

* **Content reuse** - Manage all the variables, snippets, templates, and the glossary.
* **Import and Export** - Manage all your project import and export activities from this section. In this section, you can export your content as a PDF or migrate content from other knowledge management tools.
* **Content essentials** - Manage the project-level find and replace, review reminders, tags, and SEO descriptions from the menu.
* **Feedback manager** - View and respond to articles and no search feedback from a unified module.
* **Workflow designer** - Craft your workflow statuses and sequence from this section.

#### g. Categories & Articles (Category manager)

Writing and publishing articles in Document360 is simple: pick your category, create an article(title and slug), add SEO details, and publish to your knowledge base.

When you update or edit an article (Fork), Document360 will create a new Article revision without affecting the live/public workspace.

![12_Screenshot-Knowledge_base_portal_documentation_view_categories_and_articles](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/12_Screenshot-Knowledge_base_portal_documentation_view_categories_and_articles.png)

You can make the necessary changes and republish when you're ready. You can identify the articles easily using the Article status indicators (Yellow dot). Document360 maintains all the workspaces to check the differences between them.

---

### 3. API documentation

The API documentation feature in Document360 provides a complete solution for creating and managing API references. This feature allows you to create high-quality API documentation that helps users understand and consume your APIs effectively.

![13_Screenshot-Knowledge_base_portal_api_documentation](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/13_Screenshot-Knowledge_base_portal_api_documentation.png)

This API module includes the **Try it!** feature, which allows the users to test the API endpoints within the Knowledge base site. You can create dedicated versions of your API documentation. The feature provides an intuitive interface for uploading API references as URLs or JSON/YAML files. After uploading the OpenAPI definition, the interactive API endpoint articles are created in the Knowledge base portal. Now, end users can access the **Try it!** option with the available endpoints, parameters, and responses in the API documentation on the Knowledge base site.

---

### 4. Analytics

Document360 includes an **Analytics** menu with tools to help you understand end-user engagement with your knowledge base.

![12_Screenshot-Knowledge_base_portal_Analytics](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/14_Screenshot-Knowledge_base_portal_analytics.png)

Here is the list of metrics and modules you can track with the Analytics tool:

* **Articles**
* **Eddy AI**
* **Search**
* **Team accounts**
* **Feedback**
* **Links status**
* **Page not found**
* **Ticket deflector**

---

### 5. Widget

The Knowledge base widget (previously known as *Knowledge base assistant* (or) *In-app assistant*) helps readers find their answers without leaving your site or application.

![8_Screenshot-Knowledge_base_portal_Widget](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/15_Screenshot-Knowledge_base_portal_widgets.png)

You can update the following Knowledge base widget settings from this menu.

* **Installation & setup**
* **Custom CSS**
* **Custom JavaScript**
* **URL mapping**

---

### 6. Drive

Centralized and cloud-based storage for Document360 projects that stores and let team members manage all the Knowledge base artifacts (files). If you have already used any other heavyweights, such as Google Drive or OneDrive, getting accustomed to the functions in Document360 Drive should be relatively easy. You can access your Drive by clicking the Drive icon on the left menu.

![7_Screenshot-Knowledge_base_portal_Drive](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/16_Screenshot-Knowledge_base_portal_drive.png)

---

### 7. Settings

You can set and configure all aspects of the project and knowledge base in the **Project settings** such as inviting team members, editing notification settings, configuring domains, setting up article redirects, and more.

![9_Screenshot-Knowledge_base_portal_Settings](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/17_Screenshot-Knowledge_base_portal_settings.png)

The different features are mapped under the following classifications in the Settings menu:

* **Knowledge base portal**
* **Knowledge base site**
* **Users & Security**
* **AI Features**

---

### 8. Search

A dedicated space to search the entire project content is now available on the Knowledge base portal. Perform a combined search across all the workspaces and languages simultaneously. The search bar is available at the top of all the modules and pages in the Knowledge base portal.

![10_Screenshot-Knowledge_base_portal_Search](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/18_Screenshot-Knowledge_base_portal_search.png)

The search engine works similarly to the other search functionalities in the portal. Type in the keyword and narrow the results using filters such as workspace, language, visibility, tags, and date range. You can preview the article/category page, and then preview the article or navigate to the article in the Editor.

![11_Screenshot-Knowledge_base_portal_Search_results](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/19_Screenshot-Knowledge_base_portal_search_bar_dropdown.png)

As the search is performed universally in the project, it covers files. Users can switch between the article and Drive search using the tabs below the search bar.

---

### 9. Open site

The Open site () action is used to navigate to and view the Knowledge base site. Clicking the icon will take you to the Knowledge base site of the workspace that is currently open in your knowledge base portal. If you are in the API documentation workspace, the Open site action will take you to the API documentation home page. If your API documentation site does not have a home page, you will be directed to the first article or category page in the API documentation.

---

## Knowledge base site

The Knowledge base site is the website that end-users will access to read articles and find helpful answers.

Set your knowledge base access settings to public, private, or mixed. **Public** means it is accessible to anyone on the internet, **Private** is restricted by login screens, and **Mixed** combines elements of both public and private attributes.

![14_Screenshot-Knowledge_base_site_overview](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/20_Screenshot-Knowledge_base_site_preview.png)

---

## Document360 AI - Eddy AI

Eddy AI is an AI writing assistant integrated into the Document360 platform. Eddy AI can help you with many actions, such as **writing articles**, **generating SEO descriptions**, and **recommending article tags**, **titles**, and **related articles**. Eddy AI is also available on the knowledge base site, helping your readers find information faster using **assistive search** and the **article summarizer**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/24_Screenshot-Eddy_settings_aifeatures_eddy.png)

---

## Other Resources

### Got Feedback?

We actively maintain a public [**product feedback portal**](https://feedback.document360.com/) to receive customer and user feedback. It also features our roadmap, so if you're curious about what's coming to the product, this is the best place to look!

![27_Screenshot-An_overview_of_project_feedback](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/21_Screenshot-User_feedback.png)

### Quick start (Feature explorer)

The **Quick start** is a learning wizard available on all Document360 trial projects. This feature explorer helps you track your progress as you learn about the various features included in Document360. Each time you use or explore a new part of the product, the Feature Explorer automatically updates your progress. It allows you to visualize how much of the product you have explored.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenShot-What_is_Document360.png)

---

### Need Help?

If you need any help or have any questions, contact us! Just click your profile avatar to:

![21_Screenshot-My_projects_Help_module](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/23_Screenshot-Resources_need_help.png)

* Send an **in-app chat**
* Send us an **email** at [**support@document360.com**](mailto:support@document360.com)
* Read our [**documentation**](https://docs.document360.com/docs)
* Watch some [**tutorial videos**](https://document360.com/tutorial-videos/)

---

### FAQs

#### **What is Document360?**

Document360 is a Knowledge management platform that allows you to create and curate a self-service public, private, or mixed access Knowledge base.

#### **What can I do in the Knowledge base portal?**

In the Knowledge base portal, you can create categories, articles, and templates, manage files, team accounts, and readers, and set up branding, domain, and security for your Knowledge base site.

#### **What features are available in the Analytics section?**

The Analytics section includes tools to track metrics such as articles, user engagement, search performance, team accounts, feedback, and link status.

#### **Can I restore deleted articles in Document360?**

Yes, you can restore articles and categories that have been deleted within the past 30 days from the Recycle bin section.

#### **Is there an AI feature in Document360?**

Yes, Document360 includes Eddy AI, an AI writing assistant that helps with writing articles, generating SEO descriptions, and assisting readers in finding information.

#### **What is a knowledge base?**

A knowledge base is a centralized repository of information designed to provide answers, guidance, and support for users, customers, or employees. It contains structured content like articles, FAQs, guides, and documentation, allowing users to easily search and access information to solve problems or learn more about a product, service, or topic. Knowledge bases are commonly used in customer support, internal training, and product documentation to streamline information sharing and improve efficiency.

#### Why does it show ‘Maintenance’ on the top navigation bar in the knowledge base portal?

The **Maintenance** badge on the top navigation bar indicates scheduled maintenance of the Knowledge base portal. The knowledge base portal will be unavailable for the scheduled time however, the Knowledge base site will be accessible to all the users.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/26_ScreenShot-What_is_Document360.png)

For further assistance, please contact the Document360 support team: [Contact Document360 Support](https://document360.com/support/).

Organizes related articles under a common theme in the knowledge base.

A written document on a specific topic in your knowledge base, serving as a unit of organized information.

Pre-designed article structures in Document360 that team accounts can use to create consistent and well-organized articles for the Knowledge base.

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

The public-facing website where end-users can access articles and find answers to their questions.

Organizes related articles under a common theme in the knowledge base.

A secondary category in Document360 used to organize and display groups of related articles. Subcategories act as folders within a primary category, helping structure similar topics for better organization and navigation.

A written document on a specific topic in your knowledge base, serving as a unit of organized information.

A tool in the editor’s left pane for managing article-category relations.

The practice of optimizing content to improve its visibility in search engine results and attract organic traffic. In Document360, Search Engine Optimization (SEO) elements can be added for each article through the article settings.

An option in Document360 used to create a new version of an article, containing the content of the original version for revision.

A feature to view and manage an article’s revision history, workflow updates and compare different versions.

Custom styling code used to modify the appearance of elements on a webpage.

A tool in Document360 used by writers to draft and format content. Document360 offers three types of editors: Markdown, WYSIWYG, and Advanced WYSIWYG.

<a id="sign-up-to-document-360"></a>

## Sign up to Document360

Before you start using Document360, you need to create a Document360 account. To create a Document360 account, navigate to the [**signup page**](https://document360.com/signup/).

---

## **Signing Up to Document360**

### **Navigate to the Signup page**

1. On the signup page, you'll need to provide some basic details:

   * First Name
   * Last Name
   * Work Email
   * Job Title
   * Implementation timeline
   * Phone Number
2. After filling in these details, click the **Start Free Trial** button.

![Exploring the onboarding experience while signing up the Document360](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Initial_step_of_onboarding.png)

### **Email verification**

3. You will receive a 6-digit verification code in your email. Enter this code on the verification page to continue.
4. Click **Verify.**

> NOTE
>
> If you enter the wrong verification code five times, your account activation will be locked. In such cases, you'll need to contact the Document360 support team for help.

### **Set your account password**

5. After verifying your email, you will need to create a password for your Document360 account. Make sure your password meets the following requirements:

   * At least 8 characters long
   * Includes at least one number
   * Includes at least one special character
   * Includes both uppercase and lowercase letters
6. Once you've created a password that meets these criteria, re-enter it to confirm, and then click **Get Started**.

### **Choose your use case**

7. Select any of your following primary use case for which you’re using Document360 by clicking **Get started.**

|  |  |
| --- | --- |
| **Knowledge base platform** | You can create a centralized hub where all your team's knowledge and resources are stored. It helps your team quickly find answers and enhances customer self-service by providing them with easy access to the information they need. |
| **Software documentation/****Technical documentation** | You can efficiently organize and maintain all your software or technical documentation. It helps your team document product features, APIs, release notes, and more, making sure that developers and users have clear and up-to-date information. |
| **SOP documentation** | You can create detailed SOPs that your team can follow consistently. It ensures that everyone adheres to the same processes, reduces errors, and helps in onboarding new employees by providing them with clear procedural guidelines. |
| **User manual** | You can develop comprehensive user manuals that guide your customers or team members through your product's features and usage. It helps in reducing support queries by offering step-by-step instructions and troubleshooting tips. |
| **API Documentation** | Document detailed information about API endpoints, request and response formats, authentication methods, and examples. This ensures developers have a clear understanding of how to integrate with your APIs. |
| **Others** | Choose this option if your use case does not fall into the predefined categories. You can customize your knowledge base based on specific organizational or project needs. |

### **Select a Template**

8. Select the type of content you'll create in your Document360 project. You can pick up to two templates that suit your needs.

> NOTE
>
> Based on your selection, these templates will be embedded within your project during creation.

**Knowledge base platform templates**

If you have selected the Knowledge base platform in step 7, you can choose any two templates from the list below.

|  |  |
| --- | --- |
| **Getting started guides** | Help new users quickly understand and begin using your product with clear, step-by-step instructions. This ensures a smooth onboarding experience. |
| **How-to guides** | Provide detailed instructions for specific tasks, enabling users to fully utilize and explore your product’s features efficiently. |
| **FAQs** | Address common questions at any stage of the user journey, helping users find quick answers and reducing support queries. |
| **Policy & procedures** | Outline essential organizational protocols, helping users understand and adhere to company guidelines effectively. |

**Software/Technical documentation templates**

If you have selected Software/Technical documentation in step 7, you can choose any two templates from the list below.

|  |  |
| --- | --- |
| **Release notes** | Keep users informed about updates, new features, bug fixes, and improvements with each software release. |
| **Software Design Documentation (SDD)** | Outline software architecture and design, including diagrams and specifications for development guidance. |
| **Software Requirement Documentation** | Describe the software's purpose, functionalities, and environment to ensure development aligns with project goals. |
| **Product Requirement Documentation (PRD)** | Define the product’s purpose, value, and functionalities to meet user needs and business objectives. |
| **Process documentation** | Detailed steps and procedures involved in software development to standardize workflows and enhance efficiency. |
| **User guide** | Give comprehensive instructions on using your product, covering all features and functionalities. |

**SOP documentation templates**

If you have selected SOP documentation in step 7, you can choose any two templates from the list below.

|  |  |
| --- | --- |
| **Compliance policies and procedures** | Ensure your organization meets regulatory requirements by documenting policies that enforce compliance. |
| **Operation SOP** | Enhance efficiency and productivity by standardizing operational procedures across your organization. |

**User manual templates**

If you have selected the User manual in step 7, you can choose any two templates from the list below.

|  |  |
| --- | --- |
| **Installation manual** | Provides all necessary setup information including product overview, specifications, and assembly instructions, ensuring a smooth start with the Knowledge base platform. |
| **Instruction manual** | Offers step-by-step assembly and usage instructions with diagrams and safety warnings, ideal for precise setup and safety warnings for proper usage. |
| **Maintenance manual** | Provide detailed instructions for regular upkeep, troubleshooting, and repair procedures to ensure optimal performance. |
| **Training manual** | Provides comprehensive guidance on installation, operation, and troubleshooting, and support for user training and effective platform usage. |
| **Operations manual** | Provide detailed instructions for daily maintenance and troubleshooting, ensuring ongoing effective management of the Knowledge Base platform. |

### **Personalize your Knowledge base**

9. Enter your preferred website URL. If you want to skip this step, the domain will default to the one linked to your registration email.

### **Brand guidelines**

10. Your project name, default language, branding logo, and brand colors will be automatically set based on your provided URL. However, you can edit the fields if needed.

    Your browser’s language settings determine the default language. English will be selected by default if other languages don’t support your browser’s language.

> NOTE
>
> * If you choose Spanish or Brazilian Portuguese as your default language, the portal language will be set to Spanish or Brazilian Portuguese. Otherwise, English will be the default language.
> * The branding logo and primary/secondary colors are extracted from your website. If you choose to **Skip** this step, the project name will be derived from your registration email, and Document360’s default logo and colors will be applied.

11. You can preview your Knowledge base on the right side of the screen.

### **Set documentation privacy**

12. Choose the desired privacy settings for your site:

    * **Private**: Restrict access to the Knowledge base so that only team accounts can view and interact with the content, keeping it secure and internal.
    * **Public**: Make the Knowledge base accessible to everyone, including external users, allowing open access to all content.
    * **Mixed**: Combine private and public access by allowing some sections of the Knowledge base to be visible to the public while keeping other sections restricted to team accounts only.
13. Click **Next** to proceed.

### **Access the Document360 Knowledge base portal**

Once you complete the setup, enter the Document360 Knowledge base portal. Here, you’ll find pre-loaded articles based on the use case and templates you selected.

> NOTE
>
> The articles seeded into your project are tailored to your selected use case and templates, giving you a head start on creating your content.

![Exploring the onboarding experience while signing up the Document360](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGIF-Final_onboarding_process.gif)

---

### FAQs

**Does Document360 support different languages in the onboarding flow?**

Yes, Document360 offers multi-lingual support in the onboarding flow, including languages such as English, Spanish, Brazilian Portuguese, German, and Swedish. However, within the Document360 portal, language support is currently limited to English, Spanish, and Brazilian Portuguese.

**Do I need to pay to create a Document360 account?**

You don’t need to pay or enter your credit card details to create an account. When you sign up, you will get a 14-day trial account. After trying Document360, you can upgrade to one of the available plans to continue using it beyond the trial period.

**What are the available plans I can upgrade to?**

You can choose from 4 plans: Free, Professional, Business, and Enterprise. To learn about the pricing and features of each plan, [**click here**](https://document360.com/pricing/).

**I haven’t received the verification code. How do I continue with the signup process?**

If you haven’t received the code, click **Resend Code** on the **Email verification** page. If you still can’t find the email in your inbox, check your spam/junk folder. If you cannot locate the verification code, contact the Document360 support team for further assistance.

**I have an existing knowledge base, and I want to migrate to Document360. How should I proceed?**

Once you decide to sign up for Document360, there are two ways to migrate your existing knowledge. You can fill out the migration request form even before signing up, and our migration experts will contact you to kick-start the migration process. If you have already created a trial account, simply navigate to **Documentation** > **Content** **tools** > **Import & Export** > **Migrate content**. From there, follow the on-screen instructions to migrate your knowledge base to Document360. To learn more about migrating your existing knowledge base to Document360, click [**here**](/help/docs/migrating-documentation-from-another-knowledge-base-platform).

**My Document360 trial period ended. Can I still access my data?**

Once your Document360 trial ends, you can no longer access any content you created within Document360. To regain access to your data, you'll need to upgrade to one of our subscription plans. To learn more about selecting a subscription plan and upgrading your account, click [**here**](https://docs.document360.com/docs/billing).

**What happens if I don't complete the password setup during signup?**

If you return to the signup page and enter your details again, the system will recognize your previous session and automatically redirect you to the password creation screen.

<a id="system-and-browser-requirements"></a>

## System and browser requirements

## Recommended

Here are the system and browser requirements for the Document360 Knowledge base portal to function efficiently on your device.

> NOTE
>
> You can access the Document360 Knowledge base portal and site on your web browser, even if you are using earlier or less recent versions of the hardware and software mentioned below. However, the advanced features of our platform may not perform as quickly or efficiently.

---

### Operating System and Hardware

Ensure your computer is installed with one of the following operating systems:

| # | **Operating system requirements** |
| --- | --- |
| 1 | **Windows 7.0** or **higher** |
| 2 | **OSX Mavericks** or **higher** |
| 3 | **Linux** |
| 4 | **Android 5.0** or **higher** |
| 5 | **iOS 12.0** or **higher** |

| # | **Hardware requirements** |
| --- | --- |
| 1 | **2 core CPU** or **higher** |
| 2 | **4 GB RAM** or **higher** |

---

### Web browser requirements

Document360 works well on the latest versions of these web browsers, as mentioned below.

| # | **Supported web browsers** | **Knowledge base portal** | **Knowledge base site 1.0** | **Knowledge base site 2.0** |
| --- | --- | --- | --- | --- |
| 1 | **Google Chrome** version 91.0.4472 or higher | Yes | Yes | Yes |
| 2 | **Firefox** version 79.0 or higher | Yes | Yes | Yes |
| 3 | **Safari** version 13.1.2 or higher | Yes | Yes | Yes |
| 4 | **Microsoft Edge** version 88 or higher | Yes | Yes | Yes |
| 5 | **Internet Explorer** version 11 | No | No | No |
|  | Other web browsers |  |  |  |

#### Browser features

Depending on the browser of your choice, you must ensure the following browser attribute conditions are met.

* **JavaScript** must be **enabled**.

  > Limited access is provided when disabled.
* **Cookies** must be **enabled**.
* **Session Storage** must be **enabled**.
* **Local Storage** must be **enabled**.
* **IndexedDB** must be **enabled**.
* **HTTPS - TLS v1.2** or **higher**.

---

### Support and feedback

If you face any difficulty in working with Document360 using any of the requirements mentioned above, or if there are issues that are not previously specified, you can always **write to us** at [support@document360.com](mailto:support@document360.com).

## Troubleshooting

If you encounter any issues while logging in to the Knowledge base portal, refer to the following common errors and their solutions:

### reCAPTCHA Error: “Having trouble?”

**Error**: When attempting to log in, users may encounter the error message **"Having trouble?"** while interacting with the reCAPTCHA verification. This issue can occur due to browser restrictions, VPN interference, or network-related blocks preventing reCAPTCHA from loading correctly.

![Login form displaying an error message from Cloudflare regarding login issues.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Troubleshooting_srecaptcha_error.png)

**Steps to resolve**:

Follow these steps to resolve the issue:

1. Try accessing the site in a different browser**.** If the site loads successfully in another browser, disable any browser extensions in the affected browser and try again.
2. If you are using a VPN, disconnect it and attempt to log in again.

If the issue persists after following the above steps, follow the below steps:

* Generate a HAR file by following [these steps](https://docs.document360.com/docs/document360-support-generating-a-har-file).
* Take a screenshot of any console errors that appear.
* Contact [**support@document360.com**](mailto:support@document360.com) with the HAR file and screenshots for further investigation.

![Document360 console interface displaying support articles and troubleshooting options for users.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Browser_console.png)

### Access blocked: “Sorry, you have been blocked” / “You are unable to access us.document360.io”

**Error**: When attempting to access `us.document360.io`, you may receive an error message stating **"Sorry, you have been blocked"** or **"You are unable to access** `us.document360.io`**"**, along with a **Cloudflare Ray ID:** **8dbb32d07fb2e4d4**. This error indicates that access to the site has been restricted due to network, browser, or security-related issues.

![Access denied message indicating a block by Cloudflare with a Ray ID.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Troubleshooting_cloudfare_error.png)

**Steps to resolve**:

Follow these steps to resolve the issue:

1. Check if the site is accessible using a different browser, network, or computer.

   * If the site is accessible in another browser, provide the **browser name and version** of both working and non-working browsers.
   * If the site is accessible on a different computer, provide the **operating system name and version** of both devices.
   * If the site is accessible on a different network, provide details about the **network setup and the IP address** from which the error occurs.
2. Generate a HAR file by following [these steps](https://docs.document360.com/docs/document360-support-generating-a-har-file).
3. Take a screenshot of any console errors that appear.
4. Contact [**support@document360.com**](mailto:support@document360.com) with the HAR file, screenshots, and the details collected in Step 1 for further investigation.

![Document360 console interface displaying support articles and troubleshooting options for users.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Browser_console.png)

### Login issue: Knowledge base portal keeps loading

**Error**: You are unable to log in to the knowledge base portal because the login page keeps loading indefinitely. This issue may occur due to your browser cache, extensions interfering with the login process, or incorrect system time settings.

**Steps to resolve**:

To resolve this issue,

1. Clear your browser cache and cookies. If the issue persists, check whether it affects all team accounts or only specific users. Use the following steps to clear your cache:

   * **Google Chrome:** Menu (3 dots) > Settings > Privacy and security > Clear browsing data
   * **Mozilla Firefox:** Menu (3 lines) > Settings > Privacy & Security > Clear Data
   * **Microsoft Edge:** Menu (3 dots) > Settings > Privacy, search, and services > Choose what to clear
   * **Safari (Mac):** Safari > Preferences > Privacy > Manage Website Data > Remove All
   * **Safari (iPhone/iPad):** Settings > Safari > Clear History and Website Data
   * **Opera:** Menu > Settings > Advanced > Privacy & Security > Clear browsing data
2. Try accessing the portal in an incognito or private browser window. Some browser extensions may be blocking the login page or affecting loading times.
3. Inspect the page to check for loading time issues:

   * Right-click on the page and select **Inspect**.
   * Check the console for error messages and monitor loading times.
   * If you see an invalid login persisting for a long time, your system’s time settings may be incorrect.
4. Make sure your system time zone is set correctly. An incorrect system clock or time zone mismatch can cause login failures. Update your system time zone to match your region.
5. If the issue still persists, capture diagnostic data:

   * Generate a HAR file by following [these steps](https://docs.document360.com/docs/document360-support-generating-a-har-file).
   * Share the HAR file with [**support@document360.com**](mailto:support@document360.com) for further troubleshooting.

---

### FAQs

#### **Can I download the Document360 desktop application?**

Document360 is available only as a **web application**, which can be accessed using web browsers on desktop and laptop devices.

#### **Can I access the Knowledge base portal on smartphones and tablets?**

Yes, the Knowledge base portal can be accessed via a web browser on both computers and mobile devices (smartphones and tablets).

However, for the best user experience, it is not recommended to use a web-view workaround in the mobile browser to access the portal.

#### **How do I clear the Document360 project cache?**

Clearing the cache helps resolve display or functionality issues caused by old, cached data. To clear your project’s cache in Document360, follow these steps:

1. Navigate to the specific location in the Knowledge base portal where you need to clear the cache.
2. You can open the developer tools:

   1. On Windows: Press `Ctrl+Shift+I`.
   2. On macOS: Press `Cmd+Shift+I`.
3. Right-click and hold the **refresh** button.
4. Select **Empty Cache and Hard Reload** from the menu.

#### Why am I unable to log in to my Document360 account? The callback URL is not working.

This issue may occur due to an intermittent cache issue or an incorrect system time setting on your device. If your system's internal clock is not synchronized with your time zone or region, it can cause login failures, including issues with the callback URL (`portal.document360.io/callback`).

**Steps to resolve:**

* Clear your browser cache and cookies, then try logging in again.
* Verify your system time settings and ensure they are correctly synchronized with your time zone.

![Webpage displaying a loading document360 icon and a highlighted URL in the address bar.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_Screenshot-Callback_while_logging.png)

<a id="document360-my-projects"></a>

## Project dashboard

**Plans supporting access to Your projects page**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

### What is Document360 - Your projects?

The "Your Projects" space serves as your main dashboard upon logging into your Document360 account. It provides a centralized view of all the projects you're associated with, whether as an owner, team member, or reader, along with essential navigational tools.

---

## Navigating the 'Your projects' page

Upon logging in, you are greeted with a dashboard displaying tiles representing each Document360 project you have access to. These tiles include projects you own or are associated with as part of a team account or as a reader. Here's what you can do from this space:

### 1. **Create New or Sandbox Project**

Easily initiate a new [Project](/help/docs/creating-a-project) or a [Sandbox project](/help/docs/creating-a-sandbox-project) using the buttons conveniently located at the top right corner of the dashboard.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/My projects.png "My projects.png")

---

### 2. Projects

The Document360 projects you own and those you are associated with as a team account or reader are available. You can click the project tile to navigate to the project easily.

#### Project tile elements - Team account

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Project tile elements.png "Project tile elements.png")

1. **Logo:** Project logo for quick identification.
2. **Project name:** Clearly labeled to identify each project
3. **Project site access:** Indicates whether the project is of Public, Private, or Mixed access.
4. **Settings:** Manage project-specific settings directly from the tile.
5. **Documentation editor:** Access the knowledge base portal to create and manage documentation within the project.
6. **View in knowledge base site:** Navigate directly to the knowledge base site associated with the project.

---

### 2. Profile

Manage your personal account settings and log out from Document360 using the profile menu.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Profile.png "Profile.png")

---

### 3. Release updates

Stay informed about the latest Document360 product enhancements and features by clicking on the Release updates () icon. Expand release posts to read detailed updates and improvements.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Release updates(1).png "Release updates(1).png")

---

### 4. Help

Access various support resources from the  Help menu:

* **Documentation:** Access detailed guides and resources to help you navigate and utilize the platform effectively.
* **Issues/Clarifications:** Report any issues or seek clarifications about the platform's features and functionality.
* **Submit a Feature Request:** Suggest new features or improvements to enhance your experience with Document360.
* **System Status:** Check the current status and performance of the platform’s services.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Help.png "Help.png")

This dashboard serves as a central hub for managing and accessing all your Document360 projects, ensuring streamlined navigation and efficient project management from a single interface.

<a id="top-right-menu-overview"></a>

## Top-right menu overview

**Plans supporting access to My profile page**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The top-right corner of the Knowledge base portal provides quick access to key features. Quickly access essential features, including viewing and editing your profile, checking access levels, changing your portal password, staying informed about the latest updates, and exploring help resources in Document360.

## Key features in the top-right menu

* **My profile**: Here, you can view and edit your personal information, including your profile picture and biography. This section also displays your assigned portal and content roles and permissions.
* **View access and permissions**: Check the roles and permissions assigned to your account. This helps ensure you have the right level of access to perform your tasks.
* **Change password**: Securely update your login credentials by setting a new password. Make sure to choose a strong password to protect your account.
* **Release updates**: Stay informed about the latest updates and feature releases in Document360. Notifications keep you aware of changes that may impact your work.
* **Help menu**: Access helpful resources, including:

  + **Documentation:** Explore user guides and feature instructions.
  + **Support portal**: Raise support tickets and seek assistance.
  + **Contact support**: Directly reach out for help with any issues.

![Document360 interface showing user profile settings.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Top_right_menu_overview.png)

---

## Accessing profile options

You can access the first three options —  **My profile,  View access and permissions, and  Change password** — by clicking your **profile picture** in the top-right corner of the portal.

> NOTE
>
> This icon displays your profile image or a default placeholder if no image is set. It will display your initials until you upload your profile image.

### My profile

The  **My profile** section allows you to view and edit your personal information.

To access your profile,

1. Click your profile picture.
2. Click  **My profile** from the dropdown menu. This will open the  **My profile** side panel.

![Document360 interface showing user profile access menu.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Top_right_menu_my_profile.png)

#### Features available in my profile

* **Profile image** - Update or delete your profile picture.
* **First and last name** - View and edit your name.
* **Email ID** - View your email address.
* **Author page URL** - View and edit your author page URL.
* **Author bio** - Add or update a biography. This field will be blank if no biography is added.
* **Edit button** - Use this button to update or delete your profile image, name, author URL slug, and biography directly within your profile settings.
* **Portal language** - You can use this dropdown to change the language for your knowledge base portal. The UI elements will adapt based on your selection. Available languages include English, Spanish, and Portuguese (Brazil). Note that this setting applies only to your portal view and does not change the content language.
* **Portal role** - View your assigned role (e.g., Owner, Admin, Contributor).
* **Content role & access** - Check content roles and access levels, including workspace names, languages, and categories.
* **View contributions** - Click the **Click here** hyperlink to view your contributions in the Team Accounts module under Analytics.

![User profile settings showing role, language, and access details in Document360.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-My_profile_side_panel.png)

> NOTE
>
> Email IDs in the user profile cannot be edited for SSO users.

### View access and permissions

The **View access and permissions** section allows you to check your assigned permissions within Document360 for the Portal role and Content role. Portal roles manage administrative settings within the knowledge base portal, while Content roles control access and actions related to content management.

![User interface showing access permissions in Document360.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Top_right_menu_view_access_permissions.png)

To view your access permissions,

1. Click your profile picture in the top-right corner.
2. Click  **View access and permissions** in the dropdown menu. This will open the **View access permissions** popup window.

In the View access permissions window, you will be able to see the permissions assigned to you for each feature under the Portal role and Content role.

You can edit/update your permissions from the Team accounts & groups [Insert article link here] page in Document360 settings. You will only be able to make any changes if you have the required Portal role permissions (For example, Owner or Admin).

To learn more about the various roles and permissions in Document360, and creating custom roles, read the article on Roles & permissions.

![Access permissions for project settings, team auditing, and event notifications overview.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_Screenshot-View_access_permissions_window.png)

> NOTE
>
> The View access and permissions option is only available when accessing the top-right menu from within a project.

### Change password

The **Change password** section allows you to securely update your login credentials in Document360.

![User interface showing the option to change password in settings.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/6_Screenshot-Top_right_menu_change_password.png)

To update your Document360 password,

1. Click your profile picture in the top-right corner.
2. Click **Change password** from the dropdown menu. This will open the **Change password** popup window.
3. Enter your **current password** in the provided field.
4. Enter a **new password** in the next field. Ensure the new password meets security requirements.

> NOTE
>
> Your new password should:
>
> * Be at least 8 characters long
> * Contain at least 1 UPPERCASE letter
> * Contain at least 1 lowercase letter
> * Contain at least 1 number
> * Contain at least 1 special character

5. Confirm the new password by re-entering it.
6. Click **Save** to update your password.

![Password change interface with fields for current, new, and confirm password.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/7_Screenshot-Change_password_popup.png)

> NOTE
>
> Changing your password will log you out immediately. You will need to log in with your updated password.

#### Best practices for updating your password

Here are a few pro tips for creating a strong and secure password.

**Dos**

* Create a unique password that uses a combination of numbers, words, symbols, and both uppercase and lowercase letters.

> **For example:** En37df\_n4r-hufling

**Don’ts**

* Don’t use easily guessed passwords, such as "password," "123456," or "user."
* Don’t choose passwords based on easily obtainable details, such as your birth date, Social Security number, phone number, or the names of family members.
* Don’t use words that can be found in the dictionary. Password-cracking tools often come with dictionary lists that will try thousands of familiar names and words.

  + If you must use dictionary words, try adding numbers and special characters to them, such as "In$t@llat10n."
* Don’t use simple adjacent keyboard combinations like "qwerty," "asdzxc," "abcdef," or "123456." These are generic and easy to crack.

---

## Release updates

Stay up-to-date with the latest updates and announcements from the Document360 team.

To read about the latest updates to Document360,

1. Click the **Release updates** icon () in the top-right corner in the Knowledge base portal. A popup appears, displaying information about the three latest releases.
2. Click any update to read a brief summary. To view the full details, click **Read the whole post.**
3. You can also click **Document360 updates**. This will redirect you to the [**Document360 Updates - Changelog**](https://changelog.document360.com/?utm_medium=widget) page.

![Document360 interface showing recent updates in a sidebar.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/8_Screenshot-Top_right_menu_release_updates.png)

> NOTE
>
> To read the latest Document360 release note, click [**here**](https://docs.document360.com/docs/release-note).

---

## Help menu

The **Help menu** provides several tools to assist users in resolving queries, accessing resources, and staying informed about Document360.

Click  **HELP** in the top-right corner of the Knowledge base portal to access the help menu.

### Options available in the help menu

1. **Get assistance:** Opens a side-panel widget where you can search for answers to your queries or access Document360 documentation directly.
2. **Documentation:** Redirects you to the Document360 knowledge base at `https://docs.document360.com/docs`, where you can browse detailed articles, guides, and tutorials.
3. **Chat with us:** Opens a chat widget that connects you with the Document360 customer support team for real-time assistance.
4. **Issues and clarification:** Launches a widget allowing you to create a support ticket. You can include details and attachments to help the support team resolve your issue effectively.
5. **Submit a feature request:** Provides a platform to share feedback and suggest new features. Feature requests are visible to other users, who can vote to prioritize them.

> NOTE
>
> Only Document360 authenticated users can access the feedback portal.

6. **System updates:** Redirects you to `https://status.document360.com/`, where you can view the operational status and updates regarding Document360's services.

![Document360 interface showing help features for users.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/9_Screenshot-Top_right_menu_help_menu.png)

> NOTE
>
> For further assistance, you can also contact the support team directly via email at [support@document360.com](mailto:support@document360.com).

---

### FAQs

#### What happens if the browser does not support the selected portal language?

If the browser does not support the selected language, Document360 automatically defaults to English.

#### What if I select Spanish as my portal language but my browser's preferred language is set to English?

If the browser's preferred language is English but the user selects Spanish within the application, all projects will be displayed in Spanish, following the user's preference. Similarly, if the browser's preferred language is set to Spanish, all projects are displayed accordingly.

<a id="creating-a-project"></a>

## Creating a project in Document360

#### Plans supporting the creation of new project

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

A project in Document360 serves as a comprehensive container for all your documentation needs. It encapsulates your articles, categories and subcategories, the home page, team accounts, readers, and groups (for private and mixed projects), and custom configurations or settings. This centralized approach ensures that your knowledge base is organized, easily accessible, and scalable.

## How to create a knowledge base project in Document360?

Projects in Document360 are designed to streamline your documentation process, offering a structured and efficient way to manage your information. Whether you're creating user manuals, internal process documents, or API documentation, a Document360 project provides the framework to store, manage, and distribute content effectively. Follow these steps to create your knowledge base project.

### Accessing the dashboard

1. Log in to the [**Document360 portal**](https://portal.document360.io/) with your account to access the **Dashboard**.   
   If you are logged in and are in a different project's Knowledge base portal, click the Document360 icon at the top left to be redirected to the **Dashboard**.
2. Click the **+****Project**button on the top right to create a new project.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/My projects.png "My projects.png")

### Choose your use case

3. Select any of your following primary use case for which you’re using Document360 by clicking **Get started.**

|  |  |
| --- | --- |
| **Use case** | **Description** |
| **Knowledge base platform** | You can create a centralized hub where all your team's knowledge and resources are stored. It helps your team quickly find answers and enhances customer self-service by providing them with easy access to the information they need. |
| **Software documentation/Technical documentation** | You can efficiently organize and maintain all your software or technical documentation. It helps your team document product features, APIs, release notes, and more, making sure that developers and users have clear and up-to-date information. |
| **SOP documentation** | You can create detailed SOPs that your team can follow consistently. It ensures that everyone adheres to the same processes, reduces errors, and helps in onboarding new employees by providing them with clear procedural guidelines. |
| **User manual** | You can develop comprehensive user manuals that guide your customers or team members through your product's features and usage. It helps in reducing support queries by offering step-by-step instructions and troubleshooting tips. |
| **API Documentation** | Document detailed information about API endpoints, request and response formats, authentication methods, and examples. This ensures developers have a clear understanding of how to integrate with your APIs. |
| **Others** | Choose this option if your use case does not fall into the predefined categories. You can customize your knowledge base based on specific organizational or project needs. |

### Select a Template

4. Select the type of content you'll create in your Document360 project. You can pick up to two templates that suit your needs.

> NOTE
>
> Based on your selection, these templates will be embedded within your project during creation.

**Knowledge base platform templates**

If you have selected the Knowledge base platform in step 3, you can choose any two templates from the list below.

|  |  |
| --- | --- |
| **Template** | **Purpose** |
| **Getting started guides** | Help new users quickly understand and begin using your product with clear, step-by-step instructions. This ensures a smooth onboarding experience. |
| **How-to guides** | Provide detailed instructions for specific tasks, enabling users to fully utilize and explore your product’s features efficiently. |
| **FAQs** | Address common questions at any stage of the user journey, helping users find quick answers and reducing support queries. |
| **Policy & procedures** | Outline essential organizational protocols, helping users understand and adhere to company guidelines effectively. |

**Software/Technical documentation templates**

If you have selected Software/Technical documentation in step 3, you can choose any two templates from the list below.

|  |  |
| --- | --- |
| **Template** | **Purpose** |
| **Release notes** | Keep users informed about updates, new features, bug fixes, and improvements with each software release. |
| **Software Design Documentation (SDD)** | Outline software architecture and design, including diagrams and specifications for development guidance. |
| **Software Requirement Documentation** | Describe the software's purpose, functionalities, and environment to ensure development aligns with project goals. |
| **Product Requirement Documentation (PRD)** | Define the product’s purpose, value, and functionalities to meet user needs and business objectives. |
| **Process documentation** | Detailed steps and procedures involved in software development to standardize workflows and enhance efficiency. |
| **User guide** | Give comprehensive instructions on using your product, covering all features and functionalities. |

**SOP documentation templates**

If you have selected SOP documentation in step 3, you can choose templates from the list below.

|  |  |
| --- | --- |
| **Template** | **Purpose** |
| **Compliance policies and procedures** | Ensure your organization meets regulatory requirements by documenting policies that enforce compliance. |
| **Operation SOP** | Enhance efficiency and productivity by standardizing operational procedures across your organization. |

**User manual templates**

If you have selected the User manual in step 3, you can choose any two templates from the list below.

|  |  |
| --- | --- |
| **Template** | **Purpose** |
| **Installation manual** | Provides all necessary setup information including product overview, specifications, and assembly instructions, ensuring a smooth start with the Knowledge base platform. |
| **Instruction manual** | Offers step-by-step assembly and usage instructions with diagrams and safety warnings, ideal for precise setup and safety warnings for proper usage. |
| **Maintenance manual** | Provide detailed instructions for regular upkeep, troubleshooting, and repair procedures to ensure optimal performance. |
| **Training manual** | Provides comprehensive guidance on installation, operation, and troubleshooting, and support for user training and effective platform usage. |
| **Operations manual** | Provide detailed instructions for daily maintenance and troubleshooting, ensuring ongoing effective management of the Knowledge Base platform. |

### Personalize your knowledge base

5. Enter your preferred website URL. If you want to skip this step, the domain will default to the one linked to your registration email.

### Brand guidelines

6. Your project name, default language, branding logo, and brand colors will be automatically set based on your provided URL. However, you can edit the fields if needed.   
   Your browser’s language settings determine the default language. English will be selected by default if other languages don’t support your browser’s language.

> NOTE
>
> * you choose Spanish or Brazilian Portuguese as your default language; the portal language will be set to Spanish or Brazilian Portuguese. Otherwise, English will be the default language.
> * The branding logo and primary/secondary colors are extracted from your website. If you choose to **Skip** this step, the project name will be derived from your registration email, and Document360’s default logo and colors will be applied.

7. You can preview your Knowledge base on the right side of the screen.

### Set documentation privacy

8. Choose the desired privacy settings for your site:

   * **Private**: Restrict access to the Knowledge base so that only team accounts can view and interact with the content, keeping it secure and internal.
   * **Public**: Make the Knowledge base accessible to everyone, including external users, allowing open access to all content.
   * **Mixed**: Combine private and public access by allowing some sections of the Knowledge base to be visible to the public while keeping other sections restricted to team accounts only.
9. Click **Next** to proceed.

### Access the Document360 Knowledge base portal

Once you complete the setup, enter the Document360 Knowledge base portal. Here, you’ll find pre-loaded articles based on the use case and templates you selected.

> NOTE
>
> The articles seeded into your project are tailored to your selected use case and templates, giving you a head start on creating your content.

![Exploring the onboarding experience while signing up the Document360](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGIF-Final_onboarding_process.gif)

---

## Switching between Document360 projects

Once you’ve created your projects in Document360, you may need to work on multiple projects or switch between them for various tasks. Document360 provides an intuitive project switcher to help you manage this seamlessly.

There are two ways to switch projects from the Knowledge base portal:

1. Using the Projects dropdown
2. From the Projects dashboard

### Switching projects using the Projects dropdown

1. From any module in the Knowledge Base portal, click on the project dropdown at the top-left of the screen.
2. You can view the "Project Name," "Site Access" (Public -  , Private -  , or Mixed ), and a "Sandbox" label if it is a Sandbox project.
3. Click on the project you want to view from the list.

![Screenshot for switching between projects in Document360](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Switching%20between%20projects%20-%201.png)

### Switching projects from the Projects dashboard

1. Click on the Document360 logo at the top-left.

   ![Screenshot for switching between projects in Document360](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Switching%20between%20projects%20-%202.png)

   You will be redirected to the "My Projects" page.

   The list of all projects owned or associated with your account will be displayed.
2. Click on the project you want to navigate to.

   ![Screenshot for switching between projects in Document360](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Switching%20between%20projects%20-%203.png)

---

### FAQs

#### **Does Document360 support different languages in the onboarding flow?**

Yes, Document360 offers multi-lingual support in the onboarding flow, including languages such as English, Spanish, Brazilian Portuguese, German, and Swedish. However, within the Document360 portal, language support is currently limited to English, Spanish, and Brazilian Portuguese.

#### **Can I customize the appearance and structure of my Document360 project?**

Yes, Document360 projects offer extensive customization options. You can customize the look and feel of your knowledge base by designing your home page, themes, adding your organization's branding, editor oriented, and organizing articles in a hierarchical structure (categories) that suits your documentation needs.

#### **Is it possible to control access and permissions within Document360 projects?**

Absolutely. Document360 offers robust access control and permission settings. You can assign roles and permissions to team accounts, restricting or granting access to specific features and contents based on their responsibilities and requirements.

#### **How does Document360 help with version control and documentation history?**

Document360 projects maintain a comprehensive article version control system referred to as "Article revisions." It automatically saves and tracks changes made to articles, allowing you to revert to previous versions if needed. This ensures the integrity of your documentation and simplifies collaboration on content updates.

#### **How do I know which project I am currently working on?**

You can check the project name displayed at the top-left of the screen in the Knowledge Base portal.

#### **What happens if I don't see the project I want to switch to?**

Ensure you have the necessary access permissions for that project. If the project still doesn't appear, contact your Document360 administrator for assistance.

#### **What is a "Sandbox" project, and how is it different from other projects?**

A Sandbox project is a test environment where you can experiment without affecting your live projects. It will have a "Sandbox" label in the project dropdown.

#### **What does "Site Access" mean in the project dropdown?**

"Site Access" indicates whether the project is Public, Private, or Mixed. This defines the accessibility level of the project's content.

#### **How can I request access to a project I am not currently associated with?**

Contact your team administrator or project owner to request access to the desired project.

Application Programming Interface - A set of rules that allows one software application to communicate with another.

<a id="dashboard"></a>

## Dashboard

**Plans supporting the use of Dashboard**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The Document360 dashboard provides insights on your project, team members, and tasks to complete. There are two tabs in the dashboard: **My contribution** and **Overview**. The **My contribution** tab provides information regarding your articles and contributions to the knowledge base. The **Overview** tab provides information regarding all the team accounts associated with the project.

## My contribution tab

The **My Contribution** tab in the Document360 dashboard provides you with an overview of your contributions to the associated Document360 project. This includes all the workspaces and languages that are part of the project. You can view your contributions in terms of:

* **Article summary** (number of articles created and published, and performance metrics)
* **Articles assigned to you**
* **Review reminders**
* **Feedback to address**
* **Any broken links in your articles**

![Screenshot of the dashboard](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_GIF-Dashboard_my_contribution_overview.gif)

NOTE

You can filter the data in the **My contribution** page for a particular workspace and language from the dropdown at the top. You can also choose to view data for all workspaces and languages by selecting All workspaces and All languages from the dropdown at the top.

### Article summary

The section on the left of the **My contribution** tab is called **Article summary**. It contains information regarding any articles you have worked on. View your article count in three categories:

* **Created articles** (number of created articles)
* **Published articles** (number of articles published)
* **Draft articles** (number of articles updated, but still in Draft mode)

Along with these statistics, you can also view statistics related to the performance of all your articles. You can view these performance metrics:

* **Overall views** (total views for all articles)
* **Reads** (total reads)
* **Likes** (total likes received)
* **Dislikes** (total dislikes received)

> NOTE
>
> You can use the **Date** filter from the top right corner of the Article summary section to view the statistics for your articles during the last week, last month, or during a custom date range.

### Assigned to me

The **Assigned to me** tab shows all articles assigned to you across all workspaces and languages within the project. Each assigned article displays its current workflow status and, if applicable, the assigned due date.

### Review reminders

Each article in Document360 is marked as stale after a set period without updates. If you are a contributor to a stale article, it will appear under the **Review reminders** tab, along with the date it was marked as stale.

### Feedback

Any user feedback to an article in the knowledge base site will be recorded in the Feedback manager under Content tools. If any feedback from the Feedback manager is assigned to you, it will appear in the **Feedback** tab. You will also be able to view the Feedback status, as well as the date the feedback was assigned to you.

### Broken links

If any of your articles contain any broken links, the article will be listed under the **Broken links** tab. You can see the workspace and language of the article, along with the number of broken links in the article.

## Overview tab

The **Overview** section allows team members with Owner or Admin roles to view key project information, including article contributions, performance metrics, Drive capacity, total team accounts, reader count, broken links and more. You can view the following metrics on this page:

* **Article summary** (number of articles created and published, and performance metrics)
* **Project overview**

  + Recently seen
  + Team accounts
  + Readers
  + Drive capacity
  + Broken links
  + No result searches
  + Last backed up

![1_Screenshot-Dashboard_Project_overview](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Project_dashboard_overview_page.png)

NOTE

You can filter the data in the **Overview** page for a particular workspace and language from the dropdown at the top. You can also choose to view data for all workspaces and languages by selecting All workspaces and All languages from the dropdown at the top.

### Article summary

The Article summary section shows the total articles created, published and in Draft mode as well as the article performance metrics for the time frame selected from the Date dropdown. You can filter this data by contributor by selecting one or more users from the Filter option.

### Project overview

This section allows you to manage the project by displaying important information, such as:

* **Recently seen**: Displays the gravatars of contributors who recently accessed the project.
* **Team accounts**: Shows the total team accounts added to the project. Click **View all** to navigate to the **Team accounts & groups** page (**Settings** > **Users & security**).
* **Readers**: Shows the total readers added to the project. Click **View all** to navigate to the **Readers & groups** page (**Settings** > **Users & security**)
* **Drive capacity**: Shows the used and total available Drive capacity. Click **View all** to navigate to the Drive module.
* **Broken links**: Shows the total broken links in the knowledge base. Click **View all** to navigate to the link status overview page (**Analytics** > **Link status**)
* **No result searches**: Shows the total searches on the Knowledge base site that showed no results. Click **View all** to navigate to the search analytics page (**Analytics** > **Search**)
* **Last backed up**: Shows the most recent date a backup was created for the project.

---

### FAQ

**How can I filter the data in the My Contribution page?**

You can filter the data by selecting a specific workspace and language from the dropdown at the top, or view data for all workspaces and languages by selecting **All workspaces** and **All languages**.

<a id="getting-started-with-multi-lingual-knowledge-base"></a>

## Multilingual Knowledge bases

**Plans supporting the use of multilingual knowledge base**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

### What is a multilingual Knowledge base?

A multilingual knowledge base is essentially similar to a standard knowledge base, with the primary distinction being that it provides content in various language choices, enabling users to obtain information in their chosen language for a more integrated experience.

> NOTE
>
> Document360 supports the internationalization (i18n) of your project's Knowledge base site.

---

## Adding multiple languages to a single workspace

To add multiple languages to a single project workspace or a language-specific Knowledge base in Document360.

Navigate to Settings () > **Knowledge base portal** > **Localization & workspaces** in the Knowledge base portal.

You can find a list of workspaces available in the project.

There are two ways to add a new language to the project workspace from here.

#### Method 1 - From the edit workspace module

1. Click the **Edit** (🖉) icon to the right of the workspace, and the **Edit workspace** blade window will appear.
2. Click the **New language** at the bottom, and a list of languages appears.
3. Use the search bar to search language(s).
4. Select the checkbox of the desired language(s) and click **Apply**.
5. Then click the **Update** button at the bottom of the blade.
6. Click on the More () icon for the below edit options,

   **Set as default** - To set the language as the default language of the workspace.

   **Edit display name** - To edit the display name of the language for the workspace.

   **Right to left** - Most languages are written from left to right, but a handful of languages are written in the opposite direction. By enabling this toggle, article content in the HTML editor and reader view (Knowledge base site) would start on the right and end on the left.

   **Hide** - To hide the language. The Knowledge Base portal indicates hidden languages by strikethrough for reference.

   **Remove** - To remove the language from the list of languages.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenShot-Multilingual_Knowledge_Base.gif)

#### Method 2 - Using the localization icon on the overview page

1. Click on the **Add new language** () icon next to the Edit icon.
2. Search for the desired language(s) in the search bar and select the checkbox of the languages you wish to add to your workspace.
3. Once done, click **Add**.

> NOTE
>
> While selecting a language for your workspace, all languages other than English will be displayed in their native script.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenShot-Multilingual_language_base.gif)

> NOTE
>
> All the categories and articles from your default language will be available in the new language(s). However, these articles and categories have to be manually translated, using machine translation (HTML editor only) or with extensions like **Crowdin**.

---

## FAQ

**How many languages can I use per workspace in each plan?**

Each plan includes the following number of languages per workspace by default:

* **Professional Plan:** 2 languages
* **Business Plan:** 3 languages
* **Enterprise Plan:** 5 languages

Also, you can purchase more languages as an add-on on your existing plan.

The public-facing website where end-users can access articles and find answers to their questions.

An online library where users can find information about a product, service, department, or topic. It helps users self-serve by providing answers and guidance.

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

The public-facing website where end-users can access articles and find answers to their questions.

<a id="creating-a-sandbox-project"></a>

## Creating a sandbox project

**Plans supporting for creating a Sandbox project**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

### What is a Sandbox project?

A Sandbox project is an essential feature of Document360, offering an isolated test environment to explore features and configurations without impacting your live knowledge base. Whether testing new designs, refining workflows, or training your team, the Sandbox project provides a secure space to experiment and optimize your setup.

A sandbox project allows you to:

* Safely test new features and settings before going live.
* Identify and resolve issues early.
* Refine your setup and train your team without disturbing the end-user experience.

For instance, if you want to redesign your Knowledge base site's layout to enhance user-friendliness, you can use the Sandbox project to test the new design, gather feedback from internal teams and beta customers, and make adjustments before implementing changes in the live environment.

---

## Creating a Sandbox project

To create a new sandbox project,

1. Navigate to **Settings** () > **Knowledge base portal**> **General**in the Knowledge base portal.
2. In the **Sandbox** section, click **Create Sandbox**.

   The **Create a knowledge base sandbox** panel will appear.
3. Enter your desired project name in the **Project name** field.

> NOTE
>
> **Naming Guidelines:**
>
> * Only alphabets (A-Z, a-z), numbers, hyphens (-), and spaces are allowed.
> * Special characters, except hyphens, are restricted.
> * The project name must not exceed 30 characters (including spaces).

4. Select the language from the **Language** dropdown.
5. If required, select the **KB site 1.0** checkbox, if the Sandbox project should be based on KB site 1.0.
6. The **Knowledge base visibility** for Sandbox projects will be set to [**Private**](/docs/site-access#private-access) by default.
7. Click **Next**.
8. Optionally, to invite team accounts, enter their email addresses.

   For multiple team accounts, separate the addresses with commas (,).
9. Select the desired **Role** for each team account.
10. Once all details are entered, click **Create project**.

    Your Sandbox project will be created.
11. Click **Open Sandbox**  to access the newly created Sandbox.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/New_UI_1_ScreenGIF-Creating_a_Sandbox_project.gif)

The **Sandbox** badge will appear next to **Open site**  in the top bar and beside the workspace name in the dropdown, indicating that the workspace is a Sandbox project.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-New_Sandbox_badge_in_the_top_bar.png)

> NOTE
>
> SSO users cannot create sandbox projects because logging in as an SSO user requires having a regular user who assigns SSO access to another user. Therefore, a new SSO user cannot create a sandbox project.

### Reasons to own a sandbox project

* **Reduced Risk**: By isolating the sandbox from the live knowledge base, you can experiment without risk.
* **Increased Efficiency**: Pre-launch testing in the Sandbox project ensures that transitions to the live environment are seamless and efficient.
* **Testing and Exploration**: The Sandbox project empowers you to explore Document360’s features and integrations in a safe and dynamic environment, completely free from any live project disruptions.
* **Training Through Isolation**: The sandbox serves as an excellent training platform, equipping team members with hands-on experience in Document360 without risking unintended impacts on the live environment.

---

### FAQs

#### How do I configure my subdomain name for the Sandbox?

The subdomain name for a Sandbox project will have `sandbox` appended to distinguish it from your live project. Once the Sandbox is created, you can modify the subdomain name using [custom domain mapping](https://docs.document360.com/docs/custom-domain-mapping).

#### How does the Sandbox project improve knowledge base management?

By offering a controlled environment, the Sandbox project lets you assess and refine new features before implementing them in the live knowledge base. This enhances content quality and customer support.

#### Can I test new configurations without disrupting the live project?

Yes. The Sandbox project allows you to evaluate different configurations, such as templates, integrations, and scripts, without impacting your primary knowledge base.

#### How does the Sandbox project prevent customer impact during testing?

Before introducing them to customers, you can verify changes like navigation menus and search algorithms in the Sandbox project. This safeguards their experience and helps identify and address issues before launch.

#### Can I migrate a sandbox project to production in Document360?

No, there is currently no direct option to migrate a sandbox project to production in Document360. To achieve this, you need to manually export the data from the sandbox project and then import it into the production environment.

#### Why can't I log in as an SSO user in the Sandbox environment?

Only non-SSO users can access the Sandbox environment. To gain access, request a team member with a non-SSO account to create a standard user account for you.

<a id="quick-summary-of-the-security-and-infrastructure-aspects"></a>

## Document360 security and infrastructure

**Plans supporting the Document360 security and infrastructure**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Security is one of the most important aspects of any SaaS application. As a company specializing in SaaS products, we ensure our offerings align with the latest market standards. **Document360** prioritizes data protection, ensuring your information is always secure.

We collaborate with industry-leading partners like **Algolia** and **MongoDB Atlas**, who are certified for TLS-standard encryption for data in transit. **Microsoft Azure Blob Storage** also safeguards your project backups with robust security protocols.

---

## Quick summary - Security and infrastructure

* Your data is securely stored in a remote database hosted by **MongoDB Atlas**, utilizing a three-server cluster to ensure zero downtime.
* Network traffic is encrypted using TLS, and data at rest resides in encrypted storage volumes.
* **Daily**, **weekly**, and **monthly** backups are maintained for up to **one month**, enabling quick restoration.
* Project back-ups are stored in **Microsoft Azure Blob Storage** across multiple geolocations to maintain data integrity.
* Our secured API allows data access via authenticated API tokens, ensuring complete control over access permissions.
* Document360 is hosted on **Microsoft Azure Cloud**, leveraging its advanced security protocols and compliance standards.
* **Microsoft Azure Cloud** offers protection against Distributed denial of service (DDoS) attacks by defending against common network-layer attacks through always-on traffic monitoring and real-time mitigation.
* The core team is highly technical and understands the importance of security and staying up to date with new technologies. They coordinate with an offshore team to provide the best services for the customers.

For more details on using Document360 APIs, refer to the [**Document360 API documentation**](https://apidocs.document360.com/apidocs).

---

## Best practices

Here at **Kovai.co**, we believe that best practices create secure and robust applications. We recommend that Document360 users follow our list of best practices to prevent unexpected data loss or unauthorized access.

### List of best practices:

1. **We do not recommend publicly sharing the API key via less-secured networks,** as it can result in unauthorized data access. The key can be used to view or exploit your data. In such a case, we recommend deleting the key immediately and creating a new API key for your usage.

> For more information, click [**here**](https://docs.document360.com/docs/creating-document360-api-tokens).

2. **We recommend giving** **an API key only the required permissions**, as this helps keep the data in safe hands and prevents unauthorized users from modifying it. For example, to view an *"example"* set of data, the API key only needs the GET method. This does not let users modify the data using the API key.

> For more information, click [**here**](https://docs.document360.com/docs/creating-document360-api-tokens).

3. **We suggest that the team manager give each user the correct access rights,** as most of our customers have a team that has access rights to the documentation. We simplify this by having roles corresponding to a certain access rights level.

> For more information, click [**here**](https://docs.document360.com/docs/team-roles-and-permissions-explained).

4. **We recommend that** **users take advantage of the backup functionalities**. The project will be automatically backed up every day at 00:00 UTC. You can also manually back up your project anytime to keep the changes made safe.  Both of these will back up the Settings, Landing Page, Documentation, and Entire Project contents and can be restored at any time to return to a previous version. This process is made available to keep the users in control and to prevent data loss.

> For more information, click [**here**](https://docs.document360.com/docs/backup-restore).

5. **We recommend you use the option to make the document private if needed**. Various customers have different use cases for our product. You might want the documentation to be visible to the public or internal team members. The project owners can make the documentation private in the latter case and make it not visible to the public.

> For more information, click [**here**](https://docs.document360.com/docs/making-a-knowledge-base-private).

---

## Security information of integrations and partners

### Algolia - Search partner

* **SOC2 and SOC3 compliant**- Algolia follows all SOC 2 best practices to ensure excellence in the AICPA’s five trust service principles. Resulting in securing your data from modern world threats.
* API servers use HTTPS and TLS (1.0, 1.1, and 1.2), which have an A rating from [Qualys SSL labs](https://www.ssllabs.com/ssltest/analyze.html?d=latency-dsn.algolia.net&hideResults=on).
* Algolia isolates each customer's data in separate applications, preventing leakage and exchange of information from preserving the integrity of your data.

> For more information about the security of Algolia Search, visit [**Algolia's security docs**](https://www.algolia.com/enterprise/security/).

### MongoDB Atlas - Database service partner

* **Network isolation** - MongoDB Atlas dedicated clusters are deployed in a unique Virtual Private Cloud (VPC) with dedicated firewalls. This means that a third party cannot access your private data.
* **MongoDB Atlas undergoes independent verification** of platform security, privacy, and compliance controls.
* **End-to-end encryption** - All network traffic is encrypted using TLS, and the minimum TLS protocol version can be configured. Encryption for data at rest is stored in encrypted storage volumes.

> For more information about the security of MongoDB Atlas, visit [**MongoDB's security docs**](https://www.mongodb.com/cloud/atlas/security).

### Azure Blob Storage

* **Encryption in transit** - HTTPS ensures data is encrypted during transfer. In contrast, client-side encryption secures data on your device before sending it to the server, where it is decrypted upon arrival.
* **Encryption at rest** - Storage-side encryption is always enabled and automatically encrypts storage service data when writing it to Azure Storage. Client-side encryption is also enabled to make the data stored as secure as possible.
* **Advanced threat protection** - Provides an additional layer of security to detect unusual behavior and potentially harmful attempts to access and exploit your storage account.

> For more information about the security of Microsoft Azure Blob storage, visit [**Azure security docs**](https://docs.microsoft.com/en-us/azure/security/security-storage-overview).

---

## GDPR compliance

Document360 is fully **GDPR compliant.** We collect and store only the data required to deliver our services, with explicit customer consent.

> For more information about GDPR compliance, visit [**Document360's GDPR compliance page**](https://document360.com/gdpr-compliance/).

---

## Business continuity and disaster recovery

We have High Availability configured for our web apps and database to ensure business continuity. Multiple nodes run for individual services, so if one goes down, you still get an uninterrupted experience using Document360.

For any possible disaster, our database and data storage are replicated in different geolocations, so your data is always safe with us.

### DevOps Team

The product owner defines and reviews a Product roadmap periodically. Security fixes are prioritized and bundled in the earliest possible sprint. Our DevOps sprints are powered by multidisciplinary team members, including the Product Owner, Director of Engineering, Developers, and Quality Assurance.

* **Code Review**

The Quality Assurance team tests all changes and establishes criteria for performing code reviews, web vulnerability assessments, and advanced security tests.

* **Quality Assurance**

Builds undergo a stringent functionality, performance, stability, and UX tests before they are certified "Good to go.”

* **Version Control**

Source code is managed centrally with version controls, and access is restricted based on various teams assigned to specific sprints. Records are maintained for code changes and code check-ins and check-outs.

* **Segregation of Duties**

Access to the production resources is restricted to a limited set of users based on the job roles.

### Highly Resilient Architecture

The architecture is built with resiliency to ensure the high availability of the product and data.

* **High Availability**

We have multiple instances of our services running to ensure the high availability of our services for our customers.

* **Highly Scalable DNS**

Route users to the best endpoint based on geo-proximity, latency, health, and other considerations.

* **Data Backup**

Cloud snapshots are taken daily and retained, weekly and monthly, and the backups are available for one month for restoration.

* **Incident & Breach Management**

Procedures are established for reporting and tracking incidents for timely communication, investigation, and resolution.

* **Azure CDN**

We use Azure CDN to make sure our application and customer documentation are served with speed and ensure that they are done from the nearest node.

---

## Help

**For more information about Document360's security and infrastructure,** [**contact us**](https://document360.com/contact-us/) **(or)** [**book a demo**](https://document360.com/request-demo) **with our experts today.**

Application Programming Interface - A set of rules that allows one software application to communicate with another.

<a id="x-frame-options"></a>

## X-Frame options

**Plans supporting access to security settings in the knowledge base site**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

**X-Frame options** allow you to control whether your Knowledge base can be embedded in `<frame>, <iframe>`, `<embed>`, or `<object>` tags on other domains. This feature provides an additional layer of security by preventing malicious websites from embedding your Knowledge base using the above tags.

> NOTE
>
> Ensure that you are not using iframe-based embedding for unauthorized domains, as it will be blocked when the X-Frame options setting is enabled.

---

## Access X-Frame options

![image.png](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Enable_xframe_options_toggle.png)

1. Navigate to **Settings** > **Users & security** > **Security**. This section contains controls for various security settings.
2. Locate the toggle labeled **Enable X-Frame options** and switch it on to restrict iframe embedding from external domains.

For example, if your knowledge base domain is `help.example.com` and you want to prevent other sites like `support.test.com` from embedding your content via iframes, ensure the **Enable X-Frame options** toggle is turned on.

![2_Screenshot-XFrame_options_before_after](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-XFrame_options_before_after.png)

---

### FAQ

#### What is an iframe?

An iframe, also known as an inline frame, is an HTML element that allows web developers to embed another HTML document within the current document. The content within an iframe is a separate web page displayed within a specific section of another web page. Due to its ability to embed external content, managing iframe usage with security settings such as X-Frame options is crucial to prevent security risks like clickjacking.

#### What are the embedded tags that I can restrict with the X-Frame options?

The X-Frame options setting allows you to control whether your knowledge base can be embedded in `<frame>`, `<iframe>`, `<embed>`, or `<object>` tags on external domains.

#### Why are X-Frame options important?

The X-Frame options are vital for security as they help prevent clickjacking attacks, where an attacker embeds your knowledge base in a malicious website. This embedding tricks users into performing unintended actions. Enabling X-Frame options ensures your knowledge base cannot be embedded on external domains, safeguarding user interactions.

#### How can I configure the X-Frame options for my knowledge base?

1. Navigate to **Settings** > **Users & security** > **Security**
2. Locate the toggle labeled **Enable X-Frame options** and switch it on to prevent your knowledge base from being embedded on unauthorized external domains.

#### Can I allow specific domains to embed my Knowledge Base?

Yes, you can specify the allowed domains in the Frame source of content security policy setting. For more information, see the [content security policy](/docs/content-security-policy) article.

#### How can I test if my X-Frame options are working?

You can test if your X-Frame options are correctly configured by:

1. Using your browser’s developer tools and checking the **Network** tab to inspect response headers for the **X-Frame-Options** setting.
2. Using third-party services like [securityheaders.com](http://securityheaders.com) to verify that the correct X-Frame-Options header is applied.

#### What are the potential risks of not using X-Frame options?

If the X-Frame options are not enabled for your knowledge base, it may be embedded in an iframe on another website without your authorization. This lack of control exposes your site to clickjacking attacks, where attackers overlay invisible or misleading elements over your interface to trick users into performing unintended actions, such as divulging passwords or clicking on malicious links. Such vulnerabilities can compromise user security and potentially lead to data breaches.

#### What is clickjacking?

Clickjacking, also known as UI redressing or UI masking, is a malicious technique where attackers trick users into clicking on a button or link that is hidden or obscured within a web page or application. This is often achieved by overlaying a transparent layer with deceptive elements over a legitimate website or application. Users may think they are interacting with the actual site, but in reality, they are engaging with elements controlled by the attacker. Such interactions can lead to adverse outcomes, like downloading malware, making unauthorized purchases, or inadvertently sharing sensitive information. Utilizing security settings like X-Frame options can help protect against such attacks by preventing unauthorized embedding of your content.

#### What is a malicious website?

A malicious website is a site designed to cause harm to visitors or their devices. These sites may trick visitors into downloading malware, stealing personal information, or engaging in fraudulent activities. Using X-Frame options helps prevent your content from being embedded on such sites, enhancing your security measures against these risks.

An online library where users can find information about a product, service, department, or topic. It helps users self-serve by providing answers and guidance.

<a id="content-security-policy"></a>

## Content security policy

**Plans supporting Content security policy in the knowledge base site**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

**Content Security Policy** (CSP) is a security related feature which helps to manage and prevent the external CSS, scripts, and frames embedded in your Knowledge base. When the content security policy is enabled in the project, the `Content-Security-Policy` response header will be added to the request header with the default allowed domains for each source. It restricts the resource loading from external domains and allows resources only from the configured list of domains for each source.

---

## Enable the content security policy

![image.png](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Content_Security_Policy_in_the_Knowledge_base_portal.png)

1. Navigate to **Settings** () > **Users & Security** > **Security** in the Knowledge base portal.
2. Turn on the **Enable content security policy** toggle.
3. You can find the following source fields:  
    a. [**Style source**](/docs/content-security-policy#a-style-source)  
    b. [**Script source**](/docs/content-security-policy#b-script-source)  
    c. [**Frame source**](/docs/content-security-policy#c-frame-source)**.**
4. Type in the desired domain URLs in the respective fields.
5. Click **Save.**

> NOTE
>
> * The character limit for each limit is 5000.
> * Use commas (,) to separate the URLs.
> * Keep the URLs in the following format: `https://example.com.`

### a. Style source

In the **Style source** field, you can define the valid sources of stylesheets that can be applied to your Knowledge base. Configuring the style sources will prevent malicious styles from being used to execute Cross-Site Scripting (XSS) attacks on your Knowledge base.

* Type the domain URLs of **stylesheet sources** in this field.
* All the stylesheets from other URLs will be restricted.

> NOTE
>
> Ensure that you have added Nonce attribute placeholder in all custom HTML script sections.
>
> **Example**: `<Script nonce='{{Document360-Nonce}}'>`

---

### b. Script source

In the **Script source** field, you can define the valid sources of JavaScript codes that can be executed on your Knowledge base. This helps to prevent malicious JavaScript code from being executed, even if it has been injected into the Knowledge base by an attacker.

* Type the domain URLs of **Javascript sources** in this field.
* All the JavaScript codes from other URLs will be restricted.

---

### c. Frame source

In the **Frame source** field, you can define the valid sources of frame elements like `<frame>` and `<iframe>` that can be embedded in your Knowledge base.

* Type the domain URLs of **frame sources** in this field.
* All the frames from other URLs will be restricted.

---

## Testing your content security policy settings

After setting up your CSP, it’s important to verify that the settings are working as expected. To check if the content security policy has been applied correctly:

1. Open the **Network** tab in your browser's developer tools.
2. Visit your knowledge base and review the **response headers** for the CSP.
3. Alternatively, you can use online tools like [securityheaders.com](http://securityheaders.com) to verify if your website has the correct **Content-Security-Policy** headers set.

---

### FAQs

#### **Why is my video showing as "This content is blocked" in one article but not another?**

This issue typically occurs due to Content Security Policy (CSP) settings in Document360. The video might not be allowed by the current CSP settings. Different articles might have different CSP settings. Ensure that the video source is allowed in the CSP settings for all articles where the video needs to be displayed.

#### **How can I resolve the issue of a blocked video in my article?**

To fix this, navigate to **Settings** > **Users & security** > **Security**. Under **Enable content security policy** section, add the video source (e.g., https://www.youtube.com/) to the "Frame source" list and click **Save**.

#### **Why does my CSP validation indicate that CSP is missing in the response header?**

In Document360, the Content Security Policy (CSP) is implemented using **meta elements** rather than the response header. If you validate CSP by inspecting the response header, it will appear as though CSP is missing or disabled.

To confirm that CSP is enabled on your Knowledge base site, follow these steps:

1. Open your Knowledge base site in a browser.
2. Right-click anywhere on the webpage and select **View page source**.

   The page's source code will appear.
3. Use the search function (**Ctrl + F** on Windows or **Cmd + F** on Mac) and look for the term “**Content-Security-Policy**”.
4. If the term “**Content-Security-Policy**” is found, the CSP configuration will appear as the code following this term.

By validating through the meta element in the page source, you can confirm that CSP is enabled for your Knowledge base site.

<a id="csp-guidelines-for-document360-widget"></a>

## CSP and Whitelisting guidelines for Document360 widget

**Plans supporting addition of widget**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

**Content Security Policy (CSP)** is a security feature that helps prevent attacks like Cross-Site Scripting (XSS) by allowing developers to specify which sources of content are trusted and can be loaded by the browser.

Whitelisting in software products involves specifying a list of approved entities (e.g., IP addresses, domains, email addresses) that are allowed to access certain resources or perform specific actions, thereby blocking any entities not on the list to enhance security.

### Adding trusted content sources for the Document360 widget

When using the Document360 widget, certain trusted content sources need to be added to your existing CSP. This ensures that the widget functions correctly and securely.

#### For US users

Add the following sources to your `connect-src`, `script-src-elem`, `font-src`, and `style-src-elem` directives:

```
<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Security-Policy" content="
    connect-src 
        https://jx9o5re9su-dsn.algolia.net
        https://apihub.us.document360.io/
        https://api.us.document360.io/
        https://gateway.us.document360.io
        https://*.algolianet.com
        https://js.monitor.azure.com;
    script-src-elem 
        'nonce-document360Nonce'
        https://cdn.us.document360.io
        https://*.algolianet.com
        https://cdn.jsdelivr.net
        https://cdnjs.cloudflare.com;
    font-src 
        https://fonts.gstatic.com
        https://cdn.us.document360.io;
    style-src-elem 
        'unsafe-inline'
        'unsafe-eval'
        https://cdn.us.document360.io/
        https://cdn.jsdelivr.net
        https://fonts.googleapis.com;">
</head>
</html>
```

XML

Copy

Replace `"document360Nonce"` with the nonce variable already available in your system.

#### For EU users

Add the following sources to your `connect-src`, `script-src-elem`, `font-src`, and `style-src-elem` directives:

```
<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Security-Policy" content="
    connect-src 
        https://jx9o5re9su-dsn.algolia.net
        https://apihub.document360.io/
        https://api.document360.io/
        https://gateway.document360.io
        https://*.algolianet.com
        https://js.monitor.azure.com;
    script-src-elem 
        'nonce-document360Nonce'
        https://cdn.document360.io
        https://*.algolianet.com
        https://cdn.jsdelivr.net
        https://cdnjs.cloudflare.com;
    font-src 
        https://fonts.gstatic.com
        https://cdn.document360.io;
    style-src-elem 
        'unsafe-inline'
        'unsafe-eval'
        https://cdn.document360.io/
        https://cdn.jsdelivr.net
        https://fonts.googleapis.com;">
</head>
</html>
```

XML

Copy

Replace `"document360Nonce"` with the nonce variable already available in your system.

### Updating your widget configuration

In your knowledge base portal:

1. Go to **Widget** () on the left navigation sidebar.
2. Select the required widget and click **Edit** ().
3. In the **Configure and connect** tab, expand the **Widget JavaScript** accordion under the **Connection** group.

### For US customers

Update your code as follows, replacing `"document360Nonce"` with the nonce variable already available in your system:

```
<!-- Document360 knowledge base assistant start -->
    <script nonce="document360Nonce">
        (function (w,d,s,o,f,js,fjs) {
            w['JS-Widget']=o;w[o] = w[o] || function () { (w[o].q = w[o].q || []).push(arguments) };
            js = d.createElement(s), fjs = d.getElementsByTagName(s)[0];
            js.id = o; js.src = f; js.async = 1; fjs.parentNode.insertBefore(js, fjs);
        }(window, document, 'script', 'mw', './widget.js'));
        mw('init', { nonce:'document360Nonce',apiKey: 'klhgeGoqB8wlUwq2hraJ1zbOCq/V+wBiyGQNhXEKQ6MO7V1AhLuakiEimM6ims92AR7Bqt/eOaAz3SgInMvZTkZrt3F7QaEmWtX7DDDTtIJTruZdyIv+bDBTKVuPx4BsVUavm68/y4HV7h0ahKmDgQ==' });
        //var jQuery_2_2_4 = $.noConflict(true);
    </script>
  <!-- Document360 knowledge base assistant end -->
```

XML

Copy

### For EU customers

Update your code as follows, replacing `"document360Nonce"` with the nonce variable already available in your system:

```
    <!-- Document360 knowledge base assistant start -->
    <script nonce="document360Nonce">
        (function (w,d,s,o,f,js,fjs) {
            w['JS-Widget']=o;w[o] = w[o] || function () { (w[o].q = w[o].q || []).push(arguments) };
            js = d.createElement(s), fjs = d.getElementsByTagName(s)[0];
            js.id = o; js.src = f; js.async = 1; fjs.parentNode.insertBefore(js, fjs);
        }(window, document, 'script', 'mw', './widget.js'));
        mw('init', { nonce:'document360Nonce',apiKey: 'klhgeGoqB8wlUwq2hraJ1zbOCq/V+wBiyGQNhXEKQ6MO7V1AhLuakiEimM6ims92AR7Bqt/eOaAz3SgInMvZTkZrt3F7QaEmWtX7DDDTtIJTruZdyIv+bDBTKVuPx4BsVUavm68/y4HV7h0ahKmDgQ==' });
        //var jQuery_2_2_4 = $.noConflict(true);
    </script>
  <!-- Document360 knowledge base assistant end -->
```

XML

Copy

By following these steps, you can ensure that the Document360 widget operates securely and efficiently in your environment.

---

## Troubleshooting

### Unable to view certain content on the site

**Error:** This content is blocked. Contact the site owner to fix this issue

You might encounter this issue when the CSP settings in the Knowledge Base portal block the requested content. It typically happens due to restrictions on file source URLs or incorrect CSP configurations.

**Steps to resolve:**

1. **Update the Content Security Policy:**

   a. Navigate to **Settings**() > **Users & Security** > **Security** in the **Knowledge base portal**.

   b. Under the **Content Security Policy** section, add the affected domain URL to the Source field to whitelist the required file source URLs.

   c. If you do not wish to enable this feature, toggle off the **Content Security Policy** option.
2. **Clear your browser cache:** After making changes, clear your browser cache and revisit the site to verify if the issue is resolved. It may take a few moments for the updated settings to take effect.
3. **Test the article in different environments:**

   a. Open the article in an incognito window.

   b. Test it across different browsers to confirm the issue is fixed.
4. **Review KB widget settings:** Ensure the application’s CSP settings are correctly configured to prevent errors in the Knowledge Base widget.

   If the issue persists after following these steps, please contact the Document360 support team for further assistance: [Contact Document360 Support](https://document360.com/support/)

   Provide the following details:

   a. To verify whether the CSP has been applied correctly, open the **Network** tab in your browser’s **Developer tools**.

   b. Share the details of the response headers to confirm the presence and configuration of the CSP.

---

### FAQ

#### Why is the scroll bar not showing up on the Knowledge base widget?

The issue may be related to your application’s CSP rules. If your domain is not whitelisted in your CSP, it can prevent the scroll functionality from working properly. To resolve this issue, [add the domain URL to your application’s CSP](/help/docs/csp-guidelines-for-document360-widget#adding-trusted-content-sources-for-the-document360-widget).

<a id="bot-management"></a>

## Bot management

**Plans enabled with bot management capabilities**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

A bot, short for "robot," is a software program that works on the Internet and handles repetitive tasks. While some bots are helpful, others can harm websites or apps.

## Types of bots

Bots fall into two main categories: Good Bots and Bad Bots.

• **Good Bots**: These bots, like GoogleBot, BingBot, and GPTBot, are transparent about their identity and purpose. They're often called Verified Bots.

• **Bad Bots/Malicious Bots**: These bots engage in harmful activities like scraping content, spreading spam, or perform credential stuffing attacks. Examples include bots used in DoS and DDoS attacks, web scrapers, and brute force password cracking.

---

## Bot management

Bot management involves blocking bad or malicious bots while still allowing good bots access online resources. This is crucial for keeping the online environment safe and efficient by mitigating potential threats.

### Why bot management matters?

Good bot management means legitimate users can have uninterrupted access to online resources by filtering harmful and bad bots. By spotting and stopping bad bots, it keeps servers running smoothly and makes things more secure. Plus, it helps watch for any suspicious bot activity to stop threats before they cause bigger issues.

---

## Heuristics and Machine Learning Detection

Cloudflare, as part of its security setup, utilizes both heuristics and machine learning to detect bots. This helps to proactively block malicious bots based on traffic patterns, user-agent anomalies, and other behavioral markers. By continuously analyzing incoming requests, this method effectively reduces the risk of sophisticated bot attacks.

---

## Security setup

Document360 provides enhanced security with bot detection and blocking for the knowledge base portal and knowledge base site. The bot management operates in Block mode for definite bot requests. This proactive measure prevents unwanted traffic safeguarding data integrity.

## User-Agent monitoring and IP/Port blocking

Cloudflare identifies bots using user-agent patterns. For instance, requests with empty user agents or unreleased browser versions are flagged and blocked. Additionally, if a site is accessed using unsupported port numbers, such as port 8443, Cloudflare will automatically block these attempts. Furthermore, it detects unusual traffic patterns coming from the same IP or ISP and blocks such traffic to protect against potential attacks.

> CAUTION
>
> Certain bot management measures, such as blocking specific bots or user agents, may impact custom automation scripts or integrations.

> NOTE
>
> Implementing these security measures is critical for safeguarding against malicious bot activity and maintaining the integrity of our online platforms.

<a id="fair-usage-policy-for-bot-management"></a>

## Fair usage policy for bot management

**Plans enabled with fair usage policy for bot management**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

To ensure optimal system performance and equitable access for all users, Document360 implements a Fair Usage Policy for bot management. This policy outlines the restrictions on bot usage to maintain service quality and prevent abuse.

---

## Fair usage policy details

Document360's fair usage policy includes rate limiting rules to manage bot traffic effectively and protect the application against Denial of Service (DoS) attacks. Rate limiting is used to limit the number of requests made by one user, ensuring a seamless experience for other users. These rules are designed to balance the needs of all users while maintaining system integrity.

## Rate limiting

* Maximum request limit of **1,500 requests** per **minute** per **IP address,** or
* Maximum request limit of **300 requests** per **10 seconds** per **IP address.**

Cloudflare also complements this rate-limiting process by analyzing bot activity patterns using heuristics and machine learning detection.

---

## Purpose of the policy

This policy helps ensure equitable access to our services for all users by preventing any single bot or user from monopolizing system resources. By implementing these limits, we can maintain consistent performance and availability for everyone using the platform.

## Importance of compliance

Adhering to this Fair Usage Policy is crucial for maintaining the overall health of the system. It helps prevent server overload, ensures responsive service for all users, and protects against potential abuse or unintended high-volume requests that could impact other users' experience.

---

> NOTE
>
> If you have specific use cases that may require higher limits, please contact our support team to discuss your needs and potential solutions.

<a id="using-the-text-editor"></a>

## Editor choices in Document360

**Plans supporting the use of editors**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Using the text editor in Document360 is essential for creating and managing Knowledge base articles efficiently.

Document360 allows you to draft articles in three versatile editor options:

1. The [Markdown editor](/help/docs/the-markdown-editor) lets writers use syntax and HTML to customize articles.
2. The [WYSIWYG](/help/docs/the-wysiwyg-editor) (What You See Is What You Get) editor uses rich text formatting and includes an extensive formatting toolbar; however, you cannot use custom code in articles.
3. The [Advanced WYSIWYG editor](/help/docs/advanced-wysiwyg-editor-overview) is the latest addition to the editor options in Document360 and acts as a hybrid between the Markdown and WYSIWYG editors.

Document360 ensures a user-friendly experience that enhances content clarity, consistency, and engagement.

---

## Markdown editor

The Markdown editor has a split-screen workspace and features to help you manage an article as you write it.

1. The left side of the screen is where you type and apply the Markdown syntax.
2. The preview screen on the right side allows you to view how your article will look before publishing.
3. The Scroll on indicates that both sections scroll simultaneously. Click **Scroll on** to turn off auto-scroll.
4. Click  **preview** to see how your article will appear on the Knowledge base site.
5. After publishing, you can find the **Copy link** () icon near the View in Knowledge base () icon.

Use the arrows on the divider to collapse either window of the editor.

![1_Screenshot-Markdown_editor_new_UI](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Markdown_editor_overview.png)

### Scenarios where the Markdown editor is recommended

The Markdown editor provides guided flexibility for article creation and customization and enforces a consistent writing style and formatting across the documentation. This consistency is crucial for maintaining a professional appearance in product documentation.

> **For example**, you can insert images using the toolbar, which injects the following Markdown:
>
> `![Image Alt Text] (Image URL){height="" width=""}.`
>
> You can adjust the image size by adding desired values (e.g., height="600px" width="400px"). Advanced formatting, such as shadows and borders, can be achieved with HTML customization snippets.

  

NOTE

For more information, refer to the articles on the [Markdown editor](/help/docs/markdown-editor-overview) and [Markdown basics](/help/docs/markdown-basics).

---

## WYSIWYG editor

The WYSIWYG, which stands for What You See Is What You Get, is an HTML-based editor that differs from the Markdown editor. It allows you to view the actual formatting of the article as you type or insert content.

![2_Screenshot-WYSIWYG_editor_new_UI](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-WYSIWYG_editor_overview.png)

### Scenarios where the WYSIWYG editor is recommended

If team members who contribute to articles are familiar with HTML-based editors like WordPress, this editor is relatively easy to use. Additionally, if your documentation articles contain a lot of code and media, the WYSIWYG editor provides extensive formatting options for text, images, videos, and more.

> NOTE
>
> For more information, read the article on [WYSIWYG editor](/help/docs/the-wysiwyg-editor).

---

## Advanced WYSIWYG editor

The lightweight and powerful 'Advanced WYSIWYG editor' offers rich text editing capabilities and supports Markdown syntax, providing a more visual and intuitive experience compared to the Markdown editor while maintaining flexibility similar to the WYSIWYG editor.

Type `/` in the editor, and a list of options appears. You can search for the options by typing command names. Click the desired command or press Enter key to select the command.

![3_Screenshot-Advanced_WYSIWYG_editor_new_UI](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Advanced_WYSIWYG_editor_overview.png)

### Scenarios where the Advanced WYSIWYG editor is recommended

Suppose you have Knowledge base articles with text-centric, code-heavy, and media-rich articles. In such cases, the Advanced WYSIWYG editor is a flexible alternative to the Markdown and WYSIWYG. This provides quick syntax-based editing similar to Markdown and broad text and image formatting options like the WYSIWYG editor.

> NOTE
>
> For more information, refer to the Document360 help article on [Advanced WYSIWYG editor](/help/docs/advanced-wysiwyg-editor-overview).

---

## Changing the default editor at the project level

To make the WYSIWYG/Advanced WYSIWYG editor the default editor:

1. Navigate to **Settings** () > **Knowledge base portal** > **General** in the Knowledge base portal.
2. In the **Editor** section, choose your desired editor.
3. Click **Save**.

![4_Screenshot-settingup_default_editor_in_settings](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Changing_the_default_editor_in_settings.png)

> NOTE
>
> If you change your project's default editor, all the new articles you create will be in your respective editor's choice.

---

## Switching between Markdown - WYSIWYG - Advanced WYSIWYG editor

Markdown editor is the default editor for all new projects and articles in Document360. If you want to use the WYSIWYG or Advanced WYSIWYG editor, you can switch to it at a project or article level.

### Editor switching at article-level

|  |  |
| --- | --- |
| **Possible** | * Markdown > Advanced WYSIWYG (only in 'Edit' mode) * WYSIWYG > Advanced WYSIWYG (only in 'Edit' mode) |
| **Not possible** | * Markdown > WYSIWYG * WYSIWYG > Markdown * Advanced WYSIWYG > Markdown * Advanced WYSIWYG > WYSIWYG |

To switch editors in an individual /category page, follow the below steps

1. In the article/category page, click the **More** (•••) icon, and select **More article options**.

   The **Article settings** panel will appear.
2. In the **Editor** tab, select your desired editor.
3. Select **Are you sure want to continue?** checkbox.
4. Click **Save**.

   The same steps apply to API documentation.

   5\_Screenshot-Switching\_editors

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_Screenshot-Switching_editors.png)

> NOTE
>
> Once you have switched to the Advanced WYSIWYG editor at the article level, you cannot revert the editor type for that particular article. However, for future articles, the user with the **Project Settings - Update** permission can set the default editor from **Settings** > **Knowledge base portal** > **General** > **Editor**.

---

### Handling unsupported HTML tags and attributes in the Advanced WYSIWYG editor

The Advanced WYSIWYG editor in Document360 ensures content security by managing unsupported HTML tags and attributes. Instead of removing them, the editor flags and preserves these elements for users to review and fix.

#### When does this happen?

1. **Migrating from WYSIWYG to Advanced WYSIWYG editor**

   When switching between the editors, unsupported content is automatically identified and flagged for users to address potential issues.
2. **Editing content in Advanced WYSIWYG editor**

   When unsupported tags or attributes are added in the **Code view**, the editor detects, flags, and visually marks them for correction.

#### What happens when unsupported elements are detected?

* The editor detects unsupported HTML tags (e.g., `<marquee>`, `<blink>`) and attributes (e.g., `onmouseover`, `style="text-decoration:blink"`) during parsing.
* These elements are visually flagged within the content using custom indicators, such as tooltips and block highlights, without disrupting the content structure.
* In editor, you cannot edit the desired unsupported element’s block. However, users can interact with flagged elements, receiving options to modify, remove, or correct them in the **Code view**.

**Supported tags in the Advanced WYSIWYG editor**

Below is the list of tags with custom attribute support in the Advanced WYSIWYG editor:

#### **Text formatting tags**

Tags that define or modify how text appears:

* **Abbr**: Represents abbreviations or acronyms.
* **Blockquote**: Indicates quoted content.
* **Heading**: Represents headings (e.g., `<h1>`, `<h2>`).
* **Paragraph**: Defines a paragraph of text.
* **Sub & Super Scripts**: Used for subscript (`<sub>`) and superscript (`<sup>`).
* **Inline Code**: Represents a short snippet of code within a line of text.

#### **List tags**

Tags that structure content as lists:

* **Bullet List**: Represents unordered lists (`<ul>`).
* **Ordered List**: Represents ordered lists (`<ol>`).
* **Task List**: Used for interactive or visual checklists.
* **List Items**: Represents individual list elements (`<li>`).

#### **Form and interactive tags**

Tags used for creating forms and interactive elements:

* **Input**: Defines input fields.
* **Label**: Labels associated with form elements.
* **Text Area**: Allows multi-line text input.

#### **Link and media tags**

Tags for linking or embedding media:

* **Link**: Defines hyperlinks (`<a>`).
* **Image**: Embeds images (`<img>`).
* **Video**: Embeds videos (`<video>`).
* **Object**: Embeds external resources (e.g., Flash).
* **Iframe**: Embeds inline frames (`<iframe>`).

#### **Additional tags**

Additional tags with unique purposes:

* **Div**: A generic container for grouping content.
* **Kbd**: Represents keyboard input.
* **Details**: Creates a disclosure widget for showing or hiding content.
* **Summary**: Provides a summary for the `<details>` tag.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-describing_the_unsupported_tags_in_the_Advanced_WYSIWYG_editor_.png)

---

### FAQs

#### **What is a text editor in Document360's knowledge base?**

A tool that allows team accounts to create, edit, and format content for their articles and category pages. Each editor option provides a user-friendly interface to facilitate content creation within the Knowledge base portal.

#### **What are the key features of any text editor for documentation?**

Text editors with context to knowledge bases typically offer features such as basic text formatting (bold, italics, underline, strikethrough), text type formatting (headings, callouts lists, tables), media embedding (images, videos), file attachments, code formatting, and most importantly an easy to use interface.

#### **Can I embed images and videos directly within the text editor?**

Yes, all the text editors available in Document360 support media embedding. Users can easily add images, videos, and other multimedia elements directly into their articles for better visual appeal.

#### **Can I switch between different text editor options?**

You have the option that allows you to choose the editor that best suits your preferences and needs at a project level. You can also switch the editors once at an article level, but switching back has some limitations. Please refer to the [Switching editor](https://docs.document360.com/help/docs/using-the-text-editor#switching-between-markdown---wysiwyg---advanced-wysiwyg-editor) section in this article.

#### **Do the keyboard shortcuts work in the different Document360 editors?**

Yes, each of the three editors (Markdown, WYSIWYG, and Advanced WYSIWYG editor) has its collection of keyboard shortcuts. Most conventional shortcuts universally used in tools such as Microsoft Word and Google Docs are available with the Document360 editors.

> NOTE
>
> There are plenty of shortcuts available in Advanced WYSIWYG editor, click [here](/help/docs/advanced-wysiwyg-editor-basics) to know more.

#### **How do keyboard shortcuts in the editor help in documentation?**

Keyboard shortcut, as the name implies, improves efficiency in writing by minimizing the need to use the mouse to perform specific actions and access tools in the article without your fingers leaving the device's keyboard.

#### **How do I choose the right text editor option for my knowledge base?**

Consider the following factors before selecting the editor at a project-level or article-level

* Ease of use
* Type of documentation you create
* Media files usage
* Author familiarity with the editor

#### **Will the existing articles be affected by the change in the default editor?**

Existing articles will continue to use the same editor as before, while only the newly created articles will use the newly selected default editor.

<a id="elements-of-the-editor"></a>

## Elements of the editor

**Plans supporting the use of editors**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The Document360 Knowledge base portal editor exhibits fluid interactions, a simplified interface, and an enhanced user experience.

![1_Screenshot-Fresh_new_look](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Overview_of_the_Knowledge_base_portal_editor.png)

---

### Aesthetics and Functionality

#### Switching multiple projects

Within the project section, users can view a list of projects along with their respective icons denoting the type of knowledge base.

![2_Screenshot-Project_section](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Project_section_new.png)

#### Switching Workspaces and languages

![3_Updated_Screenshot-Workspace_area](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_New_Screenshot-Switching_workspaces_and_languages.png)

* The options for Workspace and Language are merged in the dropdown menu at the workspace.
* The Workspace name is displayed alongside the flag representing the language.
* From the dropdown, you can select the desired workspace and language.
* Clicking **Manage workspace & language** redirects you to the [**Localization and Workspaces**](/docs/localization-workspace) section in the settings.

  > NOTE
  >
  > The **Create** button is available in the header. With this, you can create a category, new article, article from template or import articles.

---

## Left navigation bar: Category tree manager

![4_Screenshot-Left_navigation_bar](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Left_navigation_bar_in_the_Knowledge_bse_portal.png)

1. The left navigation bar includes key sections such as Dashboard (), Documentation (), API Documentation (), Analytics (), Widgets (), Drive (), and Settings ().
2. At the top of **Categories & Articles** section, you will find the following options:

   * [All articles](/help/docs/all-articles-overview-page) ()
   * [Workflow assignments](/help/docs/workflow-assignment) ()
   * [Starred](/help/docs/starred-categories) ()
   * [Recycle bin](/help/docs/recycle-bin-recent-and-starred-files) ()
   * [Site builder](/help/docs/customize-site) ()
   * [Content tools](/help/docs/content-tools) ()

   The **Site builder** feature, now part of the category tree manager, redirects you to the **Customize site** section in the settings.
3. The **Categories & Articles** section is where all articles and categories are created. Recent enhancements to the **More options** () menu provide a more user-friendly and intuitive interface for improved usability.

> NOTE
>
> For more information, read the article on [Knowledge base portal](/docs/document360-getting-started#knowledge-base-portal).

---

## Article editor’s header section

The elements are positioned to enhance usability, providing you with a more intuitive and efficient workflow:

![5_Screenshot-UI_enhancements_in_the_editor_header_section](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_Screenshot-UI_enhancements_in_the_editor_header_section.png)

1. **Slug of the article**: The article's URL/slug is displayed for easy reference.
2. **Status of the article**: The article's status is prominently positioned to provide quick insights into its current state. An article can be in **New**, **Draft**, **Published**, or **Stale** state.
3. **Article information**: You can now access article information such as contributors, stats, last updated, and created dates. Additionally, the **Manage** option allows users to manage [add or remove] contributors efficiently.
4. **Preview**: You can instantly preview the article's appearance on the knowledge base site.
5. **Title**: You can modify the article's title, URL slug, and description. Once you have made your changes, click **Update.**
6. **Recommendations**: A dropdown menu displays terms recommended by the **AI Glossary generator.**
7. **Workflow status**: You can add or update the workflow status of the articles.
8. **More menu** (•••): Here you can access additional actions such as clone article, move, hide, and delete. Moreover, SEO, tags, and Related articles are conveniently separated.
9. **Comments**: You can engage in discussions and provide feedback.
10. **View full screen**(): Allows users to view Document360 in full-screen mode.

<a id="markdown-editor-overview"></a>

## Markdown editor

**Plans supporting the use of Markdown editor**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The **Markdown Editor** uses a short-hand syntax style text to create documents and then converts that text to HTML. Markdown is useful when articles contain more text and fewer multimedia elements.

> NOTE
>
> To learn more about Markdown comments, refer to [**Basic Markdown syntax**](/help/docs/markdown-basics) article.

---

## Using Markdown in your Knowledge base

For more information on text editor options, refer to [**Editor choices in Document360**](/help/docs/using-the-text-editor)**.**

* When using the Markdown editor, you can use Markdown syntax manually while writing or formatting text using the Markdown toolbar.

  For example, you can make a text appear **Bold** by writing the respective syntax (such as `**word**` or using the **Bold** icon in the Markdown toolbar.
* When you write a syntax, ensure that the reference matches the required character arrangement.
* To learn more about Markdown syntax, read the [**Markdown basic syntax**](https://www.markdownguide.org/basic-syntax/) page.

> For example, In **Bold** syntax, no space should be present at the end or beginning of the characters mentioned inside the syntax.  
> `**Text**` and not `** Text **`
>
> In **Headings**, a space is required between the respective syntax and characters.  
> `### Heading3` and not `###Heading3`

---

## Markdown toolbar

The WYSIWYG toolbar offers various options to edit and format your text including the option to insert media files as well. The different toolbar sections and their uses are shown and elaborated below.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenShot-Markdown_Editor.png)

* **Headings**
* **Basic text formatting**
* **List**
* **Insert**
* **Callouts**
* **Private notes**
* **Find and replace**
* **Insert LaTeX**
* **Content reuse**
* **Code block**
* **Glossary**
* **Video**

### Headings

* **H2**: Refers to **Heading 2**
* **H3**: Refers to **Heading 3**
* **H4**: Refers to **Heading 4**

### Basic text formatting

* **Bold:** To **Bold** the text.
* **Italic:** To *Italicize* the text.
* **Strikethrough:** To ~~Strikethrough~~ the text.
* **Blockquote:** To offset a quote or paragraph with a line. For example, the below sentence is in **Blockquote**:

  > This is an example of Blockquote.
* **Line**: To insert a line in the article.

### List

* **Unordered list:** To make a list denoted with bullet points for each item.
* **Ordered list:** To make a list denoted with numbers for each item.

### Insert

* **Insert Table:** To add a table to the article.
* **Insert image:** To insert an image from the URL, local Drive, or Document360 Drive.
* **Insert file:** To insert a PDF or Word document from the Drive.
* **Insert a link:** Add a hyperlink from a provided URL or a Knowledge base article to the selected text.

### Callouts

* **Info**: To insert an editable blue info box. You can use this to add additional information.
* **Warning:** To insert an editable yellow warning box. You can use this to add important information.
* **Error:** To insert an editable red error box. You can use this to add essential information.

### Private notes

* **Private notes**: To insert an editable purple internal comment box that will only be visible to logged-in team members.

> **For example**, you can add internal feedback to the respective team members.

### Insert LaTeX

* **Insert LaTeX**: To add expressions and equations,

  1. Click on **Insert LaTeX** option and a sample latex syntax (a² + b² = c²) appears.
  2. Type in your desired syntax.
  3. The syntax must start and end with **$**.
  > NOTE
  >
  > Don't add a space between $ and syntax.

  + [**Read the help article**](http://docs.mathjax.org/en/latest/input/tex/macros/index.html) to view the basic latex commands used in latex syntax.

### Find and Replace

* **Find and Replace:** Search a text within your article and replace it with another text. You can also use this to find the article's text content occurrences. This is particularly handy in long articles.

### Content reuse

* **Content reuse:** To reuse the content across the project. Two content reuse options are available:  
  a. **Variable**: Only text content can be added inside a variable.  
  b. **Snippet**: You can add images, tables, etc., inside a snippet.

### Codeblock

* **Insert Codeblock**: Add a code block to your article.

### Glossary

* **Glossary:** Add a glossary to your article.

### Video

* **Insert Video**: To embed a video from YouTube, Wistia, or Vimeo.

### Scroll

* **Scroll on/off:** To enable or disable simultaneous scroll functionality for both the editor and the article preview sections.

---

### Spell checker in Markdown

1. Right-click on the misspelled word.
2. The suggestions for corrections will be displayed through your browser's native functions.
3. Click on the suggested correction to apply it as needed.

   ![5_Screenshot-Markdown_Spell_checker](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_Screenshot-Markdown_Spell_checker.png)

---

### FAQs

#### What is a Markdown editor, and how does it differ from a regular text editor?

Markdown editor is a specialized text editor designed to simplify the process of writing in Markdown language — a lightweight markup language that converts plain text into HTML. Unlike regular text editors, Markdown editors provide live previews, making it easier to visualize how the content will appear once published. You can experience the full potential of the Markdown editor on Document360 using the customization solution objects help articles we offer.

#### What are the key features of the Markdown editor in Document360?

Markdown editor in Document360 includes real-time previews, syntax highlighting, keyboard shortcuts, drag-and-drop image support, and seamless integration with the article version control (revisions) feature.

#### Is a Markdown editor suitable for beginners with no syntax-based writing experience?

Absolutely! Markdown's simple syntax makes it accessible for beginners without coding experience. Its intuitive structure allows users to focus on content creation without learning complex markup languages.

#### How do I add ASCII code to my article?

You can add ASCII code to your article using the **Code Block** feature.

#### Is it possible to add a code block without any heading?

Yes, when using Markdown editor, you can add code blocks in your article without necessarily having any heading.

#### Can I use the HTML content in the Markdown editor?

Yes, you can use HTML content in the Markdown editor. However, using Markdown syntax in the Markdown editor is recommended to avoid inconsistency.

---

## Related blogs

#### [1. The Ins and Outs of Using Markdown for Technical Writing](https://document360.com/blog/markdown-for-technical-writing/)

#### [2. Introductory Guide to Markdown for Documentation Writers](https://document360.com/blog/introductory-guide-to-markdown-for-documentation-writers/)

A lightweight text-to-HTML conversion tool used to format content such as lists, headers, images, videos, and links. Document360 includes a powerful markdown editor as one of its two basic editors.

<a id="markdown-basics"></a>

## Basic Markdown syntax

**Plans supporting the use of Markdown editor**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The Markdown editor is a powerful tool for creating clear, organized, and professional content in Document360. Whether you are new to Markdown or already familiar, this article will help you learn the basic commands and formatting options step by step.

Markdown is a lightweight markup language that lets you format text easily using special characters. You don't need coding knowledge to use it—just follow the syntax provided in this guide to create headings, lists, links, and more.

---

## Markdown commands

To format your text using Markdown commands, follow the table below to understand how to type Markdown commands and what they do. Here, **syntax** represents the way you type the content in your editor. You can use the examples in the **Example** column as reference.

For some Markdown commands, you also have alternate keyboard shortcuts, which you can use to quickly format your text. You can find these shortcuts in the **Notes** column in the below table.

| Feature | Syntax | Example | Output | Notes |
| --- | --- | --- | --- | --- |
| **Headings (H2, H3, H4)** | `##`, `###`, `####` before the text | `## Heading 2` | Heading 2 | This syntax helps in creating section titles. Use 1-6 hash symbols for heading levels. Document360 restricts H1 for article titles. |
| **Bold** | `**text**` | `**bold**` | **bold** | This syntax helps emphasize important text. Shortcut: Ctrl+B / Cmd+B |
| **Italics** | `*text*` or `_text_` | `*italics*` | *italics* | This syntax helps highlight text subtly. Shortcut: Ctrl+I / Cmd+I |
| **Strikethrough** | `~~text~~` | `~~strikethrough~~` | ~~strikethrough~~ | This syntax helps to cross out text. No shortcut available |
| **Numbered List** | `1.` followed by text | `1. First item` | 1. First item | Numbered lists automatically increment |
| **Bulleted List** | `*` or `-` followed by text | `* Bullet item` | \* Bullet item | Use an asterisk `*` or a hyphen `-` |
| **Link** | `[text](URL)` | `[Document360](https://docs.document360.com)` | [Document360](https://docs.document360.com) | Links are displayed as clickable text |
| **Blockquote** | `>` before text | `> This is a quote` | Creates a callout/blockquote | For quoting or highlighting text |
| **Horizontal Line** | `***` | `***` | Creates a horizontal line | Used to separate sections |

---

## Heading levels

| Heading Level | Syntax | Example | Output |
| --- | --- | --- | --- |
| H2 | `## Heading 2` | `## This is Heading 2` | This is Heading 2 |
| H3 | `### Heading 3` | `### This is Heading 3` | This is Heading 3 |
| H4 | `#### Heading 4` | `#### This is Heading 4` | This is Heading 4 |

TIP

Ensure a blank line above Heading tags and a space between hash symbols and text.

---

## Styling text

| Style | Syntax | Example | Output |
| --- | --- | --- | --- |
| **Bold** | `**text**` | `**bold text**` | **bold text** |
| *Italics* | `*text*` or `_text_` | `*italic text*` or `_italic text_` | *italic text* or *italic text* |
| ~~Strikethrough~~ | `~~text~~` | `~~strikethrough text~~` | ~~strikethrough text~~ |
| **Highlight** | `==text==` | `==highlighted text==` | ==highlighted text== |
| **Superscript** | `text^superscript` | `E = mc^2` | E = mc2 |
| **Subscript** | `text~subscript` | `H~2~O` | H2O |

TIP

Avoid spaces between syntax and text for proper styling.

---

## Lists

| List Type | Syntax | Example | Output | Description |
| --- | --- | --- | --- | --- |
| **Numbered List** | `1. Item` | `1. First item` | 1. First item | Automatically increments numbers for each item. |
|  | `2. Item` | `2. Second item` | 2. Second item | Use this format for each subsequent item. |
|  | `3. Item` | `3. Third item` | 3. Third item |  |
| **Bulleted List** | `* Item` | `* Bullet item` | - Bullet item | Use an asterisk (`*`), hyphen (`-`), or plus (`+`). |
|  | `- Item` | `- Another bullet item` | - Another bullet item | Any of these symbols will create a bulleted item. |
|  | `+ Item` | `+ Yet another bullet item` | + Yet another bullet item |  |

---

## Links and blockquotes

| Feature | Syntax | Example | Output |
| --- | --- | --- | --- |
| Link | `[text](URL)` | `[Document360](https://docs.document360.com)` | [Document360](https://docs.document360.com) |

**Blockquote**  
Include quotes or highlight important points by using '>' before the text.  
`> This will quote the entire line of text`  
Output:

> This will quote the entire line of text

---

## Horizontal line

You can enter a horizontal line to divide two lines of text using the three asterisks.

`***`  
Output:

---

## Quick tips for beginners

1. Use Headings to structure your content (e.g., sections and subsections).
   * Example: Use `##` for large headings and `###` for smaller ones.
2. Highlight key points with **Bold** or *Italics* to make the text easier to read.
3. Add Lists to organize information.
   * Use `1.` for numbered lists or `*` for bullet points.
4. Use **Links** to direct users to additional resources or websites.

---

## More elements

| Feature | Syntax | Example |
| --- | --- | --- |
| Image | `![Alt text](URL "Optional title")` | `![Logo](https://example.com/logo.png "Logo")` |
| Reference Link | `[Link text][ref]``[ref]: URL` | `[Document360][doc]``[doc]: https://docs.document360.com` |
| Escaping Characters (to avoid special characters being processed) | `\character` | `\*This is not italic\*` |
| YouTube Video | `<iframe src="https://www.youtube.com/embed/VIDEO_ID" width="560" height="315" frameborder="0" allowfullscreen></iframe>` | `<iframe src="https://www.youtube.com/embed/dQw4w9WgXcQ" width="560" height="315" frameborder="0" allowfullscreen></iframe>` |
| Vimeo Video | `<iframe src="https://player.vimeo.com/video/VIDEO_ID" width="640" height="360" frameborder="0" allowfullscreen></iframe>` | `<iframe src="https://player.vimeo.com/video/76979871" width="640" height="360" frameborder="0" allowfullscreen></iframe>` |

If you're unsure about HTML, simply copy and paste the examples provided, replacing the URL with your own video link.

---

## Emoji usage

You can copy and paste the emojis directly into your document from the table below.

| **Emoji** | **Description** |
| --- | --- |
| 📝 | Memo |
| ✍️ | Writing Hand |
| 📄 | Page Facing Up |
| 📚 | Books |
| 📖 | Open Book |
| 🖋️ | Fountain Pen |
| 📑 | Bookmark Tabs |
| 🔍 | Magnifying Glass |
| 📅 | Calendar |
| 💻 | Laptop |
| 📊 | Bar Chart |
| 📈 | Chart with Upwards Trend |
| 🗂️ | Card Index Dividers |
| ✏️ | Pencil |
| 😊 | Smiling Face |
| ❤️ | Red Heart |
| 🌟 | Star |
| 🔥 | Fire |
| 🎉 | Party Popper |

Simply copy the emoji you want and paste it wherever you need it! You can also insert icons into your editor by pasting the HTML code from FontAwesome.

---

## Using Unicode characters in the Markdown editor

Unicode characters help you add symbols, special characters, and non-Latin scripts to your Markdown documents. This includes currency symbols, mathematical operators, arrows, and accented letters, which enhance your content's clarity and style.

### Syntax for inserting Unicode characters

In the Markdown editor, you can insert Unicode characters using either of the following methods:

1. **Direct copy-paste:** Copy the desired character from any Unicode reference site and paste it directly into your Markdown content.

   **Example:**

   ```
   ★ Star symbol

   ```

   Plain text

   Copy

   **Output:**  
   ★ Star symbol
2. **HTML entity code:** Use the Unicode hexadecimal code with the format `&#xXXXX;`, where `XXXX` is the character's hex code.

   **Example:**

   ```
   &amp;#x1F680; Rocket symbol

   ```

   Plain text

   Copy

   **Output:**  
   🚀 Rocket symbol

### Common Unicode characters

Here are some frequently used Unicode characters:

| Character | Description | Unicode (Hex) | HTML entity code |
| --- | --- | --- | --- |
| ★ | Star symbol | 2605 | `&#x2605;` |
| ✔ | Check mark | 2714 | `&#x2714;` |
| ✉ | Envelope | 2709 | `&#x2709;` |
| © | Copyright | 00A9 | `&#x00A9;` |
| € | Euro sign | 20AC | `&#x20AC;` |
| → | Right arrow | 2192 | `&#x2192;` |
| ♻ | Recycling symbol | 267B | `&#x267B;` |

#### Finding more Unicode characters

For an extensive list of Unicode characters and their corresponding codes, refer to the following resources:

* [Unicode Character Table](https://unicode-table.com/)
* [Unicode.org Code Charts](https://www.unicode.org/charts/)

Copy the character you need and paste it into your Markdown document, or use its HTML entity code for precise control.

---

## Example: Creating a simple article

Let’s bring it all together with an example.

```
#### Welcome to Markdown  
Learn how to use **Markdown** in Document360 to format your articles.  

#### Why use Markdown?  
* Easy to learn  
* Clean and organized formatting  
* Saves time  

#### Useful tips  
1. Use headings to structure your content.  
2. Add links for more resources: [Learn Markdown](https://markdownguide.org)  
3. Use `***` to create a divider.  

```

Plain text

Copy

### Output

#### Welcome to Markdown

Learn how to use **Markdown** in Document360 to format your articles.

#### Why use Markdown?

* Easy to learn
* Clean and organized formatting
* Saves time

#### Useful tips

1. Use headings to structure your content.
2. Add links for more resources: [Learn Markdown](https://markdownguide.org)
3. Use `***` to create a divider.

---

For more advanced Markdown syntax commands, refer to the official [Markdown syntax guide](https://www.markdownguide.org/basic-syntax/). With these tips, you’ll be formatting your articles like a pro in no time!

Tags in Document360 used to structure subheadings in an article. H1 is automatically applied to article titles and cannot be used in the editor. H2, H3, and H4 are available for creating subheadings, with each level displaying progressively smaller text.

A lightweight text-to-HTML conversion tool used to format content such as lists, headers, images, videos, and links. Document360 includes a powerful markdown editor as one of its two basic editors.

<a id="wysiwyg-editor"></a>

## WYSIWYG editor

**Plans supporting the use of WYSIWYG editor**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The **WYSIWYG (What You See Is What You Get)** editor, also known as the HTML editor, is one of three editing options in Document360. It allows users to view content as it will appear on published articles or category pages within the Knowledge base site.

> NOTE
>
> You cannot switch from the WYSIWYG editor to the Markdown editor. Once articles are converted from Markdown to WYSIWYG, they cannot be reverted. However, switching from Markdown to WYSIWYG is possible.

---

## WYSIWYG toolbar

The WYSIWYG toolbar offers various options to edit and format your text including the option to insert media files as well. The different toolbar sections and their uses are shown and elaborated below.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenShot-WYSIWYG_Editor(1).png)

### 1. Heading options

The below heading options are available:

Normal

## Heading 2

### Heading 3

#### Heading 4

### 2. Text formatting

The below text styling options are available:

* **Bold**: To Bold the text
* *Italic*: To Italicize the text
* Underline: To Underline the text
* ~~Strikethrough~~: To Strikethrough the text
* **More text**: Provides options to update font size, font family, text color, background color, subscript, superscript, and clear formatting.

### 3. Paragraph formatting

The below paragraph formatting options are available:

* **Unordered list**: Make a list denoted with the following symbols: •, ○, ◘. **Disc** and **Default** symbols are the same.
* **Ordered list**: Make a list denoted with numbering for each item. You can use numbers, alphabets, Roman numerals, and Greek numerals. Default refers to numbers.
* **More paragraph**: To update alignment, line height of paragraphs, indentations, and quote text.

### 4. Insert options

* **Insert link**: Add a hyperlink from a provided URL or Knowledge base article to the selected text. This is useful for referencing additional information.
* **Insert codeblock**: Add a codeblock to your article, such as a JavaScript snippet.
* **Insert image**: Insert an image from the URL, local storage, or Drive. For example, you can add a screenshot of the user interface. You can also use (Ctrl+p) to perform this action.
* **Insert file**: Add a {{glossary.File}} from the Drive, such as a Word or PDF file.
* **Insert callouts**: Add editable info boxes in blue, yellow, and red for additional, important, and essential information, respectively.
* **Private notes**: Insert an editable internal comment box visible only to logged-in team members for internal feedback.
* **Insert LaTeX**: Add mathematical expressions and equations using LaTeX syntax.

  + To add, click the **Insert LaTeX** option and an **Insert latex expression** window appears. Type in your desired LaTeX syntax and click **Insert**. For more information, [read this article](http://docs.mathjax.org/en/latest/input/tex/macros/index.html).
  + To edit, click the Edit (Pencil) icon on the expression. An **Insert latex expression** window appears. Make the required changes in the syntax and click **Update**.
  + To delete, click the Remove (Trashbin) icon.
* **Find & replace**: Search for and replace text within your article, useful in long articles.
* **Content reuse**: Reuse content across the project with:

  + **Variable**: For text content.
  + **Snippet**: For text, images, tables, code blocks, etc.
* **Glossary**:  Maintain a list of terms and their definitions within the Knowledge base.

### **5. More rich**

* **Insert video**: Embed videos from platforms like YouTube, Wistia, Streams, or Vimeo.
* **Insert table**: Add a table by selecting the desired number of rows and columns.
* **Insert horizontal line**: Add a line in the article.
* **Emoticons**: Insert emoticons to enhance the article's engagement.

### 6. Other options

Additional features include:

* **Code view**: Switch to HTML syntax editor.
* **Undo**: Undo the previous action.
* **Redo**: Repeat the previous action.

### 7. Editor switch

* The switch editor toggle comes in use if you want to convert your article to the Advanced WYSIWYG editor.
* Click the toggle and click **Switch to New Editor** and the article will be converted to Advanced WYSIWYG editor.
* For steps and guidance on using the Advanced WYSIWYG editor, refer to the article on [Advanced WYSIWYG editor](/help/docs/advanced-wysiwyg-editor-overview).

### Additional formatting options

### 1. Image

Once an image is added to an article, you can access the below options by clicking on the image:

a. **Replace**: To replace the image.  
b. **Align**: Add an image caption to align the image.  
c. **Image caption**. This will appear at the bottom of the image.  
d. **Remove**: To remove the image.  
e. **Insert link**: To add a link to the image. After adding the link, you can open, remove, and edit the link.  
f. **Display**: To change the display of the image. You can use Inline or Break Text options.  
g. **Style**: To change the border style of the image. You can use Rounded, Bordered, and Shadow options.  
h. **Alternative text**: To add alternative text for the image. If the image file cannot be loaded, the alternative text will appear in a blank box where the image will appear.  
i. **Change size**: Adjust the width and height of the image as pixels. Click update to confirm.  
j. **Advanced edit**: To edit your image, use advanced tools such as **Crop** for resizing, **Text** options to adjust **bold**, **italic**, **underline**, **color**, and **size**, and **Rotate** to adjust orientation. You can also **Zoom in** or **Zoom out** for detailed editing, use the **Hand** tool for navigation, and access **History** for previous states. Use **Undo** and **Redo** to reverse or repeat actions, **Reset** to return to the original image, **Delete** to remove specific edits, or **Delete all** to clear everything. When finished, click **Save** to apply and store your changes.

### 2. Video

Once you embed a video in an article, you can access the below options by clicking on the left or right of the video in the editor pane:

a. **Replace**: To replace the video.  
b. **Remove**: To remove the video.  
c. **Display**: To change the display of the video. You can use Inline or Break Text options.  
d. **Align**: To align the video.  
e. **Change size**: To change the size of the video.  
f. **Autoplay**: To turn the autoplay option on or off.

### 3. PDF

Once a PDF file is added to an article, you can access the below options by clicking on the left or right side near the PDF file in the editor pane:

a. **Remove**: To remove the PDF file.  
b. **Change size**: To change the size of the PDF file.

### 4. Word file

Once a Word file is added to an article, you can access the below options by clicking on the Word file:

a. **Open link**: Download the word file to the local system drive.  
b. **Remove**: To remove the Word file.

### 5. Table

Once a table is added to an article, you can access the below options by clicking on the table:

a. **Table header**: Turn the table header on or off. Click on this button, and the top row appears on the table.

b. **Remove table**: To remove the table. Click on this button, and the table and the content will be deleted. If you have accidentally clicked on the remove, you can always use the Undo action (Ctrl + Z) to restore the table.

c. **Row**: Place the cursor in any cell of the intended row and click 'Insert row above' or 'Insert row below' to add rows to the table. Click on the 'Delete row' to remove the current row.

d. **Column**: Place the cursor in any cell of the intended column and click 'Insert column above' or 'Insert column below' to add columns to the table. Click on the 'Delete column' to remove the current column.

e. **Table style**: To change the table style. You can use **Dashed Borders** and **Alternate Rows** options. The alternate rows option would distinguish the row color.

f. **Cell**: Click on this button and select the action to merge or split cells. You can split a cell vertically or horizontally any number of times. The merge option would be enabled only when you select more than one cell horizontally or vertically.

g. **Cell background**: To change the cell's background color. You can select from the color palette available or enter the HEX code.

h. **Vertical align**: To change the vertical alignment of the content in the cell. You can do this for a single cell or multiple selections of cells. If the cell height is bigger than the content fit, then you can choose to align the content at the top, middle, or bottom of the cell.

i. **Horizontal align**: To change the horizontal alignment of the content in the cell. You can do this for a single cell or multiple selections of cells. If the cell width is bigger than the content fit, you can align the content at the left, center, right, or justified style.

j. **Cell style**: To change the type of the cell border. You can use the options **Highlighted** (changes the cell border color) and **Thick** (increases the cell border thickness) of the selected cell.

---

## When, Where, and Why to Use the WYSIWYG Editor

#### Who can use the WYSIWYG editor?

Document360 users who are comfortable with HTML editors

#### Is the WYSIWYG editor easy to use?

Using the WYSIWYG editor will feel similar to using a word-processing application

> **For example**, Microsoft Word, Google Docs, etc.

You can copy and paste content directly from a Word document or any other source. No special syntax is required.

#### Why use the WYSIWYG editor?

* Unlike the Markdown editor, the WYSIWYG editor uses a single editing pane since the written content is already in preview mode.
* WYSIWYG editor provides a unique feature to paste large tables from a third-party site or another Knowledge base.

  ###

<a id="advanced-wysiwyg-editor"></a>

## Advanced WYSIWYG editor

**Plans supporting the use of Advanced WYSIWYG editor**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The 'Advanced WYSIWYG editor' combines lightweight design with powerful, rich text editing capabilities, supporting specific Markdown syntax. It offers a highly visual and intuitive experience that surpasses traditional Markdown editors yet maintains more flexibility than the WYSIWYG editors.

> NOTE
>
> You can seamlessly switch between the Advanced WYSIWYG editor and the WYSIWYG editor when the article is in the **Draft/New** state. Document360 does not support this switching when the article is in the **Published** state.

> CAUTION
>
> The articles switched from the Markdown editor to the Advanced WYSIWYG editor cannot be reverted to the Markdown editor again.

---

## Using Advanced WYSIWYG editor

You can use the slash commands, toolbars, and specific Markdown syntax to create and edit content in the Advanced WYSIWYG editor.

### Slash commands

Type `/` in the editor, and a list of options appears. You can also search for the options by typing the command names. Click the desired command or press the Enter key to select the command.

> NOTE
>
> Ensure you type `/` at the start of a line or after a space. The options will not appear if you type it immediately after a character. You can navigate through each command and section in slash commands using the up, down, right, and left arrow keys.

You can also easily access **Eddy AI** right from the top of the slash menu. Additionally, the slash command options are categorized into three sections:

| **Format** | **Insert** | **Content Reuse** |
| --- | --- | --- |
| Heading 2 | Image | Variables |
| Heading 3 | Video | Snippets |
| Heading 4 | Link | Glossary |
| Ordered list | Table |  |
| Bullet list | Callouts |  |
| Checklist | Private notes |  |
| Inline code | Code block |  |
| Page break | Insert file |  |
|  | Accordion |  |
|  | Latex |  |
|  | Emoji |  |
|  | Divider |  |

![Updated_ScrenGIF-Slash_command_in_Adv_WYSIWYG](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Updated_ScrenGIF-Slash_command_in_Adv_WYSIWYG.gif)

---

### Markdown syntax

The Advanced WYSIWYG editor supports a wide range of Markdown syntaxes; for a detailed list, read the article on [Markdown basics](/help/docs/markdown-basics).

> For example, if you want to add a Heading 2, type the following syntax: `## Heading of the section`. The syntax will be rendered and Heading 2 will be added instantly.

> NOTE
>
> The Markdown syntax will only work when you type it in manually. It will not be rendered when you copy and paste the syntax.
>
> To view the list of unsupported Markdown syntax, read the article on [Advanced WYSIWYG editor basics](/help/docs/Advanced-WYSIWYG-editor-basics#unsupported-markdown-syntax).

---

## Toolbar

The toolbar is categorized into three sections:

* **Format**: To change the layout or appearance of the content.
* **Insert**: To add elements such as images, videos, tables, and more.
* **Find & replace**: To search for a specific text and replace it with another text.

> NOTE
>
> By selecting the Pin () option, you can anchor the toolbar to the right side of the editor interface.

![1_Screenshot-General_view_of_toolbar_in advanced_WYSIWYG_editor](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-General_view_of_toolbar_in%20advanced_WYSIWYG_editor.png)

### Format

![2_Screenshot-Format_seciton_toolbar](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Format_seciton_toolbar.png)

#### 1. Text styles

* **Undo** (): To reverse the last action.
* **Redo** (): To reapply the last undone action.

* **Clear** ( ): To remove all styling from selected text.
* **Lettercase** (): To change the letter case of the text.

#### 2. Headings

* : To apply the H2 (Heading 2) style to the selected text.
* : To apply the H3 (Heading 3) style to the selected text.
* : To apply the H4 (Heading 4) style to the selected text.
* **Paragraph** (): To apply the standard paragraph style to the selected text.

#### 3. Typography

* **Font family**: To select the typeface for the text.
* **Font size**: To adjust the size of selected text.

#### 4. Palette

* **Font color**: To change the color of the selected text.
* **Background color**: To set a background color for the selected text.

#### 5. Formatting & Lists

* **Bold** (): To bold the selected text.
* ***Italic*** (): To italicize the selected text.
* **Underline** (): To underline the selected text.
* **~~Strikethrough~~** (): To apply a strikethrough to the selected text.
* `Inline code` (): To add inline code to the text.
* **Align left** (): To align the text content with the left margin.
* **Center** (): To center your text content.
* **Align right** (): To align the text content with the right margin.
* **Justify** (): To distribute the text content evenly between the margins.
* **Bullet list** (): To add a list denoted with symbols for each item.
* **Ordered list** (): To add a list denoted with numbering for each item.
* **Checklist** (): To add a list denoted with checkboxes that users can mark as complete or incomplete.

#### 6. Controls

* **Increase indent** (): To move the content farther away from the margin.
* **Decrease indent** (): To move the content closer to the margin.
* **Subscript** (): To lower the text below the baseline.
* **Superscript** (): To raise the text above the baseline.
* **Line height** (): To choose the spacing between the lines.
* **Letter space** (): To change the spacing between the letters.
* **Line break** (): To switch to the next line.
* **Page break** (): To specify where to end the current page and begin the next page while exporting content as PDF.

---

### Insert

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1736939177920.png)

* **Image**: To insert an image.

> NOTE
>
> You can use the different tools available to format your added image. Click on the image, and the formatting tools appear as a floating menu. You can align, crop, add borders, add shadows, add captions, and more.

* **Video**: To insert a video.
* **Link**: To insert a hyperlink. You can also use the "Ctrl + k" keyboard shortcut.
* **Insert file**: To insert a file within the article.
* **Table**: To insert a table.
* **Divider**: To insert a horizontal line.
* **Accordion**: To add a container that can be expanded or collapsed to show or hide its content.
* **Callout**: To insert a callout. An info callout will be inserted when you click this option. To customize the callout, click within the callout, and you can find the following options in the contextual toolbar:

  + Callout info
  + Callout warning
  + Callout error
  + Callout success
  + Callout background color - To change the background color of the callout
  + Callout border color - To change the border color of the callout
  + Delete - To delete the callout
* **Private notes**: To insert private notes.
* **Code block**: To insert a block of code. Click within the code block, and you can find the following options in the contextual toolbar:

  + Language dropdown - Select the desired language
  + Copy - To copy the code block
  + Delete - To delete the code block
* **FAQs:** To insert the FAQ(s) templates.
* **Latex**: To insert mathematical equations and symbols.
* **Variable**: To insert a variable.
* **Snippet**: To insert a snippet.
* **Glossary**: To insert a glossary term.
* **Emoji**: To insert an emoji.

### Creating FAQs templates in Advanced WYSIWYG editor:

1. Navigate to the desired article in the Advanced WYSIWYG editor.
2. Click the **Insert (****)** icon and select **FAQs** from the dropdown.

   Three FAQ accordion templates will be inserted into your article.
3. In the inserted FAQs templates, you can perform the following options:

   1. Click the **Settings** () icon to customize the FAQ templates according to your preferences.
   2. Click the **Expand/Collapse** () icon to expand or collapse the FAQ accordions.
   3. Click the **Delete** () icon to remove the entire FAQ section.
   4. Click **Add question** ()in between the FAQs, to insert additional custom FAQs.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGif-Advanced_WYSIWYG_Editor.gif)

> NOTE
>
> * FAQs templates is different from AI FAQ generator.
> * For more information, read the article [AI FAQ generator](/help/docs/ai-faq-generator).

#### Code view

* It allows you to view and edit the content in HTML code format.
* By switching to **Code view**, you can add custom HTML elements, apply inline styles, or make precise adjustments.

  ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1736939256244.png)

> NOTE
>
> * You must click the Save button to save the changes made in the code view. `Ctrl/Cmd +S` will not work in code view.
> * Ordered and Unordered list misses out on sequential ordering.
> * Nested list types are not supported in the following scenarios:
>
>   + When the content is copied and pasted.
>   + In certain content migration scenarios.

---

### Adding an inline comment in Advanced WYSIWYG editor

1. Navigate to your desired article from the Knowledge base portal.
2. Select the desired text to add a comment, and a floating menu appears.
3. Click on the **Comment icon** (💬) from the floating menu.
4. Use basic formatting tools such as bold and lists, and by using **@** you can mention your project team members if needed.
5. Once done, click on the **Send** icon.

> NOTE
>
> To turn off this mode, navigate to the Knowledge base portal, Documentation ()> **Content tools** > **Workflow designer**. Hover over the desired status and click on the Edit (✎) icon and turn off the **Read only** toggle.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1736939279601.png)

**To view all the comments in an article:**

1. Navigate to the desired article.
2. Click on the **Comment icon** (💬) located on the right side near the publish button.
3. The Comments panel will appear. Use the dropdown at the top to filter the options, such as All comments, mentioned comments, open comments, and resolved comments.

Here, you can reply to the comments.

![6_Screenshot-View_all_the_comments_in_an_article](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/6_Screenshot-View_all_the_comments_in_an_article.png)

> NOTE
>
> Only the user who created the inline comment can edit, resolve, or delete it.

---

### Formatting Choices for Pasting from Microsoft Word

You can choose to retain or clear formatting when pasting content from Microsoft Word, including elements like lists, tables, indentations, and fonts.

1. Click **Paste with formatting** to retain the content’s format from Microsoft Word.
2. Click **Paste as plain text** to clear the content’s format from Microsoft Word.

![Copy and pasting content from Microsoft Word](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Screenshot-copy_pasting_from_Microsoft_word.png)

---

### FAQs

#### Is it possible to add a code block without any heading?

When using the Advanced WYSIWYG editor, it is not possible to add a code block without a name/heading. However, if you wish to hide the name of a code block, you can use Custom CSS code in the **Custom CSS & JavaScript** settings. Also, note that this change will apply to all the code blocks on your Knowledge base site.

To add a code block without a name/heading, you can use the Markdown editor.

#### How can I add spaces in LaTex formulas?

To insert spaces in LaTeX formulas, use `\;` (a backslash followed by a semicolon) between terms.

**Example:**  
`Area = length\;*\;width`

**Output:**

#### How can I add numbering to my content in the Advanced WYSIWYG editor?

You can add numbering to your content in three ways:

1. **Type and Press:** Type `1.` and press `space` to start numbering.
2. **Keyboard shortcut:** Select the desired content and use the shortcut `Ctrl + Shift + 7` or `Ctrl + Shift + O`.
3. **Format menu:** Select the desired content, go to **Format** () and choose the **Numbered list** () icon.

   You can choose from various numbering styles, including Default (1, 2, etc.), Lower Alpha, Lower Greek, Lower Roman, Upper Alpha, and Upper Roman.

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

<a id="advanced-wysiwyg-editor-basics"></a>

## Advanced WYSIWYG editor basics

**Plans supporting the use of Advanced WYSIWYG editor**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

## Keyboard shortcuts overview

To view the important keyboard shortcuts overview, follow these steps:

1. Navigate to the desired article on the Advanced WYSIWYG editor from the Knowledge base portal.
2. On the top-right corner click the **More** icon (•••) next to the **Publish** button.
3. Click **Keyboard shortcuts** from the dropdown menu.

#### Windows view

![image](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Keyboard_shortcuts_overview%281%29.png)

#### Mac view

![Updated_Portal_Screenshot-Mac_Keyboard_Screenshot](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Keyboard_shortcuts_overview_macos.png)

The following shortcuts can also be used in the Advanced WYSIWYG editor:

### General

| S. No. | Command | Windows | Mac |
| --- | --- | --- | --- |
| 1 | Copy | Ctrl + C | + C |
| 2 | Cut | Ctrl + X | + X |
| 3 | Paste | Ctrl + V | + V |
| 4 | Paste as plain text | Ctrl + Shift + V | + Shift + V |
| 5 | Undo | Ctrl + Z | + Z |
| 6 | Redo | Ctrl + Shift + Z | + Shift + Z |
| 7 | Add a line break | Shift + Enter | Shift + Enter |
| 8 | Insert link | Ctrl + K | + K |

### Text formatting

| S. No. | Command | Windows | Mac |
| --- | --- | --- | --- |
| 1 | Bold | Ctrl + B | + B |
| 2 | Italicize | Ctrl + I | + I |
| 3 | Underline | Ctrl + U | + U |
| 4 | Strikethrough | Ctrl + Shift + X | + Shift + X |
| 5 | Highlight | Ctrl + M | + M |
| 6 | Code | Ctrl + E | + E |

### Paragraph formatting

| S. No. | Command | Windows | Mac |
| --- | --- | --- | --- |
| 1 | Paragraph style | Ctrl + Alt + 0 | + Alt + 0 |
| 2 | Heading 1 | Ctrl + Alt + 1 | + Alt + 1 |
| 3 | Heading 2 | Ctrl + Alt + 2 | + Alt + 2 |
| 4 | Heading 3 | Ctrl + Alt + 3 | + Alt + 3 |
| 5 | Heading 4 | Ctrl + Alt + 4 | + Alt + 4 |
| 6 | Heading 5 | Ctrl + Alt + 5 | + Alt + 5 |
| 7 | Heading 6 | Ctrl + Alt + 6 | + Alt + 6 |
| 8 | Numbered list | Ctrl + Shift + 7 | + Shift + 7 |
| 9 | Bullet list | Ctrl + Shift + 8 | + Shift + 8 |
| 10 | Check list | Ctrl + Shift + 9 | + Shift + 9 |
| 11 | Blockquote | Ctrl + Shift + B | + Shift + B |
| 12 | Left align | Ctrl + Shift + L | + Shift + L |
| 13 | Center align | Ctrl + Shift + E | + Shift + E |
| 14 | Right align | Ctrl + Shift + R | + Shift + R |
| 15 | Justify | Ctrl + Shift + J | + Shift + J |
| 16 | Code block | Ctrl + Alt + C | + Alt + C |
| 17 | Subscript | Ctrl + , | + , |
| 18 | Superscript | Ctrl + . | + . |

### Text selection

| S. No. | Command | Windows | Mac |
| --- | --- | --- | --- |
| 1 | Complete article | Ctrl + A | + A |
| 2 | One character to the left | Ctrl + ← | + ← |
| 3 | One character to the right | Ctrl + → | + → |
| 4 | One line up | Ctrl + ↑ | + ↑ |
| 5 | One line down | Ctrl + ↓ | + ↓ |
| 6 | To the beginning of the article | Ctrl + Shift + Home | + Shift + Home |
| 7 | To the end of the article | Ctrl + Shift + End | + Shift + End |

---

## Typography

The following table shows the regular symbols/syntax list and its outcome in the Advanced WYSIWYG editor.

| S. No. | Name | Symbol/Syntax | Outcome |
| --- | --- | --- | --- |
| 1 | Em dash | -- | — |
| 2 | Ellipsis | ... | ... |
| 3 | Opening double quote | ' | ‘ |
| 4 | Closing double quote | ' | ’ |
| 5 | Left arrow | <- | ← |
| 6 | Right arrow | -> | → |
| 7 | copyright | (c) | © |
| 8 | Registered trademark | (r) | ® |
| 9 | Trademark | (tm) | ™ |
| 10 | Service mark | (sm) | ℠ |
| 11 | One half | 1/2 | ½ |
| 12 | One quarter | 1/4 | ¼ |
| 13 | Three quarters | 3/4 | ¼ |
| 14 | Plus minus | +/- | ± |
| 15 | Not equal | != | ≠ |
| 16 | Laquo | << | « |
| 17 | Raquo | >> | » |
| 18 | Multiplication | 2 \* 3 | 2×3 |
| 19 | Superscript two | ^2 | ² |
| 20 | Superscript three | ^3 | ³ |
| 21 | Indian rupee | (R) | ₹ |
| 22 | Dollar | (USD) | $ |
| 23 | Pound | (GBP) | £ |
| 24 | Australian dollar | (AUD) | A$ |
| 25 | Triple bar | === | ≡ |
| 26 | Approx | (approx) | ≈ |
| 27 | Greater than or equal to | >= | ≥ |
| 28 | Lesser than or equal to | <= | ≤ |
| 29 | Pi | (pi) | π |
| 30 | Euro | (e) | € |
| 31 | Equivalent | <==> | ⇔ |

---

## Unsupported markdown syntax

The Advanced WYSIWYG editor does not currently support the following markdown syntax:

**1. Tables**  
Markdown tables are not supported. For example, the following syntax will not render as a table:

```
| header | header |
| --- | --- |
| cell | cell |
| cell | cell |

```

Plain text

Copy

**2. Subscript**  
Subscript syntax is not supported directly in the editor. You will need to apply the subscript option manually using Format tools for it to appear correctly.

**3. Superscript**  
Superscript syntax is also not supported directly in the editor. You will need to apply the superscript option manually using Format tools for it to appear correctly.

<a id="movable-blocks-in-advanced-wysiwyg-editor"></a>

## Movable blocks in Advanced WYSIWYG editor

**Plans supporting the use of movable blocks**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

### **What are movable blocks?**

Movable blocks simplify editing in the Advanced WYSIWYG editor by allowing you to rearrange content sections. This feature provides more flexibility to organize your content and improve its structure efficiently.

> NOTE
>
> In the Advanced WYSIWYG editor, a block is a section of content that ends with a line break. The next piece of content that starts on a new line is considered a new block.

### Accessing movable blocks

By just clicking an arrow or a quick drag-and-drop action, you can position your content exactly how you envision it. Whether you’re shifting paragraphs or reorganizing entire sections, this flexibility allows you to craft your articles intuitively, enhancing your overall editing experience. Follow the below steps to access movable blocks.

1. Navigate to the desired article in the Advanced WYSIWYG editor.
2. Hover over the intended block within the editor.
3. On the left side of the block, you will see two icons: the settings () icon and the ellipsis () icon.
4. Click on the ellipsis () icon to manage the block’s position:

   * Move up: Click the up arrow () icon to move the block above the previous block.
   * Move down: Click the down arrow () icon to move the block below the next block.
   * Delete: Click on the delete () icon to remove the selected block. The following block will automatically move up the order.
5. Click the settings () icon to add new blocks:

   * Choose **Insert block above** to place a new block above the selected one.
   * Choose **Insert block below** to place a new block below the selected one.

> NOTE
>
> By holding the reorder icon () icon of a specific block, you can drag it to any desired location within the editor.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenGIF-Movable_blocks_all_in_one.gif)

> NOTE
>
> * In the current implementation, dividers cannot be moved using Movable blocks.
> * The entire FAQ section is considered as a single block. Therefore, you cannot move individual FAQs within the Eddy AI generated FAQ section.

---

### FAQs

**How do I move a block to a specific location in the Advanced WYSIWYG editor?**

  

By holding the ellipsis () icon of a specific block, you can drag it to any desired location within the editor.

**Can I add new blocks between existing content sections?**

Yes, hover over the desired block and click the settings () icon. Then, choose **Insert block above** to place a new block above the selected one.

**What happens when I delete a block in the editor?**

When you delete a block, the following block automatically moves up the order. If you want to undo the deletion, use the `Ctrl+Z` shortcut to restore the content.

<a id="conditional-content-blocks"></a>

## Conditional content blocks in Advanced WYSIWYG editor

**Plans supporting the use of Conditional content blocks**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

**Conditional content blocks** provide a powerful way to tailor the user experience by showing or hiding specific content based on predefined conditions. Whether you want to target users based on parameters like IP address, country, device type, reader groups, workspace, or specific dates, conditional content blocks ensure that your readers only see what’s relevant to them.

This feature helps streamline content management for large, diverse audiences and improves user engagement by delivering personalized content.

> For instance, use conditional content to show region-specific pricing for customers in different countries or provide different support information based on whether the user is on a desktop or mobile device.

> NOTE
>
> * This feature is exclusively available for **KB site 2.0** projects.
> * When a condition is applied to a specific content block, it will not be indexed or retrieved by Eddy AI or in general search results.

---

## Set up **conditional content blocks**

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Navigating_to_the_conditional_content_panel.png)

To set up conditional content blocks, follow the steps below:

1. Navigate to the desired article in the Advanced WYSIWYG editor within the Knowledge base portal.
2. Hover over the content block and click the **Settings** () icon on the left.
3. Select **Conditional Content**.

   The **Conditional content** panel will appear.
4. Turn on the **Enable** toggle to activate the conditional content.

   In the **Visibility** section, choose:

   * **Show**: To display content when the condition is met.
   * **Hide**: To hide content when the condition is met.
   > NOTE
   >
   > When you select **Show**, the content will be visible only to users who meet the condition. When you select **Hide**, the content will be hidden from users who meet the condition.
5. Use the **AND** operator when all conditions need to be met, and the **OR** operator if any single condition should trigger the visibility rule.
6. Click **+ Add** to create a new condition.
7. In the **Parameter** dropdown menu, select the desired parameter, such as country, date, device type, workspace, reader groups, IP address.
8. Enter the relevant value for each parameter:

| **Parameter** | **Conditions** | **Example 1** | **Example 2** |
| --- | --- | --- | --- |
| **Country** | Equals, Not equals, In, Not in | If condition is **Equals** and value is **India**, only readers from India will see the content. | If condition is **Not in** and value is **USA**, readers from all countries except the USA will see the content. |
| **Date** | After, Before, Between | If condition is **Before** and date is **October 1, 2024**, only readers accessing before that date will see the content. | If condition is **Between** and range is **September 1, 2024, to October 1, 2024**, the content will be visible during that time. |
| **Device** | Equals, Not equals, In, Not in | If condition is **Equals** and value is **Mobile**, only users on mobile devices will see the content. | If condition is **Not in** and value is **Desktop**, the content will be hidden from desktop users but visible on mobile/tablet. |
| **Workspace** | Equals, Not equals, In, Not in | If condition is **Equals** and value is **Marketing workspace**, only content in that workspace will be visible. | If condition is **Not in** and value is **Sales workspace**, the content will be hidden from users in the Sales workspace. |
| **Reader groups** | Equals, Not equals, In, Not in | If condition is **Equals** and value is **Admins**, only users in the Admin group will see the content. | If condition is **Not in** and value is **Editors**, the content will be hidden from editors but visible to other groups. |
| **IP address** | Equals, Not equals, Range, In, Not in | If condition is **Equals** and value is **192.168.1.1**, only users from that IP address will see the content. | If condition is **Range** and range is **192.168.1.1 to 192.168.1.100**, users within that IP range will see the content. |

> NOTE
>
> * **Workspace** parameter will appear only if you have multiple workspaces.
> * For parameters with conditions like **In** or **Not in**, you can select multiple values from the dropdown. For example, if the parameter is **Country**, condition is **In** or **Not in**, you can select multiple countries in the Value dropdown.

10. Once you have set the condition for your content, click **Save for reuse** to save the condition.

> NOTE
>
> The **Save for reuse** is especially useful in large knowledge bases where similar conditions apply across multiple articles. For instance, a **Country equals India** condition can be saved and reused for all India-specific content, saving time and effort.

11. Enter a name for your condition and click the () icon.
12. Click **Save** to apply the condition, which will then be reflected on the Knowledge base site.
13. Click **Save as** to save the condition for future use, enter the condition name and click the () icon.
14. To remove a condition, click **Remove Condition** within the selected block.
15. Once done, click **Apply**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGIF-Performing_Conditional_content.gif)

---

### FAQs

**What are conditional content blocks?**

Conditional content blocks allow you to display specific content only when certain conditions are met, based on parameters like IP address, country, device type, reader groups, workspace, or specific dates.

**Can I create multiple conditions for a single article?**

Yes, you can create up to 25 conditions per article.

**Will the conditions remain intact if I move an article to a different workspace?**

Yes, the conditions will move along with the article to the new workspace.

**Can I edit conditions after publishing?**

To edit content conditions after publishing, fork the published article version. Once forked, you can modify the conditions as needed.

**If an article is translated into multiple languages, does conditional content apply to all languages?**

Yes, the conditions set on a content block will apply across all translated versions of the article. However, if different visibility rules are needed for different languages, you will need to apply conditions specifically for each translation.

**What happens if no conditions are met?**

If no conditions are met, the content block will behave according to the default visibility rules. By default, the block will be visible to all users unless explicitly set to **Hide** for all conditions.

**If I change the project type from Private to Public, what happens to the conditions?**

If your project type changes from **Private to Public**, any conditions using parameters like **IP address** or **Reader groups** (which are only applicable in private/mixed projects) will be automatically disabled, and those parameters will no longer be available for selection.

**What happens to conditional content if I clone a article?**

If you clone a article that contains conditional content blocks, all the conditions will be copied over as they are. You can then edit the conditions in the duplicated article if needed.

**Can I apply multiple "Or" conditions?**

Yes, you can apply multiple **OR** conditions. For example, if you want to show content to users in either **India** or **USA**, you can set the condition **Country equals India OR Country equals USA**. The content will be visible to users from either country.

**Can conditions be time-bound?**

Yes, conditions can be time-bound by using the **Date** parameter. For example, if you want content to be visible only between specific dates, you can set the condition **Date between Dec 1, 2024, and Dec 10, 2024**. The content will automatically stop being visible after Dec 10, 2024.

**What happens if I delete a reader group that is part of a condition?**

If a reader group that is part of a conditional content block is deleted, the condition associated with that group will no longer be applied.

**Can I apply conditions based on the user's session (e.g., logged-in vs. logged-out users)?**

At this time, conditional content does not apply directly to user session status (logged-in or logged-out).

**If I move an article with conditional content between workspaces, do the conditions still apply?**

Yes, the conditional content blocks and their conditions will move along with the article when it is transferred between workspaces. However, you should verify that the conditions are still relevant in the new workspace.

**How do conditions affect articles that have multiple versions (e.g., published and draft versions)?**

Conditional content settings are version-specific. If you fork an article to create a new version, the conditions set in the original version will carry over to the new version. You can then edit the conditions in the new version as needed.

**Is there a limit to the number of conditions I can apply to a single block?**

Yes, you can apply up to 25 conditions per article. However, for performance and clarity, it is recommended to limit the number of complex conditions to ensure that content loads efficiently and is easy to manage.

<a id="tables-in-advanced-wysiwyg-editor"></a>

## Tables in Advanced WYSIWYG editor

**Plans supporting the use of Advanced WYSIWYG editor**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Tables are an essential tool for organizing and presenting data in a clear, structured format. Whether you're comparing features, listing options, or summarizing information, tables enhance content readability and make complex data easier to understand.

The Advanced WYSIWYG editor offers a range of powerful table formatting and management features designed to help you easily create visually appealing and functional tables. From adding rows and columns to customizing cell colors and implementing advanced table styles, these features help you create tables that meet your specific needs.

In this article, we will explore the various table-related tools available in the Advanced WYSIWYG editor, providing you the steps to create, format, and manage tables.

## Creating a table

There are two methods for creating a table. You can use the

* **Slash (/) command**
* **Insert option** in the **Format menu**

### Slash (/) command

To insert a table using the slash command, type the slash command **(/table)** anywhere in the editor, and hit **Enter**. This inserts a **3X3** table in the editor at the text cursor’s location.

> NOTE
>
> Inserting a table using the **slash** (/) command will always insert a 3X3 table with a header row by default. You can insert more rows and columns as per your requirement.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_GIF-Insert_table_using_slash_command.gif)

### Insert option in the Format menu

To insert a table using the Format menu,

1. Click the **Insert** option in the Format menu on the right side of the editor to open the Insert menu.
2. From the Insert menu, click on the **Table** option.
3. Clicking the Table option opens the **Insert table** grid. Select the desired table size from the grid to insert the table in the editor.

> NOTE
>
> The maximum table size you can create from the Format menu is a **10X10** table. You can add additional rows/columns manually.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_GIF-Insert_table_using_format_menu.gif)

## Formatting table content

### Inserting or deleting rows/columns

To insert a row, select an entire row. In the menu that appears upon selecting the row, click **Insert row above/Insert row below** based on your requirement. Similarly, to insert a column, select an entire column. In the menu that appears upon selecting the column, click **Insert column left/Insert column right** based on your requirement.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Insert_row_in_tables.png)

Select the entire row, then click **Delete row** in the menu. You can delete a column using the same steps after selecting a column.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Insert_column_in_tables.png)

### Merging cells

To merge cells, select multiple cells in the table. After selecting multiple cells, click **Merge cells** in the menu. Once you click the **Merge cells** option, the selected cells will be combined together into one cell.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_Screenshot-Merge_cells_in_tables.png)

### Cell alignment

To align text within a cell, select one or more cells, and select the alignment option that appears in the menu. There are two alignment options available: **Vertical align** and **Horizontal align**.

#### Vertical align

If you select the **Vertical align** option, you can align the text to either the **Top**, **Middle**, or **Bottom** of the cell.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/6_Screenshot-Vertical_alignment_in_tables.png)

#### Horizontal align

If you select the **Horizontal align** option, there are four options available: **Left**, **Center**, **Right**, and **Justify**. If you select either **Left**, **Center**, or **Right**, the text will be aligned accordingly. If you select **Justify**, the text will be aligned to the left, while the text will be equally spaced to cover the entire width of the cell.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/7_Screenshot-Horizontal_alignment_in_tables.png)

### Fit table to page width

To fit a table to the page width, select the table. In the menu that appears upon selecting the table, click the **Fit to page width** option. This will automatically adjust the table to span the full width of the page, ensuring the content within the table is evenly distributed across the available space.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/16_Screenshot-Fit_table_to_page_width.png)

---

## Customizing table appearance

### Changing background

1. To change the cell background color, select one or more cells.
2. In the menu that appears, click the **Background color** option.
3. Select the desired color from the displayed color palette.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/8_Screenshot-Background_color_in_tables.png)

> PRO TIP
>
> Once you make updates to the background color in tables, check the article preview in dark mode to verify the table’s visibility.

### Changing border

#### Border color

1. To change the cell border color, select one or more cells.
2. In the menu that appears, click the **Border color** option.
3. Select the desired color from the displayed color palette.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/9_Screenshot-Border_color_in_tables.png)

#### Border style

1. To change the border style, select the entire table.
2. In the menu that appears, click the **Border style** option.
3. Choose your preferred border style: **Solid**, **Dashed**, or **Dotted**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/10_Screenshot-Border_style_in_tables.png)

### Header rows

The top row is a header row by default when you insert a table in the Advanced WYSIWYG editor. The header row is indicated with the grey background.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/11_Screenshot-Header_row_in_tables.png)

* If you want to hide the header row, select the entire table and click the **Hide table header** option.

  ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/12_Screenshot-Hide_header_row_in_tables.png)
* If you have hidden the header row and wish to show it again, select the entire table and click the **Show table header** option.

  ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/13_Screenshot-Show_header_row_in_tables.png)

### Alternate row style

To customize your tables even further, you can choose to have banded rows. If you implement this option, the color of your rows will alternate between white and light gray.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/14_Screenshot-Banded_rows_in_tables.png)

1. To implement this customization, select the entire table.
2. In the menu that appears, click the **Alternate row style** option.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/15_Screenshot-Alternate_rows_in_tables.png)

> PRO TIP
>
> You can customize your tables even further using **CSS code snippets**. To learn more, visit the [**Table Style**](https://docs.document360.com/docs/table-style) article.

---

### FAQs

#### **How do I copy the entire table?**

To copy the table, select the entire table and click the **Copy** option that appears in the menu.

#### **How do I delete the entire table?**

To delete a table: Select the table by clicking the top-left corner. Then, choose **Delete** from the menu that appears.

#### **Can I use automatic number in a table?**

While numbered lists are possible within a cell, you cannot apply automatic number for rows in a table.

#### **Can I add symbols or icons in a table?**

Yes, you can add symbols and icons in a table. For in-built symbols/icons, you can them directly from the **Format** menu. Symbols and icons from external sources can be added using **HTML**. To add symbols/icons in HTML,

1. Switch to **Code view** within the editor.
2. Place the text cursor in the desired location.
3. Paste the HTML code for the required symbol/icon.

Now, the symbol/icon should be visible within the table in the editor.

#### **Will slash commands work inside a table?**

Yes, all the slash commands will work inside a table.

#### Can I paste tables from Microsoft Word or Excel?

Document360 supports pasting tables from Microsoft Word and the web application of Microsoft Excel directly in the editor while retaining their structure.

At this time, pasting tables from the desktop application of Microsoft Excel is not supported. If you need to insert a table from Excel, we recommend using the web application, while will allow you to directly paste the table in Document360 without loss of formatting.

<a id="image-formatting-in-the-advanced-wysiwyg-editor"></a>

## Image formatting in the Advanced WYSIWYG editor

**Plans supporting formatting images in the Advanced WYSIWYG editor**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Unlike the Markdown editor, the Advanced WYSIWYG editor offers different image formatting options. You can access the image formatting options when you click an image you wish to edit.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-floating_menu_in_image.png)

Click on the image, and you’ll have a floating menu with the following features to edit the selected image:

1. **Align**

   There are three common alignment options available for images:

   * **Align Left** ()**:** Aligns the image to the left side of the content.
   * **Center** ()**:** Centers the image within the content.
   * **Align Right** ()**:** Aligns the image to the right side of the content.
2. **Inline left** (), **Inline block** (), and **Inline right** ():

   When you select an inline display option, the image aligns side by side with the text. The alignment (left or right) places the image on the corresponding side of the text, while the inline block option keeps the image within the text flow without disrupting the layout.
3. **Image caption** ():

   You can add a caption to your image, which will appear at the bottom of the image. This is useful for providing additional context or descriptions.
4. **Alt text** ()**:**

   Also known as alt tags or alt descriptions, alt text is the written copy that appears in place of an image if it fails to load on a user's screen.

   Enter the alternative text for the image and click the () icon to save it.
5. **Hyperlinking images** ()**:**

   Click on the link icon to add hyperlinks to your images. Paste the URL and select the **Open in a new tab** box below if you want the link to be opened in a **new tab** and click **Insert**. After linking your image, three new options will appear in the formatting tray:

   * **Open Link:** Opens the link in a new tab.
   * **Edit Link:** Edits the attached link.
   * **Unlink:** Removes the link from the image.
6. Click on the [**Advanced edit**](/help/docs/image-formatting-in-the-advanced-wysiwyg-editor#advanced-editing-options-for-images) () icon to edit your image such as resize, crop, etc.,
7. **Style** ():

   There are three styling options available for images:

   * **Rounded:** The image appears as a rounded rectangle with blunt corners.
   * **Bordered:** A light gray border is added to the image.
   * **Shadow:** The image casts a visible drop shadow effect.
8. **Resize** (): You can customize the width and height of the image.
9. **Replace** (): Click the **Replace** icon to switch the current image with another using any of the three insert image methods.
10. **Copy** (): Click the **Copy** icon to copy the selected image for use elsewhere in the article.
11. **Delete** (): Click the **Delete** icon to remove the selected image from the article.

### Advanced editing options for images

![Editing images in the Advanced WYSIWYG editor](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Editing_an_image(top_bottom).png)

### **1. Top menu options**

![Editing images in the Advanced WYSIWYG editor](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-top_menu_over_view.png)

1. **Zoom In/Zoom Out:** Click **Zoom In** or **Zoom Out** to adjust the image size.
2. **Hand:** Click the **Hand** icon to move the image while editing.
3. **History:** Click **History** to view the edit history of the image.
4. **Undo:** Click **Undo** to revert the most recent action.
5. **Redo:** Click **Redo** to reapply the previously undone action.
6. **Reset:** Click **Reset** to return the image to its original state, removing all edits.
7. **Delete:** Select any edited element (e.g., circle, shape) and click **Delete** to remove that particular element.
8. **Delete All:** Click **Delete All** to remove all the edited elements from the image.

---

### **2. Bottom menu options**

![Editing images in the Advanced WYSIWYG editor](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-bottom_menu_over_view.png)

1. **Resize:** Click **Resize** to adjust the width and height of the image, and lock aspect ratio. Once done, click **Apply**.
2. **Crop:** Click **Crop** to choose a cropping option such as Custom, Square, etc. Once done, click **Apply**.
3. **Flip:** Click **Flip** to select either horizontal or vertical flip. Use **Reset** to revert to the original image.
4. **Rotate:** Click **Rotate** to rotate the image between 0° to 360° (custom range available).
5. **Draw:** Click **Draw** to add lines or shapes. Options include:

   * **Free Draw:** Allows custom drawing.
   * **Straight:** Draw straight lines.
   * **Color:** Select the desired color for the drawing.
   * **Range Slider:** Adjusts the thickness of the drawing line.
6. **Shape:** Click **Shapes** to insert shapes like rectangles, circles, or triangles. Options include:

   * **Fill Color:** Choose a color to fill the shape.
   * **Stroke:** Select the outline color for the shape. You can also adjust the thickness using custom **Stroke** range slider.
7. **Icon:** Click **Icons** to add icons such as arrows, location markers, polygons, etc. You can also upload a custom icon from local storage. Adjust the icon color as needed.
8. **Text:** Click **Add** text to the image with formatting options (bold, italic, underline, alignment, color, text size).
9. **Filter:** Click **Filter** adjust image parameters such as grayscale, blur, brightness, sepia, contrast, etc., Once done, click **Save**.

---

### FAQs

**What image formatting options are available in the Advanced WYSIWYG editor?**

The Advanced WYSIWYG editor offers options such as alignment, inline display, image captions, alt text, hyperlinking, advanced edit options, styling, resizing, replacing, copying, and deleting images.

**How can I align an image in the Advanced WYSIWYG editor?**

You can align an image to the left, center, or right by selecting the corresponding alignment option from the floating menu after clicking on the image.

**Can I add a caption to my image?**

Yes, in the advanced WYSIWYG editor, you can add a caption to your image, which will appear at the bottom of the image for additional context or descriptions.

**Is it possible to hyperlink an image?**

Yes, you can hyperlink an image by clicking the link () icon, pasting the URL, and choosing to open the link in a new tab if desired.

<a id="tabs-in-the-advanced-wysiwyg-editor"></a>

## Tabs in the Advanced WYSIWYG editor

**Plans supporting Tabs in the Advanced WYSIWYG editor**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The **Tabs** feature in the Advanced WYSIWYG Editor helps writers organize related content into separate tabs within a single article. This helps to present lengthy or complex information in a clear and structured way. Readers can quickly find the content they need without scrolling through long pages, improving their experience.

---

## Creating tabs

### Adding tabs using the Insert option

To create tabs in your article,

1. Open the **Advanced WYSIWYG editor**.
2. Access the **Insert** option from either the **floating menu** or by using the **slash (/)** **command**.
3. Select **Tabs** from the available options.
4. A default tab structure with two tabs will appear in your article.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_GIF-Adding_new_tab_block.gif)

### Adding additional tabs

To add additional tabs in an existing tab structure,

1. Hover over the tab bar and click the **+ button** to add a new tab.
2. Enter a title for the new tab (up to 50 characters).
3. Repeat as needed to create multiple tabs.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_GIF-Adding_additional_tabs.gif)

> NOTE
>
> * The tabs feature requires a minimum of two tabs to function.
> * A maximum of 10 tabs can be created within a single tab structure.

### Supported elements inside tabs

You can add the following elements to your tab content,

* **Text formatting**: Use headings (H2, H3, H4), bullet lists, numbered lists, and checklists.
* **Images and videos**: Insert, resize, and manage images or videos.
* **Tables**: Add and customize rows and columns.
* **Hyperlinks**: Insert and format links for easy navigation.
* **Callouts and private notes**: Add callouts or private notes that are visible only to specific users.
* **Code blocks and inline code**: Display code snippets or inline code for technical references.
* **Variables and snippets**: Reuse content across tabs using snippets and variables.
* **Glossary terms**: Add terms with definitions visible on hover or click.
* **Other enhancements**: Use emojis, dividers, accordions, and LaTeX equations.

---

## Editing tabs

### Duplicating tabs

To duplicate a tab,

1. Click the **Edit ()** icon next to the tab name.
2. Click the **Duplicate tab** option from the menu that appears.
3. A new tab will appear next to the original tab, with the same title, content, and color. You can edit the duplicated tab as needed.

### Changing tab names

To change the name of a tab,

1. Click the **Edit ()** icon next to the tab name.
2. Hover over the **Change tab name** option in the menu that appears.
3. Enter the new name (up to 50 characters) in the **Change tab name** field. The updated tab name will automatically reflect in the tab.

### Deleting tabs

To delete a tab,

1. Click the **Edit ()** icon next to the tab name.
2. Click the **Delete tab** option in the menu that appears.

Clicking this option will delete the tab immediately. Deleted tabs can be restored using the **Undo (Ctrl + Z)** option in the editor.

> NOTE
>
> If your content block contains only two tabs, you cannot delete either tab.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_GIF-Editing_tabs.gif)

---

## Customizing tabs

### Changing tab background and border color

To change the background/border color of a tab,

1. Select the tab content block to access the tab customization options.
2. Click **Tab background color** or **Tab border color** from the customization options.
3. Use the color picker to select a background or border color. You can choose from:

   * Preset colors
   * HEX values
   * RGB values

Click **Clear** in the color picked to remove any background or border color applied to the tab.

> NOTE
>
> The selected background or border color will be applied to the entire tab content block. It is not possible to apply different background or border colors to individual tabs.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_GIF-Customizing_tabs.gif)

### Moving tabs

To rearrange the order of tabs in your article,

1. Find the tab in the list of tabs under the **Tabs** section in the editor.
2. Hover over the **six-dot drag icon** to the left of the tab name.
3. Click on the drag icon, hold it down, and move the tab to your desired position.
4. Release the cursor to drop the tab in the new location.

#### Considerations when moving tabs

Keep the following tips in mind when working with multiple tabs to ensure smooth navigation and placement:

* **Scrolling while moving tabs:** If your list of tabs extends beyond the visible area, drag the tab toward the **dark grey area** near the **right or left arrow** to scroll and access hidden sections.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_GIF-Scrolling_while_moving_tabs.gif)

* **Moving a tab to the right:** Drag the tab until a **blue line** appears in the center of the target tab’s position. Dropping the tab here will replace the target tab, and the list will automatically realign.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/6_GIF-Moving_tabs_to_the_right.gif)

* **Moving a tab to the left:** Drag the tab until the **blue line** appears in the center of the tab **immediately to the left** of the desired position. This ensures the tab is placed correctly.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/7_GIF-Moving_tabs_to_the_left.gif)

* **Moving a tab to the first position:** To place a tab at the very beginning of the list, drag it near the first tab. Hold until a **blue line** appears on top of the first tab, then drop it.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/8_GIF-Moving_tabs_to_the_first_position.gif)

> NOTE
>
> For better control, drag tabs slowly and make small adjustments to avoid accidental replacements.

---

## Viewing tabs in the Knowledge base site

You can view tabs in the Knowledge base site exactly as they are configured in the editor:

* You can switch between tabs without needing to refresh the page.
* The tab colors, titles, and layouts will appear the same across the Knowledge base site, widgets, and extensions.
* Tabs work seamlessly on mobile devices, allowing you to switch between them just as you would on a computer.
* If you export an article with tabs as a PDF, the contents of the tabs will appear sequentially, and each tab's title will be displayed as a heading.

---

### FAQ

#### Can I create tabs within another tab?

No, nested tabs are not supported. You cannot create tabs inside other tabs. This ensures the layout and functionality of the editor remain consistent.

#### Can I include tab headings in the table of contents?

No, headings within tabs will not be included in the table of contents on the Knowledge base site.

#### Can I add page breaks inside a tab?

No, the page break option is disabled within tabs to preserve the layout and structure of the content.

#### Can I use tabs inside other editor components?

No, tabs cannot be created inside certain editor controls like tables, accordions, or callouts. This restriction ensures proper functionality and layout consistency.

<a id="categories-and-subcategories"></a>

## Categories and subcategories

In Document360, Category and Subcategory is essential for organizing and displaying articles on similar topics. They function as folders that group related content, offering a structured approach to knowledge management.

Imagine you manage a product support knowledge base for an e-commerce platform. You create a category called **Shipping Information** with subcategories like **Domestic shipping**, **International shipping**, **Shipping rates**, and **Delivery times**. This structure enables customers to easily find the exact information they need, reducing frustration and improving their overall experience.

![Document360 interface showing categories, articles, and their publication statuses for user guidance.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Catagory_n_subcategory_in_portal.png)

---

### FAQs

#### What are categories and subcategories in documentation?

Categories and subcategories are organizational structures in a knowledge base used to group related articles by topic. This makes it easier for users to navigate and find relevant information.

#### How do categories and subcategories differ?

Categories represent broad topics, while subcategories provide more specific divisions within those topics. Articles are hierarchically organized under subcategories, which are grouped under their respective parent categories.

#### Why do I need subcategories?

Subcategories help segment information into smaller, focused groups, enhancing understanding, accessibility, and navigation.

**Example:** If "Cars" is the main category, subcategories like "Sedan," "SUV," and "Convertible" allow users to quickly locate content specific to their interests.

#### Can I customize the categories and subcategories?

Yes, Document360 allows team accounts to create, edit, and delete categories and subcategories based on organizational needs. Customization options include changing icons for better visual appeal.

> NOTE
>
> For more information, read the article on Managing categories.

#### How can categories and subcategories improve knowledge base usability?

Logical groupings simplify browsing, enabling readers to find relevant information without sifting through unrelated content.

#### Can a single article belong to multiple categories or subcategories?

Yes, you can display an article in multiple categories or subcategories using the **Replicate** () option in Document360.

#### What is the best practice for naming categories and subcategories?

Use clear and descriptive names that reflect the content contained within each category or subcategory. Avoid jargon and aim for user-friendly naming conventions.

#### How should I organize my categories and subcategories for optimal user experience?

Structure categories and subcategories based on logical relationships and user needs. A tree-like format broad categories divided into specific subcategories works best.

**Example:** In the Document360 Knowledge base, categories and subcategories align with the sequential flow of features and menus in the portal.

#### Can I apply different access permissions to certain categories or subcategories?

Yes, Document360 supports role-based content access control, allowing restrictions on specific categories or subcategories. If no explicit restrictions are set, permissions inherit from parent categories.

#### Is it possible to reorder categories and subcategories after they are created?

Yes, Document360 lets you reorder categories and subcategories using the drag-and-drop () icon.

#### Why is the category/subcategory not visible on my Knowledge base site? How can I resolve this issue?

A category or subcategory might not appear on the site in the following scenarios:

* All articles within it are hidden or not published.
* The category/subcategory is empty, with no articles added.

Try the below steps if the category tree fails to load on the Knowledge base site:

* Check if JavaScript is enabled in your browser settings.
* Clear your browser cache and cookies to resolve potential caching issues.
* Ensure your browser is updated to the latest version.
* Test the category tree on a different browser or device to verify if the issue is browser-specific.

Organizes related articles under a common theme in the knowledge base.

A secondary category in Document360 used to organize and display groups of related articles. Subcategories act as folders within a primary category, helping structure similar topics for better organization and navigation.

<a id="managing-categories"></a>

## Managing categories

**Plans supporting management of categories**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Organizing content effectively is key to creating a user-friendly and efficient knowledge base. In Document360, categories and subcategories play a pivotal role in structuring your documentation. Whether you’re creating, renaming, deleting, or moving categories, Document360 provides a wide range of options to customize and manage them to meet your specific needs.

Managing categories helps to create and customize category icons to advanced tasks like cloning, reordering, and starring categories for quick access. With these features, you can ensure your knowledge base remains well-organized and accessible to your team and end users.

---

## Creating a category

In the Knowledge base portal, you can create a category using one of the following methods:

1. Method 1: Using the **Create** button on the top bar
2. Method 2: Using the **Flywheel** () icon
3. Method 3: Using the **More** () icon in the **Categories & Articles** section.
4. Method 4: Using the **Create** button in **Folder/Index** type category

![Document360 interface showing options to create  categories in a workspace.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Creating_a_categories.png)

Method 1

Method 2

Method 3

Method 4

To create a category using the **Create** button on the top bar:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Click the **Create**dropdown and select **Category**.

   The **Create new category** panel will appear.
3. Enter a **Name** for the new category.
4. In the **Nest category under** the dropdown, choose the category’s position (root level or inside an existing category).
5. Click **Reset** to create the category in Root level.
6. Choose the **Type** of category (Folder, Index, Page, or GitHub).
7. Click **Create**.

   A new category or subcategory is added.

To create a category using the **Flywheel** () icon:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Hover over just below the desired category, and click the **Flywheel** () icon.
3. Click **Category**.

   The **Create new category** panel will appear.
4. Enter a **Name** for the new category.
5. In the **Nest category under** the dropdown, choose the category’s position (root level or inside an existing category).
6. Click **Reset** to create the category in Root level.
7. Choose the **Type** of category (Folder, Index, Page, or GitHub).
8. Click **Create**.

   A new category or subcategory is added.

To create a category or sub category using the **More** **(****)** icon in the **Categories & Articles**section:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Hover over the desired category, and click the **More** () icon.

   The **Create new category** panel will appear.
3. Enter a **Name** for the new category.
4. In the **Nest category under** the dropdown, choose the category’s position (root level or inside an existing category).
5. Click **Reset** to create the category in Root level.
6. Choose the **Type** of category (Folder, Index, Page, or GitHub).
7. Click **Create**.

   A new category or subcategory is added.

To create a category using the **Create** button in a Folder/Index type category:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Click the desired Folder/Index type category in the **Categories & Articles** section.
3. Click **Create** dropdown (on the right side of the category page) and select **Sub category**.

   The **Create new category** panel will appear.
4. Enter a **Name** for the new category.
5. In the **Nest category under** the dropdown, choose the category’s position (root level or inside an existing category).
6. Click **Reset** to create the category in Root level.
7. Choose the **Type** of category (Folder, Index, Page, or GitHub).
8. Click **Create**.

   A new category or subcategory is added.

![Creating a new category in the Knowledge base portal.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/10_Screenshot-Creating_a_category_panel.png)

### Subcategories level

You can create up to **seven levels** of categories (1 root category + 6 subcategory levels). The **New category** option will be disabled for subcategories beyond this limit.

![4_Screenshot-Category_manager-Subcategory_levels](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Category_manager-Subcategory_levels.png)

> **NOTE**
>
> * When you have more subcategory levels, the user will find it challenging to navigate and discover the desired article without using the **Search** option.
> * You can structure the Knowledge base based on your requirement as Document360 facilitates content discoverability using tags, all-in-one search, related articles, internal linking, cloning articles, replicating or sharing one article in multiple categories, and the starred categories/articles feature.

> TIP
>
> Use up to three subcategory levels for optimal navigation. Two subcategory levels are ideal.

---

## Changing category icon

When you create a category or subcategory, a default folder icon is assigned. You can change this icon to an emoji to better convey the category’s purpose to your end-users.

1. Navigate to the **Documentation** () in the Knowledge base portal.
2. In the left navigation panel, click the folder icon or emoji adjacent to the desired category.

   An emoji pop-up window will appear. You can find an emoji by using the search bar, looking through the categories along the top, or using the color-tone icons next to the search bar.
3. Select your desired emoji to apply it.

> **NOTE**
>
> * To revert to the folder icon, click the 🚫 icon in the emoji pop-up window.
> * Emoji styles may vary depending on the browser.
> * You cannot update the category icon for **Page** type categories. Category icon can only be updated for **Folder** or **Index** type categories.

![Document360 interface showing how to change the category icon in the Knowledge base portal.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/6_ScreenGIF-Changing_the_Category_icons.gif)

---

## Deleting a category

There are four ways to delete a category in the Knowledge base portal:

1. Method 1: Using the **More**() icon in the **Categories & Articles**section.
2. Method 2: Using the **More** () icon in the **Folder**/**Index** category.
3. Method 3: Deleting multiple articles/categories in the **Folder**/**Index** category.
4. Method 4: Deleting a specific article/sub category in the **Folder**/**Index** category.

![User interface showing options for managing delete options in the Knowledge base portal.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Deleting_Categories.png)

Method 1

Method 2

Method 3

Method 4

To delete a specific category from the **Categories & Articles**section:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Hover over the desired category in the **Categories & Articles** section.
3. Click the **More** () icon and select **Delete** ().
4. Click **Yes** in the **Delete** confirmation panel.

To delete a specific Folder/Index type category:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Go to the desired Folder/Index category.
3. Click the **More** () icon and select **Delete** ().
4. Click **Yes** in the **Delete** confirmation panel.

To delete a multiple articles and sub categories within a specific **Folder**/**Index** category:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Go to the desired **Folder**/**Index** category.
3. Select the checkboxes for the appropriate articles and subcategories.
4. Click **Delete** ().
5. Click **Yes** in the **Delete** confirmation panel.

To delete a specific article/sub category within a specific **Folder**/**Index** category:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Go to the desired **Folder**/**Index** category.
3. Hover over the desired article/sub category.
4. Click the **More** () icon and select **Delete** ().
5. Click **Yes** in the **Delete** confirmation panel.

> **NOTE**
>
> When you delete a root-level category, all the subcategories and articles under that level will also be deleted. Deleted items will be available in the recycle bin for 30 days.

---

## Hiding and unhiding a category

In Document360, you can hide a category or subcategory within the documentation editor to restrict access to team accounts only. Hidden categories are indicated by a strikethrough in the categories list of the Documentation window.

> Suppose your documentation team is drafting a new feature guide that isn't ready for public release. You can temporarily hide the category while it's under review, ensuring that only internal team members can access it. Once finalized, you can unhide the category to make it publicly available.

There are four ways to hide a category in the Knowledge base portal:

1. Method 1: Using the **More** () icon in the **Categories & Articles**section.
2. Method 2: Using the **More**() icon in the **Folder**/**Index** category.
3. Method 3: Hiding/Unhiding multiple articles/categories in the **Folder**/**Index** category.
4. Method 4: Hiding/Unhiding a specific article/category in the **Folder**/**Index** category.

![User interface showing options for managing Hide options in the Knowledge base portal.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Hiding_Categories.png)

Method 1

Method 2

Method 3

Method 4

To hide/unhide a specific category from the **Categories & Articles**section:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Hover over the desired category in the **Categories & Articles** section
3. Click the **More**() icon and select **Hide** ().

   To Unhide, click the **Unhide** () icon.

To hide/unhide a specific Folder/Index type category:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Go to the desired Folder/Index category.
3. Click the **More**() icon and select **Hide** ().

   To Unhide, click the **Unhide** () icon.

To hide/unhide multiple articles and sub categories within a specific **Folder**/**Index** category:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Go to the desired **Folder**/**Index** category.
3. Select the checkboxes for the appropriate articles and subcategories.
4. Click **Hide** ().

   To Unhide, click the **Unhide** () icon.

To hide/unhide a specific article/sub category within a specific **Folder**/**Index** category:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Go to the desired **Folder**/**Index** category.
3. Hover over the desired article/sub category.
4. Click the **More**() icon and select **Hide** ().

   To Unhide, click the **Unhide** () icon.

> **NOTE**
>
> When you hide a category or subcategory, all its subcategories and articles will also be hidden.

---

## Renaming a category

In Document360, you can rename categories and subcategories as many times as needed.

1. Navigate to **Documentation**() in the Knowledge base portal.
2. Go to the desired category or subcategory.
3. On the category page, click the **category name** to edit.

   Alternatively, hover over the desired category in the **Categories & Articles** section, click the **More** () icon, and select **Rename** to edit the category name.
4. Enter the new category name and click **Update**.

> **NOTE**
>
> Renaming the category or subcategory does not impact the category slug.

![Renaming a category in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/13_ScreenGIF-Renaming_a_category.gif)

---

## Moving a category

You can move a category or subcategory across workspaces. All subcategories and articles within the category will also be moved when you perform the **Move** operation.

There are five ways to move a category in the Knowledge base portal:

1. Method 1: Using the **drag and drop** () icon in the **Categories & Articles**section.
2. Method 2: Using the **More**() icon in the **Categories & Articles**section.
3. Method 3: Using the **More**() icon in the **Folder**/**Index** category.
4. Method 4: Moving multiple articles/categories in the **Folder**/**Index** category.
5. Method 5: Moving a specific article/category in the **Folder**/**Index** category.

![User interface showing options for managing Move options in the Knowledge base portal.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Moving_a_category.png)

Method 1

Method 2

Method 3

Method 4

Method 5

To move a category using the drag and drop () icon in the **Categories & Articles** section:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Hover over the desired category.

   The drag and drop () icon will appear.
3. Hold and drag the category to the appropriate location.

> **NOTE**
>
> * You cannot move a root-level category into its subcategory.
> * Drag and drop () icon allows moving categories only within the same workspace.

From the **Categories & Articles**, you can move a category within or across workspaces:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Hover over the desired category or subcategory in the left navigation pane.

   The **More** **(****)** icon will appear.
3. Click the **More** **(****)** icon and select the **Move** () icon.
4. In the **Move category** panel, perform the following:

   * **Workspace:** Select the desired workspace from the dropdown. Click **Reset** to assign it under the main workspace.
   * **Category:** Select an existing category from the selected workspace. Click **Reset** to assign it under the root category.
   * **Auto update referenced links:** Select this checkbox to ensure links in the article content are updated based on the destination workspace/category.
5. Click **Move**.

You can move a **Folder**/**Index** category using the **More** () option in it:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Go to the desired **Folder**/**Index** category.
3. Click the **More**() icon and select the **Move** () icon.
4. In the **Move category** panel, perform the following:

   * **Workspace:** Select the desired workspace from the dropdown. Click **Reset** to assign it under the main workspace.
   * **Category:** Select an existing category from the selected workspace. Click **Reset** to assign it under the root category.
   * **Auto update referenced links:** Select this checkbox to ensure links in the article content are updated based on the destination workspace/category.
5. Click **Move**.

To move multiple articles/sub categories within a specific **Folder**/**Index** category:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Go to the desired **Folder**/**Index** category.
3. Select the checkboxes for the appropriate articles and subcategories.
4. Click the **Move** () icon.

   In the **Move category** panel, perform the following:

   1. **Workspace:** Select the desired workspace from the dropdown. Click **Reset** to assign it under the main workspace.
   2. **Category:** Select an existing category from the selected workspace. Click **Reset** to assign it under the root category.
   3. **Auto update referenced links:** Select this checkbox to ensure links in the article content are updated based on the destination workspace/category.
5. Click **Move**.

To move a specific article/sub category within a specific **Folder**/**Index** category:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Go to the desired **Folder**/**Index** category.
3. Hover over the desired article/sub category.

   The **More**() icon will appear.
4. Click the **More**() icon and Click the **Move** () icon.

   In the **Move category** panel, perform the following:

   1. **Workspace:** Select the desired workspace from the dropdown. Click **Reset** to assign it under the main workspace.
   2. **Category:** Select an existing category from the selected workspace. Click **Reset** to assign it under the root category.
   3. **Auto update referenced links:** Select this checkbox to ensure links in the article content are updated based on the destination workspace/category.
5. Click **Move**.

![Screenshot of Moving category in Document360](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/11_Moving_a_category_panel.png)

---

## Cloning a category

Clone categories are exact copies of the content created as new articles. You can clone the categories within or across workspaces.

There are three ways to clone a category in the Knowledge base portal:

1. Method 1: Using the **More**() icon in the **Categories & Articles**section.
2. Method 2: Using the **More**() icon in the **Folder**/**Index** category.
3. Method 3: Cloning a specific article/sub category within a **Folder/Index** category.

![Document360 interface showing options to manage clone options in the Knowledge base portal.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_Screenshot-Cloning_categories.png)

Method 1

Method 2

Method 3

From the **Categories & Articles**section, you can clone a category within or across workspaces:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Hover over the desired category or subcategory in the left navigation pane.

   The **More** () icon will appear.
3. Click the **More** () icon and select the **Clone** () icon.
4. In the **Clone category** panel, perform the following:

   1. **Name**: Enter the name for the cloning category.
   2. **Workspace:** Select the desired workspace from the dropdown. Click **Reset** to assign it under the main workspace.
   3. **Category:** Select an existing category from the selected workspace. Click **Reset** to assign it under the root category.
   4. **Auto update referenced links:** Select this checkbox to ensure links in the article content are updated based on the destination workspace/category.
5. Click **Clone**.

You can clone a **Folder**/**Index** category using the **More** () option in it:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Go to the desired **Folder**/**Index** category.
3. Click the **More** () icon and select the **Clone** () icon.
4. In the **Clone category** panel, perform the following:

   1. **Name**: Enter the name for the cloning category.
   2. **Workspace:** Select the desired workspace from the dropdown. Click **Reset** to assign it under the main workspace.
   3. **Category:** Select an existing category from the selected workspace. Click **Reset** to assign it under the root category.
   4. **Auto update referenced links:** Select this checkbox to ensure links in the article content are updated based on the destination workspace/category.
5. Click **Move**.

To move a specific article/sub category within a specific **Folder**/**Index** category:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Go to the desired **Folder**/**Index** category.
3. Hover over the desired article/subcategory.

   The **More** () icon will appear.
4. Click the **More** () icon and select the **Clone** () icon.

   In the **Clone category** panel, perform the following:

   1. **Name**: Enter the name for the cloning category.
   2. **Workspace:** Select the desired workspace from the dropdown. Click **Reset** to assign it under the main workspace.
   3. **Category:** Select an existing category from the selected workspace. Click **Reset** to assign it under the root category.
   4. **Auto update referenced links:** Select this checkbox to ensure links in the article content are updated based on the destination workspace/category.
5. Click **Clone**.

![Cloning a category in Document360 with workspace and category options displayed.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/12_Cloning_a_category_panel.png)

> NOTE
>
> Security restrictions will be applied based on the destination workspaces/categories.

---

## Starring a category

If you frequently use certain categories in your documentation, you can move them to **Starred** for quick and easy access. This feature functions like a favorites section and is available only in the **Knowledge base portal**.

> **NOTE**
>
> You can star categories, subcategories, and articles.

To add a category to **Starred**, follow these steps:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Select the desired category.
3. Click the **Starred** () icon next to the category title.

   Alternatively, hover over a subcategory in the **Folder/Index** overview and click the **Starred** () icon.
4. For a page category type, click the **Starred** () icon near the category title.

![Document360 interface showing how to add a star a category in the Knowledge base portal.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/8_Screenshot-Starring_a_category.png)

You can remove a Starred categories in two ways:

Method 1: Direct removal

Method 2: Removing from the **Starred** () section

Method 1

Method 2

To remove a starred category directly from the categories, follow the steps below:

1. Navigate to the desired category or subcategory in the **Folder/Index** overview page.
2. Click the **Starred** () icon next to the category or subcategory title to unstar it.

To remove a Starred categories in the **Starred** () section:

1. Navigate to **Documentation** () > **Starred** () in the Knowledge base portal.

   The **Starred** () page will appear, displaying a list of starred categories.
2. Select the checkboxes next to the categories you want to remove.
3. Click the **Remove from starred** option.

![Document360 interface showing how to remove a star a category in the Knowledge base portal.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/9_ScreenGIF-removing_starred_categories.gif)

> **NOTE**
>
> When the category filter is applied to the starred items, you cannot view the article status for starred folders or index categories. This is because the starred articles are treated as independent items and are not associated with the category filter. However, only page categories will display the article status.

---

### FAQs

#### What types of categories can I create?

You can create categories of type Folder, Index, Page, or GitHub.

#### Is there a limit to the number of categories I can create?

Yes, you can create up to 1,000 categories per workspace.

#### Can I create subcategories under a main category?

Yes, you can create up to seven levels of categories, including one root category and six subcategory levels.

#### What is the character limit for the article or category title?

The character limit for article or category titles is 150, including spaces.

#### Can I change the category icon to an emoji?

Yes, you can change the icon for Folder or Index type categories or subcategories to an emoji.

#### Is there a way to remove the emoji and revert to the folder icon?

Yes, you can click the 🚫 icon in the emoji popup window to remove the emoji and revert to the folder icon.

#### Do emoji styles vary by browser?

Yes, some emoji styles may vary by browser.

#### What is the purpose of hiding a category in Document360?

Hiding a category restricts access to certain information, making it visible only to team accounts while keeping it hidden from the Knowledge base site.

#### How can I identify hidden categories in Document360?

Hidden categories are indicated by a strikethrough in the categories list in the **Documentation**() section.

#### Can I hide multiple subcategories at once?

Yes, in **Folder/Index** type categories, you can hide multiple subcategories under the same parent category simultaneously by selecting the desired subcategories and clicking **Hide** ().

#### Is it possible to hide a category after it has been published?

Yes, you can hide a category even after it has been published by navigating to the **Categories & Articles**section and selecting the **Hide** () option.

> **NOTE**
>
> When you hide a category or subcategory, all its subcategories and articles will also be hidden.

#### Can I move a category across workspaces?

Yes, you can move a category between workspaces.

#### Does moving a category also move its subcategories and articles?

Yes, moving a category will also move its subcategories and articles to the desired location.

#### Can I move a root-level category into its subcategory?

No, you cannot move the root-level category into its subcategory.

#### Are there any security restrictions when moving categories?

Yes, security restrictions will be applied based on the destination workspaces/categories.

#### What are cloned categories?

Cloned categories are exact copies of the content created as new articles.

#### Can I clone categories across different workspaces?

Yes, you can clone categories within or across workspaces.

#### Is it possible to create new categories or articles within a cloned category?

Yes, you can create new categories or articles within a cloned category.

#### Can I change the type of a cloned category after it has been created?

Can I change the type of a cloned category after it has been created?

#### What is the purpose of starring categories in the Knowledge base portal?

Starring categories allows you to easily access frequently used categories, similar to a favorites section.

#### Is it possible to remove multiple categories from 'Starred' at once?

Yes, you can remove multiple categories from 'Starred' at once from the Starred () page.

#### How long are deleted categories available in the recycle bin?

Deleted categories will be available in the recycle bin for 30 days.

#### Does renaming a category update its slug?

No, renaming a category or article does not automatically update its slug. You must manually update the slug if required.

#### What are some best practices for naming categories?

Best practices include clarity and simplicity, consistent formatting, reader-centric language, avoiding repetition, logical hierarchy, keyword optimization, avoiding abbreviations, considering scalability, and ensuring contextual relevance.

<a id="category-types"></a>

## Category types

**Plans supporting category types**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

In Document360, **categories** and **subcategories** help organize and display groups of similar topic articles, acting as folders containing related content.

## Types of categories

here are three types of categories you can add to your knowledge base:

**1.** **Folder**  
**2.** **Index**  
**3.** **Page**

> NOTE
>
> You can choose the category type when creating a category and switch the category type at any time, as often as needed.

---

**Choosing a category type during category creation**

1. Navigate to the desired category, click the **More** (•••) icon and select **Add sub category**.

   The **Create new category** panel will appear.
2. Select the desired category type.
3. Click **Create.**

![ScreenGIF-Choosing a category type during category creation](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScrenGIF-New_Choosing_a_category_type_during_category_creation.gif)

---

### 1. Folder

The **Folder** is the primary category type, acting as a simple container for articles and subcategories. The default folder icon can be customized with a wide range of icons. This category type does not have a seperate view point of link/URL to the category in the Knowledge base site.

The folder category page also allows you to perform bulk operations like Hide (), Unhide (), Delete (), Move (), and Add to starred () for articles within the category.

**Knowledge base portal view**  
![Screenshot of New Knowledge base portal view for folder category type](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-New_Knowledge_base_portal_view_%20for_folder_category_type.png)

### **2. Index**

The **Index** category type serves as an index to all articles within the folder.

**Knowledge base portal view**  
A URL is generated for this category type, which can be accessed and shared. The page lists articles with details such as title, contributors, last update date, status, and tags.

1. **Index category slug**: Each Index category has a unique slug. Like articles, you can share Index category links with end-users and apply redirection rules.
2. **Bulk operations**: The Index category page supports bulk operations like Hide (), Unhide (), Delete (), Move (), and Add to starred () for the articles.

![Screenshot of a Knowledge base portal view for index category type](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-New_Knowledge_base_portal_view_%20for_index_category_type.png)

**Knowledge base site view**  
When readers click on the Index category type, they get an overview of the articles within the category. The page includes:

1. Category title
2. Number of articles/categories in the category

![Screenshot of Knowledge base site for indx category type](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-New_Knowledge_base_site_view_%20for_index_category_type.png)

### 3. Page

The **Page** category type is similar to the articles you create under other categories in your project. You can create content, publish it, and perform all the same actions as you perform with a regular article.

You can write the page content using the editor (Markdown, WYSIWYG, or Advanced WYSIWYG), change the page title and slug, and perform all other actions available for a typical article in Document360.

**Knowledge base portal view**  
![Screenshot of Knowledge base portal for page category typ](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_Screenshot-New_Knowledge_base_portal_view_%20for_page_category_type.png)

**Knowledge base site view**  
![Screenshot of Knowledge base site for page category type](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/6_Screenshot-New_Knowledge_base_site_view_%20for_page_category_type.png)

---

### FAQ (s)

**What are the different category types available in Document360?**

There are three category types you can add to your knowledge base: Folder, Index, and Page.

**How do I change the category type?**

1. Navigate to the desired category in the Knowledge base portal.
2. Click on the **More (•••)** icon and select **Change type**.
3. Select the intended category type and click **Update**.

**Can I change the category type after it has been created?**

Yes, you can change the category type at any time as often as needed.

**What is the purpose of the Index category type?**

The Index category type serves as an index to all articles within the folder and generates a URL that can be accessed and shared.

**What happens if I change a page category to an index category? Will my content be erased?**

No, your content will not be erased. The category type will change to an index category, and if you switch it back to a page category, your content will be restored.

**Is there a URL associated with the Folder category type?**

No, the Folder category type does not have a separate viewpoint or link/URL to the category in the Knowledge base site.

**What operations can I perform on articles within a Folder category?**

You can perform bulk operations like Hide, Unhide, Delete, Move, and Add to starred for articles within the Folder category.

**What is the main difference between an article and a page category?**

The main difference is that within a Page category, you can create additional categories and articles, whereas in an article, you cannot.

<a id="assigning-drive-folder-for-a-category"></a>

## Mapping a category with a folder in Drive

**Plan support for mapping a category to a folder in Drive**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

## What is a 'Drive folder mapping'?

When a Contributor upload images in the article on the Editor from their local storage or URL, the image would automatically be placed in the designated Drive folder for the article's category/subcategory.

---

## Associating a Drive folder to a category

1. Navigate to Documentation () in the Knowledge base portal.
2. Hover over the desired category and click **More** (•••) icon.
3. Click the **Set drive folder** option.

   The **Set drive folder - Getting started** panel will appear.
4. Select the intended folder/subfolder from the project's Drive where the images need to be saved.
5. Click the **Update** button.

The Drive folder is now mapped to the category/subcategory.

![Screenshot-Updated_mapping_category_with_drive_folder](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Screenshot-Updated_mapping_category_with_drive_folder.gif)

---

#### FAQ(s)

**Can I map the drive folder for subcategories?**

Yes, the **Set Drive Folder** option is available for all categories and subcategories.

**How is setting a drive folder different from the Editor folder?**

If a category is mapped to a drive folder, that mapped folder takes precedence over the Editor folder. All images added to any article in that category will be uploaded to the mapped drive folder. If the category is not mapped to a drive folder, images will be saved in the Editor folder.

**Can I map drive folders at an article level?**

Currently, drive folder mapping is only available for categories and subcategories.

**Can I change or remove a category's drive folder mapping?**

Yes, you can change or remove a category's mapped drive folder as many times as needed. However, changing the mapping to a different drive folder will not move images previously added to the article. Only images added after updating the mapping will be saved in the newly selected drive folder.

**I have a subcategory mapped to a different drive folder and the parent category mapped to another drive folder. Which mapping will be used for articles inside the subcategory?**

The immediate mapping will take precedence, overriding all other settings. In this case, the subcategory mapping will be applied.

> NOTE
>
> **Preference settings:**
>
> 1. Subcategory drive folder mapping
> 2. Parent Category drive folder mapping
> 3. Editor folder

A team account in Document360 that has contributed to a project by creating, editing, saving, or publishing articles. Document360 automatically tracks these activities and includes contributors in the public contributor list.

A tool in Document360 used by writers to draft and format content. Document360 offers three types of editors: Markdown, WYSIWYG, and Advanced WYSIWYG.

A secondary category in Document360 used to organize and display groups of related articles. Subcategories act as folders within a primary category, helping structure similar topics for better organization and navigation.

Organizes related articles under a common theme in the knowledge base.

The default folder in the Document360 Drive where all image files uploaded directly from the editor using the 'Insert Image' option are saved.

<a id="downloading-category-and-article-in-kb-site"></a>

## Downloading category and article in KB site

**Plans supporting the Downloading category and article in the KB site**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Downloading articles individually can be time-consuming and cumbersome. This feature allows you to generate and export entire categories and articles into PDFs, choosing appropriate templates for customization. Users can access these tailored PDF templates directly from the Knowledge Base site, making the process more efficient and user-friendly.

> For your information (FYI)
>
> This feature is available exclusively in private projects and private workspaces within mixed projects in KB site 2.0.

---

#### Enabling PDF download and template selection

Follow these steps to enable PDF downloads and choose a template in the Knowledge base portal:

1. Navigate to **Settings**() > **Knowledge base site**> **A****rticle settings & SEO**>**Article settings** in the Knowledge base portal.
2. Go to **Show download as PDF button** toggle and turn it on.

   By default, this option is enabled.
3. Selecting the **Allow you to choose PDF template while exporting** checkbox enables you to choose your PDF template during the export process.

> **NOTE**
>
> To create or manage the PDF templates, go to **Documentation**() > **Content tools** > **Export to PDF** and select the **PDF template** section.

![Enabling the Show download as PDF button for Downloading categories and articles](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Settingup_Knowledge_base_portal_new.png)

---

#### Downloading categories and articles

1. Navigate to the desired category and click the **More**() icon in the category manager.
2. Click **Export PDF**.
3. The **Export Articles** panel, select the desired subcategories and articles, and choose the appropriate template from the PDF templates dropdown.

   If no template is selected, the default template will be used.
4. Click **Export PDF**.

> NOTE
>
> * Customization added to the knowledge base site will not be reflected in the PDF downloaded.
> * In a Mixed project, if some categories are set to private but the overall workspace is public, the **Export PDF** option will not be available. The workspace visibility (public) takes precedence over individual category settings.

![2_Screenshot-Downloading_PDf_on_KB_site](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Downloading_PDf_on_KB_site.gif)

---

#### Generate PDF download link

* Based on the selected categories, articles, and chosen templates, the PDF will be downloaded.
* If only one article is chosen, it will be downloaded instantly. If more than one article is selected, a downloadable link will be sent via email.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image(150).png "image(150).png")

> **NOTE**
>
> The download link expires after 48 hours.

---

### FAQs

#### What happens if my download exceeds the 500 MB limit?

By default, all plans have a daily download limit of 500 MB. If a download exceeds this threshold, the process will complete, but further downloads will be restricted until the next day. For example, if a Reader generates a PDF on April 9, 2024, at 9:20 PM and exceeds the limit, further downloads will be blocked for 24 hours. **KB PDF download quota** add-ons can be purchased to increase the download capacity for all plans.

#### How can I increase my download capacity?

If you need additional download capacity beyond your daily limit, you can purchase **KB PDF download quota** add-ons from the billing section.

<a id="managing-articles"></a>

## Managing articles

**Plans supporting for Managing articles**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Articles are the foundation of a knowledge base. Managing them effectively ensures that your documentation remains organized, user-friendly, and up to date. Document360 offers a range of options for creating, editing, and organizing articles to suit diverse needs.

Imagine you're managing a large knowledge base with multiple contributors and a wide audience. You need tools to create, edit, and organize articles efficiently while maintaining consistency and accuracy. Document360 simplifies this process with intuitive methods for article management.

---

## Creating an article

The most important building block of any knowledge base is the information it contains. As a Document360 user, you can add this information in the form of articles. Articles are usually grouped into user-defined categories, based on the information they contain.

While you can create articles from a template, or import an article from another source, creating an article from scratch is the most common article creation process.

> **NOTE**
>
> Article limits by plan:
>
> * Professional: **5,000** articles/workspace
> * Business: **5,000** articles/workspace
> * Enterprise: **10,000** articles/workspace
>
> For the best experience, we recommend maintaining articles within these soft limits. If you need a higher limit, contact [support@document360.com](mailto:support@document360.com).

There are four methods to create an article in the Knowledge base portal:

1. Method 1: Using the **Create** button on the top bar
2. Method 2: Using the **Flywheel** () icon
3. Method 3: Using the **More** () icon in the **Categories & Articles** section
4. Method 4: Using the **Create** button in **Folder/Index** type category

![Instructions for creating articles in Document360 interface.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Creating_a_new_article.png)

Method 1

Method 2

Method 3

Method 4

To create an article using the **Create** button on the top bar:

1. Navigate to **Documentation**() in the Knowledge base portal.
2. Click the **Create** dropdown and select **Article**.

   The **Create new article**panel will appear.
3. Enter a **Name** for the new article.
4. In the **Category** dropdown, choose the category’s position.
5. Click **Create** to add the article.

To create an article using the **Flywheel** () icon:

1. Navigate to **Documentation**() in the Knowledge base portal.
2. Hover over just below the desired article, and click the **Flywheel** () icon.
3. Click **Article**.

   The **Create new article** panel will appear.
4. Enter a **Name** for the new article.
5. In the **Category** dropdown, choose the category’s position.
6. Click **Create** to add the article.

To create an article using the **More (****)** icon in the **Categories & Articles** section:

1. Navigate to **Documentation**() in the Knowledge base portal.
2. Hover over the desired category in the **Categories & Articles** section, and click the **More** () icon.
3. Click **Create article** and select **Blank**.

   The **Create new article** panel will appear.
4. Enter a **Name** for the new article.
5. In the **Category** dropdown, choose the category’s position.
6. Click **Create** to add the article.

To create an article using the **Create** button in a **Folder/Index** type category:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Click the desired **Folder/Index** type category.
3. Click **Create** dropdown (on the right side of the category page) and select **Article**.

   The **Create new article** panel will appear.
4. Enter a **Name** for the new article.
5. In the **Category** dropdown, choose the category’s position.
6. Click **Create** to add the article.

![Creating a new article in the Markdown editor with title and category fields.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Creating_a_new_article_panel.png)

---

## Creating article templates

In Document360, you can create, save, and reuse any article as a template for future articles. When you create a new article using a template, it automatically imports all predefined properties and formatting, saving you time and ensuring consistency across your knowledge base.

Imagine you're managing a knowledge base for a software product with a standard troubleshooting format. Instead of recreating the same structure every time, you can use a saved template to maintain consistency and reduce effort, allowing you to focus on customizing the content.

You can create an article from the template using three methods:

1. Method 1: Using the **Flywheel** () icon
2. Method 2: Using the **More** () option
3. Method 3: Using the **Create** button on the top bar

![Instructions for creating articles in the Document360 workspace interface.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Article_from_template_methods.png)

Method 1

Method 2

Method 3

Use the **Flywheel** () icon in the **Categories & Articles** section to quickly create an article from a template:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Hover over just below the desired article in the **Categories & Articles** section and click the **Flywheel** () icon.
3. Select **Article from template**.

   The **Article from template**panel will appear.
4. Choose a template from the list, and you can preview the template content in the right-side pane.
5. Enter the intended article name and select the category for the article.
6. Click **Create** to add the article.

Use the **More** () icon in a specific category to create an article from a template:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. In the **Categories & Articles** section, go the desired category.
3. Click **More**() > **Create article** > **From template**.

   The **Article from template**panel will appear.
4. Choose a template from the list, and you can preview the template content in the right-side pane.
5. Enter the intended article name and select the category for the article.
6. Click **Create** to add the article.
7. The article's name and slug will automatically populate using the template's title.

To create an article from template using the **Create** button on the top bar:

1. Navigate to **Documentation**() in the Knowledge base portal.
2. Click the **Create** dropdown and select **Article from template**.

   The **Article from template**panel will appear.
3. Choose a template from the list, and you can preview the template content in the right-side pane.
4. Enter the intended article name and select the category for the article.
5. Click **Create** to add the article.
6. The article's name and slug will automatically populate using the template's title.

![Creating a troubleshooting guide template with fields for version, date, and author.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Article_from_template_panel.png)

> **NOTE**
>
> If you want to add, manage, or change any existing template, you can navigate to the **Templates overview** page by clicking on the **Go to manage templates** above the list of templates in the **Article from template** panel.
>
> For more information, read the article on [Templates](/help/docs/article-templates).

---

## Editing an article

Editing a published article is essential for maintaining up-to-date and accurate content in your Knowledge base. When an article is published, the following changes occur:

1. Your article will appear on your Knowledge base site for readers.
2. The article's status changes from **Draft** to **Published** in the Knowledge base portal

When you select a published article, you'll notice the editor displays only the live version, not the editing pane.

To edit the published article:

1. Navigate to the desired editor and click the **Edit** button at the top-right corner.

   The **Article status** at the top of the editor changes to **Draft**.
2. Make the necessary changes to the article content.
3. Once the changes are complete, click **Publish** to republish the updated article to your Knowledge base site.

When you publish an edited article, the updated version automatically replaces the previously published version in your Knowledge base.

![Overview of Document360 platform with highlighted knowledge management features and navigation options.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_Screenshot-Editing_an_Article.png)

### Markdown view of a published article

If you've published an article using the Markdown editor, you can view the Markdown formatting without creating a new version of the article.

1. Navigate to any published article in the Markdown editor.
2. Click **More**() on the top right and select **View markdown**.
3. Once done, click **Close markdown**.

![Accessing the Markdown view of the published article in the Knowledge base portal.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/6_ScreenGIF-Markdown_view_of_a_published_article.gif)

---

## Locking an article

When you or another team member actively edits an article, it is automatically locked to prevent other contributors from making simultaneous changes that could lead to conflicts or content overwrites.

This feature is useful when multiple team members collaborate on a single article. Once you finish editing, you can unlock the article to allow others to make changes.

An article is unlocked when:

* There is **no activity** for **15 minutes**.
* You click the **Lock** () icon and select **Unlock**.
* You navigate to another article or page within the Knowledge base portal.

![Locking and unlocking an article in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/14_ScreenGIF-Locking_an_Article.gif)

---

## Deleting an article

There are five ways to delete an article in the Knowledge base portal:

1. Method 1: Using the **More**() icon in the **Categories & Articles**section.
2. Method 2: Using the **More** () icon in the desired article.
3. Method 3: Deleting multiple articles in the **Folder**/**Index** category.
4. Method 4: Deleting a specific article in the **Folder**/**Index** category.
5. Method 5: Deleting multiple articles in the **All articles** () section.

![Various methods are used to delete the articles in the knowledge base portal.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/7_ScreenGIF-Deleting_an_article_methods.gif)

Method 1

Method 2

Method 3

Method 4

Method 5

To delete a specific article from the **Categories & Articles**section:

1. Navigate to **Documentation**() in the Knowledge base portal.
2. Hover over the desired article in the **Categories & Articles** section.
3. Click the **More** () icon and select **Delete**().
4. Click **Yes**in the **Delete confirmation** panel.

To delete an article while editing it:

1. In the desired article, click the **More** () icon and select **Delete** ().
2. Click **Yes**in the **Delete confirmation** panel.

To delete multiple articles within a specific **Folder**/**Index** category:

1. Navigate to **Documentation**() in the Knowledge base portal.
2. Go to the desired **Folder**/**Index** category.
3. Select the checkboxes for the appropriate articles.
4. Click **Delete** ().
5. Click **Yes**in the **Delete confirmation** panel.

To delete a specific article within a specific **Folder**/**Index** category:

1. Navigate to **Documentation**() in the Knowledge base portal.
2. Go to the desired **Folder**/**Index** category.
3. Hover over the desired article, click the **More** () icon and select **Delete** ().
4. Click **Yes**in the **Delete confirmation** panel.

To delete multiple articles in the **All articles** () section:

1. Navigate to **Documentation** () > **All articles** () on top of the **Categories & Articles** section.

   The **All articles** page will appear. If required, use the [**filter**](/help/docs/filter-bulk-operations) options to narrow down the articles.
2. Select the desired articles and select **Delete** ().
3. Click **Yes**in the **Delete confirmation** panel.

> NOTE
>
> For more information, read the article on [**All articles**](/help/docs/all-articles-overview-page).

---

## Hiding and Unhiding an article

In Document360, you can hide an article within the documentation editor to restrict access to team accounts only. Hidden articles are indicated by a strikethrough in the Documentation window.

For instance, if you want your sales team to access an article containing pricing details but don't want that article visible to customers, you can hide it so that it won't appear in your public documentation.

There are four ways to hide or unhide an article in the Knowledge base portal:

1. Method 1: Using the **More** () icon in the **Categories & Articles**section.
2. Method 2: Hiding/Unhiding multiple articles in the **Folder**/**Index** category.
3. Method 3: Hiding/Unhiding a specific article in the **Folder**/**Index** category.
4. Method 4: Hiding/Unhiding multiple articles in the **All articles** () section.

![Hiding and unhiding articles in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/8_ScreenGIF-Hiding_Unhiding_the_articles.gif)

Method 1

Method 2

Method 3

Method 4

To hide/unhide a specific article from the **Categories & Articles**section:

1. Navigate to **Documentation**() in the Knowledge base portal.
2. Hover over the desired article in the **Categories & Articles** section
3. Click the **More** () icon and select **Hide** ().

   To Unhide, click the **Unhide**() icon.

To hide/unhide multiple articles within a specific **Folder**/**Index** category:

1. Navigate to **Documentation**() in the Knowledge base portal.
2. Go to the desired **Folder**/**Index** category.
3. Select the checkboxes for the appropriate articles.
4. Click **Hide** ().

   To Unhide, click the **Unhide**() icon.

To hide/unhide a specific article within a specific **Folder**/**Index** category:

1. Navigate to **Documentation**() in the Knowledge base portal.
2. Go to the desired **Folder**/**Index** category.
3. Hover over the desired article.
4. Click the **More** () icon and select **Hide** ().

   To Unhide, click the **Unhide**() icon.

To hide multiple articles in the **All articles** () section:

1. Navigate to **Documentation** () > **All articles** () on top of the **Categories & Articles** section.

   The **All articles** page will appear. If required, use the [**filter**](/help/docs/filter-bulk-operations) options to narrow down the articles.
2. Select the desired articles and click **Hide** ().

   To Unhide, click the **Show** () icon.

> NOTE
>
> For more information, read the article on [**All articles**](/help/docs/all-articles-overview-page).

---

## Renaming an article

To rename an article, follow the steps below:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Go to the desired article and click the article name to edit it.

   Alternatively, hover over the desired article in the **Categories & Articles** section, click the **More** () icon, and select **Rename**.
3. Enter the new article name and click **Update**.

   1. If the article is in the **Published** state, a **Article details confirmation** panel will appear.
   2. Click **Yes**.

![Renaming an article in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/13_ScreenGIF-Renaming_an_Article_update.gif)

---

## Moving an article

You can move an article across workspaces. There are five ways to move an article in the Knowledge base portal:

1. Method 1: Using the **drag and drop** () icon in the **Categories & Articles**section.
2. Method 2: Using the **More** () icon in the **Categories & Articles**section**.**
3. Method 3: Moving multiple articles in the **Folder**/**Index** category.
4. Method 4: Moving a specific article in the **Folder**/**Index** category.
5. Method 5: Moving multiple articles in the **All articles** () section.

![Moving and reordering the articles in the knowledge base portal.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/10_ScreenGIF-Moving_an_Article.gif)

Method 1

Method 2

Method 3

Method 4

Method 5

To move an article using the **drag and drop** () icon in the **Categories & Articles**section:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Hover over the desired category.

   The **drag and drop** () icon will appear.
3. Hold and drag the category to the appropriate location.

From the **Categories & Articles** section, you can move an article within or across workspaces:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Hover over the desired article in the left navigation pane.

   The **More** **(****)** icon will appear.
3. Click the **More** **(****)** icon and select the **Move** () icon.
4. In the **Move article** panel, perform the following:

   * **Workspace:** Select the desired workspace from the dropdown.
   * **Category:** Select an existing category from the selected workspace.
   * **Auto update referenced links:** Select this checkbox to ensure links in the article content are updated based on the destination workspace/category.
5. Click **Move**.

To move multiple articles within a specific **Folder**/**Index** category:

1. Navigate to **Documentation**() in the Knowledge base portal.
2. Go to the desired **Folder**/**Index** category.
3. Select the checkboxes for the appropriate articles.
4. Click the **Move**() icon.

   In the **Move article** panel, perform the following:

   1. **Workspace:** Select the desired workspace from the dropdown.
   2. **Category:** Select an existing category from the selected workspace.
   3. **Auto update referenced links:** Select this checkbox to ensure links in the article content are updated based on the destination workspace/category.
5. Click **Move**.

To move a specific article within a specific **Folder**/**Index** category:

1. Navigate to **Documentation**() in the Knowledge base portal.
2. Go to the desired **Folder**/**Index** category and hover over the desired article.

   The **More** () icon will appear.
3. Click the **More** () icon and Click the **Move**() icon.

   In the **Move article** panel, perform the following:

   1. **Workspace:** Select the desired workspace from the dropdown.
   2. **Category:** Select an existing category from the selected workspace.
   3. **Auto update referenced links:** Select this checkbox to ensure links in the article content are updated based on the destination workspace/category.
4. Click **Move**.

To move multiple articles in the **All articles**() section:

1. Navigate to **Documentation** () > **All articles** () on top of the **Categories & Articles** section.

   The **All articles** page will appear. If required, use the [**filter**](/help/docs/filter-bulk-operations) options to narrow down the articles.
2. Select the desired articles and click the **Move** **to**() icon.

   In the **Move article** panel, perform the following:

   1. **Workspace:** Select the desired workspace from the dropdown.
   2. **Category:** Select an existing category from the selected workspace.
   3. **Auto update referenced links:** Select this checkbox to ensure links in the article content are updated based on the destination workspace/category.
3. Click **Move**.

> **NOTE**
>
> When moving articles, security restrictions will be applied based on the destination workspaces and categories.

---

## Replicating an article

The **Replicate** article feature allows you to display a single article across multiple categories. Replicating articles streamlines content organization and accessibility, enhancing the user experience and improving knowledge base management.

To replicate an article, follow the steps below:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. In the **Categories & Articles** section, hover over the desired article and click the **More** () icon.

   Alternatively, if the article is in a **Folder/Index** type category, navigate to the category, hover over the desired article and click the **More** () icon.
3. Select **Replicate** ().

   The **Replicate** panel will appear.
4. Choose the appropriate category and click **Replicate**.

   The article is now available in the selected location on the Knowledge base portal and as a regular article on the Knowledge base site.

> NOTE
>
> * Security restrictions will be applied based on the destination category.
> * You can only edit the source article and not the replicated article. Certain article settings are turned off in the replicated articles.

![Various methods of replicating articles in the KNowledge base portal.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/11_Screenshot-Replicating_an_article.png)

---

## Cloning an article

Clone articles are exact copies of the content created as new articles. You can clone articles within or across workspaces.

There are two methods to clone an article in the Knowledge base portal:

1. Method 1: Using the **More** () icon in the **Categories & Articles**section.
2. Method 2: Cloning a specific article within a **Folder/Index** category.

![Various methods of cloning articles in the KNowledge base portal.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/12_Screenshot-Cloning_an_Article.png)

Method 1

Method 2

From the **Categories & Articles**section, you can clone an article within or across workspaces:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Hover over the desired article in the left navigation pane.

   The **More** () icon will appear.
3. Click the **More** () icon and select the **Clone**() icon.
4. In the **Clone article** panel, perform the following:

   1. **Name**: Enter the name for the cloning article.
   2. **Workspace:** Select the desired workspace from the dropdown. Click **Reset** to assign it under the main workspace.
   3. **Category:** Select an existing category from the selected workspace.
   4. **Auto update referenced links:** Select this checkbox to ensure links in the article content are updated based on the destination workspace/category.
5. Click **Clone**.

To move a specific article within a specific **Folder**/**Index** category:

1. Navigate to **Documentation**() in the Knowledge base portal.
2. Go to the desired **Folder**/**Index** category.
3. Hover over the desired article.
4. Click the **More** () icon and select the **Clone** () icon.
5. In the **Clone article** panel, perform the following:

   1. **Name**: Enter the name for the cloning article.
   2. **Workspace:** Select the desired workspace from the dropdown. Click **Reset** to assign it under the main workspace.
   3. **Category:** Select an existing category from the selected workspace.
   4. **Auto update referenced links:** Select this checkbox to ensure links in the article content are updated based on the destination workspace/category.
6. Click **Clone**.

> **NOTE**
>
> When moving articles, the **Security restrictions** will be applied based on the destination workspaces and categories.

---

## Troubleshooting

### **Article limit reached**

**Error:** `documentation.categoriesAndArticles.maxArticlesCountReached` and `documentation.categoriesAndArticles.articleLimitExceedsPerCategory`

These errors occurs when the article limit for a **category** or **project** has been exceeded. It commonly happens in the following scenarios:

* Creating a **large number of articles** within a category or project that exceeds the allowed limit.
* **Bulk importing** a significant number of articles into a category.
* Adding a **page type subcategory** within another category.

**Steps to resolve**

1. Check if the error occurs across **all categories** in your workspace.
2. In Document360, the maximum number of articles per category and per project depends on your plan:

   **Category limits**

   * Professional, Business, and Enterprise plans: Up to **100 articles per category**.

   **Project Limits**

   * Professional & Business plans: Up to **5,000 articles per workspace**.
   * Enterprise plan: Up to **10,000 articles per workspace**.
3. If your workspace has exceeded these limits, reduce the number of articles in a category or upgrade your plan if needed.

If the issue persists after following these steps, please contact the Document360 support team for further assistance: [Contact Document360 Support](https://document360.com/support/)

![Overview of document categories and articles with highlighted error message that indicates the article creation limit is reached.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1739518144665.png)

---

### FAQs

#### What is the character limit for article titles?

The character limit for article titles is 150 characters, including spaces. Special characters like $, %, \*, {, }, ", <, and > are not allowed.

#### What are the best practices for creating an article title and URL slug?

When creating an article title, remember that the URL slug is derived from the title. Document360 automatically separates words with hyphens and removes special characters/punctuation in the slug. Further updates to the URL slug can be made later.

#### How can I identify the published status of an article?

The published status of an article is indicated by a colored dot next to the article name:

* Light blue dot: A new article which is not yet published.
* Light green dot: The article is published.

#### Do I need to save my content frequently?

No, Document360 automatically saves your content every 5 seconds. You can also save manually using **Ctrl+S** (Windows) or **Cmd+S** (Mac).

#### What should I do if I cannot access an article or see recent updates?

If you’re having trouble accessing an article or viewing recent updates, try the following steps:

* Refresh the page.
* Ensure the article title or link is correct.
* Clear your browser cache and cookies, then try again.
* If the article was recently published or updated, allow a few moments for the changes to reflect.

If the issue persists after following these steps, please contact the Document360 support team for further assistance: [Contact Document360 Support](https://document360.com/support/)

#### What happens after I create a new article from a template?

Your article will be added to the respective category/subcategory with a New article status indicator (light-blue dot).

#### What happens after an article is published?

After an article is published, it will appear in your Knowledge base site for readers, and its status will be updated from Draft to Published in the Knowledge base portal.

#### How can I edit a published article?

To edit a published article, click the **Edit** button at the top-right of the editor. This will change the article status back to Draft, allowing you to make changes.

#### What happens when I publish an edited article?

When you publish an edited article, the edited version replaces the previously published version in your Knowledge base.

#### Is the 'Edit article' option available for all readers in the Knowledge base site?

No, the 'Edit article' option is only available for logged-in team accounts on the Knowledge base site.

#### What happens when an article is locked because a user is editing it, and how can it be released?

In Document360, when a user begins editing an article, the article is locked, preventing others from making changes. This lock is automatically released 15 minutes after the user stops editing, at which point the article becomes available for other users to edit.

If you need to unlock it before that time, the user editing the article can manually click **Unlock** () icon at the top of the article, near the preview.

#### Can I move articles from one project to another?

The inbuilt move functionality to move articles from one project to another is currently unavailable.  As a workaround, when transferring multiple articles, use the export feature to save the articles along with all media files from the original project, then import them into the new project. Alternatively, you can manually copy and paste content from articles in one project to another. As a best practice, upload images from the original article to the drive of the new project and then insert them into the new article.

#### What happens to the links and references within an article when it is moved to a new category or workspace?

When you move an article to a new category or workspace, all internal links and references within the article will be updated automatically to reflect the new location. This ensures that all links and references remain functional.

#### Are there any security restrictions when moving articles across workspaces?

Yes, security restrictions will apply based on the destination workspace and category. Ensure that you have the appropriate permissions to move articles to the target workspace and category.

#### What is a hidden article?

A hidden article will not be listed in the Knowledge base site and cannot be accessed through the direct link, but will appear in the Knowledge base portal for internal use.

#### How can I hide a single article?

To hide a single article, navigate to  **Documentation** () in the Knowledge base portal, hover over the desired article, click on the **More** () icon, and select **Hide**.

#### Can I hide multiple articles at once?

Yes, you can hide multiple articles at once by navigating to the **All articles** () section in **Documentation** (), selecting the desired articles, and clicking the **Hide** option at the top of the pane.

#### Will hidden articles appear in search results?

No, hidden articles are excluded from search results.

#### How can I hide an article from the Knowledge base site while still allowing access via its URL?

To hide an article while maintaining access through its URL, follow these steps:

1. Navigate to Settings () > **Knowledge base site** > **Customize site**.
2. Click on **Custom CSS & JavaScript**.
3. Paste the following code in the JavaScript tab:

```
$(document).ready(function() {
    $('a[href="SLUG NAME"]').parent().css({"display": "none"});
    $('a[href="SLUG NAME"]').parent().css({"display": "none"});
});
```

JavaScript

Copy

4. Click **Save**.

#### How do I restore my deleted articles?

You can restore your deleted articles from the **Recycle bin**. The deleted articles will remain in the Recycle bin for 30 days. For more information, read the article on [Recycle bin](/help/docs/recycle-bin-recent-and-starred-files).

#### Why doesn't the article name change reflect on the Knowledge base site?

* If the article is in **Draft** status, the change in the article name doesn't reflect immediately on the site. The article name change will only be reflected after publishing it.
* If the article is in **Published** status, the change in the article name will reflect immediately on the Knowledge base site.

#### Can I clone and replicate articles across different workspaces?

You can clone articles within or across workspaces. However, replication is limited to the same workspace.

#### What happens if I delete the source article of a replicated article?

If the source article is deleted, the replicated articles will also be removed from their respective categories.

#### Is there a limit to the number of times an article can be replicated or cloned?

Document360 does not limit the number of times you can replicate or clone articles, allowing flexibility in content management.

#### Why am I getting 404 errors when trying to access articles other than the homepage or the first article? How do I resolve it?

This issue typically occurs due to incorrect slug configuration or folder name changes in the subfolder hosting page. Follow these steps to resolve the issue:

1. Verify article slugs: Ensure the slugs for your articles are correctly configured. For example, the first article might load using the slug /docs, but other articles may require a different slug, such as /help. In such cases, make sure all the slugs are consistent.
2. Check subfolder settings: Navigate to the subfolder hosting page and confirm if the `/docs` folder has been renamed or altered. If it has been renamed, update it back to `docs` to maintain consistency.
3. Test access: After correcting the folder name, try accessing the articles again to confirm the issue is resolved.
4. Clear cache and perform hard refresh:

   a. Right-click anywhere on the page and select Inspect to open the developer tools menu.

   b. Right-click the browser's reload button and choose Hard reload or Empty cache and Hard reload.

If the issue persists after following these steps, please contact the Document360 support team for further assistance: [Contact Document360 Support](https://document360.com/support/)

 Provide the following details:

* Screenshots or video recordings of the subfolder hosting page.
* Information about any recent changes to your website or system settings.
* An exported CSV file from the article redirect rule feature.

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

The public-facing website where end-users can access articles and find answers to their questions.

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

<a id="article-import-from-word-files"></a>

## Word .docx files

**Plans supporting the import of articles from Word**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Importing article content directly from Word files can significantly streamline the process of building your knowledge base. Document360 supports importing .docx files, allowing you to effortlessly transfer your pre-written content into your knowledge base.

> NOTE
>
> Document360 supports only Word files with the **.docx** extension. Ensure your file size is **under 15MB**. Other file formats are not supported.

---

## Importing Word files

### Import as a single article

To import a .docx Word file as a Document360 article,

1. Log in to the **Knowledge base portal** and select your desired project.
2. Select the **Documentation** tab from the left navigation sidebar.
3. Navigate to the desired category in the **Categories & Articles** pane.
4. Click the **More ()** icon next to the category name.
5. Select **Add article** > **Import ().** The **Import** window will appear.
6. **Drag and drop** the .docx source document or click **Upload a file** to import it from your local storage. By default, the **Single article** tab will be selected in the **Import** window.
7. Click **Replace** if you want to select a different .docx source document.

Document360 automatically populates the **Article name** and **Category** fields based on the filename of the source document and the category you selected in step 3. You can edit both fields if needed.

> NOTE
>
> If the article name is manually updated during the Word import process, the change will not be captured in the Team auditing.

7. Select the location where your media files should be saved from the **Drive location** dropdown menu.
8. Click **Import**. A success message will appear once the article has been imported.
9. Click **Done** to close the Import window and view the imported article in the editor.

> NOTE
>
> * Images in the Word document will be uploaded as individual files in the selected Drive folder.
> * Document360 retains all external hyperlinks in the imported article.

![Importing the word document as a single article](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenGIF-Importing_a_single_article.gif)

---

### Importing a Word file as multiple articles

To import a .docx Word file as a Document360 article,

1. Log in to the **Knowledge base portal** and select your desired project.
2. Select the **Documentation** tab from the left navigation sidebar.
3. Navigate to the desired category in the **Categories & Articles** pane.
4. Click the **More ()** icon next to the category name.
5. Select **Add article** > **Import ().** The **Import** window will appear.
6. **Drag and drop** the .docx source document or click **Upload a file** to import it from your local storage.
7. Click **Replace** if you want to select a different .docx source document.
8. Select the **Multiple articles** tab in the Import window.
9. Select the location where your media files should be saved from the **Drive location** dropdown menu.
10. Select the desired heading levels (e.g., H1, H2) in the field labeled **"Which heading levels create a new article?"** for splitting the document into articles. By default, **H1** is selected and cannot be removed. For example:

    * If only H1 is selected, a new article is created at the start of each H1.
    * If both H1 and H2 are selected, a new article is created at each H1, and H2 headings within an H1 section will also create separate articles. This is helpful when your document has multiple subsections that you want to organize as individual articles for better clarity and navigation.
11. Click **Proceed** to process the document based on the selected heading levels.

After processing, a list of articles will appear, with the heading text from the .docx file serving as the article name for each generated article. The **Category** fields are also auto populated based on the category you selected in step 3. You can select a different category from the dropdown menu.

When you hover over an article in the article list, the **Merge**, **Preview**, and **Delete** options are displayed.

* Click the **Merge** option to merge a sub-heading article with its parent article. This will combine the sub-heading article (e.g., created from H2) into the parent article (e.g., created from H1).
* Click the **Preview** option to view the content of the article.
* Click the **Delete** option to delete the article.

11. Once you are done reviewing the articles, click **Import** to finish importing the articles to your knowledge base. A success message will confirm that the articles have been imported.
12. Click Done to close the Import window. The imported articles will now appear in the selected category.

> NOTE
>
> * Images in the Word document will be uploaded as individual files in the selected Drive folder.
> * Document360 retains all external hyperlinks in the imported article.

![Importing a document as multiple articles](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGIF-Importing_multiple_article.gif)

---

## Determining editors while importing .docx files

When importing articles from Word files, the editor used will be based on your selection in the Knowledge base portal settings. Follow these steps to check or change your editor selection:

1. Navigate to **Settings** > **Knowledge base portal** > **General** > **Editor**.
2. Select the editor to determine how articles are imported:

   1. Choose Markdown or WYSIWYG editors to import Word files using the WYSIWYG editor.
   2. Choose the Advanced WYSIWYG editor to import Word files using the Advanced WYSIWYG editor.

---

### FAQs

**What is the best practice for managing large documents in the Advanced WYSIWYG editor?**

As a best practice, split large documents into multiple articles for better performance and easier management. For instance, if you are importing content from a Word file, you can use the [**Import Word File into Multiple Articles**](/help/docs/article-import-from-word-files) feature for a more efficient workflow.

**What is the maximum file size for .docx files that can be imported?**

The .docx file size should be less than 15MB. If your Word file exceeds this limit, you will get an error saying, ‘*File size can’t be larger than 15 MB*’ and you will need to split the file into smaller parts before attempting to import the file again.

**Can I import multiple .docx files at once?**

You can import only one .docx at a time. However, during the upload, you can choose to import it as either a single article or multiple articles.

**Is it possible to import Word files using the Markdown editor?**

No, importing Word files (.docx) is not supported in the Markdown editor.

**Why am I facing an error while importing a Word document into Document360?**

There are several reasons for errors when importing Word documents into Document360:

1. **Missing or empty headers in the Table of Contents (TOC)**

If your document contains missing or empty headers in the TOC section, this can cause an error saying “*An item with the same key has already been added*” during the import process. To resolve this, remove any empty or missing headers from the TOC and then try importing the file again. Once corrected, the import should work as expected.

2. **Firewall blocking the upload**

Another potential issue could be related to your network firewall. If your firewall is blocking the upload, you might receive an object error. In such cases, ensuring that the Word document upload is allowed in your firewall settings should resolve the issue.

3. **Password-protected or restricted files**

Word files that are password-protected or restricted to specific users cannot be imported. Ensure the file is accessible to everyone.

4. **Conflicting styles between Microsoft Word and Google Docs**

If a Word file was created in Microsoft Word and later modified in Google Docs, changes to the heading styles in Google Docs can result in duplicate or conflicting styles. This occurs because Microsoft Word and Google Docs handle styles differently, leading to mismatched style tags. To resolve this:

a. After uploading the Word document to Google Docs, apply the default Google Docs styles to the document.  
b. This will reset all styles to Google Docs' default settings, removing any duplicated or conflicting styles.

If the issue persists after following these steps, please contact the Document360 support team for further assistance: [Contact Document360 Support](https://document360.com/support/)

**Why do I see the error “You have reached the maximum number of articles you can have in a project”?**

This error occurs when the number of articles in your project exceeds the allowed limit. If you are importing a Word file, Document360 uses heading tags to divide the file into multiple articles. For example, if the Word file generates 10 articles, but the target category has a soft limit that allows fewer than 10 articles, this error may occur. As a solution,

1. Review the heading tags in your Word file to understand how the content is structured and split into articles.
2. Adjust the heading structure in the Word file to reduce the number of articles generated during the import.

If the issue persists after following these steps, please contact the Document360 support team for further assistance: [Contact Document360 Support](https://document360.com/support/)

<a id="publishing-an-article"></a>

## Publishing an article

**Plans supporting for publishing an articles**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Once you have drafted and reviewed an article, the final step in the content creation process is publishing the article. Publishing an article is crucial as it makes the information available to your end-users.

## Publishing from the editor

The following steps outline the process of publishing an article directly from the editor within Document360:

1. Click **Publish** at the top right of the editor.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1717940422587.png)

2. You can add an optional comment for internal purposes in the **Publish confirmation** dialog box.
3. Click the **Configure article settings** dropdown to expand the Publish confirmation dialog box.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Configure_article_settings.png)
4. Once you configure the article settings, click **Yes** to publish the article.

### Configure article settings

#### Tags

Add **tags** to enhance the discoverability of your article.

* Ask **Eddy AI** to generate tags based on your article content.
* Select existing tags from the dropdown menu.
* Manually input a tag.

  ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Configure_article_settings_tags.png)

#### SEO description

You can add an SEO description to boost your content’s visibility on search engines.

* Ask **Eddy AI** to generate an SEO description based on your article content.
* Manually add an SEO description.

  ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Configure_article_settings_seo_description.png)

#### Related articles

Add Related articles to keep your readers engaged with related content, encouraging them to spend more time on your site.

* Ask **Eddy AI** to suggest related articles based on your article content, and the existing articles in your knowledge base.
* Manually search for specific articles and add them as related articles.

  ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_Screenshot-Configure_article_settings_related_articles.png)

#### Status indicator

Add a Status indicator to your article to help users quickly identify new or updated content.

* **New Article**: A green circle displayed next to the article name in the left navigation pane indicates that the entire article is newly added.
* **Updated Article**: A yellow circle displayed next to the article name in the left navigation pane indicates that an existing article has been recently modified or updated with new or revised information.
* **Custom:** You can be set by the Team account manually.

  ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/6_Screenshot-Configure_article_settings_status_indicator.png)

> NOTE
>
> * You can automatically update status indicators for new and updated articles by toggling on **Automatically set article status** from **Settings** () > **Knowledge base site** > **Article settings & SEO.**

## Publishing articles in bulk

You can publish more than one article at the same time in Document360. Follow the below steps to publish articles in bulk:

1. Navigate to **Documentation** () > **All articles** () in the knowledge base portal.
2. Select the checkbox next to the articles you want to publish.
3. Click  **Publish** from the available bulk actions.

   ![Document360 interface showing article management with options to publish and edit articles.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/screenshot-Bulk_publish_in_all_Articles.png)

> TIP
>
> To ensure you only select unpublished articles, you can use the  **Filter** option from the top right corner.

> NOTE
>
> You can bulk publish articles within specific categories as well.

---

### FAQs

#### **Why is the Ask Eddy AI button disabled when I try to add tags?**

The **Ask Eddy AI** functionality for tag suggestions requires a minimum article length of **50 words**. This threshold ensures sufficient content for accurate tag generation based on the article's subject matter.

#### **Why is the Ask Eddy AI button disabled when I try to add an SEO description?**

For SEO description generation, the **Ask Eddy AI** feature requires a minimum article length of **200 words.** This requirement allows for a comprehensive analysis of the content to produce an effective SEO description.

#### **Why is the Ask Eddy AI button disabled when I try to add related articles?**

The **Ask Eddy AI** function for suggesting related articles requires a minimum of **200 words** in the article. This word count threshold facilitates a thorough content analysis for identifying relevant related articles.

#### **Why can't I see the “ Publish” option when attempting to publish multiple articles at once?**

When you are selecting the articles you wish to publish, ensure that you are not selecting any already published articles.

#### **If an article is hidden, will it be ignored by Google search?**

Yes, if an article is hidden, it will be ignored by Google Search. Hidden articles are not indexed and therefore not visible in search results.

#### **If an article is published, you have Knowledge base access, but it is restricted for you for a particular article, will it be ignored?**

Yes, if an article is published and you have KB access but are restricted from viewing a particular article, it will be ignored.

#### **I published an article, but I can't see it on the Knowledge base site. What should I do?**

If your published article is not visible on the Knowledge base site, check the following:

1. Ensure the article is not set to [hidden](/help/docs/hiding-article) in the Knowledge base portal.
2. Verify if any [restrictions](/help/docs/article-access-control-knowledge-base-site) have been applied to the article.
3. Check for any [redirection rule](/help/docs/article-redirect-rules) associated with the article and clear them if needed.
4. Confirm that the selected [workspace](/help/docs/workspaces) is set to Public.

<a id="reviewing-an-article-inline-comments"></a>

## Reviewing an article using Inline comments

**Plans supporting discussion/inline comments**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Efficient collaboration and feedback are crucial for maintaining high-quality documentation. With Document360’s inline comment feature, reviewing and refining articles becomes a seamless process.

> NOTE
>
> You can use the **Inline comments** feature only in the Advanced WYSIWYG editor.

---

## Adding inline comments to an article

1. Navigate to the desired article within the Knowledge base portal.
2. Ensure that the article is in **Advanced WYSIWYG editor**.
3. Select the desired text by clicking and dragging the cursor over it.   
   A bubble menu appears.
4. Click the **Comment** (  ) icon, to open the comment box.

![1. Adding inline comments to an article](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1.%20Adding%20inline%20comments%20to%20an%20article.png)

5. Inside the comment box,

   1. You can enter the desired comments.
   2. Using **@** symbol you can mention another Team account in your project.
   3. Basic text formatting options such as bold and lists are available.   
      Comments are visually indicated by a yellow highlight.

6. Once done, click **send** (  ) or press **Ctrl + Enter** to create an inline comment.
7. If you wish to cancel, click on any other area of the article, or press **ESC.**

> **NOTE**
>
> Once the article is published, all unresolved comments will be automatically deleted.

![2.Managing-comments](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2.Managing-comments.png)

---

### Enabling comment notification

1. Navigate to Settings () > **Knowledge base portal** > **Notifications** in the Knowledge base portal.
2. Select the **Notification mapping** tab and scroll to the bottom to find the **All comments notification** toggle.
3. Turn on the **All comments notification** toggle.

All contributors to the article will receive email notifications when inline comments are added once the comment notification toggle is turned on.

![Portal-Screenshot-Enhanced_Comment_notification_system](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-All_comments_notification_toggle.png)

---

## Managing comments

* **View comment**: Click the yellow highlighted area or the comment icon next to the article settings to view the comment.
* **Resolve comment**: If a comment has been addressed, a Team account can mark it as resolved by clicking the (  ) icon.

  > NOTE
  >
  > Inline comments can only be resolved by the team account that created them. Other team accounts do not have the ability to resolve these comments.
* **Edit or Delete comment**: You can edit or delete your comments by selecting the **More** (•••) icon at the top of the comment box. Note that these actions are only available for comments that you have added.
* **Reply to comment**: Team accounts can respond to the comments from other Team accounts in the **Write a reply** field.

![Inline comments](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/_Screenshot-Managing_contents_in_inline_comments.png)

In the discussion section, you can filter comments by:

* **All comments:** Displays all comments, including mentioned and resolved, except deleted ones.
* **Mentioned me:** Shows only comments where you are mentioned.
* **Open**: Displays all comments that are not resolved.
* **Resolved:** Shows only resolved comments.

![Inline comments](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/_Screenshot-Managing_contents_in_inline_commentsfrom_discussion.png)

---

### FAQ (s)

**How many replies can I add to an inline comment?**

You can reply up to 20 times to an inline comment.

**What is the maximum number of inline comments I can add to an article version?**

You can add up to 500 inline comments per article version.

**Is there a character limit for the inline comment text box?**

Yes, the inline comment text box has a character limit of 500 characters.

A powerful Document360 editor with rich text editing and Markdown support, offering a visual, flexible experience compared to the Markdown and basic WYSIWYG editors.

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

<a id="adding-images-to-articles"></a>

## Adding images to articles

**Plans supporting the addition of images to articles**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Adding images to your articles enhances comprehension and engagement. Visual aids clarify complex procedures and illustrate desired outcomes more effectively than text alone. Images simplify instructions, making them easier to follow and understand. They enhance the user experience and contribute to the overall effectiveness of the documentation.

There are several methods for inserting images into your articles using the Markdown editor or the Advanced WYSIWYG editor. Each method offers its own set of advantages and allows for customization to suit your preferences.

---

## Inserting an image in the Markdown editor

You can insert images in your documentation with the Markdown editor in four methods:

Method 1: Insert image from Upload/URL

Method 2: Insert image from file picker

Method 3: Insert image using Insert file ()

Method 4: Insert image by drag and drop

Method 1

Method 2

Method 3

Method 4

#### Using upload

To insert an image:

1. Navigate to the desired article in the Markdown editor.
2. Click the Insert image () icon and select **From Upload/URL**.
3. In the **File** tab, click the **Choose File** button.
4. Select the image file you want from your local storage and click **Open**.
5. In the **Description** field, type in a description for the image.
6. Click **OK**.

   The image will be inserted into the article where the cursor is placed.

> NOTE
>
> The **height** and **width** of the imagewill not be set by default `{height="" width=""}`.

7. If required, you can specify the pixel (px) dimensions for displaying your image in the documentation.

> **For example**, {height="720" width="1280"}.

You can see the size of the image in the documentation in the Preview window.

![Adding images in the Markdown and Advanced WYSIWYG editors](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_New_Screenshot-Insert_image_from_Upload_URL.gif)

#### From URL

To insert an image using an URL:

1. Navigate to the desired article in the Markdown editor.
2. Click the Insert image () icon and select **From Upload/URL**.
3. In the **URL** tab, enter the desired **Image URL**.
4. In the **Description** field, type in a description for the image.
5. Click **OK**.   
   The image will be inserted into the article where the cursor is placed.

> NOTE
>
> The **height** and **width** of the imagewill not be set by default `{height="" width=""}`.

5. If required, you can specify the pixel (px) dimensions for displaying your image in the documentation.

> **For example**, {height="720" width="1280"}.

You can see the size of the image in the documentation in the Preview window.

![Adding images in the Markdown and Advanced WYSIWYG editors](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_New_Screenshot-Insert_image_from_URL.gif)

> NOTE
>
> We recommend adding images to the Document360 Drive and then inserting them into articles. When you upload using the image URL, If the image is removed or renamed in the future, it will appear broken in the Knowledge base sites.

To insert an image from the file picker:

1. Navigate to the desired article in the Markdown editor.
2. Click the Insert image () icon and select **From file picker**.

   The [Drive](/help/docs/drive-getting-started) window will appear with only image format files.

> NOTE
>
> You can insert any number of images in one go. The multiple image selection is available only on Markdown and Advanced WYSIWYG editors.

4. Navigate to the desired folder where the image you wish to upload is available.
5. Select the desired image(s) and click **Insert**.  
   The image will be inserted into the article where the cursor is placed.
6. If required, you can specify the pixel (px) dimensions for displaying your image in the documentation.

> **For example**, {height="720" width="1280"}.

You can see the size of the image in the documentation in the Preview window.

![Adding images in the Markdown and Advanced WYSIWYG editors](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_New_Screenshot-Insert_the_image_from_the_file_picker.gif)

To insert an image using the Insert file ():

1. Navigate to the desired article in the Markdown editor.
2. Click the Insert file ().

   The [Drive](/help/docs/drive-getting-started) panel will appear.
3. Navigate to the desired folder where the image you wish to upload is available.
4. Select the image and click **Insert**.  
   The image will be inserted into the article where the cursor is placed.

> NOTE
>
> The **height** and **width** of the imagewill not be set by default `{height="" width=""}`.

5. If required, you can specify the pixel (px) dimensions for displaying your image in the documentation.

> **For example**, {height="720" width="1280"}.

You can see the size of the image in the documentation in the Preview window.

![Adding images in the Markdown and Advanced WYSIWYG editors](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_New_Screenshot-Insert_an_image_using_the_Insert_file.gif)

You can add an image to the editor by dragging it from your local system to your editor.

The images you insert in an article through drag and drop will be saved automatically in the Document360 Drive. Any changes made to your local file will not affect the inserted image.

---

## Inserting an image in the Advanced WYSIWYG editor

You can insert images in your documentation with the Advanced WYSIWYG editor in the following methods.

1. Using the **Slash** command or **Insert** menu
2. Using copy and paste or drag and drop

Method 1

Method 2

To insert an image using the **Slash** command or **Insert** menu:

1. Navigate to the desired article in the Advanced WYSIWYG editor.
2. You can use the **slash menu** `/image` to insert the **Image**

   Alternatively, click the **Insert menu** () and select **Image**.
3. Select **Image**,and a panel will appear with following options:

   * **Upload from my device**: Click to upload or drag and drop the image file from your device's local storage.
   * **Choose from Drive**: Opens the file picker, and you can choose any image format available in your Document360 Drive.
   * **External URL**: Paste the URL of the image in the field.
4. Click **Insert**, and the image is added to the article.

You can perform a copy/paste operation for the image or click, drag, and drop an image from your device's local storage inside the article.

The images you insert in an article through drag and drop will be saved automatically in the Document360 Drive. Any changes made to your local file will not affect the inserted image.

> NOTE
>
> You can format images in the Advanced WYSIWYG editor. For more information, read the article on [Image formatting in the advanced WYSIWYG editor](/help/docs/image-formatting-in-the-advanced-wysiwyg-editor).

---

## **Troubleshooting**

### Broken image in the Knowledge base site

A broken image is an image that fails to load on a webpage, displaying a missing image icon and its alt text instead. This typically happens when the image file is deleted, moved, renamed, or the URL pointing to the image is incorrect or inaccessible.

**Steps to resolve:**

1. Retrieve the image URL from the article’s **code view** in the Knowledge base portal or by inspecting the element in the Knowledge base site.
2. Open the image URL in a browser.
3. If it results in a **404 error**, the image may have been deleted, moved, or renamed.
4. Ensure the image file still exists at the same path and with the same name.
5. As a best practice:

   1. Upload images directly to the Document360 Drive instead of using external URLs.
   2. Adding images from Document360 Drive helps organize assets efficiently and prevents broken images in the future.

![Document360 Knowledge base site appearing with a broken image](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-broken_image_troubleshooting.png)

---

### FAQs

#### Can I change the alignment of an image in Markdown?

Yes, you can change the image alignment in Markdown.

> NOTE
>
> For more information, read the article on [How to align the image in Markdown?](/help/docs/how-to-align-the-image-in-markdown)

#### What is the recommended method for inserting images into articles?

The recommended method is to upload images to the Document360 Drive and insert them directly into articles. This ensures image stability and prevents broken image links if the image is removed or renamed in the future.

#### Can I customize the appearance of the inserted images?

Yes, you can customize the alignment, size, and style of inserted images to suit your preferences and optimize the visual presentation within your articles.

#### How can I ensure accessibility for visually impaired users when adding images?

You can provide alternative text (alt text) for each image, which helps screen-reading tools describe images to visually impaired users and improves search engine optimization (SEO) for your Knowledge base.

#### How can I add icons in line with text?

To add icons in the markdown editor, simply paste the HTML code snippet of the icon wherever you want it to appear in your text. For example, use `<nor class="fa-light fa-comment"></nor>` for a comment icon.

If you are using the advanced WYSIWYG editor, place the cursor where you want the icon, switch to code view, and paste the same HTML code snippet. After pasting, save the file and switch back to the regular view. You should now see the icon in line with your text. You can find these icon snippets on websites like FontAwesome.

#### Will images copied from any external source that are pasted into Document360 be permanently stored? If yes, what happens when the external source is deleted?

If images from any external source are copied and pasted into Document360, they will be stored in the Document360 Drive. However, it is recommended to upload images directly from the Drive rather than pasting them to ensure they are not linked to any external sources.

If the images point to any external source as their original location is deleted, the images will be broken in Document360.

A lightweight text-to-HTML conversion tool used to format content such as lists, headers, images, videos, and links. Document360 includes a powerful markdown editor as one of its two basic editors.

A powerful Document360 editor with rich text editing and Markdown support, offering a visual, flexible experience compared to the Markdown and basic WYSIWYG editors.

<a id="adding-videos-in-articles"></a>

## Adding videos in articles

**Plans supporting the addition of videos in articles**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Videos can explain complex concepts better than text alone. They make it easier for users to understand instructions, tutorials, and detailed processes. Videos capture attention and keep users engaged longer than plain text. In Document360, by using **Insert video** and **Insert file** options in the toolbar you can add videos to the article and category pages.

---

## Insert a video in the Markdown editor

Two methods exist to insert a video in your article or category page.

1. **Insert video**: To insert a video by URL.
2. **Insert file**: To insert a video available in the Drive.

#### Insert video

1. Navigate to the desired article in the Markdown editor.
2. Click the **Insert video** () icon.

   The **Insert video** panel appears.
3. Paste the video URL (YouTube, Wistia, and Vimeo) in the first text field.
4. Give an alternative text for the video in the **Alt Text** field.
5. Click **OK**.

![Adding videos in the markdown via video option](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Inserting_video_in_Markdown_.gif)

---

#### Insert file

Navigate to the desired article in the Markdown editor.

1. Click the **Insert file** () icon.
2. Select the desired video from the Drive and click **Insert**.
3. Update the desired pixel height and width.

> NOTE
>
> Similarly, you can add videos to the WYSIWYG editor.

![Inserting videos via file option](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGIF-Inserting_the_file_in_markdown_.gif)

---

## Insert a video in Advanced WYSIWYG editor

1. From the Advanced WYSIWYG editor, navigate to **Insert** () > **Video**.
2. The **Insert Video** panel has three options or methods to insert a video:

   1. **Embed URL**:

      * Enter video URL: Self-hosted video URL from platforms such as Wistia, YouTube, Vimeo, and more. Update the desired pixel height and width in the editor.
      * Enter embed URL: The URL available on Video hosting platforms.
   2. **Embed code**: The embed code snippet is available with the video on specific platforms such as Wistia, YouTube, Vimeo, and more.
   3. **Drive**: Choose the desired video from the drive.
3. Click "**Insert video**".

> NOTE
>
> You can also use Slash commands `/video` to insert videos in the Advanced WYSIWYG editor.

![Inserting videos in Advanced WYSIWYG editor](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_ScreenGIF-adding_videos_in_advanced_WYSWYG_Editor.gif)

---

### FAQ(s)

**Can the search function in Document360 search captions within videos?**

No, video captions will not be fetched in the search results.

**Can Document360 detect broken videos in the articles?**

Document360's link analytics feature can identify broken links. This feature validates your project's links, including media files, videos, and images.

> For more information, please refer to the article on [Link Status](/help/docs/links-status).

A centralized, cloud-based storage repository in Document360 for storing and managing all files.

<a id="adding-files-to-articles"></a>

## Adding files to article

**Plans supporting the use of Drive**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Supporting files can clarify and expand on the article’s content, making complex topics easier to understand. In Document360, there are two ways to add files in the articles and category pages:

1. Adding files
2. Attaching files

## Adding files to articles

Adding a file to an article means embedding it directly into the body of the article, rather than as an attachment for download. To do this, the file must first be uploaded to the [Drive](/help/docs/drive-getting-started).

### Adding files in Markdown editor

1. Navigate to the desired article in the Markdown editor.
2. Select the **Insert file** () icon.
3. Choose the file from the Drive that you wish to add.
4. Click **Insert**.

> NOTE
>
> In the **Drive**, you can filter () files by:
>
> * **Uploaded:** Filter by All, 7 days, 30 days, 3 months,  1 year, or even a custom date.
> * **Uploaded by:** Select the desired contributors from the list.
> * **Type:** Choose the file type, such as PDF, JPEG, etc.
> * **Tags:** Sort files based on the tags.

![1_ScreenGIF-Update_Adding_files_in_article](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenGIF-Update_Adding_files_in_article.gif)

### Adding files in the Advanced WYSIWYG editor

1. Navigate to the desired article in the Advanced WYSIWYG editor.
2. To insert file, use slash command `/Insert file` or go to **Insert > Insert file**.

   The Insert file panel will appear in the editor.
3. You can insert the file in three ways:

   1. Drag and drop the file into the panel.
   2. Click on the **Click here to upload** text and select the desired file from your local storage.
   3. Click **Open file picker** and choose a file from the drive.
4. Click on the **Delete** () icon to remove the insert file panel if needed.

> NOTE
>
> After adding file in the article, click **Download** () to download the file in the Knowledge base site.

![Adding files to an article in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Adding_files_in_Adv_WYSIWYG_editor.png)

---

## Attaching files to articles

Attaching a file to an article allows it to appear as a downloadable link rather than embedding it directly into the article body. In the Knowledge base site, attached files are aligned above the tags and Table of Contents on the right side of the page.

1. From the desired article, click on **More** (•••) icon on the top right side.
2. Click on the **More article options**.
3. In the **Attachments** section, attach your file in one of two ways:

   * **URL**: Enter the URL and click **Insert**.
   * **Upload an attachment:** Choose your desired file and click **Upload**.
4. Once done, click **Save**.

> NOTE
>
> If you attach more than one file to an article, you can arrange the display order by dragging and dropping the file names in the menu.

![Adding files to an article in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_ScreenGIF-Adding_attachments_in_the_article.gif)

**Knowledge base site view**

![Adding files to an article in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-attached_file_in_an_article.png)

---

### FAQ (s)

**What is the difference between adding and attaching files?**

Adding files embeds them directly into the article body, while attached files are aligned above the tags and Table of Contents on the right side of the page.

**Can I filter files in the Drive when adding them to an article?**

Yes, you can filter files by upload date, contributor, file type, and tags.

**What should I do if my attached file is not visible in the Knowledge base site?**

If the attached file is not visible in the desired article, follow these steps to enable article files on the Knowledge base site:

1. Navigate to **Settings** () > **Knowledge base site** > **Article settings & SEO**.
2. In the **Article settings** tab, expand the **Article right** accordion.
3. Turn on the **Show article files** toggle if it is turned off.

<a id="linking-to-other-articles"></a>

## Adding hyperlinks

**Plans supporting the use of hyperlinks**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

In Document360, you can add hyperlinks to text, images, or files within your articles or category pages. Hyperlinks help users navigate seamlessly between related content, external resources, or specific sections within the same article, enhancing the overall reading experience.

Imagine you're writing a installation guide for software installation. You can add a hyperlink to the download page, so users can quickly access the required software without searching for it.

> NOTE
>
> Replicated articles cannot be added as internal links within other articles.

## Adding hyperlinks to an article

Markdown editor

Advanced WYSIWYG editor

To add a hyperlink in the Markdown editor, follow these steps:

1. Select the desired text and click the **Insert link** () icon at the top of the editor.

   The **Link** panel will appear.
2. In the **Link text** field, enter the text to be hyperlinked.
3. Choose one of the following linking options:

   * **Link to an existing article**: Start typing the article name in the **Search & link to existing article** field. A list of matching articles will appear.
   * **Link to a specific heading in the current article**: Use the **Link to the current article heading** dropdown to select an H2, H3, or H4 heading. The appropriate URL slug will be generated automatically.
   * **Link to an external URL**: Enter the desired URL in the **Link** field.
4. (Optional) To open the hyperlink in a new tab, select the **Open in a new tab** checkbox.
5. Click **Ok** to add the hyperlink to your content.

![Adding hyperlink in markdown editor in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenGIF-Adding_hyperlink_to_an_markdown_article.gif)

To add a hyperlink in the Advanced WYSIWYG editor, follow these steps:

1. You can access the hyperlink option in three ways:

   * Select the desired text, go to **Insert** () and click **Link**.
   * Select the desired text and press `Ctrl + K`.
   * Use the **Slash** `/`command and type `/link`.

   The **Link** panel will appear.
2. In the **Link text** field, enter the text to be hyperlinked.
3. Choose one of the following linking options:

   * **Link to an existing article**: Start typing the article name in the **Search & link to existing article** field. A list of matching articles will appear.
   * **Link to a specific heading in the current article**: Use the **Link to the current article heading** dropdown to select an H2, H3, or H4 heading. The appropriate URL slug will be generated automatically.
   * **Link to an external URL**: Enter the desired URL in the **Link** field.
4. (Optional) To open the hyperlink in a new tab, select the **Open in a new tab** checkbox.
5. Click **Insert** to add the hyperlink to your content.

![Adding hyperlink in Advanced WYSIWYG editor in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_ScreenGIF-Adding_hyperlinks_to_an_Advanced_WYSIWYG_editor.gif)

---

## Editing or unlinking a hyperlink

In the **Advanced WYSIWYG editor**, follow these steps to edit or remove a hyperlink:

1. Click the hyperlinked text. A floating menu will appear.
2. To manage the hyperlink:

   * **Open the link:** Click on the link to visit the URL.
   * **Edit the link:** Click on the **Edit** () icon to modify the hyperlink.
   * **Unlink the text:** Click on the **Unlink** () icon to remove the hyperlink.
   * **Copy the link:** Click on the **Copy** () icon to copy the hyperlink.

> NOTE
>
> In Markdown editor, you need to manually edit the hyperlink.

![Editing or unlinking a hyperlink in the Advanced WYSIWYG editor.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Editing_or_unlinking_an_article.gif)

---

## Bookmark links inside articles/page categories

When dealing with long articles or category pages, Bookmark links allow you to link directly to specific headings (H2, H3, H4) within the same article.

**For example:** If an article contains multiple sections, such as "Installation," "Configuration," and "Troubleshooting," you can create bookmark links for each heading. This allows readers to jump directly to the relevant section without scrolling.

In the **Advanced WYSIWYG editor**, follow these steps to bookmark links inside articles or page categories:

1. Select the desired text and click the **Insert** () and select **Link** ().

   Alternatively, select the desired text, and press `Ctrl+K`.

   The **Link** panel will appear.
2. In the **Link to the current article heading** field, choose a heading from the dropdown list. This creates a URL slug linking directly to that section.
3. If needed, select **Open in a new tab**.
4. Click **Insert**.

> NOTE
>
> * The **H3** and **H4** headings will only be available in the dropdown if enabled in settings. To enable them, navigate to Settings () > **Knowledge base site** > **Article settings & SEO** > **Article settings** > **Article right** and ensure **H3** and **H4** are selected.
> * If you're using the **Advanced WYSIWYG editor**, you can also press `Ctrl+K` to quickly add hyperlink to the text.

![Bookmark links inside articles or page categories in the Knowledge base portal.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_ScreenGIF-Bookmark_links_inside_articles_page_categories.gif)

---

## Adding an Email link to an article

Markdown editor

Advanced WYSIWYG editor

To add an email link to an article in Markdown editor, follow the steps below:

1. Select the text you want to link and click the **Link** () icon.
2. In the Link field, use the following Markdown format to create an email link:

   `[link_text](mailto:email_id)`

> For example, if you want to add an email hyperlink to `test@gmail.com` with the link text "Email support", type:
>
> `[Email support](mailto:test@gmail.com)`.
>
> Outcome: [Email support](mailto:test@gmail.com)

![Adding an email link to an article in the markdown editor](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_ScreenGIF-Adding_an_email_link_to_an_Article_in_markdown.gif)

To add an email link to an article in the Advanced WYSIWYG editor, follow the steps below:

1. Select the desired text and press `Ctrl + K` or use the **slash** command `/link`.

   The **Link panel** will appear.
2. In the **Link** field, type the desired email in this format: `(mailto:email_id)`.
3. Click **Insert**.

![Adding an email link to an article in the Advanced WYSIWYG editor](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/6_ScreenGIF-Adding_an_Email_link_to_an_Article_in_Advanced_WYSIWYG_editor.gif)

---

## Effect of changing an article heading on Hyperlinks

If you change the heading, the existing hyperlink will break.

**For example:** If you add a hyperlink to an H3 heading titled "Markdown editor" and later change the heading to "The Markdown editor," the hyperlink will break and no longer work.

**How to overcome this scenario?**

This method is applicable only in the **WYSIWYG editor**. When you directly update a heading, both the heading link and name are updated. However, to change the heading without affecting the heading link, you need to update the HTML tag for the heading ID.

Typically, an H2 heading is formatted as `<h2>Heading name</h2>`. To separate the heading link from the name, you can modify the tag as `<h2><a name="heading-link"></a>Heading name</h2>`.

> For example, you want to update the H2 heading name 'How Risk Analytics Works' to 'Risk Analytics'
>
> * Your current heading tag would be `<h2>How Risk Analytics Works</h2>`
> * Replace it with `<h2><a name="How-Risk-Analytics-Works"></a>How Risk Analytics Works</h2>`  
>    Heading link - `How-Risk-Analytics-Works`  
>    Heading name - `How Risk Analytics Works`
> * Now change the heading name to Risking analytics, and don't change the heading link  
>   `<h2><a name="How-Risk-Analytics-Works"></a>Risk Analytics</h2>`
> * If you have added a hyperlink for this heading, it will work fine even after changing the heading name. This is because the heading link is kept the same.

---

## **Effect of Machine translation on Hyperlinks**

When an article is translated, all internal hyperlinks in the original language are updated to link to the corresponding translated articles in the new/draft state.

**For example:** An article in English contains internal links to other articles. When translated to French, those links will redirect to the French versions of the linked articles.

> NOTE
>
> To avoid broken links in translated articles, ensure that article slugs are consistent across languages.

> For example, if the English article has the slug `/getting-started`, use the same slug for the translated version (e.g., `/getting-started` for German). This will help maintain link consistency. This is because when you add a redirect rule, the hyperlink URL text for English language is `docs/en/article_slug` and for German language is `docs/de/article_slug`.

---

### Types of URLs

#### Absolute path/URL

An Absolute path/URL includes the entire web address, from the protocol (HTTP/HTTPS) to the domain name and the path within the site. It is the complete address required to access a specific webpage, regardless of the site you are currently on. An absolute URL is used when linking to external websites or when you want to specify the full address of a page.

**For example**: `https://docs.document360.com/docs/v3/overview/interface`

#### Relative path/URL

A Relative path/URL is a shortened version of the URL that only specifies the location after the domain. It assumes that the link is within the same site and shares the same root domain. The relative path always starts with a forward slash (`/`). It is commonly used for internal links within the same site.

In Document360, relative paths are used in several places, such as the linking feature in the editor, article redirect rules, tag redirect rules, and the ticket deflector.

**For example**: `https://docs.document360.com/docs/v3/overview/interface`

Relative path: `/v3/overview/interface`

---

### FAQs

#### How do I link to an existing article in my Knowledge base?

Highlight the text you want to link, click on the **Link** () icon in the editor toolbar, type the article name in the search field, select the article, and click **Insert**.

#### Can I link to headings within the same article?

Yes, you can link to headings (H2, H3, H4) within the same article using the hyperlink () tool in the editor.

#### Do hyperlinks get auto-updated when I translate an article?

Yes, when you translate an article, all hyperlinks in the default language will direct to the respective translated language in the new article.

#### How can I link a new article to another article before it gets published?

You can link new unpublished articles to other articles before publishing them by following these steps:

1. Hover over the desired text in the editor and click the **Insert link** () icon.
2. In the **Search & link to existing article** dropdown, enter the name of the new article and select it.
3. If needed, check the **Open in a new tab**option to have the link open in a new tab.
4. Once finished, click **Insert**.

> NOTE
>
> Until you publish the linked new article, the link will be in a broken state.

#### Does an article heading hyperlink still work when I change the heading name?

No, hyperlinks would not work when you change the heading name. For example, if you have added a hyperlink for the H3 heading as “Markdown editor”, and later you change the H3 heading to "The Markdown editor", then the hyperlink would not work.

Visit this [link](https://docs.document360.com/docs/linking-to-other-articles#does-an-article-heading-hyperlink-still-work-when-i-change-the-heading-name) to find a workaround.

**Bookmark links**, also known as internal hyperlinks or cross-references, allow readers to navigate to specific sections within the same document or webpage. These links improve accessibility and help users quickly find relevant content.

<a id="code-blocks"></a>

## Code blocks

**Plans supporting Code blocks**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Document360 uses [Prism.js](https://prismjs.com/) for syntax highlighting and supports various programming languages in code blocks, including:

* HTML
* C#
* Java
* JavaScript
* XML
* JSON
* CSS
* SQL
* Python
* Markdown
* PHP
* PowerShell
* Text

For an exhaustive list of languages that are supported, please refer to the documentation for [Prism's Supported languages](https://prismjs.com/#supported-languages).

---

## Creating code blocks in the Markdown editor

In the Markdown editor, there are two methods to create fenced code blocks:

1. Use **triple backticks** ````` before and after the code snippet.

For example:

```csharp  
 [your code snippet]   
 ```

2. Use the shortcut `Ctrl+Shift+P` or click the **Insert codeblock** () icon from the formatting toolbar.

![1_ScreenGIF-Creating_code_blocks_in_the_Markdown_editor](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenGIF-Creating_code_blocks_in_the_Markdown_editor.gif)

---

## Creating code blocks in the WYSIWYG (HTML) editor

1. Navigate to the desired article in the WYSIWYG editor.
2. Click the **Code block** () icon, and a panel will appear.
3. Select your desired language from the drop down menu.
4. Enter your code into the **Insert your code** field.
5. Click **Insert** to add the code block to your article.
6. To edit a code block, click the **Edit** () icon on the right side of the code block.
7. To delete a code block, click the **Delete** () icon on the right side of the code block.

![2_ScreenGIF-Creating_code_blocks_in_WYSIWYG_HTML](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGIF-Creating_code_blocks_in_WYSIWYG_HTML.gif)

---

## Creating code blocks in the Advanced WYSIWYG editor

1. Navigate to the desired article in the Advanced WYSIWYG editor.
2. You can create code blocks in three ways:

   1. In the **Insert** section, click **Code block** ().
   2. Enter three backticks ````` and press **Enter**.
   3. Use the slash command `/code block` and press **Enter**.
3. Click on the created code block, a floating menu will appear.
4. Select the desired heading .
5. Click the Copy () icon to copy the code.
6. Click the Delete () icon to delete the code block.
7. Enter the indented code inside the code block.

![3_ScreenGIF-Creating_code_blocks_in_Advanced_WYSIWYG_editor](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_ScreenGIF-Creating_code_blocks_in_Advanced_WYSIWYG_editor.gif)

---

#### Language shortcodes

* C: c
* C++: CPP, c++
* C#: csharp
* CSS: css
* CoffeeScript: coffeescript
* HTML: html
* JSON: json
* Java: java
* JavaScript: javascript, js
* Objective-C: objective-c, obj-c, objc
* Objective-C++: objc++
* PHP: php
* Perl: perl, pl
* Python 3: python3, py3
* Python: python, py
* Ruby: ruby, rb
* Snobol: snobol
* XML: xml

#### Custom language

If the desired language is unavailable, you can create a **Custom Language** code block.

1. **In the Markdown editor**: After inserting the code block, add a title by entering the desired text after the initial backticks:

```
```HTML
Hello world
```
```

Markdown

Copy

2. **In the WYSIWYG editor**: Select **Custom** from the **Select Language** dropdown and enter your desired title in the **Enter your title** field.
3. **In the Advanced WYSIWYG editor**: Use the search bar in the dropdown to select **Custom**, then click the **Edit** () icon to enter your title and click **Update**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/ScreenGIF-Custom_Language_in_code_block.gif)

---

### Indentation and code blocks

Any text indented by at least four spaces will be treated as a code block. This method is useful for longer code snippets, but it will not include syntax highlighting.

The following code block is created using indents instead of backticks.

```
def test():
    logging.error('Test failed')
```

Python

Copy

---

### Code block examples

The following code blocks are created in various programming languages, including C#, JavaScript, XML, JSON, PowerShell, and Ruby, to dynamically showcase syntax and functionality.

**C# block**

```
using System;
namespace HelloWorld
{
    class Hello 
    {
        static void Main() 
        {
            Console.WriteLine("Hello World!");

            // Keep the console window open in debug mode.
            Console.WriteLine("Press any key to exit.");
            Console.ReadKey();
        }
    }
}
```

C#

Copy

**Javascript block**

```
function $initHighlight(block, cls) {
try {
if (cls.search(/\bno\-highlight\b/) != -1)
return process(block, true, 0x0F) +
` class="${cls}"`;
} catch (e) {
/* handle exception */
} 
export $initHighlight;
```

JavaScript

Copy

**XML block**

```
<book id="bk101">
      <author>Gambardella, Matthew</author>
      <title>XML Developer's Guide</title>
      <genre>Computer</genre>
      <price>44.95</price>
      <publish_date>2000-10-01</publish_date>
      <description>An in-depth look at creating applications 
      with XML.</description>
   </book>
```

XML

Copy

**JSON block**

```
{
    "one": 2,
    "three": {
        "point_1": "point_2",
        "point_3": 3.4
    },
    "list": [
        "one",
        "two",
        "three"
    ]
}

```

JSON

Copy

**PowerShell block**

```
$user = Read-Host "Enter Username"
$pass = Read-Host "Enter Password" -AsSecureString
```

PowerShell

Copy

**Ruby block**

```
require 'redcarpet'
markdown = Redcarpet.new("Hello World!")
puts markdown.to_html
```

Ruby

Copy

---

### FAQs

**What programming languages are supported for syntax highlighting in code blocks?**

Document360 supports syntax highlighting for languages such as HTML, C#, Java, JavaScript, XML, JSON, CSS, SQL, Python, Markdown, PHP, PowerShell, and Text.

**How do I indent the contents in a code block having multiple lines?**

To indent, manually add spaces at the start of each line where you want indentation. If you're pasting code, use the shortcut `Ctrl + Shift + V` to preserve the formatting.

**How can I create a code block in the Markdown editor?**

You can create a code block in the Markdown editor by using triple backticks ````` before and after your code snippet or by using the shortcut `Ctrl+Shift+P`.

**Is it possible to create a custom language code block?**

Yes, select **Custom** from the language dropdown, then enter your desired title.

A lightweight text-to-HTML conversion tool used to format content such as lists, headers, images, videos, and links. Document360 includes a powerful markdown editor as one of its two basic editors.

<a id="private-notes"></a>

## Adding private notes

**Plans support private notes**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

**Private notes** are a useful feature in Document360 that allow project team members and specific reader groups to see content that remains hidden from the general public. These notes can be added to articles in both the [**Markdown**](/help/docs/the-markdown-editor)and [**Advanced WYSIWYG**](/help/docs/advanced-wysiwyg-editor-overview) editors, giving you more control over what content is visible to different audiences.

## Using private notes

Private notes are ideal for leaving reminders or editorial comments within your article. They are especially useful for:

* Asking a team member to double-check information.
* Keeping notes for future updates or improvements.
* Providing extra context or instructions for other project team members working on the documentation.

> NOTE
>
> When readers download an article containing a private note via the **Download as PDF** option in the Knowledge base site, the private note is **not** included. However, if the team accounts use their browser's **Print/Save as PDF** function, the private note will be included in the exported file.

---

## Private notes in the Markdown editor

To add a private note in the Markdown editor:

Click the **Private notes** icon from the toolbar.

Alternatively, use the following syntax to create a private note:

```
:::(Internal) (Private notes)
Only visible to team accounts
:::
```

Markdown

Copy

![4-Screenshot-Markdown_editor_private_notes](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4-Screenshot-Markdown_editor_private_notes.png)

You can edit both the title (Private notes) and content (Only visible to team accounts) of the private note. You can remove a private note by deleting the corresponding syntax. This will remove the note from both the article and the preview pane. Private notes added in this format will not be visible on the public version of your article but can be accessed by team members.

### Delete private note

To remove a Private notes from the article or category page, delete the corresponding syntax from the editor.

---

## Private note in the WYSIWYG editor

1. Navigate to the desired article in the WYSIWYG editor.
2. Click the **Private note** icon from the toolbar.
3. Click on the private note, and a floating menu will appear with the following options:

   1. [Visibility settings](/help/docs/private-notes#visibility-settings) ()
   2. **Copy** () - Click to copy the private note.
   3. **Delete** () - Click to delete the private note.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Screenshot-Private_note_in_Advanced_WYSIWYG_editor.png)

---

## Private note in the Advanced WYSIWYG editor

1. Navigate to the desired article in the Advanced WYSIWYG editor.
2. Use the slash comment `/Private note` or go to **Insert** () > **Private notes.**
3. Click on the private note, and a floating menu will appear with the following options:

   1. [Visibility settings](/help/docs/private-notes#visibility-settings) ()
   2. Copy () icon - Click on the Copy () icon to copy the private note.
   3. Delete () icon - Click on the delete () icon to delete the private note.

> NOTE
>
> Private notes cannot be deleted from a **published** article or category page. You must first **Edit** the article first to remove the note.

#### Visibility settings

Click on the **Visibility Settings** () icon. A popup window will appear with three options:

* **All team account:** This is the default setting when adding a private note. By default, the toggle is turned on, and the private note appears to all team members added to the project.
* **Security groups**: Click the dropdown arrow to view and select the intended team account groups available in the project. Only these groups can view the private note.
* **Reader groups**: This option applies only in **Private** and **Mixed** mode Knowledge Bases. Click the dropdown arrow to view and select the intended reader groups available in the project.

> NOTE
>
> Selective visibility settings for private notes are only available in the WYSIWYG and Advanced WYSIWYG editors.

![_ScreenGIF-Updated_Private_note_in_Advanced_WYSIWYG](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/_ScreenGIF-Updated_Private_note_in_Advanced_WYSIWYG.gif)

---

### FAQs

**What are private notes in Document360?**

Private notes are a feature that allows project team members and specific reader groups to see content that remains hidden from the general public.

**Can I add private notes in both Markdown and WYSIWYG editors?**

Yes, private notes can be added to articles in both the Markdown and Advanced WYSIWYG editors.

**How can I delete a private note?**

To delete a private note, you need to remove the corresponding syntax in the Markdown editor or use the delete option in the WYSIWYG or Advanced WYSIWYG editors.

**Can private notes be visible to all team members?**

Yes, by default, private notes are visible to all team members added to the project, but you can adjust visibility settings.

**What visibility settings are available for private notes?**

In WYSIWYG and Advanced WYSIWYG editors, the visibility settings include options for all team accounts, specific security groups, and reader groups in Private and Mixed mode Knowledge Bases.

**Is it possible to edit private notes after they are created?**

Yes, you can edit both the title and content of the private note after it has been created.

**Do private notes appear in the public version of the article?**

No, private notes are not visible in the public version of the article.

**Can I use private notes for reminders or editorial comments?**

Yes, private notes are ideal for leaving reminders or editorial comments within your article.

Text elements within an article that are visible only to project team accounts and specific reader groups. These notes do not appear in public articles and can be added using either editor in Document360.

<a id="embedding-microsoft-streams-video-in-articles"></a>

## Embedding Stream videos in articles

**Plan supporting embedding stream videos in articles**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

You can insert both Microsoft sharePoint stream and the latest stream videos into a Document360 article. These videos can be embedded in both the Markdown and Advanced WYSIWYG editors.

---

## Embedding SharePoint Stream videos

1. Navigate to the [Streams](https://www.office.com/launch/stream) platform.
2. Select the video you wish to embed in your article.
3. Click on **Share** at the top-right of the video page, then select **Embed code**.
4. An embed panel will appear with additional parameters:

   * Choose the **Start from** timestamp (e.g., 01:23).
   * Choose the **Player size** (e.g., 640x360, 1280x720, etc.).
   * Optionally, select the following settings:

     + **Autoplay**
     + **Responsive**
     + **Show title**
5. Click **Copy embed code**.

> NOTE
>
> Ensure you manage the access permissions for the Stream video you embed in the article. Without proper permissions, the readers won't be able to view it. For more information, refer to the Microsoft Stream [support article](https://support.microsoft.com/en-us/topic/permissions-in-microsoft-stream-0b646420-0868-494f-8921-d7f3e5f9cced#) on permissions.

![Embedding stream videos in the article](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenGIF-Embedding_sharepoint_stream_videos.gif)

---

## Embedding Microsoft Stream videos in article

#### Markdown editor

1. Navigate to the desired article in the Knowledge base portal.
2. Paste the embedded video code in the indented location within the article.

![Embedding stream videos in the article](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Embedding_videos_in_Markdown.png)

---

#### Advanced WYSIWYG editor

You can embed videos in two ways using the Advanced WYSIWYG editor:

**Method 1:**

1. While editing the article, click on the **Code View** () icon.
2. Paste the embed code in the desired location.
3. Press **Ctrl + S** to save the changes.

**Method 2:**

1. Using the slash menu `/Video` or go to **Insert** () > **Video**.

   The **Insert video** panel will appear.
2. In the **Embed code** tab, paste the copied embed code.
3. Click **Save**.

![Embedding stream videos in the article](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_ScreenGIF-Microsoft_stream_videos_in_Advanced_WYSIWYG_editor.gif)

---

#### Knowledge base site view

![4_Screenshot of Knowledge base site view Embedding videos](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Knowledge_base_site_view_Embedding_videos.png)

---

### FAQs

**Can I embed Stream videos on external pages?**

Yes, you can use the **Embed Code** option on the video page. This option uses the `iframe` tag to add an inline video.

**How does embed code snippet look like?**

```
<iframe src="<Stream video URL>" width="640" height="360" frameborder="0" scrolling="no" allowfullscreen title="<Video_file_name>"></iframe>
```

Plain text

Copy

<a id="embedding-google-forms-in-article"></a>

## Embedding Google forms in articles

**Plans supporting Embedding google forms in articles**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

You can embed **Google forms** inside your Knowledge base article using the Embed HTML code block.

## Embedding Google forms

1. Go to the [**Google forms**](https://docs.google.com/forms/u/0/) page and login with your Google account.
2. You can create a new form or choose from any existing one.
3. Select the form you want to embed in your article.
4. Click the **Send** button at the top.

   The **Send form** panel will appear.
5. Select the **<>** tab to get the **Embed HTML** code.
6. Click **Copy** to copy the **iframe src** link.
7. Head back to your desired article in the Knowledge base portal.
8. In the **Markdown** editor, paste the iframe src link directly into the article.
9. In the **Advanced WYSIWYG** editor, click the **Code view** () icon and paste the iframe src link.
10. The form will appear in your article.

After publishing, readers can interact with the form for data entry, surveys, feedback, or any other purpose.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Embedded_form_in_Advanced_WYSIWYG_editor.gif)

**Knowledge base site view**

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Embedded_form_Knowledge_base_site.png)

---

### FAQs

**How can I embed a Google form in my Knowledge base article?**

You can embed a Google form by using the Embed HTML code block in your article.

**What steps are involved in embedding a Google form?**

The steps include creating or selecting a form, copying the Embed HTML code, and pasting it into your article.

**Can readers interact with the embedded Google form after publishing?**

Yes, readers can interact with the form for data entry, surveys, feedback, or other purposes.

<a id="embedding-a-drawio-diagram"></a>

## Embedding a Draw.io diagram

**Plans supporting Embedding a Draw.io diagram**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

**Diagrams.net** (commonly referred to as Draw.io) is a web-based open-source tool for creating diagrams that enables users to design flowcharts, UML diagrams, entity relationships, network diagrams, mock-ups, and more.

> NOTE
>
> All mentions of Diagrams.net or Draw.io in this support article refer to the same tool.

Diagrams.net uses Google Drive to store finished diagrams. You can embed Diagrams.net images into Document360 by using HTML and an autogenerated link, which you can find in the Diagrams.net app.

> NOTE
>
> Diagrams stored on Google Drive, Dropbox, etc., are private by default. When embedding a diagram in an article, ensure that the privacy settings for that diagram are set to public.

---

## Embedding a Draw.io diagram

There are two methods to embed Draw.io (Diagrams.net) diagrams into your Document360 editors:

1. Using the embed option
2. Exporting as an image

#### Method 1: Using the embed option

1. Navigate to [Diagrams.net](https://www.drawio.com/).
2. Click **File** > **Embed** and choose **Image.**
3. Click **Embed.**
4. Click **Copy** to copy the generated image tag.
5. Head back to the Knowledge base portal.
6. In the **Markdown** editor, directly paste the copied code.
7. In the **Advanced WYSIWYG editor**, click the Code view () icon and paste the code in the desired location.

> NOTE
>
> You can adjust the height and width of the diagram as needed.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Using_the_embed_option_Draw_io.gif)

---

#### Method 2: Exporting as an image

1. Navigate to [Diagrams.net](https://www.drawio.com/).
2. Click **File** > **Export as** and choose your desired image format**.**
3. Click **Export.**
4. Enter the **File name** and save it to your desired location (**Google Drive**, **OneDrive**, **Dropbox**, **GitHub**, **GitLab**, or your **Device**).
5. Click **Download**.
6. Head back to the article in the Document360 editor.
7. Click **Insert image** () and select **From Upload/URL**.
8. Select the intended image and click **Insert**.

> NOTE
>
> For more information, read the article on [adding images to articles](/help/docs/adding-images-to-articles).

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Embedding_Draw_io_via_image_Export.png)

---

### FAQs

**Can I embed a Draw.io diagram in Document360?**

Yes, you can embed Draw.io diagrams into Document360 articles using HTML and an autogenerated link from the Diagrams.net app.

<a id="all-articles-overview-page"></a>

## All articles - Overview page

**Plans supporting bulk operations on all articles**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The **All articles** feature in Document360 simplifies article management by enabling users to perform bulk actions on multiple articles at once. Now, in addition to individual articles, this feature also displays page categories, allowing for a more comprehensive view and streamlined management. Available actions include publishing, previewing, copying links, hiding, moving, deleting, setting review reminders, checking live article status, creating tags, machine translation, downloading as PDF, and deprecating articles.

The **All articles** feature provides a solution to this challenge, enabling users to efficiently execute actions across multiple articles in one go.

For instance, imagine you're publishing ten articles and two page categories from various categories for a product launch. With the All articles feature, you can publish them simultaneously as part of your release documentation. In such a scenario, select the desired articles and page categories on the **All articles** page and execute a bulk publishing action.

> NOTE
>
> The **All articles** feature displays all articles, including page categories.

---

## Managing multiple articles with the All articles feature

To manage multiple articles and page categories with the **All articles** feature, follow the steps below:

1. Navigate to **Documentation** () > **All articles** () on top of the **Categories & Articles** section.  
    The **All articles** page will appear.
2. Navigate to your project's different workspaces and languages using the drop-down at the top.
3. Click the **All articles** dropdown to filter articles by status.
4. Click **Export** to export the article list as a CSV file.
5. Click the **Filter** button, and from the dropdown menu, select options like Status, Date, or Tags to narrow your results. For more information, read the article on [Using filter in All articles page](/help/docs/filter-bulk-operations).
6. Select the desired articles you wish to perform the following bulk operation actions:

1. **Publish**: Publish multiple selected articles in one go. This option will appear only if you have selected new or draft articles.
2. **Publish later:** Schedule the selected articles to be published at a specified time. This option is enabled only if you have selected new or draft articles.
3. **View preview/View in KB**: **View preview** option will appear to preview the article for new and draft articles in the Knowledge base site. For published articles, by selecting **View in KB**, you can open them in the Knowledge base site.
4. **Copy link:** Copy the link for the selected articles.
5. **Hide**: Hide the selected articles so they are no longer available on the Knowledge base site.
6. **Move** to: Move the selected articles to different categories or workspaces.
7. **Delete**: Delete the selected articles. They will be sent to the recycle bin for 30 days, during which time they can be restored if needed.
8. **Review reminder**: Set a review reminder for the selected articles.
9. **Live article status**: Define the status for the selected articles.
10. **Add tags**: Create and assign new or existing tags to the selected articles.
11. **Add labels:** Create and assign new or existing labels to the selected articles.
12. **Machine translate**: Automatically translate selected articles into other languages with the Machine Translate feature.
13. **Download as PDF**: Download the selected articles as a PDF. If multiple articles are selected, they will be combined into one PDF in the chosen order.
14. **Deprecate**: Mark the selected articles as deprecated. These articles will display a Deprecated status tag in the Knowledge base site.

> NOTE
>
> In the **All articles** feature, if a page category contains both articles and subcategories, you cannot perform actions such as Hide, Move, or Delete on that page category. However, if the page category has no sub-articles, the Hide, Delete, and Move options will be applicable.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-All_articles_Overview_page(1).png)

---

### FAQs

**Can I publish multiple articles at once?**

Yes, to publish multiple articles simultaneously using the All articles feature, navigate to the **All articles** page, select the desired articles and page categories, and then select **Publish**. This feature eliminates the need to publish each article individually.

**Can I hide multiple articles at once?**

With the All articles feature, you can easily hide several articles at once. Select the articles you want to hide and use the **Hide** option to make them inaccessible to readers. The hidden articles are visible to team accounts in the portal and can be unhidden anytime.

**How does the All articles feature enhance article management efficiency?**

The All articles feature enhances efficiency by allowing bulk actions such as deletion, status change, and more on multiple articles simultaneously. This streamlines tasks, saving time and effort compared to performing these actions individually.

**Can I reuse custom filters to narrow down results?**

Yes, the All articles feature in Document360 is designed to adapt to your needs. It offers a versatile approach, allowing you to set up custom filters and reuse them in the future.

**How do I change the status of all published articles to draft in a bulk operation?**

No, you cannot change the status of published articles to draft as a bulk operation on the **All articles** page. However, you can manually navigate to each article and change its status to draft individually.

<a id="filter-bulk-operations"></a>

## Using filters in All articles page

**Plans supporting bulk operations on all articles**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

## Accessing 'All articles' filters

To manage filters in the **All articles** feature, follow the steps below:

1. Navigate to **Documentation** () > **All articles** () on top of the **Categories & Articles** section.  
    The **All articles** page will appear.
2. Navigate to your project's different workspaces and languages using the drop-down at the top.
3. Click the **All articles** dropdown to filter articles by status.
4. Use the basic filters or custom filters to narrow down the results.
5. The filters applied can be viewed at the top of the window, and they include the following:

   1. Status
   2. Review reminder
   3. Starred
   4. Visibility
   5. Read receipt
   6. Contributor
   7. Category
   8. Date
   9. Tags
   10. Labels

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-FIlters_in_All_Articles.png)

#### **a. Status**

* **All**: All articles, irrespective of the status.
* **Published**: Articles with **Published status**.
* **Scheduled**: Articles that are scheduled for publishing.
* **Draft**: Articles with **Draft status**.
* **New article**: Articles with **New article** status.
* **Broken links**: Articles that have broken links based on the recent [Link validation](/help/docs/links-status).
* **Deprecated**: Articles marked as **Deprecated** in the Knowledge base site.

#### b. Review reminder

* **All**: All articles, irrespective of the review status.
* **Fresh**: Articles without the **Needs review** status.
* **Stale**: Articles with the **Needs review** status.

#### c. Starred

* **All**: All articles, irrespective of the starred status.
* **Starred**: Articles with **Starred status**.
* **Not starred**: Articles without **Starred status**.

#### d. Visibility

* **All** - All the articles, irrespective of visibility status.
* **Visible** - All articles in the selected workspace/language except for hidden articles.
* **Hidden** - Hidden articles are marked with a strikethrough, meaning they are not visible on the Knowledge base site but still exist in your project.

#### **e. Read receipt**

* **All**: All articles, irrespective of read receipt status.
* **Enabled**: Articles with **Read receipt** enabled.
* **Disabled**: Articles with **Read receipt** disabled.

> NOTE
>
> Read receipt feature is available only for **Private** and **Mixed** projects in **KB site 2.0**. For more information, read the article on [Read receipt](/help/docs/read-receipt).

#### f. Contributor

You can search for individual contributors using the search bar and select one or more contributors from the list. The contributors are all Team accounts in the project. The default selection is **All**.

#### g. Category

You can filter articles based on their category or subcategory (visible when you expand the root-level category). You can choose one or more categories using this filter.

> NOTE
>
> Selecting a category will show only articles under that category. To select articles under a subcategory, pick them manually.

#### h. Date

You can filter articles based on their last **Updated date**. All articles in **Published**, **New**, **Draft**, and **Deprecated** status will appear.  
You can select from the preset time intervals or add custom dates. Once you choose the date, the specified time period (For example, `Jun 28, 2022` to `Jun 28, 2023`) will appear next to the selection.

* **All**
* **7 days**
* **30 days**
* **3 months**
* **1 year**
* **Custom date**

#### i. Tags

You can search for individual tags using the search bar and select one or more tags from the list. The default selection is **All tags** and **None** (articles with no tag association).

#### j. Labels

You can search for individual labels using the search bar and select one or more labels from the list. The default selection is **All labels** and **None** (articles with no label association).

---

### Custom filter

You can save a custom filter in **All articles** that you can reuse.

> **For example,** you can create a custom filter for your documentation team members with a specific date range and status indicator.

Saved custom filters can be accessed using the expand arrow to the right of the **Filter** button.

#### Saving a custom filter

1. Navigate to the Documentation () section in the Knowledge base portal.
2. Click **All articles** at the top-left of the page.  
   The **All articles** page will appear.
3. Click the **filters** dropdown, choose the desired filter, and click **Apply**.

   The applied filters are visible at the top of the list.
4. Click **Save filter**.
5. The **Save filter** panel will appear.
6. Type the intended **Filter name** (up to 30 characters).
7. Turn on the **Share filter with team members** toggle if you want the filter to be available to other team accounts. (If the toggle is not enabled, the custom filter can only be used by you).
8. Once done, click **Save**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Saving_a_Custom_filter.png)

#### Deleting a custom filter

1. Click the expand arrow () icon near the **Filter** button.
2. Hover over the desired custom filter and click **Delete** () icon.
3. Click **Yes** in the confirmation prompt.

> NOTE
>
> Once a custom filter is saved, you cannot edit it. After deleting a custom filter, you cannot revert back.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Deleting_a_custom_filter(1).png)

---

## Clear filters

You can clear the applied filter in three ways:

1. Click **Clear all** on the top of the window.
2. Navigate to the **Filter** dropdown and click **Clear**.
3. To remove an individual filter, click the **X** next to the applied filter visible above the articles list section.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Clear_filters_in_All_articles_page.png)

---

### FAQs

#### What filters can I apply to narrow down the articles?

In All articles section, you can apply filters such as Status, Review reminder, Starred, Visibility, Read receipt, Contributor, Category, Date, and Tags.

#### Can I save a custom filter for future use?

Yes, you can save a custom filter in **All articles** that you can reuse later.

#### What should I do if I want to clear all applied filters?

You can clear all applied filters by clicking **Clear all** at the top of the window or using the Filter dropdown.

#### Why is the Read receipt feature not available in my project?

The Read receipt feature is available only for **Private** and **Mixed** projects in KB site 2.0.

<a id="export-bulk-operations"></a>

## Export All articles list

**Plans supporting bulk operations on all articles**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

In Document360, you can export the list of articles and their status as a .csv (comma-separated values) file. You can filter the desired fields from the extracted CSV file and export the report.

> For example, you might want to export the published articles of a specific contributor from the last month.

---

## Exporting All articles

To export a complete list of all articles in your knowledge base,

1. Navigate to **Documentation** () > **All articles** () on top of the **Categories & Articles** section.  
    The **All articles** page will appear.
2. Navigate to your project's different workspaces and languages using the drop-down at the top.
3. Click the **All articles** dropdown to filter articles by status.
4. Choose the desired filters from the **Filter** () button.

   The following filter options are available:

   * **Status**
   * **Review reminder**
   * **Starred**
   * **Visibility**
   * **Contributor**
   * **Category**
   * **Date**
   * **Tags**
   * **Labels**
5. Once done, click **Apply**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-FIlters_in_All_Articles.png)

3. Click the **Export** ()button next to the filter.

   This action downloads the generated file to your device’s local storage in .csv format.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Export_All_articles_list.png)

The exported file consists of the following details:

* **Article title**
* **Category title**
* **Article status**
* **Date**
* **Portal URLs**
* **Site URLs**

> NOTE
>
> The downloaded file can be viewed with Microsoft Excel, Open Office, Google Sheets, Notepad, or any CSV-compatible application.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenShot-Export_articles.png)

---

### FAQ

#### **How do I retrieve both articles and their URLs from my project?**

You can use our [API endpoint to get all article lists](https://apidocs.document360.com/apidocs/project-version-articles) article to get the article title and their corresponding URLs.

To retrieve this information:

1. Enter the required details in the API request.
2. Execute the query.

The Project Version ID needed for the query can be found using the [Get Project Versions endpoint](https://apidocs.document360.com/apidocs/get-project-versions) article.

#### How can I export draft articles?

You cannot export draft articles individually. However, you can export the category containing the draft articles. To do this, follow these steps:

1. Navigate to **Documentation** () > **All articles** () on top of the **Categories & Articles** section.  
    The **All articles** page will appear.
2. Click the **All articles** dropdown to filter articles by status. Select **Draft** status.
3. Choose the **Category** filter from the **Filter** () button.
4. Select the category that includes the draft articles you want to export.
5. Click **Export** to export the entire category to access the draft articles in it.

<a id="review-reminders"></a>

## Article review reminder

**Plans supporting article review reminder**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

**Review reminders** help team accounts deliver the most accurate information to customers and internal teams by alerting project members when an article is ready for review. This helps keep your articles up to date.

---

## Review reminder

Create and apply review reminders to flag an article for review immediately or set the review reminder to trigger on a specified date. You can also apply a review reminder individually or to a group of articles. When an article needs review, a red badge (article status indicator) will appear on the left of each article title in the documentation editor.

### Creating a review reminder for an article from the Documentation editor

1. Navigate to the desired article in the Knowledge base portal.
2. Click on the More (•••) icon in the top right corner and select **More article options**.

   The **Article settings** pane will appear.
3. The **Review reminder** tab will be selected by default.
4. Select a date for the reminder to trigger. Options include, Now, 30 days, 3 months, and Custom date.
5. Enter a reason for the review. Ensure it is descriptive enough to provide context for the team member reviewing the article. This field is **optional**.

   > NOTE
   >
   > In the **Reason for review** field, you can enter up to 100 characters.
6. Click **Save**.

A **Needs review** tag will appear next to the article slug in the Documentation editor. When team members hover over the **Needs review** tag, they can view the reason for the review.

![ Creating a review reminder for an article from the Documentation editor](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Review_reminder_in_more_options.png)

### Clearing a review reminder

Once an article in need of review has been edited and updated, follow these steps to clear the review reminder state:

1. Navigate to the desired article and click the **Needs review** tag at the top of the article editor.
2. Click **Mark as reviewed**.

The **Needs review** tag will be removed, and the article status indicator will revert to the updated/draft/new status.

![Clearing a review reminder in documentation editor](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGIF-clearing_review_reminder.gif)

---

## Marking multiple articles as Reviewed or Needs review

You can mark multiple articles as Reviewed or Needs review using two methods:

### **All articles**

1. Navigate to the Documentation () and click on **All articles** tab.
2. In the **Filter** () option, expand the **Review reminder** dropdown and select **Stale**.
3. Select the articles you want to mark as reviewed.
4. Click the **Mark as Reviewed** option at the top
5. Similarly, to mark multiple articles as **Needs review**, select the desired articles, click **Review reminder**, and choose the intended reminder days.

![Article review reminders in all articles section](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_ScreenGIF-Marking_multiple_articles_in_all_articles.gif)

---

### **Article review reminders in content tools**

1. Navigate to Documentation () > **Content tools** > **Documentation** > **Article review reminders**.

   The **Article review reminders** page will appear with a list of reminders you have already created.
2. Click **Create review reminder.**

   The **Create reminder** pane will appear.
3. Enter the Reminder name, set the reminder frequency, and add the desired reviewers.
4. Once done, click **Next**.
5. Select the desired **Workspace** and **Language**.
6. Select the desired articles and click **Set reminder**.

> NOTE
>
> You can apply **Filter ()** options to retrieve articles based on category, contributor, tags and date.

![Article review reminders in content tools](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_ScreenGIF-Articles_review_reminder_in_content_tools.gif)

---

## FAQ(s)

**How do I set a review reminder for all articles in my project?**

To set a review reminder for specific articles or all articles in your project, navigate to Documentation () > **Content tools** > **Documentation** > **Article review reminders**.

<a id="article-seo"></a>

## Article SEO

**Plans supporting the use of article and SEO settings in knowledge base site**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Search Engine Optimization (SEO) is crucial for ensuring your articles gain visibility and reach their target audience effectively. Add SEO title and descriptions to your article to make improve their visibility on the web and get the article indexed in web Search engines.

---

## Adding SEO title and description

1. Navigate to the desired article in the Knowledge base portal.
2. Click on the **More** (•••) icon and click **SEO.**

   The **Article settings** window will appear.
3. Go to the **SEO** tab.
4. If needed, you can select the **Exclude from external search engine results** checkbox to prevent the articles from appearing in external search engines like Google, Yahoo, Bing, and more.
5. Enter the desired [**Meta title**](/help/docs/article-seo#editing-the-meta-title).

   > NOTE
   >
   > A meta title is a concise, impactful title displayed on search engine results pages (SERPs) that summarizes a webpage’s content. For optimal visibility, it’s typically recommended that it be between 5 and 60 characters.
6. The slug is auto-generated when the article is created. If needed, you can edit the slug.
7. Enter the desired **Description**.

   A meta description is a brief summary beneath the meta title, providing a snippet of the webpage's content. It's advisable to keep it compelling, informative, and within 150-160 characters to enhance click-through rates on search results.
8. You can use the **Ask Eddy AI**, an AI SEO description generator to help you create the description.

![Excluding articles from the external search](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Excluding_articles_from_External_search_engines.png)

> NOTE
>
> To generate SEO description for multiple articles, navigate to Documentation **()** > **Content tools** > **Documentation** > **SEO description**.

---

### Editing the Meta title

The Meta title is a key HTML element that defines the title of a webpage. It plays an important role in **SEO**, helps with **search engine rankings**, and appears as the clickable title in search results and browser tabs.

To edit the Meta title, follow the below instructions:

1. Navigate to the desired article in the **Knowledge Base portal**.
2. Click on the **More (•••)** icon and select **SEO**.
3. Click on the **Meta title** field in the Article Settings panel.
4. Click **Save**.

   The updated Meta title will appear as the article title on the Knowledge base site.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Editing_Meta_title.gif)

---

### FAQs

#### If I update an SEO description for a document in English, will it automatically translate to French or any other language in which the document is available?

No, updating the SEO description for a document in one language will not automatically translate it into other languages. You will need to update the SEO descriptions in each specific language manually the document is available in to ensure accuracy and relevance.

#### Why is my AI SEO description generator disabled even though I have Eddy credits?

To use the Eddy AI for generating an SEO description, your article must have a word count of at least 200 words.

#### The article name on the Knowledge base site does not update even after renaming it in the portal. How can I change this?

To update the article name on the Knowledge base site, you will have to change the SEO’s meta title of the article.

1. Click on the More () icon and go to **SEO**.
2. Update the meta title and save the changes.

<a id="excluding-articles-from-searches"></a>

## Excluding articles from search engines

**Plans supporting the exclusion of articles from search engines**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

To manage the visibility and confidentiality of your content, you can easily exclude certain articles or category pages from search engine results using Document360. This helps in ensuring the sensitive or internal content remains private and not publicly searchable.

---

## Excluding articles from external search engines

1. Navigate to the desired article or page category you want to exclude from search results.
2. Click the **More** (•••) icon in the top right corner.
3. From the dropdown menu, choose the **SEO** option.

   The **Article settings** panel appears.
4. In the **SEO settings**, select the **Exclude from external search engine results** checkbox.
5. Click **Save** to apply the changes.

By following these steps, you can include/exclude articles from the external search results.

![Excluding articles from the external search](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Excluding_articles_from_External_search_engines.png)

---

## Excluding articles from Search results and Eddy AI assistive search

> NOTE
>
> For users on the new pricing plan, AI search suite is available for Business and Enterprise plans. For legacy (old plan) users, only customers who have purchased Eddy AI assistive search as an add-on will have **Exclude from Eddy AI assistive search** toggle.

1. Navigate to the desired article or category page in the Knowledge base portal.
2. Click the **More** (•••) icon in the top right corner of the article or category page.
3. From the dropdown menu, choose **More article options.**

   The **Article settings** panel will appear.
4. In the **Article settings** panel, go to **Search Visibility** section.
5. In the **Search visibility**, select the desired options:

   1. Click **Exclude from the knowledge base search** checkbox to excludes articles from search results within the knowledge base site.
   2. Click **Exclude from Eddy AI assistive search** checkbox to excludes articles from Eddy AI assistive search results within the knowledge base site.

> NOTE
>
> You can exclude articles from Eddy AI Assistive Search only if you have purchased the Eddy AI Suite.

6. Click **Save** to save the changes.

![Excluding articles from AI assistive search and knowledge base search](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Excluding_articles_from_Eddy_AI_assistive_and_Search_engines.png)

> NOTE
>
> The article will still be accessible via the URL or navigation menu even after configuring it to be excluded from Knowledge Base searches and Eddy AI searches.

---

### FAQs

**What happens if the article is cloned?  Will the Search visibility settings remain the same?**

If the article is cloned, the Search visibility settings will also apply to the cloned article.

**What happens to hidden articles if we select to exclude articles from search engines?**

By default, if your article is hidden, its information will not be fetched in the knowledge base search or the AI assistive search.

<a id="changing-the-url-of-an-article"></a>

## Change the URL of an article

**Plans supporting changing the URL for an article**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

By default, when you create an article, articles will convert the article title into a slug and add it to your knowledge base URL.

For example, if an article title is “*This is a really good content*,” the resulting URL would be: `docs.yourcompany.com/[project version]/docs/this-is-really-good-content`.

You can easily change the slug of the article URL inherited from the title, `.../this-is-really-good-content`.

> NOTE
>
> Changing an article’s title does not automatically change the article slug.

---

## Changing the slug of an article

You can change the slug of an article in two ways.

**Method 1**

1. Navigate to the desired article in the Knowledge base portal.
2. Click the **More**() icon in the top right corner and then choose **More article options**.
3. In the **Article settings** panel that appears, go to the **SEO** tab.
4. Update the slug in the Slug field.
5. Click **Save**.

> NOTE
>
> While changing the slug of an article, ensure that you apply the redirection rule to the new slug. For more information, read the article on [Article redirect rule](/help/docs/article-redirect-rules).

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Changing_theURL_for_an_Article.png)

**Method 2**

You can also change an article URL in the editor.

1. Navigate to the desired article.
2. Click the slug field provided next to the article status badge.

![article slug 2](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/article%20slug%202.png)

3. Update the necessary changes in the field provided under **URL Slug**.
4. Click **Update** to save the changes.

![3_slugupdate_articleredirect.png](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_slugupdate_articleredirect.png)

5. Click **Yes** in the **Article details confirmation** prompt to redirect the article to the updated URL slug.
6. Deselect the checkbox to avoid applying the redirecting rule.

> **NOTE**
>
> **Redirect Rule:** If you change the article slug after publishing, Document360 will prompt you to set up a redirect rule to ensure that any links to the old slug remain functional. While setting up a redirect rule is optional, it is recommended.

---

### FAQs

#### What is the default URL format for an article?

The default URL format for an article is based on the article title, converted into a slug. For example, if the article title is '`This is a really good content`', the resulting URL would be: `docs.yourcompany.com/[project version]/docs/this-is-really-good-content`.

#### Does changing the article title automatically change the slug?

No, changing an article’s title does not automatically change the article slug.

#### Is it necessary to apply a redirect rule when changing the slug?

While applying a redirect rule is optional, it is recommended to ensure that any links to the old slug remain functional, avoiding broken links.

#### Why use special characters like ä, ö, ü in URLs?

Special characters like **ä**, **ö**, and **ü** are often part of words in languages such as German. When creating URLs for knowledge base articles or other web content, using these characters can make the URL:

1. **More intuitive:** The URL reflects the exact title or content of the article, making it easier for users to understand.
2. **Language-specific:** It preserves the linguistic integrity of terms or phrases specific to a language.
3. **SEO-friendly:** Search engines can associate the URL more accurately with the content, improving visibility for users searching in that language.

However, due to technical encoding requirements, these characters must be properly percent-encoded to function correctly in web links. Always copy URLs from the portal to ensure they work as expected when shared.

#### Why do URLs with special characters (e.g., ä, ö, ü) break when shared?

When URLs contain special characters like **ä**, **ö**, or **ü**, they need to be percent-encoded for proper handling in web links. If these characters are not encoded, the URLs may break when shared or accessed, resulting in errors. This behavior is consistent across all browsers and messaging tools.

1. **Copy the URL from the Document360 portal:**  
   Always copy the URL directly from the **portal** instead of from the browser's address bar. This ensures that the encoded URL remains intact when shared.
2. **Browser behavior:**

   * When you paste the URL in a browser, the percent-encoded characters may be decoded automatically.
   * This is normal behavior and does not impact the functionality if the link is used directly from the portal.

   By copying the link from the portal, the encoded characters remain intact, allowing the link to work as expected when shared with others.

If the issue persists after following these steps, please contact the Document360 support team for further assistance: [Contact Document360 Support](https://document360.com/support/)

#### Is it possible to change the URL of articles to numbers instead of the title?

Yes, in Document360, you can change an article’s URL to use numbers instead of the title:

1. Navigate to the desired article.
2. Click the slug field provided next to the article status badge.
3. Update the necessary changes in the field provided under **URL Slug**.
4. Click **Update** to save the changes.

<a id="article-tags"></a>

## Article tags

**Plans supporting tags**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Article tags are keywords that users, readers, or team accounts might use to search for content related to the articles in the Knowledge base site. Team accounts can use these tags to search, filter, sort, and perform bulk operations on articles or category pages within the project.

> NOTE
>
> * The **Tags** page allows you to manage all tags across your project. The same tag can be applied to articles, category pages, and drive files. For more information, read the articles on [Tags](/help/docs/tags).
> * The tags added to the files in Drive can only be viewed in the Knowledge Base portal.

---

## Adding tags to an article or category page

To add tags to an article or category page, follow the steps below:

1. Navigate to the desired article in the Knowledge base portal.
2. Click the **More** () icon in the top right corner and select **Tags**.
3. Create a new tag or choose an existing one from the dropdown of relevant matches.
4. Click Ask Eddy AI to generate AI-suggested tags and select the appropriate ones.

   > NOTE
   >
   > To use the AI tag generator, your article must have a word count of at least 200 words.
5. After adding the tags, click **Save**.
6. Click **Publish** and expand the **Configure article settings** dropdown.
7. Add or delete tags as needed from the list in the **Tags** section.
8. Click **Yes** to publish the article.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenGIF-Adding_tags_in_the_articles.gif)

---

### Guidelines for tags

Follow these guidelines when creating and adding tags to the **Tag** Library:

1. The tag character limit with spaces is **30**.
2. Tags names can include:

   * Upper and lowercase letters (multi-language support)
   * Numbers
   * Spaces
   * Certain special characters: **\_ + - @ # % ^ & ! ()**
3. Tags cannot contain: **\ / : \* ? “ < > |**

> NOTE
>
> For more information, read the article on [Tags](/help/docs/tags)**.**

---

### Tags in Knowledge base site

Once you add tags to an article or category page and publish it, readers will see those tags on the Knowledge base site.

![Tags readers POV.png](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Tags%20readers%20POV.png)

Readers can click on a tag to see a list of all articles and category pages associated with that tag.

![tags readers pov 2.png](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/tags%20readers%20pov%202.png)

<a id="adding-article-labels"></a>

## Add article labels

**Plans supporting the use of labels in articles**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Labels help streamline content management and organization within the Knowledge base portal. Using article labels, you can efficiently sort, filter, and categorize articles efficiently, saving time.

For instance, if you need to filter release notes specifically to perform updates or review them, use the label filter in the **All articles** () section to locate these articles quickly.

> NOTE
>
> Article labels are only available in the Knowledge base portal and are supported across all plans.

---

## Adding labels to articles

You have multiple options for adding labels to articles. The steps below outline each method available in the Knowledge base portal.

**Method 1:** Adding Labels from the article editor

**Method 2:** Adding Labels from the All articles section

**Method 3:** Adding Labels from the Workflow assignments section

**Method 4:** Adding Labels from the Starred section

**Method 5:** Adding Labels from the Folder or Index category

Method 1

Method 2

Method 3

Method 4

Method 5

To add labels to an article in the editor, follow these steps:

1. Navigate to the desired article in the Knowledge base portal.
2. Click the **More** () icon and select **Labels**.

   Alternatively, click **More** () > **More article options** and go to **Labels** tab in the **Article settings**panel.
3. In the **Add labels**panel, enter the desired label name and press **Enter**.

   Alternatively, to add an existing label, type the label name and select it from the dropdown list.
4. Click **Add**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenGIF-Adding_labels_in_the_article_editor.gif)

###

To add labels in the **All articles** section, follow the steps below:

1. Navigate to **Documentation** () > **All articles** () icon on top of the **Categories & Articles** section.
2. Select the desired articles and at the top, click the **More** () icon > **Add labels**.

   The **Add labels** panel will appear.
3. Enter the desired label name and press **Enter**.

   Alternatively, to add an existing label, type the label name and select it from the dropdown list.
4. Click **Add**.
5. Use the Filter dropdown to sort articles by label:

   1. Click **Filter** and expand **Labels** section.
   2. Choose your labels or search for specific ones.
   3. Click **Show more** to view additional labels and click **Apply** to filter.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGIF-Adding_labels_in_the_All_articles_section.gif)

To add labels in the **Workflow assignments** section, follow the steps below:

1. Navigate to **Documentation** () > **Workflow assignments** () on top of the **Categories & Articles** section.
2. Select the desired articles and click **Add labels** at the top.
3. Enter the desired label name and press **Enter**.
4. Use the **Labels** filterto narrow articles based on labels.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_ScreenGIF-Adding_labels_in_workflow_assignment.gif)

To add labels in the **Starred** section, follow the below steps:

1. Navigate to **Documentation** () > **Starred** () on top of the **Categories & Articles** section.
2. Select the desired articles and click **Add labels** at the top.
3. Enter the desired label name and press **Enter**.
4. To label a specific article, hover over it, click **More** (), and select **Add labels**.
5. Click **Add**.
6. Use the **Labels** filterto narrow articles based on labels.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_ScreenGIF-Adding_labels_in_Starred_articles.gif)

To add labels from a Folder or Index type category, follow these steps:

1. Navigate to the desired category in the Knowledge base portal.
2. To label a specific article, hover over it, click the **More**() icon, and select **Add labels**.

   Alternatively, select multiple articles and click **Add labels** at the top.
3. Enter the desired label name and press **Enter**.
4. Click **Add**.

![Adding labels from the category in the Knowledge base portal.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_ScreenGIF_Adding_labels_from_category.gif)

---

### FAQs

#### How many labels can I add to a project?

You can add up to 10,000 labels per project.

#### Is there a limit on the number of labels per article?

Yes, you can add up to 10 labels per article.

#### Can I use the same label across different articles?

Yes, you can reuse labels across multiple articles within the same project.

#### What is the difference between tags and labels?

**Tags** are keywords visible on both the Knowledge base site and portal, helping users categorize articles, enhance navigation, and optimize search results.

Whereas **labels** are exclusively available in the Knowledge base portal. They are used for internal content organization and management and are not visible to end users on the site.

#### Can I search for a specific article using labels in the Knowledge base portal?

No, labels cannot be used directly in search. However, you can filter articles by labels in the **All articles** section.

#### Can I add labels to images and videos?

No, currently, labels can only be added to articles.

#### Will labels appear in the Knowledge base site?

No, labels are only for internal use within the Knowledge base portal and do not appear on the Knowledge base site.

<a id="related-articles"></a>

## Related articles

**Plans supporting addition of related articles**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Related articles help readers navigate between articles the author selects that relate to the article. The added articles appear at the bottom of the article on the Knowledge base site.

> NOTE
>
> * Only published articles can be used as related articles.
> * The related articles appear only in the Knowledge base site.
> * The related articles will not appear in the Knowledge base widget.

---

## Adding Related articles

To add related articles, from the Knowledge base portal:

1. Navigate to **Documentation** () in the Knowledge base portal.
2. Select any published or unpublished article.
3. Click the **More** () icon on the top right and click **Related articles**.
4. In the search bar enter the keyword you wish to search and the results will be displayed.
5. Click on the cross **(x)** icon to the right of the search bar to remove the search keyword.
6. Click on the add **(+)** icon to the right of the article you wish to add to the related article list.
7. All the added articles will be listed under the title **Added articles**.
8. Click the cross **(x)** icon to remove the article from the added list.
9. Once done, click **Save**.

   You can also add related articles in the Publish checklist popup.
10. Click **Publish** on any article.

    The **Publish confirmation** prompt will appear.
11. Expand the **Configure article settings** section.
12. Scroll down to view the Related articles.
13. Click **Yes** to save and publish the changes.

---

### Eddy AI recommender

1. Click **Ask Eddy** to get recommendations from the Eddy AI on adding related articles

   > NOTE
   >
   > To use the AI related article recommender, your article must have a word count of at least 50 words.
2. The suggested articles will be displayed under the title **Suggested articles from Eddy AI**.
3. Click on the add **(+)** icon to the right of the article you wish to add to the related article list.
4. The article will be added to the list of **Added articles**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenGif-Related_articles.gif)

> NOTE
>
> **AI related article recommender**
>
> After purchasing the Eddy AI add-on, click the **Ask Eddy AI** button below the search bar in the Related Articles tab to use the [AI-powered related article recommender](/help/docs/ai-related-articles-recommender).

---

### Auto relate

Turn on the **Auto relate this article to all related articles** toggle on the **Article settings** window to automatically link the active article to other related articles.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenShot-Related_articles.png)

---

### FAQ

#### If a reader doesn't have access to an article, will it appear under the Related articles section in the Knowledge base site?

No, if a reader lacks access to a specific article, the link to that article will not appear in the **Related articles** section of any other articles in the Knowledge base site. Only articles accessible to the reader will be displayed in this section.

The public-facing website where end-users can access articles and find answers to their questions.

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

<a id="featured-image"></a>

## Featured image

**Plans supporting for adding feature image**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

A featured image is a representative thumbnail commonly found at the top of content in most CMS (Content Management System) platforms. In Document360, the featured image serves a different purpose. Instead of being displayed at the top of an article, it is used mainly for SEO purposes, helping search engines and enhancing link previews when the article is shared on external platforms.

---

## Adding a featured image to an article

To add a featured image to an article:

1. Open any article (published or unpublished) in the Knowledge base portal.
2. Click the **More (•••)** icon in the top-right corner and select **More article options**.
3. In the **Article settings** panel, click the **Featured image** tab.
4. Click **Upload an image**.

   The Drive's file picker panel will appear.
5. Select the desired image and click **Save**.

> NOTE
>
> Follow these recommendations when uploading featured images:
>
> * **Image size**: Optimal dimensions range from 1200x800 pixels to 2000x1200 pixels for clarity and responsiveness across devices.
> * **Image type**: Use high-quality JPEG or PNG formats to maintain image integrity and enhance visual appeal.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenGIF-Adding_Feature_Image_in_Articles.gif)

<a id="attachments"></a>

## Attachments

**Plans supporting for adding attachments**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

## Adding attachments to an article

1. Navigate to any article (Published or Unpublished) in the Knowledge base portal.
2. Click on the **More** (•••) option and select **More article options**.
3. Click on the **Attachments** tab in the **Article settings** panel.
4. Add the file URL if hosted externally, or click **Upload an attachment** if the file is available in **Drive**.
5. Select the indented file and click **Insert**.
6. Rearrange the attachments using the reorder () icon.
7. Click the () icon to remove any attachment.

   The attachment will appear near the Table of Contents and Tags on the Knowledge base site.

![Adding attachments in the Knowledge base](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenGIF-Adding_attachment_in_the_Knowledge_base_portal.gif)

**Knowledge base site view**

![Adding attachments in the Knowledge base](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Added_attachment_in_the_Knowledge_base_side.png)

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

<a id="status-indicator"></a>

## Status indicator

**Plans supporting status indicator**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The **Status indicator** is visible in the Knowledge base site near the article title. There are three possible indicators: **New**, **Updated**, and **Custom**.

---

## Automatic "Status indicator" update

If the **Automatically set article status** toggle is enabled, the status indicator automatically updates every time an article or category is published.

1. Navigate to **Settings** () > **Knowledge base site** > **Article settings & SEO** in the Knowledge base portal.

   By default, **Article settings** tab will be selected.
2. In the **Category manager** accordion, turn on the **Automatically set article status** toggle.
3. In the **Show article status for field**, enter the number of days the status should appear.

> NOTE
>
> For more information, read the article on [**Category manager**](/help/docs/knowledge-base-category-manager).

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Automatic_Status_Indicator_update.png)

---

## Manually updating the "Status indicator" for an article

To manually update the status indicator for an article:

1. Navigate to your desired article (published or unpublished) in the Knowledge base portal.
2. Click the **More** (•••) icon and select **More article options**.
3. In the **Article settings** panel, select the **Status indicator** tab.
4. Choose the desired status from the drop-down.
5. In the **Show status for** field,enter the number of days the status should persist in the Knowledge base site.
6. Click **Save**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Manually_updating_status_indicator_in_an_Article.png)

### Setting a Custom status indicator

To customize the status indicator text:

1. Navigate to **Settings** () > **Knowledge base portal** > **Localization & Workspaces** > **Localization variables** in the Knowledge base portal[.](http://Variables.Select)
2. Expand the **Category manager** accordion and edit the **Custom** field to modify the status indicator text.
3. Click **Save**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Customizing_the_status_indicator_text.png)

To set the custom status indicator color:

1. Navigate to **Settings** () > **Article settings & SEO** in the Knowledge base portal.
2. By default, the **Article settings** tab will be selected.
3. In the **Category manager** accordion, choose the desired color for the **Custom status indicator.**
4. Click the  icon to save the changes.
5. Hover over the **Background color** () icon to preview the custom status indicator.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Custom_Status_Indicator_color.png)

> NOTE
>
> For more information on custom status indicator, read the article on [**Category manager**](/help/docs/knowledge-base-category-manager).

---

## Knowledge base site view

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Status_Indicator_KB_site_View.png)

* **New** (green dot): Appears when an article is published for the first time.
* **Updated** (orange dot): Appears when an article is edited and republished.
* **Custom**: Can be set manually by the team.

The public-facing website where end-users can access articles and find answers to their questions.

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

<a id="article-status"></a>

## Article status

**Plans supporting Article status**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Article status helps you easily identify the current status of articles in the Knowledge base portal, eliminating the need to check each article individually.

For instance, a content manager can quickly identify **Draft** articles that need editing before publishing or spot **Needs review** articles flagged for review by contributors. This helps streamline the process of updating and maintaining the knowledge base efficiently without manually checking each article's progress.

> NOTE
>
> An article or category page will display article statuses (New/Updated/Custom) on the Knowledge base site, helping readers to know when content has been added or updated. For more information, read the article on [**Status indicator**](/help/docs/status-indicator).

---

## Article status in the Knowledge base portal

Within the Knowledge base portal, articles can have one of four statuses, each indicated by a unique color-coded icon next to the article in the left navigation pane.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-All_four_article_status.png)

> NOTE
>
> The article status also applies to category pages.

### New article (article status blue.png)

The article has been created and is in draft mode but yet to be published. It can be only accessible by team members within the portal.

> NOTE
>
> For category pages, the status appears as **New category page**.

### **Draft status (article status yellow)**

A published article is being forked to update the content in a draft form, while the original version remains live in the Knowledge base site.

### Published (article status-green)

The article is public and available for readers to view on your Knowledge base site.

### Needs review (article status pink)

The article has been flagged for review, either by a contributor or through an automated review reminder. For more information, read the article on [Article review reminder](/help/docs/review-reminders).

---

## Article status of hidden articles

Hidden articles are shown with a strikethrough and will not be available on the Knowledge base site. These articles are only accessible through the Knowledge base portal. You can hide articles in any status. For more information, read the article on [Hiding an article](/help/docs/hiding-article).

> NOTE
>
> Articles in a hidden category are also hidden on the Knowledge base site

---

### FAQs

**What is the purpose of article status in the Knowledge base portal?**

Article status helps you easily identify the current status of articles, streamlining the process of updating and maintaining the knowledge base.

**What are the different article statuses available?**

The article statuses are New, Draft, Published, and Needs review.

**What happens to articles flagged as Needs review?**

Articles flagged as Needs review have been marked for review by a contributor or through an automated reminder.

**Do category pages also display article statuses?**

Yes, the article status also applies to category pages.

<a id="preferences"></a>

## Preferences

**Plans supporting for preferences**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

## Updating the preferences for an article

To update the preferences in an article from the Knowledge base portal, follow the steps given below.

1. Navigate to any article (Published or Unpublished).
2. Click the **More** (•••) icon at the top right.
3. Click on the **Preferences** tab in the **Article settings**.
4. Select or clear the checkbox next to each option to enable or disable respective preferences.

   * **Allow comments**: Allow readers to comment via Disqus.
   * **Show table of contents**: Display the table of content in your article.
   * **Enable feedback**: Allow end-users to comment on articles within a knowledge base.
5. Click **Save**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Preference%20tab%20overview%20page(1).png)

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

<a id="showhide-table-of-contents-for-an-article"></a>

## Show/hide table of contents for an article

**Plans supporting show/hide of content for an article**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

You can choose to show or hide the table of contents at two levels. One can show or hide the table of contents for the entire knowledge base or an individual article.

#### Show or Hide the table of contents at Knowledge base site level

1. Navigate to **Settings** () > **Knowledge base site** and select **Article Settings & SEO** in the Knowledge base portal.
2. In the **Article settings** tab, you can toggle on or toggle off the **Show table of contents** under the **Article right** section.

   The changes will be saved. A confirmation pop-up will be displayed at the top right corner.

![1_TOC_artcilesettings.gif](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_TOC_artcilesettings.gif)

#### Show or Hide the table of contents for an individual article

1. Navigate to the desired article.
2. Click the **More** (•••) icon in the top right corner and then choose **More article options**.

   The **Article settings** panel will appear.
3. Click on the **Preferences** tab and select the **Show table of contents** checkbox to show the table of contents.
4. Uncheck the checkbox to hide the table of contents.
5. Click **Save**.

By following the above-mentioned steps, you can show or hide the table of contents at the Knowledge base site level or for an individual article.

![2_Article_TOC.gif](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Article_TOC.gif)

---

### FAQs

**Can I show or hide the table of contents for the entire knowledge base?**

Yes, you can toggle the table of contents visibility at the knowledge base site level.

**How do I show or hide the table of contents at the knowledge base site level?**

Navigate to **Settings** () > **Knowledge base site,** select **Article Settings & SEO**, and toggle the **Show table of contents** option.

**Is it possible to hide the table of contents for an individual article?**

Yes, you can hide the table of contents for an individual article.

**What steps do I need to follow to hide the table of contents for a specific article?**

1. Navigate to the article, click the **More** (•••) icon, select **More article options.**

   The **Article settings** panel will appear.
2. Go to the **Preferences** tab, and deselect the **Show table of contents** checkbox.
3. Click **Save**.

**Does bold text used as headings appear in the table of contents?**

No, bold texts will not appear in the table of contents. Only headings formatted as H2, H3, and H4 will appear in the table of contents.

<a id="marking-articles-as-deprecated"></a>

## Mark as deprecated

**Plans supporting mark as deprecated**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

## What is a deprecated article?

In the context of a knowledge base, a deprecated article is flagged as obsolete and may no longer be relevant or valuable for the reader. It is usually replaced by more up-to-date information. Articles may be marked as deprecated for various reasons, such as the core subject being removed, no longer in use, modified, or replaced with a different concept.

For instance, if a product feature is removed or significantly changed, you can mark the related article as deprecated. This helps readers avoid outdated information and redirects them to updated resources or newer articles.

### Mark as deprecated

Previously, the **Mark as deprecated** option was available at the workspace level. Now, this feature is available at the article or page category level, where the article will display a **Deprecated** status tag. Additionally, you can provide a custom deprecation message explaining the reason for deprecation and include hyperlinks to any alternate or updated versions of the article/page if applicable.

---

## Marking an article as deprecated

1. Navigate to the article (published or unpublished) in the Knowledge base portal.
2. Click the **More** (•••) icon and select **More article options**.
3. In the **Article settings** panel, select the **Mark as deprecated** tab.
4. Turn on the **Deprecated** toggle.
5. Enter the reason for deprecating the article in the text field. This message is optional and will be displayed on the Knowledge base site.
6. Use basic text formatting options like Bold (), Italics (), and Underline (), or add Hyperlinks ()if needed.
7. Once done, click **Save**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Article_settings_deprecating_An_article.png)

---

## Marking multiple articles as deprecated

To mark multiple articles as deprecated in one instance, follow the steps below:

1. Navigate to the **Documentation** () and select **All articles** in the Knowledge base portal.

   A list of all articles will appear in the **All articles** page.
2. Select the articles you want to mark as deprecated.
3. Click the **More** (•••) icon and select **Deprecate**.

   By default, the **Deprecate** toggle will be enabled.
4. Enter the **Deprecation message** in the text field.
5. Once done, click **Apply**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Deprecating_multiple_article_at_one_go.png)

---

### Knowledge base site view

In the Knowledge base site, a deprecated article will display a **Deprecated** tag and a message at the top in a highlighted format with this icon - .

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-KB_Site_view_of_Deprecated_article.png)

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

<a id="updating-article-contributors"></a>

## Update article contributors

**Plans supporting for updating article contributors**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Document360 automatically tracks the project members who have created, updated, or published an article and includes them in the public contributor list.

Readers in knowledge base site can click the avatars within the contributor list to view any other articles that the corresponding project member has contributed.

By default, team members who have taken any action on an article will be added as a contributor. However, project members can be manually added or deleted to the contributor list as well.

---

## Adding or deleting contributors

To update the contributor list:

1. In the desired editor, click the **Article information** () icon next to the article status on the top left to view the contributors list.

> NOTE
>
> If a project member hasn’t uploaded a profile photo, Document360 will display their default avatar.

2. Click **Manage** to open the Manage popup window. You can add and remove contributors from this window.
3. You can delete a contributor by clicking the **Remove contributor** icon provided near the contributor banner.
4. You can add a contributor by searching for a user’s name or email address in the **Add contributors** field from the popup banner.
5. Click the **Add as contributor** () icon to add a project member to the article.

![add contributor](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_GIF-Add_delete_contributors.gif)

By following the above-mentioned steps, you can modify the contributors for an article.

> PRO TIP
>
> * If multiple team members collaborate on an article, manually adding contributors ensures that each person’s contribution is acknowledged.
> * If a contributor is no longer part of your team or organization, they will still appear as a contributor as long as their team account remains in the Document360 project. To completely remove them, you’ll need to delete their team account. For more information, refer to our article on [**Managing team accounts**](/help/docs/managing-team-account).

---

### Why does the ‘**This article has no listed contributor. Please assign one**.’ error occur?

This warning message appears in the article editor when no contributors are assigned to an article. During article creation, the creator is automatically assigned as a contributor. If their account is deleted, the association with the article is removed, resulting in the article appearing without any contributors.

To resolve this issue, follow these steps:

1. Open the desired article in the Knowledge base portal.
2. Click the **Article information** () icon next to the article status badge.
3. In the **Contributors** section, verify if any contributors are listed. If none are listed, this confirms the article lacks a valid contributor.
4. Click **Manage** to open the contributor management interface.
5. Search for and select the appropriate contributors. Click the **Add as contributor** () icon next to their names.

   Save the changes. Confirm the contributor's name now appears in the article's **Contributors** section, and the warning message no longer displays.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-No_contributor_error_resolving.gif)

<a id="schedule-publishing"></a>

## Schedule publishing

**Plans supporting schedule publish**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Document360 offers enhanced content management capabilities, including scheduling your drafted articles for publication at specific dates and times. By scheduling publications, you can plan your content calendar effectively, maintain consistency, and avoid last-minute publishing stress.

---

## Setting up schedule publishing

1. Navigate to the article in the Knowledge base portal.
2. Select the dropdown next to the **Publish** button and click the **Publish later** ().

   The **Publish later** panel will appear.
3. Choose the **Date**, **Time** and **Time zone**.
4. Optionally, add comments in the **Comment field** (up to 160 characters).
5. Click **Schedule**.

> NOTE
>
> The **Schedule publishing** feature is applicable for both articles & page categories.

![1_ScreenGIF-Setting_up_schedule_publishing](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenGIF-Setting_up_schedule_publishing.gif)

---

## Editing a schedule publication

1. Navigate to the desired article in the Knowledge base portal.
2. Click the **Scheduled** dropdown in the top right corner.
3. Click the **Edit** **schedule** () to perform the necessary changes in the publishing schedule.

   The **Edit schedule** panel will appear.
4. Modify the **Date**, **Time** and **Time zone**, and add comments if needed.
5. Click **Schedule** to save the changes.

![2_ScreenGIF-editing_schedule_publishing](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGIF-editing_schedule_publishing.gif)

> NOTE
>
> To immediately publish a scheduled article, click the dropdown next to **Scheduled** and select **Publish now** ().

---

## Cancel schedule publishing

1. Navigate to the article in the Knowledge base portal.
2. Click on the **Scheduled** drop down.
3. Click on **Cancel** () to cancel the schedule publishing.
4. Click **Yes** in the confirmation prompt.

![3_Screenshot-Cancel_schedule_publishing](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Cancel_schedule_publishing.png)

---

## Schedule publishing on multiple article

To schedule multiple articles at once, follow the steps below:

1. Navigate to **Documentation** () > **All articles** in the Knowledge base portal.

   Alternatively, go to any index type category to publish its articles alone.
2. Select the desired articles and click the **Publish later** () or **Publish** () as needed.
3. Choose the **Date**, **Time** and **Time zone** in the **Publish later** panel.
4. Click **Schedule**.

Once scheduled, a **Publish later** () icon will appear next to each article. Hovering over this  icon will display the scheduled publishing date and time.

> NOTE
>
> The publishing process will be initiated at the designated time. However, there might be a delay of a few seconds in publishing the selected articles.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_ScreenGIF-Schedule_publish_on_multiple_articles.gif)

---

### FAQ(s)

**How to instantly publish an article that is already scheduled for publishing?**

Go to the **Scheduled** dropdown in the top right corner of your Knowledge base portal and click **Publish** now.

**Can I edit an article once it is scheduled for publishing?**

No, an article cannot be edited after scheduling. However, you can cancel the scheduled publishing to make edits. This is similar to forking a draft, except the forked draft has not been published yet.

**Can I publish a scheduled article via the customer API?**

No, scheduled articles in the Knowledge base portal cannot be published via the customer API.

**What happens if I move a scheduled article to a different workspace? Will it remain scheduled?**

No, the scheduled publishing time will be cleared once the article is moved to another workspace.

<a id="article-discussion-feed"></a>

## Discussion feed

**Plans supporting the discussion feed**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Every Article and Category page has a Discussion feed, where you can converse, tag(mention), and collaborate with Team accounts regardless of the roles on your project. Peer reviews, approvals, and conversations can be discussed within the portal using the Discussion feed.

---

## Accessing the discussion feed

1. Navigate to the desired article in the Knowledge base portal, and click on **Discussion feed**(  ) at the top right.

> **NOTE**
>
> In Markdown and WYSIWYG editor, this section is termed as **Discussion**, and in Advanced WYSIWYG editor, it is termed as **Comments**.

1. The Discussion blade appears with the history of conversations (if any).
2. You can type your comments/messages in the text box at the bottom right and hit the **Send** icon.
3. It would be posted as a bubble in the feed with a time stamp and profile name.

> **NOTE**
>
> There is no character limit cap for the comments field.

#### Tag/mention team members in the discussion

5. By using @, you can tag any team account from your project.

6. Choose the intended team account by clicking on their profile.

![Discussion feed](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Overview_page_of_discussion_feedback.png)

> **NOTE**
>
> When you tag or mention a team account, an email notification is sent to their address. The email includes:
>
> * The name of the team account
> * The article name and link to the article
> * The language and version
> * The comment or message
> * A login button to your Knowledge base portal

---

## Delete from feed

You can delete the comment/message you've posted previously in the feed.   
Hover your mouse pointer over the message bubble, and a **Delete** () icon appears. Click on it, and the message is removed.

![Discussion feed](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Deleting_the_feedback_in_feedback_discussion.png)

> **NOTE**
>
> * Only you can delete your comment or message.
> * If you accidentally delete or need to restore a removed message, click the **Undo** option in the deleted bubble. The discussion bubble is restored in the feed.
> * Once the article is published, Discussion feed will disabled.

---

## FAQ (s)

**How can I add comments in the discussion feed, and how does it work in the Advanced WYSIWYG editor?**

You can add comments in the discussion feed using Markdown or the WYSIWYG editor. You can add inline comments in the Advanced WYSIWYG editor, which will be displayed here. For more information, read the article on [Reviewing an article using Inline comments](/help/docs/reviewing-an-article-inline-comments).

**Why is the discussion feed/comment section disabled?**

Once the article is published, you can't add comments directly (the **Discussion feed/comment** section will be disabled). However, you can click **Edit** and add comments to the discussion feed.

A written document on a specific topic in your knowledge base, serving as a unit of organized information.

An end-user with login credentials to access the Knowledge Base portal in Document360. Team accounts manage articles, categories, versions, and languages within the portal.

<a id="revision-history"></a>

## Revision history

**Plans supporting for revision history**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

## Article revision

Versioning in a knowledge base ensures accurate, up-to-date content by tracking changes, supporting different product versions, and maintaining a history of edits. It helps teams collaborate, revert to previous versions if needed, and comply with audit requirements. Users can access the right information for their needs while minimizing errors and improving transparency.

In Document360, when a Team account clicks the **Edit** button on a Published article, a new unpublished version of that article is created. The old version is added to the article’s version history but remains available on the Knowledge base site until the new version is published.

![revision history](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734605317771.png)

This article versioning option allows project admins, reviewers, and contributors to compare differences between versions and revert to a previous version at any time.

> **NOTE**
>
> Creating a new article version does not delete existing content. Only a team account can manually delete older article versions.

---

## Creating an article version

There are two ways to create a new version of an article:

#### Method 1: From the Editor

To create a new article revision, follow the steps below:

1. Open a published article in the Knowledge base portal.
2. Click **Edit** on the top right of the editor.

   A new version of the article is created and opened as a draft in the text editor.
3. Update the article content.
4. Click **Publish** and click **Yes** in the confirmation prompt.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenGif-Revision_history.gif)

#### Method 2: Fork an older revision to create a new article version

To **restore** an old version of the article:

1. Navigate to the desired article in the Knowledge base portal.
2. Click the **More** () icon and select the **Revision history** ().
3. Click **Fork** on the desired version listed in the history.
4. Click **Yes** in the pop-up.

   This action will create a new version of the article with the content of the selected article version.
5. To edit the new version, click **Open** on the latest version listed in the history.
6. If required, update the article content.
7. Click **Publish** and click **Yes** in the confirmation prompt.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_ScreenGif-Revision_history.gif)

---

## Article revision actions

The below options are available in **Article revision**:

1. **Fork**: To create a new article version from an existing article version. Here, the article is opened in the Editor mode, where you can make changes to the article content.
2. **Delete****:** To delete the article version. This action cannot be reversed.

> NOTE
>
> You cannot delete a published article version. Only unpublished versions can be deleted.

3. **Open****:** To open the article version in the Editor. This helps you restore any of the previous versions to their published state.
4. **Workflow history****:** View the article version's workflow history. This includes all the Workflow stages, Workflow assignees, comments, and dates.
5. To make any previous version of an article public by opening that version in the editor and clicking **Publish**.

You can also see detailed information about each version, including the version number, contributor, created date, and version visibility.

![revision history](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Workflow_history.png)

---

## Comparing article versions

You can open two versions of an article at any point in **Article revision** and compare them.

To compare two versions of an article:

1. Go to the desired article in the Documentation editor.
2. Click the **More** () icon and select the **Revision history** ().
3. Select the checkbox for the desired versions you want to compare.
4. Click the **Compare** button.

![revision history](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Article_Version_comparision.png)

### Content highlighting criteria:

The compared view of the two versions shows the below details:

**Added content:**

* New content in the compared versions is highlighted in green for easy identification.
* For images, videos, code blocks, PDFs,  and self-closing tags (<br>, <hr>), added content is highlighted with a green badge labeled 'Added.'
* For changes made to tables, the content is highlighted in green.
* Highlights remain visible while scrolling, ensuring added content is easy to spot throughout the article.

**Removed content:**

* Deleted content is highlighted in red with a strikethrough.
* For images, videos, code blocks, PDFs, and self-closing tags (<br>, <hr>), removed content is highlighted with a red badge labeled 'Removed.'
* For changes made to tables, the removed content is highlighted in red.
* Removed content remains visible in the comparison view for clarity and to ensure removed content is easy to spot across the entire article.

**Formatting changes:**

* Changes in formatting (e.g., bold, italic, underline, font size, lists) are highlighted in blue.
* Non-text formatting changes, like table styles or image resizing, are also highlighted in blue with a blue badge labeled ‘Modified.’

> NOTE
>
> Content block movements and multiple formatting changes will not be highlighted when comparing article versions. Multi-formatting changes refer to applying italic, bold, and underline formatting to the same content block.

**Swap versions:**

* The **Swap** button is placed near the version dropdowns at the top for easy access.
* This allows you to reverse the comparison order of two versions, instantly switching the comparisons of the old and new versions.
* This helps you understand changes from both perspectives, such as seeing what was previously added and removed or vice versa.
* The comparison view updates in real time without requiring a page reload, ensuring a seamless experience.
* All existing highlights, filters, and settings are preserved when switching.
* After swapping, the version labels will update to reflect the new order, ensuring clarity on which version is being compared as the new and old.

> NOTE
>
> All highlights for added, removed, and formatting changes will be maintained after the swap. The system will update the highlights to reflect the new comparison.
>
> For example, content previously marked as "added" will appear as "removed" after swap.

**Exit version compare:**

* The **Exit compare** button is located at the top right which you can use to exit from the comparison window.
* Clicking the button will take you back to the main document view without reloading the page.
* You will return to the exact location of the article you were viewing before comparison mode to ensure workflow continuity.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_ScreenGif-Revision_history.gif)

---

### FAQs

#### **Why are the updated timeframes of the forked article not in order?**

If the older versions are opened and updated, the recently modified version will be shown with the updated timeframe accordingly.

#### **Can I restore a previous revision of the article?**

If you need to revert an article to a previous state before your recent edits, follow these steps:

* **For published articles:** Delete the forked version that contains your recent edits. This restores the last published version of the article.
* **For draft or new articles:** Create a new version by forking an earlier revision or delete the forked version that includes recent edits.

Forking before making changes preserves the original version, so you can restore it anytime.

#### **How do I discard the current changes and revert to the previous version of the article?**

**Method 1:**

* If the changes have not been published, follow these steps to revert to the previous version:

  + Click on the **Revision history** of the article.
  + **Open** the previous version to view and restore the old content.

**Note:** This option works if the article has been published at least once.

**Method 2:**

* If the article was never published, try the Backup & Restore option in the **Settings** page. This allows you to restore the content of a specific article.

#### Can I change or modify the article's published or last updated date to a past date?

No, the article's published date or last updated date cannot be changed. The last updated date will always reflect the most recent modification date, even if the article version is old.

An end-user with login credentials to access the Knowledge Base portal in Document360. Team accounts manage articles, categories, versions, and languages within the portal.

The public-facing website where end-users can access articles and find answers to their questions.

<a id="article-analytics"></a>

## Article analytics

**Plans supporting article analytics**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Article Analytics in Document360 provides detailed, article-specific insights, unlike standard Analytics that offer a broader overview of your entire knowledge base. With Article Analytics, you can assess individual article performance across metrics like reads, views, likes, dislikes, and link status. Use these insights to optimize your content strategy and enhance user experience.

---

## Accessing article analytics

1. In the editor, navigate to the top-right and click the **More (•••)** icon.
2. Select **Analytics** from the dropdown menu.

   Here, you’ll find detailed metrics on the article's **Reads**, **Views**, **Likes**, **Dislikes**, and **Link Status**.

---

### Understanding article analytics metrics

Each metric gives you actionable insights into article engagement:

* **Reads**: Measures reader engagement based on scrolling, clicking, and time spent on the article. The read count updates daily and is counted once per day per user.

> NOTE
>
> Time spent varies based on user activity. Multiple clicks on the same article are counted as a single read, while time spent can differ for each session.

* **Views**: Represents the number of unique clicks per browser, counted once per browser per user.
* **Likes**: Shows the total number of likes received by the article, providing feedback on content relevance.
* **Dislikes**: Tracks the number of dislikes to help identify areas for improvement.

> NOTE
>
> All metrics start tracking from the time the article is created.

---

### Navigating to project-wide analytics

Click **Go to Analytics** to access the broader project-level analytics for deeper insights into the entire knowledge base’s performance.

![Update-Screenshot-Article_Analytics](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Update-Screenshot-Article_Analytics.png)

---

### Validating links in article analytics

The **Link status** displays the **Total** links within an article, including a breakdown of links that are:

* **Working**: Active and accessible
* **Broken**: Unreachable or incorrect URLs
* **Unknown**: Status could not be determined
* **Ignored**: Links intentionally excluded from validation

The link validation tool helps you maintain active, reliable links within each article. Here’s how to use it:

1. From the Article Analytics page, locate the **Link Status** metric.
2. Click **Validate Now** to automatically check the link status.
3. If any links are broken, identify and copy the link URL.
4. Update the link or set a redirection rule to guide users to the correct destination.

**Example**: If an article link to external documentation is broken, copy the URL, navigate to **Settings > Knowledge base site > Article redirect rules**, and add a new rule.

---

### FAQs

#### How often is the analytics data updated?

Data refreshes in real-time, with reads updating daily based on unique user sessions.

#### Why might my read count differ from views?

Reads factor in user engagement activities like scrolling and clicking, while views simply count unique browser clicks.

#### Can I use article analytics to improve content engagement?

Yes, metrics like Reads, Likes, and Dislikes help you gauge engagement, showing which articles resonate most with your audience.

<a id="article-access-control-knowledge-base-site"></a>

## Security - Article access control

**Plans supporting access to security settings in the knowledge base site**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Add or deny access to the article content for team accounts, team account groups, reader accounts, and reader groups on the Knowledge base portal or Knowledge base site.

---

## Accessing the Article access control

1. Navigate to the desired article in the documentation editor.
2. Click on the **More** () options on the top right of the editor, and select **Security**.
3. There are two options to choose from

   * [Knowledge base portal](/help/docs/article-access-control-knowledge-base-site#knowledge-base-portal)
   * [Knowledge base site](/help/docs/article-access-control-knowledge-base-site#knowledge-base-site)

   An **Assign content access** blade will appear.
4. You can manage access to the article for Team accounts or readers.

![1_Screenshot-Accessing_the_Article_access_control](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Accessing_the_Article_access_control.png)

### Knowledge base portal

To change the article access on the portal, select the **Knowledge base portal access control**.

> **For team accounts & team account groups**   
> Portal access refers to the access through which the article content and article settings are updated or deleted.

The **Assign content access: Knowledge base portal** panel appears with the list of existing team accounts.

1. If no accounts are listed, click **Assign article access** to assign team members.
2. Select the desired team account and click **Apply**.
3. In the **Team account** section, you can perform operations such as **Edit**, **Deny**, and **Remove**.
4. Once done, click **Site access**.

![2_Screenshot-Knowledge_base_portal_access_control](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Knowledge_base_portal_access_control.png)

### Knowledge base site

To change the article access on the site, select the **Knowledge base site access control.**

> **For readers & reader groups**  
> Site access refers to the view access of the published article on the private or mixed knowledge base site.

> **Why is this option Inactive?**  
> This option would be inactive (grayed out) if the knowledge base site access is set as **Public**.

The **Assign content access: Knowledge base site** panel appears with the list of existing readers.

1. If no readers are listed, click **Assign article access** to assign reader accounts.
2. Select the desired reader account and click **Apply**.
3. In the **Readers** section, you can perform operations such as Deny and Remove.
4. Once done, click **Site access**.

![3_Screenshot-Knowledge_base_site_access_control](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Knowledge_base_site_access_control.png)

---

### FAQs

#### **Once Knowledge base portal access is denied for a Team account or group, how can it be restored?**

If access is denied for a team account, the team account will not be listed. To restore access, click **Assign article access** and add the same team account again.

#### **Once Knowledge base site access is denied for a reader or group, how can it be restored?**

If access is denied for a reader account, the read account will not be listed. To restore access, click **Assign article access** and add the same reader account again.

#### **Can I give access to an entire category to a team account and still restrict access to specific articles within that category?**

Yes, in Document360, you can grant access to an entire category to a team account and still restrict access to specific articles within that category.

#### **How do I deny access to a specific article for a team account?**

To deny access to a specific article for a team account, follow these steps:

1. Go to the specific article and click on the **More**() icon in the Knowledge base portal.
2. Navigate to **Security** > **Knowledge base portal**.

   The Team accounts list will appear.
3. Hover over the desired Team account and click the **Deny** () icon.

#### **How do I grant access to a category for a team account?**

To grant access to a category for a team account,

1. Navigate to the category you want to give access to in the Knowledge base portal.
2. Click **More** () icon > **Security** > **Knowledge base portal** > **Assign category access**.
3. Select the desired Team account and click **Apply**.

#### **Can I manage article-level access independently within a category?**

Yes, Document360 allows you to manage article-level access independently within a category. You can grant or deny access to specific articles even if the user has access to the entire category.

#### **What happens if I deny access to an article that is part of a category the user has access to?**

If you deny access to a specific article, the user will not be able to view or interact with that article, even if they have access to the rest of the category. The restrictions applied at the article level will override the category-level permissions for that specific article.

#### **Why can't I see the category and article structure on the Knowledge base site as it appears in the portal?**

If you are unable to see the category and article structure on the knowledge base site, it may be due to JWT access settings. If the reader group doesn’t have access to specific categories, those categories won't be visible to them.

To resolve this, ensure the correct content access is granted to the reader group. If the issue persists, please contact our support team for assistance.

#### How can I configure one article public while keeping all others private in the Knowledge base site?

You can configure a single article as public while keeping all other articles private in a **Mixed project** by following these steps:

**Set the workspace site access to public:**

1. Navigate to **Settings** () > **Users & security** > Site access in the Knowledge base portal.
2. Locate the workspace where the desired article is created.
3. Set the Site access for that workspace to **Public**.

**Configure all other articles as private:**

4. Go to the **Documentation** () section.
5. For each article or category you want to keep private.
6. Hover over the article or category, and click the **More** () icon.
7. Select **Security** > **Knowledge base site**.
8. In the **Assign content access** panel, choose **Private** and click **Close**.

   Ensure that the article you want to make public remains in **Public** access mode.

By doing this, only the specified article will be publicly accessible, while all others remain private.![Configuring one article as public while keeping all others private in the Knowledge base site.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Screenshot-FAQ_Configuring_one_article_public_other_Articles_As_private.gif)

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

The public-facing website where end-users can access articles and find answers to their questions.

<a id="health-check-metrics"></a>

## Health check metrics

**Plans supporting health check metrics**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

**Health check metrics** help you optimize your article's content and readability. These metrics provide valuable insights into current problems, suggestions for improvement, and aspects where the content is performing well. This feature is only available for articles and category pages in English.

For example, if an article has long sentences or lacks internal links, the tool will flag these issues, allowing you to make improvements and enhance readability and SEO performance.

---

## Accessing health check metrics

To access the Health Check Metrics for an article:

1. Navigate to the desired article in the Knowledge base portal.
2. Click **More** (•••) and select **Health check metrics**.

   The **Health check metrics** panel will appear with two major sections:

   * [SEO metrics](/help/docs/health-check-metrics#seo-metrics)
   * [Readability metrics](/help/docs/health-check-metrics#readability-metrics)

> NOTE
>
> If you update any parameter while the **Health check metrics** panel is open, click **Check now** to view insights on the latest changes.

### Metrics classification

The metrics are classified into three sections,

* **Problems:** Parameters that need immediate action.
* **Suggestions:** Parameters that require improvement.
* **Good Work:** Parameters that are currently optimal.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenGIF-Health_check_metrics_in_the_Knowledge_base_portal.gif)

---

## SEO metrics

This section displays the SEO metrics for your article, covering the following parameters:

### 1. SEO title length

**SEO title** is the article title text appearing in the search engine results and the browser tabs. This parameter indicates the length of your article's SEO title. If adjustments are needed, the recommended length and an option to update it appear. The ideal SEO title length is between 50-70 characters (including spaces).

* If the SEO title's character length (including spaces) is less than 30 or more than 90, it will appear under **Problems** with a link to update it. Click **Update now** to navigate to the respective section.
* If the length is between 30-49 or 71-90, it will appear under **Suggestions** with a link to update it. Click **Update now** to navigate to the respective section.
* If the length is between 50-70, it will appear under **Good Work**.

### 2. SEO description length

**SEO description** is the summary of an article. It appears in the search engine results as a short article description. This parameter shows the length of your article's SEO description. If adjustments are needed, the recommended length and an option to update it appear. The ideal SEO description length is between 120-160 characters (including spaces).

* If the description length is less than 80 or more than 160 characters, it appears under **Problems**, with a link to update it.
* If the description length is between 80-119 characters, it will appear under **Suggestions**, with a link to update it.
* If the description length is between 120-160 characters, it appears under **Good Work**.

### 3. External links

**External links** are the links used that point to a web location outside your Document360 project. This parameter shows the presence of external links in your article.

* Articles with no external links or more than three will appear under **Suggestions**.
* Articles with one to three external links will appear under **Good Work**.

### 4. Internal links

**Internal links** include article links, category page links, and other relevant links within your Document360 project. Media file links are not considered internal links. This parameter shows the presence of internal links in your article.

* If there are no internal links or more than three, it appears under **Suggestions**.
* If there are one to three internal links, it appears under **Good Work**.

### 5. Featured image

**Featured image** will appear alongside the SEO title and description when the article is shared on social media or other websites. This parameter shows the availability of the featured image in the article.

* If there is no featured image, it appears under **Suggestions**.
* If a featured image is added, it appears under **Good Work**.

---

## Readability metrics

This section displays readability metrics for your article, providing insights into the following parameters:

### 1. Readability score

The readability score indicates how easy your article is to read, on a scale from 0 to 100. A higher score means the content is more readable.

* If the score is below 30, it appears under **Problems**.
* If the score is between 30-59, it appears under **Suggestions**.
* If the score is above 59, it appears under **Good Work**.

> NOTE
>
> For more information, visit the [Readability score](/docs/readability-score) article.

---

### 2. Paragraph length

This parameter shows the length of paragraphs in your article. Long paragraphs can make content harder to follow, so shorter paragraphs are recommended. The optimal length is 150 words or less per paragraph.

* If any paragraph exceeds 150 words, it appears under **Suggestions**.
* If all paragraphs are 150 words or less, it appears under **Good Work**.

> NOTE
>
> Two or more sentences without a break are considered as a paragraph.

---

### 3. Sentence length

This parameter shows the length of sentences in your article. Shorter sentences are easier to read. The recommended sentence length is 20 words or less.

* If any sentence exceeds 20 words, it appears under **Suggestions**.
* If all sentences are 20 words or less, it appears under **Good Work**.

> NOTE
>
> **What is considered a sentence?**
>
> * A sentence is defined as a group of words ending with a period (.).
> * If the ordered and unordered list contains no full stop at the end, it will be considered as a single sentence.

---

### 4. Sub-heading distribution

This parameter shows the use of sub-headings in your article. Sub-headings improve readability and help readers identify different sections.

* If no sub-heading is present, it appears under **Suggestions**.
* If sub-headings are used, it appears under **Good Work**.

In Document360, use Heading tags (H2, H3, H4) to add sub-headings. These are available in the toolbar. If the table of contents is enabled, sub-headings will appear there as well.

> NOTE
>
> Readability metrics do not account for LaTeX expressions or code blocks.

<a id="readability-score"></a>

## Readability score

**Plans supporting Readability score**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The Readability score, found in the Readability metrics section of the [**Health Check Metrics**](/help/docs/health-check-metrics), measures how easy it is to read and understand an article. It is presented as a score out of 100, where a higher score indicates greater readability.

For example, a score between 80 and 100 indicates that the article is very easy to read. If the score is between 60-80, the article is relatively easy to understand. If the score is below 60, the article is more complex, and readers may find it difficult to comprehend.

This score helps you quickly assess an article's readability. It helps you identify areas where readers might struggle without requiring feedback from them.

---

## Checking the readability score

1. Open the desired article in the Knowledge base portal.
2. Click the **More** (•••) icon and select **Health check metrics**.
3. The **Health check metrics** panel will appear with two major sections:

   * SEO metrics
   * Readability metrics
4. Expand **Readability metrics** and find the **Readability score.**

   * If the score is below 30, it appears under **Problems**.
   * If the score is between 30-59, it appears under **Suggestions**.
   * If the score is above 59, it appears under **Good Work**.

> NOTE
>
> If you update any parameter while the **Health check metrics** panel is open, click **Check now** to view insights on the latest changes.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-readability_metrics_in_the_Health_check_metrics.png)

---

### Score classification

The table below outlines the readability score ranges and their corresponding messages. These messages appear next to the score.

| Readability score | Message |
| --- | --- |
| 90-100 | Very easy to read |
| 80-89 | Easy to read |
| 70-79 | Fairly easy to read |
| 60-69 | Easily understood |
| 30-59 | Fairly difficult to read |
| 0-29 | Hard |

For example:

* If the readability score is 84, the message **Easy to read** will appear.
* If the readability score is 35, the message **Fairly difficult to read** will appear.

<a id="sitemap-generator"></a>

## Sitemap

**Plans supporting for sitemap generation**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

A Sitemap is a file that shares detailed information about a website, primarily containing page URLs. Search engines like Google, Bing, and Yahoo use this file to crawl your site more effectively. It communicates the most important pages and files to search engine crawlers. Document360 uses an XML-type sitemap generator.

> NOTE
>
> Sitemap URLs are available only for public projects.

---

## Accessing the Sitemap in Document360

1. Navigate to **Settings** () >**Knowledge base site** > **A****rticle settings & SEO**> **SEO** tab in the Knowledge base portal.
2. Locate the **Sitemap URL**.
3. In the **Select change frequency** field, choose how often your sitemaps should be generated.

> NOTE
>
> Sitemaps are not updated instantly when you add a new article or change an article slug. They are generated based on the selected frequency. It's recommended to choose a frequency that aligns with your article publishing rate. For example, if you publish one or more new articles daily, set the frequency to **Daily**.

4. Click the sitemap URL to view your sitemap.

![Settings page showing SEO options for article management and sitemap configuration.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Screenshot-New-Accessing_sitemap_in_Document360.png)

---

### FAQs

#### Do I need a sitemap?

A sitemap.xml file is an essential for communicating with search engines. It’s also useful for verifying your website structure for other internal audits.

#### What should I do with the sitemap?

You should submit your sitemap to Google Search Console once it's generated from the Document360 sitemap generator. [Click here](https://developers.google.com/search/docs/advanced/sitemaps/build-sitemap) to learn more about submitting your sitemap to Google Search Console.

#### How does a sitemap look?

```
<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
  <url>
    <loc>http://www.example.com/foo.html</loc>
    <lastmod>2018-06-04</lastmod>
  </url>
</urlset>

```

Plain text

Copy

> Above is a basic sitemap example that includes one URL. It is a misconception that sitemaps have only URLs in them. It can also have metadata added to them.

#### What are the types of sitemaps?

There are three main types of sitemaps

1. **Visual sitemaps**- Used by web project developers.
2. **HTML sitemaps**- Used for sites with large content, with lower impacts on SEO.
3. **XML sitemaps**- Most used commonly used type, performing well in SEO as they are crawler friendly.

<a id="public-comments"></a>

## Public article comments

**Plans supporting discussion/inline comments**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Document360 uses [Disqus](https://disqus.com/), a commenting plug-in, to allow end-users to comment on articles on the Knowledge base site. To enable Disqus, you must first set up and configure the Disqus integration. After configuration, commenting will be automatically enabled on all articles.

> NOTE
>
> For more information, read the article on [Disqus integration in Document360](/help/docs/disqus).

---

## Enabling comments on a public article

> NOTE
>
> If you don’t have the Disqus integration enabled, end-users can’t comment on a public article.

1. Navigate to the desired article in the Knowledge base portal.
2. Click on the **More** (**•••**) icon at the top right and select **More article options**.
3. Go to the **Preferences** tab in the **Article settings** panel.
4. Select the **Enable feedback** checkbox.
5. To disable comments on a public article, deselect the **Enable feedback** checkbox.
6. Click **Save**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Enable_feedback_in_public_articles.png)

> NOTE
>
> Removing the Disqus integration will disable commenting entirely. If you decide to re-enable Disqus later, you'll need to reconfigure the integration by following the steps in the [Disqus](/help/docs/disqus) topic.

### Knowledge base site view

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Enabling_Feedback_Knowledge_base_site_view.png)

---

### FAQ(s)

#### How do I enable comments on a public article?

To enable comments, navigate to the desired article, click on the **More (•••)** icon, go to the **Preferences** tab in the **Article settings** panel, select the **Enable feedback** checkbox, and click **Save**.

#### Can I disable comments on a public article?

Yes, you can disable comments by deselecting the **Enable feedback** checkbox in the **Article settings** panel.

#### Will deleting the Disqus integration disable public comments?

Yes, removing the Disqus integration will disable public comments on all articles.

#### What steps do I need to take to delete the Disqus integration?

To delete the Disqus integration, navigate to Settings () > **Knowledge base site** > **Integrations**, and click **Delete** on the Disqus list item.

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

<a id="robotstxt"></a>

## Robots.txt

**Plans supporting for Robot.txt**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

## What is a Robots.txt file?

A Robots.txt file is a text file used to communicate with web crawlers and other automated agents about which pages of your knowledge base should not be indexed. It contains rules specifying which pages may be accessed by which crawlers.

> For more information, read this [help article](https://developers.google.com/search/docs/crawling-indexing/robots/robots_txt) from Google.

---

## Accessing Robots.txt in Document360

1. Navigate to **Settings** () > **Knowledge base site** > **Article settings & SEO** > **SEO** tab in the Knowledge base portal.
2. Locate **Robots.txt** and click **Edit**.

   The **Robots.txt settings** panel will appear.
3. Type in your desired rules.
4. Click **Update**.

![Screenshot of robot txt page](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot_robot_txt_page.png)

---

### Use cases of Robots.txt

A Robots.txt file can block a folder, file (such as a PDF), or specific file extensions from being crawled.

You can also delay the crawl speed of bots by adding crawl-delay in your Robots.txt file. This is useful when your site is experiencing high traffic.

```
User-agent: *
Crawl-delay: 10
```

Plain text

Copy

---

### Restricting the crawler through admin data

```
User-agent: *
Disallow: /admin/
Sitemap: https://example.com/sitemap.xml

```

Plain text

Copy

`User-agent: *` - Specifies that any bot can crawl through the site.  
`Disallow: /admin/:` - Restricts the crawler from accessing admin data.  
`Sitemap: https://example.com/sitemap.xml` - Provides access to bots to crawl the sitemap. This makes the crawl easier as the sitemap contains all the URLs of the site.

---

### Restricting a specific search engine from crawling

```
User-agent: Bingbot 
Disallow: /

```

Plain text

Copy

> The above Robots.txt file is defined to disallow the Bingbot.

`User-agent: Bingbot` - Specifies the crawler from the Bing search engine.  
`Disallow: /` - Restricts Bingbot from crawling the site.

---

#### Best Practices

* **Include links** to the most important pages.
* **Block links** to pages that do not provide any value.
* Add the sitemap location in the **Robots.txt** file.
* A Robots.txt file cannot be added twice. Please check the basic guidelines from [Google Search Central](https://developers.google.com/search/docs/advanced/robots/create-robots-txt#format_location) documentation for more information.

> NOTE
>
> A web crawler, also known as a Spider or Spiderbot, is a program or script that automatically navigates the web and collects information about various websites. Search engines like Google, Bing, and Yandex use crawlers to replicate a site's information on their servers.
>
> Crawlers open new tabs and scroll through website content, just like a user viewing a webpage. Additionally, crawlers collect data or metadata from the website and other entities (such as links on a page, broken links, sitemaps, and HTML code) and send it to the servers of their respective search engine. Search engines use this recorded information to index search results effectively.

---

### FAQs

**How do I remove my Document360 project from the Google search index?**

To exclude the entire project from the Google search index:

1. Navigate to **Settings** ()> **Knowledge base site** > **Article settings & SEO** in the Knowledge base portal.
2. Go to the **SEO** tab and click **Edit** in the `Robots.txt`.
3. Paste the following code:

```
User-Agent: Googlebot 
Disallow: 
```

Plain text

Copy

4. Click **Update.**

**How do I prevent tag pages from being indexed by search engines?**

To exclude the tag pages from the search engines:

1. Navigate to **Settings** ()> **Knowledge base site** > **Article settings & SEO** in the Knowledge base portal.
2. Go to the **SEO** tab and click **Edit** in the `Robots.txt`.
3. Paste the following code:

```
User-agent: *
Disallow: /docs/en/tags/
```

Plain text

Copy

4. Click **Update**.

<a id="read-receipt"></a>

## Read receipt

**Plans supporting read receipt**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The **Read receipt** feature helps you see who has read and acknowledged an article. This helps ensure important updates are noticed. For example, if your company updates its security policy, employees can be required to acknowledge the article, confirming they have read it. This keeps communication clear and trackable.

> For your information (FYI)
>
> * The Read receipt feature is available exclusively for private and mixed projects in **KB site 2.0**.
> * The Read receipt feature is not available for JWT configured projects.

---

## Managing Read receipts in the Knowledge base portal

You can manage the read receipt feature for articles and category pages in three ways:

Method 1: Bulk management in All articles

Method 2: Individual article settings

Method 3: Accessing read receipt in the Settings

Method 1

Method 2

Method 3

You can enable or disable read receipts for multiple articles at once through the **All articles** () section.

1. Navigate to **Documentation** () > **All articles** () in the Knowledge base portal.

   The **All articles** page will appear with all articles within your workspace.
2. Select the intended articles.
3. To enable the read receipt, click **Enable read receipt**.
4. To disable the read receipt, click **Disable read receipt**.
5. Hover over the **Read receipt** () icon to see the number of readers who have acknowledged the articles.

> NOTE
>
> If the read receipt is configured in the **Settings**, it cannot be changed in the **All Articles** section.

![Enabling the read receipt for selected articles in the All articles section in the Knowledge base portal.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-New_Enabling_read_receipt_from_All_articles.png)

To enable read receipts for a specific article:

1. Navigate to the desired article in the Knowledge base portal.
2. Click the **More**() icon and select **More article options**.
3. In the **Article settings** panel, go to the **Read receipt** tab.
4. Turn on the **Enable read receipt for this article** toggle and click **Save**.

![Enabling the read receipt for selected articles in the Articles section in the Knowledge base portal.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-New_Enabling_read_receipt_from_Article_settings.png)

You can apply read receipt rules to entire knowledge base categories:

1. Navigate to the **Settings**() > **Knowledge base settings** > **Read receipt** in the Knowledge base portal.

   The **Read receipt** page will display any previously created rules.
2. Click **Create rule**.
3. In the **Create read receipt rule** panel, enter the rule name (up to 50 characters).
4. Choose the visibility option: **Show** or **Hide**.

> NOTE
>
> When creating rules, the order in which they appear determines which rule takes effect. You can create up to 20 rules per project and rearrange them as needed.
>
> For example, if you have two rules for the same category:
>
> * **Rule 1**: Enable the reader acknowledgment feature in Category A.
> * **Rule 2**: Disable the reader acknowledgment feature in Category A.
>
> If Rule 1 is in the second position and Rule 2 is in the third, Rule 1 will take effect first, provided both rules are set to "Show." However, if Rule 1 is set to "Hide," then Rule 2 will take effect, even though Rule 1 has a higher priority.

5. Select the desired categories to apply the read receipt.
6. If needed, assign the rule to specific reader groups.
7. Once done, click **Create**.

![Enabling All articles in the Project settings in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_ScreenGIF-New_Enabling_Read_receipt_in_the_Settings_page.gif)

> NOTE
>
> * If you have configured in Settings, read receipts cannot be altered at the **Article-level settings**.
> * Read receipts can be added to both draft and published articles.
> * When forking and republishing an article with acknowledgment enabled, readers will need to acknowledge the republished article again.
>
> ![2_Screenshot-publish_confirmation_prompt](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-publish_confirmation_prompt.png)

For articles with reader acknowledgment enabled, the acknowledgment information will be displayed at the top. ![3_Screenshot-acknowledgement_information_at_the_top](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-acknowledgement_information_at_the_top.png)

---

## **Read receipt page**

![Interface showing rules for read receipt settings with highlighted elements for visibility and rules.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-New_Overview_page_of_Read_receipt_in-Settings.png)

The **Read receipt** page provides a detailed view of your configured rules:

1. **Create Rule:** Click to create a new read receipt rule for Knowledge base categories.
2. **Rearrange Rules:** You can rearrange the order of created rules. Rules are prioritized based on their sequence, with the first rule taking precedence.
3. **Name:** Displays the name of each read receipt rule.
4. **Visibility:** Indicates whether the rule is set to Show or Hide.
5. **Rules:** Displays the categories to which the rules are applied.
6. **Dependency viewer:** View and edit the categories where the rule is applied.
7. **Edit:** Hover over the desired rule to edit it.
8. **Delete:** To delete a rule, hover over it, click **Delete**, and confirm the action.

---

## Reader acknowledgement in the Knowledge base site

1. Once the Read receipt configured, navigate to the desired article in the Knowledge base site.

   A small banner will appear at the top, stating **"Your acknowledgement is required upon reading.”**
2. Scroll down to the end of the article, select the checkbox to acknowledge, and then click **Submit**.

   Upon successful acknowledgement, a confirmation message will appear at the top of the article.

![4_ScreenGIF-Reader_acknowledgement_in the KB_site](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_ScreenGIF-Reader_acknowledgement_in%20the%20KB_site.gif)

---

## Acknowledgement required in the Knowledge base site

![Acknowledgement required in the Knowledge base site](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_Screenshot-Acknowledgement_required_in_the_Knowledge_base_site.png)

On the top-right side of the home page, you'll see an Announcement () icon indicating the number of acknowledgements that need to be addressed. Click this to access the **Acknowledgement required** page.

On the left side of the **Acknowledgement required** page, you'll find filter options for workspace and acknowledgement status:

**Workspace**:

* Current Workspace: Filters articles only within the current workspace.
* All Workspace: Filters articles across all workspaces.
* Specific: Allows selection of specific workspaces for filtering.

**Acknowledgement status**:

* Required: Displays a list of articles that have not been acknowledged.
* Acknowledged: Displays a list of articles that have been acknowledged.

---

## Monitoring Read receipt in Analytics

In the **Analytics** () section, you can monitor the read receipt analytics:

1. Navigate to **Analytics** () > **Articles** in the Knowledge base portal.
2. In the **Top articles** section, click **View all**.

The **All Articles** page will appear, showing a field named **Read Receipt**, where you can see the acknowledgment details for each article.

![6_ScreenGIF-Analytics_section_Reader_Acknowledgement](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/6_ScreenGIF-Analytics_section_Reader_Acknowledgement.gif)

NOTE

Any changes made to the respective articles will reflect in the analytics within 15 minutes.

---

### FAQs

#### What is the maximum number of read receipt rules I can create?

You can create up to 20 read receipt rules.

#### What happens to reader acknowledgment rules when cloning articles or categories across workspaces?

When you clone articles or categories within or across workspaces, reader acknowledgment rules will not be carried over to the new workspace. The rules must be configured separately for the new workspace.

#### Do readers need to acknowledge every time an article is updated?

When forking and republishing an article with acknowledgment enabled, readers will need to acknowledge the republished article again.

<a id="share-articles-via-private-link"></a>

## Share articles via private link

**Plans supporting the sharing of private link**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Share articles with external readers using a private link even before publishing the content. This feature allows you to generate a unique link for any article. With this link, you can grant access to the content to users who do not have access to your knowledge base portal or site. You can share these private links with external users outside your Document360 project (team accounts or reader groups) and disable or regenerate the links at any time to manage access as per your preferences.

> For your information (FYI)
>
> This feature is available exclusively in **KB Site 2.0**, which is accessible for projects created after June 10th.

---

### Creating a private link

1. Navigate to the desired article in the Knowledge base portal.
2. Click on more options (•••) in the category tree next to the article.

   Alternatively, select more options (•••) near the Publish button.
3. Click the **Share link** (  ) icon.
4. In the **Share link** pop-up window,

   a. Click on **Get sharable link (  )** once you have deleted the pre-existing link to generate a new link.

   b. Click on **Copy** (  ) to copy the link to share.

   c. You can choose to click **Delete link** (  ) to delete the existing link.

> NOTE
>
> * When the user has deleted the article, the link will not display the information of the article in the KB site.
> * But once it’s recovered from the recycle bin (or) back up and restored, the same link should allow the user to view the content.

![1_ScreenGIF-Creating_deleting_the_private_link](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenGIF-Creating_deleting_the_private_link.gif)

---

### FAQs

**What happens if the user deletes the generated link?**

The shared private link will be invalid if the user deletes the generated link in the KB portal.

**How do I regenerate my shareable link?**

After deleting the existing link, navigate to the **More** (•••) option > **Share (  )** icon > click **Get sharable link** to regenerate it.

**How do I share an unpublished article with someone who is not part of the team account?**

In Document360, you can use the Get shareable link feature to share an unpublished article with individuals who are not part of your project’s team account.

<a id="ai-customization"></a>

## Eddy AI customization

**Plans supporting the Eddy AI customization**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

> NOTE
>
> **Current Plan:**
>
> * **Business Plan:** You can customize the response tone and length for AI assistive search.
> * **Enterprise Plan:** In addition to customizing the response tone and length for AI assistive search, you can also customize the AI assistant's name.
>
> **Legacy Plan:**
>
> * If you have purchased AI assistive search, you can customize the response tone and length.
> * **Enterprise Plan:** In addition to customizing the response tone and length, you can also customize the AI assistant's name.

As a Document360 user, you have the flexibility to rename Eddy to fit seamlessly with your company’s identity. Whether your organization has its own advanced AI capabilities or simply wants Eddy to reflect its unique culture and values, customization options are available. This depicts that Eddy not only supports your content needs but also represents your brand in the best possible way.

> NOTE
>
> The users with the access to **View access permissions** > **Portal role** > **Project settings** > **Update (enabled),** can customize the Eddy AI term.

---

## Customizing the Eddy AI

To personalize your Eddy AI,

1. Navigate to Settings ()> **AI features** > **Customization** in the Knowledge base portal.

   The **Customize Eddy AI** page will appear.
2. In the **AI assistant name** text box, enter your desired name for the AI assistant.

   By default, **Eddy AI** will be assigned as the AI assistant name.
3. You can customize the AI Assistive response tone to fit various contexts and situations:

* Default (Select this option for search responses that match the tone of your question or context, offering adaptability for different situations.)
* Professional
* Friendly
* Casual
* Straightforward
* Confident

4. You can customize the response length of AI Assistive search based on how detailed you want the responses to be:

* Default (Select this option for search responses that adjust to your question and the context, varying in length as required)
* Long and detailed
* Short and concise

5. Once done, click **Save.**

> NOTE
>
> **Moderation APIs** verify and filter out inappropriate words in the **AI assistant name** field. If the name doesn’t meet our community standards while saving, a prompt will be displayed. Click **Yes** to proceed, and the moderation API will be overridden.

![Customizing the Eddy AI](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Customizing_the_Eddy_AI.png)

---

### FAQ

#### Is there a character limit for the AI assistant name?

Yes, the AI assistant name should not exceed 15 characters.

<a id="ai-machine-translation"></a>

## AI machine translation

**Plans supporting access to machine translation settings in knowledge base portal**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Document360’s AI machine translation feature enables seamless translation of text within your article. This capability ensures that all aspects of your content can be localized to the languages added to your project, allowing you to easily maintain a multilingual knowledge base.

Key benefits:

* Time-efficient: Easily translates article text, saving you time on manual translations.
* Consistency: Keeps terminology and phrasing uniform across languages, ensuring a cohesive user experience.
* Scalability: Easily handle translations across numerous articles and languages as your knowledge base grows.

> **NOTE**
>
> * When you perform machine translation for a Markdown article, it will be automatically converted to the WYSIWYG editor.
> * If an article is deleted in the main language, it will also be deleted in all other languages. However, if an article is hidden in the main language, it will still be visible on the Knowledge base site in other languages.

## Prerequisites for using machine translation

To perform AI machine translation,

* Ensure you have sufficient machine translation character credits. You can check your available character credits from **Settings**() > **Knowledge base portal** > **Localization & Workspaces** > **Machine translation**. You can also purchase additional credits by clicking the Buy more button on the same page.

> NOTE
>
> Machine translation credits are consumed at a rate of one credit per translated character in the article. Each character translated reduces the available machine translation credits accordingly.

## Using machine translation

You can translate articles using two methods:

1. Machine translation using the **All articles**() section
2. Translating articles from the editor

### Method 1: Machine translation using the **All articles** () section

To translate multiple articles using the **All articles** () section, follow the steps below:

1. Navigate to **Documentation** () >**All articles** () in the Knowledge base portal.
2. From the article list, select the checkbox(s) next to the article(s) you wish to translate.
3. Click **Machine translation**.

   The **Translate to other languages** panel will appear.
4. Select the desired languages (e.g., German and Spanish).
5. Type `Yes` in the confirmation field and click **Yes**.

   > NOTE
   >
   > * The Machine translation feature is only available for WYSIWYG and Advanced WYSIWYG editors. The selected articles will be switched over to the WYSIWYG editor and cannot be reverted.
   > * If you update the content in your main language later, you must repeat these steps to ensure the translated versions reflect the updates.

![Steps to perform bulk machine translation for articles](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenGif-AI_machine_translation.gif)

#### Updating translation status for articles

On the **All articles** () page, after you select one or more articles, you can perform the following translation actions from the toolbar:

1. **Machine translate**: This option is available before an article has been translated for the first time.
2. **Needs translation**: After an article has been translated, you can manually change its status to indicate it requires further translation.
3. **Mark as translated**: When an article is in the translated status, you can manually change it to **Mark as translated** once it's complete.

> **NOTE**  
> The **Need translation** status is only available for secondary languages in your workspace. When a new language is added to a workspace, all articles will appear with the **Need translation** status by default.

### Method 2: Translating articles from the editor

To translate an article from the editor, follow these steps:

1. Navigate to the Knowledge base portal, and from the **Workspace & Language** dropdown, select the desired language.
2. Navigate to the desired article in the editor.
3. Ensure the appropriate content is present in the editor.
4. Click the **Needs translation** dropdown in the top-right corner of the editor to access translation options.
5. Click **Translate** to start the process.

   A progress indicator will appear, and other operations will be restricted until the translation is complete.

![To perform machine translation for individual articles in different language](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGif-AI_machine_translation.gif)

> **NOTE**  
> If a translated article has been updated, and you wish to apply machine translation to the article again, click **✓ Translated** and select **Mark as ‘Needs translation’**. This will change the translation status back to **Needs translation**.

## Understanding machine translation with real-time examples

You can choose between the two methods based on your use case.

1. Scenario 1: Translating articles to existing languages
2. Scenario 2: Adding a new language to the project

Scenario 1

Scenario 2

Assume your main language is English, and your project includes two other languages, such as German and Spanish.

When you create a new article (e.g., **Troubleshooting**) in English, corresponding articles are automatically created in German and Spanish, but they appear without content.

In this scenario, you can use **All articles**() to translate the English content into other languages:

1. Navigate to **Documentation** () > **All articles** () in the Knowledge base portal.
2. Select the **Troubleshooting** article in English.
3. Click **Machine translation**.

   The **Translate to other languages** panel will appear.
4. Select the desired languages (e.g., German and Spanish).
5. Type **Yes** in the confirmation field and click **Yes**.

The content will now be translated from English to German and Spanish.![Translating content from the All articles section in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_ScreenGIF-Translating_content_from_all_articles_realtime_example.gif)

If you add a new language (e.g., French) to your project after creating content in English, then the English content will be automatically replicated in the newly added language.

Navigate to the French articles and click **Needs translation** to translate the content.

However, if languages (e.g., German and Spanish) were already added before drafting the English article, the content will not be automatically replicated. In this case, you must manually translate it from the **All articles** () section.

![Translating content from the article editor in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/6_ScreenGIF-Translating_content_from_editor_real_time_eg.gif)

---

## Managing machine translation credits

To view the available machine translation credits for your project, navigate to **Settings**() > **Knowledge base portal** > **Localization & Workspaces** > **Machine translation**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Machine translate screenshot 1.png)

On this page, you will find the details regarding your used and available machine translation credits.

| Name | Description |
| --- | --- |
| Limit | The total machine translation credits allotted for your project. |
| Usage | The number of credits consumed for machine translation in your project. |
| Remaining | The number of characters remaining from your total machine translation limit. |
| Usage meter | Shows the percentage of translated characters using machine translation from your total limit of 100%. |

> **NOTE**
>
> * An individual article should have fewer than 50,000 characters for machine translation to work. The character count includes all formatting, such as tables, accordions, and other complex elements. Articles with extensive formatting are more likely to exceed this limit. If the character count is too high, consider splitting the article into smaller, manageable sections as a workaround.
> * Machine translation credits are allocated at the project level and apply collectively across all workspaces and languages within that project.

### Machine translation credit limits based on subscription plan

| Plan | Machine translation character limit |
| --- | --- |
| Professional | 1 million characters |
| Business | 2 million characters |
| Enterprise | 5 million characters |

Click **Buy more** to purchase an additional 1 million characters for $50, supporting all three plans: Professional, Business, and Enterprise.

---

## Article translation status indicators

Keep track of the translation status and update it easily as needed. Translation statuses help you identify which articles need updates and which are fully translated, ensuring you’re always informed of your multilingual content's status. The article's translation status indicator is located above the text formatting toolbar in a project workspace that contains multiple languages in both Markdown, WYSIWYG, and Advanced WYSIWYG.

| Status | Indication |
| --- | --- |
| Need translation | The article has not yet been translated or requires additional translation. Initially, the **Need translation** status appears as the default status in all other language articles. The article can either be an existing article created from the base version or a new one.  The options that appear when you click on this status are:   * Translate * Mark as translated   Articles that require translation (with **Needs translation** status) are indicated using the globe (🌐) icon on the left navigation pane. |
| Translated | The article has either been machine or manually translated to the destination language or marked as translated by the team account. |

> **NOTE**  
> The translation status indicator is unavailable on the main language article.

### Filtering articles based on translation status

1. Navigate to **Documentation**() >**All articles** () in the Knowledge base portal.

   The list of articles will appear.
2. Click **Filter** on the right and select the intended filter (**Needs translation** or **Translated**).

From here, you can perform actions such as:

* Changing the translation status
* Machine translate

---

## Troubleshooting

### Encountering error while translating an article

**Error:** Unable to connect the Translate API  
The error message "Error occurred: Unable to Connect the Translate API" appears when attempting to apply machine translation to an article in the editor or from the All articles section. This occurs because the HTML content of the article exceeds the character limit of 50,000 set by the Azure Translation service. Articles with a large number of tables or complex HTML elements are more prone to exceeding this limit, as these elements contribute significantly to the overall character count.

**Steps to resolve:**

1. Open the code view of the article you are trying to translate.
2. Copy the entire HTML content of the article.
3. Use a character counting tool to determine the total number of characters in the HTML content.
4. If the character count exceeds 50,000, split the article content into smaller sections and create multiple articles.
5. Apply machine translation to the smaller articles separately to proceed with the translation.

![Encountering “Error occurred: Unable to connect the Translate API" message while translating an article.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/ScreenGIF-Troubleshooting_Unable_to_connect_the_Translate_API.gif)

### Latest content in the main language not reflected in secondary languages

Updates made to the main language will not automatically reflect in other languages. You must manually initiate the translation process using the Machine translation feature.

When an article is created in the main language, its structure is automatically replicated in secondary languages, but the content itself is not transferred.

**Steps to resolve:** To update the content in secondary languages, follow these steps:

1. Navigate to the **All articles** () section in the main language.
2. Select the article you want to translate into secondary languages.
3. Click **Machine translation**.

   The **Translate to other languages** panel will appear.
4. Select the desired languages.

> **NOTE**
>
> * The translating article(s) will switch to the Advanced WYSIWYG editor and cannot be reverted.
> * Articles in New or Draft status in secondary languages will be overwritten by the latest version from the main language.

5. Type **Yes** in the confirmation field and click **Yes** to proceed.

![Translating content from the All articles section in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_ScreenGIF-Translating_content_from_all_articles_realtime_example.gif)

---

### FAQs

#### What languages are supported for machine translation?

Machine translation supports the following languages:

|  |  |  |  |  |
| --- | --- | --- | --- | --- |
| Afrikaans | Dutch | French (Canada) | Korean | Slovenian |
| Arabic | Dutch (Belgium) | Georgian | Latvian | Spanish |
| Arabic - Egypt | English | German | Lithuanian | Spanish (Mexican) |
| Bulgarian | English (Australia) | Greek | Mongolian | Swedish |
| Chinese | English (UK) | he - עִבְרִית | Norwegian | Thai |
| Chinese (Simplified, People's Republic of China) | English (US) | Hungarian | Polish | Türkçe |
| Chinese (Traditional, Taiwan) | Estonian | Icelandic | Portuguese | Ukrainian |
| Chinese (Traditional) | Filipino | Indonesian | Portuguese (Brazil) | Vietnamese |
| Czech | Finnish | Italian | Romanian | Русский |
| Danish | French | Ja - 日本語 | Slovakian |  |

#### Can I manually translate articles instead of using machine translation?

Yes, you can manually translate articles using external translation services. Once you have finished translating, you can mark them as translated.

#### Is there a limit on how many articles I can translate at once?

No, you can translate multiple articles simultaneously as long as you have sufficient machine translation credits.

#### What happens if my article exceeds the character limit for machine translation?

If an article exceeds the 50,000-character limit, machine translation cannot proceed. To enable translation, reduce the character count. Note that the character count is based on the HTML content, ensuring formatting is preserved across all languages during translation.

#### Can I revert back to the original state after machine translation?

Once an article is machine translated, you can change its status back to "Needs translation," but the original content is not retained. Be sure to keep a backup of the original content if needed.

#### Are there additional costs for using machine translation?

Machine translation is included in your subscription plan. However, exceeding your character limit will incur additional charges.

#### What happens to articles in other languages when I create a new article in the main language?

When you create a new article in the main language, corresponding articles are created in other languages (e.g., German, Spanish) but without content. You will need to translate the content using the Machine translation feature in the Knowledge base portal.

#### What happens when I add a new language to the project?

When a new language is added after content has been drafted in the main language, the content from the main language is automatically replicated in the newly added language's articles. To translate these articles, navigate to them and click **Needs translation** to complete the translation.

#### Why are some articles empty in other languages?

If the desired languages were already added to the project before drafting the article in the main language, the content will not be automatically replicated. You must translate the content manually via **All articles**().

#### How do I delete an article in a specific language without affecting other languages?

When you delete an article in any specific language, it will also be deleted in the main language and other languages, as articles are linked across languages.

To avoid this, you can **hide** the article in that specific language:

1. Navigate to the desired article in that language.
2. Use the **Hide** () option to ensure it does not appear in the Knowledge base for users in that language.

   This way, the article will remain available in other languages within your project.

#### How do I delete all articles in one specific language without deleting other languages?

If you want to delete all articles in a specific language but retain the articles in other languages:

1. Navigate to **Settings**() > **Knowledge base portal** > **Localization & Workspaces** >**Localization & Workspaces**in the Knowledge base portal.
2. Hover over the desired workspace and click the **Edit**() icon.

   The **Edit workspace** panel will appear.
3. Navigate to the desired language and click the **More** () icon.
4. Click **Remove**.

> **NOTE**
>
> This action will permanently delete all articles in that desired language across the project. Other languages will remain unaffected.

<a id="eddy-ai-trust-page"></a>

## Eddy AI trust page

**Plans supporting the use of AI tools**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

At Document360, we are committed to transparency with our customers regarding our products and how we use AI to enhance your experience. Below is an overview of Eddy AI's functionality, along with our related security and privacy practices.

---

## Compliance

Eddy AI, our advanced AI-powered tool, adheres to strict compliance standards such as:

* **GDPR**: We follow the General Data Protection Regulation, ensuring robust data protection and privacy for all individuals in the European Union.
* **SOC 2 Type 2**: Our procedures align with the requirements of SOC 2 Type 2, demonstrating our commitment to security, availability, and confidentiality.

---

## Subprocessors

To deliver a high-quality service, Eddy AI leverages a network of trusted subprocessors. These include:

* **MongoDB**: Used as our vector database.
* **OpenAI**: Provides AI capabilities, utilizing their advanced models.
* **Azure**: Our cloud provider ensures a scalable and reliable infrastructure.
* **Stripe**: Facilitates secure payment processing.
* **Segment**: Used for product analytics to enhance the user experience.

---

## Data Security and Privacy

We take facts, safety, and privacy seriously. All facts associated with Eddy AI are securely stored and encrypted. Here’s how we ensure the integrity and confidentiality of your information:

* **Data at rest**: All the information is encrypted using industry-standard encryption protocols.
* **Data in transit**: Data transmitted between your tool and our servers is encrypted to save you from interception and tampering.

Eddy AI is designed to supply steady and dependable overall performance, even under high utilization.

---

## Resources

**1. Cryptography policy**

**Purpose**: The policy aims to ensure the proper and effective use of cryptography to protect the confidentiality, authenticity, and integrity of information.

**Scope**: The policy applies to all information systems developed and/or controlled by Document360 that store or transmit confidential data.

**Policy Owner**: The CEO is responsible for the policy.

**Effective Date**: The policy becomes effective on March 1, 2024.

**Risk Evaluation**: Document360 evaluates risks and implements cryptographic controls to mitigate them where appropriate.

**Encryption Standards**: Strong cryptography with associated key management processes and procedures must be implemented and documented in accordance with industry standards, including NIST SP 800-57.

**Key Management**: Access to keys and secrets is tightly controlled, and there are specific recommendations for the usage of cryptographic keys, including key types, algorithms, and key lengths for various domains such as web certificates, web ciphers, and endpoint storage.

**Exceptions**: Requests for exceptions to the policy must be submitted to the CEO for approval and must be documented.

**Violations & Enforcement**: Known violations should be reported to the CEO and may result in disciplinary action, including termination of employment.

**Version History**: The policy is in its first version, approved by Yasser Elsaid on February 3, 2024.

**Data at Rest**: Confidential data at rest must be encrypted using symmetric encryption with AES-256 bit for a maximum period of 1 year.

**Passwords**: Passwords must be hashed using one-way hash functions like Bcrypt, PBKDF2, scrypt, or Argon2, with a 256-bit key and a 10K stretch, including a unique cryptographic salt and pepper.

**2. Incident Response Plan**

**Purpose and Scope**: The document aims to provide a plan for managing information security incidents and events, covering all such occurrences within the company.

**Definitions**: It clarifies the difference between a security event (an observable occurrence relevant to data security) and a security incident (an event that results in loss or damage to data security).

**Reporting and Documentation**: Employees are instructed to report any suspected incidents immediately using specific communication channels, and all incidents must be documented.

**Severity Levels**: Incidents are categorized into S1 (Critical), S2 (High), and S3/S4 (Medium/Low) severity levels, with clear guidelines for escalation and response.

**Incident Response Team**: The IT Manager or VP of Support leads the incident response effort, with a designated "War Room" for centralized response. Regular meetings are held to update the incident ticket, document indicators of compromise, and perform other response activities.

**Root Cause Analysis**: For critical incidents, a root cause analysis is performed, documented, and reviewed by the CEO, who decides on the need for a post-mortem meeting.

**Response Process**: The response process includes triage, investigation, containment, eradication, recovery, and hardening, with a focus on lessons learned and long-term improvements.

**Physical Security**: The document addresses the physical security of affected systems, including isolation and backup procedures.

**Breach Determination and Reporting**: Only the CEO can determine if an incident constitutes a breach. The company shall promptly notify all relevant parties in accordance with policies and regulatory requirements.

**External Communications**: The company cooperates with customers, data controllers, and authorities as needed, with legal and executive staff determining the approach.

**Roles and Responsibilities**: The document outlines the specific responsibilities of incident responder roles.

**Special Considerations**: It includes handling internal issues, compromised communications, and root account compromises.

**Incident Status and Summary**: A detailed template is provided for documenting incident details, including date, time, location, personnel involved, type of information involved, indicators of compromise, root cause, and actions taken.

**AWS Root Account Compromise Playbook**: Specific guidance is provided for managing Root AWS account usage in the event of a compromise.

**Policy Owner and Effective Date**: The CEO is the policy owner, and the plan becomes effective on March 1, 2024.

**3. Information Security Roles and Responsibilities Policy**

**Objective**: To establish clear roles and responsibilities for protecting electronic information systems and related equipment.

**Policy Owner and Effective Date**: The CEO is the policy owner, and the plan becomes effective on March 1, 2024.

**Applicability**

* Applies to all Document360 infrastructure, network segments, systems, employees, and contractors involved in security and IT functions.

**Audience**

* All employees and contractors involved in the Information Security Program.
* Includes partners, affiliates, temporary employees, trainees, guests, and volunteers.

**Roles and Responsibilities**

1. **Executive Leadership**:

* Approves capital expenditures for security programs.
* Oversees execution and communication of information security and privacy risk management.
* Ensures compliance with laws and standards (e.g., GDPR, CCPA, SOC 2, ISO 27001).
* Reviews vendor service contracts and oversees third-party risk management.

2. **VP of Engineering:**

* Oversees information security in software development.
* Implements and monitors security controls for development and IT processes.
* Conducts IT risk assessments and communicates risks to leadership.

3. **VP of Customer Support:**

* Manages information security tools and processes in customer environments.
* Ensures compliance with data retention and deletion policies.

4. **System Owners:**

* Maintain confidentiality, integrity, and availability of information systems.
* Approve access and change requests for their systems.

5. **Employees, Contractors, Temporary Workers:**

* Act responsibly to protect health, safety, and information resources.
* Identify areas for improved risk management practices.
* Report incidents and adhere to company policies.

6. **Chief Human Resources Officer:**

* Ensures employees and contractors are qualified and competent.
* Oversees background checks, policy presentation, and Code of Conduct adherence.
* Evaluates employee performance and provides security training.

**Policy Compliance**

* Compliance measured through reports, audits, and feedback.
* Exceptions must be pre-approved by the CEO.
* Non-compliance can lead to disciplinary actions, including termination.

**Document Control**

* **Version**: 1.0
* **Date**: February 3, 2024
* **Author**: Yasser Elsaid
* **Approved by**: Yasser Elsaid

**4. Secure Development Policy**

**Policy Owner and Effective Date**: The CEO is the policy owner, and the plan becomes effective on March 1, 2024.

**Purpose:** To ensure that information security is designed and implemented within the development lifecycle for applications and information systems.

**Scope:** Applies to all Document360 applications and information systems that are business critical and/or process, store, or transmit Confidential data.

**Secure-by-Design Principles:**

* Minimize attack surface area.
* Establish secure defaults.
* Apply the principle of Least Privilege.
* Implement defense in depth.
* Fail securely.
* Avoid security by obscurity.
* Keep security simple.

**Privacy-by-Design Principles:**

* Proactive, preventative approach.
* Privacy as the default setting.
* Privacy embedded into design.
* Full functionality without compromising privacy.
* End-to-End Security.
* Full lifecycle protection.

**Development Environment:** Logical or physical segregation of environments: Production, Test/Staging, Development.

**System Acceptance Testing:** Establish acceptance testing programs and criteria for new information systems, upgrades, and new versions. Complete a Release Checklist before deploying code.

**Protection of Test Data:** Test data must be selected carefully, protected, and controlled. Confidential customer data must be protected and not used for testing without explicit permission.

**Change Control Procedures:** Ensure development, testing, and deployment of changes are not performed by a single individual without approval and oversight.

**Software Version Control:** All software is version controlled, with access restricted based on role.

**Policy Compliance:** Measured through reports, audits, and feedback. Non-compliance may result in disciplinary action, up to and including termination.

**5. Code of Conduct Policy**

**Policy Owner**: The CEO is responsible for the policy.

**Effective Date**: The policy becomes effective on March 1, 2024.

**Purpose**: The policy aims to establish and maintain a safe and inclusive environment for all staff members.

**Scope**: This policy applies to all staff members across all professional settings within the organization.

**Culture**: The organizational culture promoted by this policy emphasizes respect, collaboration, and consideration among all employees.

**Expected Behavior**: Staff members are expected to actively participate in creating a respectful and collaborative workplace environment.

**Unacceptable Behavior**: Any form of harassment, violence, discrimination, or inappropriate conduct is strictly prohibited.

**Weapons Policy**: The policy prohibits the possession of weapons on company premises, with strict consequences for violations.

**Consequences**: Non-compliance with this policy will result in immediate corrective actions, including disciplinary measures and the requirement to report violations.

**Responsibility**: The CEO holds the responsibility for ensuring that all staff members adhere to and uphold the principles outlined in this policy.

**6. Access Control Policy**

**Policy Owner**: The CEO is responsible for the policy.

**Effective Date**: The policy becomes effective on March 1, 2024.

**Purpose:** The purpose of this policy is to restrict access to information and systems to authorized individuals in accordance with business objectives.

**Scope:** This policy applies to all systems operated by Document360 that handle confidential data for employees and external parties with network access.

**Access Control and User Management Summary:**

**Identifying Users:** Access privileges are allocated based on specific job roles and competencies required to perform tasks.

**Maintaining Authorization:** All allocations of privileged access are documented and maintained to ensure accountability.

**Enforcing Security Measures:** Multi-factor authentication (MFA) is mandatory for privileged access to enhance security. Generic administrative IDs are prohibited to prevent unauthorized usage.

**Adopting Protocols:** Time-bound access permissions are granted to limit exposure and reduce security risks.

**Logging and Auditing:** All privileged logins and activities are logged and audited to monitor for unauthorized access or misuse.

**User Access Reviews:** Regular reviews ensure that distinct and appropriate identities are maintained for those with privileged access.

**Access Control Policy:** Access is restricted to authorized parties only, ensuring that information remains protected.

**Password Management**: Secure log-on procedures and password policies are implemented to safeguard against unauthorized access.

**User Access Provisioning:** Access permissions are granted based on documented business requirements and validated needs.

**Violations & Enforcement:** Violations of this policy are reported and subject to enforcement measures to maintain compliance and security.

**7. Data Management Policy**

**Policy Owner**: The CEO is responsible for the policy.

**Effective Date**: The policy becomes effective on March 1, 2024.

**Purpose:** To ensure information is classified, protected, retained, and securely disposed of based on its importance to the organization.

**Scope:** Applies to all data, information, and information systems of Document360.

**Data Classification:** Confidential: Highly sensitive data needing the highest protection levels. Examples include customer data, PII, company financials, strategic plans, and technical reports.

**Restricted:** Proprietary information requiring thorough protection. Default classification for all company information unless otherwise stated. Examples include internal policies, legal documents, contracts, and emails.

**Public:** Information intended for public consumption and can be freely distributed. Examples include marketing materials and product descriptions.

**Data Handling:**

**Confidential Data:**

* Restricted access to specific employees or departments.
* Must be encrypted at rest and in transit.
* Should not be stored on personal devices or removable media.
* Requires secure storage and disposal.

**Restricted Data:**

* Access restricted to users with a need-to-know basis.
* Requires management approval for external transfer.
* Secure storage and disposal are mandatory.

**Public Data:** No special protection or handling controls required.

**Data Retention and Disposal:**

* Data retained as long as needed for business, regulatory, or contractual requirements.
* Confidential and restricted data securely deleted when no longer needed.
* PII deleted or de-identified when no longer needed for business purposes.

**Annual Data Review:** Management reviews data retention requirements annually to ensure compliance with the policy.

**Legal Requirements:** Data associated with legal holds or lawsuits is exempt from standard policy requirements and retained per legal counsel’s stipulations.

**Policy Compliance:** Compliance measured through business tool reports and audits.

**Exceptions:** Any exceptions to the policy require CEO approval.

**Violations & Enforcement:** Known policy violations should be reported to the CEO and can result in disciplinary actions, including termination of employment.

**8. Operations security policy**

**Policy Owner**: The CEO is responsible for the policy.

**Effective Date**: The policy becomes effective on March 1, 2024.

**Purpose and Scope:**

* Ensure the secure operation of information processing systems and facilities.
* Applies to all critical Document360 information systems and third-party entities with network access.

**Documented Operating Procedures:**

Technical and administrative procedures must be documented and accessible to relevant users.

**Change Management:**

* Significant changes must be documented, tested, reviewed, and approved before deployment.
* Emergency changes require retrospective review and authorization.

**Capacity Management:**

* Monitor and adjust processing resources and system storage to meet performance requirements.
* Include human resource capacity in planning and annual risk assessments.

**Data Leakage Prevention:**

* Identify and classify information per the Data Management Policy.
* Train users on proper handling of sensitive information.
* Use Data Loss Prevention (DLP) tools based on risk assessment.

**Web Filtering:**

* Implement DNS and IP blocking to restrict access to risky websites.
* Block websites with malicious content or command and control servers unless necessary for business.

**Separation of Environments:**

* Strictly segregate development, staging, and production environments.
* Do not use confidential production customer data in development or test environments without approval.

**Systems and Network Configuration:**

* Follow configuration and hardening standards to maintain system and network security.
* Review production network access configuration rules annually.

**Protection from Malware:**

* Implement detection, prevention, and recovery controls for malware.
* Utilize anti-malware and threat detection software on all company endpoints and emails.

**Information Backup:** Design and implement backup processes for systems and data, ensuring customer data recovery per SLAs.

**Logging and Monitoring:** Implement logging and monitoring to detect and respond to security incidents.

**Control of Operational Software:** Manage the installation and use of operational software according to established rules.

**Threat Intelligence:** Collect and analyze information security threats to produce actionable intelligence.

**Technical Vulnerability Management:** Identify, assess, and address technical vulnerabilities in a timely manner.

**Restrictions on Software Installation:** Establish rules for software installation to ensure security and compliance.

**Information Systems Audit Considerations:** Plan and agree on audit requirements to minimize disruptions to business processes.

**Systems Security Assessment and Requirements:** Include security requirements in the acquisition or significant changes to systems.

**Data Masking:** Implement data masking techniques to protect PII and sensitive data based on risk assessment.

---

## Data Privacy

We prioritize your privateness and cling to strict information dealing with practices:

* Data Privacy Compliance: We have signed a Data Processing Agreement (DPA) with OpenAI, outlining our commitment to data privacy and protection. For more details, refer to [DPA with OpenAI](https://ironcladapp.com/public-launch/63ffefa2bed6885f4536d0fe).
* We utilize OpenAI's ChatGPT 3.5 and GPT-4 models to power Eddy AI, ensuring cutting-edge performance and capabilities.
* This feature adheres to OpenAI's privacy policies by using a form of OpenAI integration.
* We send data to OpenAI via their APIs. An extract from the policy states, "OpenAI will not use data submitted by customers via our API to train OpenAI models or improve OpenAI's service offerings." Any data sent through the API to OpenAI will be retained for analytical purposes for a maximum of 30 days, after which it will be deleted.

> **NOTE**
>
> Read the complete [**OpenAI API data usage policies**](https://openai.com/enterprise-privacy/).
>
> If you have any queries regarding Document360's data policy, please read our [**Privacy policy**](https://document360.com/privacy/).

<a id="ai-writer-suite"></a>

## AI writer suite

**Plans supporting the use of AI writer suite**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The AI writer suite in Document360 is a powerful collection of AI-driven tools designed to streamline your content creation process, enhance the quality of your articles, and ensure your documentation remains engaging and relevant. Available directly within the knowledge base portal, this suite offers features that assist with everything from writing assistance and SEO optimization to generating FAQs and recommending related content, all aimed at boosting productivity and improving the reader experience.

---

## Features in the AI writer suite

1. [**AI writer**](/help/docs/ai-writer)

   1. **Outline creation**  
      Automatically generate a structured outline for your articles, helping you to get started with an article more quickly.
   2. **Make longer/Make shorter**  
      Adjust the length of your content with ease, either by expanding or condensing content based on your needs.
   3. **Change tone/Change voice**  
      Modify the tone or voice of your content to match your audience or brand guidelines.
   4. **Split sentences**  
      Break up long, complex sentences into shorter ones to improve readability.
   5. **Convert speech**  
      Switch between active and passive voice based on your documentation needs.
   6. **Improve it**  
      Enhance your writing by making it clearer, more concise, or more impactful.
   7. **Convert into table**  
      Automatically convert a list or paragraph into a neatly formatted table for easier data presentation.
2. [**AI FAQ generator**](/help/docs/ai-faq-generator)  
   Automatically create frequently asked questions (FAQs) based on the content of your article.
3. [**AI title recommender**](/help/docs/ai-title-recommender)  
   Receive AI-driven title suggestions to make your articles more engaging and easier to find.
4. [**AI SEO description generator**](/help/docs/seo-description-generator)  
   Automatically generate search engine-friendly descriptions to boost the visibility of your articles in the search engine results.
5. [**AI tag recommender**](/help/docs/ai-tag-recommender)  
   Get relevant tag suggestions to help categorize and improve the discoverability of your content within the knowledge base.
6. [**AI related articles recommender**](/help/docs/ai-related-articles-recommender)  
   Suggest relevant articles to users based on the current content, helping them find additional information quickly.
7. [**AI Chart generator**](/help/docs/ai-chart-generator)

   Generate pie charts, flow charts, and tables using Eddy AI based on the selected content.
8. [**AI alt text generator**](/help/docs/ai-alt-text-generator)

   Generate alt text for images and videos while uploading using Eddy AI to enhance user experience, improve accessibility, and boost search rankings.

---

## Multilingual support for Eddy AI writer suite

The Eddy AI writer suite seamlessly integrates with the Knowledge base site, offering support for a wider array of languages.

In addition to English (en, en-US, en-GB, en-AU), Eddy AI writer suite supports 15 other languages, including French (fr), Spanish (es), German (de), Norwegian (no), Dutch (nl), Portuguese (pt), Swedish (sv), Italian (it), Korean (ko), Finnish (fi), Polish (pl), Arabic (ar), Hebrew (he), Danish (da), and Brazilian Portuguese (pt-br).

If a workspace is configured with a language not supported by Eddy AI, such as Chinese, the search suite features will not be available for that workspace.

---

## Plan availability and usage limits

The availability of these features varies depending on your subscription plan. Users on the Professional, Business, and Enterprise plans have full access to all the features listed above, while the Freemium plan does not include the AI Writer Suite.

For most features, there is a soft limit of 5,000 credits per month. Specific features like the **SEO description generator** and **title recommender** have a limit of 1,000 credits per month. If you're approaching your limit, you will be notified within the platform.

Here’s a quick overview of the key credit limits per month:

* **Make longer/Make shorter/Outline creation/Change tone**: 5,000 credits
* **AI SEO description generator/AI Title recommender**: 1,000 credits
* **Other features**: Unlimited usage within Professional, Business, and Enterprise plans

These credit limits apply across the AI writer suite, ensuring you have ample room to use these powerful tools throughout the month.

<a id="ai-writer"></a>

## AI writer

**Plans supporting the use of AI writer suite**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Document360 offers a wide range of AI-powered tools, powered by **Eddy AI**, to help contributors enhance their articles efficiently. Here's a detailed overview of available actions, how to use them, and best practices.

You can quickly launch **Eddy AI** using the keyboard shortcut **Ctrl + Spacebar**.

> NOTE
>
> By default, all the **Eddy AI** features will be enabled for a trial account in the Document360 project.

---

## Prerequisite

Ensure your project subscription supports the AI writer feature, which is turned off by default.

1. Navigate to **Settings**() > **AI features** > **Eddy AI** in the Knowledge base portal.
2. Turn on the **AI writer** toggle.

> NOTE
>
> * To know more about the languages supported by Eddy AI, [click here](/help/docs/ai-writer-suite#multilingual-support-for-eddy-ai-writer-suite).
> * Third-party web browser extensions can affect the smooth working of the Document360 AI writer. If you face any issues, try disabling browser extensions such as ad blockers, password managers, or pop-up blockers before continuing.

---

## Accessing the AI writer actions

The AI writer enables you to perform the following actions on your content:

* Outline creation
* Improve it
* Change tone
* Convert speech
* Change voice
* Make longer
* Make shorter
* Convert into table
* Split sentence
* [AI chart generator](/help/docs/ai-chart-generator)

> NOTE
>
> The AI writer is available only in the Advanced WYSIWYG editor.

To access the AI writer features:

1. Select a piece of text content while writing in the Advanced WYSIWYG editor. The selected text must have at least ten words for Eddy AI to generate a response.

   The bubble menu appears with the available tools.
2. Click the **Eddy AI** option and choose the desired actions.

   **Outline creation**

   This feature generates a structured outline based on your article's content or a prompt.

   **How to use**:

   1. Create a new article with a relevant title.
   2. Click on the **Start writing with Eddy AI** feature.
   3. Ask Eddy AI to write an outline for you with the necessary information.

      Eddy AI will analyze your content and suggest an organized outline.
   4. Review and modify the outline as needed.

   **Benefits**:

   * Ideal for creating clear, logical structures in lengthy articles.
   * Saves time by providing an initial outline that you can refine.

   **Best practices**:

   * Always review the AI-generated outline to ensure it aligns with your goals.
   * Use this when writing complex articles or guides.

   **Improve it**

   This feature refines your text by improving grammar, semantics, clarity, and phrasing.

   **Example**:

   Original:  
   *"The system is highly effective because it works well in most cases."*

   Using **Improve it**:  
   *"The system is very efficient as it performs effectively in the majority of situations."*

   **Best practices**:

   * Use this option for drafts that need polishing before publication.
   * Check the enhanced version to ensure it aligns with your intent.

   **Change tone**

   Allows you to modify the tone of your text to suit different audiences or purposes. The available tone options are Professional, Friendly, Casual, Straightforward, and Confident.

   **Example**:

   Original:  
   *"The team will proceed with the update as soon as possible."*

   Change to **Friendly**:  
   *"The team is excited to get started on the update and will do so as soon as possible!"*

   Change to **Professional**:  
   *"The team will initiate the update at the earliest opportunity."*

   **Best practices**:

   * Use tone changes when targeting different audiences (e.g., casual for blogs, professional for reports).
   * Adjust based on the context and intended reader.

   **Convert speech**

   Document360's AI Eddy AI can change the selected text from direct speech to indirect speech or vice versa.

   **Example**:

   Original (Direct):  
   *"He said, 'I will definitely complete the task by tomorrow.'"*

   Convert to Indirect:  
   *"He said that he would definitely complete the task by the following day."*

   **Best practice**:

   Helpful when rewriting quotes or conversations for formal reports or documentation.

   **Change voice**

   Allows you to switch between active and passive voice.

   **Example**:

   Original (Active):  
   *"The team successfully completed the project within the specified date."*

   Using **Change voice** (Passive):  
   *"The project was successfully completed by the team within the specified date.*

   **Best practices**:

   Use this for stylistic choices or when passive voice is more appropriate (e.g., formal writing).

   **Make longer**

   This option allows you to expand the selected text by elaborating on ideas or providing additional details.

   **Example**:

   If you have a brief introduction like:  
   *"Document360 is a knowledge base platform with several advanced features."*

   Using **Make longer**, you can generate:  
   *"Document360 is a comprehensive knowledge base platform equipped with a wide array of advanced features that cater to the diverse needs of users. It offers a user-friendly interface, robust search functionality, seamless integration capabilities, and customizable branding options. The platform enables teams to create, manage, and share knowledge effectively, facilitating streamlined collaboration and information dissemination. With Document360, organizations can enhance productivity, foster innovation, and drive growth by harnessing the power of knowledge management."*

   **Best practices**:

   * Use this feature to elaborate on key points or when your content feels too brief or lacking depth.
   * Review the expanded text for relevance to avoid unnecessary verbiage.

   **Make shorter**

   This feature condenses text, making it more concise without losing its essence.

   **Example**:

   Original:  
   *"The Document360 platform provides a robust set of features, including version control, multi-language support, analytics, and a powerful AI-assisted search, which helps streamline the knowledge management process."*

   Using **Make shorter**:  
   *"The Document360 platform offers version control, multi-language support, analytics, and a powerful AI-assisted search to streamline knowledge management."*

   **Best practices**:

   * Use this when trying to reduce word count or simplify explanations.
   * Great for summarizing long passages or complex ideas.

   **Convert into table**

   This AI option converts selected content into a well-formatted table. It’s especially useful when dealing with data or lists that would be better presented in a table format.

   **Example:**

   A documentation team has 3 technical writers, whereas a customer support team has 2 technical writers. The documentation team has access to software such as SnagIT while the customer support team has access to software such as Freshdesk and Freshchat.

   Using **Convert into table**, the output becomes:

   | Team | Number of Technical Writers | Software Access |
   | --- | --- | --- |
   | Documentation Team | 3 | SnagIT |
   | Customer Support Team | 2 | Freshdesk, Freshchat |

   **Best practices**:

   * Use this for content that involves comparisons, data, or organized lists.
   * Tables can improve readability, especially for technical or detailed content.

   **Split sentence**

   Splits complex sentences into simpler ones to improve readability.

   **Example**:

   Original:  
   *"Document360 is an advanced platform, and it offers numerous features, including analytics, version control, and AI assistance, making it ideal for managing knowledge bases efficiently."*

   Using **Split sentence**:  
   *"Document360 is an advanced platform. It offers numerous features, including analytics, version control, and AI assistance. These features make it ideal for managing knowledge bases efficiently."*

   **Best practices**:

   * Useful when writing for broader audiences or when clarity is paramount.

   An AI response popup window will appear.
3. You can perform either one or more AI operations in a single window.

   > NOTE
   >
   > A single AI response window can be used to regenerate responses for up to 10 instances.

6. When you click **Regenerate**, the preset action is repeated.
7. Click **Insert** to replace the selected text.
8. Click **More** to view the **Eddy AI** features.

   Team accounts can rate the AI response once below the generated content.

![1_ScreenGIF-Overall_AI_Writer](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenGIF-Overall_AI_writer.gif)

> NOTE
>
> The outline creation, make longer, make shorter, improve it, convert to table, convert speech, change voice and change tone features have a soft limit of 5000 uses per month. The SEO description generator, title recommender, and article summarizer features have a limit of 1000 uses per month.

---

### FAQs

#### What subscription plans support the use of the AI writer suite?

The AI writer suite is supported by the Professional, Business, and Enterprise subscription plans.

#### How can I activate the Eddy AI feature?

To activate Eddy AI, navigate to Settings > AI features > Eddy AI and turn on the AI writer toggle.

#### What actions can I perform using the AI writer?

You can perform actions such as making text longer or shorter, creating outlines, changing tone, converting speech, improving text, converting content into tables, changing voice, and splitting sentences.

#### Is the AI writer available in all editors?

No, the AI writer is only available in the Advanced WYSIWYG editor.

#### Will my data be secure when using Eddy AI?

* As this feature uses a form of OpenAI integration, we adhere to the privacy policies of OpenAI. We send data to OpenAI via their APIs.
* An extract from the policy states, "OpenAI will not use data submitted by customers via our API to train OpenAI models or improve OpenAI's service offerings."
* Any data sent through the API to OpenAI will be retained for analytical purposes for a maximum of 30 days, after which it will be deleted.

> Read the complete [**OpenAI API data usage policies**](https://openai.com/policies/api-data-usage-policies).  
> If you have any queries regarding Document360's data policy, please read our [**Privacy policy**](https://document360.com/privacy/).

#### Can I use the AI writer features multiple times in a month?

Yes, the content creation, make it longer, make it shorter, and change tone features have a soft limit of 5000 uses per month.

#### What should I do if I encounter issues with the AI writer?

If you face issues, try turning off any third-party web browser extensions that may affect the AI writer's performance.

#### Are there any best practices for using the AI writer features?

Yes, best practices include reviewing generated content for relevance, using features to elaborate or simplify text, and ensuring the tone matches your audience.

#### How many AI credits do my plan support?

5000 AI credits are allocated each month in the Professional, Business, and Enterprise plans. You can contact our customer support if you need to increase this limit.

Application Programming Interface - A set of rules that allows one software application to communicate with another.

<a id="ai-faq-generator"></a>

## AI FAQ generator

**Plans supporting the use of AI writer suite**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The **AI FAQ Generator** in Document360 is a powerful tool that automatically creates a list of frequently asked questions (FAQs) along with their answers based on the content of your article in the Advanced WYSIWYG editor. This feature is designed to save you time while ensuring that all essential questions are covered.

---

### Prerequisites

To utilize the AI FAQ Generator, ensure you have met the following requirements:

* You must have purchased the **Eddy AI content suite**.
* The **AI writer suite** must be enabled in your Document360 account. This feature is enabled by default upon purchase.

> NOTE
>
> To know more about the languages supported by Eddy AI, [click here](/help/docs/ai-writer-suite#multilingual-support-for-eddy-ai-writer-suite).

---

## AI FAQ generator in Advanced WYSIWYG editor

1. Navigate to the article you wish to enhance in the **Advanced WYSIWYG editor**.
2. Locate and click the **Eddy** icon in the toolbar at the right of the editor.
3. From the dropdown menu, choose **Generate FAQs**.

> NOTE
>
> * The article must contain a minimum of **150 words** for the FAQ generator to function properly.
> * The generated FAQs will automatically be placed at the end of your article, allowing you to add additional content below this section if necessary.

### Customizing generated FAQs

Once the FAQs are generated, you have several options to customize them:

1. You can customize the title of the FAQ section to better fit your article.
2. Click on the **FAQ** section. You will have four options to customize the generated FAQs:

   1. **Settings** (): Click the **Settings** icon to adjust the FAQ template settings for this specific article. Changes made here will apply only to this article.
   2. **Regenerate** (): If you want to create new FAQs based on the current article content, click the **Regenerate** option.
   3. **Expand/Collapse** (): Use the **Expand/Collapse** icon to show or hide the answers to the FAQs.
   4. **Delete** (): If you wish to remove the entire generated FAQ section, click the **Delete** icon.

### Adding custom FAQs

1. Hover between any two FAQs where you want to add a new one.
2. Click the **Add question** ()icon that appears.
3. Fill in your custom question and answer.

To delete a specific FAQ:

4. Click on the FAQ you want to remove.
5. Select the **Delete** () icon that appears above it.

![Adding AI fAQ and FAQ builder in the Advanced WYISYWG editor.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreeenGIF-AI_FAQ_generator_in_the_advanced_WYSIWYG_Editor.gif)

### Locking FAQs

To prevent certain FAQs from being altered during regeneration:

1. Click the Lock () icon next to the FAQ you want to protect.
2. Locked FAQs will be marked with a badge, indicating they are safeguarded from changes.
3. You can still edit these locked FAQs manually if necessary.

If you want to generate additional FAQs while keeping the current ones locked, follow these steps:

1. Lock all existing questions.
2. Click **Regenerate** to create more relevant FAQs based on your article’s content depth.

> NOTE
>
> **FAQ templates** are different from the AI FAQ generator. For detailed information about FAQ templates, refer to the article on the [Advanced WYSIWYG editor](/help/docs/advanced-wysiwyg-editor-basics).

---

## Setting up the FAQ generator

You can customize the FAQ generator settings at the project level by following these steps:

1. Navigate to the Settings ()> **Knowledge base site** > **Article settings & SEO** tab in the Knowledge base portal.
2. In the **Article settings** tab, expand the **FAQ** accordion.

### Customization options

You can customize the FAQ templates as needed from the following options:

1. In the **Expand/Collapse** section, choose your option

   a. **Expand first**: Only the first FAQ will be expanded by default.

   b. **Expand all**: All generated FAQs will be expanded.

   c. **Collapse all**: All generated FAQs will be collapsed.
2. **Style:** For styling the FAQs, choose your desired option:

   a. **With border**: A border will appear around all sides of each FAQ accordion (default option).

   b. **Without border:** Only the bottom border will be displayed on each accordion, except for the last one.
3. **Expand arrow position:** You can select the position of the arrow for expanding FAQs, either right or left. By default, the arrow position is set to right.
4. **Expand/Collapse:** Customize the icons used for expanding and collapsing FAQs. Choose between arrow up/down or plus/minus options.

![Adding AI fAQ and FAQ builder in the Advanced WYISYWG editor.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Setting_page_in_the_Knowledge_base_portal.png)

---

### FAQs

#### What languages does the AI FAQ generator support?

The AI FAQ generator currently supports **English** language only.

#### How do I add a custom FAQ between the generated FAQs?

To add a custom FAQ between the generated FAQs, hover between any two FAQs, click the () icon, and select FAQs from the dropdown.

#### What is the minimum number of questions generated by the AI FAQ generator?

The AI FAQ generator typically produces between **5 and 10 questions**, depending on the content depth of your article.

#### Can I edit the AI-generated FAQs?

Yes, you can edit the AI-generated FAQs by selecting the desired FAQ and making the necessary changes.

#### Is there a usage limit for the AI FAQ generator?

You can use the AI FAQ generator up to 5000 times per month. You can contact our customer support if you need to increase this limit.

<a id="ai-title-recommender"></a>

## AI title recommender

**Plans supporting the use of AI writer suite**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The **Article Title Recommender** is one of the many AI-powered features available in Document360. This tool helps generate optimized article titles using Natural Language Processing (NLP) to analyze your content and suggest titles that capture the key information while maintaining the original context.

---

### Prerequisites

Before using the Article Title Recommender, ensure that the following prerequisites are met:

* **Preprocessed article content** should contain more than **50 words**.
* **Sufficient Document360 credits**: One title recommendation (three title options) consumes **1 credit**.

> NOTE
>
> To know more about the languages supported by Eddy AI, [click here](/help/docs/ai-writer-suite#multilingual-support-for-eddy-ai-writer-suite).

---

## Using the article title recommender

The **Suggest Title** option is available in the article title section for new articles.

For published or draft articles, follow these steps:

1. Click the article title in the editor to display the **suggest title** feature.
2. Click the **Ask Eddy AI** button.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Title recommender 1.png)

   Three AI-generated title suggestions will appear.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Title recommender 2.png)
3. You can click **Generate more suggestions** for additional options.
4. Choose your preferred title and click **Choose**.
5. If none of the titles meet your needs, click **Cancel** to close the module.

#### Key options:

* **Suggested titles**: Each click on 'Suggest title' generates three title options. Select your preferred title by clicking the radio button beside it.
* **Share feedback**: You can upvote or downvote the suggested titles to provide feedback. This helps improve the feature's performance.
* **Save/Cancel**: After selecting a title, click **Save** or click **Cancel** to exit. **One credit** is consumed each time you click **Suggest title**, regardless of whether you save or cancel.

---

### Credit usage and limits

* Every time you click the **Suggest title**, **one credit** is used, even if you don’t save the suggestion.
* Your subscription plan determines your monthly credit limit.

  > NOTE
  >
  > The soft limit of **1000 credits per month** applies to the **title recommender** feature across the Professional, Business and Enterprise plans. Additional credits can be obtained by contacting customer support.
* **Credits do not automatically renew** each month. For additional credits, contact customer support.

---

### What are preprocessed words in Document360?

**Preprocessing** filters out certain elements from the article content for the purpose of title recommendation. The following elements are **excluded** from the word count:

* HTML tags
* Images
* URLs/links
* Code blocks

For example, if the article word count shown at the bottom of the editor is **220 words**, this includes all elements. After preprocessing, the word count might drop. Ensure your content has more than **50 preprocessed words** for the Title recommender to work.

---

### Data privacy

We prioritize the privacy of your Knowledge base data. The Title Recommender uses OpenAI integration, and we strictly adhere to the **OpenAI privacy policies**. An extract from the policy states: "OpenAI will not use data submitted by customers via our API to train OpenAI models or improve OpenAI's service offerings."

* [Read the full OpenAI API data usage policy here](https://openai.com/privacy).
* For Document360's data policy, refer to our Privacy Policy.

Application Programming Interface - A set of rules that allows one software application to communicate with another.

<a id="seo-description-generator"></a>

## AI SEO description generator

**Plans supporting the use of AI writer suite**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The SEO description generator helps streamline the process of creating meta descriptions for your articles and category pages. Automatically generating concise and relevant descriptions ensures that your content is better optimized for search engines, enhancing visibility and click-through rates. This tool saves time while maintaining alignment with your content's focus and SEO best practices.

---

## Prerequisites

Before generating an SEO description for your article or category page, ensure that the following prerequisites are met:

1. **Sufficient credits**: You must have enough credits to generate an SEO description. Credits are consumed per description generated.
2. **Preprocessed content**: The article’s preprocessed word count (excluding HTML tags, images, URLs, and code blocks) must exceed 200 words. Keep in mind that the word count displayed at the bottom of the Document360 editor includes all elements, including those that do not count toward the meta description generation. Make sure the content exceeds 200 words after preprocessing.

   Example: If an article shows 250 words, but contains images, HTML, and links, the preprocessed count may drop below 200, making it ineligible for SEO description generation.
3. **Access permissions**: The **Ask Eddy AI** button will only be available to team members with the relevant permissions. If disabled, contact your administrator to gain access.

> NOTE
>
> To know more about the languages supported by Eddy AI, [click here](/help/docs/ai-writer-suite#multilingual-support-for-eddy-ai-writer-suite).

---

## Using the SEO description generator

For individual articles or category pages,

1. In the Knowledge base portal, go to the desired article/category page.
2. Click on the More () icon at the top-right corner and select **SEO.**

   The **Article settings** panel will appear.
3. Expand the **SEO** section and click the **Ask Eddy AI** button.

   The meta description is generated by Eddy AI based on the article/category page content.
4. Review the generated description and click **Save**.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/SEO.png)

> PRO TIP
>
> Always double-check the generated meta description to ensure it aligns with the intent of your article. Although AI-generated descriptions are efficient, manual review ensures the content is accurate and relevant to your audience.

---

## How to generate SEO descriptions for multiple articles/category pages?

You can generate meta descriptions for multiple articles/category pages in the same version and language.

1. Navigate to the Documentation () > **Content tools** > **Documentation** > **SEO description**.
2. Select the desired workspace from the project workspace dropdown.
3. Ensure that the selected language is **English.**
4. All the articles and category pages in the selected workspace and language appear.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/SEO Description.png)

> NOTE
>
> The preprocessed word count appears next to the article/category page name. You can generate meta descriptions only for the articles and category pages with a preprocessed word count of more than 200.

5. Use filter options to narrow down articles by SEO description availability, category, contributor, tags, or last updated date.

   **Example:** If you want to generate descriptions for articles that haven’t been updated recently, filter by "Date" to prioritize older articles.
6. Select the checkbox next to each eligible article (those with a preprocessed word count of over 200). Click **Ask Eddy AI** to generate meta descriptions for multiple articles at once.
7. Review the descriptions and click **Yes** in the confirmation prompt to save.

> PRO TIP
>
> Prioritize generating meta descriptions for high-traffic or cornerstone content first, as improving SEO for these pages can have the biggest impact on your overall search engine visibility.

---

### Best practices for writing SEO meta descriptions & titles

Creating effective meta descriptions and titles is crucial for improving your search engine rankings. Here are some best practices to help you craft strong meta descriptions and titles:

#### Best practices for SEO meta descriptions

1. **Keep it concise (around 155-160 characters):** Meta descriptions should be brief yet informative. They are snippets that appear in search engine results, so ensure they’re clear and concise.
2. **Include relevant keywords:** Incorporate primary and secondary keywords naturally, reflecting the core topic of the article to improve discoverability.
3. **Align with user intent:** Ensure the meta description answers what your target audience might be looking for. This helps increase click-through rates by attracting the right audience.
4. **Make it actionable:** Use calls to action like “Learn more,” “Discover,” or “Get started” to encourage users to click on your link.
5. **Unique for every page:** Ensure every page on your website has a unique meta description to avoid duplicate content issues.
6. **Avoid keyword stuffing:** Overloading the meta description with too many keywords can make it seem unnatural and may negatively impact SEO.

> **PRO TIP**
>
> Focus on clarity and relevance. Even though meta descriptions don’t directly impact rankings, they play a significant role in improving click-through rates.

#### Best practices for SEO titles

1. **Optimal length (50-60 characters):** Keep your title under 60 characters to ensure it doesn’t get cut off in search results.
2. **Include primary keywords:** The title should include your primary keywords, preferably at the beginning, to improve relevance for search engines.
3. **Reflect the article’s content:** The title should accurately represent the article’s subject matter to avoid misleading users or increasing bounce rates.
4. **Make it engaging:** Write compelling titles that spark interest. Use power words or questions to attract user attention.
5. **Avoid redundancy:** Ensure your title is clear, straightforward, and free from unnecessary repetition of words.
6. **Brand inclusion (optional):** You can add your brand’s name at the end of the title to improve brand visibility, but only if space allows without truncating essential keywords.

---

### FAQs

#### Why is an SEO description generator essential?

Use the SEO description generator to generate the meta descriptions for your articles and category pages effortlessly. This AI (Artificial Intelligence) powered feature will generate the best meta description for your articles and category pages based on the content.

#### What is a meta/SEO description?

A meta description or SEO description summarizes an article/category page. The meta description appears as snippets in the search engine results. Adding meta descriptions will improve your SEO, discoverability, and increase organic traffic.

#### How are credits associated with the SEO description generator?

Credits are required to generate SEO descriptions with the SEO description generator. One credit is consumed when you generate a meta description for an article/category page. For example, if you want to generate the meta description for 50 articles, you need 50 credits.

#### Does Document360 offer free credits for generating meta descriptions?

Yes, we offer ten free credits for all paid projects. You cannot avail free credits in the Trial plan.

#### Why the article word count shown in the editor varies from preprocessed word count?

The preprocessed word count excludes content elements such as HTML tags, Images, URLs/links, and Code blocks. The article word count includes all the elements in the content.

#### What happens when I generate an SEO description for an article which already has an SEO description?

* One credit would be consumed to generate the meta description.
* The generated meta description will replace the current meta description.

#### Can I generate different meta descriptions with the same article content?

No, the meta description changes only if the content is modified. Suppose you generate the meta description for the same content. In that case, the same meta description will be generated again, and one credit will be consumed.

#### Can I manually update the SEO title and SEO description?

You can manually update the SEO title and SEO description on the SEO description overview page or in the individual article settings.

#### Can I generate SEO descriptions for articles in languages other than English?

Currently, we support the SEO description generator only for the English language. However, you can manually add SEO descriptions for articles in other languages.

#### Do search engines crawl SEO descriptions of private articles?

No, search engines cannot crawl private articles.

#### What is the validity of the credits?

The credits are valid for the lifetime of the project.

#### Do the credits get affected by a change in the subscription plan?

No, the credits are not affected by a subscription plan change.

#### Does Document360 provide a refund for unused credits?

No, we don't provide a refund for unused credits.

#### Can I generate an SEO title with the SEO description generator?

You can only generate meta descriptions with the SEO description generator. As the article's title is considered an SEO title for an article without an SEO title, you can use Document360's AI title recommender feature.

#### Can I switch between languages in the SEO description module?

Yes, you can switch between languages in the SEO description module. This option lets you update the meta description for multiple articles in one place. However, the SEO description generator can be used only in English.

#### How many SEO descriptions can I generate?

Here’s a breakdown of the soft limits for the SEO description generator based on the pricing plans:

* **Professional**: 1000 descriptions/month
* **Business**: 1000 descriptions/month
* **Enterprise**: 1000 descriptions/month

#### Is my data security maintained?

We understand that your Knowledge base data is sensitive. As this feature uses a form of OpenAI integration, we adhere to the privacy policies on OpenAI. An extract from the policy states, "OpenAI will not use data submitted by customers via our API to train OpenAI models or improve OpenAI's service offerings."  
Read the complete [**OpenAI API data usage policies**](https://openai.com/policies/api-data-usage-policies)  
If you any queries regarding Document360's data policy, please read our [**Privacy policy**](https://document360.com/privacy/)

Application Programming Interface - A set of rules that allows one software application to communicate with another.

<a id="ai-tag-recommender"></a>

## AI tag recommender

**Plans supporting the use of AI tag recommender**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The AI tag recommender is a powerful tool that leverages Artificial Intelligence (AI) to suggest relevant tags for your article or category page content. By analyzing the content and identifying common keywords and topics, the AI recommends a set of tags. These tags help categorize and organize your content, making it easier for both team members and readers to find the right information within your Knowledge base.

---

### Prerequisites

* **Preprocessed article content** must be more than 50 words.
* You must have the relevant access permissions to generate tags.

> NOTE
>
> To know more about the languages supported by Eddy AI, [click here](/help/docs/ai-writer-suite#multilingual-support-for-eddy-ai-writer-suite).

---

## Accessing the recommended tags for an article

1. Go to the desired article in the {{glossary.Knowledge base portal}}.
2. Click **More** (•••) at the top right of your editor next to the Publish button.
3. Select **Tags** to open the **Article settings** page.
4. Click the **Ask Eddy AI** button.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/AI tag recommender 1(1).png)

   You will find a set of AI-suggested tags based on the article content in the **Eddy AI recommends** section.

   > NOTE
   >
   > To use the AI tag generator, your article must have a word count of at least 200 words.
5. Click to choose the suitable tags to add them to the article and click **Save**.
6. Reopen the article settings to regenerate tags.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/AI tag recommender 2.png)

> NOTE
>
> The recommended tags also appear in the confirmation prompt when publishing an article. In the **Publish confirmation** prompt. Expand the **Configure article settings** section and click **Ask Eddy AI** in the **Tags** section for tag recommendations. Select the suitable tags to add it before publishing the article.

---

### What does preprocessing mean?

Preprocessing refers to the filtering of specific elements in the article or category page content. The following elements are excluded when generating tags:

* HTML tags
* Images
* URL/links
* Code blocks

For example, if your article shows 80 words at the bottom of the Document360 editor, this number includes HTML tags, links, and code blocks. After preprocessing, the word count might be reduced. Ensure the preprocessed article contains more than 50 words to generate tags.

---

**Why is tagging important?**  
Adding tags to your articles is essential for effective content management, especially when dealing with a large volume of information. Tags categorize articles based on themes or topics, making them easier to locate through searches. Proper tagging improves search precision, enhances content discoverability, and ensures that related articles are grouped together, benefiting both your internal team and external users.

---

## Best practices for content management

To make the most out of tagging, follow these best practices to ensure your knowledge base is well-organized and easy to navigate:

1. **Create a consistent tagging structure**: Establish clear guidelines for how tags should be used across all articles. Consistency is key to making sure similar content is grouped appropriately. For instance, decide in advance whether to tag articles based on topics, products, or user roles and follow this approach throughout.
2. **Use specific and relevant tags**: Avoid broad or vague tags that don't provide enough context. Focus on tags that directly relate to the article's core content. For example, instead of using a general tag like "Update," specify "Security Update" or "Feature Update."
3. **Limit the number of tags**: While tags are important, applying too many can be counterproductive. Aim to use 3-5 key tags per article that best describe the content. This keeps searches focused and avoids cluttering the tagging system.
4. **Review and update tags regularly**: As your content evolves, review and update your tags to ensure they remain relevant. Retire or modify tags that are outdated or no longer applicable to ensure efficient content retrieval.
5. **Group content using tags**: Tags allow you to group related content, improving navigation. For example, you could tag all articles related to "Onboarding," "Troubleshooting," or "Product Features" to create clusters of related content, helping users easily find what they need.
6. **Leverage the AI tag recommender**: Use the AI Tag Recommender feature to ensure consistent and relevant tagging across your articles. The AI's suggestions will help maintain uniformity, which is especially useful when different team members are managing content.

---

### FAQs

#### Who can generate the Tags?

Team accounts with the following permission combinations can generate the tags:

* Update article settings + Manage Tags
* Publish article + Manage Tags
* Update article settings + Publish article + Manage Tags

#### Can I generate the tags for multiple articles in one go?

Currently, you can generate the tags for one article at a time.

#### Does using the AI tag recommender feature spend credits?

No, the AI tag recommender feature does not consume any Eddy AI credits. This feature currently offers unlimited usage without any credit limitations.

#### Can I still add the Tags manually?

Yes, you can add the Tags manually.

#### Can I turn off the Tag recommendations?

No, you cannot turn off the Tag recommendations.

<a id="ai-related-articles-recommender"></a>

## AI related articles recommender

**Plans supporting the use of AI related articles recommender**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Document360's AI-powered related articles recommender enables team accounts to automatically associate relevant related articles based on the content of your current article. This feature enhances the user experience by ensuring that readers have quick access to additional information related to their queries.

---

### Prerequisites

* Preprocessed article content must be more than 200 words.
* You must have the relevant access permissions and credits to generate related articles.

> NOTE
>
> To know more about the languages supported by Eddy AI, [click here](/help/docs/ai-writer-suite#multilingual-support-for-eddy-ai-writer-suite).

---

## Accessing the AI related article recommender

You can add related articles using Eddy AI by following the below steps:

1. Navigate to the **Documentation** in the Knowledge base portal.
2. Select any published or unpublished article.
3. Click on the **More** (•••) option and select **Related articles**.

   If related articles have already been added, you can view the list below the search bar.
4. Click **Ask Eddy AI**, and Eddy AI will recommend the related articles.

   > NOTE
   >
   > To use the AI related article recommender, your article must have a word count of at least 50 words.
5. Click the **Add** () icon to include the desired articles in the related articles list.
6. Turn on the **Auto relate this article to all related articles** toggle, if needed.

   > NOTE
   >
   > When **Auto relate this article to all related articles** is enabled, if Article-A is added as a related article in Article-B, then Article-B will appear as a related article in Article-A. Save time by using this toggle for adding related articles.
7. Once you have made changes, click **Save**.

   > NOTE
   >
   > To add related articles to your entire Knowledge base in one instance, read the article on [**Dynamic related article recommendation**](/help/docs/ai-dynamic-related-articles-recommendation) article.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_ScreenGIF-Adding_related_articles_manually_KBsite_1_0.gif)

---

### Accessing the AI related article recommender in the publish checklist

You can also use the Related articles recommender when publishing an article by following these steps:

1. Click **Publish** on any desired article.

   The **Publish confirmation** prompt will appear.
2. Expand the **Configure article settings** section.
3. Scroll down to view the **Related articles** section.
4. Click **Ask Eddy AI**, and Eddy AI will recommend the related articles.
5. Click the **Add** () icon to include the desired articles in the related articles list.
6. Once done, click **Yes.**

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screengif-Adding_related_articles_in_publish_checklist.gif)

---

### Viewing related articles in the knowledge base site

In the knowledge base portal, related articles are generated by Eddy AI and can be found in the **Related articles** section at the bottom of each article. Readers can click on a related article to navigate directly to it, making it easy to explore additional resources and information relevant to the current reading.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Related articles in KB site.png)

---

### FAQs

#### How many related articles can Eddy AI generate at one time?

Eddy AI can generate a maximum of 3 related articles at one time.

#### Can I manually add related articles in addition to those recommended by Eddy AI?

Yes, you can manually add articles, and Eddy AI’s recommendations will complement your selection.

#### Will previously added related articles be overwritten when I use Eddy AI?

No, Eddy AI will suggest additional articles. You can choose to add them without affecting your existing related articles.

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

<a id="ai-chart-generator"></a>

## AI Chart generator

**Plans supporting the use of AI chart generator**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The **AI Chart generator** in Document360 allows you to automatically convert text into various visual formats, such as pie charts and flow charts. This feature streamlines the process of creating charts, eliminating the need for third-party tools and saving time in generating visual aids directly within your articles.

## Prerequisites

To use the AI Chart generator, you must meet the following requirements:

* You must have an active subscription to the Eddy AI content suite.
* The AI writer suite must be enabled in your Document360 account.
* Ensure that the text or table you want to convert is within the main body of your article. Text within comments or image captions cannot be used for chart generation.

> NOTE
>
> To know more about the languages supported by Eddy AI, [click here](/help/docs/ai-writer-suite#multilingual-support-for-eddy-ai-writer-suite).

---

## Creating charts from text

1. In the Advanced WYSIWYG editor, highlight the content you want to turn into a chart.
2. Click the Eddy AI option in the floating bubble menu and select the **Generate** option from the dropdown menu.
3. Choose the type of chart you want to generate. Available options include **Pie chart**, **Flow chart**, and **Table**.
4. The system will create a chart of the highlighted text based on your selection. If the generated chart is not satisfactory, you can regenerate it up to 10 times. Regenerations are tracked and displayed in tabs, allowing you to review previous versions and select the best one.
5. Once you are satisfied with the generated chart, you can either replace the selected text or insert the chart below the selected text as an image within your article.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_GIF-Create_flow_chart_from_text.gif)

> NOTE
>
> If the system fails to generate the chart, an error message will be displayed: "No results found. Please revise the content or add more context and try again." You can dismiss the error message by clicking elsewhere on the screen or the close button.

## Creating charts from tables

1. Highlight the table you want to convert into a chart.
2. Click the Eddy AI option in the floating bubble menu and select the **Generate** option from the dropdown menu.
3. Choose the type of chart you want to generate. Available options include **Pie chart**, **Flow chart**, **Table**.
4. The system will create a chart of the highlighted text based on your selection. If the generated chart is not satisfactory, you can regenerate it up to 10 times. Regenerations are tracked and displayed in tabs, allowing you to review previous versions and select the best one.
5. After generating the chart, you can either replace the table or insert the chart below the table as an image.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_GIF-Create_piechart_from_table.gif)

> NOTE
>
> The final generated chart which you use in your article is saved in the Document360 Drive, allowing you to reuse it in other articles if needed.

## Customizing charts

After generating a chart, you can customize its appearance using the editing options available for images in Document360:

* **Alignment and positioning**: Use the bubble menu to adjust the alignment or inline positioning of the chart.
* **Edit chart**: You can edit the chart using the image editing options in the editor, such as cropping, resizing, or adding annotations.

> NOTE
>
> Although the chart cannot be edited directly once inserted into the article, you can undo the action, update the content, and generate a different result, or regenerate the chart using the same text but with a different chart type.

* **Undo option**: If you accidentally replace content with a generated chart and want to revert, use the Undo (Ctrl+Z) option to restore the original content.

## Supported chart types

Document360 currently supports the following chart types:

* **Pie charts**

  + **Use case**: Show the distribution of parts within a whole. Useful for visualizing proportions, such as categories, percentages, or data segments.
  + **Example**: Display the percentage of tasks completed by different team members.
* **Flow charts**

  + **Use case**: Map out processes, workflows, or decision sequences. Ideal for illustrating step-by-step procedures or decision trees.
  + **Example**: Outline the steps involved in a document approval process or a user onboarding workflow.
* **Tables**

  + **Use case**: Present structured data for easy comparison. Ideal for displaying data sets, such as comparisons or performance metrics.
  + **Example**: Compare product features, service levels, or user feedback across different categories.

## File naming convention

All generated charts will follow a standardized naming convention. The file name will be AI generated based on context, or the selected content. The file name will be appended with the chart type. For example - **sales\_data\_pie\_chart.png**.

---

### FAQs

#### Can I edit a generated chart?

No, once a chart is generated, it cannot be edited directly. However, you can regenerate the chart with updated content or switch to a different chart type.

#### What are the possible reasons for chart generation to fail, and how can I fix it?

Chart generation may fail due to:

1. Insufficient or incomplete data.
2. Unsupported content (e.g., comments, captions).
3. Formatting issues or exceeding data limits.

To resolve this, provide more context by using structured lists, numeric data, or grouping information logically (e.g., by region, product type). These text types are ideal for generating accurate charts. If generation fails, revise the content and try again.

#### Where are the generated charts saved?

The final generated charts used in the article are saved in the Document360 Drive, allowing you to reuse them in multiple articles. The generated charts will be saved to **Images** > **Documentation** in the Document360 Drive.

#### How many times can I regenerate a chart?

You can regenerate charts type up to 10 times. This includes switching between chart types.

#### Are all versions of generated charts saved?

No, only the final chart that you choose to insert or replace in the document will be saved in the Document360 drive. Charts generated during the regeneration process are not saved unless they are inserted into the article.

#### Is there an undo option after replacing content with a chart?

Yes, you can use the Undo (Ctrl+Z) option to restore the original content if you are not satisfied after replacing content with a generated chart.

#### Does the AI Chart generator consume Eddy AI credits?

Yes, each chart generated using the AI Chart generator consumes credits from your monthly Eddy AI credit limit. This includes generating charts from text or tables, as well as regenerating charts to try different types or updated visuals. Each generation or regeneration counts as one credit deduction from your monthly credit allowance under the Eddy AI content suite.

<a id="ai-alt-text-generator"></a>

## AI alt text generator

**Plans supporting the use of AI alt text generator**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

> NOTE
>
> For users on the Legacy plans, AI alt text generation will be available if you have purchased Eddy AI content suite add-on.

Writing alt text for images can be time-consuming but is vital for accessibility and discoverability. Alt text, also known as alt tags, appears when an image fails to load and comes to the help of visually impaired users when they choose the read out loud option in the KB site. With 20% of Google searches being image-based, optimized alt text enhances user experience, improves accessibility, and boosts search rankings.

To address this challenge, Document360 offers the Eddy AI alt text generation feature. This tool automatically suggests alt text for your images, helping you adhere to best practices like keeping descriptions concise while ensuring accessibility compliance. You can easily edit or use these suggestions as they are, saving time and effort.

Document360’s Eddy AI alt text generation feature streamlines this process by providing concise, accessible suggestions. For instance, it might describe a software interface as **Document360’s settings dashboard with configuration options**. This ensures compliance, saves time, and enhances discoverability.

By combining accessibility and search optimization, the Eddy AI alt text generation feature empowers businesses to make their visual content more impactful while delivering a seamless user experience.

> NOTE
>
> * This feature is enabled by default if the AI writer is enabled.
> * You can generate up to 5000 alt texts per month. Each API call deducts one soft limit, so one project can use it across various articles.
> * Eddy AI can only generate alt text for images smaller than 20 MB in JPEG, JPG, PNG, and WEBP formats.
> * Eddy AI Alt text generator feature supports only in **English** language.
> * Eddy AI Alt text generator may have accuracy limitations with panorama images, fisheye view images, and icons with monochrome colors.
> * To know more about the languages supported by Eddy AI,  [click here](/help/docs/ai-writer-suite#multilingual-support-for-eddy-ai-writer-suite).

---

## Generating AI alt Text in the Advanced WYSIWYG Editor

To generate alt text while uploading an image in the Advanced WYSIWYG editor, follow these steps:

1. Navigate to the article in the Advanced WYSIWYG editor.
2. Use the slash command `/image` or go to **Insert > Image**.

   The **Insert Image** panel will appear.
3. Insert images using one of the following methods:

   * **Upload from my device**:  
     Select an image from your local device. Eddy AI will automatically generate alt text in the **Alt Text** field.
   * **Choose from Drive**:  
     Select an image from the Drive.

     + If the image already has alt text from the Drive, it will persist.
     + To update or regenerate the alt text, click the inserted image, then click the **Alt text** () icon in the floating menu.
   * **Drag and drop**:  
     Drag and drop the desired image in the panel. Eddy AI will automatically generate alt text in the **Alt Text** field.
   * **External URL**:  
     Enter the image’s URL. Eddy AI will automatically generate alt text in the **Alt Text** field.
4. To regenerate alt text, remove the existing text and click  **Generate**.
5. **For multiple images**, Eddy AI will generate alt text for all images. To regenerate, remove the existing alt text and click  **Generate** for each image individually.
6. Review and edit the generated alt text as needed.
7. Once done, click **Insert** to add the image to your article.

> NOTE
>
> For more information on adding images, read the article on [Inserting images in the Advanced WYSIWYG editor](https://docs.document360.com/docs/adding-images-to-articles#inserting-an-image-advanced-wysiwyg-editor).

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_ScreenGIF-Adding_Alt_Text_for_pasted_images.gif)

---

### Generating AI alt text while copy-pasting images in the Advanced WYSIWYG editor

To generate AI alt text while copy-pasting images in the Advanced WYSIWYG editor:

1. Drag and drop or paste the desired image into the Advanced WYSIWYG editor.
2. Click on the pasted image, and the floating menu will appear.
3. Select the **Alt text** () icon.
4. In the **Image alt text** field, either:

   * Enter the alt text manually.

     Alternatively, click  **Generate** to create alt text using Eddy AI.
5. Click the  icon to save the alt text.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_ScreenGIF-Adding_Alt_Text_for_pasted_images.gif)

---

## Generating AI alt text while uploading an image in Drive

To generate an alt text while uploading an image to the Drive:

1. During the image upload process, either:

   * Manually enter the alt text.

     Alternatively, click  **Generate** to create Eddy AI-generated alt text.
2. For multiple images:

   * Click  **Generate** next to each image to create alt text individually.

     Alternatively, click  **Generate for all images** to generate alt text for all uploaded images in one go.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGIF-Adding_alt_text_for_multiple_images_in_drive.gif)

### Generating AI alt text for an uploaded image in Drive

To generate alt text for an image already uploaded in the Drive:

1. Navigate to the **Drive** () in the Knowledge base portal.
2. Click the desired image, and the **File details** panel will appear.
3. In the **Alt text** section:

   * Click  **Generate** to create alt text using Eddy AI.
   * To regenerate, remove the existing alt text and click  **Generate** again.
4. Once done, click **Update** to save the changes.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_ScreenGIF-Generating_AI_alt_text_for_an_uploaded_image_in_Drive.gif)

## Try this feature

Explore this feature with an interactive demo below and see how it works in real time.

---

### FAQs

#### How many AI alt texts can I generate per month?

You can generate up to 5000 alt texts per month per project.

#### Is the AI alt text generation feature enabled by default?

Yes, this feature is enabled by default if the AI writer is enabled.

#### Can I review and edit the generated AI alt text?

Yes, you can review and edit the generated alt text before accepting it.

#### How do I generate AI alt text when uploading an image to Drive?

When uploading an image to Drive, simply click the  **Generate** button next to the alt text field to create AI-generated alt text.

#### How do I regenerate AI alt text for an image?

To regenerate the alt text, delete the existing alt text, the  **Generate** button will appear to help you regenerate using Eddy AI.

#### What happens if the Generate button is disabled?

If the  **Generate** button is disabled, it means your monthly AI credit balance has been exhausted. You can contact your admin/Document360 support.

#### What happens if I try to upload multiple images but don't have enough credits?

If your available credit balance is insufficient for all images in a single upload, the **Generate all** button will be disabled.

For example, if you upload 10 images but only have 5 credits, the  **Generate all** option will not be available. However, you can manually select up to 5 images (or as many as your credits allow) and click  **Generate** to create alt text for the selected images.

#### Can AI generate alt text for all image formats?

AI can only generate alt text for images smaller than 20 MB in JPEG, JPG, PNG, and WEBP formats.

#### What if I copy-paste an image in an article? How can I add alt text?

If the article is in Advanced WYSIWYG editor, you can generate the AI alt text for the image. Click the pasted image in the article and a floating menu will appear. Click on the **Alt Text** () icon and then **Generate** to create the alt text. Click the  icon to save.

#### Are KB customization images included in the alt text generation count in Drive?

No, only images from published articles with dependencies, as well as those from templates, snippets, and glossary, are counted.

<a id="ai-search-suite"></a>

## AI search suite

**Plans supporting the use of AI search suite**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The AI search suite enhances the user experience by integrating AI-powered tools that streamline search and content discovery. The suite includes three key features: Ask Eddy AI assistive search, Ask Eddy AI API, and an AI article summarizer, all designed to improve knowledge base navigation and content summarization.

---

## Features in the AI search suite

1. [**Ask Eddy AI assistive search**](/help/docs/ai-assistive-search-ask-eddy)

   This feature provides an intelligent search experience, allowing users to ask questions directly and receive relevant, AI-curated answers. By leveraging machine learning, it enhances the accuracy and speed of content retrieval, making knowledge base navigation more efficient.
2. [**Ask Eddy AI API**](/help/docs/ask-eddy-ai-api)

   This API gives you a flexible, customizable solution, allowing you to seamlessly integrate GenAI search directly into your product's UI. With this integration, your users can access the Ask Eddy feature without needing to navigate through product documentation, providing a more streamlined and efficient experience.
3. [**AI article summarizer**](/help/docs/ai-article-summarizer)

   The AI article summarizer is integrated into the Knowledge base site to help users quickly get the gist of lengthy documents. This tool scans articles and condenses them into shorter summaries, providing users with key takeaways without having to read through the entire content.
4. [**Text to voice functionality**](/help/docs/text-to-voice-functionality)

   The text-to-voice feature on your Knowledge base site allows users to listen to articles instead of reading them, saving time. This functionality is beneficial for multitasking, allowing users to absorb information while performing other activities.

---

## Multilingual support for Eddy AI search suite

The Eddy AI search suite seamlessly integrates with the Knowledge base site, offering support for a wider array of languages.

In addition to English (en, en-US, en-GB, en-AU), Eddy AI search suite supports 15 other languages, including French (fr), Spanish (es), German (de), Norwegian (no), Dutch (nl), Portuguese (pt), Swedish (sv), Italian (it), Korean (ko), Finnish (fi), Polish (pl), Arabic (ar), Hebrew (he), Danish (da), and Brazilian Portuguese (pt-br).

If a workspace is configured with a language not supported by Eddy AI, such as Chinese, the search suite features will not be available for that workspace.

---

## Plan availability and usage limits

1. **Ask Eddy search**: This feature is included with 2,000 credits per month for the **Business** plan and 5,000 credits per month for the **Enterprise** plan, with each search query consuming 1 credit. It is tailored to support businesses with high AI-driven search needs. To purchase additional credits, please contact support.
2. **Ask Eddy AI API**: This feature is included with 2,000 credits per month for the **Business** plan and 5,000 credits per month for the **Enterprise** plan, with each call consuming 1 credit. This enables enterprises to scale AI-powered search functionality seamlessly.
3. **AI article summarizer**: This feature is included with 1,000 credits per month for the **Business** and **Enterprise** plans, with each summarization task consuming 1 credit. It enhances content summarization efficiency for improved workflow management.

The AI search suite's flexible credit system ensures businesses can tailor their usage to their specific needs, providing scalable solutions to meet growing demands for AI-enhanced search and content management tools. For more information on pricing, click [here](https://document360.com/pricing/).

<a id="ai-assistive-search-ask-eddy"></a>

## AI assistive search (Ask Eddy AI)

**Plans supporting the use of AI assistive search**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The Ask Eddy AI feature is available on your home page and the Knowledge base site's search bar. This AI assistant provides more contextual answers to reader queries and prompts. This helps the user avoid having to search and read through multiple articles. Instead, it provides answers from your existing Knowledge base.

> NOTE
>
> * By default, Eddy AI assistive search retrieves answers from the main workspace. To access information from a different workspace or across all workspaces, switch to the desired workspace using the filter on your knowledge base site.
> * After updating content in the published article, Eddy AI assistive search will take approximately 15 minutes to fetch the updated information in the knowledge base site.
> * To know more about the languages supported by Eddy AI, [click here](/help/docs/ai-search-suite#multilingual-support-for-eddy-ai-search-suite).

The Ask Eddy AI will extract all information in your knowledge base, including the textual content, code blocks, tables, content reuse elements, and LaTeX.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Eddy_fetching_Code_block_information.png)

---

## Enable Ask Eddy AI for your Knowledge base site

1. Navigate to **Settings** () > **AI features** > **Eddy AI** in the Knowledge base portal.
2. Turn on the **AI assistive search** toggle.

   The AI assistant **Eddy AI**now starts indexing your Knowledge base content and this process takes a while. Once done, the Ask Eddy AI button will be available on your Knowledge base site search bar and the Home page.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenShot-AI_assisstive_search.png)

* The **KB site** checkbox will be the default selection which enables Eddy AI for searches on the Knowledge base site.
* The **KB widgets & extensions** checkbox enables Eddy AI for widgets and third-party tool integrations with Document360.
* The **Public API** checkbox activates Eddy AI for all API endpoints using a single API token.

---

## Accessing Ask Eddy AI

> For your information
>
> The Conversational Eddy AI enhancement is available exclusively in **KB site 2.0.** To explore KB site 2.0 without impacting your existing Knowledge base, go to **Settings** () **> Customize site**. For more details, read the article on [KB site 2.0 migration](/help/docs/kb-site-20-migration).

1. Click on the **Search bar** or press `Ctrl + K` on the Knowledge base site.
2. Start typing the keyword, and the general search results will appear.

> NOTE
>
> If Ask Eddy AI is not enabled in the Knowledge base portal, only the search bar will be available in the Knowledge base site.

3. Hit Enter and Ask Eddy AI will generate results along with the source articles.
4. Click the **Copy** () icon to copy the generated content if needed.
5. Provide feedback by clicking the **Like** () or **Dislike** () icon for the generated result.
6. Click **Source articles** to refer to the articles based on which the **Eddy AI** fetches information.

   The source URLs will be listed and numbered in the **Source articles** section. The same numbers will be used in the AI response to help you identify which parts of the response are fetched from each source article.
7. Hover over the number to find additional information, such as, if it’s an external source, you can find the title of the web page and a short description of the source article. Click on the number or the **Open in a new tab** () icon to open the source article in a new tab.
8. Click on the desired source article, to open the article in a new tab.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_ScreenGif-External_sources.gif)

   **Eddy AI** will provide answers in the language the question is asked.
9. Choose the desired workspace or all workspaces from the filter dropdown to fetch results from **Eddy AI**.

> NOTE
>
> * If you filter workspaces during an Ask Eddy AI conversation, the generated results will be reset.
> * Eddy’s response will be contextual and will be based on the last five queries.

9. After the first query and answer, click the **Continue conversation with** **Eddy AI** text field to enter your next query and press Enter or click the **Send** icon.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_ScreenGIF-Conversational_Eddy_AI.gif)

---

### Customize the Eddy AI Localization variables

1. Navigate to **Settings** () > **Localization & Workspaces**in the Knowledge base portal.

   By default, the **Localization & Workspaces** tab will appear.
2. Navigate to the **Localization variables** tab.
3. In the **Eddy AI** accordion, update the variable values according to your desired language.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_ScreenShot-AI_assisstive_search.png)

---

## Integrating Eddy AI in KB Widget with multi-lingual support

You can access Eddy AI within your knowledge base as a widget, in various languages including English (en-US, en-GB), French (fr), Spanish (es), German (de), Norwegian (no), Dutch (nl), Portuguese (pt), Swedish (sv), Italian (it), Korean (ko), Finnish (fi), Polish (pl), Arabic (ar), Hebrew (he), Danish (da), ensuring a seamless user experience.

> For more information, read the article on [Integrating Eddy AI in KB widget](/help/docs/knowledge-base-widget-getting-started).

---

## Enabling Eddy AI credits notification

You can configure notifications for Ask Eddy AI credit balance. To enable Credit usage alert toggle,

1. Navigate to **Settings** () > **Knowledge base portal**> **Notifications**.

   By default, the **Notification channels** tab will appear.
2. Go to the **Notification mapping**tab.
3. In **Eddy AI notifications**accordion, turn on the **Credit usage alert**toggle.

Once enabled, Document360 will send reminders to the configured notification channels when the credit balance drops to 20%, 10% of the total allotted balance, and when the balance expires.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/6_ScreenShot-AI_assisstive_search.png)

---

NOTE

Document360's "Ask Eddy AI" utilizes OpenAI APIs in its backend operations. Data is transmitted to OpenAI through their APIs. OpenAI adheres to a privacy policy that prohibits the use of customer-submitted data via our API for training OpenAI models or enhancing OpenAI's service offerings. Both Document360 and OpenAI comply with GDPR regulations. Additionally, Document360 is SOC 2 compliant.  
An extract from the policy states, "OpenAI will not use data submitted by customers via our API to train OpenAI models or improve OpenAI's service offerings."

> Read the complete [**OpenAI API data usage policies**](https://openai.com/policies/api-data-usage-policies)**.**  
> If you any queries regarding Document360's data policy, please read our [**Privacy policy**](https://document360.com/privacy/)**.**

---

### FAQs

#### What data or information does Ask Eddy AI collects?

Ask Eddy AI does not collect any Personal Identifiable Information (PII). We collect prompts (questions), **Eddy AI**'s response, citation articles, and feedback; This collected data is available as part of Eddy AI Search Analytics.

#### What technology does Ask Eddy AI use?

Ask Eddy AI utilizes OpenAI APIs under the hood for its functionality. We send data to OpenAI via their APIs. According to OpenAI's privacy policies, data sent via their APIs will not be used to train their GPT models.

#### Does Ask Eddy AI use any external source other than our knowledge base?

No, Ask Eddy AI does not use any other sources. It solely relies on your knowledge base content to generate responses. If there is insufficient information or context available in your knowledge base to answer a specific question, Ask Eddy AI will respond with "I do not know."

#### How do my readers use the AI-powered assistive search feature?

Your Knowledge base site users click the Ask Eddy AI button, and a prompt input popup opens. They can type in any prompt or query to get tailor-made answers.

#### How does Ask Eddy AI protect your data?

We know that privacy and security is critical for many organizations. We are committed to protecting your organization’s and user’s data and privacy. We use industry-standard security practices, reputable sub processors with SOC 2 compliance, and provide the controls needed for organizations to meet their own data protection requirements.

#### What does credit mean for Ask Eddy AI?

One credit equals one question (prompt) asked. As part of our standard offering, Ask Eddy AI can be used to ask 1000 questions per month. Please contact our support team or your customer success manager if you wish to purchase additional credits.

#### How does Ask Eddy AI work on private knowledge base?

Ask Eddy AI utilizes the access controls you have set to generate an appropriate response based on the user's access control and permissions. If a logged-in user lacks access to a specific article but asks a question where the restricted article holds the answer, Ask Eddy AI will respond with "I do not know."

#### How quickly does Eddy AI's response reflect new content?

After updating an article, it generally takes around 15 minutes for **Eddy AI**'s response to align with the changes if a question is posed regarding the updated content. Similarly, when deleting an article, **Eddy AI** typically takes about 15 minutes to stop referencing the content from the deleted article.

#### Does Ask Eddy AI search within attachments?

Currently, Ask Eddy AI does not search within attachments. This means any content within your PDF and Word document which you have attached or embedded within your knowledge base article, is not indexed by Ask Eddy AI. However, we will support this functionality in future release updates.

#### Does Eddy AI read Excel file data to provide answers if I upload a file?

No, Eddy AI does not fetch or read information from files uploaded in articles.

#### What happens if I select French as the workspace language but ask questions in English?

If you set French as your workspace's preferred language but ask questions in English, Eddy AI will respond in English.

> NOTE
>
> Eddy AI responds in the same language as the query, regardless of the workspace language.

#### How do I check my Eddy AI credit balance?

The admin/owner can view the remaining credits for using AI Assistive search feature from  **Settings** () > **AI features** > **Eddy AI** .

Document360 will send reminders to the configured notification channels when the credit balance drops to 20%, 10% of the total allotted balance, and when the balance expires.

#### How can I purchase additional credits for the Eddy AI assistive search?

You can purchase additional credits by navigating  **Settings** () > **AI features** > **Eddy AI**, and the Buy moreoption in the Document360 portal. If you are in trial version, you cannot purchase add-ons.

#### How do I configure email domain for Eddy AI credit notification?

To receive **Eddy AI** credit notifications via email, you need to configure your email domain. Go to **Settings** () > **Knowledge base portal**> **Notifications** > **Email domain**. By default, emails will be sent from [support@document360.com](mailto:support@document360.com) if the email domain is not configured.

#### What are the various notification channels for receiving Eddy AI credit notifications?

You can receive **Eddy AI** credits notifications in English from various notification channels such as webhook, Microsoft Teams, Slack, and email if you have set up the configuration. For more information of configuring notifications, read the article on [Notifications](/help/docs/notifications).

#### How do I configure the desired email address for receiving Eddy AI credit notifications?

After enabling the **Eddy AI** credits notification toggle, to receive **Eddy AI** credit notifications, configure your email address in  **Settings** () > **Knowledge base portal**> **Notifications**.

1. In the **Notification channels** tab, click on **New channel** and select SMTP.
2. Click **Next**.
3. Enter the channel name and the desired email address to receive notifications.
4. If required, you can add CC and **BCC**.

   For more information, read the article on [SMTP notification channel](/help/docs/smtp-email-notification-channel).

#### Why is Eddy AI not available in my API documentation?

**Eddy AI** is available only on the Knowledge base site and is not implemented for API documentation.

#### Can Eddy AI answer questions that require user login or involve restricted articles?

No, **Eddy AI** answers questions based on the user’s access control and permissions. If a logged-in user does not have access to a specific article, but they ask a question related to that article, **Eddy AI** will respond with *No results found.*.

#### Why is the Ask Eddy AI button greyed out?

The **Ask Eddy AI** button becomes greyed out or disabled when your Eddy AI credit limit has been reached. To continue using this feature, you will need to renew your credits.

The public-facing website where end-users can access articles and find answers to their questions.

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

Application Programming Interface - A set of rules that allows one software application to communicate with another.

<a id="ai-dynamic-related-articles-recommendation"></a>

## AI dynamic related articles recommendation

**Plans supporting AI dynamic related articles recommendation**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The dynamic related articles recommendation feature allows you to effortlessly enhance your knowledge base site by automatically linking relevant articles across all content. This ensures that readers always find additional information related to their queries, improving navigation and overall user experience. In one instance, you can apply these related articles to your entire knowledge base.

> NOTE
>
> To know more about the languages supported by Eddy AI, [click here](/help/docs/ai-search-suite#multilingual-support-for-eddy-ai-search-suite).

---

## Dynamic related articles recommendation

> For Your Information (FYI)
>
> The Dynamic related articles recommendation is available exclusively in **KB site 2.0**. To explore KB site 2.0 without impacting your existing Knowledge base, go to **Settings** () > **Customize site**. For more details, read the article on [KB site 2.0 migration](/help/docs/kb-site-20-migration).

You can dynamically add related articles to your Knowledge base site for all articles.

1. Navigate to **Settings** () > **AI features** > **Eddy AI**in the Knowledge base portal.
2. Turn on the **Dynamic related article recommendation** toggle.

   Now, **Eddy AI** will automatically add related articles to all the articles in your knowledge base site.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Dynamic_related_articles_recommendation.png)

Additionally, you can manually add more related articles by following these steps:

1. Navigate back to **Documentation** () and select the article to which you want to add related articles.
2. Click the **More** () option and select **Related articles**.
3. Click Ask Eddy AI, and **Eddy AI** will recommend the related articles.
4. Click the **Add**() icon to include the desired articles in the related articles list.
5. Turn on the **Auto relate this article to all related articles**  toggle, if needed.
6. Once you have made changes, click **Save**.

> NOTE
>
> When **Auto relate this article to all related articles** is enabled, if Article-A is added as a related article in Article-B, then Article-B will appear as a related article in Article-A. Save time by using this toggle for adding related articles.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGIF-Adding_related_articles_manually_KBsite_2_0.gif)

> NOTE
>
> The following scenarios apply if you have not yet enabled the **Dynamic related article recommendation** toggle:
>
> * If you have permission to enable the toggle, a banner will appear with the option to **Enable recommendations**. Clicking this will redirect you to the **Eddy AI** settings page, where you can turn it on.
> * If you do not have permission, you'll see an **I'm Interested** button. Clicking this will send an email to your team account owner, notifying them of your interest in enabling the feature.

### Knowledge base site view

After enabling the Dynamic related article recommendation feature, all articles recommended by this feature in the Knowledge Base will display relevant related articles, marked with an  icon next to the article name.

> NOTE
>
> **Eddy AI** recommends up to three articles. If manually curated articles are the same as Eddy's recommendations, the number of recommended articles may vary.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Screenshot-Knowledge%20base%20view%20of%20dynamically%20added%20related%20articles.png)

---

### FAQs

#### What is the Dynamic related articles recommendation feature?

The Dynamic related articles recommendation feature automatically links relevant articles across all content in your knowledge base, enhancing navigation and user experience.

#### How can I enable the Dynamic related articles recommendation feature?

To enable it, navigate to **Settings** () > **AI features** > **Eddy AI** in the Knowledge base portal and turn on the Dynamic related article recommendation toggle.

#### Why are related articles not appearing for certain articles?

The dynamic related articles recommendation feature uses an algorithm to assess article relevance. Only articles that meet a specific relevance threshold will appear as related. If no similar articles are found, recommendations cannot be generated.

#### How do I identify articles recommended by the Dynamic related articles feature?

Articles recommended by the Dynamic related articles feature are marked with a  icon next to the article name in the Knowledge base site. However, if you manually add related articles or use the Ask Eddy AI feature to add them, the  icon will not appear.

The public-facing website where end-users can access articles and find answers to their questions.

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

<a id="ai-chatbot"></a>

## AI Chatbot

**Plans supporting AI chatbot**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

> NOTE
>
> If you're on a **Legacy plan**, this feature is available only if you've purchased the AI assistive search add-on for your project.

In Document360, you can interact with the Eddy AI Chatbot to quickly get answers to your questions without having to search through Knowledge base articles. The Eddy AI Chatbot helps you find relevant information faster and more easily.

> NOTE
>
> * The Eddy AI Chatbot will be available exclusively for KB site 2.0 projects.
> * To know more about the languages supported by Eddy AI, [click here](/help/docs/ai-search-suite#multilingual-support-for-eddy-ai-search-suite).

---

## Configuring the Eddy AI Chatbot

To enable Eddy AI in the Knowledge base widget:

1. Navigate to **Settings** () > **AI features** > **Eddy AI** in the Knowledge base portal.
2. Turn on the **AI assistive search** toggle.
3. Select the **KB widgets & extensions** checkbox.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Turn_on_KbWidget_in_Settings.png)

To configure the Eddy AI Chatbot in the Knowledge base portal:

1. Navigate to **Widget**() in the Knowledge base portal.
2. Click **Add widget**.
3. Enter your desired name for the Eddy AI Chatbot in the **Widget name** field (up to 30 characters).
4. By default, the **Configure & connect**tab will be selected.

#### **Connection**

5. In the **Widget JavaScript** accordion, find the **Widget key** and its JavaScript code.
6. Click the **Regenerate** () icon to regenerate the **Widget key**.
7. In the **Connect domains** accordion, find the domains where the widget displays.
8. In the **JWT** accordion, implement an authentication configuration for the Eddy AI Chatbot using JWT, ensuring a secure environment for private and mixed projects.

> NOTE
>
> For more information, read the article on [Securing Chatbot authentication using JWT](/help/docs/securing-chatbot-authentication-using-jwt).

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot_Connection_section_in_Chatbot_AI.png)

#### **Customize the experience**

9. Select **Chatbot** as the widget type.

> NOTE
>
> Once a widget type is selected and saved, it cannot be changed.

10. In the **Style widget**accordion, customize Eddy AI chatbot’s styles and themes.

> NOTE
>
> For more information, read the article on [Styling the Eddy AI Chatbot](/help/docs/styling-the-chatbot).

11. In the **Content access** accordion, select the content level access for your readers, such as **Project**, **Workspace**, or **Category**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Customize_the_experience_in_the_Chatbot.png)

#### **Set controls**

12. In the **Widget security**accordion, enter your desired domain to ensure the widget is displayed exclusively on that specific domain.

> NOTE
>
> * Once a domain is added to the **Widget security** list, any project member who wants to install the Eddy AI Chatbot on a different domain must add that domain in the Widget security section.
> * If no domains are added to the list, the Eddy AI Chatbot can be integrated into any SaaS application or public website.
> * Please note, the **www.** is not considered part of your domain. Only add what follows **www.** in your URL.
>
>   Example: [document360.com](http://document360.com)

13. Preview the Eddy AI Chatbot on the right side of the page.
14. Once configured, click **Save**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Set_controls_in_Chatbot.png)

To display the created Eddy AI Chatbot on your Knowledge base site:

1. From the Knowledge base widget page, hover over the desired widget and click the **Copy script** () icon.
2. Go to **Settings** () > **Knowledge base site** > **Integrations**.
3. Scroll down to **Custom HTML** blade and click **Add**.

   The **Add new integration** panel will appear.
4. Enter the desired description.
5. Select the intended option in the **Insert code** field.
6. Paste the copied script and click **Add**.

Now, the Eddy AI Chatbot will appear on your Knowledge base site.

> NOTE
>
> To integrate the Eddy AI Chatbot into your custom site, paste the copied script into the appropriate HTML file.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_ScreenGIF-Pasting_the_code_in_HTML_Integration.gif)

---

## Accessing the Eddy AI Chatbot in the site

To access and interact with the Eddy AI Chatbot on your site:

1. Click the Eddy AI Chatbot icon to open the chatbot.
2. Type your question and click the **Send**() icon or press **Enter**.

   Eddy AI will retrieve information from your Knowledge base to answer your query.
3. Hover over any generated answer to **Copy** (), **Like** (), or **Dislike** () the response.
4. Click the **Clear** () icon to clear the conversation.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_ScreenGIF-Exploring_Chatbot_AI.gif)

---

### FAQs

#### How can I view the feedback (likes and dislikes) received from the Eddy AI Chatbot?

To view the Eddy AI Chatbot feedback,

1. Navigate to the **Analytics**() > **Eddy AI** in the Knowledge base portal.
2. Filter the desired Eddy AI Chatbot using the **Application** filter at the top of the page.

   In the **Feedback** section, you will see the number of likes and dislikes received.

#### What is the difference between a Widget and an Eddy AI Chatbot?

A **Widget** allows manual navigation through articles or search functions, while an **Eddy AI Chatbot** engages users in a conversation, offering immediate, direct answers without the need to manually navigate through content.

<a id="securing-chatbot-authentication-using-jwt"></a>

## Securing Chatbot authentication using JWT

**Plans supporting AI chatbot**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

JSON Web Token (JWT) is an open standard used to securely transmit information between parties as a JSON object. It allows for authentication and information exchange, ensuring that the data sent is verified and trusted. By implementing JWT for the Eddy AI Chatbot, you can create a secure environment for your private and mixed projects, protecting sensitive information from unauthorized access.

> NOTE
>
> To know more about the languages supported by Eddy AI, [click here](/help/docs/ai-search-suite#multilingual-support-for-eddy-ai-search-suite).

You can implement an authentication configuration for the Eddy AI Chatbot using JWT, ensuring a secure environment for Private and Mixed projects.

1. Navigate to Knowledge base widget () in the Knowledge base portal.
2. Click **Add widget** to create a new widget.

   Alternatively, hover over the desired widget and click the **Edit** (✎) icon to modify an existing widget.
3. Select the widget type as **Chatbot** to configure JWT for Eddy AI Chatbot.
4. In the **Configure & connect** tab, go to the **JWT** accordion and **enable** the JWT toggle.

1. **Client ID:** The client ID will be your project’s ID.
2. **Widget ID:** Since multiple widgets may exist, a widget ID is provided for their unique purposes.
3. **Token endpoint:** This is the HTTP endpoint used to obtain an access token using an authorization code.
4. **Client secret:** Click **Regenerate** to generate the client secret. Ensure you save this for future use, as it will apply to all widgets created moving forward.

> NOTE
>
> The **Client Secret** is required for all future JWT-enabled widgets. It will not be stored within Document360, so keep it securely.

   e. **Authorize URL:** Paste the authorized URL from your knowledge base widget webpage.

5. Click **Save**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Securing_Knowledge_base_widget_authentication_using_JWT(1).png)

Embed the authorized URL within your code and paste it into the **Script section** of your webpage to implement a secure, authenticated Chatbot. This setup will prevent unauthorized third-party access. By following these steps, you can successfully implement JWT authentication for the Eddy AI Chatbot, ensuring a secure environment for your projects. After configuring your chatbot, test the setup thoroughly to ensure that everything functions correctly.

> NOTE
>
> For more information on implementing the auth endpoint, read the article on [Managing the Knowledge base widget](/help/docs/managing-the-knowledge-base-widget).

---

### FAQs

#### What should I check if I encounter issues during authentication?

If you experience authentication issues, ensure the following:

* The client secret and token endpoint are correctly configured.
* The user is authenticated before making a request to the endpoint.

#### What are common pitfalls to avoid when implementing JWT?

Here are a couple of common pitfalls to watch out for:

* **Failing to save the client secret** after regeneration can lead to authentication failures.
* **Misconfiguring the token endpoint** can prevent successful token retrieval.

#### What should I do if I lose my client secret?

You will need to regenerate a new client secret and update your configuration accordingly.

#### How can I verify that JWT authentication is working?

Test the authentication flow by attempting to access the Eddy AI Chatbot and checking for the correct access token response.

<a id="styling-the-chatbot"></a>

## Styling the Chatbot

**Plans supporting AI chatbot**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Styling the appearance and behavior of your Eddy AI chatbot can significantly enhance the user experience. Customizing your Eddy AI Chatbot’s colors and icons to match your brand can create a seamless experience, making it easier for users to engage with the Eddy AI chatbot and get timely information.

> NOTE
>
> To know more about the languages supported by Eddy AI, [click here](/help/docs/ai-search-suite#multilingual-support-for-eddy-ai-search-suite).

---

## Styling the Eddy AI Chatbot

To style the Eddy AI chatbot, follow the steps below:

1. Navigate to Knowledge base widget () in the Knowledge base portal.
2. Hover over the desired widget and click the **Edit** (✎) icon.
3. In the **Configure & connect** tab, expand the **Style widget** accordion.

#### Widget color

4. Click **Change icon** to replace the icon with an image or select one from the available icons.

   a. Choose any icon from the **Icon set** tab.  
   **(or)**  
   b. Click the **Insert image** tab.

   1. To use an image URL, paste or type the URL and click **Insert**.
   2. Alternatively, to upload an image from Drive, click **Upload an image** and select the desired file.

> NOTE
>
> Click **Default** to revert to the default icon and color.

5. Click **Change color** to update the Eddy AI Chatbot’s background color.

   The color palette will appear.
6. Select a color using the color picker or enter a hex, RGB, or HSL code for specific color values.

#### Widget position

7. Select **Left** or **Right** to position the widget icon on either side of your site.
8. Enter the desired pixel values in the **Side spacing** and **Bottom spacing** fields to adjust the Eddy AI Chatbot's placement.

#### Hide widget

9. Turn on the **Hide widget** toggle if you want to hide the widget on your site.
10. After making your changes, click **Save**.

> NOTE
>
> The **autosave** feature is enabled when navigating between the Knowledge base widget tabs, ensuring your changes are automatically saved.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGIF-Styling_the_Knowledge_base_widget.gif)

<a id="eddy-ai-federated-search"></a>

## Adding external sources for AI Assistive search

**Plans supporting addition of external sources in AI assistive search**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

> NOTE
>
> For **Legacy** plan users, this feature is available only if you have purchased the AI assistive search add-on for your project.

The Adding external sources for AI assistive search feature allows you to configure it to retrieve information from multiple external sources, simplifying the process and delivering more comprehensive answers to users.

Imagine a support agent for a software company using Document360 to resolve customer issues. Previously, they could only search for solutions within their internal Knowledge base articles. With this feature, the agent can now pull information from external resources like the company's public documentation site, blogs, and product release notes. This helps the agent deliver accurate and comprehensive answers quickly without leaving the platform, improving both response time and customer satisfaction.

> NOTE
>
> To know more about the languages supported by Eddy AI, [click here](/help/docs/ai-search-suite#multilingual-support-for-eddy-ai-search-suite).

---

## Adding external sources

To access and manage external sources:

1. Navigate to **Settings** () >**AI features** >**Manage source****s** in the Knowledge base portal.

   The **Manage source** page will display a list of already configured external sources (if any).
2. Click **Add new** to add a new external source.

   The **Add source** panel will appear.
3. Choose the desired source type, either **Webpage** or **Sitemap**.

> NOTE
>
> You can add up to 50 **Webpage****s** and 1 **Sitemap**.

4. Enter the desired source name.
5. Enter a valid URL.

> NOTE
>
> The webpages must be in HTML5 format and should include `<article>` or `<main>` tags.

6. Once done, click **Add source**.

![Adding new external sources in AI Assistive search in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_ScreenGIF-Adding_External_sources.gif)

---

## Manage source overview page

The **Manage source** page will list all indexed external sources.

![Manage sources for AI search, including content access and external source options.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Manage_source_over_view_page.png)

Below is a breakdown of the available options:

1. **Content access:** Restrict Eddy AI’s access to specific workspace and language. Two options are available: **All** and **Allow** selected.
2. **Filter:** Filter sources based on type such as **All, Sitemap, Webpage, or Failed Sources**. Failed sources will display all sources that encountered errors.
3. **Sync:** By default, sources are synced every 24 hours, and to sync manually, you can click **Sync** up a source up to four times per day.
4. **Add new:** Click **Add new** to add a new source for indexing.
5. **Search:** Use the search bar to locate a source by its name.
6. **Type:** Displays the type of the source, either **Webpage** or **Sitemap**.
7. **Last sync:** Shows the last sync date. Hover to view the exact time.
8. **Status:** Toggle to enable or disable a source. If disabled, Eddy AI will stop fetching information from that source.
9. **Error:** To denote an external source where the URL has encountered some error.
10. **Delete:** Click the **Delete** () icon to remove a source.
11. **Edit:** Click **Edit** () to modify the source name or URL.

### Enabling Eddy AI for specific workspaces, languages, and categories

This feature allows you to configure Eddy AI to selectively enable or restrict support for specific workspaces, languages, and categories in your Knowledge base. On the **Manage sources for AI assistive search** overview page, you can manage the content access and restrict AI access to specific workspaces, languages, and categories for more focused assistance.

1. Click the **All** dropdown and you have two selections,

   * **All** - lists all the workspaces in your knowledge base.
   * **Allow selected** - allows you to select the workspace, languages, and categories.

   If you select **Allow selected** from the dropdown, a **Manage workspace & category popup** appears.
2. Select the workspace, languages, and categories you want to allow the assistive search to fetch data from.

   A Manage button appears with the Allow selected dropdown selection.
3. Click **Manage** to select and manage the sources and click **Save**. The Save button is enabled only when changes are made.

   Once any modifications are made, you will get a confirmation popup saying, ‘*AI search sources updated*.’
4. Click **Cancel** or hit Esc to close the popup.

![Manage workspaces and categories with language options of the external sources in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Enabling_Eddy_AI_for_specific_workspaces_languages_and_categories.png)

> NOTE
>
> If you switch from **Allow selected** to **All** dropdown selection, and then again switch to **Allow selected**, the selections made will be retained.

The **Enabling Eddy AI for specific workspaces, categories, and languages** feature is applicable across all areas where AI Assistive Search is enabled.

---

### Handling errors in external sources

If errors such as unsupported HTML formats, unsupported languages, or HTTPS issues occur on a webpage, Eddy AI will stop fetching information from that page until the error is resolved. However, if errors occur on one or more web pages within a sitemap, Eddy AI will continue fetching data from the remaining valid URLs in the sitemap.

1. Click the **Error** () icon next to the status toggle.

   The **Edit** panel will display the URLs and their errors.
2. Hover over a URL and click the **Open site** () icon to view the external source.
3. Click **Remove** to delete a specific URL from the list in the Sitemap.
4. Click **Remove all** to delete all URLs with errors.

> NOTE
>
> * If the webpage source link has bot detection or similar detection mechanisms enabled, Eddy AI search will be unable to crawl the content. As a result, the source will not be added, and a forbidden error will occur.
> * Eddy AI supports only Server-Side Rendered (SSR) webpages. Client-side rendered webpages may not be indexed properly, leading to empty search results. To ensure accurate embedding and search functionality, please use server-rendered content.

![Handling errors of the external sources in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_ScreenGIF-Handling_GIF_in_External_sources.gif)

---

## Knowledge base site view

When Eddy AI fetches results from external sources:

1. The source URLs will be listed and numbered in the **Source articles** section. The same numbers will be used in the AI response to help you identify which parts of the response are fetched from each source article.
2. Hover over the number to find additional information, such as, if it’s an external source, you can find the title of the web page and a short description of the source article. Click on the number or the **Open in a new tab** () icon to open the source article in a new tab.
3. Click on the desired source article, to open the article in a new tab.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_ScreenGif-External_sources.gif)

---

## Troubleshooting

This section provides step-by-step guidance to address common issues that you may encounter when adding external sources to your Eddy AI Assistive search. To configuration errors, each solution is tailored to help you quickly identify and resolve potential roadblocks.

### Unsupported format while adding sitemap

**Error:** Unsupported format

The error message **Unsupported format** occurs when attempting to add a sitemap to the **Manage sources** section if the sitemap contains nested sitemaps with the `<sitemapindex>` tag, exceeds the 1 MB file size limit, or is in an unsupported format.

**Steps to resolve:** To resolve this error, follow the steps below:

* Use only the direct sitemap URL without the `<sitemapindex>` tag, as nested sitemaps are not supported.
* Ensure the sitemap file size is less than 1 MB.
* Verify that the sitemap is in a supported format, such as XML.

### Forbidden error while adding webpage

**Error:** Forbidden

The error message **Forbidden** will appear when attempting to add a web page to the **Manage sources** section. This error arises if the web page source has bot detection or other security mechanisms enabled, preventing Eddy AI search from crawling the content.

**Steps to resolve:** To resolve this error, follow the steps below:

* Check if the source link has bot detection mechanisms enabled. If so, you may need to contact the website administrator to allow crawler access.
* Use a different source that does not restrict crawling.

### Only HTML5 documents with `<article>` or `<main>` tags are supported while adding webpage

**Error:** Only HTML5 documents with `<article>` or `<main>` tags

The error **Only HTML5 documents with** `<article>` **or** `<main>` **tags** will occur when adding a web page that does not meet the HTML5 format or lacks the required `<article>` or `<main>` tags.

**Steps to resolve this issue:** To resolve this, follow the steps below:

* **Verify the HTML5 format:** Check the doctype declaration of the web page. HTML5 pages should have `<!DOCTYPE html>` as the declaration.
* **Check for required tags:** View the page source (`Ctrl + U` / `Cmd + U`) and ensure it contains `<article>` or `<main>` tags.
* **Update the web page:** If the page is not in HTML5 format or lacks the required tags, update the page to meet these requirements.

By addressing these common errors and their solutions, you can ensure a smoother experience when adding external sources to your Eddy AI Assistive search.

---

### FAQs

#### **How do I perform a manual sync for external sources?**

To perform manual sync for external sources, follow steps below:

1. Navigate to **Settings** **(****)** > **AI features**>**Manage source****s** in the Knowledge base portal.
2. Click **Sync** at the top of the **Manage source** page.
3. You can manually sync external sources up to four times per day.

> NOTE
>
> The system automatically syncs every 24 hours.

#### **How do I delete an external source?**

To delete any external sources from the Manage source page:

1. Navigate to **Settings** **(****)>** **AI features** **>** **Manage source****s** in the Knowledge base portal.
2. Hover over the desired source and click the **Delete** () icon.
3. To delete multiple sources at once, select the checkboxes for the desired sources and click **Delete** at the top.

#### **How do I view analytics for external sources?**

To view the search metrics analytics for external sources:

1. Navigate to **Analytics**() > **Eddy AI** in the Knowledge base portal.
2. In the **Most referenced articles** section, external sources will be listed alongside Knowledge base articles.

#### **Can I disable external sources temporarily without deleting them?**

Yes, you can turn off the **Status** toggle next to any external source to temporarily disable it. Eddy AI will stop fetching information from that source until it’s re-enabled.

<a id="ai-article-summarizer"></a>

## AI article summarizer

**Plans supporting the use of AI article summarizer**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The **Article summarizer** is one of the many Artificial Intelligence (AI) powered features in Document360. This feature comes in handy when readers want to save time by not reading lengthy articles. Instead, they can read a piece of condensed article information as a **summary**.

Document360 uses natural language processing (NLP) to locate the vital information in the article content while maintaining the original context to generate an optimal summary.

> NOTE
>
> To know more about the languages supported by Eddy AI, [click here](/help/docs/ai-search-suite#multilingual-support-for-eddy-ai-search-suite).

### Prerequisites

* **Preprocessed article content** should be more than **250 words.**
* The AI feature is supported in your subscription plan.

> NOTE
>
> The article summary is available (depending on your subscription plan) in new/existing articles published on or after May 27, 2023.

---

## Enabling article summarizer

To enable the article summarizer, follow the steps below:

1. Navigate to **Settings** ()> **AI Features** > **Eddy AI** in the Knowledge base portal.
2. Turn on the **Article summarizer** toggle.

When enabled, the **Summary** is available at the article top in the Knowledge base site. Click on 'Summary' to expand and read it.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Enabling_Summarizer.png)

---

---

#### What is 'Preprocess' or 'Preprocessed words' in Document360 articles?

**Preprocess** refers to filtering specific article/category page elements. The below elements are not considered for meta description generation's word count:

* HTML tags
* Images
* URL/links
* Code blocks

  > If you have an article word count shown as 220 words at the bottom of the Document360 editor, this includes the HTML tags, links, code blocks, and more. When preprocessing content is considered, the word count would be less. Ensure the preprocessed article content is more than 250 words for the AI article summarizer to work.

---

#### Data privacy

We understand that our customer's Knowledge base data is sensitive. As this feature uses a form of OpenAI integration, we adhere to the privacy policies on OpenAI. An extract from the policy states, "OpenAI will not use data submitted by customers via our API to train OpenAI models or improve OpenAI's service offerings."

> Read the complete draft of [**OpenAI API data usage policies**](https://openai.com/policies/api-data-usage-policies)

> If you any queries regarding Document360's data policy, please read our [**Privacy policy**](https://document360.com/privacy/)

Application Programming Interface - A set of rules that allows one software application to communicate with another.

<a id="ask-eddy-ai-api"></a>

## Ask Eddy AI API

**Plans supporting the use of Ask Eddy AI API**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The Eddy AI Public API is an invaluable feature designed to enhance the functionality and flexibility of our Eddy AI search feature. The Eddy AI Public API is particularly useful for businesses looking to deeply integrate AI-driven search capabilities directly into their own platforms or services. By embedding Eddy AI into your product, you provide users with the ability to access powerful search functionality without needing to visit your documentation site.

This API offers greater flexibility in customizing the user interface, allowing you to tailor aspects like color, naming, and placement to align with your brand and user experience. With this seamless integration, Eddy AI becomes a natural extension of your product, enhancing user interactions and improving search efficiency. By exposing the API endpoints, you can incorporate them into your platforms, effortlessly extract answers from Eddy AI and build a customized search experience.

> NOTE
>
> To know more about the languages supported by Eddy AI, [click here](/help/docs/ai-search-suite#multilingual-support-for-eddy-ai-search-suite).

---

## Using the Public API

1. Navigate to the Settings () > **AI Features** > **Eddy AI** in the Knowledge base portal.
2. In **AI assistive search**, select the **Public API** checkbox.

![1_Screenshot-ENabling_Ask_Eddy_API](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-ENabling_Ask_Eddy_API.png)

> NOTE
>
> 1. Ensure at least one of the checkboxes is selected. Otherwise, the AI assistive search toggle will be automatically disabled.
> 2. If the Public API is not enabled, you'll receive a ‘500 response code error’ or a ‘400 API access disabled error’ while using Ask Eddy AI API.
> 3. Each API call will reduce your total credit count by one.

3. Create authorization API token.

> NOTE
>
> 1. In the Knowledge Base portal, navigate to Settings () > **Knowledge Base Portal** > **API Tokens**.
> 2. Click **Create API Token**, enter the token name, and specify the POST method.
> 3. Click **Create** and **copy** the generated API token.

4. You can find the API structure at the [API hub](https://apihub.document360.io/index.html).

---

## Try the Eddy AI Public API in our API docs

1. Navigate to the Document360 [API documentation](https://apidocs.document360.com/apidocs/perform-ai-assistive-search-ask-eddy-within-project-version).
2. On the right side of the page, click the **Try it** section.
3. In the **Token** field, field, enter the API token generated from your Document360 project.
4. Enter the desired values in the **Body** section. The default request box will appear as follows:

   1. **Prompt**: Enter the question or query.
   2. **Version ID**: Obtain the current version ID.
   3. **Language Code**: Specify the desired language code for the input.
5. Click **Try it & see response** and the response will be generated.

![5_Screenshot-Ask_Eddy_in_API_Documentation](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_Screenshot-Ask_Eddy_in_API_Documentation.png)

---

## Try the Eddy AI Public API in Swagger

1. Navigate to the Swagger [API hub](https://apihub.document360.io/index.html). Under project versions, you can find the Ask Eddy AI API.
2. In the top right of the Swagger API hub and click **Authorize**.
3. The **Available authorizations** panel will appear, prompting you to enter the API token.
4. Paste the API token into the **Available Authorizations** window and click **Authorize**.
5. Once authorized, navigate to **Project versions** > `/v2/ProjectVersions/ask-Eddy AI` and click **Try it out**.
6. The default request box will appear as follows:

* **Prompt**: Enter the question or query.
* **Version ID**: Obtain the current version ID from the `/v2/ProjectVersions` endpoint.

  ![6_Screenshot-Updating_Getting_Project_version](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/6_Screenshot-Updating_Getting_Project_version.png)
* **Language Code**: Specify the desired language code.

7. Click **Execute** to receive a successful response containing all required information.

> NOTE
>
> If you receive a service unavailable message, ensure the Public API is enabled in the settings.

![4_ScreenGIF-Using_Eddy_API_Token_in_Swagger](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_ScreenGIF-Using_Eddy_API_Token_in_Swagger.gif)

---

### FAQ

#### **Why is there a discrepancy in the source articles between the Ask Eddy public API and Eddy AI search on the user site?**

The discrepancy in source articles may occur if you're retrieving details using the `articleID` for an article that is of type "Pagecategory." In such cases, fields like `article_id`, `article_title`, and `article_slug` will return null in the API response.

For "Pagecategory" articles, the details should be fetched using the `categoryID` instead of the `articleID`. Here's an example of what the API response would look like for a "Pagecategory" article:

```
{
  "category_id": "_categoryid",
  "category_title": "Title",
  "category_slug": "slug",
  "version_name": "v1",
  "version_slug": "v1",
  "article_id": null,
  "article_title": null,
  "article_slug": null,
  "version_display_name": null
}
```

JSON

Copy

To resolve this issue, ensure that you're using `categoryID` to retrieve information for "Pagecategory" articles when using the Eddy API.

Application Programming Interface - A set of rules that allows one software application to communicate with another.

<a id="text-to-voice-functionality"></a>

## Enhancing accessibility with our read out loud feature

**Plans supporting read out loud feature on the Knowledge base site**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The read out loud feature on your Knowledge base site allows users to listen to articles instead of reading them, saving time. This functionality is beneficial for multitasking, allowing users to absorb information while performing other activities. This feature is particularly useful for users who want to listen to content while performing other activities or for those who prefer auditory learning.

Available exclusively on the Knowledge Base site 2.0, this feature enhances engagement by offering a flexible alternative to reading.

> NOTE
>
> For customers on the old pricing plan, the read out loud functionality is available under Enterprise plan with the AI assistive search add-on.

## Using the read out loud feature

Here are some of the key highlights of the read out loud feature,

* The read out loud feature begins reading from the article heading and continues with the body content.
* It does not cover the article summary.
* The feature reads the alt text of images and videos. If the image or video does not contain alt text, the audio just indicates their presence in the respective language.
* The **Listen** button is located in the article header below the article heading. Once playback begins, the button label updates to **Listening**, and the Player window opens.

> **NOTE**  
> To know more about the languages supported by Eddy AI, [click here](/help/docs/ai-search-suite#multilingual-support-for-eddy-ai-search-suite).

#### Player option

The player controls are located at the bottom right of the screen. Here’s how to use them:

* Play () icon - to start listening to the content.
* Pause () icon - to stop audio play.
* Forward () icon - to skip ahead by ten seconds.
* Backward () icon - to rewind by ten seconds.
* Close (**x**) icon - to close the player window.

  ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Text_to_voice_kb_site.png "image(169).png")

#### Enable or disable player option

You can enable or disable the player option at the project level.

1. Navigate to Settings () > **Knowledge base site** > **Article settings**.
2. Under the **Accessibility** section, turn on the **Enable** **read out loud** toggle.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Read_out_loud_settings.png "image(169).png")

> NOTE
>
> The **Enable read out loud** feature will be disabled by default for customers on the trial plan.

---

## FAQs

**What all does the feature read from the article content? Is there any content it doesn’t cover?**

In addition to the textual content, the feature reads out the contents from the following content blocks of the article,  
Glossary, Snippets, Variables, Headings (H2, H3, H4), Numbered lists, Checklists, Bullet lists, Callouts, Private notes, Accordions, FAQ, Link text, emojis.

The Enable read out loud feature only indicates the presence of the following without actually reading its contents - Tables, Inline code, code blocks, images, videos, Latex, and files attached to the article using insert menu.

**Can I choose to read an article from in between?**

Yes, you can navigate the audio player using the seek option.

<a id="ai-premium-suite"></a>

## AI premium suite

**Plans supporting the use of AI premium suite**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The **AI premium suite** elevates the user experience by automating key business processes and improving workflow efficiency through advanced AI-powered tools.

---

## Features in the AI premium suite

1. [**AI-automated business glossary generation**](/help/docs/ai-glossary-generator)

This feature helps companies streamline the creation and management of industry-specific glossaries. This feature allows businesses to maintain consistent terminology across teams, enhance communication, and ensure accuracy in documentation.

> **NOTE**
>
> The Eddy AI premium suite is available in English (en) only.

<a id="ai-glossary-generator"></a>

## AI glossary generator

**Plans supporting the use of AI premium suite**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Different departments within an organization may use similar business terms, but the underlying definitions and assumptions may differ. This knowledge is only known to those within each department. Therefore, defining business terms is crucial for a shared understanding, consistent data collection practices, and the right business logics applied to compute reliable business metrics.

Document360's AI Glossary generator helps organizations communicate and collaborate by clearing ambiguity in terminology. It helps you to create a complete collection of business terms used in an organization, providing clarity and a shared understanding of ambiguous terms. It aids in data collection, team collaboration, communication, and database design.

---

## Enabling the AI Glossary generator

![1_Screenshot-Enabling_Automated_business_glossary](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Enabling_Automated_business_glossary.png)

1. Navigate to **Settings () > AI Features > Eddy AI** in the Knowledge base portal.
2. Scroll down to find the **AI Glossary generator** option.
3. Toggle the switch to enable this feature.

---

## Accessing AI Glossary generator

You can access the **AI Glossary generator** using the following steps:

1. Navigate to **Documentation** ()> **Content tools** > **Content reuse** and select **Glossary.**
2. Click **Take action** on the Eddy AI banner in the center of the page.

   By default, the **Open suggestion** section appears as the default view under the **Eddy AI glossary suggestions.**

> NOTE
>
> The AI Glossary Generator will show suggestions only if the articles are published. Otherwise it shows 0 suggestions.

1. On the left navigation bar:

   * You'll find a list of Eddy AI recommended glossary terms.
   * Use the **Search bar**, if you have multiple terms to search.
   * Use the **Sort** option to organize the terms.
2. At the top center, you can view the number of times that each term is repeated.

> For example, Backup is used 1 time(s) in 1 article(s).

6. In the **Definition** text box, Eddy AI will suggest the relevant definition of the term, and you can edit it using the formatting tools.

> NOTE
>
> Glossary definition can be up to 500 characters.

7. Under the **Add to** drop down menu, **English** will be selected as default.
8. Enable the **Update in articles (n)** check box to update the glossary in the articles.

> NOTE
>
> You can create a glossary without implementing it in the article by unchecking the **Update in articles** check box.

9. Click **Show Articles** to view the list of articles where the glossary terms will be used.

> NOTE
>
> Only articles that you have access are displayed here.

10. Once the changes are done, click **+ Add to glossary**.
11. After adding the term to the glossary, it will be moved to the glossary list.
12. If you need to ignore it, click **Ignore term**, and it will be added to the **Ignored suggestions** section.
13. Anytime, you can go to **Ignored suggestions** and click **Move to open list**.
14. Click **Continue later** to close the blade.

![2_ScreenGIF-Accessing_Automated_Business_Glossary](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGIF-Accessing_Automated_Business_Glossary.gif)

You can perform the AI Glossary generator Scan every 7 days.

![3_Screenshot-Scan_Again_of_that_specific_eddy_box](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Scan_Again_of_that_specific_eddy_box.png)

---

### Using AI Glossary generator in the advanced WYSIWYG editor

![4_ScreenGIF-Automated_Business_Glossary_in_the_Editor](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_ScreenGIF-Automated_Business_Glossary_in_the_Editor.gif)

1. Navigate to the Advanced WYSIWYG editor and click **Insert**.
2. Select **Glossary**, and Eddy AI will provide glossary suggestions based on that specific article.

> NOTE
>
> In the Editor, **AI Glossary generator** scan will occur every time you open it. At one instance, it can scan up to the first 50 terms

3. Click **Take action** to open the **Eddy AI glossary suggestions** window, with the Open suggestions section as the default view.

### Shortcuts for AI Glossary generator

You can use the following shortcuts in the **Edit glossary suggestions** window.

* Use the ARROW keys to navigate suggestions.
* Press ENTER to add the current glossary term.
* Press BACKSPACE to ignore the current glossary term.

---

## FAQs

**Does the AI Glossary generator recognize singular and plural business terms as one?**

No, the Document360's AI Glossary generator considers two identical terms, one being singular and the other being plural, as two individual and specific terms.  
For example, the term **Team Accounts** and **Team Account** are evaluated as two distinguished terms.

**Does the AI Glossary generator recognize synonymous terms as one term?**

The synonymous terms will be considered as two individual and separate terms.  
For example, the words Routine and Daily are synonymous with each other. However, they are considered as two different terms or words.

**How often can you perform a rescan and why?**

The system recommends an interval of 7 days between each scan which will be notified in the user interface. Some quantifiable content in the documentation is necessary to scan the content and provide new suggestions.

**Is the rescan manual or automated?**

The Rescan is a manual process and not an automated action.

**What happens post a rescan?**

After the rescan, new suggestions are updated in the **open suggestions** list and the users will be notified with an email notification regarding the same.

A powerful Document360 editor with rich text editing and Markdown support, offering a visual, flexible experience compared to the Markdown and basic WYSIWYG editors.

<a id="how-to-write-genai-friendly-content"></a>

## How to write GenAI friendly content

To write AI-friendly content for your articles, it's important to structure your information in a way that improves clarity, readability, and searchability. Here are some best practices to follow:

### 1. **Use clear and concise headings**

* **Headings (H1, H2, H3)**: Organize content using clear and descriptive headings. This helps AI understand the hierarchy and structure of your article.
* **Keyword-rich headings**: Ensure your headings reflect the content of the section. For example, instead of "Introduction," use "Introduction to Cloud Storage Solutions."

### 2. **Write short and focused paragraphs**

* **Keep sentences short**: Aim for sentences of 15-20 words. Avoid complex sentences as they can confuse AI processing.
* **One idea per paragraph**: Ensure each paragraph covers one idea to make it easy for AI to extract key information.

### 3. **Include tables for structured data**

* **Well-labeled tables**: Use tables to present structured data, making it easier for AI to scan and interpret. Clearly label rows and columns with descriptive headers.
* **Consistent formatting**: Ensure the table is formatted consistently for better AI recognition (e.g., avoid merged cells or irregular formatting).

### 4. **Incorporate code snippets carefully**

* **Use clean and well-commented code**: When including code snippets, use standard formatting and comment on key sections. AI can use comments to understand the context.
* **Use appropriate syntax highlighting**: This helps AI differentiate code from regular text.

### 5. **Use bullet points and numbered lists**

* **Break up information**: Bullet points and lists help organize content and make it easier for AI to break down and extract key points.
* **Limit list length**: Keep lists concise, ideally under 5-7 points, to avoid overwhelming the AI and readers.

### 6. **Include descriptive alt text for images**

**Alt text and captions**: Always include descriptive alt text and captions for images. This allows AI to understand and process the context of the image.

### 7. **Provide clear, contextual links**

* **Internal links**: Link to relevant internal articles using clear anchor text. Avoid generic phrases like “click here.”
* **Anchor text**: Use descriptive anchor text that informs AI of the linked content, such as “Read more about cloud storage security best practices.”

### 8. **Ensure SEO best practices**

* **Keyword optimization**: Use keywords naturally within headings, subheadings, and content. Avoid keyword stuffing.
* **Meta descriptions**: Write clear, relevant meta descriptions with keywords to help AI rank the content effectively.

### 9. Use business glossary terms consistently

* **Consistent terminology:** Make sure to use terms from your business glossary consistently throughout your articles. This helps AI identify and relate key terms across your content, improving searchability and comprehension.
* **Define key terms:** If a term might be unfamiliar to readers, include a brief definition or link to your business glossary. This ensures both AI and users understand the context of specialized terms.
* **Standardize abbreviations:** Always use standardized abbreviations or acronyms from your business glossary. This ensures AI correctly identifies and categorizes key terms.

### 10. **Write for humans first**

* **Conversational tone**: AI tends to perform better with content that is written in a human-friendly tone, as it improves engagement and contextual understanding.
* **Natural language**: Use natural, everyday language. Avoid jargon or overly complex terms unless absolutely necessary, and provide definitions for technical terms.

### 11. **Monitor AI-generated content**

**Review and revise**: If you're using AI tools like AI writers or content generators, always review the output to ensure it meets your quality standards and reads naturally.

---

#### Recommendations for optimizing your experience as a contributor with Eddy AI

Writing documentation that is easily understood by AI (Eddy AI) involves incorporating clear language, structured formatting, and adherence to specific guidelines.

1. **Use clear and focused language**

   Express ideas in a straightforward manner, avoiding unnecessary complexity.

   Break down complex concepts into simpler, digestible parts.

   Define technical terms or provide links to detailed explanations.
2. **Structured formatting**

   Use clear headings and subheadings to organize information.

   Employ bullet points and numbered lists to present step-by-step instructions.

   Highlight key points using bold or italics for better parsing by bots.
3. **Consistent terminology**

   Maintain consistency in the use of terminology to facilitate understanding.

   Use the Glossary feature in Document360 to achieve this.

   Avoid ambiguity by using specific and standardized terms.
4. **Avoid jargon overload**

   Minimize the use of industry-specific jargon unless essential.

   If technical terms are necessary, provide brief explanations or context.
5. **Elaborative text content**

   Elaborate the content and clearly specify the content's intent.

   If you use multimedia content, ensure that you provide a text explanation of what the media is trying to convey.

   Break down information into shorter paragraphs for better readability.

   Provide explicit answers to questions in the form of FAQs to minimize inaccurate answers by "Eddy AI." AI bots tend to hallucinate when the content is not elaborate or explicitly mentioned.
6. **Provide context and example**

   Offer real-world examples to illustrate technical concepts.

   Provide context to help the reader understand the purpose and application of the information.
7. **Use descriptive headings**

   Craft descriptive headings that accurately represent the content.

   Headings should act as a guide, summarizing the content beneath.

   Avoid repetitive heading text in the same article.
8. **Test with "Eddy AI"**

   Utilize "Eddy AI" to analyze your content for clarity and coherence.

   Make adjustments based on feedback from these tools.

By implementing these recommendations, you can create and manage documentation that is not only comprehensible to humans but also easily processed and understood by AI and NLP bots like "Eddy AI".

<a id="prompt-engineering-tips"></a>

## Prompt engineering tips

In Document360, Eddy AI provides various AI-driven functionalities that help streamline content creation and enhance the overall knowledge base experience. Leveraging prompt engineering with Eddy AI can improve accuracy, efficiency, and relevance in generating content tailored to your needs. This guide will help you make the most of Eddy AI’s capabilities when interacting with your knowledge base.

---

## Best practices for prompt engineering with Eddy AI

**1. Be clear and specific in your prompts**

When working with Eddy AI, the more precise your instructions, the better. For example, instead of asking for a “brief summary,” be specific about what you want, such as, “Generate a 100-word summary about the benefits of Document360’s knowledge base.”

If your content involves complex technical details, break it into smaller, more manageable requests. This helps Eddy AI deliver focused, relevant outputs.

**2. Ask for step-by-step instructions**

Eddy AI can be very effective in generating procedural content when you clearly specify the task. Instead of just saying, "Explain how to publish an article," a more refined prompt would be, "List the steps to publish an article in Document360, including where to click and how to configure settings."

**3. Structure your prompts for comparisons**

Structure your prompt accordingly if you need content that compares features or options. For example, “Compare the key differences between Document360’s private and public knowledge base setups” will guide Eddy AI to focus on generating a detailed comparison.

**4. Focus on article summaries**

When summarizing articles, especially longer ones, ask Eddy AI to create summaries based on specific sections or categories. For instance, “Summarize the benefits and limitations section of the article on Document360’s multi-language support.” This will help generate more concise and useful summaries.

**5. Include context for recommendations**

Context is critical when asking Eddy AI to generate recommendations or suggestions. For example, instead of saying, “Recommend improvements,” you could say, “Recommend improvements to the onboarding process in a knowledge base article for new users.”

---

#### **Recommendations for optimizing your experience as a reader with Eddy AI**

1. **Converse naturally**

   **Why**: Speak to "Eddy AI" as you would to a human.

   Example: Instead of "Search for articles on templates," try "Eddy AI, find me articles explaining Document360 templates."
2. **Provide detailed context**

   **Why**: Enhance understanding by setting the stage and providing context.

   **Example**: Instead of "Errors in the documentation," try "Eddy AI, help me identify and resolve errors in the Document360 user guide."
3. **Customize persona**

   **Why**: Instruct "Eddy AI" to adopt a specific identity for personalized responses.

   **Example**: Instead of "Search for software updates," try "Eddy AI, imagine you're our IT expert and update me on the latest software changes."
4. **Embrace creativity**

   **Why**: Encourage experimentation and creativity in your queries.

   **Example**: Instead of a standard search like "Knowledge base structure," try "Eddy AI, let's play! Imagine you're a content strategist and suggest an ideal knowledge base structure."

By following these recommendations, you harness the power of Eddy AI’s capabilities and make your interactions more engaging and tailored to your specific needs. Feel free to experiment, instruct Eddy AI creatively, and watch as your queries yield more insightful and personalized results.

---

## Tips for enhancing knowledge base articles with Eddy AI

**1. Use Eddy AI for content categorization**

When organizing content, ask Eddy AI to help categorize or label articles. For example, “Suggest categories for an article that discusses API integration and customization in Document360.” This will help streamline your knowledge base’s structure.

**2. Generate error message documentation**

If your knowledge base deals with troubleshooting or technical content, you can ask Eddy AI to document common error messages. For example, “Generate explanations for common error messages users may encounter when integrating third-party tools in Document360.”

**3. Request best practices**

Eddy AI can also assist in compiling best practices. For instance, you can ask, “List best practices for writing comprehensive how-to articles for a knowledge base aimed at developers.”

**4. Create troubleshooting guides**

Suppose your knowledge base includes a troubleshooting section. In that case, you can instruct Eddy AI to generate content like, “Create a troubleshooting guide for resolving common login issues in Document360,” which ensures the AI focuses on step-by-step solutions.

---

## Use cases

Eddy AI is a versatile tool that can streamline content creation across various industries, whether you’re building an LMS, maintaining a customer support knowledge base, or generating compliance documentation. By tailoring prompts to your specific needs, you can harness the full potential of Eddy AI to improve efficiency, accuracy, and engagement across your platform.

### 1. Building a Learning Management System (LMS) with Eddy AI

**Course creation and structuring**

* **Outline generation:** You can use Eddy AI to quickly generate course outlines by specifying your learning objectives. For example, ask Eddy AI, “Create an outline for a beginner’s course on cloud computing,” and it will draft a structured plan with topics and subtopics.
* **Content segmentation:** For educational materials, Eddy AI can divide long-form content into smaller, digestible modules. For instance, “Split this article on cybersecurity fundamentals into 5 lessons, each with a title and brief summary.”
* **Quiz and FAQ generation:** Request, “Generate quiz questions for each module in a cloud computing course,” or “Create FAQs for the module on cloud security,” and Eddy AI will produce interactive learning assessments and clarification points.

**Enhancing user engagement**

* **Adaptive learning paths:** Based on learner performance, you can ask Eddy AI to recommend follow-up content. For example, “Suggest advanced articles for learners who have completed the beginner’s cloud computing course.”
* **Knowledge retention aids:** Eddy AI can help create summaries and quick revision guides. You might ask, “Generate a revision guide summarizing the key points of the data privacy module.”

---

### 2. Streamlining content for customer support knowledge base

In customer support, having a well-structured knowledge base is essential for quick and effective problem resolution. Eddy AI can assist by creating and organizing relevant content for customer support teams and self-service portals.

**Creating troubleshooting guides**

* You can prompt Eddy AI with specific support cases like, “Generate a step-by-step troubleshooting guide for common login issues in an e-commerce platform.”
* For technical support, ask for explanations on error messages. For example, “Create documentation explaining the causes and fixes for error code 403 in web hosting.”

**Organizing FAQs for support agents**

* Use Eddy AI to generate frequently asked questions based on customer interactions. For example, “Create a list of FAQs for common billing issues faced by customers on our platform.”
* It can also assist in updating existing FAQs by analyzing new data or customer queries. Ask, “Update our current FAQ section with recent questions about product integration.”

---

### 3. Accelerating compliance documentation in regulated industries

For industries like healthcare, finance, or manufacturing, maintaining up-to-date compliance documentation is crucial. Eddy AI can simplify the creation and maintenance of this content.

**Generating compliance checklists**

* Ask Eddy AI to generate specific checklists based on industry standards. For instance, “Generate a checklist of mandatory compliance requirements for healthcare data privacy regulations (HIPAA).”
* Compliance content often requires updates. Eddy AI can help with prompts like, “Update the checklist with the latest changes to GDPR regulations.”

**Creating Standard Operating Procedures (SOPs)**

* In regulated environments, SOPs need to be clear and detailed. Eddy AI can assist in drafting these. You could ask, “Draft a Standard Operating Procedure for handling customer data in compliance with GDPR.”

---

### 4. Supporting product development documentation in tech companies

Maintaining up-to-date product documentation is key to smooth operations and customer satisfaction for software and tech companies. Eddy AI can help streamline the process.

**API documentation**

* Ask Eddy AI to generate API usage examples or explanations. For example, “Generate a step-by-step guide on how to integrate our API with third-party services.”
* It can also assist with documentation updates. You can request, “Update the API documentation to reflect the changes in the latest version.”

**Release notes and feature documentation**

* With new product updates, use Eddy AI to create concise release notes. For instance, “Generate release notes for version 4.2 of our software, highlighting the new features and bug fixes.”
* It can also help generate user guides for new features. For example, “Create a user guide for the new reporting dashboard feature in our SaaS platform.”

---

### 5. Automating knowledge base content for retail and E-commerce

In retail and e-commerce, a comprehensive knowledge base is critical for ensuring smooth customer support and product understanding. Eddy AI can help keep your content updated and relevant.

**Product documentation**

* Use Eddy AI to automatically generate product guides. For instance, “Create a product guide for a smart home security system, covering setup, troubleshooting, and usage tips.”
* It can also generate comparison content. Ask, “Compare the features of three smart home security systems available on our platform.”

**Order and return procedures**

* Create customer-facing content that simplifies processes. For example, ask, “Generate a step-by-step guide for returning a product purchased on our e-commerce site.”

---

### FAQs

**How can I ensure Eddy AI gives me specific content?**

Be as detailed as possible in your prompt. If you're asking for an explanation, specify the length, tone, and focus. For example, “Provide a formal, 200-word explanation of how to create custom categories in Document360.”

**What should I do if the output is too broad?**

Rephrase the prompt to narrow the focus. Break down the request into smaller steps, such as “Generate a summary of Document360’s version control feature,” followed by “List the key benefits of version control in a knowledge base system.”

**Can Eddy AI assist with writing FAQs based on my content?**

Yes, you can request FAQs based on specific sections or topics. For instance, ask, “Generate FAQs related to article categorization and tagging in Document360.”

**How can I use Eddy AI to create technical content?**

For technical content, make sure your prompts include relevant technical details. For example, “Generate a step-by-step guide for integrating Google Analytics with Document360’s knowledge base.”

<a id="drive"></a>

## File management

**Plans supporting the use of Drive**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Document360 Drive is a centralized, cloud-based storage solution designed to help Document360 customers store, organize, and manage files efficiently.

> NOTE
>
> Plan storage limits are as follows:
>
> * **Free:** 1 GB
> * **Professional:** 50 GB
> * **Business:** 100 GB
> * **Enterprise:** 500 GB

## Document360 Drive

Document360 Drive is a centralized, cloud-based storage repository designed for Document360 customers. It allows you to store and manage all your files efficiently, ensuring easy access and seamless collaboration across your team.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Document360_drive_overview.png "image(134).png")

To access the Document360 drive, click the Drive () icon on the left navigation bar.

### Drive management features

1. [Adding folders and files](/help/docs/adding-folders-and-files)
2. [Folder actions in Drive](/help/docs/folder-actions-in-drive)
3. [File actions in Drive](/help/docs/file-actions-in-drive)
4. [All files overview](/help/docs/all-content-overview)
5. [Recent, Starred, and Recycle bin files](/help/docs/recycle-bin-recent-and-starred-files)

<a id="adding-folders-and-files"></a>

## Adding folders and files

**Plans supporting the use of Drive**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Document360 Drive enables you to create and manage folders and subfolders, ensuring that your file structure aligns with your Knowledge base categories for better navigation and accessibility. This article will walk you through the steps to manage system folders, add new folders, subfolders, and files, making your document management more organized and intuitive.

---

## System folders

Every Document360 project includes **System folders**, which are built-in folders that come by default. These folders are essential for the core functionality of your project and cannot be deleted, moved, reordered, or renamed. However, users can perform certain actions within these folders, including adding files or setting a default folder.

When you navigate to the **Drive** page, you will see a category tree on the left navigation pane listing all your files and folders. System folders are easily identifiable by the **shield icon** next to their name.

> NOTE
>
> While files within system folders can be deleted (though not recommended), the folders themselves have several restrictions.

For example, **Images** is a system folder which contains subfolders such as Home page builder, Settings, Documentation, and Glossary.

![Drive interface displaying system folders like Settings, Documentation, and Home page builder.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-System_folders_in_Drive.png)

### Folder actions

#### Restricted actions

* **Delete**: System folders cannot be deleted.
* **Move/Reorder/Rename**: You cannot move, reorder, or rename system folders.

#### Allowed actions

* **Add Files/Folder**: You can freely add files or create new subfolders within system folders.
* **Change color**: Customize folder colors to help visually organize your Drive.
* **Set default folder**: You can set any system folder as the default for easy access.

![Document360 interface showing file management options and folder structure in the drive.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-More_options_in_system_folder.png)

---

## Adding a new folder

Here are the methods to create a new folder in your Drive.

**Method 1:** Using the ‘New folder’ option  
**Method 2:** Using the ‘+’ option

Method 1

Method 2

### Using the '+' option

Use the Folder Manager navigation pane on the left to add a root-level folder. This process is similar to adding a category using the "Category Manager" in the Documentation section.

1. Navigate to **Drive** () from the left menu in the knowledge base portal.

   Existing Folders and Subfolders will be displayed in a tree-view style on the left navigation pane.
2. In the left navigation bar, hover the mouse pointer over the space between the folders until the **Flywheel** (**+)** icon appears.
3. Click the **+** icon, and a **New folder** popup will appear.
4. Enter the desired folder name.
5. The default location is 'Root level.' You can add a new root-level folder from anywhere in the Drive using the folder location dropdown and clicking on the **Reset** option.
6. Click **Create**.

![Creating a new folder named 'Artifacts related to Release notes' in the drive.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Adding_a_new_folder_using_flywheel_icon.png)

### Using the 'New folder' option

1. Navigate to **Drive** () from the left menu in the knowledge base portal.

   Existing Folders and Subfolders will be displayed in a tree-view style on the left navigation pane.
2. Click the **New folder** option on the top left.

   A **New folder** popup will appear.
3. Enter the **Folder name**.
4. The folder location is 'Root level' by default.

   Using the **Folder location** dropdown, you can select the desired folder.
5. Click **Create**.

![Creating a new folder named 'Artifacts related to Release notes' in Document360.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Adding_a_new_folder_using_New_folder_option.png)

> PRO TIP
>
> When you create folders for your knowledge base s, it is easier to navigate and maintain if the folders are in-sync with the Category and Subcategory of your knowledge base.

---

## Adding subfolders

You can add subfolders once you have more than one root-level folder.

**Method 1:** Using the ‘More’ option  
**Method 2:** Using the ‘+’ option

Method 1

Method 2

### Using the 'More' option

1. Navigate to **Drive** () from the left menu in the knowledge base portal.

   Existing Folders and Subfolders will be displayed in a tree-view style on the left navigation pane.
2. Click the More () icon next to the folder, select **Add folder**.

   The **New folder** popup appears.
3. Enter the **Folder name**.
4. The folder location by default is the folder you click on the More () icon.

   You can add a subfolder anywhere in the Drive using the location dropdown.
5. Click **Create**.

![Creating a new folder named 'AI Writer artifacts' in the document management system.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_Screenshot-Adding_a_subfolder_using_More_option.png)

### Using the '+' option

1. Navigate to **Drive** () from the left menu in the knowledge base portal.

   Existing Folders and Subfolders will be displayed in a tree-view style on the left navigation pane.
2. In the left navigation bar, hover the mouse pointer over the space between the folders until the '+' icon appears.
3. Click the '**+**' icon.

   A **New folder** popup will appear.
4. Enter the desired folder name.

   The default location is the folder where you clicked the '+' icon.

   Using the location dropdown, you can add a subfolder from anywhere in the Drive.
5. Click **Create**.

![Creating a new folder named 'Artifacts related to Release notes' in the drive.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Adding_a_new_folder_using_flywheel_icon.png)

> NOTE
>
> Ensure the root level folder is expanded (The arrow on the left side of the folder points downwards); if not, a new folder will be created at the same level.

> **CAUTION**
>
> Deleting a root-level folder in the Drive also deletes its subfolders and files. This can cause broken images and file links in articles referencing any deleted file.

---

## Adding files

You can add files to folders in drive using two methods:

**Method 1:** Using drag and drop in Empty folders  
**Method 2:** Using the 'More' option

Method 1

Method 2

### Using drag and drop in Empty folders

You can add individual or multiple files to folders or subfolders using the drag and drop feature. If your folder is empty, you can use the drag and drop area in the center or click the **Upload** button.

1. Drag one or more files from your device's local storage and drop them into the designated area.

   Alternatively, click the **Upload from my device** button and use the file explorer to select your files.
2. Specify the **Folder location** where you will store the files.

   The Folder that is selected in the Folder manager is set as the default location for file upload.
3. Upon completing the selection of images, in the **Tags** field, you can select pre-existing tags or choose to create tags, which will be saved to the available list of tags.
4. If a single image is being uploaded, define the **Alt-text**, and if multiple images are being uploaded, define the **Common alt-text** for the set of images selected for upload.
5. Click **Upload** to confirm.

![Adding files using the local file explorer option in the Drive](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/6_Screenshot-Adding_files_drag_and_drop.gif)

### Using the 'More' option

To add files to a subfolder, use the left navigation pane:

1. Click the **More** () icon next to the folder.
2. Select the **Add file** option.
3. You can upload your files in two ways:

   1. Click **Upload from my device** and select your files from local file explorer.
   2. Drag and drop the desired file.
4. Add **Tags** and **Common alt text** if required.
5. Click **Upload**.

![Adding files using the More icon in the Drive](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/7_ScreenGIF-Adding_files_using_more_option.gif)

> NOTE
>
> * File names should not contain the characters +, %, #, or =.
> * You can view the list of acceptable file formats in the bottom left. To know more about acceptable formats, read [How can I add file type restrictions](/help/docs/adding-folders-and-files#how-can-i-add-file-type-restrictions)?
> * When uploading multiple images, you can add both tags and alt text. However, if you upload a combination of images and other file formats, or if you upload only file formats other than images, you can only add tags. Both Tags and Alt text fields are optional fields.

---

## File limits and file type restrictions

The file limits and file type restrictions are as follows:

* Each folder can contain up to 5000 files.
* Subfolders are treated as separate folders.
* **Single file upload**: The maximum file size is 150MB per file.
* **Multiple files upload**: The maximum combined size of all selected files is 160MB.

### Adding file type restrictions

You can restrict the file types you and other team members can upload. For example, if you want to restrict uploads to only .png files, follow these steps:

1. Navigate to **Settings**() > **Knowledge base portal** > **General** > **Drive settings**.

   By default, the **Allow all media types** option is selected.
2. Click **Choose allowed media formats** and click **Add**.
3. Enter the **Media type** and **Extension** fields.

   > NOTE
   >
   > * **Media type** - Type in the media you want to restrict. You must enter the following format: `media type/extension`. Refer the [basic media format types](https://en.wikipedia.org/wiki/Media_type#Common_examples_%5B10%5D) for better understanding
   > * **Extension** - Type in the extension type. This is a case-sensitive field. Ensure that you enter the lowercase alphabet in this field. (For example, .png, .svg, .jpg)
4. Click **Add media type** to add the more allowed file formats.
5. Click **Save** to confirm.

![Adding file restrictions to the project](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/8_ScreenGIF-Adding_file_type_restrictions.gif)

## Troubleshooting

### **Folder file limit reached**

**Error:** This folder has reached its maximum file limit. Please upload your file(s) to another folder.

This error occurs when a folder exceeds the **5000-file limit** in Document360 Drive. This includes:

* Files uploaded directly into a folder.
* Images copied and pasted into the article editor, which are automatically saved in the default folder by **Set default folder**.
* Images from imported **Docx files**, which are stored in the **default folder** on the drive.

**Steps to resolve:**

* Upload new files to a **different folder** or change the default folder on the drive.
* Remove **unused files** from the current folder to free up space.
* If the issue persists, **clear the browser cache** and try again.

![Folder storage limit reached notification in Document360 interface with file list displayed.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/9_Screenshot-Troubleshooting_Folder_files_limit_reached.png)

---

### FAQs

#### What is alt text in Document360 Drive and how is it used?

Alt text (alternative text) in Document360 Drive is a brief description of an image's content. It is used primarily for accessibility purposes, helping visually impaired users understand the context of images embedded in articles. Alt text should be descriptive yet concise, providing meaningful information about the image.

* Specify alt text for each image to ensure accessibility compliance and improve user experience.
* Alt text can be set during the upload process or edited later through image properties in Document360 Drive.
* Each alt text can be up to 140 characters long.

#### Why are certain files and images not uploading to Google Drive and showing a 'File type not supported' error?

This may be due to file type restrictions. To check and adjust the allowed file formats, follow these steps:

1. Navigate to **Settings** ()> **Knowledge base portal**> **General** > **Drive settings** in the Knowledge base portal.

   By default, the **Allow all media types option** is selected.
2. If this option is enabled, try re-uploading your files or images.
3. If specific file formats are selected to restrict, you must remove these restrictions to upload your desired files.

> NOTE
>
> Ensure that file names in uploaded files do not include the characters **+**, **%**, **#**, or **=**."

A centralized, cloud-based storage repository in Document360 for storing and managing all files.

A type of category in Document360 used to organize articles without creating a separate knowledge base page.

A secondary folder in the Document360 drive that is created within a primary folder to further organize files and content.

A type of category in Document360 used to organize articles without creating a separate knowledge base page.

A secondary folder in the Document360 drive that is created within a primary folder to further organize files and content.

Organizes related articles under a common theme in the knowledge base.

A secondary category in Document360 used to organize and display groups of related articles. Subcategories act as folders within a primary category, helping structure similar topics for better organization and navigation.

A type of category in Document360 used to organize articles without creating a separate knowledge base page.

A secondary folder in the Document360 drive that is created within a primary folder to further organize files and content.

A type of category in Document360 used to organize articles without creating a separate knowledge base page.

A secondary folder in the Document360 drive that is created within a primary folder to further organize files and content.

<a id="folder-actions-in-drive"></a>

## Folder actions in Drive

**Plans supporting the use of Drive**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

In Document360, you can organize your files efficiently using folders and subfolders. You can manage individual folders or use bulk actions to handle multiple folders at once, making it easier to maintain and retrieve your knowledge base assets.

> NOTE
>
> For effective file management, it is recommended to organize your folders and subfolders similarly to your documentation categories and subcategories. This ensures that storing, maintaining, and retrieving files is straightforward and intuitive.

---

## Setting a folder as Default folder

To set a folder as a Default folder, follow the below steps:

1. Click the Drive () icon on the left navigation sidebar.
2. Click on any folder from the left navigation pane.
3. Click the More () icon next to the desired folder and then click the **Set default folder** option.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenShot-Default_folder.png)

* The selected folder will be set as the default folder on a project level.
* Once done, you will get a popup saying *Editor folder updated*.
* The **Default folder** on the Drive can be identified by the Edit () icon that appears next to the folder icon.

  > NOTE
  >
  > + If a category has already been mapped to a Drive folder, the mapped Drive folder setting is chosen over the Default folder. All the images added to any article in that category are uploaded to the mapped Drive folder.
  > + But if the category is not mapped to any Drive folder, the images added directly would be saved in the Default folder.

---

## Renaming a folder

You can change or update the existing name of a folder or a subfolder.

1. Click the Drive () icon on the left navigation sidebar.
2. You can view the existing Folders and Subfolders in tree-view style on the left navigation pane.
3. Click the More () icon next to the desired folder.
4. Click **Rename**.
5. Enter the new name and click the **Rename** button.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenShot-Rename_drive.png)

   > NOTE
   >
   > You cannot rename a **System folder**.

---

## Moving a folder

You can move your folders and subfolders within the Drive.

> NOTE
>
> You cannot move a **System folder** in the Drive.

There are two ways to execute the **Move** function.

### Using the More option

1. Click the Drive () icon on the left navigation sidebar.
2. Hover over the folder you want to move and click the **More (****)** icon.
3. Select **Move**.

   Alternatively:

   1. Select one or more folders by checking the boxes next to their names.
   2. Click the **Move** option that appears above the list.
4. In the **Move files** window, select the destination folder.
5. Use the search field to quickly find the destination folder by typing keywords.
6. Click **Move**.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGif-Moving_drive_folder.gif)

The category with its subfolder and files will be moved to the new location.

### Using drag and drop

You can also use the left navigation panel to move your folders into other main folders and subfolders.

1. Click and hold the folder you want to move.
2. Drag the folder to the desired location on the left navigation pane.
3. Drop the folder onto another folder to move it inside.

![54_Screenshot-Drive-Moving_drag_and_drop_moving](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1729155724024.png)

---

## Starred folders

You can add your main folder or subfolder as a Starred entity. This means the folder marked as starred appears when you click on the **Starred** option on the left navigation pane, irrespective of the folder’s location in the Drive.

1. Click the Drive () icon on the left navigation sidebar.
2. Hover over the desired folder and click the star (☆) icon.

   The starred folders will be indicated with a star (★) icon next to the folder name.
3. Click on the "★" icon next to the folder name to remove the folder from the **Starred** list of folders.

   You can perform the same action from the "Starred" overview folder.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_ScreenShot-Starred_drive_folders.png)

---

## Change folder color

You can change the folder color to any given or custom color. This is handy when you want to differentiate one folder from another or color-code it. The default folder color is Gray.

1. Hover over the desired folder on the left navigation pane and click the More () icon.
2. Click **Change color**.

   You can choose from the color palette with all the most common colors. If you want to add any custom color, enter the required Hex code or use the color picker.

![32_Screenshot-Drive_Folder_actions-Change_folder_color](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/32_Screenshot-Drive_Folder_actions-Change_folder_color.png)

---

## Removing or deleting a folder

You can remove or delete folders and subfolders from the Drive using the Remove and Delete options.

1. Click the Drive () icon on the left navigation sidebar.
2. Click the More () icon next to the desired folder.
3. Click **Remove**.

   Alternatively:

   Select the checkbox of the desired folder and the **Remove** option will appear above the folder list.
4. Click **Remove**.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_ScreenShot-Remove_drive_folder.png)
5. A **Delete** confirmation prompt will appear.
6. Click **Yes**.

> NOTE
>
> * Once deleted, all the corresponding reference links of the media files will be broken. Please note that clearing the CDN cache will take up to 1 minute.
> * You cannot remove or delete the System folders. You can identify these folders by the shield symbol on the folder icon.
> * If you have accidentally removed or deleted any folder from the Drive, you can always retrieve it from the **Recycle bin** (up to 30 days from deletion) of the Drive.

---

## Bulk folder actions

You can perform different actions on more than one folder at a time. This saves time when you want to perform these actions for a larger number of folders in your Drive.

1. Click the Drive () icon on the left navigation sidebar.
2. Select one or more folders (in list view and grid view) from the list of folders.

   At the top, you can view the bulk actions possible:

   * **Move**: Relocate the selected folders to another folder.
   * **Copy**: Create a copy of the folders.
   * **Add tags**: Organize folders with tags for better categorization.
   * **Download**: Download the selected folders to your local storage.
   * **Remove**: Delete the folders and move them to the Recycle bin.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_ScreenShot-Bulk_folder_action.png)

---

## Folder breadcrumb

The folder **Breadcrumb** at the top of the Drive window helps you navigate within the folder hierarchy. It shows the path from the root directory to the current folder you’re viewing.

Click on any level of the breadcrumb to navigate back to that folder.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1729167349844.png)

---

### FAQ

#### What happens if I click on the Set default folder option for a folder that is already set as the default?

A drive folder can be set as the default multiple times. If you select the **Set default folder** option for a folder that is already the default, no changes will be made.

#### What happens when I change the name, copy, move, or reorder a folder?

Changing the name, copying, moving, or reordering a folder does not affect the file URLs of the files within it keeping the images linked to articles intact.

A type of category in Document360 used to organize articles without creating a separate knowledge base page.

<a id="file-actions-in-drive"></a>

## File actions in Drive

**Plans supporting the use of Drive**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

## Performing file actions in Drive

To manage files in Document360 Drive, follow these steps:

1. Navigate to **Drive** () from the left menu in the knowledge base portal.
2. Click the desired folder in which the required file is available.
3. Click the list view/grid view () icon on the top right of the **Drive** page.

   * **List view:** Click the **More** () icon next to the file name.

     By default, the list style appears. You can view the files along with information such as name, dependencies, updated on, updated by, file size, and tags. It is visible in columns only when the view is in List style. You can adjust the length of each of the columns containing file information.

     ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Drive page - List view(1).png "Drive page - List view(1).png")
   * **Grid View:** Hover over the file and click **More** and select the file action.

     Alternatively, hover over the file(s) and select the checkbox to view the file actions, such as actions **Move**, **Copy**, **Add tags**, **Download**, and **Remove** at the top menu.

     ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Drive page - Grid view(2).png "Drive page - Grid view(2).png")

---

### Move

You can **move** files between folders without changing its link structure. This is similar to performing cut and paste action.

1. Select the required file in your drive.
2. Click **Move** in the top menu bar.

   The **Move files** popup window appears.
3. Select the desired folder by searching the destination folder in the search bar or by navigating to the desired folder manually from the list.
4. Click **Move**.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/File actions in Drive - Move.png "File actions in Drive - Move.png")

   > NOTE
   >
   > The image link does not change when it is moved from one folder to the other folder in Drive. This helps the images linked to the articles stay intact.
   >
   > `https://cdn.document360.io/project-id/Images/Documentation/image name.image_type`

---

### Copy

You can duplicate the file in another destination folder. This is similar to performing copy and paste action.

1. Select the required file in your drive.
2. Click **Copy** in the top menu bar.

   The **Copy files** popup window appears.
3. Select the desired folder by searching the destination folder in the search bar or by navigating to the desired folder manually from the list.
4. Click **Copy**.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/File actions in Drive - Copy.png "File actions in Drive - Copy.png")

---

### Add tags and alt-text

You can add tags and alt-text to your file for easy discoverability and grouping. The article tags and file tags are from the same tag library. Adding tags makes it easier for you to identify or search and retrieve a particular set of files.

1. Select the required file in your drive.
2. Click **Add tags**, in the top menu bar.

   The **File details** blade appears.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/File actions in Drive - Add tags & alt-text(1).png "File actions in Drive - Add tags & alt-text(1).png")
3. Add the tags in the **Tags** field.
4. Add the alternative text in the **Alt text** field.
5. Click **Update**.

You can also add tags to multiple files simultaneously.

1. Selecting the required files from the drive.
2. Click **Add tags** in the top menu.

   The **Add tags** pop-up window appears.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/File actions in Drive - Add tags - multiple files(2).png "File actions in Drive - Add tags - multiple files(2).png")
3. In the **Tags** field, enter the relevant tags.

   You can either add existing tags or create new tags.
4. Click **Add**.

---

### View details

To view and manage file details, click the **More** () icon next to the file name and select **View details** from the dropdown menu. This will open the **File details** blade, where you can view a thumbnail of the file and access various actions such as move, copy, replace, download, and delete, which are available through icons located below the thumbnail.

Additionally, you can view important file information, including the file's location, size, type, uploaded date, and the name of the user who uploaded the file. You can also view and edit the tags associated with the file, as well as the alt text for image files.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/File actions in Drive - View details.png "File actions in Drive - View details.png")

---

### View file dependencies

**File dependency** indicates the number of instances a particular file has been added/attached to articles/category pages in the knowledge base.

1. Navigate to the Drive (  ) icon in the **Knowledge base portal**.
2. Browse through the folders to locate the intended file.
3. In the Dependencies column, click on the number (e.g., 6) displayed next to the file. This number represents the count of related areas with dependencies.

   * **Files with Dependencies**: If a file has dependencies, the Dependencies field will show the number of dependencies.
   * **Files without Dependencies**: If a file has no dependencies, the Dependencies field will be indicated by a '-'.

   Be cautious when handling folders, as they may contain files with dependencies. Always review individual file dependencies before making changes to a folder.
4. Upon clicking the number, the **File dependencies** panel will appear. This panel provides information about the file's associations in various areas, such as Articles, KB Customization, and Content Reuse.
5. In **Articles**, expand the listed articles to view details such as the article status, article version, Open site () icon, team account, and date.
6. In **KB Customization**, the homepage details associated with the file will be displayed.
7. In **Content reuse**, expand the desired content tool, and you can view the languages and the content reuse (variable, snippet, glossary) name.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/File actions in Drive - File dependencies(1).png "File actions in Drive - File dependencies(1).png")

To identify files with or without dependencies in your drive,

1. Click the **Filter** () in the top right corner.
2. Expand the **Dependencies** tab and choose the necessary option to filter the files based on filtering options.
3. Click **Apply** to view your desired results.   
   This will help to keep the drive free from outdated images or files with no dependencies.

   ![Image showing dependencies filter in drive](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1735730861622.png)

---

### Download

You can download single or multiple files from the drive to your local storage.

1. Select the file(s) you want to download.
2. Click the **Download** button on the top menu bar. The file(s) will be downloaded as a .zip file.

Alternatively, you can download a file from its details page:

1. Open the **File details** blade.
2. Click the **Download** () icon. The selected file will be downloaded as a .zip file.

Alternatively, click the **More** () icon next to the file name and select **Download** from the dropdown menu. The specific file will be downloaded as a .zip file.

---

### Remove

You can delete single or multiple files from the drive to your local storage.

1. Select the file(s) you want to delete.
2. Click the **Remove** button on the top menu bar. The file(s) will be moved to the Recycle bin folder.

Alternatively, you can delete a file from its details page:

1. Open the **File details** blade.
2. Click the **Remove** () icon. The selected file will be moved to the Recycle bin folder.

Alternatively, click the **More** () icon next to the file name and select **Remove** from the dropdown menu. The specific file will be moved to the Recycle bin folder.

> NOTE
>
> Once deleted, all corresponding media file reference links will be broken, and the CDN cache will be cleared shortly.
>
> You can choose to retrieve files from the recycle bin in case of accidental deletion.

---

### Replace

You can update a file by replacing it with another file of the same type. This allows you to update your files without changing the file name or URL. This helps in retaining the file path in any locations where the file is used without breaking the links. The file change will be updated in the article within 20 minutes.

![15_Screenshot-File_actions_in_Drive_File_replace](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1731493359282.png)

#### Method 1

1. Click the Drive () icon on the left navigation sidebar.
2. Navigate to the folder where the file you want to replace is located.
3. Hover over the desired file and click the More () icon.
4. Click **Replace**.

   Your local file manager will open.
5. Select the new file to replace the existing one and click **Open**.

   The new file will be updated in the Drive.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenShot-File_replacement.png)

#### Method 2

1. Click the Drive () icon on the left navigation sidebar.
2. Navigate to the folder where the file you want to replace is located.
3. Hover over the desired file and click the More () icon.
4. Click **View details**.
5. A **File details** blade will open on the right side of the window.
6. Click the Replace () icon.
7. On the **Replace file** popup, click **Replace file**.

   Your local file manager will open.
8. Select the new file to replace the existing one and click **Open**.

   The new file will be updated in the Drive.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGif-File_replacement.gif)

> NOTE
>
> When a file is replaced on the Drive, the old file content is overwritten. The old file content cannot be restored in any way possible (unless there is an offline backup of the same file). Unlike the deleted files, the overwritten files are not available in the Recycle bin of the Drive to restore.

---

## Troubleshooting

### Resolving file replacement error

**Error**: You can’t replace files with a different style type.

This error occurs when you try to replace a file with another file of a different type, which is not allowed. For instance, if you are trying to replace a jpg file with a pdf file, you might encounter this error.

**Steps to resolve**:

1. **Verify file types:**

   1. Navigate to **Drive ()** in the **Knowledge base portal**.
   2. Click the **More** () icon to view the file details and click **Replace.**
   3. Ensure the selected and destination files are of the same type.

2. **Clear your browser cache:**

   1. After confirming the file types, clear your browser cache and try again.
   2. Use the steps below based on your browser:

      * Google Chrome: Click on **Menu** () > **Settings** > **Privacy and security** > **Clear browsing data**.
      * Mozilla Firefox: Click on **Menu** ()  > **Settings** > **Privacy & Security** > **Clear Data**.
      * Microsoft Edge: Click on **Menu** ()  > **Settings** > **Privacy, search, and services** > **Choose what to clear**.
      * Safari (Mac): Go to **Safari** > **Preferences** > **Privacy** > **Manage Website Data** > **Remove All**.
      * Safari (iPhone/iPad): **Settings** > **Safari** > **Clear History and Website Data**.
      * Opera: **Menu** > **Settings** > **Advanced** > **Privacy & Security** > **Clear browsing data**.

        > NOTE
        >
        > It may take some time for the updated settings to take effect.

3. **Test in different environments:**

   1. Open the file replacement workflow in an incognito window.
   2. Try the process in different browsers to confirm the issue is resolved.

4. If the issue persists after following these steps, please contact the Document360 support team for further assistance: [Contact Document360 Support](https://document360.com/support/)

   Provide the following details:

   * Screenshots of the error message.
   * Details of the affected files.
   * A HAR file for further analysis.

---

### FAQs

#### Is there a way to see the file's history or previous versions before replacing it?

Currently, Document360 does not provide version history of files in the Drive. It's recommended to keep backups of important files before making replacements.

#### What happens to the old file after I replace it?

The old file's content is permanently overwritten and cannot be restored. Make sure to back up important files before replacing them.

A folder in the Document360 drive where deleted files and folders are temporarily stored. It allows users to recover accidentally deleted items if needed. Deleted items are stored for 30 days before they are deleted permanently.

A folder in the Document360 drive where deleted files and folders are temporarily stored. It allows users to recover accidentally deleted items if needed. Deleted items are stored for 30 days before they are deleted permanently.

A folder in the Document360 drive where deleted files and folders are temporarily stored. It allows users to recover accidentally deleted items if needed. Deleted items are stored for 30 days before they are deleted permanently.

A centralized, cloud-based storage repository in Document360 for storing and managing all files.

A folder in the Document360 drive where deleted files and folders are temporarily stored. It allows users to recover accidentally deleted items if needed. Deleted items are stored for 30 days before they are deleted permanently.

<a id="all-content-overview"></a>

## All files overview

**Plans supporting the use of Drive**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The **All Files** overview page in Document360 Drive compiles all the files in your project in one place. This feature is particularly helpful for performing bulk operations, allowing you to manage files across all folders and subfolders from a single location. Whether you need to move, copy, or delete files in bulk, the All Files page saves you time and effort by centralizing your file management.

## All files overview page

Navigate to Drive () > **All files** on the Knowledge base portal.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Drive_all_files_page_overview.png)

The **All files** overview page will display, listing the files in your project. By default, the page shows 20 files per page. To navigate through the list of files, use the pagination buttons at the bottom of the list to move between pages.

The following options are available on the **All files** page:

* **Storage used**: You can view both the used and total available storage in your Document360 Drive. If you need additional space, you can purchase more storage by selecting the **Buy more** option.
* **Grid view**: Files and folders in Drive are displayed in list view by default. You can switch to **Grid view** to display files and folders in a grid format.
* **Filter**: Use the **Filter** option to narrow down files based on specific criteria. The following filters are available in Drive:

  + **Dependencies**: Shows files without any dependencies, meaning these files haven't been used in articles, content reuse elements, or knowledge base customizations.
  + **Uploaded**: Filters files by their upload date.
  + **Uploaded by**: Filters files by the team account that uploaded them.
  + **Type**: Filters files by their format.
  + **Tags**: Filters files by user-added tags.

### Bulk operation on files

The **All files** page allows you to perform bulk operations, streamlining file management across the entire Drive. Here's how to select files and use these operations effectively:

* Click on the checkbox next to each file to select it individually.
* To select all files on the current page (up to 20), click the **Select all** checkbox at the top of the list.

> NOTE
>
> If you want to select all files in the Drive, click **Select all {N} items**, where **N** is the total number of files in your project. This will select all files, not just the 20 displayed on the current page.

Once you have selected the files you wish to manage, you can choose from the following bulk actions:

* #### **Move**

  + Relocate selected files to any folder or subfolder, including categories.
  + Use this feature when reorganizing your Drive to keep files well-structured.
* #### **Copy**

  + Duplicate files and paste them into a different folder or subfolder in the Drive.
  + Copy files when you need the same content in multiple locations without affecting the original file.
* #### **Download**

  + Download the selected files to your local storage.
  + Use this feature to back up important files or to work on them offline.
* #### **Remove**

  + Delete files from the folder and move them to the Recycle bin (includes categories).
  + Once in the Recycle bin, files can be restored or permanently deleted.

If your project contains more than 20 files, use the pagination buttons at the bottom of the All Files page to move between pages. Here’s how to navigate:

* **Next/Previous buttons**: Click these to move forward or backward through the list of files.
* **Page numbers**: Jump to a specific page by clicking the page numbers displayed at the bottom of the file list.

  ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Drive_all_files_bulk_actions.png)

---

### Best practices for file management

* **Regular cleanup**: Use the **All files** page to periodically review and clean up unnecessary files. This ensures your Drive stays organized and clutter-free.
* **Use categories**: When moving or copying files, categorize them appropriately to improve searchability and file management.
* **Check dependencies**: Before removing files, verify their dependencies to ensure they are not linked to other important content.

<a id="recycle-bin-recent-and-starred-files"></a>

## Recent, Starred, and Recycle bin files

**Plans supporting the use of Drive**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Managing a large number of files and folders can sometimes lead to intentional or accidental deletions. To help recover deleted content, Document360 provides a Recycle bin. When a file or folder is deleted, it is temporarily moved to the Recycle bin, allowing users to easily restore it if needed.

> NOTE
>
> Document360 also provides a dedicated **Recycle bin** for the categories and articles deleted from your Documentation.

## Recycle bin operations

1. Click the Drive () icon on the left navigation sidebar.

   You can view the existing Folders and Subfolders in tree-view style on the left navigation pane.
2. Click **Recycle bin**.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenShot-Recycle_bin.png)

> NOTE
>
> Hover over the file and click the eye () icon to view its dependencies. A blade with the list of article(s) where the file is associated will appear.

### Restore from recycle bin

#### Bulk restore

In case of accidental file/folder deletions in the Drive, follow the below steps to restore all the files and folders.

1. On the Recycle bin window, select the checkbox of the files/folders you want to restore.
2. If you wish to select all the items in the Recycle bin, check the Select all checkbox at the top (only the first 20 items will be selected).
3. To select all the files in your Recycle bin, click **Select all {N} items**, where N is the total number of files in the Recycle bin.

   This option will appear only when at least one file is selected.
4. Click **Restore**.

   The selected files/folders will be restored to their original location in the Drive.

#### Restore individual files or folder

For individual files/folders,

1. Hover over the desired file/folder and click on the More (•••) icon.
2. Click **Restore**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGif-Restore_drive.gif)

### Permanently deleting files from the Recycle bin

If you are confident that you do not need the files/folders in the recycle bin,

1. On the Recycle bin window, select the checkbox of the desired files/folders.
2. If you wish to select all the Recycle bin items, check the Select all checkbox at the top (only 20 items will be selected).
3. To select all files, click **Select all {N} items**.
4. Click **Delete forever** located above the list of files/folders.
5. Alternatively, for individual files/folders, hover over the desired file/folder and click on the More (•••) icon next to the file/folder.
6. Click **Delete forever**.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_ScreenGif-Delete_forever_drive.gif)

#### Empty recycle bin

If you want to eliminate all the files/folders in the Recycle bin in one go, click the **Empty recycle bin** button at the top right. All the files/folders will be permanently deleted from the Recycle bin.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_ScreenShot-Empty_recycle_bin.png)

> NOTE
>
> The deletion of files/folders from the **Recycle bin** is an irreversible action. Once the file/folder is removed from the Recycle bin using the **Delete forever** or the **Empty recycle bin** option, it cannot be retrieved (unless you have an offline backup of the same file/folder).

---

## Recently uploaded files and folders

The **Recent** folder in the Drive window helps you to access the latest uploaded files/folders. This is a dynamic folder populated with files and folders based on the latest addition or upload. This comes in handy as you do not have to look for the latest files uploaded into any of the folders. To access this folder,

1. Click the Drive () icon on the left navigation sidebar.
2. From the left navigation pane, click on the **Recent** folder.

   You will see the list of files/folders that are uploaded latest based on the time of upload.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_ScreenShot-Recent_drive.png)

---

## Starred folder and files

You can add your main folder or subfolder as a Starred entity. This means the folder marked as starred appears when you click on the **Starred** option on the left navigation pane, irrespective of the folder’s location in the Drive. Starred files and folders help you quickly access important content by marking them for easy reference.

1. Click the Drive () icon on the left navigation sidebar.
2. On the left navigation pane, click the **Starred** folder.

   All the files/folders that you have starred will be listed here with a star (★) icon next to the folder name.
3. Click on the star (★) icon again to remove it from the **Starred** folder.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_ScreenShot-Starred_drive_folders.png)

---

### FAQs

#### What happens to a file/folder in the Recycle bin if I do not perform any action on it?

The file/folder would be automatically deleted permanently after 30 days.

#### Can I recover permanently deleted files or folders from the Recycle Bin?

No, once files or folders are permanently deleted using the "Delete forever" option, they cannot be recovered. It’s important to be certain before selecting this option. If you need additional backups, consider creating an offline backup before permanently deleting files.

A type of category in Document360 used to organize articles without creating a separate knowledge base page.

A centralized, cloud-based storage repository in Document360 for storing and managing all files.

<a id="workflow-designer"></a>

## Workflow designer

**Plans supporting workflow designer**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

A workflow in Document360 is a crucial tool designed to streamline the management of knowledge base documentation. It enables you to establish an internal business process for creating, editing, reviewing, and publishing articles or category pages.

## Why use workflow?

Workflow management facilitates collaboration among team members, including writers, editors, illustrators, and subject matter experts. Organizations can ensure consistency, accountability, and efficiency throughout the documentation cycle by implementing a structured workflow.

### Using workflow in Document360

Workflow functionality in Document360 consists of two main modules:

**1. Workflow designer**  
**2. Workflow assignments**

Here's a quick guide to using the **Workflow designer** efficiently.

---

## Workflow designer

The **workflow designer** feature helps project team members to create and maintain a step-by-step stage for any new or existing documentation. This makes collaboration easier between the writers, editors, illustrators, subject matter experts, and other project team members.

The workflow feature allows the admins or project owners to design a workflow that best suits their business requirements.

### Accessing the Workflow designer

To access the workflow designer page, follow the below steps.

Navigate to **Documentation**() > **Content tools** > **Workflow designer** in the Knowledge base portal.

You can view the existing built-in workflow (Draft – In review – Published). You can create additional workflow statuses here. You can also edit the existing statuses (including system status) and reorder/delete the custom statuses anytime.

![1-Screenshot-Accessing_the_workflow_designer.png](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1-Screenshot-Accessing_the_workflow_designer.png)

---

## Workflow status

A **Workflow Status** represents a checkpoint or stage in the documentation cycle within Document360. There are two types of statuses:

* **System Status**: These are predefined start and end statuses (e.g., Draft and Published) that **cannot be deleted or reordered**.
* **Custom Status**: These are user-defined statuses that offer flexibility in creation, editing, reordering, and deletion at any time. You can also turn on the **read-only** toggle for the statuses you added. This restricts the other team members from editing the article(s) or category page(s). They can only view and comment on it.

---

## Adding a new status

1. Navigate to **Documentation**() > **Content tools** > **Workflow designer** in the Knowledge base portal.
2. Click the **Create workflow status** button at the top-right.  
    Alternatively, click the **(+)** button found between the statuses to create the workflow status.

![2-Screenshot-Create_workflow_status.png](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2-Screenshot-Create_workflow_status.png)

4. Type in a **Name** (required) and **Description** (optional) for your status.
5. Turn on/off the **Read-only** toggle to allow or restrict editing the article when it is set to the specified status.

   > NOTE
   >
   > If the Read-only toggle is enabled, team members will not be able to edit the article or category page content when the article is set to the specified workflow status. Additionally, team members will not be allowed to publish the article. However, they can still add comments on the articles or category pages.
6. Click on the **Add** button at the bottom.

   The workflow status will be added in the intended section of the workflow.

![3-Screenshot-Create_workflow_status](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3-Screenshot-Create_workflow_status.png)

### Editing an existing status

1. Navigate to **Documentation**() > **Content tools** > **Workflow designer** in the Knowledge base portal.  
    The existing statuses in the workflow will be listed.
2. Click on the **Edit** () icon and an **Update status** panel will appear.

   ![4_Screenshot-Editing_a_new_workflow_status](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Editing_a_new_workflow_status.png)
3. You can edit the **Name**, and **Description** and update the **Read-only** option (for statuses you have created (or) statuses for which the **Read only** is turned off).
4. Click the **Update** button at the bottom once you are done.

#### Reorder status

You can reorder the custom statuses dragging and dropping them within the workflow. The reorder icon is available on the left adjacent to each status.

![6_Screenshot-Reordering_a_new_workflow_status](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/6_Screenshot-Reordering_a_new_workflow_status.png)

> NOTE
>
> You cannot reorder system workflow statuses.

### Deleting an existing status

1. Navigate to **Documentation**() > **Content tools** > **Workflow designer** in the Knowledge base portal.  
    The existing statuses in the workflow would be listed.
2. Click on the **Delete** () icon.

![5_Screenshot-Deleting_a_new_workflow_status](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_Screenshot-Deleting_a_new_workflow_status.png)

4. Click **Yes** to confirm.

> NOTE
>
> * The workflow status cannot be recovered once deleted. All the due dates and assignee data would also be lost.
> * Users cannot delete the two system statuses (Start\* and end\*) provided.

---

## Troubleshooting

### Cannot edit article due to read-only workflow status

**Error:** You can't edit this article as the current workflow status is marked as read-only.

This warning appears because the article's workflow status is currently set to a custom read-only mode. When an article's workflow status is read-only, editing is restricted to maintain content integrity for specific workflow stages.

Your admin may have set this status for a specific purpose. If you have the appropriate permissions, you can modify the status. Otherwise, please contact your admin to make the necessary changes.

**Steps to resolve:**

Follow the steps below to enable editing for the article:

1. Navigate to **Documentation**() > **Content tools** > **Workflow designer** in the Knowledge base portal.
2. Locate the workflow status causing the warning message. You can identify it by the **lock** () icon, which indicates that the **Read-only** option is enabled.
3. Click the **Edit**() icon next to the workflow status.

   The **Update status** panel will appear.
4. Turn off the **Read-only** toggle.
5. Click **Update**to save the changes.

Once the read-only status is disabled, you can edit the article as needed.

![Encountering "You can't edit this article as the current workflow status is marked as read-only" message while editing an article.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/ScreenGIF-Troubleshooting_You%20can't_edit_this_article.gif)

---

## eBook

### Guide to Setup Documentation Workflow

Our eBook will show you how to produce quality documentation!

#### You'll learn,

* *A step-by-step guide to creating documentation workflows*
* *Documentation best practices that improve content quality*
* *How to produce content that meets your customer expectations*

![ebook-documentation-workflow-mockup](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/ebook-documentation-workflow-mockup.png)

[![2022-02-02_08-23-42](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2022-02-02_08-23-42.png)](https://document360.com/ebook/guide-to-setup-documentation-workflow/#eBook-Form)

---

<a id="managing-workflow-status"></a>

## Managing workflow status

**Plans supporting for Managing workflow status**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

You can manage workflow statuses from the Documentation editor. Additionally, they can assign these statuses to team members directly within the editor.

---

## Workflow status actions

The **Workflow status** option is available at the top right of the Documentation editor, next to the **Publish**/**Edit** button.

![Image showing workflow status of a article](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/18_ScreenShot-Workflow.png)

#### View the current status

The active workflow status of an article will be displayed as a tag below the **Workflow status** option above the editor.

For more information about the current or other status in the workflow, follow the below steps:

1. Click the **Workflow status** dropdown at the top right of the editor.
2. The list of available statuses and supporting information (due date, approved status, assignee) will be displayed.
3. If the article is in any status, the preceding statuses will be struck through.
4. If the article is *Published*, then all the statuses will be struck through.

#### Setting a due date

You can set due dates for both active/current and upcoming statuses in an article workflow.

1. Click the **Workflow status** dropdown at the top right of the editor.
2. Hover over the status for which the date has to be set.
3. Click the **Set due dates** () icon.
4. A calendar selection assistant will appear, and you can select the desired date.
5. To clear any existing due date, click the **Clear due date** option below the calendar.

#### Setting an assignee

1. Click the **Workflow status** dropdown at the top right of the editor.
2. Hover over the status for which the team member has to be assigned.
3. Click the **Assign owner** () icon.

   The list of project team members will be displayed.
4. You can also use the **Search by email** bar at the top to find the desired team member.
5. Click the **Assign** () icon.

   The team member will be assigned a particular status, and a notification will be sent to the team member’s Email.

   Removing an assignee can also be done by following the same steps. Hover over the team account and click the (**x**) icon next to it.

   > NOTE
   >
   > A single team member account can be assigned to multiple workflow statuses for an article. However, multiple team accounts cannot be assigned to a single workflow status.

#### Activate a workflow status

You can activate the next status if they have completed the assigned workflow status.

1. Click the **Workflow status** dropdown at the top right of the editor.
2. Hover over the next status and click on it.

   An expanded view of the status will appear along with the comment box.
3. If needed, use the comment box to provide any information to the next assignee by tagging them.
4. Click the **Set status** button and the next workflow status will be activated.

#### View workflow history

Users can view the entire workflow history with all the supporting information for an article.

1. Click the **Workflow status** dropdown at the top right of the editor.
2. Click the **View history** option above the workflow status list.
3. An expanded view with all the workflow status history will be displayed.

   This provides an overview of the entire workflow cycle that an article has gone through.

   Each version of the article revision can have its workflow history and comments.

![To set and manage workflow status of an article](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/19_ScreenGif-Workflow.gif)

---

### FAQ

**What steps should I take to ensure that team accounts receive notifications when I assign a workflow?**

The email will be sent to the team account to whom the workflow status is assigned, provided they have enabled the workflow events in the notification mapping. To ensure that team accounts receive notifications when assigning a workflow, they need to enable the relevant events in the notification section. Follow these steps:

1. Navigate to **Settings** () > **Knowledge base portal** > **Notifications**.
2. Go to the **Notification mapping** tab and expand the **Documentation editor** accordion.
3. Turn on the following toggles:

   * Article Workflow Status Updated
   * Article Workflow Due Date Updated
   * Article Workflow Assignee Updated
4. Additionally, to enable notifications for page category types, turn on the following toggles:

* Category Workflow Status Updated
* Category Workflow Due Date Updated
* Category Workflow Assignee Updated

---

## **eBook**

### **Guide to setup documentation workflow**

Our eBook will show you how to produce quality documentation!

**You’ll learn,**

* *A step-by-step guide to creating documentation workflows*
* *Documentation of best practices that improve content quality*
* *How to produce content that meets your customer expectations*

![ebook-documentation-workflow-mockup](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/ebook-documentation-workflow-mockup.png)

[![2022-02-02_08-23-42](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2022-02-02_08-23-42.png)](https://document360.com/ebook/guide-to-setup-documentation-workflow/#eBook-Form)

<a id="workflow-assignment"></a>

## Workflow assignment

**Plans supporting workflow assignment**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Document360 enables you to manage and assign workflow statuses to team members directly from the editor. This feature streamlines the documentation process by providing clear visibility and control over each stage of an article's lifecycle.

---

## Assign an article to a team member

1. Navigate to the desired article from the Knowledge base portal.
2. Click the workflow status dropdown on the top right corner of your editor.
3. Hover over the desired status and click the **Assign owner** () icon.
4. Select the appropriate team member and click () to assign.

   Assigned team member will receive a notification email.

   > NOTE
   >
   > A single team member can be assigned to multiple workflow statuses in an article, but multiple members cannot be assigned to a single workflow status.
5. To remove an assignee, hover over the team member's name and click the (x) icon.
6. Click the **Set due dates** () icon to select the desired due date.
7. Click the status again to add any necessary comments (optional). Use the @ command to tag your team members and notify them regarding the updated workflow status.
8. Click **Set status** to complete the workflow assignment.

![4-Screenshot-Assign_workflow_to_team_member.png](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4-Screenshot-Assign_workflow_to_team_member.png)

---

## Workflow assignments overview

The Workflow assignments overview page gives a bird’s eye view of the articles/category pages available on the selected version and language of the knowledge base project. The articles that assigned information to the team account’s profile are available.

From the Knowledge base portal, navigate to Documentation () > **Workflow assignments**.  
![1-Screenshot-Workflow_assignments.png](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1-Screenshot-Workflow_assignments.png)Team accounts can view the number of articles/category pages in each workflow status at any given point in time along with the due date and workflow status. You can also view the articles that are assigned to you from the left navigation menu.

---

## eBook

### Guide to Setup Documentation Workflow

Our eBook will show you how to produce quality documentation!

#### You'll learn,

* *A step-by-step guide to creating documentation workflows*
* *Documentation best practices that improve content quality*
* *How to produce content that meets your customer expectations*

![ebook-documentation-workflow-mockup](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/ebook-documentation-workflow-mockup.png)

[![2022-02-02_08-23-42](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2022-02-02_08-23-42.png)](https://document360.com/ebook/guide-to-setup-documentation-workflow/#eBook-Form)

---

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

<a id="article-templates"></a>

## Templates

**Plans supporting content reuse**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Document360 article templates are pre-designed article structures that you or any team member can use while writing articles for your Knowledge base. These templates provide design consistency and style for your brand, whether you're creating a User guide, FAQ, Release notes, or any custom document.

In Document360, you can create new articles from any basic system templates or create a new article template that you can reuse any number of times in your project.

---

## Creating an article from an existing template

1. From the left navigation pane, hover over the desired category and click on the () icon.
2. Click **Article from template** and enter the article name in the **Name** field.
3. Choose the category location from the **Nest category under…** dropdown.
4. Select one of the available templates.

   A preview will be available in the right frame.
5. Once done, click **Create**.
6. If you don’t find a suitable template in the preloaded list, click **Manage templates** next to the the **Template name**.

   ![Creating a template from existing article](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_ScreenGIF-Creating_an_article_from_an_existing_template.gif)

---

## Creating a new template

1. From the Knowledge base portal, Navigate to Documentation() > **Content tools** > **Content reuse** > **Templates** in the Knowledge base portal.

   The **Manage templates** overview page appears.

   You can view the system templates and the templates you have previously added.

> NOTE
>
> Default templates will be created automatically based on your onboarding use case selection. These templates can be edited, copied, or deleted as per your requirements.
>
> ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-New_system_templates.png)

2. Click **Create template** on the top right of the page.

   The **Create template** window will appear.
3. Enter the desired template name.
4. Select the editor type for the template.
5. Enter the description of the templates.
6. Click **Create.**

   A new article is created, and you can start making the necessary changes.
7. Once done, click **Save** or **Save & close** from the Save dropdown.

   Your new template will be added to the list of templates.

   ![2_ScreenGIF-Creating_a_new_template_from_scratch](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGIF-Creating_a_new_template_from_scratch.gif)

### Editing a template

1. Hover over the desired template and click the **Edit** () icon.

   The selected template will appear.
2. On the top, next to the template name, click the  icon.

   A popup will appear.
3. Update the name and the description of the template in their respective fields.

   Note that the character limit for the description is 250 characters (including space).
4. Once done, click **Save**.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_ScreenGif-Templates.gif)

---

## Saving an existing article as a template

You can add an existing article as a template regardless of its status (Published, Draft, New, Review, Hidden).

1. In the **Documentation editor**, click the More (•••) icon next to an article name.
2. Select **Save as template** and click **Yes** in the **Save** confirmation prompt.
3. You can also find the **Save as template** option under the More (•••) icon on the top-right of the article editor.

   A template has been added, which you can use when creating new articles from a template.
4. Go to the **Manage templates** page to view, edit, and delete the saved template.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenGif-Templates.gif)

---

## FAQs

#### Can I clone templates and use them to create a new template?

On the Templates page, you can clone templates to create new ones by hovering over the template and clicking on the **Clone** () icon. This saves time by allowing you to derive aspects from existing templates.

#### What happens if I delete a template that I no longer need?

Deleting a template removes it from the library but doesn't affect articles already created using that template. Your existing content remains unaffected.

#### Is the template I create available for other team members to use?

Once you create or save an article as a template, other team members can view and use the template in the Template library.

#### Does updating a template affect the article created from it?

Updating a template does not affect articles that were created from that template. When you create an article from a template, a local copy of the content is saved in the article. It is isolated from the template content.

#### Can I clone templates used in articles to other languages?

No, templates cannot be cloned to different languages in Document360. Currently, templates can only be cloned within the same language.  
If you need to use a template in a different language:

1. Manually recreate the template in the desired language by copying its structure and content.
2. Translate the content into the desired language.
3. Save the new template in the respective language workspace.

<a id="variables"></a>

## Variables

**Plans supporting content reuse**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

You can reuse variables when you use the same text-based content in multiple places that may change over time (like field names, contact numbers, addresses, disclaimers, etc.). A **Variable** in Document360 is a reusable element that helps maintain consistency and efficiency across various documentation sections. By employing variables, contributors to your articles can easily update information in one place, and it automatically reflects throughout the entire documentation, ensuring accuracy and reducing redundant efforts.

For example, you want to add your contact information in multiple instances, which might change over time. In this case, you can add a variable for contact information. If a change is required, you can update the variable alone instead of updating it in all instances.  
 (**Contact: +1 897564231/support@serverless.com**)

---

## Creating a variable

To create a variable,

1. Navigate to Documentation () > **Content tools** > **Content reuse** > **Variables** in the knowledge base portal.

   The **Variables** page appears. If you have added any variables earlier, you can see them listed here.
2. Click **Create variable** at the top to select language-specific variables (Global, English, French, etc.) added to your project.
3. Enter the **Name** for your variable.

> NOTE
>
> The variable **name** can include letters, numbers, hyphens, and underscores, with a maximum length of 30 characters.

6. The **Merge code value** will be the variable name that appears with the variable tag in your editor.

> For example, if your variable name is **Disclaimer**, your Merge code value would be ***{{variable.Disclaimer}}.***

7. In the **Language** selection dropdown, the default selection is **Global** (Available across all languages). However, if needed, you can choose a desired available language to create a language-specific variable.
8. In the **Content** field, enter the variable's content.

> NOTE
>
> The variable content's character limit is 100 characters with spaces. If you want to add longer texts, expressions, media, tables, or code blocks, use **Snippets**. For more information, read the article on [Snippet](/help/docs/snippets).

#### Formatting options

Use the following text formatting options to style your variable content

a. Basic text formatting:  
 • **Bold**  
 *•* ***Italic***  
 • **~~Strikethrough~~**  
 • **Underline**  
 • **Font size** (8 to 36)

b. Additional formatting:

Click the **More text** icon to access:  
 • **Font Family** (Choose from the list of fonts)  
 • **Text color** (Color picker or HEX code)  
 • **Background color** (Color picker or HEX code)  
 • **Subscript**  
 • **Superscript**  
 • **Clear Formatting**

c. **Insert Link** - To add a hyperlink.

* Click on the **Insert link** icon.
* Type the **URL** and add text to the link.
* If needed, select **Open in new tab.**
* Click **Insert.**

9. Click the **Create variable** button.

The newly created variable will appear on the **Variables** page, where it can be edited or deleted as needed.

![Creating a new variable in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenGIF-Creating_a_variables.gif)

---

## Using variable in an article/category page

You can add a variable to your article/category page using two methods.

#### Method 1: Using the syntax (Markdown editor)

In the Markdown editor, type a **variable.MergeCodeValue** between closed double curly brackets.

> **Example**: *{{variable.Disclaimer}}*

You must know the exact merge code value to add the desired variable. The variable will not work even if a single letter changes.

> NOTE
>
> Typing in *variable.Merge\_Code\_Value* will only work in the Markdown editor. If you are using Advanced WYSIWYG editor, you can insert variable using the toolbar.

#### Method 2: From the toolbar (Markdown, WYSIWYG, and Advanced WYSIWYG)

1. Click the Content reuse **()** icon for Markdown and WYSIWYG editor.   
   **(or)**  
   From the Advanced WYSIWYG editor, click **Insert > Variables** or use the slash "**/**" command to access variables.
2. Select the variable or use the **Search variables** bar to narrow down the variable name.

> In the Advanced WYSIWYG editor, the **Variables** pane appears on the right for variable selection. Hover the pointer on the variable name to preview its content.

3. Select the intended variable to insert**.**

> NOTE
>
> In Markdown and WYSIWYG editor, you can select multiple variables in one go.

![Inserting the variables in the Advanced WYSIWYG editor](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGIF-Using_variables_in_advanced_WYSIWYG_method2.gif)

---

## Variables overview page

You can view, edit, or delete a variable on the **Variables** page.

1. Navigate to Documentation () > **Content tools** > **Content reuse** > **Variables** in the knowledge base portal.

   The **Variables** page appears where you can find the list of variables you have already added.

![Overview page of Variables in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-overview_of_Variables_page.png)

1. **Languages**: To filter the variables in Global or a specific language.
2. **Search variable**: Search the variable list based on the name.
3. **Used in**: If a variable is not added to any article/category page, the status would be `-`. If a variable is added to any article/category page, you can click the **View** button to see the list of articles/category pages containing the variable.
4. **Language**: The desired language of each variable.
5. **Last modified**: The last time the variable content was updated.
6. **Preview**: Click on the variable name, and you can view the variable's content.
7. **Progress**: Click the globe icon to view the variable’s progress in multiple languages.
8. **Edit** () icon: To edit the variable content.
9. **Delete** () icon: To remove the variable.

---

### View article/category page dependency

In the **Variables** page, you can find the **Used in** column.

1. In the **Used in** column, click on the **View** button.

   The **View references** panel will appear, where you can view the list of articles/category pages to which the variable has been added.
2. Click on the article to expand the section.
3. You can find the following information:

   * The article version.
   * The project workspace and language.
   * The team account name and profile picture who has added the variable.
   * The article states (Published, Draft, New Article).
   * The time/date information when the variable was inserted in the article/category page.

![Viewing the dependency of variables](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_ScreenGIF-Viewing_the_dependency_of_variables.gif)

---

### Editing an existing variable

1. Navigate to Documentation () > **Content tools** > **Content reuse** > **Variables** in the knowledge base portal.

   The **Variables** page appears. You can find the list of variables you have already added.
2. Hover over the desired variable and click the Edit **()** icon.

   You can edit the content of the variable. The Name and Merge Code Value cannot be edited.

> NOTE
>
> **Editing a link added in a variable**
>
> Click the link, and you can find the following options:
>
> * **Open link** (): The link will open in the tab. This helps in checking the link.
> * **Style** (): Style has two options.
>
>   + Green: To change the link text color to green.
>   + Thick: To increase the thickness of the link text.
> * **Edit** (): To edit the URL, link text, and change open in the new tab option.
> * **Unlink** (): To unlink the URL and change it to standard text. The URL will be unlinked, and only the URL text will appear.

3. After you complete the content edit, click the **Update** button.

> NOTE
>
> When you edit the content of an existing variable in the library, the content change will reflect in all the articles/category pages that contain the respective variable.

![Editing the existing variables in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_ScreenGIF-editing_an_existing_variables.gif)

---

### Deleting a variable

1. Navigate to Documentation () > **Content tools** > **Content reuse** > **Variables** in the knowledge base portal.

   The **Variables** page appears. You can find the list of variables you have already added.
2. Hover over the desired variable and click the **Delete** () icon.
3. Click **Yes** in the confirmation prompt.

#### To bulk delete multiple variables

Select multiple intended variables from the **Variables** page and click the **Delete** option at the top of the list.

![Deleting the variables in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/6_ScreenGIF-Deleting_a_variable.gif)

---

## Translating variables

You can create and manage variables in multiple languages. This ensures that when your articles are translated, the variables match the language of the article, providing a consistent and localized user experience.

#### **Translating new variables**

1. Navigate to the Documentation () > **Content tools** > **Content reuse** > **Variables** in the knowledge base portal.
2. Click **Create Variable**.
3. In the **Language** dropdown, select the intended language (except global).
4. Enter the variable **name** and the content for the variable in English (or your default language).
5. To translate the content into other languages, click the **Translate to other languages** dropdown.
6. Select the desired language(s) from the dropdown menu and click **Translate**.

   > NOTE
   >
   > * The default language will be marked as **Main**.
   > * Translated languages will be indicated with a green tick to show that the translation is complete. If needed, you can navigate to untranslated languages and complete their translation.
7. Once the translations are complete, click **Create Variable** to save the variable along with its translations.

> For example, if you create a variable for a welcome message in English, you can use the translation feature to add the same message in French, Spanish, German, etc.

![Translating the new variables in other languages in the Knowledge base portal.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/7_ScreenGIF-Translating_new_variables.gif)

#### Translating existing variables

> NOTE
>
> Global variables cannot be translated.

1. Click on the desired existing variable you wish to translate.
2. Navigate to **Translate to other languages** and select the desired language that the variable needs to be translated.
3. Click **Translate**.
4. If needed, you can navigate to other languages and translate them.
5. To retranslate the content, click **Translate again**, which will overwrite the existing translation with the new one.
6. If you need to remove the translated variable for a specific language, click **Remove language**.

   You can retranslate the content at any time if needed.

![Translating the existing variables in other languages in the Knowledge base portal.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/8_ScreenGIF-Translating_existing_variables.gif)

---

## FAQ(s)

**How do Variables work?**

Variables allow you to define specific content elements, such as product names or version numbers, in one place. Updating the variable automatically reflects the change across all relevant sections when this content changes, ensuring uniformity.

**What's the benefit of using Variables in my documentation?**

By using Variables, you ensure consistency in your documentation while minimizing the need for manual updates. This saves time, reduces errors, and maintains accuracy, especially when dealing with frequently changing information.

**Can I create my Variables in Document360?**

Document360 empowers you to create custom Variables tailored to your documentation needs. This allows you to adapt the feature to the specific terminology and elements relevant to your content.

**How do I use Variables in my articles?**

Insert the variable into the article content using the editor's toolbar or the merge code value, and it will dynamically pull the information you've defined, ensuring uniformity across your documentation.

**Can Variables be updated across multiple articles at once?**

When you update a Variable, the change is automatically reflected throughout all instances where that variable is used, making it easy to maintain consistent information across your entire knowledge base.

**Are Variables limited to specific types of content?**

Yes, Variables can be used for limited text, number, or link-based content, from product names and version numbers to URLs and contact information.

**How do Variables enhance collaboration among team members?**

Variables streamline the collaboration process by ensuring everyone is using the same accurate information. Changes to a variable are instantly updated across all articles, preventing discrepancies.

**Is using Variables a best practice in technical documentation?**

Using Variables is a best practice that improves technical documentation efficiency, consistency, and accuracy. It's particularly valuable when working with dynamic information that requires frequent updates.

**Can I translate variables into any language?**

You can translate variables into any of your project’s languages.

**Is the definition of a variable term created in the Knowledge base site indexed in search and by Google?**

Yes, the definition of a variable term created in the Knowledge Base (KB) site is indexed in both the site's search and by Google. Once the term is added, it becomes searchable on the website and will also be crawled and indexed by Google.

A powerful Document360 editor with rich text editing and Markdown support, offering a visual, flexible experience compared to the Markdown and basic WYSIWYG editors.

<a id="snippets"></a>

## Snippet

**Plans supporting content reuse**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

**Snippets** is a predefined set of content blocks the content manager or author uses as reusable content. The Snippet's content can vary from simple text or phrases to lengthy paragraphs, tables, images, and more. In Document360, the snippets are stored in a library, and you can easily insert them into articles during editing with just a click of a button.

> NOTE
>
> The Snippet will appear as regular content to the reader on the Knowledge Base site. The reader will not know that the content was rendered through Snippet.

---

## Creating a snippet

To create a snippet,

1. Navigate to **Documentation** () > **Content tools** > **Content reuse** > **Snippets** in the knowledge base portal.

   The **Snippets** page appears. If you have added any snippets earlier, you can see them listed here.
2. Click **Create snippets** at the top to select language-specific snippets(Global, English, French, etc.) added to your project.
3. Enter the **Name** for your snippet.

   > NOTE
   >
   > The snippet **name** can include letters, numbers, hyphens, and underscores, with a maximum length of 30 characters.
4. The **Merge code value** will be the snippet name that appears with the snippet tag in your editor.

   **For example,** if your snippet name is **Disclaimer**, then your Merge code value would be ***{{snippet.Disclaimer}}.***
5. In the **Language** selection dropdown, the default selection is **Global** (Available across all languages). However, if needed, you can choose a desired available language to create a language-specific snippet.
6. In the **Content** field, enter the snippet's content.

   By default, the snippet editor will be WYSIWYG (HTML). However, you can switch to the Markdown editor if required.

> NOTE
>
> Switching to Markdown:
>
> 1. Click **Switch to Markdown**.
> 2. Click **Proceed** in the **Change confirmation** prompt.
>
> **You will lose the WYSIWYG content when you switch to Markdown.**

7. Once done, click **Create snippet**.

![Adding a new snippet in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenGIF-Adding_a_Snippet.gif)

#### **Formatting options**

**WYSIWYG**

The below formatting options are available for snippet content in WYSIWYG:

![1_Screenshot-Formatting_options_available _in_snippet](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1724477524068.png)

* Basic text formatting options such as **Bold**, **Italic**, **Strikethrough**, and **Underline** are available.
* Additional formatting options include **Font size, Font Family, Text color, Background color, Subscript, Superscript, and Clear Formatting**.
* You can create **Ordered** and **Unordered Lists** for listing items.
* **Insert Image** allows you to insert an image from a URL, local storage, or Drive.
* **Insert Link** lets you add a hyperlink from a provided URL or link to a knowledge base article.
* You can use **Insert callouts** such as Info, Warning, Error, and Success.
* **Insert latex** lets you add expressions and equations:

  + Click the **Insert latex** option, and an **Insert latex expression** panel will appear.
  + Type your desired Latex syntax and click **Insert.**
  + [Read this article](http://docs.mathjax.org/en/latest/input/tex/macros/index.html) for basic Latex commands used in Latex syntax.
* **Insert table** allows you to create a table by selecting the required number of rows and columns.
* **Insert codeblock** lets you add codeblocks.

  + Click **Insert codeblock** and select the language of the desired code from the dropdown.
  + Add code in the **Insert your code** field and click **Insert.**
* You can preview the Snippet in **Code view** (HTML). Click **Code view** to view the preview. If you want to switch back to the editor view, click **Code view** again.

---

**Markdown**

Markdown is handy when significant text and minimal media are involved in the Snippet. You can use Markdown syntax manually while writing or formatting text using the Markdown toolbar.

**For example**, you can make a text appear bold by writing the respective syntax or using the Bold () icon in the Markdown toolbar.

![13_Screenshot-Makdown_options_available _in_snippet](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1724478140496.png)

* Basic text formatting options such as **Bold**, **Italic**, **Strikethrough** are available.
* **Block quote** lets you add block quotes.
* **Line** lets you insert a horizontal line.
* **Ordered List** and **Unordered List** are available for listing items.
* **Insert Table** allows you to create a table by selecting the required number of rows and columns.
* **Insert Image** allows you to insert an image from a URL, local storage, or Drive.
* **Insert Codeblock** lets you add code blocks:

  + Click **Insert Codeblock** and type the desired code inside the code block.
  + Example: ``code``.
* You can use **Insert callouts** such as Info, Warning, Error, and Success.
* **Insert latex** lets you add expressions and equations.

  + Click the **Insert latex** option, and a sample latex syntax () will appear.
  + Type your desired syntax.
  + The syntax must start and end with `$`.

> NOTE
>
> When adding latex, do not include a space between `$` and syntax. For more information, [read this article](http://docs.mathjax.org/en/latest/input/tex/macros/index.html) for basic latex commands.

* **Insert Link** allows you to add a hyperlink from a provided URL or link to a knowledge base article.
* **Glossary** lets you add glossary terms to your Snippet.

---

## Using snippet in the article

There are **two methods** by which you could add a snippet to your article.

#### Method 1: Using the syntax (Markdown editor)

In the Markdown editor, type a **snippet.MergeCodeValue** between closed double curly brackets.

> **Example**: *{{snippet.Disclaimer}}*

You must know the exact merge code value to add the desired snippet. The snippet will not work even if a single letter changes.

> NOTE
>
> Typing in *snippet.Merge\_Code\_Value* will only work in the Markdown editor. If you are using Advanced WYSIWYG editor, you can insert snippet using the toolbar.

#### Method 2: From the toolbar (Markdown, WYSIWYG, and Advanced WYSIWYG)

1. Click on Content reuse **()** for Markdown and WYSIWYG editor.   
   For the Advanced WYSIWYG editor, click on **Insert >** **Snippets****,** or using the slash "**/**" command you can access snippets.
2. Select the snippet or use the **Search snippets** bar to narrow down the snippet name.

> In the Advanced WYSIWYG editor, the **Snippets** pane appears on the right for snippet selection. Hover the pointer on the snippet name to preview its content.

3. Select the intended snippet to insert.

> NOTE
>
> If the **Insert as local copy** toggle is on, the snippet content added to the article will remain unchanged. The snippet in the article will not be affected if the selected snippet's content is modified or removed in the future.

![Inserting snippets in the article in the Knowledge base portal.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGIF-Inserting_Snippet__in_an_article.gif)

---

## Snippet overview page

You can view, edit, or delete a snippet on the **Snippets** page.

1. Navigate to **Documentation** () > **Content tools** > **Content reuse** > **Snippets** in the knowledge base portal.

   The **Snippets** page appears where you can find the list of snippets you have already added.

![Explaining the Snippet overview page](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Snippet_overview_page.png)

1. **Languages**: To filter the snippet in Global or a specific language.
2. **Search snippets**: Search the snippet list based on the name.
3. **Used in**: If a snippet is not added to any article/category page, the status would be `-`. If a snippet is added to any article/category page, you can click the **View** button to see the list of articles/category pages containing the snippet.
4. **Language**: The desired language of each snippet.
5. **Last modified**: The last time the snippet content was updated.
6. **Preview**: Click on the snippet name, and you can view the snippet's content.
7. **Progress**: Click the globe icon to view the snippet’s progress in multiple languages.
8. **Edit** () icon: To edit the snippet content.
9. **Delete** () icon: To remove the snippet.

---

### View article/category page dependency

In the **Snippets** page, you can find the **Used in** column.

1. In the **Used in** column, click on the **View** button.

   The **View references** panel will appear, where you can view the list of articles/category pages to which the snippet has been added.
2. Click on the article to expand the section.
3. You can find the following information:

   * The article version.
   * The project workspace and language.
   * The team account name and profile picture who has added the snippet.
   * The article states (Published, Draft, New Article).
   * The time/date information when the snippet was inserted in the article/category page.

![Viewing the dependencies of snippets](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_ScreenGIF-View%20article_Snippet_dependency.gif)

---

### Editing an existing snippet

1. Navigate to **Documentation** () > **Content tools** > **Content reuse** > **Snippets** in the knowledge base portal.

   The **Snippets** page appears. You can find the list of snippets you have already added.
2. Hover over the desired snippet and click the **Edit ()** icon.
3. After you complete the content edit, click on the **Update** button.

> NOTE
>
> When you update a snippet in the library, the changes are automatically reflected in all articles and category pages that use it. This includes published articles, which will be updated without needing to republish them.

![Editing the existing snippets](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_Screenshot-Edit_snippet.png)

---

### **Deleting a snippet**

1. Navigate to **Documentation** () > **Content tools** > **Content reuse** > **Snippets** in the knowledge base portal.

   The **Snippets** page appears. You can find the list of snippets you have already added.
2. Hover over the desired snippet and click the **Delete** () icon.
3. Click **Yes** in the confirmation prompt.

#### **To bulk delete multiple snippets**

Select multiple intended snippets from the **Snippets** page and click the **Delete** option at the top of the list.

![Deleting the snippets in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/6_ScreenGIF-Deleting_a_Snippet.gif)

---

## Translating snippets

You can create and manage snippets in multiple languages. This ensures that when your articles are translated, the snippets match the language of the article, providing a consistent and localized user experience.

> NOTE
>
> Global snippets cannot be translated.

#### Translating new snippets

1. Navigate to the **Documentation** () > **Content tools** > **Content reuse** > **Snippets** in the knowledge base portal.
2. Click **Create snippet**.
3. In the **Language** dropdown, select the intended language.
4. Enter the snippet **name** and the content for the snippet in English (or your default language).
5. Click **Switch to markdown** to change the content editor from WYSIWYG to the Markdown editor.
6. To translate the content into other languages, click the **Translate to other languages** dropdown.
7. Select the desired language(s) from the dropdown menu and click **Translate**.

> NOTE
>
> * The default language will be marked as **Main**.
> * Translated languages will be indicated with a green tick to show that the translation is complete. If needed, you can navigate to untranslated languages and complete their translation.

7. Once the translations are complete, click **Create snippet** to save the snippet along with its translations.

> For example, if you create a snippet for a welcome message in English, you can use the translation feature to add the same message in French, Spanish, German, etc.

![Translating the snippets in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/7_ScreenGIF-Translating_snippets.gif)

#### Translating existing snippets

1. Click the desired existing snippet you wish to translate.
2. Navigate to **Translate to other languages** and select the desired language that the snippet needs to be translated.
3. Click **Translate**.
4. If needed, you can navigate to other languages and again translate into those languages.
5. To translate the content again, click **Translate again**. This will overwrite the existing translation with a new one.
6. If you need to remove the translated snippet for a specific language, click **Remove language**.

   You can retranslate the content at any time if needed.

![Translating the existing snippets](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/8_ScreenGIF-Translating_existing_snippets.gif)

---

## FAQs

**How many snippets can be created in one project?**

You can create up to 200 snippets in a single project. If you need more, additional snippets can be purchased as an add-on.

**Can I change the name of a snippet after it has been created?**

While you can edit the contents of a snippet, its name cannot be changed after creation.

**Why is a snippet inserted in a new line?**

Snippets are designed as new blocks of content, allowing for multiple lines to be added within them. As such, they will always start from a new line to maintain structure and clarity.

One of the three editors in Document360, WYSIWYG (What You See Is What You Get) is a content editing tool that shows the final output as writers create and format content.

A powerful Document360 editor with rich text editing and Markdown support, offering a visual, flexible experience compared to the Markdown and basic WYSIWYG editors.

<a id="glossary"></a>

## Glossary

**Plans supporting content reuse**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

A glossary helps readers easily understand frequently used terms, such as words, phrases, acronyms, or abbreviations. By adding a glossary to your knowledge base, you provide quick, convenient access to definitions, making your content more user-friendly and informative.

Glossary terms are visually marked with a dotted underline in your articles and category pages. Readers can hover over these terms to view the definition, ensuring they stay informed without navigating away from the page. You can reuse glossary terms throughout your content as needed. For example, when adding the acronym *GDPR*, you can define it as "General Data Protection Regulation," and the term will be consistently used across all relevant articles.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1.%20Glossary%20-%20View%20in%20site.png)

> NOTE
>
> Glossary terms are available in both the Knowledge Base and Knowledge Base Assistant.

---

#### Why add a glossary to your Knowledge base?

Including a glossary in your documentation improves both the reader experience and the accuracy of your content. Here’s how:

1. **Improved readability**: Glossary terms allow readers to get instant definitions for complex terms without leaving the page, reducing confusion and ensuring better comprehension.
2. **Consistency**: Once a term is added to the glossary, it can be reused across multiple articles, ensuring that terminology is defined consistently across your entire knowledge base.
3. **Time-saving for writers**: Technical writers no longer have to define terms in each individual article, which reduces redundancy and speeds up the content creation process.
4. **Product-specific education**: You can use the glossary to define product-specific terms or industry jargon, helping readers get familiar with your terminology and enhancing their understanding of your product.

---

## Managing glossary terms

Accessing and managing your glossary is straightforward. Navigate to **Content tools** > **Content reuse** > **Glossary** to view your existing glossary terms. Here’s a breakdown of the key features for managing glossary terms:

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2.%20Glossary%20-%20Overview%20page.png)

1. **Languages**: Use the language filter to sort glossary terms by specific languages. Terms marked as "Global" represent glossary terms available across all languages in your knowledge base.
2. **Create**: Add new glossary terms individually or import multiple terms in bulk to streamline content creation.
3. **Export CSV**: Export selected glossary terms as a CSV file for external use, enabling easy sharing or backup.
4. **Search term**: Search for glossary terms by name. Hover over the **Preview** () icon to see a quick definition.
5. **Used In**: If a glossary term is linked to any articles or category pages, the **View** option appears.

   Click **View** to open the **View references** pop-up showing all associated articles or categories. The pop-up also displays the workspace and language of each article.

   Use the dropdown next to each article/category name to see detailed information such as article status, version, a link to view the article in the knowledge base portal, contributor profile image, name, and last updated date.
6. **Language**: Displays the language in which the glossary term is available.
7. **Last Modified**: Shows the most recent time and date the glossary term was updated.
8. **Edit**: Update the glossary term or its content. Note: The term’s language cannot be changed.
9. **Delete**: Remove the glossary term from the knowledge base.
10. **Items on Page/Total Items**: Displays the number of glossary terms shown per page and the total number of terms in the glossary.
11. **Use Eddy AI for glossary generation**

    Leverage **Eddy AI’s glossary generation** to automate the process of creating glossary terms for key phrases and acronyms in your knowledge base. This AI-powered feature analyzes your content and suggests terms that can be defined, saving you time and ensuring your documentation is thorough. For large projects, this feature is especially helpful, as it ensures that all relevant terminology is consistently captured. For more information, read [AI glossary generator](/help/docs/ai-glossary-generator).

---

#### SEO and search benefits of glossary terms

By defining industry-specific terms in your glossary, you’re not only helping your readers but also improving your knowledge base’s SEO. Glossary terms can increase the relevance of your documentation in search engine results by associating definitions with keywords, making it easier for users to find your content online

---

## Quick navigation for glossary management

### Adding glossary terms

* [How to add a glossary term?](/help/docs/adding-glossary-term)
* [How to add a glossary term in articles?](/help/docs/adding-glossary-term-in-articles)
* [How to import the glossary?](adding-glossary-term#importing-glossary-terms)

### Managing glossary terms

* [How to edit a glossary term?](/help/docs/editing-and-deleting-glossary-term#editing-a-glossary-term)
* [How to delete a glossary term?](/help/docs/editing-and-deleting-glossary-term#deleting-a-glossary-term)
* [How to delete multiple glossary terms?](/help/docs/editing-and-deleting-glossary-term#deleting-multiple-glossary-terms)

### Navigation links for glossary

* [How to add the glossary overview page link in the header?](/help/docs/glossary-overview-page#how-to-add-the-glossary-library-page-link-in-the-header)
* [How to add the glossary overview page link in the footer?](/help/docs/glossary-overview-page#how-to-add-the-glossary-overview-page-link-in-the-footer)
* [How to add the glossary overview page link in the menu?](/help/docs/glossary-overview-page#how-to-add-the-glossary-overview-page-link-to-the-menu)
* [How to add the glossary overview page link on the Home page?](/help/docs/glossary-overview-page#how-to-add-the-glossary-overview-page-link-on-the-home-page)

---

### FAQs

#### How do I add a glossary term to my articles?

You can add glossary terms by navigating to **Content tools > Content reuse > Glossary**, then create a new term. Once added, the term can be used in your articles, and readers can hover over it to view the definition.

#### Can I import multiple glossary terms at once?

Yes, you can bulk import glossary terms using the import option in the Glossary section. This is useful for large projects where multiple terms need to be added quickly.

#### What happens if I delete a glossary term?

When a glossary term is deleted, it is removed from all articles where it was used. The term will no longer display as a hoverable definition for readers.

#### Can glossary terms be filtered by language?

Yes, you can filter glossary terms by language. Terms marked as "Global" will be available across all languages in your knowledge base.

#### How can I track where glossary terms are used?

You can click on the **View** option next to any glossary term to see a list of articles or categories it is associated with, including details like article status, version, and contributors.

#### Does the glossary setting change when I switch between workspaces?

No, glossary settings, along with other content tools such as snippets, templates, variables, and tags, are configured at the project and not at the workspace level. This means that when you switch between workspaces, the glossary and other content tool configurations remain unchanged. Each project retains its unique settings regardless of the workspace you are in.

<a id="adding-glossary-term"></a>

## Adding glossary terms

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

In Document360, you can easily add glossary terms at any time, making it a quick process that takes just a few seconds.

---

## Adding a glossary term

1. Log in to the ****Knowledge base portal**** and navigate to your project.
2. Select the ****Documentation**** tab and click on ****Content tools**** from the left navigation list pane.
3. Navigate to ****Content tools**> **Content reuse** > **Glossary****. Here, you’ll see a list of existing glossary terms (if any have been added).
4. Click **Create** to create a new glossary term.

   Alternatively, click the dropdown to import terms as a CSV file. For detailed instructions on importing terms, refer to [Import Glossary Terms](adding-glossary-term#importing-glossary-terms).
5. Enter the desired term in the provided field.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Create%20glossary%20-%20English.png)

   When adding a glossary term, you will encounter four fields: **Name**, **Language**, **Term**, and **Content**.

   1. **Name:**

      * This field allows you to give a specific name to the glossary term, which will be used for reference.
      * The character limit for the Name is **100 characters**.
   2. **Language:**

      * Choose the appropriate language for the glossary term from the dropdown menu.
      * If you select a language other than **Global**, the option to translate the term into other languages will be enabled.
   3. **Term:**

      * This field is where you enter the actual term or phrase you want to define.
      * The character limit for the Term is also **100 characters** including spaces. Acceptable inputs include letters, numbers, spaces, and special characters such as () - \_ & : ; ? / . , [ ] @ # ! \*.
   4. **Content:**

      * In this field, you can provide a detailed definition or explanation of the term.
      * The character limit for the Content is **500 characters**.
   > NOTE
   >
   > When translating a term into another language, you can use the name for reference across all languages.

6. Once completed, click **Create glossary** to finalize the addition.

   > NOTE
   >
   > When translating an article into other languages, machine translation credits are consumed based on the number of characters.

### Formatting options

Basic text formatting options include:

* Bold
* *Italic*
* Underline
* ~~Strikethrough~~

You can also access additional formatting features, such as:

* Font size
* Font family
* Text color
* Background color
* Subscript and superscript
* Clear formatting

For item lists, you can use Ordered list and Unordered list options.

To insert images, use the **Insert image** feature to upload from a URL, local storage, or Drive. You can also view the snippet in **Code view (HTML)** and switch back to **Editor view** as needed.

> NOTE
>
> If a glossary term is added under "All," it cannot be added at the language-specific level. For example, if you want to define "TXT record" in multiple languages, create a glossary term in English and translate it to other languages. Use the Name field to identify the term across all languages. A term designated as Global cannot be language-specific.

For a better understanding of how a business glossary can help your Knowledge base, read our blog: [**Importance of business glossary in knowledge management**](https://document360.com/blog/knowledge-management-business-glossary/)**.**

---

## Importing glossary terms

You can also effortlessly import multiple glossary terms using the **Import glossary** option. Before importing, you need to prepare a CSV file with glossary terms and their corresponding definitions.

### Import glossary template

You can create a CSV file matching the required template or download a sample to populate your data.

#### Sample CSV format

| Term | Definition |
| --- | --- |
| First term | First term definition |
| Second term | Second term definition |
| Third term | Third term definition |

#### Download sample CSV file

You can download one of the following templates for local use:

* **With data** - Includes sample terms and definitions.

Import glossary - With data

761 Byte

* **Without data** - Contains only row headers.

Import glossary - Without data

20 Byte

> NOTE
>
> Use software like Microsoft Excel, OpenOffice Calc, or Google Docs to open and edit the CSV file.

### Importing glossary terms using the CSV file

Once your CSV is ready, upload it to the platform and start using the glossary terms in your articles and category pages.

1. Navigate to ****Content tools** > **Content reuse** > **Glossary**** in the Knowledge Base portal.
2. Click **Create > Import terms**, and the import popup will appear.
3. Drag and drop the CSV file or use the **Upload** option to select the file from your device.

   Wait a few seconds for validation. The system will display the number of valid and invalid terms.

   If any terms are invalid, click **Download** next to the error count to review the errors, such as "Already associated term" or "Definition exceeds 500 characters."
4. Click **Import**, and the newly added terms will appear in the Glossary overview.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Import%20glossary%20terms.png)

This feature streamlines the glossary management process, saving you time when handling large sets of terms and definitions.

---

## Troubleshooting

### CSV upload error

If you encounter an error message like *"Please make sure the CSV follows the sample template"* when uploading a glossary CSV file, it may be due to the language settings in your Excel application.

**Cause:** The headers in the template file may have been altered if your Excel language is set to anything other than English. The system cannot detect modified headers, leading to upload failure.

**Resolution:** Follow these simple steps to fix the problem:

* Check and change Excel regional settings (Office 365 Web Application)

1. Open the glossary CSV template in Excel.
2. If you are using **Excel in Office365 (Web Application):**

   1. Go to **File > Options > Regional Settings** in Excel.
   2. In the **Change Regional Format Settings** pop-up, select *English (United Kingdom)* from the dropdown in the **Select your preferred regional format for Excel for the web** field.

* Change regional format in Windows:

1. Open Settings in Windows.
2. Navigate to **Time & Language** > **Language & Region**.
3. Change the regional format to **English (United Kingdom)**.

   Once done,
4. Close and reopen the glossary CSV template in Excel.
5. Ensure the headers match the sample template exactly.
6. Save the file again to ensure the correct headers remain intact.
7. Retry uploading the CSV file.

If the issue persists after following these steps, please contact the Document360 support team for further assistance: [Contact Document360 Support](https://document360.com/support/)

---

### FAQs

#### Can I add images to the glossary while importing glossary terms from a CSV file?

Only web images can be imported through definitions. Use the tag `<img src="Image_URL"/>` in your definition cell to add images.

For example, to include an image for "JSON Web Token," add the definition in the CSV as: `JSON Web Token <img src="https://jwt.io/img/logo-asset.svg"/>`

Imported images are stored in the Glossary folder in **My Drive** > **Images** > **Glossary**.

#### How do I add a hyperlink inside a glossary?

You can embed a hyperlink within a glossary definition using HTML tags in the **Code view** of the Glossary editor.

**Example:** If you want to hyperlink the word "Google" to `google.com` in the glossary definition, follow these steps:

1. Navigate to the desired glossary and click **Edit** ().
2. In the editor section, click the **Code view** () icon.
3. Add the hyperlink in HTML format as shown below.

```
<p><a href="https://google.com/">Google</a></p>
```

HTML

Copy

4. Click **Update** to save your changes.

Now, when users hover over this glossary term on the Knowledge base site, they can click "Google" to navigate to `google.com`.

<a id="adding-glossary-term-in-articles"></a>

## Inserting glossary term in an article

**Plans supporting content reuse**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Glossary terms are essential for improving your readers' understanding of frequently used terms, abbreviations, acronyms, and industry-specific jargon. By incorporating glossary terms into your articles and category pages, you ensure that readers can easily grasp complex concepts without leaving the content. Glossary terms are visually marked with a dotted underline, allowing users to hover over them for instant definitions. Here's how you can add glossary terms across different editors in Document360.

---

### How to add glossary terms in the Markdown editor?

The Markdown editor allows you to seamlessly add glossary terms to enhance your articles. You can do this using two methods:

#### Method 1 - Using the menu option

1. Open the desired article in the Markdown editor.
2. In the toolbar, click on the **Glossary** icon.
3. The **Insert glossary term(s)** menu will appear, displaying a list of all available glossary terms.
4. Click the checkbox next to the term(s) to select the term(s) you want to insert into your article.
5. Click **Insert**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Glossary%20in%20markdown%20editor.png)

Your selected glossary terms will now be added to the article, enriching the reader's experience.

#### Method 2 - Using the Markdown syntax

If you prefer to use the Markdown syntax or need to manually input a term, follow this method:

1. Open the desired article in the Markdown editor.
2. Enter the following syntax:  
   `{{glossary.Term_name}}`
3. Replace `Term_name` with the exact name of the glossary term you want to add.

> NOTE
>
> Glossary terms are case-sensitive and must match exactly, including any spaces. To find the exact term name, refer to the Glossary section in your Document360 portal.

### How to add glossary terms in the WYSIWYG editor (HTML)?

If you’re working in the WYSIWYG editor, adding glossary terms is simple and efficient. Follow these steps:

1. Open the desired article in the **WYSIWYG editor**.
2. Click on the **Glossary** option in the toolbar.
3. The Insert glossary term(s) pop-up window will appear with a list of available glossary terms.
4. Click the checkbox next to the term(s) to select the term(s) you want to insert into your article.
5. Click **Insert**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Glossary%20in%20WYSIWYG%20editor.png)

The glossary terms will now be embedded within your article, improving clarity and reader engagement.

### How to add glossary terms in the Advanced WYSIWYG editor?

For more advanced formatting or content management needs, the Advanced WYSIWYG editor also supports glossary terms. Here’s how to do it:

1. Open the article in the **Advanced WYSIWYG editor**.
2. Click on the **Insert** menu in the toolbar.
3. From the dropdown, select **Glossary**.
4. A blade will appear, displaying all available glossary terms.
5. Use the search function to find the specific term you want.
6. Click on the term to insert it into the article.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Glossary%20in%20Advanced%20WYSIWYG%20editor.png)

The merge code value will appear in the article: `{{glossary.Term_name}}`

> NOTE
>
> While in the editor, you won’t see a live preview of the glossary term. To see how the glossary will appear to readers, click the **View preview** button in the toolbar. This will allow you to view the article with the glossary terms fully rendered, ensuring they are correctly placed.

<a id="editing-and-deleting-glossary-term"></a>

## Managing glossary terms

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

## Translating glossaries

You can create and manage glossaries in multiple languages, ensuring a consistent and localized user experience when your articles are translated.

1. Navigate to the ****Documentation****() > ****Content tools**** > ****Content reuse**** > ****Glossary**** in the knowledge base portal.
2. Click **Create**.
3. In the **Language** dropdown, select the intended language (except global).
4. Enter the Glossary **Name, Term** and **Content** in English (or your default language).
5. Click the **Translate to other languages** dropdown to translate the term and content into other languages.
6. Select the desired language(s) from the dropdown menu and click **Translate**.

> NOTE
>
> * The default language will be marked as **Main**.
> * Translated languages will be indicated with a green tick to show the complete translation. If needed, you can navigate to specific languages and complete their translation.

7. Once the translations are complete, click **Create glossary** to save the glossary along with its translations.

![Translating the glossaries in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenGIF-Translating_the_glossary.gif)

---

## Editing a Glossary term

You can edit glossaries in Document360 by following these steps:

1. Navigate to Documentation () > **Content tools** > **Content reuse** > **Glossary** in the knowledge base portal.

   The **Glossary** page appears. If you have added any glossaries earlier, you can see them listed here.
2. Hover over the desired glossary and click the Edit **()** icon.
3. You can update the term and definition of the glossary.
4. Navigate to **Translate to other languages** and select the desired language in which the glossary needs to be translated.
5. Click **Translate**.
6. If needed, you can navigate to other languages and translate them.
7. To retranslate the content, click **Translate again**, which will overwrite the existing translation with the new one.
8. If you need to remove the translated glossary for a specific language, click **Remove language**.
9. Once you have made changes, click **Update**.

> NOTE
>
> Global glossaries can be translated.

![Translating, editing a glossary in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenGIF-Editing_the_glossary.gif)

---

## Deleting a Glossary

To delete a glossary term,

1. Navigate to Documentation () > **Content tools** > **Content reuse** > **Glossary** in the knowledge base portal.

   The **Glossary** page appears. You can find the list of glossaries you have already added.
2. Hover over the desired glossary and click the **Delete** () icon.
3. Click **Yes** in the confirmation prompt.

#### To bulk delete multiple terms

Select multiple intended glossaries from the **Glossary** page and click the **Delete** option at the top of the list.

![Deleting a glossary in the Knowledge base portal](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3-ScreenGIF-Deleting_the_glossaries.png)

> **NOTE**
>
> When deleting a term with dependencies, please follow the below instructions to avoid glossary content loss in articles:
>
> 1. Navigate to the desired glossary term and click on the **View** option.
>
>    The **View references** panel will appear, where you can view the list of articles/category pages to which the glossary has been added.
> 2. Click on the Open in new window () icon and open the article in the portal.
> 3. Manually remove the glossary term.
> 4. Navigate back to the glossary page and click **Delete**.

---

## Exporting glossary terms

You can easily export the glossary terms from your knowledge base project as a CSV (Comma Separated Values) file. This feature allows you to back up your glossary data or share it with your team for further analysis.

To streamline the export process, you can download glossary terms specific to a particular language within your project.

To export your glossary terms,

1. Navigate to **Documentation** > **Content tools** > **Content reuse** > **Glossary**.
2. Select the desired language from the **Languages** dropdown at the top.  
    The default selection is **Global**.
3. Click the **Export CSV** button at the top right.
4. Wait for a few seconds to let Document360 compile the terms.
5. A file with a (.csv) extension is downloaded to your local device storage.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Glossary%20-%20Export%20CSV%20option.png)

> NOTE
>
> To open the exported CSV file, you can use Microsoft Excel, OpenOffice Calc, Google Docs, or other CSV tools.

### What data is included in the exported file?

The exported CSV file contains the following information:

* **Glossary Name:** The name of each glossary term.
* **Glossary Definition:** The definition associated with each term.
* **Dependencies:** The number of articles or categories linked to each glossary term.
* **Updated By:** The name of the user who last updated the term.
* **Updated On:** The date when the term was last modified.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Glossary%20-%20Export%20as%20CSV.png)

By exporting your glossary terms, you ensure easy access to important definitions and enhance collaboration within your team. If you have any questions about this process, feel free to consult our support resources for further assistance.

<a id="glossary-overview-page"></a>

## Managing the glossary landing page

**Plans supporting content reuse**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Readers can access all the glossary terms in the selected language knowledge base on the glossary overview page. You can find the alphabetical list of words at the top, where you can navigate to the desired alphabet glossary. Here's your glossary overview page link:

> `https://yourdomain/docs/glossary-overview`  
>  Replace the <yourdomain> with your Knowledge base site domain

---

### Adding the Glossary library page link in the header

1. Navigate to **Settings** > **Knowledge base site** > **Customize site** from the Knowledge base portal.
2. Select the **Customize site** and select the **Header** dropdown menu.
3. Select **Primary navigation**, and click **Add new item** under left side or right side.

   An **Add new item** panel appears.
4. Select **Glossary** in the dropdown.
5. Add the desired text in the Glossary definition. This text appears on the Knowledge base site.
6. If you want the glossary overview page to appear in a new tab, enable the **Open link in new tab** toggle next to the glossary definition.
7. Click **Save**.

![Portal_Screenshot-Update_Add_glossary_in_header](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Portal_Screenshot-Update_Add_glossary_in_header.png)

#### Outcome

![Outcome_Screenshot-Update_Add_glossary_in_header_outcome](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Outcome_Screenshot-Update_Add_glossary_in_header_outcome.png)

### Adding the glossary overview page link in the footer

1. Navigate to **Settings** > **Knowledge base site** > **Customize site** from the Knowledge base portal.
2. Select the **Customize site** and select the **Footer** dropdown menu.
3. You can either configure with **Basic footer** or **Custom footer**.

**Basic footer**  
 If you're using the Basic footer option, follow the below steps:  
 \* Select **Basic footer**, and click the **Add new link** button.  
 \* Add the Link name as Glossary (You can change it as per your requirement).  
 \* Type in your glossary overview page URL \*`https://yourdomain/docs/glossary-overview`.  
 \* Once done, click **Add**.  
 \* Click on the **Save** icon > **Publish** to publish the changes in the KB site.

**Custom footer**  
 If you're using the custom footer option, add the glossary overview page URL  
`https://yourdomain/docs/glossary-overview` in the desired code location and click **Save**.

![Portal_Screenshot-Update_Add_glossary_in_footer](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Portal_Screenshot-Update_Add_glossary_in_footer.png)

#### Outcome

![Outcome_Screenshot-Update_Add_glossary_in_footer_outcome](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Outcome_Screenshot-Update_Add_glossary_in_footer_outcome.png)

---

### Adding the glossary overview page link to the Secondary navigation

1. Navigate to **Settings** > **Knowledge base site** > **Customize site** from the Knowledge base portal.
2. Select the **Customize site** and select the **Header** dropdown menu.
3. Select **Secondary navigation**, and click **Add new item**.

   Make sure the **Show in home page** check box is enabled.
4. You can either configure with **Single level**, **Multiple level** or **Ticket deflector**.
5. Add the desired **title** and type in your glossary overview page URL `https://yourdomain/docs/glossary-overview` in the **link** field.
6. Click **Add**.

![Portal_Screenshot-Update_Add_glossary_in_mrng](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Portal_Screenshot-Update_Add_glossary_in_mrng.png)

#### Outcome

![Outcome_Screenshot-Update_Add_glossary_in_the_Menu](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Outcome_Screenshot-Update_Add_glossary_in_the_Menu.png)

You can also add a glossary overview page link in any other section on the Home page as per your requirement.

<a id="feedback-manager-overview"></a>

## Feedback manager

**Plans supporting feedback manager**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The Feedback manager is a content tool in Document360 designed to help you track, evaluate, and respond to feedback from readers on your knowledge base. It is a powerful tool for addressing user concerns and identifying areas where your content may need improvement.

---

## Feedback manager overview

### Accessing the Feedback manager

To access the Feedback manager in Document360,

1. Navigate to **Documentation** () > **Content tools** > **Documentation** > **Feedback manager** in the Knowledge base portal.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Feedback_manager_overview(1).png)

### Features of the Feedback manager

The Feedback manager includes two tabs, each serving a specific purpose in managing reader feedback. Both tabs share similar features, such as filtering, assigning feedback, setting feedback status, and exporting feedback data for further analysis.

#### Article feedback tab

The **Article Feedback** tab compiles feedback directly related to individual articles or categories within your knowledge base. This includes reader comments, positive or negative ratings, and any specific concerns raised about the content.

Readers indicate whether an article was helpful by selecting the  **Yes** or  **No** options at the end of each article. If they select  **Yes**, they can add an optional comment. If they select  **No**, they can choose from options like “Need more information” or *“*Difficult to understand” and may add additional feedback. All responses appear in the **Article feedback tab**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Feedback_manager_article_feedback.png)

#### No search results feedback tab

The **No search results feedback** tab captures feedback from readers who did not find results for their search queries. This feedback is useful for uncovering gaps in content or identifying keywords to improve search relevance.

When a reader does not find any results for a particular search query or keyword, they can share their feedback. All feedback is compiled in the **No search results feedback** tab.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Feedback_manager_no_search_results_feedback.png)

---

## Managing feedback in the Article feedback tab

The feedback in the **Article feedback** tab are user feedback related to articles in your knowledge base. You can use this tab to understand the satisfaction of readers with your articles and find opportunities for improvement.

### Reader actions

At the end of each article, readers can show if the article was helpful or not by,

* **Selecting Yes**: Readers can optionally add a comment about why they found the article helpful.
* **Selecting No**: Readers can choose from reasons (like "Need more information" or "Difficult to understand") and add more comments if needed. If the reader wishes to be informed if you reply to their feedback, they can select the **Notify me about updates** checkbox.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Article_feedback_reader_actions.png)

### Responding to article feedback

To respond to feedback in the **Article feedback** tab, follow these steps:

1. **Select feedback**: Choose an item from the list in the **Article feedback** tab.
2. **Review the feedback**: Read through the reader’s comments to understand their input.
3. **Open the associated article**: The article linked to the feedback is displayed in the top right corner. Click the  icon to open the article in the editor in a new tab.
4. **Assign the feedback**: If necessary, assign the feedback to a team member by selecting their name from the **Assignee** dropdown.
5. **Discussions & history**: Update the feedback with any comments/responses related to the feedback in the **Discussions & history** field.

6. **Update the Feedback Status**: Select a status from the **Status** dropdown to indicate the feedback’s progress. The available statuses are:

   1. **Open**: Feedback is assigned the **Open** status by default, indicating it is yet to be addressed.
   2. **Planned**: The **Planned** status shows that the feedback has been reviewed and scheduled for future action.
   3. **In progress**: Set to **In progress** when a team member actively works on the feedback.
   4. **Complete**: When the feedback has been addressed, assign it the **Complete** status. You can still add comments to feedback marked as **Complete** if needed.
   5. **Closed**: The **Closed** status indicates that the feedback is no longer active, and no further actions can be performed.

> NOTE
>
> If the reader has requested a response for their feedback, enable the **Notify end user/reader** toggle after adding your response in the **Discussions & history** field. When you post a response with this toggle enabled, the feedback status will automatically change to **Closed**.

By addressing feedback in this tab, you can enhance the quality and relevance of your articles, ensuring a better experience for your readers.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Article_feedback_steps.png)

---

## Managing feedback in the No search results feedback tab

The **No search results feedback** tab collects feedback from readers who couldn’t find results for their search queries. You can use this feedback to identify content gaps in your knowledge base or adjust keywords to improve search results.

### Reader actions

If a search yields no results, readers can submit feedback to let you know what information they seek. If the reader wishes to be informed if you reply to their feedback, they can select the **Notify me about updates** checkbox.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Search_results_feedback_reader_actions.png)

### Responding to No search results feedback

To respond to feedback in the *no search results feedback* tab, follow these steps:

1. **Review the search query**: Check the search query provided by the user. This information helps you understand what the reader was looking for but couldn’t find.
2. **Understand the feedback**: Read any additional comments from the user to gain more context about their needs.
3. **Assign the feedback**: Use the **Assignee** dropdown to assign the feedback to a relevant team member.
4. **Take action**: Decide the necessary steps to address the feedback, such as creating new content, updating existing articles, or adding relevant keywords to improve search results.
5. **Discussions & history**: Update the feedback with any comments/responses related to the feedback in the **Discussions & history** field.
6. **Update the status**: Use the same status options as in the **Article feedback** tab (Open, Planned, In Progress, Complete, and Closed) to track the feedback’s progress.

> NOTE
>
> If the reader has requested a response for their feedback, enable the **Notify end user/reader** toggle after adding your response in the **Discussions & history** field. When you post a response with this toggle enabled, the feedback status will automatically change to **Closed**.

By addressing feedback in this tab, you can close content gaps and improve the search experience for your readers.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Search_results_feedback_steps.png)

---

## Additional features

Both feedback tabs include tools to make feedback management easier:

* **Filters**: Filter feedback by status, date, assignee, or other options to quickly find what you need.
* **Bulk actions**: Apply actions to multiple feedback entries simultaneously, like assigning feedback or updating statuses.
* **Export to CSV**: By default, feedback data from the past 90 days will be exported for analysis or record-keeping.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_Screenshot-Feedback_manager_additional_features.png)

---

### FAQs

**What is the difference between "Complete" and "Closed" in the Feedback Manager?**

In the Feedback manager, the status **Complete** indicates that the feedback has been fully addressed, while **Closed** signifies that all actions related to the feedback are resolved. Once the feedback is closed, it cannot be reopened, whereas feedback in **Complete** status can be set to **Open** if needed.

**For example**:  
Let's say a user submits feedback about an issue with a feature. Once the team reviews and addresses the feedback, they mark it as **Complete** to show the work is done. However, if the user later reports that the issue isn't fully resolved, the team can change the status from **Complete** back to **Open** to continue working on it.

On the other hand, if the feedback is not in scope or the team finishes all related actions, such as updating the documentation and informing the user, they mark the feedback as **Closed**. Once feedback is **Closed**, it cannot be reopened for further changes.

**Can I export the data from the Feedback manager?**

Yes, you can export data from the feedback from the Feedback manager for a maximum of up to 90 days.

<a id="custom-pages"></a>

## Custom pages

**Plans supporting Custom pages**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The **Custom pages** featurein Document360 allows you to create dedicated, standalone pages for your Knowledge base site. Custom pages are separate from standard articles and provide the flexibility to add content like Terms & Conditions, Privacy policies, Copyrights. With options for customization, multilingual support, and navigation configuration, Custom pages can enhance the user experience of the Knowledge base site and keep your content organized.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Custom_pages_overview.png "Custom page overview - figma(1).png")

> NOTE
>
> This feature is exclusively available for **KB site 2.0** projects.

## Creating a Custom page

Users with Draft writer, or Editor content roles can create a custom page in the Knowledge base portal. You can also create custom roles with exclusive permissions for custom pages.

To create a custom page,

1. Navigate to **Documentation** () > **Content tools** > **Custom pages** in the knowledge base portal.
2. Click on the **Create page** button to open the **Create custom page** popup.
3. In the Create custom page popup, enter the page name and optional description for the custom page. Select the language for the Custom page from the language dropdown.
4. Click **Create** to open the editor.
5. In the editor, enter the desired content for your Custom page.

> NOTE
>
> Users with **Draft writer**, or **Editor** content roles can create a custom page in the Knowledge base portal. You can also create custom roles with exclusive permissions for custom pages.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_GIF-Creating_custom_page.gif "Create custom page - figma.png")

The editor provides Advanced WYSIWYG options, allowing you to format text, add images, and structure content as needed.

* **Add and format content**: Add content, images and use other formatting and insert options to organize the content as needed.
* **Set SEO details**: Navigate to **More** () > **SEO**, and enter the **Meta title**, **URL slug**, and **Description** for your custom page.
* **Collaborate with team members**: Add inline comments directly on the content, allowing others to provide feedback and suggestions.

Once you have finished creating your custom page, click **Publish** to go live.

> NOTE
>
> To keep a custom page in draft mode, save your content without selecting **Publish**. This keeps the page hidden from the live site until it’s ready to be published.

---

## Managing a Custom page

You can easily manage your custom pages from the **Custom pages** list in **Content tools**.

### Editing a custom page

To edit an existing custom page,

1. In **Content tools** > **Custom Pages**, select the page you wish to edit, and click **Edit** ().
2. Make the desired updates in the editor, such as changing text, images, or page details.
3. **Save** any changes to keep your draft updated or **Publish** to make it live immediately.

### Deleting a custom page

To delete a custom page,

1. In **Content tools** > **Custom Pages**, select the page you wish to delete, and click **Delete** ().
2. Once you click Delete, the **Delete confirmation** popup will open.
3. Click **View dependencies** to see the articles and KB Customizations that use the custom page.
4. Click **Delete** to permanently delete the custom page.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_GIF-Deleting_custom_page.gif "Delete custom page dependencies - figma.png")

> NOTE
>
> Deleted pages cannot be restored, so ensure the page is no longer needed before deleting.

### Cloning a custom page

In **Content tools** > **Custom Pages**, select the page you wish to clone, and click **Clone** (). A duplicate custom page will be created with the prefix **“Clone -”**.

For example, if a clone a custom page titled *Terms and Conditions*, the duplicate custom page will be titled *Clone - Terms and Conditions*.

---

## Multilingual custom pages

Custom pages support machine translation, enabling you to provide content in multiple languages. To translate the custom pages to another language,

1. Click the language dropdown from the top right of the editor to view the available languages.
2. Select the desired language from the dropdown to enable the **Translate** dropdown.
3. Expand the Translate dropdown to view the number of characters to be translated, and the number of characters available for machine translation.
4. Click Translate to translate the contents of your custom page to the desired language.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_GIF-Translating_custom_page.gif "Translate custom page - figma.png")

---

## Try this feature

Once created, custom pages can be added to your Knowledge base site’s navigation. You can integrate a custom page into the site’s [**header**](/help/docs/header-primary-navigation)or [**footer**](/help/docs/footer-navigation), making it visible across your knowledge base.

To add a custom page to the header or footer, go to **Customize Site** in the **Knowledge Base Site** settings, where you can choose the location and display options.

* To add a custom page to a header, select **Custom page** from the list of navigation menus under **Primary navigation**.
* To add a custom page to a footer, enter your desired title, and a link to the Custom page while adding a new link to the footer.

To see custom pages in action, explore the interactive demo below, which showcases how to create and integrate a custom page seamlessly into your Knowledge Base site:

---

### FAQs

**How many custom pages can I create?**

Each project allows up to 5 custom pages by default, with options to add more depending on your plan.

**Can I make a custom page private?**

Yes, you can restrict access to custom pages based on user roles in your knowledge base settings.

**Where will custom pages appear?**

They can be included in the left navigation or placed in the header or footer for quick access across the site. If a custom page is publishing, but not included in the header or footer, only users with a link to the custom page can access it.

**What can I do if I accidentally delete a custom page?**

Deleted pages cannot be restored, so always double-check before deleting.

<a id="tags"></a>

## Tags

**Plans supporting tags**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Tags in Document360 help you easily identify, filter, navigate, and group related articles, category pages, or files within your knowledge base.

---

## What are tags?

A tag is a simple label made up of letters, numbers, words, or phrases that describe the content of an article, category page, or file.

For example, if an article covers software installation, you can apply the tag *Installation*. When readers see this tag next to the article, they’ll instantly know what to expect.

### How tags improve your experience

* Simplify team and reader navigation (via identification, filtering, and browsing)
* Group similar articles or files for easier access
* Improve keyword searches within your knowledge base
* Boost visibility on third-party search engines by generating unique URLs for tags

> NOTE
>
> Try the [AI Tag recommender](/docs/ai-tag-recommender) to automatically generate and apply relevant tags to your content.

### Best practices for using tags

| Do’s | Don’ts |
| --- | --- |
| Keep tags concise | Overuse tags on a single page |
| Use broad category terms | Assign irrelevant or redundant tags |
| Ensure tag consistency across your knowledge base | Make spelling or semantic errors in tag names |

---

## FAQs

**Can I assign multiple tags to a single article or file?**

Yes, you can assign various tags to a single article, category page, or file. This capability enables you to capture the multiple aspects and topics covered within the content.

**What's the advantage of using tags for grouping content?**

Using tags for grouping allows you to create thematic collections of content. For instance, you can group articles from different categories related to a common theme under a specific tag, making it easier for users to explore comprehensive information.

**Do tags have any impact on search functionality?**

Yes, tags enhance search functionality. When users search for specific topics, content with relevant tags will be more accurately identified and presented in search results, helping users find pertinent information faster.

**Can I search for content using tags?**

Yes, you can use tags to refine your search results. Document360 will display a list of content items tagged with that keyword or label when you search for a specific tag.

**Is there a limit to the number of tags I can assign to an item?**

There's no strict limit, but Document360 recommends using a reasonable number of tags to maintain clarity. Assign tags that accurately represent the main themes or topics of the content.

**Is there a limit to the number of tags I can add in a project?**

Yes, you can add up to 1000 tags in a single Document360 project.

**Can I bulk-import tags into my Document360 project?**

No, with the current implementation, you cannot bulk-import tag.

<a id="tag-manager-overview-page"></a>

## Manage tags page overview

**Plans supporting tags**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The **Manage tags** page in Document360 is your central hub for managing tags within your knowledge base. Here, you can assign tags to articles, category pages, and files stored on Drive. This page also allows you to organize tag groups, helping you consolidate related tags and view their dependencies across all articles, categories, and files.

To access the Tags Overview page, go to **Documentation** > **Content tools** > **Documentation** > **Tags**.

---

## Key features of the Manage tags page

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1.%20Manage%20tags%20page.png)

1. **Create tag**: Easily add new tags to your project, which can be later associated with articles, category pages, and files.
2. **Search tags**: Use this field to quickly filter and search for existing tags in your project. Simply type in the keyword, and relevant results will be displayed below.
3. **Created by**: View the contributor’s name who created each tag, providing transparency and accountability within your tagging strategy.
4. **Date**: Check the creation date for each tag, helping you track updates and changes over time.
5. **Tag dependency**:

   View how many instances each tag has been associated with across:

   * Articles
   * Page category
   * Files in drive
   > NOTE
   >
   > You cannot delete a tag if it has dependencies, meaning it is associated with any articles, category pages, or files. Please remove the tag’s dependencies first before deleting it from the tag library.
6. **Edit options**:

   Access various actions to manage your tags:

   * Edit: Click the edit icon to modify the tag name and description.
   * Move: Easily relocate tags to different categories or groups.
   * Merge tags: Combine similar tags to reduce redundancy.
   * Remove references: Detach tags from specific articles, categories, or files.
   * Delete: Remove tags from your project, ensuring your tagging system stays organized.
7. **Export**: Export all tags in your project to a CSV file for external use or analysis.
8. **Filter**:

   Use the "Filter" option at the top-right to narrow down the displayed tags by various criteria, such as:

   * Tag associations
   * Creation on
   * Created by

---

## FAQs

**Can I view the list of all Tags used in my knowledge base?**

Yes, the **Manage tags** overview page *(****Content tools*** *>* ***Documentation*** *>* ***Tags****)* displays all the tags available in your knowledge base project. This page helps you manage and maintain a consistent tagging strategy across your content.

**Can I view which is associated with which article or file?**

The tag references in articles, categories, and files can be viewed from the **Manage tags** overview page. Click on the number in the consequent columns and View dependencies for the tags.

**Can I edit or remove Tags?**

Yes, you can easily edit or remove Tags at any time. Navigate to the **Manage tags** overview page *(****Content tools*** *>* ***Documentation*** *>* ***Tags****)* select the tag, and the Edit and Delete option appears at the page top.

**Can I merge two or more tags?**

You can merge similar tags by selecting them in the **Manage tags** overview page and clicking on the **Merge tags** option at the top.

**Can I remove tag dependencies?**

You can remove tag dependencies one article/file at a time or use the bulk dependency remove. Select the tags in the **Manage tags** overview page and click on the **Remove dependencies** option at the top.

<a id="adding-a-new-tag"></a>

## Adding a new tag

**Plans supporting tags**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Team accounts in Document360 can create tags to organize articles, page categories, and files in Drive. Tags help classify and manage content efficiently across the project, while also enhancing search functionality by making content easier to find.

> NOTE
>
> Use the [**AI tag recommender**](/help/docs/ai-tag-recommender) feature in Document360 to analyze article content and recommend relevant tags. If no suitable tag exists in your tag library, the recommender can also help you create new tags.

---

## Adding tags to the library

There are **four** methods to add tags to your project's Tag library.

1. From the **Manage tags** overview page
2. From **More article options** in the editor
3. Adding tags to files in **Drive**
4. Adding tags to the articles in the **All articles** page

### Adding tags from the Manage tags overview page

To add tags from the **Manage tags** overview page,

1. Log in to the **Knowledge base portal** and select the **Documentation ()** tab from the left navigation sidebar.
2. Navigate to **Content tools > Documentation > Tags**.
3. On the **Manage tags** overview page, click the **Create tag** button at the top-right.
4. Enter the tag name and description in the respective fields.
5. Select the group you want to associate the tag with (the individual tag is the default selection).
6. Click the **Create** button to add the tag to your project's tag library.

![1_Screenshot-Creating_a_new_tag_method1](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Add_tags_content_tools.png)

### Adding tags from More article options in the editor

To add tags in the editor,

1. In the documentation editor, click the **More ()** icon.
2. From the menu, select **Tags** to open the **Article settings** window.
3. In the **Tags** field:

   * Click the field to open a dropdown showing existing tags.
   * Type in the field to search for matching tags. The dropdown will filter results as you type.
   * If the tag you typed does not exist, the dropdown will show an option to create a new tag. Select this option to add the tag to your library.
4. After selecting or creating the desired tags, click **Save** to apply the changes.

![2_ScreenGIF-Creating_tags_in_documentation_editor](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_GIF-Add_tags_editor.gif)

### Adding tags to files in Drive

To add tags to files in Drive,

1. Navigate to the **Drive** and click on the desired file name.
2. Click the **More ()** icon next to the file name and select either **Add tags** or **View details** to open the **File details** side panel.
3. In the **File details** side panel, locate the **Tags** field.
4. In the **Tags** field:

   * Click the field to open a dropdown showing existing tags.
   * You can type in the field to search for matching tags. The dropdown will filter results based on your input.
   * If the tag you typed does not exist, you will see an option to create a new tag.Click this option to add the new tag.
5. After selecting or creating the desired tags, click the **Update** button to save the changes.

![3_Screenshot-Adding_tags_in_drive_method_3](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Add_tags_drive.png)

### Adding tags to articles from the All articles page

1. From the Knowledge base portal, go to Documentation > All articles.
2. Select one or more articles from the list.
3. Select **Create tags** from the toolbar. This opens the **Create tags** window.
4. In the **Create tags** window:

   * Use the **Tags** field to select existing tags from the dropdown or type to search for tags.
   * If the tag you typed does not exist, select the option to create a new tag.
5. After selecting or creating the desired tags, click **Save** to apply the changes.

![4_Screenshot-Method4_Adding_tags_in_All_articles](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Add_tags_all_articles.png)

## Tag limitations and details

Below are some of the details and limitations of tags in Document360.

### **Number of tags in a project**

Team members can add up to **1,000 tags** to a single project. Tags are listed on the **Manage tags overview** page, with pagination at the bottom for easier navigation.

### **Tag character limit**

* **Tag name**: The maximum character limit, including spaces, is **30**.
* **Tag description**: The maximum character limit, including spaces, is **100**.

### **Tag description**

* When you hover over a tag in the **Knowledge base portal** or **Knowledge base site**, the tag's description appears as a tooltip.
* On the dedicated **Tags page** in the **Knowledge base site**, the tag description appears below the tag title.

## **Tag naming guidelines**

Tags can include:

* Uppercase and lowercase characters (with multi-language support)
* Numbers
* Spaces
* Selective special characters: **\_ + - @ # % ^ & ! ()**

> NOTE
>
> Tag name cannot contain the following special characters: **\ / : \* ? " <> |**.

<a id="tag-groups-overview"></a>

## Tag groups page overview

**Plans supporting tag groups**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Tags in Document360 help you organize articles, page categories, and files in Drive. But managing a large number of tags can get complicated. To make it easier, Document360 allows you to group related tags into **Tag groups**. Tag groups help you keep your tags organized and easier to manage. Within each group, you can see the tags it contains and their dependencies, making it simple to maintain a clear and organized tag library.

---

## Creating a tag group

To create a tag group,

1. Log in to the **Knowledge base portal** and select the **Documentation ()** tab from the left navigation sidebar.
2. Navigate to **Content tools > Documentation > Tags**.
3. Select the **Groups** tab. You can view the list of Tag groups if you have any.
4. Click on the **Create group** to add a new tag group.
5. Add the **Tag group** name and description and click **Create**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_GIF-Creating_tag_groups.gif)

## Adding tags to tag groups

There are two methods for adding tags to tag groups.

* **Method 1**: Assign a tag to a group while creating it by selecting the desired group from the **Select group** dropdown.
* **Method 2**: In the tag library, select multiple tags, click **Move** in the toolbar, and assign them to the desired group.

## Deleting tag groups

To delete a tag group, go to the **Tag groups** page, select the group you want to delete, and click **Delete** in the toolbar.

> NOTE
>
> Deleting a tag group will remove all dependencies of the tags in the group from associated articles, page categories, and files. Additionally, the tags themselves will be deleted from the project.

---

### FAQs

#### **Can I add tags to tag groups after creating them?**

Yes, you can add tags to tag groups either while creating the group or later by selecting multiple tags in the tag library and moving them to the desired group.

#### **What happens if I delete a tag group?**

Deleting a tag group will remove all dependencies of the tags in the group from associated articles, page categories, and files, and the tags themselves will be deleted from the project.

#### Is it possible to add tag groups to articles?

No, tag groups cannot be added to articles. They are designed to help organize your tags and provide a way to view all articles associated with the tags in a specific tag group.

<a id="tag-dependency-viewer"></a>

## Manage tag dependencies

**Plans supporting tags**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Tag dependencies allow you to view and manage where tags have been applied in your project, such as articles, page categories, and files in Drive. This ensures you can track and clean up tag usage across your project efficiently.

## Viewing tag dependencies

To view tag dependencies,

1. Navigate to **Documentation** > **Content tools** > **Documentation** > **Tags**.
2. Click the number displayed under the **Articles**, **Page category**, or **Files in drive** columns to open the **Tag dependencies** window and view detailed information.
3. Review the detailed information about the selected tag's usage in the **Tag dependencies** window.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-View_tag_dependencies.png)

### Information available in the Tag dependencies window

In the **Tag dependencies** window, you can view detailed information about where the tag is applied:

* **For articles**: Article title, status (new article, draft, published), workspace, language, article creator, and the article's date of creation.
* **For page categories**: Page category title, status (new article, draft, published), workspace, language, article creator, and the page category's date of creation.
* **For files**: File name.

---

## Removing tag dependencies

You can remove tags from articles, page categories, or files directly from the **Tag dependencies** window by following these steps:

1. Select the desired items (articles, page categories, or files) using the checkboxes.
2. Click **Remove dependencies** to remove the tag from the selected items.
3. To remove the tag from all listed items, click **Select all** and then **Remove dependencies**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Remove_tag_dependencies.png)

<a id="find-and-replace"></a>

## Find and replace

**Plans supporting find and replace**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

**Find and replace** allows you to search and replace a keyword/phrase across your project's articles and category pages.

You can search only words and numbers and you can replace those with words, numbers, and selective characters.

![4b_Screenshot-Find_and_replace-Text_fields](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4b_Screenshot-Find_and_replace-Text_fields.png)

---

## Performing the find and replace operation

1. Go to the Documentation () icon > **Content tools** > **Documentation** > **Find and replace**.  
   ![1b_Screenshot-Accessing_find_and_replace](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1b_Screenshot-Accessing_find_and_replace.png)
2. Enter the desired keyword/phrase you want to search in the **Find** field.

   * A list of articles and category pages which has the keyword/phrase appears.
   * You can use the available filter options by clicking on **Filter** available on the top-right to narrow down the results.
   * Select the **Match whole words** checkbox to find and replace a specific word/phrase.
   > For example, when you replace `page` with `article`, all occurrences of `page` will be replaced with `article` but only when it is a separate word. The word `homepage` will be ignored for this action.

   > NOTE
   >
   > The number of times the term is mentioned in the article is fetched by the **Find** field and displayed as occurences. The occurrences are displayed at the top of the article preview pane.
   >
   > ![2_Screenshot-Find_and_replace-Article_preview](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Find_and_replace-Article_preview.png)

3. Select the articles and category pages in which you want to replace the text.

   * To replace the text in the desired article, select the adjacent checkbox.
   * If you want to replace it in all instances, select the check box adjacent to the **Articles/Category pages** column header.
4. Enter the desired keyword/phrase you want to replace in the **Replace with** field.
5. Click **Replace**.

> NOTE
>
> The **Replace** button is enabled only when you select at least one article/category page.

6. Select the desired article status after replacement.

   * **Publish** - To publish the article after replacing the keyword/phrase.
   * **Draft** - To keep the article in the draft after replacing the keyword/phrase.
7. Click **Apply**.
8. To view the full article on a new tab, click on the open article in new tab () icon near the **Article preview**.  
    ![6b_Screenshot-Find_and_replace-Confirmation_prompt](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/6b_Screenshot-Find_and_replace-Confirmation_prompt.png)

### Filter options

The following filter options are available:

* **Workspace/Language** - To filter the search results by workspace and language.
* **Visibility** - To filter the search results by visibility status (Visible/Hidden).
* **Status** - To filter the search results by article status (New article/Draft/Published).
* **Contributors** - To filter the search results by contributors. You can search by team account name, and multiple selections are allowed.
* **Tags** - To filter the search results by tags.
* **Updated on** - To filter the search results by last updated date range.

![5d_Screenshot-Find_and_replace-Filters_available](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5d_Screenshot-Find_and_replace-Filters_available.png)

## Find and replace in editor

1. You can also use the **Find and replace** tool within the Editor.
2. Navigate to the desired editor and click the find and replace () icon.  
   ![New_Screenshot-Find&Replace_in_editor](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/New__Screenshot-Find&Replace_in_editor.png)

   > NOTE
   >
   > When the tool is used from the editor, it finds and replaces the text only in the respective article.

---

## FAQ(s)

**Who can access the Find and replace?**

Find and replace is available only for team accounts with Content role as **Editor** (or) custom content role with the Perform **Find and replace** permission.

**Can I perform Replace without entering anything in the 'Replace with' field?**

* You can perform Replace without content in the **Replace with** field. The keyword/phrase entered in the **Find** field will be removed from the selected articles and category pages.
* When you enter nothing in the **Replace with** field and click **Replace**, the 'Replace content is not provided' message appears in the 'Confirm replace' prompt.

**Does the 'Replace with' change the Markdown or HTML syntax entered in the editor?**

No, it does not replace the Markdown or HTML syntax entered in the editor. It replaces the text that appears in the Knowledge base article.

> For example, to replace the keyword "Set up" with "Install" in an article with Markdown syntax, enter as : Find - `Set up`; Replace - `Install`.

**Do the search results return the articles in the Recycle bin?**

No, the articles and category pages dumped in the Recycle bin will not be covered in the search.

**How many replacement events can be performed?**

The occurrences in a maximum of 1000 articles can be replaced in a single event.

A tool in Document360 used by writers to draft and format content. Document360 offers three types of editors: Markdown, WYSIWYG, and Advanced WYSIWYG.

Permissions assigned to a team account in Document360 that define the actions they can perform on knowledge base content, such as creating, editing, or managing articles and categories.

![8_Screenshot-Content_role_view permission](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/8_Screenshot-Content_role_view%20permission.png)

A folder in the Document360 drive where deleted files and folders are temporarily stored. It allows users to recover accidentally deleted items if needed. Deleted items are stored for 30 days before they are deleted permanently.

<a id="seo-descriptions"></a>

## SEO descriptions

**Plans supporting SEO description**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

SEO descriptions can be added for individual articles in the article settings. To manage or generate SEO descriptions for multiple articles or page categories, use the SEO description tool in the Content tools section.

## Generating SEO descriptions

To manage the SEO descriptions for multiple articles or page categories,

1. Log in to the Knowledge base portal and choose the desired project.
2. Choose a workspace from the Workspace dropdown menu. Make sure the workspace language is set to English.
3. Navigate to **Content tools** > **Documentation** > **SEO description** in the Documentation tab.
4. Select the checkbox next to each article for which you want to generate SEO descriptions.

> NOTE
>
> Articles with fewer than 200 words are ineligible for SEO description generation, and their checkboxes will be disabled.

5. Click **Ask Eddy AI** in the top-right corner to generate SEO descriptions for the selected articles.
6. Review the generated descriptions in the SEO description column:

   1. If you are satisfied with all generated descriptions, click **Save**.
   2. If you are not satisfied with any description, click **Cancel**.
   3. For partially satisfactory results, click **Save** or **Cancel** individually for each article in its respective row.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_GIF-Content_tools_seo_description.gif)

### Filters in the SEO description tool

You can use the Filter dropdown to quickly identify the articles for which you want to generate SEO descriptions.

The following filters are available in the **Filter** dropdown:

* **SEO description**

  + **Available**:Filter the articles with existing SEO description.
  + **Not available**: Filter the articles without an existing SEO description.
* **Category**: Filter the articles by category or subcategory.
* **Contributor**: Filter the articles by contributors.
* **Tags**: Filter the articles with the tags.
* **Updated on**: Filter the articles updated within a time frame or a specific range of dates.

---

### FAQs

#### **What happens when I use the “Select all” option and try to generate SEO descriptions for articles with fewer than 200 words?**

When using the **Select all** option, all articles on the page are selected, including those with fewer than 200 words. If you proceed to generate SEO descriptions, a confirmation prompt will notify you that descriptions cannot be generated for these articles. To continue generating descriptions for eligible articles, type "yes" in the field and confirm by clicking **Yes**.

#### How do I generate the SEO description for individual articles from the editor?

You can generate the SEO description for individual articles from the editor using the [**AI SEO description generator**](/help/docs/seo-description-generator).

#### What are some best practices while draft SEO titles and descriptions?

#### Best practices for SEO descriptions

1. **Keep it concise (around 155-160 characters):** Meta descriptions should be brief yet informative. They are snippets that appear in search engine results, so ensure they’re clear and concise.
2. **Include relevant keywords:** Incorporate primary and secondary keywords naturally, reflecting the core topic of the article to improve discoverability.
3. **Align with user intent:** Ensure the meta description answers what your target audience might be looking for. This helps increase click-through rates by attracting the right audience.
4. **Make it actionable:** Use calls to action like “Learn more,” “Discover,” or “Get started” to encourage users to click on your link.
5. **Unique for every page:** Ensure every page on your website has a unique meta description to avoid duplicate content issues.
6. **Avoid keyword stuffing:** Overloading the meta description with too many keywords can make it seem unnatural and may negatively impact SEO.

#### Best practices for SEO titles

1. **Optimal length (50-60 characters):** Keep your title under 60 characters to ensure it doesn’t get cut off in search results.
2. **Include primary keywords:** The title should include your primary keywords, preferably at the beginning, to improve relevance for search engines.
3. **Reflect the article’s content:** The title should accurately represent the article’s subject matter to avoid misleading users or increasing bounce rates.
4. **Make it engaging:** Write compelling titles that spark interest. Use power words or questions to attract user attention.
5. **Avoid redundancy:** Ensure your title is clear, straightforward, and free from unnecessary repetition of words.
6. **Brand inclusion (optional):** You can add your brand’s name at the end of the title to improve brand visibility, but only if space allows without truncating essential keywords.

<a id="export-documentation-as-zip"></a>

## Exporting your Document360 project as a ZIP file

**Plans supporting import and export of project**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Using the **Export** option in Document360, you can export and download the contents of your project as **ZIP** file.

The exported Document360 ZIP file contains the following:

* Articles and category pages
* Media files hosted in Drive (Exporting media files is optional)

The exported project ZIP file can be easily imported onto another project in Document360.

---

## Exporting a project

To export a Document360 project as a ZIP file,

1. Navigate to **Documentation ()** > **Content tools** > **Import & Export** > **Import & Export project**.
2. Click the **Export** button to open the **Export project** popup.
3. In the **Export project** popup, select the **Article modified on** option that matches the articles you want to export. Choose **All** to export all articles, **7 days**, **30 days**, or **90 days** to export articles modified within the selected timeframe, or **Custom date** to specify a custom date range.
4. Select the workspace you wish to export by checking the box next to the workspace name. Selecting a workspace includes all languages and categories within that workspace.
5. To export specific languages and categories within a workspace, click the arrow next to the workspace name to view the available languages. Then, click the arrow next to each language to display its categories. You can select specific languages and categories as needed.

> NOTE
>
> As you make the selections, the total categories selected for export are displayed at the top-right of the frame.

6. Check the **Include media files** box to include related media files in the exported ZIP file.
7. Click **Export** to begin exporting the project contents.

> NOTE
>
> Depending on the size of the content selection, the time taken to export may vary.
>
> For example, the typical sample project content provided by Document360 is usually exported in 60 seconds or less.

![Screengif-Updated_Exporting_your_Document360_project_as_a_ZIP_file](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_GIF-Export_project_file.gif)

The export process is initiated, and you will get a notification popup at the top-right when the export is complete and ready for download. You can navigate to other modules while the export is in progress.

---

## Downloading the ZIP file

To download the exported Document360 project ZIP file,

1. Navigate to **Documentation ()** > **Content tools** > **Import & Export** > **Import & Export project**. The latest exported file will be available under **Recent files** (The date and time of export will be available in the file).
2. Click **Download** to save the file in your local storage (or)Click **Copy link** to generate a downloadable link for the export file.

![Screenshot-Updated_Import_and_Export_projects-Download_the_exported_file](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Download_exported_project_zip_file.png)

## Export project API endpoint

* To use the export project API endpoint, you should be on the **Business** or **Enterprise** plan. You can use it up to 2 times per day.

> NOTE
>
> Once you perform a new export operation, the previously exported ZIP available for download is overwritten.

---

### FAQ

**In what format are the articles available in the exported ZIP file?**

If you select a single language while exporting your Document360 project:

* Articles created in the **Markdown editor** will be in **.md** format.
* Articles created in the **WYSIWYG/Advanced WYSIWYG editor** will be in **.html** format.

If you select multiple languages while exporting your Document360 project:

* All articles will be downloaded in **.json** format.

Application Programming Interface - A set of rules that allows one software application to communicate with another.

<a id="import-a-documentation-project"></a>

## Importing a Document360 project ZIP file

**Plans supporting import and export of project**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Once you complete exporting the **Document360** **ZIP files**, they can be imported to any project. This is useful when you need to migrate your knowledge base from one project to another, or if you need to restore your knowledge base from a backup ZIP file.

Importing a **Document360** ZIP file includes:

* Articles and category pages
* Media files included in the exported ZIP file

> NOTE
>
> To import a **Document360** project, the team account must have the **Editor** content role. For custom content roles, the account must have **Update** and **Publish access** to the **Project Import & Export** feature.

---

## Importing a project ZIP file

To import a **Document360** project ZIP file,

1. Navigate to **Documentation**() > **Content tools** > **Import and export** > **Import and export project** in the Knowledge base portal.
2. Click the **Import**  button to open the **Import project** panel.
3. Drag and drop the project ZIP file from your local storage or use the **Upload** option to select the ZIP file.

   Document360 will upload and validate the ZIP file.
4. If you need to choose a different ZIP file, click **Replace**.
5. After successful validation, a confirmation message will display details about the ZIP file, such as:

   * **Languages**
   * **Number of categories**
   * **Number of articles**
6. Select the **Set article status to publish** checkbox if you want all the imported articles to be published. If the checkbox is not marked, all the imported articles remain in the **Draft** state.
7. Click **Import**  to finalize the process.

Once the ZIP file is successfully imported into your desired project, all articles and media files will become available within the project.

![Screenshot-Updated_importing_document360_successfull](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_GIF-Import_zip_file_process.gif)

---

### Importing projects with the same workspace slug

When importing a project ZIP file into another project with the same workspace slug:

* The imported articles and categories will merge with the existing articles and categories within the same workspace.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Importing_Document360_project_within_same_workspace.png)

If the workspace slug of the destination project differs from the slug in the imported ZIP file:

* A **new workspace** will be created with the workspace name and slug from the imported project. All imported data will be added to this new workspace.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Importing_Document360_project_as_seperate_workspace.png)

---

### Importing a project ZIP file into a specific workspace without overriding existing content

To import a project ZIP file into a specific workspace while avoiding conflicts with existing articles or workspace slug:

1. Export the desired categories from your **Document360** project as a ZIP file.
2. Extract the ZIP file in your local file explorer.

   The extracted folder contains two main directories: **Media** and **workspace\_slug**.

   * **Media**: Contains all media files of the project.
   * **workspace\_slug**: Contains two folders and a JSON file:  
     a) **Articles**: List of articles in the project.  
     b) **Categories**: List of page categories in the project.  
     c) **workspace\_slug\_category\_articles**: A source file with workspace and article data.
3. Open the **workspace\_slug\_category\_articles** file in a code editor.
4. Modify the workspace name and slug to match the destination workspace name and slug.
5. Save your changes and rename the JSON file using the destination workspace slug format: `workspace_slug_category_articles`.

   **Example:** `v2_category_articles`
6. If needed, update the slugs of articles or categories, and the language code in the extracted folders.
7. Compress the modified files into a new ZIP file and name it using the destination workspace slug.
8. Return to your **Document360** project and import the newly created ZIP file.

In this example, we are importing a project ZIP file with the workspace slug **v1** into a project with the workspace slug **v2**. To match the target workspace **v2**, we update the workspace name and slug in the **v1** ZIP file.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_ScreenGIF-Importing_steps_of_Document360_project.gif)

The above screen recording demonstrates how to change the workspace slug and name from **v1** to **v2** in the extracted files, re-compress the modified files into a new ZIP file, and successfully import them into the **Document360** project with the workspace slug **v2**.

---

### FAQs

#### What happens to my existing content when I import Document360 project data from a ZIP file?

Importing project data from a **Document360** ZIP file behaves differently based on the workspace slug:

* If the workspace slug in the ZIP file matches the destination project’s workspace slug, the imported articles and categories will merge with the existing articles and categories within the same workspace.
* If the workspace slug in the ZIP file differs from the destination project’s slug, a new workspace will be created using the workspace name and slug from the imported project. All imported data will be added to this new workspace.

Importing the ZIP file does not affect your project’s settings. Be sure to back up any important data before proceeding with the import.

#### What happens if I import a ZIP file into the same project it was exported from?

If you import a ZIP file into the same project from which it was exported, any articles in the ZIP file that match existing articles in the project will be overwritten with the version from the ZIP file. Articles that do not exist in the ZIP file will remain unchanged.

#### How do I find the Workspace slug URL for my project?

1. Navigate to the desired **Document360** project.
2. Go to **Settings**() > **Knowledge base portal** > **Localization & Workspaces**.
3. In the **Localization & Workspaces** tab, hover over the desired workspace and click the **Edit**() icon.

   The **Edit workspace** panel will appear.
4. In the **Slug URL** field, locate the slug URL for the workspace.

#### Can I import only ZIP files for Document360 projects? Are ZIP files from other platforms supported?

No, ZIP files from other platforms are not supported. Only project export ZIP files generated in **Document360** can be used while importing content to a project.

#### What is the maximum size for Document360 project ZIP files I can upload?

**Document360** project ZIP files can be uploaded up to a maximum size of 1 GB.

#### Why did my Document360 export file fail to import?

There are several reasons why your **Document360** export file may fail to import:

1. **Unsupported features**  
   If the export file contains workspaces, languages, or other features not supported in your current Document360 plan, the upload will fail. Hover over the info icon for details on unsupported features.
2. **Mismatched slugs and workspace names**  
   The workspace names and slugs in the source and destination projects do not match. Ensure these align before attempting the upload.
3. **Incorrect file format**  
   The imported file must follow the required format for the import process. Verify the structure and ensure it meets the necessary guidelines.
4. **Missing languages in destination**  
   If the import file contains languages that are not available in the destination workspace, the upload will not proceed. Add the required languages to the destination workspace before uploading.

![Screenshot-Updated_importing_document360_successfull](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Import_zip_file_error.png)

<a id="migrating-documentation-from-another-knowledge-base-platform"></a>

## Migrating documentation from other platforms

**Plans supporting content migration**

| Professional | Business | Enterprise |
| --- | --- | --- |
| **✓** | **✓** | **✓** |

Document360 supports migration from 100+ Knowledge base platforms. Document360 provides migration support as an add-on in the Business and Enterprise plans.

Migrating documentation from one knowledge base platform to another platform can be tricky and overwhelming. With Document360, it is just a simple process.

The Document360 migration team has helped customers migrate from other platforms such as

* Zendesk
* Freshdesk
* HelpDocs
* WordPress
* KnowledgeOwl
* GitHub
* Intercom
* Drift
* Confluence  
   and many more.

![4_Screenshot-Migration-Platforms_supported](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1731245595890.png)

### Initiating a migration request

Get the latest information on migration to Document360 on the [**Migration page**](https://document360.com/migration-request/) on our website. You can initiate a migration request from the website through the [**Migration request form**](https://document360.com/migration-request/#MigrationForm).

If you're currently using a trial version of Document360, to migrate your existing knowledge base content to Document360, follow these steps.

1. Navigate to **Documentation** ()> **Content tools** > **Import & Export** > **Migrate content**.

![Screenshot-Updated_Migration-Accessing_migration_page](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1731245662452.png)

2. Click the **Initiate migration** button and a popup appears.
3. Enter the hyperlink to your existing external knowledge base or product documentation site in the **External knowledge base link** field.

   This refers to the link at which your content is currently hosted.  
   For example, docs.yourcompany.com
4. Enter the knowledge base platform used in the **Current platform** field.

   This refers to the platform currently hosting your documentation.  
   For example, Zendesk, Intercom, Confluence, etc.
5. Click the **Submit** button.

![Screenshot-Updates_Migration-Accessing_migration_page_request](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1731245721164.png)

Once you submit the information, one of Document360's migration experts will contact you to help with the migration process.

---

## Document360 migration - What happens next?

![Screenshot-Updated_Migration-Process](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1731245759014.png)

### Step 1: Kick-off

Document360's migration expert will contact you to understand your current knowledge base system and provide an estimate. We can migrate from pretty much any existing knowledge base system or platform.

### Step 2: Migrate

The migration team then uses automated tools and manual processes to migrate your knowledge base. This will be an iterative process with regular updates and sync-ups.

### Step 3: Test

We perform a thorough QA (Quality Assurance) process, set redirection rules, and make sure your new Document360 knowledge base is live without losing any of your existing SEO (Search Engine Optimization) traffic.

### To set up a redirect rule for the subfolder URL path

When you migrate from another platform to Document360, you must set up a redirect rule at the subfolder level. This will enable any URLs from your previous platform to redirect to documentation in your current knowledge base in Document360.

Follow the below steps to set up a redirect rule for the subfolder URL path:

1. Go to **Settings** > **Knowledge base site** > **Article redirect rules** > **New redirect**.
2. Select Redirect type as **Replace with**.
3. Enter the old subfolder path in the **Source path** field.
4. Enter the subfolder path you want to redirect in the **Destination URL** field.
5. Click **Save**.

> **For example**, you want to redirect the subfolder path `/help/customer/` to `/docs/en/` in the URLs `https://docs.churn360.com/help/customer/article_slug`.
>
> * Enter `/help/customer/` in the **Source path** field.
> * Enter `/docs/en/` in the Destination URL field.
>
> With the above redirect rule, all the URLs with subfolder path `/help/customer/` in the configured knowledge base domain (`https://docs.churn360.com/`) will be redirected to the subfolder path `/docs/en`.

---

### FAQ

**Why should I set up a redirect rule when I change the subfolder path?**

Your readers would have bookmarked the articles in your old knowledge base. Your articles would be backlinked in internal and external articles as references. So, when you do not set up a redirect rule for these URLs, it will lead to a 404 error page. 404 error pages play a negative role in google search index which will pull down google search results and mainly cause a bad reader experience.

<a id="pdf-design-templates"></a>

## Designing a PDF template

**Plans supporting export to PDF**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

PDF templates (previously "Design templates") define the PDF's design, styling, and text formatting aspects ready to be exported. Templates help maintain brand consistency for the different PDFs generated.  
 PDF templates are chosen along with other settings when the Team account initiates a new **Export to PDF**.

Team accounts can choose the existing system template (Default) or create a new one.

---

## PDF templates overview page

Users can access the PDF templates in the Knowledge base portal.

1. Go to the Documentation () icon > **Content tools** > **Import & Export** > **Export to PDF**.
2. Select the **PDF template** tab at the top.
3. You can find the list of PDF templates available (both system templates and custom templates).

   The information available here is the Template name and the last modified time/date. The data can be sorted in ascending or descending order.
4. The template name is the name of the respective project (If this feature is being accessed for the first time and no custom template is added).
5. You can add and manage all PDF templates from this page.  
    ![1_Screenshot-Accessing_the_PDF_templates_overview](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Accessing_the_PDF_templates_overview.png)

   ### Template actions on the overview page

   You can perform the following action on the PDF templates on the overview page. The individual template controls are visible when the user hovers the mouse pointer over each template.

* **Clone**: Create a duplicate template similar to the original. Clicking on the clone button would open the PDF template settings page. ‘Clone’ will be added to the original template name. The user can make the necessary changes and click **Save**.
* **Edit:** Users can click on the **Edit** button and edit all the previously saved settings on the template. Once the changes are done, click on the **Save** button. Click on the **Back** button to return to the overview page.
* **Delete**: Click the Delete option to remove any design template from the list. A delete confirmation prompt is displayed. Click **Yes**.  
   The delete option is disabled for the default template. Also, if only one template is available in the list, that is considered a default template.
* **Create new template**: Unlike the other actions, this action has a dedicated button at the top of the page. Users can click this button to create and add new PDF templates to the list.

![4_Screenshot-Updated_PDF_templates_create_new_template](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Updated_PDF_templates_create_new_template.gif)

---

## New PDF template

On the design template overview page, click on the **Create new template** button at the top. A design settings window appears. Specify the following settings in each section.

---

### Template name

Add a name for the new design template. This is a mandatory field. The name can be a maximum of 250 characters with space. Letters, numbers, spaces, and special characters (- and \_) can be added.

![5_Screenshot-PDF_templates_create_new_template_overall_settings](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_Screenshot-PDF_templates_create_new_template_overall_settings.png)

There are three main design segregations for creating the PDF template.

### **1.  Design options**

#### Layout style

Select the page orientation of the template (Portrait or Landscape). Choose between **Portrait** (Height > Width)

or \*\* \*\* (Height < Width).

![6_Screenshot-PDF_templates_create_new_template_display_settings](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/6_Screenshot-PDF_templates_create_new_template_display_settings.png)

#### Margin

You can choose from the four different system margins or a custom margin.

![7_Screenshot-PDF_templates_create_new_template_display_settings_Margins](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/7_Screenshot-PDF_templates_create_new_template_display_settings_Margins.png)

* **Normal** - Top: 50px, Bottom: 50px, Left: 60px, Right: 60px
* **Moderate** - Top: 30px, Bottom: 30px, Left: 40px, Right: 40px
* **Narrow** - Top: 10px, Bottom: 10px, Left: 15px, Right: 15px
* **Wide** - Top: 70px, Bottom: 70px, Left: 80px, Right: 80px
* **Custom margins** - The margins can be set from a minimum of 10 pixels to 80 pixels

![8_Screenshot-PDF_templates_create_new_template_display_settings_Custom_margins](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/8_Screenshot-PDF_templates_create_new_template_display_settings_Custom_margins.png)

#### Cover page

You can add a cover page to the PDF template by turning on the toggle. The cover page is the first page in the PDF file. The cover page is applied only if the checkbox is selected.  
You can preview the cover page on the right.

![1_advancedPDFtemplate](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_advancedPDFtemplate.png)

**a.  Title:** The title text that appears on the Cover. The title must be less than or equal to **15 characters**. It can comprise letters, numbers, spaces, and special characters.

**b.  Description:** Provide a short description of the PDF document. The description must be less than or equal to **500 characters**. It can comprise letters, numbers, spaces, and special characters.

**c.  Color:** Specify the text color of the Title and description on the cover. Use the color picker or the hex code to specify the color.

**d.  Logo:** Upload any logo image to appear on the cover page. Click on the **Click to upload logo or image** button, select the image from the local storage file explorer, and click the **Open** button.  
You can select the three standard square sizes available **Small**(150px), **Medium**(200px), **Large**(250px), or choose a **Custom size** in pixels. The canvas size can be between 20 and 350 pixels in width and height.

**e. Image:** Upload any image to appear on the cover page. Click on the **Background color / image** to select the background color. Choose the color from the pop-up color palette. Click image and click **Click to upload** to upload an image.

#### Terms & conditions

Click on the checkbox to insert any article or custom text into the exported PDF document.

![10_Screenshot-PDF_templates_create_new_template_display_settings_Terms_and_conditions](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/10_Screenshot-PDF_templates_create_new_template_display_settings_Terms_and_conditions.png)

* **Link existing article**- You can choose any one of the existing articles from the project to be included as default in the PDF template.
* **Custom** - You can use the text formatting options to draft custom content to appear in the PDFs.  You can add text, numbers, special characters, and links to the field.

  > NOTE
  >
  > There are no character limits for the Terms & Conditions.

#### Table of content

Select the checkbox to enable the table of contents in your PDF document.  The table of contents helps in easy navigation to the section of the PDF documents.

![11_Screenshot-PDF_templates_create_new_template_display_settings_Table_of_contents](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/11_Screenshot-PDF_templates_create_new_template_display_settings_Table_of_contents.png)

You can select the checkbox(s) of the heading(s) to make them visible in the table of content in the PDF.  When you choose a subheading, all the higher-level headings are automatically selected.

For example, when you select H4, H2 and H3 are automatically selected.

The page numbers are added to the heading on the Table of Contents page.

**Using Table of contents in a document**  
 A table of contents serves two primary functions:

* It's a straightforward way to show every topic your PDF covers at a glance
* It makes document navigation a breeze by clearly showing the page on which each subject is explained

#### Watermark

Turn on the **Enable watermark** available at the bottom.  
 You can choose a text or image watermark on your PDF document.

> **What is a watermark?**  
>  A **watermark** is a text or image behind the document's main text.  It is usually a lighter shade than the text to read the document easily.
>
> Text watermarks are often used to categorize or show a document's purpose with words such as DRAFT, CONFIDENTIAL, etc.
>
> Image watermarks add brand identity, visual attention, and a professional look with imagery such as logos.

![12_Screenshot-PDF_templates_create_new_template_display_settings_watermark](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/12_Screenshot-PDF_templates_create_new_template_display_settings_watermark.png)

* **Text watermark** - A simple text can be added as a watermark using the text field.  The character limit is maximum of 65 characters including spaces
* **Image watermark** - If an image watermark is required, select an image, click on the **Click to upload logo or image**, and select an image from your local storage file explorer to continue.  
   You can select the three standard square sizes available **Small**(150px), **Medium**(200px), **Large**(250px), or choose a **Custom size** in pixels.  The canvas size can be between 20 and 350 pixels in width and height.

### 2.  Header & footer

#### Header image

Set a header image for the PDF doc template using this section.  This acts as a logo (or any image) placeholder on all the pages except for the cover.  
 Click on the **Click to upload logo or image** option and select the required image from the local storage file explorer.

![13_Screenshot-PDF_templates_create_new_template_Header_and_footer](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/13_Screenshot-PDF_templates_create_new_template_Header_and_footer.png)

* **Alignment** - You can select the position of the header image in the document.  The selections available are **Left, Center,** or **Right**.
* **Image size** - Users can select the three standard sizes available **Small**(50x60px), **Medium**(70x80px), **Large**(80x95px), or choose a **Custom size** in pixels. The canvas size for **Height** and **Width** can be between 20 and 85 pixels.

#### Page numbers

Click on the checkbox to enable page numbers on each page.

![14_Screenshot-PDF_templates_create_new_template_Page_number](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/14_Screenshot-PDF_templates_create_new_template_Page_number.png)

* **Page number type** - Users can select from the three types of page numbers provided

  > + Page 1 of 10, Page 2 of 10, ...
  > + Page 1, Page 2, Page 3....,
  > + 1,2,3...
* **Text alignment** - Choose the position of the page number in the document, **Left, Center or Right**

#### Footer text

Click on the checkbox to enable the footer text in your document.  The footer text has no character limit and can comprise letters, numbers, spaces, and special characters.

![15_Screenshot-PDF_templates_create_new_template_Footer_text](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/15_Screenshot-PDF_templates_create_new_template_Footer_text.png)

* **Content** - Type in the content that appears in the document's footer section
* **Font size** -The font size (10 to 16) can be customized based on the requirement.
* **Font color** - Specify the text color of the footer content.  Use the color picker or the hex code to specify the color.

> NOTE
>
> As the footer space in the PDF page is dynamic based on the text and font size, the text does not appear truncated in the final document.

### 3.  Text Settings

Specify the Heading and paragraph font-related settings for the PDF text in this section.

![19_Screenshot-PDF_templates_New_template_Text_settings](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/19_Screenshot-PDF_templates_New_template_Text_settings.png)

#### Heading text settings

* **Font family** - Select the font family for the Headings in the PDF document

  For example, Arial, Calibri, Verdana, etc.
* **Heading color** - Specify the text color of the Heading tags (H2, H3, H4). Use the color picker or the hex code to specify the color

#### Paragraph text settings

* **Font family** - Select the font family for the Headings in the PDF document

  For example, Arial, Calibri, Verdana, etc.
* **Font size** - Choose the font size(10 to 24) in the PDF design template
* **Font color** - Specify the text color of the paragraph content.  Use the color picker or the hex code to specify the color
* **Disable links** - Turn on or off the hyperlinks in the PDF that you want to export.  When you turn on the toggle, other than the table of contents and direct URL, the hyperlinks in the PDF are disabled

  For example, when you turn on the **Disable links** toggle and export a PDF, the hyperlinks in the exported PDF are disabled.  However, the hyperlinks of the table of content and direct URL work.
* **Links color** - Specify the color of the links that appear in the document.  Use the color picker or the hex code to specify the color

  > **Pro tip** - Choose the color that aligns with your brand or the Heading color for a more visual appeal

---

## Default template

Any created PDF template can be set as a **Default** template.  The default template is available without selection in the "Select PDF template" when you initiate an Export to PDF.

![16_Screenshot-PDF_templates_create_new_template_Set_as_default](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/16_Screenshot-PDF_templates_create_new_template_Set_as_default.png)

Click on the **Set as default setting** on the design template page before you **Save** any template. A **Default** tag appears next to the template name on the design template overview page.

![17_Screenshot-PDF_templates_default_template](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/17_Screenshot-PDF_templates_default_template.png)

> NOTE
>
> The default design template cannot be deleted.

---

## FAQ(s)

**What are PDF templates?**

PDF design templates are pre-designed layouts or formats that can be used as a starting point for creating professional-looking PDF documents. They provide structured and design elements, such as fonts, colors, and graphics, that can be customized with specific content.

**How can the PDF templates benefit me?**

PDF templates save time and effort by providing a ready-made framework for your documents. They ensure consistency in branding and visual appeal, making your PDFs look polished and visually appealing. Templates also streamline the design process, allowing you to focus on content compilation rather than starting from scratch.

**Can I customize PDF templates to fit my needs?**

Yes, PDF templates are meant to be customizable. You can modify the text, images, colors, and layout of the template to align with your specific requirements. This allows you to maintain your brand identity while tailoring the design to suit your content and purpose.

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

<a id="compliling-content-for-pdf"></a>

## Compiling content for PDF

**Plans supporting export to PDF**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Create a new PDF (customizing the content you want in your PDF) and add PDF attributes like file name, choosing templates, and choosing the content. The exported PDF can also be password-protected if the user chooses to add a level of access security.

---

## Export to PDF

Go to **Documentation**() > **Content tools** > **Import & Export** > **Export to PDF**, and the Content templates tab is the default selection.

> NOTE
>
> You can only export **published articles** and **category pages**. All the hidden articles/categories are will not be available for export.

### Create new PDF

Follow the below steps to create a new PDF.

1. In the **Export to PDF** page, click the **Create new PDF** button on the top right corner.   
   The **Start export** page opens.
2. Enter the **Name** for the PDF.
3. Enter a **Password** if you want to password-protect your PDF.
4. In the **Select PDF template** field, choose the required PDF template from the dropdown menu.   
   The design template is used to style the PDF content template. Users can configure the visual aspects like the cover page, table of contents, watermark, layout, header & footer, and font settings.   
   To learn more about creating PDF templates, read the article on Designing a PDF template.
5. Select the required **Workspace**.
6. Select the required **Language**.   
   ![2-Screenshot_Start-Export](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2-Screenshot_Start-export.png)You can view the preview of the selected template on the right side. You can navigate between Cover, Terms, ToC, and Content previews.
7. In the **Categories & articles** section, click **Select category articles** to choose the categories.
8. In the **Add categories & articles** popup window, select the sub-categories and articles that you want to export.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3-Screenshot_Add-categories-and-articles_1.png)

8. Click **Done** to confirm selection.
9. Click **Export** to initiate export to PDF.  
   The **Export Status** will be updated as *Success* on completion.

> NOTE
>
> You can now download multiple articles from one or more categories on your knowledge base site as PDFs.

---

## Other actions on PDF

You can perform the following actions on the exported PDF.

1. **Download**: Save the generated PDF in your computer.
2. **Regenerate**: Perform the export function again. Clicking on this option exports the latest content available to the PDF.
3. **Clone**: Create a duplicate of the content template with all the attributes similar to the original template.
4. **Edit**: Make changes to the attributes of the content template.
5. **Export details**: View the file name, version, language, categories and articles in the exported PDF.
6. **Delete**: Remove the content template from the template library. This action cannot be reversed.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4-Screenshot_Export-to-PDF-actions_1.png)

---

### FAQs

#### How can I share draft articles with members outside my project team?

In the Advanced WYSIWYG editor, you can share draft articles with members who are not part of your project team by using the "Export PDF" option.

1. Navigate to the desired article in the Advanced WYSIWYG editor.
2. Select the More (•••) options > **Export PDF**
3. Download a PDF version of the draft article.

   You can then share this PDF with the relevant members.

#### Why are SVG images not visible in my exported PDFs?

SVG images may not appear in exported PDFs due to a limitation of the SelectPDF plugin, which is used for converting HTML to PDF. When SVGs are included using the `<img>` tag, they are not rendered in the PDF. This is a known limitation of the SelectPDF plugin.  
As a workaround, you can:

1. Convert the SVG file into a supported image format such as PNG or JPG.
2. Re-upload the converted file.

<a id="analytics"></a>

## Analytics

**Plans supporting analytics**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The **Analytics** section in Document360 provides a comprehensive overview of your Knowledge base's performance, offering insights to help you optimize content and enhance user engagement. It is categorized into several detailed reports:

* [Articles analytics](/help/docs/articles-geography-and-performance)
* [Eddy AI assistive search analytics](/help/docs/eddy-ai-search-analytics)
* [Search analytics](/help/docs/analytics-search)
* [Reader analytics](/help/docs/reader-analytics)
* [Team accounts analytics](/help/docs/analytics-team-accounts)
* [Feedback analytics](/help/docs/feedback)
* [Links status analytics](/help/docs/links-status)
* [Page not found analytics](/help/docs/page-not-found-analytics)
* [Ticket deflector](/help/docs/ticket-deflector-overview)

### Plan availability

The following analytics features are available based on your subscription plan:

* **Professional plan only**:

  + Eddy AI assistive search analytics
  + Links status analytics
  + Page not found analytics
  + Ticket deflector analytics
* **Professional and Business plans**:

  + Article analytics
  + Search analytics
  + Reader analytics
  + Team account analytics
  + Feedback analytics

### Analytics based on workspace and language

The analytics in Document360 are specific to the active workspace and language of your Knowledge base portal. If you switch to a different workspace or language, the analytics will update to reflect data for the selected workspace and language.

To view analytics for a specific workspace or language:

1. Click on the Workspace Dropdown.
2. Select the desired **Workspace** and **Language** from the available options.

The displayed analytics will now correspond to your chosen workspace and language. All data in analytics displayed is based on the UTC time zone.

<a id="articles-analytics"></a>

## Articles analytics

**Plans supporting article analytics**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The **Articles**analytics page in Document360 offers detailed insights into the performance of your articles, including overall article data, geographic distribution, and top-performing categories and articles. This valuable data can help you understand user engagement, identify popular content, and make data-driven decisions for improving your Knowledge base.

---

## Accessing Articles analytics

To access the Articles analytics page:

1. From the Knowledge base portal, navigate to **Analytics** ()>**Articles**.

   The **Articles** analytics page opens with an overview of article data. This data is specific to the current workspace and language.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenShot-Article_analytics.png)

### Using filters to customize data

By default, the data shows metrics for the **last week**. You can adjust this using filters:

1. Click the **Date** filter dropdown.
2. Select a predefined range (e.g., **This month**, **Last month**) or choose **Custom** to specify a date range.
3. Click on the **All users** dropdown to filter analytics data based on **Team accounts** or **Readers**. This filter applies only to private and mixed projects.
4. If using the **Knowledge base widget**, use the top-right dropdown to switch between **Knowledge base** and **Widget analytics**.
5. Select the JWT widget to track and analyze user interactions and engagement of Feedback analytics within private and mixed projects secured by JWT authentication.

   For more information on Knowledge base widget JWT authentication, read the article on [Managing the Knowledge base widget](https://docs.document360.com/docs/managing-the-knowledge-base-widget).

![Updated_Screenshot-JWT_for_reader_Analytics_June_release](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Updated_Screenshot-JWT_for_reader_Analytics_June_release.png)

> NOTE
>
> Article analytics data can take up to 15 minutes to reflect in the portal.

---

### Article performance

The following performance information of the articles is available in this section as tiles based on the filters applied. Total views, total reads, total likes and total dislikes here in this section are cumulative metrics which include the total including the deleted articles.

| Field | Description |
| --- | --- |
| **Total articles** | Total number of unique articles that were published in the date range based on the applied filters. The deleted articles are not considered. |
| **Total views** | The number of times an article is accessed is counted once per browser session.   * A view is recorded when an article loads in the browser, regardless of user interaction. * Multiple visits to the same article within a session count as one view, even across tabs or windows or when a user closes and opens the same article within that particular browser session. * Alternatively, if a user opens the same article in a different browser, device, clears the cache & reopens the article or refreshes the browser, they will count as another view. * A browser session resets every 24 hours. Accessing the article after this period will count as another view. |
| **Total reads** | An article read is recorded when a user engages through clicking, scrolling, and spending time on the page. The user has to perform all these three actions to count as one read.   * **Scrolling**: At least a single scroll is needed for a valid read. * **Time spent**: Time is tracked only after 40 seconds spent on the article. If a user becomes idle (e.g., stops interacting) for some time or switches tabs, the timer pauses and resumes upon return. * **Session tracking**: Time spent revisiting the same article within 24 hours in the same browser session is added to the previous session's total.   Reads reflect meaningful interaction, distinguishing them from simple page loads. |
| **Total likes** | The total number of likes an article has received. |
| **Total dislikes** | The total number of dislikes received. |

The aggregated data for **Views**, **Reads**, **Likes**, and **Dislikes** within the selected date range is presented in both a numeric format and graphs. You can interact with the graphs by clicking on the legends at the bottom to view individual data points. Click **Export image** ( ) to save the section as a PNG image.

![3_Screenshot-Article_performance_part](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734677856131.png)

---

### Most read articles

This section displays the top-performing articles based on total read time (in hours or minutes). The **Article name**s are listed on the left, and the **Duration** is displayed on the right. Click on the **Export image** () icon to save the section as a PNG image.

![4_Screenshot-Most_read_analytics](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734677884298.png)

---

### Top articles list

The top five articles are listed with information such as **Article name**s, **Contributors**, **Views**, **Reads**, **Likes**, **Dislikes**, and **Feedback**. These articles are ranked by views. Click **View all** to see all the articles in your knowledge base, along with additional information such as time spent and the last updated date. This list does not contain the deleted articles.

![5_screenshot-Top_Articles_part](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734677909945.png)

To analyze specific articles, select one from the list to view detailed analytics. Filters are available to sort readers by:

* **All readers**
* **Self-registration**
* **JWT**
* **Invited readers**

![10_Screenshot-JWT_filter_updation](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1732612581614.png)

* You can filter the following article type, contributors, and date.
* Click **Export CSV** to export the articles in the list.
* Click the **Download** () icon to download the last exported file.
* Click on the back arrow on the top-left to navigate back to the **Articles** page.

![6_Screenshot_All_article_entire_view_part](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734677936708.png)

---

### Location-based views

This section displays a world map highlighting countries based on article views. The data is derived from the IP addresses of users who accessed the articles. A table beside the map lists the top 5 countries, showing the total number of views for each of them (here the cumulative views are shown including those that were garnered by deleted articles as well). These locations are ranked by views. The rest of the countries are grouped under Others.

![7_Screenshot-Location_based_view](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734677969019.png)

* Click on **View all** to view detailed country-based information.

  > NOTE
  >
  > The View all list has tiles representing the number of total views, reads, likes, and dislikes. This count, however, unlike the main page does not include the deleted articles.
* All the countries with at least one view are available. Scroll to view the list of countries on the left side. You can also search for the countries by name.
* The article names, views, reads, likes, dislikes, and average time spent are available as a list.
* You can filter the location data based on article type and date.
* Click on the **Export CSV** button to export the articles in the list.
* Click **Download** () icon to download the last exported file.
* Click the Close (**X**) icon on the top right to navigate back to the **Articles** page.

---

### Top categories

This section displays the top category name and total views. These categories are ranked by views (here the cumulative views are shown including those that were garnered by deleted articles as well).

* Click on **View all** to view the entire list of categories. The category name, number of articles in the category, views, reads, likes, dislikes, and time spent (in minutes) in the categories. This count, however, unlike the main page does not include the deleted articles.
* You can filter the data based on the category type (*All*, *Folder*, *Page,* or *Index*).
* Click on the **Export CSV** button to export the categories in the list.
* Click the Download () icon to download the category list.
* Click on the back arrow on the top-left to navigate back to the **Articles** page.

![8_Screenshot-detailed_Location_based_view](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734678085925.png)

---

### FAQs

#### **Why do my most-read articles and top articles sections differ?**

The Most read articles section lists the top 5 articles with the longest read times during the selected period. In contrast, the Top articles section lists the top 5 most viewed and read articles on your knowledge base, consolidated for the selected period.

#### **Which team account roles in Document360 can access the Analytics section? Is it limited to Admins and Owners?**

In Document360, Admins, Owners, and Contributors can access the Analytics section if their content role is Editor or draft writer.

If you want to restrict team accounts from accessing the Analytics section, you can create a custom portal and content role and uncheck the "Analytics" permission. This will prevent specific users from accessing Analytics.

When creating a new team account or modifying an existing one, assign this custom content role to ensure users with this role can't access the Analytics section.

> For more details on creating a custom content role, read the [Roles and permissions](/help/docs/roles) article.

#### **How can I find the file size I am trying to export?**

Currently, Document360 does not display the file size before export. After downloading the file, you can check the size on your local device.

#### How does the analytics track read counts for smaller articles that do not require scrolling?

For shorter articles where scrolling is not necessary, a read is counted if a user clicks on the article and spends at least 60 seconds engaging with the content. Even without scrolling, this interaction is recognized as a valid read based on the read time shown in the article.

A chart legend represents data series in a chart, using colors or symbols to differentiate them. For example, each column of data in a chart is shown in a unique color, with the colors and series names displayed as the legend

<a id="eddy-ai-search-analytics"></a>

## Eddy AI search analytics

**Plans supporting Eddy AI analytics**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Eddy AI assistive search analytics empowers you to understand and optimize the performance of AI search in your Knowledge base. The **Eddy AI - Assistive Search** analytics page provides information on the overall Eddy AI performance and search metrics, including unanswered searches of your knowledge base site. Also, you can visualize search analytics through charts and graphs for better understanding.

> NOTE
>
> To know more about the languages supported by Eddy AI, [click here](/help/docs/ai-search-suite#multilingual-support-for-eddy-ai-search-suite).
>
> The Conversational Eddy AI related metrics are available only in **KB site 2.0** projects.

---

## Accessing Eddy AI search analytics

1. Navigate to **Analytics** () >**Eddy AI**in the Knowledge base portal.

   The **Eddy AI - Assistive Search** page will appear.

   You can view a comprehensive overview of article performance for the past week by default, but the filter allows you to select a different date range.

### Using filters to customize data

By default, the data shows metrics for the **last week**. You can adjust this using filters:

1. Click the **Date** filter dropdown.
2. Select a predefined range (e.g., **This month**, **Last month**) or choose **Custom** to specify a date range.

---

### Eddy AI search analytics page overview

> NOTE
>
> If multiple chatbots are deployed, the data from all chatbot instances will be merged and reflected in the results.
>
> Similarly, if multiple knowledge base widgets are in use, data from all widget instances will be combined into the results.

You can view the following article performance metrics as tiles based on the filter applied:

| Field | Description |
| --- | --- |
| **Total conversations** | Total number of conversations in Eddy AI, where one or more Eddy queries count as a conversation. This metric will be available only for Knowledge base site 2.0 where Eddy AI is conversational. A single message is also counted as a conversation. |
| **Total queries** | Total number of queries performed in Eddy AI. Queries are individual questions included in the conversation. |
| **Answered queries** | Total number of queries that returned a result. |
| **Unanswered queries** | Total number of queries that did not produce any results. |

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/10_ScreenShot-Eddy_AI_analytics.png)

---

### Query analysis

You can interact with the graph to learn more information on query analysis:

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734687587539.png)

1. **Date-wise metrics**: Hover over the graph to find the metrics on a specific date.
2. **Date**: The metrics are shown in month/date format. To view metrics of a different month, click the **This month** dropdown at the top right and make a selection of your choice.
3. **All**: Represents the comparison of answered queries, unanswered queries, and conversations in a single graph.
4. **Answered (green line)**:  Click to view the graph of queries that returned a result.
5. **Unanswered (red line)**: Click to view the graph of queries that did not produce any result.
6. **Conversations (violet line)**:Click to view the graph of conversations. It is available only for KB site 2.0projects. Scroll down to the last section to export **Conversations** in CSV format.
7. **Export image**: To export the Query analysis as an image in .png format.

> NOTE
>
> Try to maintain the **Unanswered** searches as low as possible compared to the **Answered** searches to ensure your readers find the right content when they perform a Knowledge base site search. Unanswered searches typically occur when there is a lack of relevant information in the documentation, causing the Eddy AI to be unable to fetch data for specific search queries. Keeping your documentation up-to-date can help minimise such queries.

---

### Conversation depth metrics

The conversation depth metrics display the graph illustrating the total number of queries per conversation alongside the total number of conversations. Conversation depth metrics are available only for **KB site 2.0** projects.

1. Hover over each bar to see the exact number of conversations.

   The graph tracks conversations ranging from 1 to 5 queries, with conversations exceeding 5 queries grouped under 6+.
2. Click the **Export image** () icon to export Conversation depth metrics as an image in .png format.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734687695576.png)

---

### Feedback chart

The feedback charts display the data illustrating the total number of Likes and Dislikes, along with the percentage information. The total percentage of feedback is represented inside the color chart.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734687719524.png)

Click the **Export image** () icon to export the Feedback as an image in .png format.

---

### Popular queries

This section showcases the top five popular search themes, along with their frequency counts for the selected month. Queries are grouped by keywords, highlighting the most popular topics of the month and the frequency of related questions asked by readers.

> NOTE
>
> The Popular queries metric is generated only if at least one month of data is available.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734687745810.png)

---

### Unanswered queries

This section showcases the top five popular search themes, along with their frequency counts for the selected month. Each keyword represents a popular topic with unresolved searches.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734687764606.png)

> NOTE
>
> Post-processing occurs monthly, where 30 days of data is analyzed. The data is sent to OpenAI, which identifies the most common keywords and groups them into 10 primary topics. Any remaining data that does not fit into these categories is grouped under "Others." This helps to organize and highlight the most frequent topics efficiently. This is done for all the answered and unanswered queries.

---

### Most referenced articles

This section lists the five most-referenced source articles for the selected month, along with how often each has shown as a source in Eddy AI search results.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734687787606.png)

---

### Conversations

This section offers a detailed view of user interactions in a tabular form showing queries, response status, and feedback.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/9_Screenshot-Conversation_table_in_Eddy_AI_Analytics.png)

1. **Search field:** Enter a query to search for a specific conversation or query.
2. **Conversations:**The conversation will appear. By default, only the first question of each conversation is visible, with the other questions collapsed. Click on a desired query to open a pop-up that displays the entire conversation.

   > NOTE
   >
   > If a conversation started last month and continues into this month, the conversation will be included in last month's analytics.
3. **Query topic:** Query topics are fetched from the list of popular queries. A minimum of 30 days of data is required to generate a query topic.
4. **Response:** Indicates the response status, such as answered () or unanswered queries ().
5. **Feedback**: Displays the feedback, such as likes or dislikes.
6. **Filter**: Filter by query topic, response status, feedback type, or application.

   * **Response Status**: Filter the response status by three options: All, Answered, or Unanswered.
   * **Feedback**: Filter the feedback types by four options: All, None, Liked, or Disliked. By default, **All** is selected.
   * **Query type**: Filters queries from previous months. This filter is unavailable for the current month.
7. **Export**: Export the data as a CSV file based on the applied filters.

---

### FAQs

#### **Why am I unable to filter the data on a weekly basis?**

Popular queries and unanswered search keywords are derived from algorithmic grouping methods. These methods require sufficient data to categorize keywords based on the frequency of responses generated.

#### **How do I resolve queries for which no response is generated?**

To address queries that receive no responses, identify the relevant articles based on the keywords derived from unanswered search prompts raised by readers. Update the content of these articles accordingly.

#### **How does Eddy AI conversation analytics fetch information if the conversation is in multiple languages?**

If a conversation includes multiple languages, the conversation will be updated in the conversation table for each language used. However, specific metrics like total searches, answered queries, unanswered queries found, and feedback received will only be updated for the language in which they occurred.

#### **How does Eddy AI conversation analytics fetch information if the conversation is in multiple workspaces?**

If a conversation includes multiple workspaces, it will be updated in the conversation table for each workspace used. However, specific metrics such as total searches, answered queries, unanswered queries, and feedback will only be updated for the languages used within the respective workspace.

#### **How are queries different from conversations?**

Queries are individual questions included in the conversation. One or more queries contribute to a conversation.

<a id="analytics-search"></a>

## Search analytics

**Plans supporting search analytics**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Use Search Analytics to track reader behavior, optimize your content, and identify gaps in your documentation. This page provides metrics on search trends, successful queries, and no-result searches, helping you enhance the search experience for your users.

---

## Accessing the Search analytics page

To access Search analytics, from the Knowledge base portal, navigate to **Analytics** () and then select **Search**.

### Using filters to customize data

By default, the data shows metrics for the last week. You can adjust these using filters:

1. Click the **Date** filter dropdown.
2. Select a predefined range (e.g., **This month**, **Last month**) or choose **Custom** to specify a date range.
3. For private and mixed projects, you can filter the search analytics by All users, Team accounts and Readers. For mixed projects, All users will include Team accounts, private readers and public readers data. The readers filter however will only show the private readers data.
4. If using the **Knowledge base widget**, use the top-right dropdown to switch between **Knowledge base** and **Widget analytics**.
5. Select the JWT widget to track and analyze user interactions and engagement of reader analytics within private and mixed projects secured by JWT authentication.

   For more information on Knowledge base widget JWT authentication, read the article on [Managing the Knowledge base widget](/help/docs/managing-the-knowledge-base-widget).

![Updated_Screenshot-JWT_for_Search_analytics_June_release](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Updated_Screenshot-JWT_for_Search_analytics_June_release.png)

> NOTE
>
> Search analytics data can take up to 15 minutes to reflect in the Knowledge base portal.

---

### Search analytics page overview

The **Search** analytics page shows the below four metric tiles that are also represented graphically in the Search analysis tile.

| Field | Graph color | Description |
| --- | --- | --- |
| **Total searches** | Purple line | The number of searches users perform on the selected project workspace in the Knowledge base site. |
| **Successful searches** | Green line | The searches that returned at least one result. |
| **No result found** | Red line | The total number of searches that did not produce any result. |
| **Bounced** | Yellow line | The searches that returned results, but the user did not click on any of the results. |

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_ScreenShot-Search_Analytics.png)

You can interact with the graphs by clicking on the legends at the bottom to view individual data points. Click **Export image** ( ) to save the section as a PNG image.

> NOTE
>
> Aim to keep **No result found** searches as low as possible to improve the overall search success rate.

---

### Search success rate

The **Search success rate** pie chart distinguishes successful and unsuccessful results. The total number of searches is available in the middle of the chart.

* **Successful** refers to the searches that returned results.
* **Failed** refers to the searches that returned no results.

Click **Export image** ( ) to save the section as a PNG image.

![5_Screenshot-Updated_Search_analytics-Search_success_rate](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734687879593.png)

---

### Search and No result found list

#### Searches

This section lists the most searched keywords and provides the following information:

| **Field** | **Description** |
| --- | --- |
| **Search keyword** | The exact term searched by users. |
| **Search count** | Number of times the keyword was searched. |
| **Views** | Number of views associated with search results. |
| **Reads** | Number of reads triggered by the search. |
| **Bounced** | Searches that returned results but were not clicked by users. |

You can sort data using numeric values for better analysis.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734687860119.png)

#### No result found

Displays keywords that did not return any results. The following fields are available:

| **Field** | **Description** |
| --- | --- |
| **Search keyword** | Keyword users searched for. |
| **Search count** | Number of times the keyword was searched. |

---

### Export Search analytics data

1. Click **Export CSV** to download the search analytics.

   Wait for a few seconds. Once the file is ready, a Download icon appears next to the **Export CSV** button.
2. Click on the Download () icon, and the file is saved to your local device storage.

   The downloadable file remains available until a new CSV is generated.

   Hover over the Download () icon to see the last export date and time.

---

## Knowledge base site view

This is how your reader would view the search terms that do not return any results. The reader can provide their feedback similar to the Article feedback on their recent search term. They can provide their email (optional) and choose to be notified of any change.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_ScreenShot-Search_analytics.png)

To know more about No search results feedback, read the article on [Feedback manager](/help/docs/feedback-manager-overview).

---

### FAQs

#### **How can Search Analytics help me identify gaps in documentation?**

You can review the list of **No Results Found** search terms, highlighting topics users are searching for but not finding results. This information helps pinpoint areas where documentation may be lacking or unclear.

#### **How does understanding popular search terms benefit my knowledge base?**

Understanding popular search terms helps identify the topics your readers are most interested in or frequently searching for. By analyzing these terms, you can optimize your Knowledge base content, create new articles to address common queries, and ensure your Knowledge base is aligned with your user’s needs.

#### **What is meant by bounced search?**

The Bounced search refers to a situation where search results are displayed to the user, but they do not click on any of the results. This term is used to describe such instances.

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

The public-facing website where end-users can access articles and find answers to their questions.

A chart legend represents data series in a chart, using colors or symbols to differentiate them. For example, each column of data in a chart is shown in a unique color, with the colors and series names displayed as the legend

<a id="reader-analytics"></a>

## Reader analytics

**Plans supporting readers analytics**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The **Reader** analytics page provides an overview of reader activity in your Private or Mixed access project. Use this tool to track user engagement and optimize your content strategy.

---

## Accessing the Reader analytics page

To view reader analytics, from the Knowledge base portal, navigate to **Analytics** () and then select **Reader**.

### Using filters to customize data

By default, the data shows metrics for the **last week**. You can adjust this using filters:

1. Click the **Date** filter dropdown.
2. Select a predefined range (e.g., **This month**, **Last month**) or choose **Custom** to specify a date range.
3. If using the **Knowledge base widget**, use the top-right dropdown to switch between **Knowledge base** and **Widget analytics**.
4. Select the JWT widget to track and analyze user interactions and engagement of reader analytics within private and mixed projects secured by JWT authentication.

   For more information on Knowledge base widget JWT authentication, read the article on [Managing the Knowledge base widget](https://docs.document360.com/docs/managing-the-knowledge-base-widget).

![Updated_Screenshot-JWT_for_reader_Analytics_June_release](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Updated_Screenshot-JWT_for_reader_Analytics_June_release.png)

4. To filter readers by their registration type, use the dropdown menu to select All readers, Self-registration, SSO, JWT, and Invited readers.

> NOTE
>
> Reader analytics data can take up to 15 minutes to reflect in the Knowledge base portal.

---

### Reader Analytics page overview

The **Reader** page shows the below three metric tiles, each representing absolute data points reflecting the overall reader analytics. These metrics remain unaffected by any filters applied to the data.

| Field | Description |
| --- | --- |
| **Total readers** | Number of readers added to your project who can access the Knowledge base. |
| **Self-registered readers** | Readers who registered themselves on your Knowledge base site. |
| **Frequent readers** | Readers who frequently access your articles, calculated based on views and reads.If a reader is searched in the reader table using the search field, the reader gets updated in the frequently modified list. |

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenShot-Reader_analytics.png)

---

### View reader analytics data

The Reader analytics section displays data for the for the selected duration, including the following fields:

| Field | Description |
| --- | --- |
| **Name** | The profile picture and name of the Reader is available here. This is a clickable field.  Click the reader’s name to view detailed information, including total views, reads, likes, dislikes, and a list of articles they've accessed, along with the average time spent and the last viewed date. |
| **Email** | Displays the email of the reader. |
| **Reader type** | Displays the type of reader based on their mode of registration like Self-registration, SSO, JWT, or Invited readers. |
| **Views** | The number of times an article is accessed is counted once per browser session.   * A view is recorded when an article loads in the browser, regardless of user interaction. * Multiple visits to the same article within a session count as one view, even across tabs or windows or when a user closes and opens the same article within that particular browser session. * Alternatively, if a user opens the same article in a different browser, device, clears the cache & reopens the article or refreshes the browser, they will count as another view. * A browser session resets every 24 hours. Accessing the article after this period will count as another view. |
| **Reads** | An article read is recorded when a user engages through scrolling, clicking, or spending time on the page.The user has to perform all these three actions to count as one read.   * **Scrolling**: At least a single scroll is needed for a valid read. * **Time spent**: Time is tracked only after 40 seconds spent on the article. If a user becomes idle (e.g., stops interacting) for some time or switches tabs, the timer pauses and resumes upon return. * **Session tracking**: Time spent revisiting the same article within 24 hours in the same browser session is added to the previous session's total.   Reads reflect meaningful interaction, distinguishing them from simple page loads. |
| **Last login** | Displays the login date of the reader’s most recent login. Click a reader's name to view their detailed login activity. |

---

### Reader individual contributions

1. Click on a reader to view more detailed information about their contributions:

* **Profile** - Team account name, Image, Email, Portal role, and Last login date and time (UTC time zone).
* **Contribution performance - Total views**, **Total reads**, **Total likes**,and **Total dislikes**.
* **Articles** - Displays a list of **Article names** to which the user has contributed, along with details such as **Views**, **Reads**, **Likes**, **Dislikes**, **Created on**, and **Last updated** date. This table can be exported as a CSV file for download to your local system.

2. Click the **Filter** button at the top to filter the analytics data based on **Article type** (*All*, *Page*, *Article*) and **Date** (*7 days*, *30 days*, *Custom date*).
3. Once done, click **Apply**.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_ScreenShot-Reader_analytics.png)

---

### Export reader analytics data

1. Click **Export CSV** to download the reader analytics.

   Wait for a few seconds. Once the file is ready, a Download icon appears next to the **Export CSV** button.
2. Click on the Download () icon, and the file is saved to your local device storage.

   The downloadable file remains available until a new CSV is generated.

   Hover over the Download () icon to see the last export date and time.

Single Sign-On - A method that allows users to access multiple applications with one set of login credentials.

<a id="analytics-team-accounts"></a>

## Team accounts analytics

**Plans supporting team accounts analytics**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The **Team accounts** analytics overview page provides a detailed view of each team member’s account type, the articles or category pages they create or access, their contributions, and last login details.

---

## Accessing the Team accounts analytics page

To view Team accounts analytics, from the Knowledge base portal, navigate to **Analytics** () and then select **Team accounts**.

### Using filters to customize data

By default, the data shows metrics for the **last week**. You can adjust this using the filter:

1. Click the **Date** filter dropdown.
2. Select a predefined range (e.g., **This month**, **Last month**) or choose **Custom** to specify a date range.

> NOTE
>
> Team account analytics data can take up to 15 minutes to reflect in the Knowledge base portal.

---

### Team account analytics page overview

The **Team accounts** page shows the below three metric tiles:

| Field | Description |
| --- | --- |
| **Total team accounts** | Number of team accounts in the project in your Knowledge base excluding the deleted team accounts. |
| **Articles published** | Number of articles published based on the **Date** filter you have chosen. |
| **Top performers** | Profile images of top-performing team members, ranked by the number of articles contributed, are displayed here. |

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenShot-Team_account_analytics.png)

---

### View Team account analytics data

The Team account analytics displays data for the selected duration, including the following fields:

| Field | Description |
| --- | --- |
| **Name** | The profile picture and name of the Team account along with its type (normal or SSO) are available here. This is a clickable field.  Click the Team account name to view detailed information, including total views, reads, likes, dislikes, and a list of articles they've accessed, along with the date the articles were created and last updated. |
| **Email** | Displays the email of the reader. |
| **Portal role** | Displays the portal role that is assigned to the Team account (Owner, Contributor, Admin, and more). |
| **Contributed** | Displays the total number of articles contributed by the Team account during the selected time frame. |
| **Last contributed** | The time of the last contribution made by a team account is displayed relative to the current time, such as "4 minutes ago" or "This Monday." For contributions older than a week, the exact date ("Nov 16, 2024") is shown. |

---

### Team account individual contributions

1. Click on a team account to view the detailed information about their contributions:

* **Profile** - Team account name, Image, Email, Portal role, and Last login date and time (UTC time zone).
* **Contribution performance -** Four tiles displaying **Articles created**, **Total views**, **Total likes**,and **Total dislikes**. These metrics exclude the count of deleted articles.
* **Articles** - Displays a list of **Article names** to which the user has contributed, along with details such as **Views**, **Reads**, **Likes**, **Dislikes**, **Created on**, and **Last updated** date. This table can be exported as a CSV file for download to your local system.

2. Click the **Filter** button at the top to filter the analytics data based on **Article type** (*All*, *Page*, *Article*) and **Date** (*7 days*, *30 days*, *Custom date*).
3. Once done, click **Apply**.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_ScreenShot-Team_accounts_analytics.png)

---

### Export Team account analytics data

1. Click **Export CSV** to download the team account analytics.

   Wait for a few seconds. Once the file is ready, a Download icon appears next to the **Export CSV** button.
2. Click on the Download () icon, and the file is saved to your local device storage.

   The downloadable file remains available until a new CSV is generated.

   Hover over the Download () icon to see the last export date and time.
3. To export the analytics of individual team accounts, click on the team account name and then click **Export CSV** available above the list of article performance details.
4. Click the Download () icon, and the file is saved to your local device storage.

<a id="feedback"></a>

## Feedback analytics

**Plans supporting feedback analytics**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

Feedback analytics track total comments, likes, and dislikes for each article/page category. You can find the analytical representation of the feedback data in charts and graphs.

---

## Accessing the Feedback analytics page

To view Feedback analytics, from the Knowledge base portal, navigate to **Analytics** () and then select **Feedback**.

### Using filters to customize data

By default, the data shows metrics for the **last week**. You can adjust this using filters:

1. Click the **Date** filter dropdown.
2. Select a predefined range (e.g., **This month**, **Last month**) or choose **Custom** to specify a date range.
3. If using the **Knowledge base widget**, use the top-right dropdown to switch between **Knowledge base** and **Widget analytics**.
4. Select the JWT widget to track and analyze user interactions and engagement of Feedback analytics within private and mixed projects secured by JWT authentication.

   For more information on Knowledge base widget JWT authentication, read the article on [Managing the Knowledge base widget](https://docs.document360.com/docs/managing-the-knowledge-base-widget).

![Updated_Screenshot-JWT_for_reader_Analytics_June_release](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Updated_Screenshot-JWT_for_reader_Analytics_June_release.png)

> NOTE
>
> Feedback analytics data can take up to 15 minutes to reflect in the portal from the time the feedback is given.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenShot-Feedback_analytics.png)

---

### **Feedback analysis**

The graphical representation of the Feedback analysis is shown below.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734801406078.png)

The **Feedback** page shows the below four metric tiles:

| Field | Description |
| --- | --- |
| **Total article** | The number of articles that received some feedback (Like, dislike, or comment) from the readers. |
| **Total feedback** | The number of comments logged. |
| **Total likes** | The number of likes received, that are accompanied by comments from the readers. |
| **Total dislikes** | The number of dislikes received, that are accompanied by comments from the readers. |

![1_Updated_Screenshot-Feedback_analytics-Overview_page](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734802023945.png)

---

The Feedback analysis displays the following metrics:

| Field | Description |
| --- | --- |
| **Date-wise metrics** | The metrics on a specific date when you hover over the graph. |
| **All** | The graph of all feedback, including articles, likes, and dislikes. |
| **Articles** | The graph of article feedback. |
| **Feedback** | The number of feedback submitted. |
| **Likes** | The graph of likes received. |
| **Dislikes** | The graph of dislikes received. |
| **Export image** | To export the Feedback analysis graph as an image in .png format. |

---

### Feedback metrics

This section displays a graphical representation of reader’s dislike responses, including the specific reasons selected by readers for their feedback. The dislike responses are:

* Need more information
* Difficult to understand
* Inaccurate or irrelevant content
* Missing or broken link
* Others

![4_Screenshot-Updated_Feedback_analytics-Filters_metrics](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734802120667.png)

#### Custom feedback messages

The dislike responses mentioned above are the default system responses. You can change the response on the **Localization variables** page and also view the total count for each type of dislike response selected by readers.

Navigate to **Settings**()> **Knowledge base portal** > **Localization & Workspaces** > **Localization variables**.

For more information, read the article on [Localization variables](/help/docs/localization-variables).

---

### Feedback list

Here, the list of articles, along with the feedback information, is displayed. The information available in this section are

* Article name
* Proportion (Likes vs. Dislikes out of 100)
* The total article views in the selected time frame
* Likes received with feedback or comments
* Dislikes received with feedback or comments
* Feedback or comments received

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734802145188.png)

The actions you can perform from this section are:

* **View in Knowledge base**: This appears next to the article name when you hover over it. Click on this, and the article opens the Knowledge base site in a new browser tab.
* **View feedback**: This appears at the end of the row when you hover your pointer over the article. Clicking **View feedback** redirects you to the **Feedback manager**.
* **Filter**: You can filter the list based on articles, page categories, or both.
* **Export CSV**: Click **Export CSV** to download the reader analytics.

  Wait for a few seconds. Once the file is ready, a Download icon appears next to the **Export CSV** button.

  Click on the Download () icon, and the file is saved to your local device storage.

  The downloadable file remains available until a new CSV is generated.

  Hover over the Download () icon to see the last export date and time.

---

### FAQ

#### **Are feedback submissions without comments included in the metrics displayed on the Feedback Manager tiles?**

No, Any feedback without a comment will not appear in the metrics reflected on the Feedback Analytics tiles. Only feedback submissions that include both a thumbs up/thumbs down response and a comment are counted in the **Feedback analytics** data.

The public-facing website where end-users can access articles and find answers to their questions.

<a id="links-status"></a>

## Links status analytics

**Plans supporting analytics on link status**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

**Links status** is a sub-feature under the Analytics section of Document360. This feature is a broken link checker that helps validate and monitor all internal, external, and media file links on the knowledge base. It allows you to fix bad/broken links to improve Search Engine Optimization (SEO) and enhance the reader experience.

With the following validations, you can run the link validation at a workspace and language level.

1. **Scheduled validation**
2. **Manual validation**
3. **Article level validation**

> NOTE
>
> For manual and scheduled validation, all the links at the project level are analyzed to check for broken, unknown, or working links.

---

## Accessing the Links status analytics page

To view the Link status analytics, from the Knowledge base portal,

1. Navigate to **Analytics** () and then select **Link status**.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenShot-Link_status_analytics.png)

---

## Links status overview page

This page contains all the necessary data regarding the links used in your Knowledge base (selected workspace and language). You have two sections on the page: **Links status tiles** and **Links list**.

### 1. Links status tiles

![Image showing links status overview page](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Link_analytics.png)

#### Links classification

| Field | Description |
| --- | --- |
| **Total links** | The total number of URLs and files (both internal and external) linked in the different articles on your Knowledge base. |
| **Internal** | The total number of Internal URLs including article links and media file links within your Document360 project. |
| **External** | The total number of External URLs including article links and media file links outside your Document360 project. |
| **Ignored** | The links you want to ignore in the current validation or upcoming validation. |

#### Current state

| Field | Description |
| --- | --- |
| **Redirect URL** | When the link has been temporarily or permanently routed to a different URL. |
| **Working** | The link works fine and points to an intended webpage or file (Internal and External). |
| **Broken** | A broken or dead link is a hyperlink in the article that no longer works because it's encountering one or more issues like URL changes, incorrect URL, page or item removed, or restricted/private knowledge base article URL. Broken status applies to URLs and media files. |
| **Unknown** | The link that does not return a status. |

#### Broken link/image

When a broken link or an image file is accessed:

* **Link** – When the reader clicks on a broken link, a 404-page error or similar message showing that the webpage is unavailable is displayed.  
  ![8_Screenshot-Links_status_404_error_page](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/8_Screenshot-Links_status_404_error_page.png)
* **Media files** – In the case of an image or video file, a broken image thumbnail icon would be displayed in place of it in the article.  
  ![9_Screenshot-Links_status_Broken_media_file](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/9_Screenshot-Links_status_Broken_media_file.png)

---

### 2. Links list

The list of all links used in the entire workspace is displayed below the Links status section. You can find the following information about the links used.

![Image showing list of links used in a workspace](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Link_analytics.png)

| Field | Description |
| --- | --- |
| **Article name** | The article name in the Knowledge base that contains the link. |
| **Link type** | **Links**: Internal link, External link, Secured link, Unsecured link **Media files**: Internal file, and External file. |
| **URL** | The actual web link (destination URL) |
| **Redirect URL** | If the existing source path has been redirected to a new destination. |
| **Status** | Indicating the status of the link. **Working**, **Broken**, **Redirected**, or **Ignored**. |

> NOTE
>
> If you have deleted an article after the validation and the report has been generated, the article is grayed out. A trash icon appears next to the article name.

---

### Filters for Links list

The **Filter** button at the top of the Links list section is useful when you have a greater number of links. You can filter links based on four parameters: the **Source**, **Visibility**, **Link type**, and **Status**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734802570175.png)

Once you have selected the filter, click **Apply**.

You can also apply filters directly by clicking on the Link status tile that you prefer to view. For example, when you click on the **Broken** or **External** link status tile, the respective links with the link type or status are displayed in the list.

---

### Export Links list analytics data

1. Click **Export CSV** to download the Link analytics.
2. Click on the Download () icon next to the **Export CSV** button, and the file is saved to your local device storage.

   The downloadable file remains available until a new CSV is generated.

   Hover over the Download () icon to see the last export date and time.

---

## Actions and controls

Above the Links status sections, you can find the controls and data regarding the link analytics.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734802611737.png)

#### a. Validation type

The validation types are **Scheduled**, **Manual**, and **Article level**.

#### b. Report date

* The date of the reports generated will be loaded here. The validation reports are named as per the generation date.
* When you hover over the info () icon adjacent to the **Report data** dropdown, you can view the next or upcoming Scheduled link validation date.

  > NOTE
  >
  > Scheduled link validation runs every 7 days hence only the latest weekly data is shown.

#### c. Manage links

* This button opens the **Manage links** window.
* This window contains information about all the links used, and also those which are **Ignored** or **Included** in the validations under respective tabs.

#### d. Validate links

* This button initiates the Manual link validation at the project level.
* When you click **Validate links,** a confirmation prompt pops up to alert you with the number of manual validations left for the month.
* To proceed, click **Confirm**.

#### e. Manual validation usage

* This status bar shows your project's available Manual validation limit as per your project plan. The limit resets every month.
* The link status validation limit applies to both internal and external links.
* Customers of all price tiers can opt for an increase in the link validation limit anytime based on their requirement for a nominal charge.
* For additional information, contact our [**support team**](https://document360.com/contact-us/).

#### f. Link analytics usage

This status bar shows the stats of the link limit used out of the total limit for your project.

> NOTE
>
> The link validation limit for the plans that support analytics on link status are:
>
> Business plan - 5000 links
>
> Enterprise plan - 10000 links

### Links analytics limit exceeded

When the links count is higher than the total count of links limited for your project, the **Links analytics limit exceeded** text appears instead of the **Link analytics usage**.

* When the link analytics limit is exceeded, and the links validation (both Scheduled and Manual validation) takes place, only the links under the total given limit are validated.
* The extra links that exceed the limit are not validated. Article-level validation is also not possible for those links.

  For example, your total link limit is 10000, but the total link count in your project is 10500. Only the first 10000 links are validated when you perform the links validation. The recently added 500 links are not validated.
* To validate all the links in your project, contact our [**support team**](https://document360.com/contact-us/) to increase the limit for your project.

---

## Link validation

You can perform link validation at a workspace and language level in the below ways,

1. Scheduled validation
2. Manual validation
3. Article level validation

> NOTE
>
> For manual and scheduled validation, all the links at the project level are analyzed to check for broken, unknown, or working links.

### 1. Scheduled validation

This is an automated link validation that runs on a **Schedule**, based on your plan tier.

#### Steps to perform schedule validation

1. On the Knowledge base portal, click on the Analytics () icon on the left navigation sidebar.
2. Click **Links status** on the left navigation pane.
3. The Links status overview page appears.
4. From the **Validation type** drop-down at the top, select the **Scheduled** validation (which is the default selection for your projects).
5. You can find the recently generated Scheduled link validation.
6. If you want to look into any previous reports, from the **Report date** drop-down select the report date you wish to view.

### 2. Manual validation

#### Steps to perform manual validation

1. On the Knowledge base portal, click on the Analytics () icon on the left navigation sidebar.
2. Click **Links status** on the left navigation pane.
3. The Links status overview page appears.
4. From the **Validation type** drop-down at the top, select **Manual** validation.
5. The latest Manual validation report list will appear.
6. Click **Validate links** at the top right to perform a new manual validation.

   > NOTE
   >
   > The analytics report for links is generated every 24 hours (UTC 00:00). If you run consecutive Manual validations within 24 hours, the already run manual validation reports are overwritten with the latest validation data. Once generated, data cannot be retrieved.
7. Once the validation is complete, you will receive a mail on your registered email, and you can view the analytics report on the overview page.

   > NOTE
   >
   > Only team member roles with the Validate link analytics permission can perform link validations.

### 3. Article level validation

When choosing the **Article level validation** from the **Validation type** drop-down, you can view the article/category-page link validations you have already run. This overview page will be empty if you haven't validated links at the article/category page level.

#### Validate links at the article/category-page level

The article/category-page level link validation can be done from the article **editor** section.

1. Navigate to the desired article/category page in the Knowledge base portal.
2. Click on the More () icon at the top right.
3. Click **Analytics** from the listed options.

   The **Article analytics** modal window appears.
4. Click **Validate now** to perform validation.

   > NOTE
   >
   > The article/category-page link validation is unlimited.

---

## Manage links

Click **Manage links** on the Links status overview page.

The **Manage links** overview page will appear.  
This section provides a high-level view of all the top metrics in the broken links.

* **Search** - You can search for a specific URL.
* **Link type** - Refers to whether the link is an External or Internal URL.
* **Dependency** - The number of times the link has been referenced in the Knowledge base articles.
* **Status** - To choose to see if a link is Ignored or Included.

### Add links to Ignore/Include list

1. In the **Manage links** window, select the checkbox of the desired links you wish to ignore or include.
2. In the status column, you can set the status to **Ignored** or **Included** from the dropdown.

   (or)
3. Select the checkbox of the desired link of which you wish to change the status.
4. Click on the **Ignore** option available above the links list.

   The links that are set to Included status will be displayed in the **Included** tab, and the links set to Ignored status will be displayed under the **Ignored** tab.

   ![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/7_ScreenShot-Links_status_analytics.png)

### Export

You can export the links into .csv format to your local storage.

1. Click on the **Export CSV** button above the links list.
2. Wait for a few seconds, and a Download ()icon appears next to the **Export CSV** button.
3. Click on the Download () icon, and the exported file will be downloaded to your local computer storage.

---

## Troubleshooting

### Working links appear as broken in the Link status report

Document360 enforces a 5-second validation timeout for link verification. If a request exceeds this limit, the system may flag the link as **Unknown** or **Broken**. Even if the link is functional, it may be incorrectly marked as broken due to the timeout restriction.

**Steps to resolve:**

1. **Manually check the URL**

   1. Open the link in a browser to confirm if it loads correctly.
   2. If the page loads, the link may have been incorrectly flagged as broken.
2. **Validate the link using Postman**

   3. Open Postman and create a new request tab.
   4. Enter the URL and select the **GET** method.
   5. Click **Send** to check the response status.
3. **Interpret the HTTP response status**

   6. If the response is **200 OK**, the link is functional.
   7. If the response code is anything other than **200**, the link might be broken.

![Postman interface showing a GET request with highlighted parameters and response status.](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Screenshot-Troubleshooting_Link_status_validation_.png)

Some of the important status codes are:

| **Status code** | **Status description** | **Description** |
| --- | --- | --- |
| **200 OK** | Success | The request was successful, and the expected response was returned. |
| **201 Created** | Resource created | The request was successful, and a new resource was created. |
| **204 No content** | No response body | The request was successful, but there is no response body (common for DELETE requests). |
| **400 Bad request** | Invalid request | The request has incorrect syntax or missing parameters. |
| **401 Unauthorized** | Authentication required | The request lacks valid authentication credentials (e.g., missing or incorrect API key). |
| **403 Forbidden** | Access denied | The request is valid, but the user does not have permission to access the resource. |
| **404 Not found** | Resource missing | The requested resource does not exist or the endpoint is incorrect. |
| **405 Method not allowed** | Invalid method | The HTTP method (GET, POST, etc.) is not allowed for this endpoint. |
| **500 Internal server error** | Server issue | A generic error indicating something went wrong on the server. |
| **502 Bad gateway** | Invalid response | The server received an invalid response from an upstream server. |
| **503 Service unavailable** | Server overloaded | The server is down or overloaded with requests. |
| **504 Gateway timeout** | Timeout error | The server did not receive a response from another service in time. |

If the issue persists after following these steps, please contact the Document360 support team for further assistance: [Contact Document360 Support](https://document360.com/support/)

---

### FAQs

#### What is the purpose of the Links status feature in Document360?

The Links status feature is a broken link checker that helps validate and monitor all internal, external, and media file links on the knowledge base, improving SEO and reader experience.

#### What happens when a user exceeds the Manual validation limit?

When you exceed the validation limit as per your plan, the **Validate links** button will be disabled. The manual validation resets on the first day of every month, and the button is enabled again. You can contact our customer support if you need to increase this limit.

#### How can I prevent specific example links from being flagged as broken in the link status report?

If you have examples or placeholder links in your articles that are being detected as broken links in the analytics, you can exclude these links from validation to avoid confusion.

1. Navigate to **Analytics** () > **Link status**.
2. On the **Link status** page, click **Manage links** in the top-right corner.
3. In the **Manage links** page, by default, the **All links** tab will be selected.
4. Select the links you want to **ignore** from the list or use the search bar to find them.
5. Once you have selected the desired links, click **Ignore** ().

   The ignored links will be moved to the Ignored tab and will no longer appear in link validation reports.

If you want to include these links back in the validation process later:

1. Go to the **Ignored** tab.
2. Select the links you wish to include again.
3. Click **Include** (), and these links will be validated in future link checks.

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

<a id="ticket-deflector-overview"></a>

## Ticket deflector analytics

**Plans supporting the use of ticket deflector**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The **Ticket deflector** analytics page provides an overview of all key metrics related to the ticket deflector form(s) in your Knowledge base site or widget.

---

## Accessing the Ticket deflector analytics page

To view Ticket deflector analytics, from the Knowledge base portal, navigate to **Analytics** () and then select **Ticket deflector**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_ScreenShot-Ticket_deflector_analytics.png)

### Using filters to customize data

By default, the data shows metrics for the last week. You can adjust these using filters on both **Ticket deflector** and **Feedback** tabs:

1. Click the **Date** filter dropdown.
2. Select a predefined range (e.g., **This month**, **Last month**) or choose **Custom** to specify a date range.
3. For private and mixed projects, you can filter the search analytics by All users, Team accounts, and Readers.
4. If using the **Knowledge base widget**, use the top-right dropdown to switch between **Knowledge base** and **Widget analytics**.
5. Select the JWT widget to track and analyze user interactions and engagement of reader analytics within private and mixed projects secured by JWT authentication.

   For more information on Knowledge base widget JWT authentication, read the article on [Managing the Knowledge base widget](/help/docs/managing-the-knowledge-base-widget).

![Updated_Screenshot-JWT_for_Search_analytics_June_release](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/Updated_Screenshot-JWT_for_Search_analytics_June_release.png)

> NOTE
>
> Search analytics data can take up to 15 minutes to reflect in the Knowledge base portal.

---

### Ticket deflector tab

This is the default tab on the **Ticket deflector** analytics page. The **Ticket deflector** page shows the below four metric tiles:

| Field | Description |
| --- | --- |
| **Total feedback** | The total number of feedback entries including the responses from the Knowledge base and the number of forms submitted. |
| **Answered from knowledge base** | The number of queries answered by articles in the knowledge base. |
| **Form submitted** | The total number of ticket deflector forms submitted. |
| **Total search** | The total number of searches performed on the **Quick support** page of the Knowledge base. |

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734869391552.png)

---

## Sections of Ticket deflector tab

The **Ticket Deflector** tab displays various sections, each highlighting different aspects of its performance.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734869409488.png)

### 1. Satisfaction analysis

This graph shows the percentage of ticket deflector forms submitted and queries answered from the knowledge base. You can interact with the graphs by clicking on the legends at the bottom:

| Field | Description |
| --- | --- |
| **All** | Click to view the total number of feedback entries including the responses from the Knowledge base and the number of forms submitted. |
| **Form submitted** | Click to view the total number of ticket deflector forms submitted. |
| **Answered from knowledge base** | Click to view the total number of queries answered by articles in the knowledge base. |

1. Hover over the graph to find the metrics.
2. Click **Export image** ( ) to save the section as a PNG image.

---

### 2. Frequently selected questions

This section displays the top five most frequently chosen questions from the ticket deflector form. The list shows the questions and how often they were selected. You can export this list using the export () icon.

---

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/8_Screenshot-Ticket_deflector_analytics.png)

### 3. Satisfaction

This section displays a pie chart showing the proportion of forms submitted (orange color) and the number of questions successfully answered by the Knowledge base (green color).  
Click **Export image** ( ) to save the section as a PNG image.

---

### 4. Most useful articles

This section highlights the top articles that were helpful in resolving queries which represents the queries that produced successful search results. It provides the following details:

* **Articles**: The title of the article.
* **Answered**: The number of queries the article helped resolve.

---

### 5. Keywords

In this section, you can view data related to specific keyword searches. The following information is available:

* **Keyword**: The keyword searched by the user.
* **Count**: The number of times the keyword was searched.
* **Answer found**: Indicates whether a suitable answer was found.
* **Answer not found**: Indicates whether the search failed to return an answer.

1. Click **Export CSV** to export the articles in the list.
2. Click the **Download** () icon to download the last exported file.

---

### 6. Search success rate

This section shows the percentage of searches performed using the selected ticket deflector form(s). The chart displays the percentage of successful and unsuccessful searches. Searches that generate results are classified as successful, while those that yield no results are considered unsuccessful.

Click **Export image** ( ) to save the section as a PNG image.

---

## Feedback tab

* The **Feedback** tab displays all user feedback related to ticket deflector forms. Each feedback entry is labeled to indicate its source, such as **Form Submitted** or **Answered from Knowledge Base***.*
* Each feedback entry displays the date and time (in minutes) it was received.
* Click open a feedback to view the feedback content.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/image-1734869658688.png)

---

### FAQs

#### What is a ticket deflector?

A **ticket deflector** is a feature designed to reduce the number of support tickets by providing users with relevant Knowledge base articles before they submit a ticket. When users begin filling out the ticket form, the system suggests helpful articles that might answer their questions, deflecting the need to raise a support request.

#### How does the ticket deflector work?

The ticket deflector suggests relevant knowledge base articles based on keywords from the user's query or question. As users type into the form, the system automatically searches the knowledge base and displays suggested articles that may provide the solution, potentially preventing ticket submission.

#### What does the ‘*Answered from Knowledge Base’* metric represent?

The Answered from Knowledge Base metric shows the number of queries that were successfully resolved by the suggested articles in your knowledge base, without the user needing to submit a ticket. This helps measure the effectiveness of your knowledge base in reducing support requests.

#### How can I improve the effectiveness of the ticket deflector?

To improve the effectiveness of the ticket deflector:

* Ensure your knowledge base is up to date with accurate and comprehensive articles.
* Use clear and relevant keywords in your articles to improve searchability.
* Regularly review and update the **Frequently selected questions** section to better address common user queries.
* Analyze the **Search Success Rate** to identify gaps in your knowledge base and add or improve articles accordingly.

#### How is the Search success rate calculated?

The **Search Success Rate** represents the percentage of searches that returned a relevant article for the user's query. It compares the total number of searches performed with the number of successful searches that resulted in the user finding a helpful article.

A chart legend represents data series in a chart, using colors or symbols to differentiate them. For example, each column of data in a chart is shown in a unique color, with the colors and series names displayed as the legend

<a id="manage-api-documentation"></a>

## Managing API documentation

**Plans supporting  API document generation**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

The API documentation feature in Document360 makes it easy to create clear, interactive documentation by uploading your API specification files. This process automatically builds detailed documentation that covers everything from API endpoints to methods and responses, helping developers understand and use your API more effectively.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-New_API_button.png)

## Generating API documentation

There are three methods to generate API documentation in Document360:

* **From a URL**
* **From a JSON/YAML file**
* **With a CI/CD flow**

> NOTE
>
> Document360 supports OpenAPI 2.0, OpenAPI 3.0, and Postman API specifications.

### Generating API documentation from a URL

To upload the API specification file as a URL to Document360,

1. Navigate to the desired project in the Knowledge base portal.
2. Select **API documentation** (**{}**) from the left navigation bar.
3. Click the **Create** dropdown from the header menu bar and select **New API** or click the **New API** button from the top right corner. This will display the **New API reference** side panel.
4. In the **Choose source** screen, select the **Create from URL** radio button, and click **Next**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Create_API_from_URL.png)

5. In the **Source settings** screen, enter the URL for your API specification file in the **URL** field.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_Screenshot-URL_field.png)

6. Click **Add API reference** to navigate to the **Finish** screen.
7. On the **Finish** screen, you will be able to see the number of categories and articles that have been created for your API specification file.
8. Click **Publish** to generate your API documentation.

> NOTE
>
> If you wish to verify your API documentation before publishing, click **Close** on the Finish screen to return to the Documentation screen. You will be able to see the drafts of your API documentation in the **Categories & articles** pane.

### Generating API documentation from a JSON/YAML file

To upload the API specification file from a JSON/YAML file to Document360,

1. Navigate to the desired project in the Knowledge base portal.
2. Select **API documentation** (**{}**) from the left navigation bar.
3. Click the **Create** dropdown from the header menu bar and select **New API**. This will display the **New API reference** side panel.
4. In the **Choose source** screen, select the **Upload API definition** radio button, and click **Next**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_Screenshot-Create_API_from_JSON_YAML.png)

5. In the **Source settings** screen, upload the API specification file in either JSON or YAML format.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/6_Screenshot-Upload_API_definition.png)

6. Click **Add API reference** to navigate to the **Finish** screen.
7. On the **Finish** screen, you will be able to see the number of categories and articles that have been created for your API specification file.
8. Click **Publish** to generate your API documentation.

> NOTE
>
> To review your documentation before publishing, click **Close** to return to the Documentation screen. Your draft will be visible in the **Categories & Articles** pane.

### Generating API documentation with a CI/CD flow

Before you upload an API specification file with a CI/CD flow, ensure that the latest version of Node.js is installed on your system. If you are unfamiliar with Node.js, refer to [this guide](https://nodejs.org/en/learn/getting-started/how-to-install-nodejs) for installation instructions.

Next, from command prompt, install the d360 npm with the following command: `npm install d360 -g`

To upload the API specification file with a CI/CD flow,

1. Navigate to the desired project in the Knowledge base portal.
2. Select **API documentation** (**{}**) from the left navigation bar.
3. Click the **Create** dropdown from the header menu bar and select **New API**. This will display the **New API reference** side panel.
4. In the **Choose source** screen, select the **CI/CD Flow** radio button, and click **Next**.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_Screenshot-Create_API_with_CI_CD_flow.png)

5. Copy the API token from the **Source settings** screen.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/7_Screenshot-CI_CD_flow_API_key.png)

6. Paste the API token in the command line tool.
7. Choose the spec file path

   * For **JSON/YAML** file: Type your spec file's directory path in the "`--path`" parameter
   * For **URL**: Type your spec file URL in the "`--path`" parameter
8. Your API specification file will be imported, and API documentation will be generated

---

## Regenerate API documentation

If you make any changes to your API, such as adding any endpoints, you do not need to manually update your API documentation in Document360. You can simply regenerate your API documentation, and any changes in your API will automatically reflect in the API documentation.

> NOTE
>
> Any custom content you add to your API documentation will be retained when you regenerate your API documentation.

### Regenerate API documentation from URL

1. Navigate to the desired project in the Knowledge base portal.
2. Select **API documentation** (**{}**) from the left navigation bar.
3. Click **API docs reference** from the left navigation list pane.
4. Click the more (•••) icon next to the desired API reference for which you want to regenerate the API documentation.

   1. **To regenerate API documentation from the existing URL**:

      * Click **Resync.**
      * The API documentation will be regenerated as per the latest API specification file.
   2. **To regenerate API documentation with a new URL**:

      * Click **Edit.**
      * Enter the new URL in the **URL** field.
      * Click **Update.**
      * The API documentation will be regenerated as per the API specification file in the new URL.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/8_Screenshot-Resync_API_URL.png)

### Regenerate API documentation from an API specification file

1. Navigate to the desired project in the Knowledge base portal.
2. Select **API documentation** (**{}**) from the left navigation bar.
3. Click **API docs reference** from the left navigation list pane.
4. Click the more (•••) icon next to the desired API reference for which you want to regenerate the API documentation.
5. Click **Edit**.
6. Upload the latest API specification file in JSON/YAML format.
7. Click **Update**. The API documentation will be regenerated as per the latest API specification file.

![](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/9_Screenshot-Update_JSON_YAML_file.png)

### Regenerate API documentation integrated with CI/CD flow

You can resync the API reference in your CI/CD pipelines with the help of your [d360 npm packages](https://www.npmjs.com/package/d360). D360 is the command line tool that helps you set up workflows that sync your API docs to Document360.

You can also perform the resync manually using the below command.

```
d360 apidocs:resync 
                    --apiKey=API_key_value
                    --userId=user_id_value
                    --apiReferenceId=API_reference_value
                    --path=Spec_file_path
```

Plain text

Copy

---

### FAQs

**Can I keep the generated API documentation in the draft state?**

After uploading the API reference file, if you click **Close** instead of **Publish**, all the generated API documentation articles are kept in the draft state.

**Can I move a specific API endpoint article from one API reference folder to another in Document360?**

No, it is not possible to move a specific API endpoint article from one API reference folder to another. However, you can move API endpoint articles between subfolders within the same API reference folder.

**Can an article from the API documentation have the same URL as a Knowledge base articles?**

No, a knowledge base article and an API documentation article cannot have the same URL. However, you can keep them under the same subdomain.

**How often is an API reference file resynced?**

If you generated your API documentation from a URL, or a JSON/YAML file, the API reference file is not resynced automatically, and will have to be updated manually. If you want the API reference file to be resynced automatically, it is recommended to integrate the API reference file with CI/CD flow.

---

## Helpful links

* [**d360 npm package link**](https://www.npmjs.com/package/d360)
* [**Source code**](https://github.com/document360/d360)

Application Programming Interface - A set of rules that allows one software application to communicate with another.

<a id="edit-clone-and-delete"></a>

## Edit, Clone, and Delete widget

**Plans supporting editing the knowledge base widget**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

You can easily manage your Knowledge base Widget in Document360, as all the options are available in just a few clicks away.

## Edit Knowledge base Widget

1. Navigate to **Knowledge base Widget** in the Knowledge base portal.
2. Hover on the desired Knowledge base Widget and click () **Edit**.

![1_editwidget.png](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_editwidget.png)

3. Update the desired configurations in the **Configure & connect** tab.

![2_editwidget.png](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_editwidget.png)

4. Click **Save** to confirm the changes.

---

## Clone Knowledge base Widget

1. Navigate to **Knowledge base Widget** in the Knowledge base portal
2. Hover on the desired Knowledge base Widget that you want to clone.
3. Click (

   ) **Clone**.

![2_KBWidget_clone.png](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_KBWidget_clone.png)

4. Specify a title and update the desired configurations in **Configure & connect** tab.

![5_KBWidget_confirmclone.png](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/5_KBWidget_confirmclone.png)

5. Click **Save**.

---

## Delete Knowledge base Widget

1. Navigate to **Knowledge base Widget** in the Knowledge base portal.
2. Hover on the desired Knowledge base Widget that you want to delete.

![3_KBWidget_delete.png](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/3_KBWidget_delete%281%29.png)

3. Click (

   ) **Delete**.

![4_KBWidget_deletewidgetsetting.png](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/4_KBWidget_deletewidgetsetting.png)

4. Click **Yes** in the confirmation prompt. Click **No** to undo the process.

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

The platform where project members manage and create content for the knowledge base. It allows users to create categories, articles, and templates; manage files, team accounts, and readers; and configure site settings such as branding, domain, and security.

<a id="managing-and-customizing-the-knowledge-base-widget"></a>

## Managing and customizing the Knowledge base widget

**Plans supporting knowledge base widget**

| Professional | Business | Enterprise |
| --- | --- | --- |
|  |  |  |

## Customizing the knowledge base widget

You can customize each knowledge base widget to improve the user experience.

![1_Screenshot-Overview_page_of_KNowledge_base_Widget](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/1_Screenshot-Edit_kb_widget.png)

1. Log in to the Knowledge base portal and select your desired project.
2. Navigate to the **Widget ()** tab from the left navigation sidebar. The list of widgets created by the user will be displayed.
3. Hover over the desired widget and click the **Edit** (✎) icon.
4. In the **Configure & connect** tab, expand the **Style widget** section.
5. The following widget customization options are available:

   * [Widget color](/help/docs/styling-the-in-app-assistant#widget-color)
   * [Widget icon](/help/docs/styling-the-knowledge-base-widget#b-widget-icon)
   * [Widget position](/help/docs/styling-the-knowledge-base-widget#c-widget-position)
   * [Hide widget](/help/docs/styling-the-knowledge-base-widget#d-hide-widget)
   * [Hide most searched articles](/help/docs/styling-the-in-app-assistant#hide-most-searched-articles)

![2_Screenshot-Style_your_widget](https://cdn.document360.io/860f9f88-412e-4570-8222-d5bf2f4b7dd1/Images/Documentation/2_Screenshot-Edit_widget_style_widget_section.png)

### Widget color

You can choose the knowledge base widget theme color. This color is also set as the widget icon color.

1. Click **Change color** to open the color palette.
2. Select a color from the color picker or enter a hex, RGB, or HSL color code.

### Widget icon

Similarly, under the widget color section, you can replace the icon with an image or an available icon.

1. Click the **Change icon** button.
2. Choose an icon from the **Icon set** tab or insert an image from the **Insert image** tab:

   * To insert an image from a URL: Paste the URL and click **Insert.**
   * To upload an image: Click **Upload an image** and select a file from your Drive.

### Widget position

Choose the position of the widget launcher on your website or application.

1. Select **Left** or **Right** to change the widget position.
2. Enter the desired spacing values in the **Side spacing** and **Bottom spacing** fields to position the widget from the side or bottom of the window.

### Hide widget

When toggled on, the Knowledge base widget will be hidden.

NOTE

* The Knowledge base widget is enabled by default.
* To unhide a Knowledge base widget, turn off the **Hide widget** toggle and click **Save**.

### Hide most searched articles

When toggled on, the top search article section will be hidden.

> NOTE
>
> Enabling **Hide top search** disables the URL mapping functionality for the widget.

Once you complete making the desired customizations to the knowledge base widget, click the **Save** button next to the **Widget name** field.

---

## Adding a ticket deflector in Knowledge base widget

To add a ticket deflector to your Knowledge base widget,

1. Log in to the Knowledge base portal and select your desired project.
2. Navigate to the **Widget** tab from the left navigation sidebar. The list of widgets will be listed.
3. Hover over the desired widget 