# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

ABIDS_JSON_TOOL_PY_METADATA = Metadata(
    id="a9dbf330af1f3822b5e39734d477a5a6979179ef.boutiques",
    name="abids_json_tool.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


AbidsJsonToolPyParameters = typing.TypedDict('AbidsJsonToolPyParameters', {
    "__STYXTYPE__": typing.Literal["abids_json_tool.py"],
    "input_file": InputPathType,
    "prefix": str,
    "txt2json": bool,
    "json2txt": bool,
    "add_json": typing.NotRequired[list[str] | None],
    "del_json": typing.NotRequired[str | None],
    "force_add": bool,
    "overwrite": bool,
    "help": bool,
    "delimiter_major": typing.NotRequired[str | None],
    "delimiter_minor": typing.NotRequired[str | None],
    "literal_keys": bool,
    "values_stay_str": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "abids_json_tool.py": abids_json_tool_py_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class AbidsJsonToolPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `abids_json_tool_py(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def abids_json_tool_py_params(
    input_file: InputPathType,
    prefix: str,
    txt2json: bool = False,
    json2txt: bool = False,
    add_json: list[str] | None = None,
    del_json: str | None = None,
    force_add: bool = False,
    overwrite: bool = False,
    help_: bool = False,
    delimiter_major: str | None = None,
    delimiter_minor: str | None = None,
    literal_keys: bool = False,
    values_stay_str: bool = False,
) -> AbidsJsonToolPyParameters:
    """
    Build parameters.
    
    Args:
        input_file: One file to convert. Enter NULL with -add_json to create\
            new json file.
        prefix: Output file name.
        txt2json: Convert from ':' separated text file to json formatted file.
        json2txt: Convert from json formatted file to ':' separated text file.
        add_json: Add an attribute to the end of the specified json file.
        del_json: Remove attribute (KEY) from the -input json file.
        force_add: Use with -add_json to overwrite an existing attribute in the\
            specified json file.
        overwrite: Use caution as this will overwrite the -prefix file if it\
            exists!!.
        help_: Show this help and exit.
        delimiter_major: Specify the new (major) delimiter to separate keys and\
            values when using '-txt2json' opt.
        delimiter_minor: Specify the new (minor) delimiter to separate value\
            items when using '-txt2json' opt.
        literal_keys: Do not replace spaces with '_', nor parentheses and\
            brackets with ''.
        values_stay_str: Each numeric or str item gets saved as a str;\
            otherwise, guess at int and float.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "abids_json_tool.py",
        "input_file": input_file,
        "prefix": prefix,
        "txt2json": txt2json,
        "json2txt": json2txt,
        "force_add": force_add,
        "overwrite": overwrite,
        "help": help_,
        "literal_keys": literal_keys,
        "values_stay_str": values_stay_str,
    }
    if add_json is not None:
        params["add_json"] = add_json
    if del_json is not None:
        params["del_json"] = del_json
    if delimiter_major is not None:
        params["delimiter_major"] = delimiter_major
    if delimiter_minor is not None:
        params["delimiter_minor"] = delimiter_minor
    return params


def abids_json_tool_py_cargs(
    params: AbidsJsonToolPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("abids_json_tool.py")
    cargs.extend([
        "-input",
        execution.input_file(params.get("input_file"))
    ])
    cargs.extend([
        "-prefix",
        params.get("prefix")
    ])
    if params.get("txt2json"):
        cargs.append("-txt2json")
    if params.get("json2txt"):
        cargs.append("-json2txt")
    if params.get("add_json") is not None:
        cargs.extend([
            "-add_json",
            *params.get("add_json")
        ])
    if params.get("del_json") is not None:
        cargs.extend([
            "-del_json",
            params.get("del_json")
        ])
    if params.get("force_add"):
        cargs.append("-f")
    if params.get("overwrite"):
        cargs.append("-overwrite")
    if params.get("help"):
        cargs.append("-help")
    if params.get("delimiter_major") is not None:
        cargs.extend([
            "-delimiter_major",
            params.get("delimiter_major")
        ])
    if params.get("delimiter_minor") is not None:
        cargs.extend([
            "-delimiter_minor",
            params.get("delimiter_minor")
        ])
    if params.get("literal_keys"):
        cargs.append("-literal_keys")
    if params.get("values_stay_str"):
        cargs.append("-values_stay_str")
    return cargs


def abids_json_tool_py_outputs(
    params: AbidsJsonToolPyParameters,
    execution: Execution,
) -> AbidsJsonToolPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = AbidsJsonToolPyOutputs(
        root=execution.output_file("."),
    )
    return ret


def abids_json_tool_py_execute(
    params: AbidsJsonToolPyParameters,
    execution: Execution,
) -> AbidsJsonToolPyOutputs:
    """
    This script helps to manipulate json files in various ways.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `AbidsJsonToolPyOutputs`).
    """
    params = execution.params(params)
    cargs = abids_json_tool_py_cargs(params, execution)
    ret = abids_json_tool_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def abids_json_tool_py(
    input_file: InputPathType,
    prefix: str,
    txt2json: bool = False,
    json2txt: bool = False,
    add_json: list[str] | None = None,
    del_json: str | None = None,
    force_add: bool = False,
    overwrite: bool = False,
    help_: bool = False,
    delimiter_major: str | None = None,
    delimiter_minor: str | None = None,
    literal_keys: bool = False,
    values_stay_str: bool = False,
    runner: Runner | None = None,
) -> AbidsJsonToolPyOutputs:
    """
    This script helps to manipulate json files in various ways.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_file: One file to convert. Enter NULL with -add_json to create\
            new json file.
        prefix: Output file name.
        txt2json: Convert from ':' separated text file to json formatted file.
        json2txt: Convert from json formatted file to ':' separated text file.
        add_json: Add an attribute to the end of the specified json file.
        del_json: Remove attribute (KEY) from the -input json file.
        force_add: Use with -add_json to overwrite an existing attribute in the\
            specified json file.
        overwrite: Use caution as this will overwrite the -prefix file if it\
            exists!!.
        help_: Show this help and exit.
        delimiter_major: Specify the new (major) delimiter to separate keys and\
            values when using '-txt2json' opt.
        delimiter_minor: Specify the new (minor) delimiter to separate value\
            items when using '-txt2json' opt.
        literal_keys: Do not replace spaces with '_', nor parentheses and\
            brackets with ''.
        values_stay_str: Each numeric or str item gets saved as a str;\
            otherwise, guess at int and float.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AbidsJsonToolPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(ABIDS_JSON_TOOL_PY_METADATA)
    params = abids_json_tool_py_params(
        input_file=input_file,
        prefix=prefix,
        txt2json=txt2json,
        json2txt=json2txt,
        add_json=add_json,
        del_json=del_json,
        force_add=force_add,
        overwrite=overwrite,
        help_=help_,
        delimiter_major=delimiter_major,
        delimiter_minor=delimiter_minor,
        literal_keys=literal_keys,
        values_stay_str=values_stay_str,
    )
    return abids_json_tool_py_execute(params, execution)


__all__ = [
    "ABIDS_JSON_TOOL_PY_METADATA",
    "AbidsJsonToolPyOutputs",
    "AbidsJsonToolPyParameters",
    "abids_json_tool_py",
    "abids_json_tool_py_params",
]
