# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

ABIDS_TOOL_METADATA = Metadata(
    id="623988e726ff6bf6b4972b1940f6f0b4f38877f2.boutiques",
    name="abids_tool",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


AbidsToolParameters = typing.TypedDict('AbidsToolParameters', {
    "__STYXTYPE__": typing.Literal["abids_tool"],
    "input_files": list[InputPathType],
    "tr_match": bool,
    "add_tr": bool,
    "add_slice_times": bool,
    "copy_prefix": typing.NotRequired[list[str] | None],
    "help_flag": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "abids_tool": abids_tool_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class AbidsToolOutputs(typing.NamedTuple):
    """
    Output object returned when calling `abids_tool(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def abids_tool_params(
    input_files: list[InputPathType],
    tr_match: bool = False,
    add_tr: bool = False,
    add_slice_times: bool = False,
    copy_prefix: list[str] | None = None,
    help_flag: bool = False,
) -> AbidsToolParameters:
    """
    Build parameters.
    
    Args:
        input_files: At least one 3d+time dataset in NIFTI format.
        tr_match: Check if the TR in the json file matches the TR from input\
            dataset header. (Returns 1 if match).
        add_tr: Add the TR from the BIDS json file to the input dataset using\
            3drefit.
        add_slice_times: Add the slice times from the BIDS json file to the\
            input dataset using 3drefit.
        copy_prefix: Copy both the NIFTI dataset(s) and matching .json file(s)\
            to PREFIX. Must have the same number of prefixes as datasets.
        help_flag: Show help information and exit.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "abids_tool",
        "input_files": input_files,
        "tr_match": tr_match,
        "add_tr": add_tr,
        "add_slice_times": add_slice_times,
        "help_flag": help_flag,
    }
    if copy_prefix is not None:
        params["copy_prefix"] = copy_prefix
    return params


def abids_tool_cargs(
    params: AbidsToolParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("abids_tool.py")
    cargs.extend([execution.input_file(f) for f in params.get("input_files")])
    if params.get("tr_match"):
        cargs.append("-TR_match")
    if params.get("add_tr"):
        cargs.append("-add_TR")
    if params.get("add_slice_times"):
        cargs.append("-add_slice_times")
    if params.get("copy_prefix") is not None:
        cargs.extend([
            "-copy",
            *params.get("copy_prefix")
        ])
    if params.get("help_flag"):
        cargs.append("-help")
    return cargs


def abids_tool_outputs(
    params: AbidsToolParameters,
    execution: Execution,
) -> AbidsToolOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = AbidsToolOutputs(
        root=execution.output_file("."),
    )
    return ret


def abids_tool_execute(
    params: AbidsToolParameters,
    execution: Execution,
) -> AbidsToolOutputs:
    """
    A tool to work with BIDS formatted datasets created with dcm2niix_afni or
    dcm2niix, mainly to pull information from the matching JSON file and refit the
    input dataset using 3drefit.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `AbidsToolOutputs`).
    """
    params = execution.params(params)
    cargs = abids_tool_cargs(params, execution)
    ret = abids_tool_outputs(params, execution)
    execution.run(cargs)
    return ret


def abids_tool(
    input_files: list[InputPathType],
    tr_match: bool = False,
    add_tr: bool = False,
    add_slice_times: bool = False,
    copy_prefix: list[str] | None = None,
    help_flag: bool = False,
    runner: Runner | None = None,
) -> AbidsToolOutputs:
    """
    A tool to work with BIDS formatted datasets created with dcm2niix_afni or
    dcm2niix, mainly to pull information from the matching JSON file and refit the
    input dataset using 3drefit.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_files: At least one 3d+time dataset in NIFTI format.
        tr_match: Check if the TR in the json file matches the TR from input\
            dataset header. (Returns 1 if match).
        add_tr: Add the TR from the BIDS json file to the input dataset using\
            3drefit.
        add_slice_times: Add the slice times from the BIDS json file to the\
            input dataset using 3drefit.
        copy_prefix: Copy both the NIFTI dataset(s) and matching .json file(s)\
            to PREFIX. Must have the same number of prefixes as datasets.
        help_flag: Show help information and exit.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AbidsToolOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(ABIDS_TOOL_METADATA)
    params = abids_tool_params(
        input_files=input_files,
        tr_match=tr_match,
        add_tr=add_tr,
        add_slice_times=add_slice_times,
        copy_prefix=copy_prefix,
        help_flag=help_flag,
    )
    return abids_tool_execute(params, execution)


__all__ = [
    "ABIDS_TOOL_METADATA",
    "AbidsToolOutputs",
    "AbidsToolParameters",
    "abids_tool",
    "abids_tool_params",
]
