# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

ADJUNCT_COMBINE_STR_PY_METADATA = Metadata(
    id="000e1eed64bccb1d991895bd288ca5f9ee91719d.boutiques",
    name="adjunct_combine_str.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


AdjunctCombineStrPyParameters = typing.TypedDict('AdjunctCombineStrPyParameters', {
    "__STYXTYPE__": typing.Literal["adjunct_combine_str.py"],
    "output_file": str,
    "upper_index": float,
    "string_selectors": list[str],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "adjunct_combine_str.py": adjunct_combine_str_py_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "adjunct_combine_str.py": adjunct_combine_str_py_outputs,
    }.get(t)


class AdjunctCombineStrPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `adjunct_combine_str_py(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_selector_file: OutputPathType
    """The output file containing the new string selector"""


def adjunct_combine_str_py_params(
    output_file: str,
    upper_index: float,
    string_selectors: list[str],
) -> AdjunctCombineStrPyParameters:
    """
    Build parameters.
    
    Args:
        output_file: An output file name.
        upper_index: An int that is the upper index for the selector (-1 means\
            to use the max number in the input strings).
        string_selectors: One or more string selector strings of *goods* to\
            keep.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "adjunct_combine_str.py",
        "output_file": output_file,
        "upper_index": upper_index,
        "string_selectors": string_selectors,
    }
    return params


def adjunct_combine_str_py_cargs(
    params: AdjunctCombineStrPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("adjunct_combine_str.py")
    cargs.append(params.get("output_file"))
    cargs.append(str(params.get("upper_index")))
    cargs.extend(params.get("string_selectors"))
    return cargs


def adjunct_combine_str_py_outputs(
    params: AdjunctCombineStrPyParameters,
    execution: Execution,
) -> AdjunctCombineStrPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = AdjunctCombineStrPyOutputs(
        root=execution.output_file("."),
        output_selector_file=execution.output_file(params.get("output_file")),
    )
    return ret


def adjunct_combine_str_py_execute(
    params: AdjunctCombineStrPyParameters,
    execution: Execution,
) -> AdjunctCombineStrPyOutputs:
    """
    A simple helper function for fat_proc* scripts that processes string selectors
    and outputs a new string selector.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `AdjunctCombineStrPyOutputs`).
    """
    params = execution.params(params)
    cargs = adjunct_combine_str_py_cargs(params, execution)
    ret = adjunct_combine_str_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def adjunct_combine_str_py(
    output_file: str,
    upper_index: float,
    string_selectors: list[str],
    runner: Runner | None = None,
) -> AdjunctCombineStrPyOutputs:
    """
    A simple helper function for fat_proc* scripts that processes string selectors
    and outputs a new string selector.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        output_file: An output file name.
        upper_index: An int that is the upper index for the selector (-1 means\
            to use the max number in the input strings).
        string_selectors: One or more string selector strings of *goods* to\
            keep.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AdjunctCombineStrPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(ADJUNCT_COMBINE_STR_PY_METADATA)
    params = adjunct_combine_str_py_params(
        output_file=output_file,
        upper_index=upper_index,
        string_selectors=string_selectors,
    )
    return adjunct_combine_str_py_execute(params, execution)


__all__ = [
    "ADJUNCT_COMBINE_STR_PY_METADATA",
    "AdjunctCombineStrPyOutputs",
    "AdjunctCombineStrPyParameters",
    "adjunct_combine_str_py",
    "adjunct_combine_str_py_params",
]
