# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

ADJUNCT_MAKE_SCRIPT_AND_RST_PY_METADATA = Metadata(
    id="d715c1c643d7b006ced626bc661c6b0f3c88f4c5.boutiques",
    name="adjunct_make_script_and_rst.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


AdjunctMakeScriptAndRstPyParameters = typing.TypedDict('AdjunctMakeScriptAndRstPyParameters', {
    "__STYXTYPE__": typing.Literal["adjunct_make_script_and_rst.py"],
    "input_script": InputPathType,
    "prefix_rst": str,
    "prefix_script": str,
    "reflink": str,
    "execute_script": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "adjunct_make_script_and_rst.py": adjunct_make_script_and_rst_py_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "adjunct_make_script_and_rst.py": adjunct_make_script_and_rst_py_outputs,
    }.get(t)


class AdjunctMakeScriptAndRstPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `adjunct_make_script_and_rst_py(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    rst_file: OutputPathType
    """Generated RST documentation file."""
    script_file: OutputPathType
    """Generated script file."""
    output_directory: OutputPathType
    """Output directory in Sphinx tree."""


def adjunct_make_script_and_rst_py_params(
    input_script: InputPathType,
    prefix_rst: str,
    prefix_script: str,
    reflink: str,
    execute_script: bool = False,
) -> AdjunctMakeScriptAndRstPyParameters:
    """
    Build parameters.
    
    Args:
        input_script: Input script file with special markup.
        prefix_rst: Output filename including any path of the RST/Sphinx file.\
            Must include file extension '.rst'.
        prefix_script: Output filename of the script file. Should include file\
            extension such as '.tcsh'.
        reflink: A string tag that will serve as the subdirectory name holding\
            images for the given demo, and the RST internal reference label.
        execute_script: Flag to create the RST and script files, and also\
            execute the script.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "adjunct_make_script_and_rst.py",
        "input_script": input_script,
        "prefix_rst": prefix_rst,
        "prefix_script": prefix_script,
        "reflink": reflink,
        "execute_script": execute_script,
    }
    return params


def adjunct_make_script_and_rst_py_cargs(
    params: AdjunctMakeScriptAndRstPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("adjunct_make_script_and_rst.py")
    cargs.extend([
        "-input",
        execution.input_file(params.get("input_script"))
    ])
    cargs.extend([
        "--prefix_rst",
        params.get("prefix_rst")
    ])
    cargs.extend([
        "--prefix_script",
        params.get("prefix_script")
    ])
    cargs.extend([
        "--reflink",
        params.get("reflink")
    ])
    if params.get("execute_script"):
        cargs.append("--execute_script")
    return cargs


def adjunct_make_script_and_rst_py_outputs(
    params: AdjunctMakeScriptAndRstPyParameters,
    execution: Execution,
) -> AdjunctMakeScriptAndRstPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = AdjunctMakeScriptAndRstPyOutputs(
        root=execution.output_file("."),
        rst_file=execution.output_file(params.get("prefix_rst")),
        script_file=execution.output_file(params.get("prefix_script")),
        output_directory=execution.output_file(params.get("prefix_rst") + "/media/" + params.get("reflink")),
    )
    return ret


def adjunct_make_script_and_rst_py_execute(
    params: AdjunctMakeScriptAndRstPyParameters,
    execution: Execution,
) -> AdjunctMakeScriptAndRstPyOutputs:
    """
    Program to take a script with some special markup and turn it into both an RST
    page and a script for the online Sphinx documentation.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `AdjunctMakeScriptAndRstPyOutputs`).
    """
    params = execution.params(params)
    cargs = adjunct_make_script_and_rst_py_cargs(params, execution)
    ret = adjunct_make_script_and_rst_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def adjunct_make_script_and_rst_py(
    input_script: InputPathType,
    prefix_rst: str,
    prefix_script: str,
    reflink: str,
    execute_script: bool = False,
    runner: Runner | None = None,
) -> AdjunctMakeScriptAndRstPyOutputs:
    """
    Program to take a script with some special markup and turn it into both an RST
    page and a script for the online Sphinx documentation.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_script: Input script file with special markup.
        prefix_rst: Output filename including any path of the RST/Sphinx file.\
            Must include file extension '.rst'.
        prefix_script: Output filename of the script file. Should include file\
            extension such as '.tcsh'.
        reflink: A string tag that will serve as the subdirectory name holding\
            images for the given demo, and the RST internal reference label.
        execute_script: Flag to create the RST and script files, and also\
            execute the script.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AdjunctMakeScriptAndRstPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(ADJUNCT_MAKE_SCRIPT_AND_RST_PY_METADATA)
    params = adjunct_make_script_and_rst_py_params(
        input_script=input_script,
        prefix_rst=prefix_rst,
        prefix_script=prefix_script,
        reflink=reflink,
        execute_script=execute_script,
    )
    return adjunct_make_script_and_rst_py_execute(params, execution)


__all__ = [
    "ADJUNCT_MAKE_SCRIPT_AND_RST_PY_METADATA",
    "AdjunctMakeScriptAndRstPyOutputs",
    "AdjunctMakeScriptAndRstPyParameters",
    "adjunct_make_script_and_rst_py",
    "adjunct_make_script_and_rst_py_params",
]
