# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

ADJUNCT_SELECT_STR_PY_METADATA = Metadata(
    id="51bd0c93e4c33858ebe75938263e1d88647851a7.boutiques",
    name="adjunct_select_str.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


AdjunctSelectStrPyParameters = typing.TypedDict('AdjunctSelectStrPyParameters', {
    "__STYXTYPE__": typing.Literal["adjunct_select_str.py"],
    "input_file": InputPathType,
    "num_bricks": float,
    "output_file": str,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "adjunct_select_str.py": adjunct_select_str_py_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class AdjunctSelectStrPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `adjunct_select_str_py(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def adjunct_select_str_py_params(
    input_file: InputPathType,
    num_bricks: float,
    output_file: str,
) -> AdjunctSelectStrPyParameters:
    """
    Build parameters.
    
    Args:
        input_file: File containing a list of integers.
        num_bricks: The number N of bricks in the dataset (so max index is N-1).
        output_file: Output file name.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "adjunct_select_str.py",
        "input_file": input_file,
        "num_bricks": num_bricks,
        "output_file": output_file,
    }
    return params


def adjunct_select_str_py_cargs(
    params: AdjunctSelectStrPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("adjunct_select_str.py")
    cargs.append(execution.input_file(params.get("input_file")))
    cargs.append(str(params.get("num_bricks")))
    cargs.append(params.get("output_file"))
    return cargs


def adjunct_select_str_py_outputs(
    params: AdjunctSelectStrPyParameters,
    execution: Execution,
) -> AdjunctSelectStrPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = AdjunctSelectStrPyOutputs(
        root=execution.output_file("."),
    )
    return ret


def adjunct_select_str_py_execute(
    params: AdjunctSelectStrPyParameters,
    execution: Execution,
) -> AdjunctSelectStrPyOutputs:
    """
    A simple helper function for the fat_proc* scripts.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `AdjunctSelectStrPyOutputs`).
    """
    params = execution.params(params)
    cargs = adjunct_select_str_py_cargs(params, execution)
    ret = adjunct_select_str_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def adjunct_select_str_py(
    input_file: InputPathType,
    num_bricks: float,
    output_file: str,
    runner: Runner | None = None,
) -> AdjunctSelectStrPyOutputs:
    """
    A simple helper function for the fat_proc* scripts.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_file: File containing a list of integers.
        num_bricks: The number N of bricks in the dataset (so max index is N-1).
        output_file: Output file name.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AdjunctSelectStrPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(ADJUNCT_SELECT_STR_PY_METADATA)
    params = adjunct_select_str_py_params(
        input_file=input_file,
        num_bricks=num_bricks,
        output_file=output_file,
    )
    return adjunct_select_str_py_execute(params, execution)


__all__ = [
    "ADJUNCT_SELECT_STR_PY_METADATA",
    "AdjunctSelectStrPyOutputs",
    "AdjunctSelectStrPyParameters",
    "adjunct_select_str_py",
    "adjunct_select_str_py_params",
]
