# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

ADJUNCT_SUMA_FS_ROI_INFO_METADATA = Metadata(
    id="174d682bbfbcc03f436d1ab2dd83376c7847145f.boutiques",
    name="adjunct_suma_fs_roi_info",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


AdjunctSumaFsRoiInfoParameters = typing.TypedDict('AdjunctSumaFsRoiInfoParameters', {
    "__STYXTYPE__": typing.Literal["adjunct_suma_fs_roi_info"],
    "subject_id": str,
    "suma_directory": str,
    "help": bool,
    "hview": bool,
    "version": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "adjunct_suma_fs_roi_info": adjunct_suma_fs_roi_info_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "adjunct_suma_fs_roi_info": adjunct_suma_fs_roi_info_outputs,
    }.get(t)


class AdjunctSumaFsRoiInfoOutputs(typing.NamedTuple):
    """
    Output object returned when calling `adjunct_suma_fs_roi_info(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    rois_2000_ft: OutputPathType
    """Info for the '2000' parcellation."""
    rois_2009_ft: OutputPathType
    """Info for the '2009' parcellation."""
    segs_2000_ft: OutputPathType
    """Info for the '2000' parcellation brain mask and tissue/segmentations."""
    segs_2009_ft: OutputPathType
    """Info for the '2009' parcellation brain mask and tissue/segmentations."""


def adjunct_suma_fs_roi_info_params(
    subject_id: str,
    suma_directory: str,
    help_: bool = False,
    hview: bool = False,
    version: bool = False,
) -> AdjunctSumaFsRoiInfoParameters:
    """
    Build parameters.
    
    Args:
        subject_id: Subject ID.
        suma_directory: SUMA directory output by AFNI's @SUMA_Make_Spec_FS.
        help_: Show help.
        hview: Show help in text editor.
        version: Show version.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "adjunct_suma_fs_roi_info",
        "subject_id": subject_id,
        "suma_directory": suma_directory,
        "help": help_,
        "hview": hview,
        "version": version,
    }
    return params


def adjunct_suma_fs_roi_info_cargs(
    params: AdjunctSumaFsRoiInfoParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("adjunct_suma_fs_roi_info")
    cargs.extend([
        "-sid",
        params.get("subject_id")
    ])
    cargs.extend([
        "-suma_dir",
        params.get("suma_directory")
    ])
    if params.get("help"):
        cargs.append("-help")
    if params.get("hview"):
        cargs.append("-hview")
    if params.get("version"):
        cargs.append("-ver")
    return cargs


def adjunct_suma_fs_roi_info_outputs(
    params: AdjunctSumaFsRoiInfoParameters,
    execution: Execution,
) -> AdjunctSumaFsRoiInfoOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = AdjunctSumaFsRoiInfoOutputs(
        root=execution.output_file("."),
        rois_2000_ft=execution.output_file("stats_fs_rois_2000_FT.1D"),
        rois_2009_ft=execution.output_file("stats_fs_rois_2009_FT.1D"),
        segs_2000_ft=execution.output_file("stats_fs_segs_2000_FT.1D"),
        segs_2009_ft=execution.output_file("stats_fs_segs_2009_FT.1D"),
    )
    return ret


def adjunct_suma_fs_roi_info_execute(
    params: AdjunctSumaFsRoiInfoParameters,
    execution: Execution,
) -> AdjunctSumaFsRoiInfoOutputs:
    """
    Script for making ROI stats for the SUMA/ directory created by
    @SUMA_Make_Spec_FS after running FreeSurfer's recon-all.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `AdjunctSumaFsRoiInfoOutputs`).
    """
    params = execution.params(params)
    cargs = adjunct_suma_fs_roi_info_cargs(params, execution)
    ret = adjunct_suma_fs_roi_info_outputs(params, execution)
    execution.run(cargs)
    return ret


def adjunct_suma_fs_roi_info(
    subject_id: str,
    suma_directory: str,
    help_: bool = False,
    hview: bool = False,
    version: bool = False,
    runner: Runner | None = None,
) -> AdjunctSumaFsRoiInfoOutputs:
    """
    Script for making ROI stats for the SUMA/ directory created by
    @SUMA_Make_Spec_FS after running FreeSurfer's recon-all.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        subject_id: Subject ID.
        suma_directory: SUMA directory output by AFNI's @SUMA_Make_Spec_FS.
        help_: Show help.
        hview: Show help in text editor.
        version: Show version.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AdjunctSumaFsRoiInfoOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(ADJUNCT_SUMA_FS_ROI_INFO_METADATA)
    params = adjunct_suma_fs_roi_info_params(
        subject_id=subject_id,
        suma_directory=suma_directory,
        help_=help_,
        hview=hview,
        version=version,
    )
    return adjunct_suma_fs_roi_info_execute(params, execution)


__all__ = [
    "ADJUNCT_SUMA_FS_ROI_INFO_METADATA",
    "AdjunctSumaFsRoiInfoOutputs",
    "AdjunctSumaFsRoiInfoParameters",
    "adjunct_suma_fs_roi_info",
    "adjunct_suma_fs_roi_info_params",
]
