# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

AFNI_OPEN_METADATA = Metadata(
    id="87c5cb2a1fc95478c838202fe74a9d66e957b97d.boutiques",
    name="afni_open",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


AfniOpenParameters = typing.TypedDict('AfniOpenParameters', {
    "__STYXTYPE__": typing.Literal["afni_open"],
    "files": list[InputPathType],
    "method": typing.NotRequired[str | None],
    "editor": bool,
    "downloader": bool,
    "examinexmat": bool,
    "browser": bool,
    "readme": bool,
    "afniweb": bool,
    "global_help": bool,
    "gopts_help": bool,
    "help": bool,
    "mini_help": bool,
    "extreme_help": bool,
    "h_view": bool,
    "h_web": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "afni_open": afni_open_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class AfniOpenOutputs(typing.NamedTuple):
    """
    Output object returned when calling `afni_open(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def afni_open_params(
    files: list[InputPathType],
    method: str | None = None,
    editor: bool = False,
    downloader: bool = False,
    examinexmat: bool = False,
    browser: bool = False,
    readme: bool = False,
    afniweb: bool = False,
    global_help: bool = False,
    gopts_help: bool = False,
    help_: bool = False,
    mini_help: bool = False,
    extreme_help: bool = False,
    h_view: bool = False,
    h_web: bool = False,
) -> AfniOpenParameters:
    """
    Build parameters.
    
    Args:
        files: Input file(s) to be opened.
        method: Method to open files (editor, downloader, browser, afni, suma,\
            1dplot, ExamineXmat, iviewer, afniweb, readme).
        editor: Same as -w editor.
        downloader: Same as -w downloader.
        examinexmat: Same as -w ExamineXmat.
        browser: Same as -w browser.
        readme: Same as -w readme.
        afniweb: Same as -w afniweb.
        global_help: Show help for global options.
        gopts_help: Show help for global options.
        help_: The entire help output.
        mini_help: Mini help.
        extreme_help: Extreme help.
        h_view: Open help in text editor.
        h_web: Open help in web browser.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "afni_open",
        "files": files,
        "editor": editor,
        "downloader": downloader,
        "examinexmat": examinexmat,
        "browser": browser,
        "readme": readme,
        "afniweb": afniweb,
        "global_help": global_help,
        "gopts_help": gopts_help,
        "help": help_,
        "mini_help": mini_help,
        "extreme_help": extreme_help,
        "h_view": h_view,
        "h_web": h_web,
    }
    if method is not None:
        params["method"] = method
    return params


def afni_open_cargs(
    params: AfniOpenParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("afni_open")
    cargs.extend([execution.input_file(f) for f in params.get("files")])
    if params.get("method") is not None:
        cargs.extend([
            "-w",
            params.get("method")
        ])
    if params.get("editor"):
        cargs.append("-e")
    if params.get("downloader"):
        cargs.append("-d")
    if params.get("examinexmat"):
        cargs.append("-x")
    if params.get("browser"):
        cargs.append("-b")
    if params.get("readme"):
        cargs.append("-r")
    if params.get("afniweb"):
        cargs.append("-aw")
    if params.get("global_help"):
        cargs.append("-global_help")
    if params.get("gopts_help"):
        cargs.append("-gopts_help")
    if params.get("help"):
        cargs.append("-help")
    if params.get("mini_help"):
        cargs.append("-h")
    if params.get("extreme_help"):
        cargs.append("-HELP")
    if params.get("h_view"):
        cargs.append("-h_view")
    if params.get("h_web"):
        cargs.append("-h_web")
    return cargs


def afni_open_outputs(
    params: AfniOpenParameters,
    execution: Execution,
) -> AfniOpenOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = AfniOpenOutputs(
        root=execution.output_file("."),
    )
    return ret


def afni_open_execute(
    params: AfniOpenParameters,
    execution: Execution,
) -> AfniOpenOutputs:
    """
    A program to open various AFNI/SUMA files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `AfniOpenOutputs`).
    """
    params = execution.params(params)
    cargs = afni_open_cargs(params, execution)
    ret = afni_open_outputs(params, execution)
    execution.run(cargs)
    return ret


def afni_open(
    files: list[InputPathType],
    method: str | None = None,
    editor: bool = False,
    downloader: bool = False,
    examinexmat: bool = False,
    browser: bool = False,
    readme: bool = False,
    afniweb: bool = False,
    global_help: bool = False,
    gopts_help: bool = False,
    help_: bool = False,
    mini_help: bool = False,
    extreme_help: bool = False,
    h_view: bool = False,
    h_web: bool = False,
    runner: Runner | None = None,
) -> AfniOpenOutputs:
    """
    A program to open various AFNI/SUMA files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        files: Input file(s) to be opened.
        method: Method to open files (editor, downloader, browser, afni, suma,\
            1dplot, ExamineXmat, iviewer, afniweb, readme).
        editor: Same as -w editor.
        downloader: Same as -w downloader.
        examinexmat: Same as -w ExamineXmat.
        browser: Same as -w browser.
        readme: Same as -w readme.
        afniweb: Same as -w afniweb.
        global_help: Show help for global options.
        gopts_help: Show help for global options.
        help_: The entire help output.
        mini_help: Mini help.
        extreme_help: Extreme help.
        h_view: Open help in text editor.
        h_web: Open help in web browser.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AfniOpenOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(AFNI_OPEN_METADATA)
    params = afni_open_params(
        files=files,
        method=method,
        editor=editor,
        downloader=downloader,
        examinexmat=examinexmat,
        browser=browser,
        readme=readme,
        afniweb=afniweb,
        global_help=global_help,
        gopts_help=gopts_help,
        help_=help_,
        mini_help=mini_help,
        extreme_help=extreme_help,
        h_view=h_view,
        h_web=h_web,
    )
    return afni_open_execute(params, execution)


__all__ = [
    "AFNI_OPEN_METADATA",
    "AfniOpenOutputs",
    "AfniOpenParameters",
    "afni_open",
    "afni_open_params",
]
