# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

AFNI_PROC_PY_METADATA = Metadata(
    id="7969059f0ff122f045207188e28f2aea49969161.boutiques",
    name="afni_proc.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


AfniProcPyParameters = typing.TypedDict('AfniProcPyParameters', {
    "__STYXTYPE__": typing.Literal["afni_proc.py"],
    "dsets": list[InputPathType],
    "subj_id": str,
    "out_dir": typing.NotRequired[str | None],
    "blocks": typing.NotRequired[list[str] | None],
    "anat": InputPathType,
    "echo_times": typing.NotRequired[list[float] | None],
    "stim_times": typing.NotRequired[list[InputPathType] | None],
    "stim_files": typing.NotRequired[list[InputPathType] | None],
    "copy_files": typing.NotRequired[list[InputPathType] | None],
    "copy_anat": typing.NotRequired[InputPathType | None],
    "regress_params": typing.NotRequired[list[str] | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "afni_proc.py": afni_proc_py_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "afni_proc.py": afni_proc_py_outputs,
    }.get(t)


class AfniProcPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `afni_proc_py(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_files: OutputPathType | None
    """All output files stored in the specified output directory."""


def afni_proc_py_params(
    dsets: list[InputPathType],
    subj_id: str,
    anat: InputPathType,
    out_dir: str | None = None,
    blocks: list[str] | None = None,
    echo_times: list[float] | None = None,
    stim_times: list[InputPathType] | None = None,
    stim_files: list[InputPathType] | None = None,
    copy_files: list[InputPathType] | None = None,
    copy_anat: InputPathType | None = None,
    regress_params: list[str] | None = None,
) -> AfniProcPyParameters:
    """
    Build parameters.
    
    Args:
        dsets: Specify the EPI dataset files. (e.g. epi_run1+orig,\
            epi_run2+orig).
        subj_id: Specify the subject ID for the script.
        anat: Specify the anatomical dataset.
        out_dir: Specify the output directory for the script.
        blocks: Specify the processing blocks to apply (e.g. tshift volreg blur\
            mask scale regress).
        echo_times: Specify echo times for multi-echo data processing.
        stim_times: Specify files used for stimulus timing in -stim_times.
        stim_files: Specify TR-locked stim files for 3dDeconvolve -stim_file\
            instead of -stim_times.
        copy_files: Specify additional files to be copied to the results\
            directory.
        copy_anat: Copy the anatomical dataset(s) to the results directory.
        regress_params: Specify extra options for 3dDeconvolve.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "afni_proc.py",
        "dsets": dsets,
        "subj_id": subj_id,
        "anat": anat,
    }
    if out_dir is not None:
        params["out_dir"] = out_dir
    if blocks is not None:
        params["blocks"] = blocks
    if echo_times is not None:
        params["echo_times"] = echo_times
    if stim_times is not None:
        params["stim_times"] = stim_times
    if stim_files is not None:
        params["stim_files"] = stim_files
    if copy_files is not None:
        params["copy_files"] = copy_files
    if copy_anat is not None:
        params["copy_anat"] = copy_anat
    if regress_params is not None:
        params["regress_params"] = regress_params
    return params


def afni_proc_py_cargs(
    params: AfniProcPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("afni_proc.py")
    cargs.extend([execution.input_file(f) for f in params.get("dsets")])
    cargs.append(params.get("subj_id"))
    if params.get("out_dir") is not None:
        cargs.append(params.get("out_dir"))
    if params.get("blocks") is not None:
        cargs.extend(params.get("blocks"))
    cargs.append(execution.input_file(params.get("anat")))
    if params.get("echo_times") is not None:
        cargs.extend(map(str, params.get("echo_times")))
    if params.get("stim_times") is not None:
        cargs.extend([execution.input_file(f) for f in params.get("stim_times")])
    if params.get("stim_files") is not None:
        cargs.extend([execution.input_file(f) for f in params.get("stim_files")])
    if params.get("copy_files") is not None:
        cargs.extend([execution.input_file(f) for f in params.get("copy_files")])
    if params.get("copy_anat") is not None:
        cargs.append(execution.input_file(params.get("copy_anat")))
    if params.get("regress_params") is not None:
        cargs.extend([
            "-regress_opts_3dD",
            *params.get("regress_params")
        ])
    return cargs


def afni_proc_py_outputs(
    params: AfniProcPyParameters,
    execution: Execution,
) -> AfniProcPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = AfniProcPyOutputs(
        root=execution.output_file("."),
        output_files=execution.output_file(params.get("out_dir") + "/*") if (params.get("out_dir") is not None) else None,
    )
    return ret


def afni_proc_py_execute(
    params: AfniProcPyParameters,
    execution: Execution,
) -> AfniProcPyOutputs:
    """
    Generate a tcsh script for an AFNI single subject processing stream.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `AfniProcPyOutputs`).
    """
    params = execution.params(params)
    cargs = afni_proc_py_cargs(params, execution)
    ret = afni_proc_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def afni_proc_py(
    dsets: list[InputPathType],
    subj_id: str,
    anat: InputPathType,
    out_dir: str | None = None,
    blocks: list[str] | None = None,
    echo_times: list[float] | None = None,
    stim_times: list[InputPathType] | None = None,
    stim_files: list[InputPathType] | None = None,
    copy_files: list[InputPathType] | None = None,
    copy_anat: InputPathType | None = None,
    regress_params: list[str] | None = None,
    runner: Runner | None = None,
) -> AfniProcPyOutputs:
    """
    Generate a tcsh script for an AFNI single subject processing stream.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dsets: Specify the EPI dataset files. (e.g. epi_run1+orig,\
            epi_run2+orig).
        subj_id: Specify the subject ID for the script.
        anat: Specify the anatomical dataset.
        out_dir: Specify the output directory for the script.
        blocks: Specify the processing blocks to apply (e.g. tshift volreg blur\
            mask scale regress).
        echo_times: Specify echo times for multi-echo data processing.
        stim_times: Specify files used for stimulus timing in -stim_times.
        stim_files: Specify TR-locked stim files for 3dDeconvolve -stim_file\
            instead of -stim_times.
        copy_files: Specify additional files to be copied to the results\
            directory.
        copy_anat: Copy the anatomical dataset(s) to the results directory.
        regress_params: Specify extra options for 3dDeconvolve.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AfniProcPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(AFNI_PROC_PY_METADATA)
    params = afni_proc_py_params(
        dsets=dsets,
        subj_id=subj_id,
        out_dir=out_dir,
        blocks=blocks,
        anat=anat,
        echo_times=echo_times,
        stim_times=stim_times,
        stim_files=stim_files,
        copy_files=copy_files,
        copy_anat=copy_anat,
        regress_params=regress_params,
    )
    return afni_proc_py_execute(params, execution)


__all__ = [
    "AFNI_PROC_PY_METADATA",
    "AfniProcPyOutputs",
    "AfniProcPyParameters",
    "afni_proc_py",
    "afni_proc_py_params",
]
