# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

AFNI_RUN_R_METADATA = Metadata(
    id="c25de8aaab9b4faa0067fa6c9d3361eb1f13f7bf.boutiques",
    name="afni_run_R",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


AfniRunRParameters = typing.TypedDict('AfniRunRParameters', {
    "__STYXTYPE__": typing.Literal["afni_run_R"],
    "r_script": InputPathType,
    "r_args": list[str],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "afni_run_R": afni_run_r_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class AfniRunROutputs(typing.NamedTuple):
    """
    Output object returned when calling `afni_run_r(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def afni_run_r_params(
    r_script: InputPathType,
    r_args: list[str],
) -> AfniRunRParameters:
    """
    Build parameters.
    
    Args:
        r_script: R script to be executed.
        r_args: Arguments to be passed to the R script.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "afni_run_R",
        "r_script": r_script,
        "r_args": r_args,
    }
    return params


def afni_run_r_cargs(
    params: AfniRunRParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("afni_run_R")
    cargs.append(execution.input_file(params.get("r_script")))
    cargs.extend(params.get("r_args"))
    return cargs


def afni_run_r_outputs(
    params: AfniRunRParameters,
    execution: Execution,
) -> AfniRunROutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = AfniRunROutputs(
        root=execution.output_file("."),
    )
    return ret


def afni_run_r_execute(
    params: AfniRunRParameters,
    execution: Execution,
) -> AfniRunROutputs:
    """
    Run an R script with the specified arguments.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `AfniRunROutputs`).
    """
    params = execution.params(params)
    cargs = afni_run_r_cargs(params, execution)
    ret = afni_run_r_outputs(params, execution)
    execution.run(cargs)
    return ret


def afni_run_r(
    r_script: InputPathType,
    r_args: list[str],
    runner: Runner | None = None,
) -> AfniRunROutputs:
    """
    Run an R script with the specified arguments.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        r_script: R script to be executed.
        r_args: Arguments to be passed to the R script.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AfniRunROutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(AFNI_RUN_R_METADATA)
    params = afni_run_r_params(
        r_script=r_script,
        r_args=r_args,
    )
    return afni_run_r_execute(params, execution)


__all__ = [
    "AFNI_RUN_R_METADATA",
    "AfniRunROutputs",
    "AfniRunRParameters",
    "afni_run_r",
    "afni_run_r_params",
]
