# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

AIV_METADATA = Metadata(
    id="15fdfbd8f9f110092da69182fb86e63bdd365727.boutiques",
    name="aiv",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


AivParameters = typing.TypedDict('AivParameters', {
    "__STYXTYPE__": typing.Literal["aiv"],
    "verbose": bool,
    "quiet": bool,
    "title": typing.NotRequired[str | None],
    "port": typing.NotRequired[float | None],
    "pad": typing.NotRequired[str | None],
    "input_images": list[InputPathType],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "aiv": aiv_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class AivOutputs(typing.NamedTuple):
    """
    Output object returned when calling `aiv(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def aiv_params(
    input_images: list[InputPathType],
    verbose: bool = False,
    quiet: bool = False,
    title: str | None = None,
    port: float | None = None,
    pad: str | None = None,
) -> AivParameters:
    """
    Build parameters.
    
    Args:
        input_images: Input image files (e.g., img1.jpg, img2.bmp).
        verbose: Print out the image filenames for progress tracking.
        quiet: Run the program in quiet mode.
        title: Specify the window title.
        port: Listen to TCP/IP port for incoming images.
        pad: Pad all input images to be the same size.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "aiv",
        "verbose": verbose,
        "quiet": quiet,
        "input_images": input_images,
    }
    if title is not None:
        params["title"] = title
    if port is not None:
        params["port"] = port
    if pad is not None:
        params["pad"] = pad
    return params


def aiv_cargs(
    params: AivParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("aiv")
    if params.get("verbose"):
        cargs.append("-v")
    if params.get("quiet"):
        cargs.append("-q")
    if params.get("title") is not None:
        cargs.extend([
            "-title",
            params.get("title")
        ])
    if params.get("port") is not None:
        cargs.extend([
            "-p",
            str(params.get("port"))
        ])
    if params.get("pad") is not None:
        cargs.extend([
            "-pad",
            params.get("pad")
        ])
    cargs.extend([execution.input_file(f) for f in params.get("input_images")])
    return cargs


def aiv_outputs(
    params: AivParameters,
    execution: Execution,
) -> AivOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = AivOutputs(
        root=execution.output_file("."),
    )
    return ret


def aiv_execute(
    params: AivParameters,
    execution: Execution,
) -> AivOutputs:
    """
    AFNI Image Viewer program. Shows the 2D images on the command line in an
    AFNI-like image viewer.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `AivOutputs`).
    """
    params = execution.params(params)
    cargs = aiv_cargs(params, execution)
    ret = aiv_outputs(params, execution)
    execution.run(cargs)
    return ret


def aiv(
    input_images: list[InputPathType],
    verbose: bool = False,
    quiet: bool = False,
    title: str | None = None,
    port: float | None = None,
    pad: str | None = None,
    runner: Runner | None = None,
) -> AivOutputs:
    """
    AFNI Image Viewer program. Shows the 2D images on the command line in an
    AFNI-like image viewer.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_images: Input image files (e.g., img1.jpg, img2.bmp).
        verbose: Print out the image filenames for progress tracking.
        quiet: Run the program in quiet mode.
        title: Specify the window title.
        port: Listen to TCP/IP port for incoming images.
        pad: Pad all input images to be the same size.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AivOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(AIV_METADATA)
    params = aiv_params(
        verbose=verbose,
        quiet=quiet,
        title=title,
        port=port,
        pad=pad,
        input_images=input_images,
    )
    return aiv_execute(params, execution)


__all__ = [
    "AIV_METADATA",
    "AivOutputs",
    "AivParameters",
    "aiv",
    "aiv_params",
]
