# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

APQC_MAKE_TCSH_PY_METADATA = Metadata(
    id="7c727cf4831b8e83a2479b91545d58e11b202d3a.boutiques",
    name="apqc_make_tcsh.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


ApqcMakeTcshPyParameters = typing.TypedDict('ApqcMakeTcshPyParameters', {
    "__STYXTYPE__": typing.Literal["apqc_make_tcsh.py"],
    "uvar_json": InputPathType,
    "subj_dir": str,
    "review_style": typing.NotRequired[str | None],
    "mot_grayplot_off": bool,
    "vstat_list": typing.NotRequired[list[str] | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "apqc_make_tcsh.py": apqc_make_tcsh_py_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class ApqcMakeTcshPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `apqc_make_tcsh_py(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def apqc_make_tcsh_py_params(
    uvar_json: InputPathType,
    subj_dir: str,
    review_style: str | None = None,
    mot_grayplot_off: bool = False,
    vstat_list: list[str] | None = None,
) -> ApqcMakeTcshPyParameters:
    """
    Build parameters.
    
    Args:
        uvar_json: Text file of user variables created by gen_ss_review.py that\
            catalogs important files in the results directory for the APQC.
        subj_dir: Location of AP results directory (often '.', as this program\
            is often run from within the AP results directory).
        review_style: The 'style' of the APQC HTML output HTML. Allowed\
            keywords are: {none, basic, pythonic}. Using 'pythonic' is recommended.
        mot_grayplot_off: Turn off the grayplot generation. This option was\
            created for a specific case with a large dataset. Not recommended to\
            use generally.
        vstat_list: Provide a list of label items to specify which volume's\
            images should appear in the vstat QC block. Each item should correspond\
            to subbrick label basename in the stats_dset. 'Full_Fstat' is always\
            included. If not used, default logic picks up to 5 items to show.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "apqc_make_tcsh.py",
        "uvar_json": uvar_json,
        "subj_dir": subj_dir,
        "mot_grayplot_off": mot_grayplot_off,
    }
    if review_style is not None:
        params["review_style"] = review_style
    if vstat_list is not None:
        params["vstat_list"] = vstat_list
    return params


def apqc_make_tcsh_py_cargs(
    params: ApqcMakeTcshPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("apqc_make_tcsh.py")
    cargs.extend([
        "-uvar_json",
        execution.input_file(params.get("uvar_json"))
    ])
    cargs.extend([
        "-subj_dir",
        params.get("subj_dir")
    ])
    if params.get("review_style") is not None:
        cargs.extend([
            "-review_style",
            params.get("review_style")
        ])
    if params.get("mot_grayplot_off"):
        cargs.append("-mot_grayplot_off")
    if params.get("vstat_list") is not None:
        cargs.extend([
            "-vstat_list",
            *params.get("vstat_list")
        ])
    return cargs


def apqc_make_tcsh_py_outputs(
    params: ApqcMakeTcshPyParameters,
    execution: Execution,
) -> ApqcMakeTcshPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = ApqcMakeTcshPyOutputs(
        root=execution.output_file("."),
    )
    return ret


def apqc_make_tcsh_py_execute(
    params: ApqcMakeTcshPyParameters,
    execution: Execution,
) -> ApqcMakeTcshPyOutputs:
    """
    This program creates the single subject (ss) HTML review script
    '@ss_review_html' which generates images and text for the afni_proc.py quality
    control (APQC) HTML.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `ApqcMakeTcshPyOutputs`).
    """
    params = execution.params(params)
    cargs = apqc_make_tcsh_py_cargs(params, execution)
    ret = apqc_make_tcsh_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def apqc_make_tcsh_py(
    uvar_json: InputPathType,
    subj_dir: str,
    review_style: str | None = None,
    mot_grayplot_off: bool = False,
    vstat_list: list[str] | None = None,
    runner: Runner | None = None,
) -> ApqcMakeTcshPyOutputs:
    """
    This program creates the single subject (ss) HTML review script
    '@ss_review_html' which generates images and text for the afni_proc.py quality
    control (APQC) HTML.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        uvar_json: Text file of user variables created by gen_ss_review.py that\
            catalogs important files in the results directory for the APQC.
        subj_dir: Location of AP results directory (often '.', as this program\
            is often run from within the AP results directory).
        review_style: The 'style' of the APQC HTML output HTML. Allowed\
            keywords are: {none, basic, pythonic}. Using 'pythonic' is recommended.
        mot_grayplot_off: Turn off the grayplot generation. This option was\
            created for a specific case with a large dataset. Not recommended to\
            use generally.
        vstat_list: Provide a list of label items to specify which volume's\
            images should appear in the vstat QC block. Each item should correspond\
            to subbrick label basename in the stats_dset. 'Full_Fstat' is always\
            included. If not used, default logic picks up to 5 items to show.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ApqcMakeTcshPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(APQC_MAKE_TCSH_PY_METADATA)
    params = apqc_make_tcsh_py_params(
        uvar_json=uvar_json,
        subj_dir=subj_dir,
        review_style=review_style,
        mot_grayplot_off=mot_grayplot_off,
        vstat_list=vstat_list,
    )
    return apqc_make_tcsh_py_execute(params, execution)


__all__ = [
    "APQC_MAKE_TCSH_PY_METADATA",
    "ApqcMakeTcshPyOutputs",
    "ApqcMakeTcshPyParameters",
    "apqc_make_tcsh_py",
    "apqc_make_tcsh_py_params",
]
