# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

CAT_MATVEC_METADATA = Metadata(
    id="61e7c2b9d7eb804f1420ce54e105f89806022415.boutiques",
    name="cat_matvec",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


CatMatvecParameters = typing.TypedDict('CatMatvecParameters', {
    "__STYXTYPE__": typing.Literal["cat_matvec"],
    "matrix_format": bool,
    "oneline_format": bool,
    "four_by_four_format": bool,
    "matvec_spec": list[str],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "cat_matvec": cat_matvec_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class CatMatvecOutputs(typing.NamedTuple):
    """
    Output object returned when calling `cat_matvec(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def cat_matvec_params(
    matvec_spec: list[str],
    matrix_format: bool = False,
    oneline_format: bool = False,
    four_by_four_format: bool = False,
) -> CatMatvecParameters:
    """
    Build parameters.
    
    Args:
        matvec_spec: Specifies the matrix transformation. Can take forms\
            described in the documentation.
        matrix_format: Indicates that the resulting matrix will be written in\
            the 'MATRIX(...)' format (FORM 3).
        oneline_format: Option indicates that the resulting matrix will simply\
            be written as 12 numbers on one line.
        four_by_four_format: Output matrix in augmented form (last row is 0 0 0\
            1). This option does not work with -MATRIX or -ONELINE.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "cat_matvec",
        "matrix_format": matrix_format,
        "oneline_format": oneline_format,
        "four_by_four_format": four_by_four_format,
        "matvec_spec": matvec_spec,
    }
    return params


def cat_matvec_cargs(
    params: CatMatvecParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("cat_matvec")
    if params.get("matrix_format"):
        cargs.append("-MATRIX")
    if params.get("oneline_format"):
        cargs.append("-ONELINE")
    if params.get("four_by_four_format"):
        cargs.append("-4x4")
    cargs.extend(params.get("matvec_spec"))
    return cargs


def cat_matvec_outputs(
    params: CatMatvecParameters,
    execution: Execution,
) -> CatMatvecOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = CatMatvecOutputs(
        root=execution.output_file("."),
    )
    return ret


def cat_matvec_execute(
    params: CatMatvecParameters,
    execution: Execution,
) -> CatMatvecOutputs:
    """
    Catenates 3D rotation+shift matrix+vector transformations.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `CatMatvecOutputs`).
    """
    params = execution.params(params)
    cargs = cat_matvec_cargs(params, execution)
    ret = cat_matvec_outputs(params, execution)
    execution.run(cargs)
    return ret


def cat_matvec(
    matvec_spec: list[str],
    matrix_format: bool = False,
    oneline_format: bool = False,
    four_by_four_format: bool = False,
    runner: Runner | None = None,
) -> CatMatvecOutputs:
    """
    Catenates 3D rotation+shift matrix+vector transformations.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        matvec_spec: Specifies the matrix transformation. Can take forms\
            described in the documentation.
        matrix_format: Indicates that the resulting matrix will be written in\
            the 'MATRIX(...)' format (FORM 3).
        oneline_format: Option indicates that the resulting matrix will simply\
            be written as 12 numbers on one line.
        four_by_four_format: Output matrix in augmented form (last row is 0 0 0\
            1). This option does not work with -MATRIX or -ONELINE.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `CatMatvecOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(CAT_MATVEC_METADATA)
    params = cat_matvec_params(
        matrix_format=matrix_format,
        oneline_format=oneline_format,
        four_by_four_format=four_by_four_format,
        matvec_spec=matvec_spec,
    )
    return cat_matvec_execute(params, execution)


__all__ = [
    "CAT_MATVEC_METADATA",
    "CatMatvecOutputs",
    "CatMatvecParameters",
    "cat_matvec",
    "cat_matvec_params",
]
