# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

CJPEG_METADATA = Metadata(
    id="2c8dea63ef6018ee1b6008e2b8bd11dd5b58bb30.boutiques",
    name="cjpeg",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


CjpegParameters = typing.TypedDict('CjpegParameters', {
    "__STYXTYPE__": typing.Literal["cjpeg"],
    "quality": typing.NotRequired[float | None],
    "grayscale": bool,
    "optimize": bool,
    "baseline": bool,
    "progressive": bool,
    "outfile": str,
    "infile": InputPathType,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "cjpeg": cjpeg_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "cjpeg": cjpeg_outputs,
    }.get(t)


class CjpegOutputs(typing.NamedTuple):
    """
    Output object returned when calling `cjpeg(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    outfile: OutputPathType
    """The output JPEG file"""


def cjpeg_params(
    outfile: str,
    infile: InputPathType,
    quality: float | None = None,
    grayscale: bool = False,
    optimize: bool = False,
    baseline: bool = False,
    progressive: bool = False,
) -> CjpegParameters:
    """
    Build parameters.
    
    Args:
        outfile: Output JPEG file.
        infile: Input image file.
        quality: Quality of JPEG image (0-100).
        grayscale: Create a grayscale JPEG file.
        optimize: Optimize Huffman table.
        baseline: Create a baseline JPEG file.
        progressive: Create a progressive JPEG file.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "cjpeg",
        "grayscale": grayscale,
        "optimize": optimize,
        "baseline": baseline,
        "progressive": progressive,
        "outfile": outfile,
        "infile": infile,
    }
    if quality is not None:
        params["quality"] = quality
    return params


def cjpeg_cargs(
    params: CjpegParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("cjpeg")
    if params.get("quality") is not None:
        cargs.extend([
            "-quality",
            str(params.get("quality"))
        ])
    if params.get("grayscale"):
        cargs.append("-grayscale")
    if params.get("optimize"):
        cargs.append("-optimize")
    if params.get("baseline"):
        cargs.append("-baseline")
    if params.get("progressive"):
        cargs.append("-progressive")
    cargs.append(params.get("outfile"))
    cargs.append(execution.input_file(params.get("infile")))
    return cargs


def cjpeg_outputs(
    params: CjpegParameters,
    execution: Execution,
) -> CjpegOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = CjpegOutputs(
        root=execution.output_file("."),
        outfile=execution.output_file(params.get("outfile")),
    )
    return ret


def cjpeg_execute(
    params: CjpegParameters,
    execution: Execution,
) -> CjpegOutputs:
    """
    Compresses an image file to a JPEG file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `CjpegOutputs`).
    """
    params = execution.params(params)
    cargs = cjpeg_cargs(params, execution)
    ret = cjpeg_outputs(params, execution)
    execution.run(cargs)
    return ret


def cjpeg(
    outfile: str,
    infile: InputPathType,
    quality: float | None = None,
    grayscale: bool = False,
    optimize: bool = False,
    baseline: bool = False,
    progressive: bool = False,
    runner: Runner | None = None,
) -> CjpegOutputs:
    """
    Compresses an image file to a JPEG file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        outfile: Output JPEG file.
        infile: Input image file.
        quality: Quality of JPEG image (0-100).
        grayscale: Create a grayscale JPEG file.
        optimize: Optimize Huffman table.
        baseline: Create a baseline JPEG file.
        progressive: Create a progressive JPEG file.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `CjpegOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(CJPEG_METADATA)
    params = cjpeg_params(
        quality=quality,
        grayscale=grayscale,
        optimize=optimize,
        baseline=baseline,
        progressive=progressive,
        outfile=outfile,
        infile=infile,
    )
    return cjpeg_execute(params, execution)


__all__ = [
    "CJPEG_METADATA",
    "CjpegOutputs",
    "CjpegParameters",
    "cjpeg",
    "cjpeg_params",
]
