# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

CONVEX_HULL_METADATA = Metadata(
    id="212679c3e56974a08070cda35b98c1c96c0bfe04.boutiques",
    name="ConvexHull",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


ConvexHullParameters = typing.TypedDict('ConvexHullParameters', {
    "__STYXTYPE__": typing.Literal["ConvexHull"],
    "vol": typing.NotRequired[InputPathType | None],
    "isoval": typing.NotRequired[float | None],
    "isorange": typing.NotRequired[list[float] | None],
    "isocmask": typing.NotRequired[str | None],
    "xform": typing.NotRequired[str | None],
    "surface_input": typing.NotRequired[InputPathType | None],
    "surf_vol": typing.NotRequired[InputPathType | None],
    "input_1d": typing.NotRequired[InputPathType | None],
    "q_opt": typing.NotRequired[str | None],
    "proj_xy": bool,
    "orig_coord": bool,
    "these_coords": typing.NotRequired[InputPathType | None],
    "output_prefix": typing.NotRequired[str | None],
    "debug": typing.NotRequired[str | None],
    "novolreg": bool,
    "setenv": typing.NotRequired[str | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "ConvexHull": convex_hull_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "ConvexHull": convex_hull_outputs,
    }.get(t)


class ConvexHullOutputs(typing.NamedTuple):
    """
    Output object returned when calling `convex_hull(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_surf: OutputPathType | None
    """Output surface file"""


def convex_hull_params(
    vol: InputPathType | None = None,
    isoval: float | None = None,
    isorange: list[float] | None = None,
    isocmask: str | None = None,
    xform: str | None = None,
    surface_input: InputPathType | None = None,
    surf_vol: InputPathType | None = None,
    input_1d: InputPathType | None = None,
    q_opt: str | None = None,
    proj_xy: bool = False,
    orig_coord: bool = False,
    these_coords: InputPathType | None = None,
    output_prefix: str | None = None,
    debug: str | None = None,
    novolreg: bool = False,
    setenv: str | None = None,
) -> ConvexHullParameters:
    """
    Build parameters.
    
    Args:
        vol: Input AFNI (or AFNI readable) volume.
        isoval: Create isosurface where volume = V.
        isorange: Create isosurface where V0 <= volume < V1.
        isocmask: Create isosurface where MASK_COM != 0. Example: -isocmask '-a\
            VOL+orig -expr (1-bool(a-V))' is equivalent to using -isoval V. NOTE:\
            Allowed only with -xform mask.
        xform: Transform to apply to volume values before searching for sign\
            change boundary. Options: mask, shift, none.
        surface_input: Input surface type.
        surf_vol: Specify a surface volume which contains a transform to apply\
            to the surface node coordinates.
        input_1d: Construct the triangulation of the points contained in 1D\
            file XYZ. Use AFNI's [] selectors to specify the XYZ columns.
        q_opt: Meshing option OPT. Options: convex_hull, triangulate_xy.
        proj_xy: Project points onto plane whose normal is the third principal\
            component. Then rotate projection so that plane is parallel to Z =\
            constant.
        orig_coord: Use original coordinates when writing surface, not\
            transformed ones.
        these_coords: Use coordinates in COORDS.1D when writing surface.
        output_prefix: Prefix of output surface. Specifies the format and\
            prefix of the surface.
        debug: Debugging level.
        novolreg: Ignore any Rotate, Volreg, Tagalign, or WarpDrive\
            transformations present in the Surface Volume.
        setenv: Set environment variable ENVname to be ENVvalue.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "ConvexHull",
        "proj_xy": proj_xy,
        "orig_coord": orig_coord,
        "novolreg": novolreg,
    }
    if vol is not None:
        params["vol"] = vol
    if isoval is not None:
        params["isoval"] = isoval
    if isorange is not None:
        params["isorange"] = isorange
    if isocmask is not None:
        params["isocmask"] = isocmask
    if xform is not None:
        params["xform"] = xform
    if surface_input is not None:
        params["surface_input"] = surface_input
    if surf_vol is not None:
        params["surf_vol"] = surf_vol
    if input_1d is not None:
        params["input_1d"] = input_1d
    if q_opt is not None:
        params["q_opt"] = q_opt
    if these_coords is not None:
        params["these_coords"] = these_coords
    if output_prefix is not None:
        params["output_prefix"] = output_prefix
    if debug is not None:
        params["debug"] = debug
    if setenv is not None:
        params["setenv"] = setenv
    return params


def convex_hull_cargs(
    params: ConvexHullParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("ConvexHull")
    if params.get("vol") is not None:
        cargs.extend([
            "-input",
            execution.input_file(params.get("vol"))
        ])
    if params.get("isoval") is not None:
        cargs.extend([
            "-isoval",
            str(params.get("isoval"))
        ])
    if params.get("isorange") is not None:
        cargs.extend([
            "-isorange",
            *map(str, params.get("isorange"))
        ])
    if params.get("isocmask") is not None:
        cargs.extend([
            "-isocmask",
            params.get("isocmask")
        ])
    if params.get("xform") is not None:
        cargs.extend([
            "-xform",
            params.get("xform")
        ])
    if params.get("surface_input") is not None:
        cargs.extend([
            "-i_TYPE",
            execution.input_file(params.get("surface_input"))
        ])
    if params.get("surf_vol") is not None:
        cargs.extend([
            "-sv",
            execution.input_file(params.get("surf_vol"))
        ])
    if params.get("input_1d") is not None:
        cargs.extend([
            "-input_1D",
            execution.input_file(params.get("input_1d"))
        ])
    if params.get("q_opt") is not None:
        cargs.extend([
            "-q_opt",
            params.get("q_opt")
        ])
    if params.get("proj_xy"):
        cargs.append("-proj_xy")
    if params.get("orig_coord"):
        cargs.append("-orig_coord")
    if params.get("these_coords") is not None:
        cargs.extend([
            "-these_coords",
            execution.input_file(params.get("these_coords"))
        ])
    if params.get("output_prefix") is not None:
        cargs.extend([
            "-o_TYPE",
            params.get("output_prefix")
        ])
    if params.get("debug") is not None:
        cargs.extend([
            "-debug",
            params.get("debug")
        ])
    if params.get("novolreg"):
        cargs.append("-novolreg")
    if params.get("setenv") is not None:
        cargs.extend([
            "-setenv",
            params.get("setenv")
        ])
    return cargs


def convex_hull_outputs(
    params: ConvexHullParameters,
    execution: Execution,
) -> ConvexHullOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = ConvexHullOutputs(
        root=execution.output_file("."),
        out_surf=execution.output_file(params.get("output_prefix")) if (params.get("output_prefix") is not None) else None,
    )
    return ret


def convex_hull_execute(
    params: ConvexHullParameters,
    execution: Execution,
) -> ConvexHullOutputs:
    """
    A program to find the convex hull, or perform a Delaunay triangulation of a set
    of points.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `ConvexHullOutputs`).
    """
    params = execution.params(params)
    cargs = convex_hull_cargs(params, execution)
    ret = convex_hull_outputs(params, execution)
    execution.run(cargs)
    return ret


def convex_hull(
    vol: InputPathType | None = None,
    isoval: float | None = None,
    isorange: list[float] | None = None,
    isocmask: str | None = None,
    xform: str | None = None,
    surface_input: InputPathType | None = None,
    surf_vol: InputPathType | None = None,
    input_1d: InputPathType | None = None,
    q_opt: str | None = None,
    proj_xy: bool = False,
    orig_coord: bool = False,
    these_coords: InputPathType | None = None,
    output_prefix: str | None = None,
    debug: str | None = None,
    novolreg: bool = False,
    setenv: str | None = None,
    runner: Runner | None = None,
) -> ConvexHullOutputs:
    """
    A program to find the convex hull, or perform a Delaunay triangulation of a set
    of points.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        vol: Input AFNI (or AFNI readable) volume.
        isoval: Create isosurface where volume = V.
        isorange: Create isosurface where V0 <= volume < V1.
        isocmask: Create isosurface where MASK_COM != 0. Example: -isocmask '-a\
            VOL+orig -expr (1-bool(a-V))' is equivalent to using -isoval V. NOTE:\
            Allowed only with -xform mask.
        xform: Transform to apply to volume values before searching for sign\
            change boundary. Options: mask, shift, none.
        surface_input: Input surface type.
        surf_vol: Specify a surface volume which contains a transform to apply\
            to the surface node coordinates.
        input_1d: Construct the triangulation of the points contained in 1D\
            file XYZ. Use AFNI's [] selectors to specify the XYZ columns.
        q_opt: Meshing option OPT. Options: convex_hull, triangulate_xy.
        proj_xy: Project points onto plane whose normal is the third principal\
            component. Then rotate projection so that plane is parallel to Z =\
            constant.
        orig_coord: Use original coordinates when writing surface, not\
            transformed ones.
        these_coords: Use coordinates in COORDS.1D when writing surface.
        output_prefix: Prefix of output surface. Specifies the format and\
            prefix of the surface.
        debug: Debugging level.
        novolreg: Ignore any Rotate, Volreg, Tagalign, or WarpDrive\
            transformations present in the Surface Volume.
        setenv: Set environment variable ENVname to be ENVvalue.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ConvexHullOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(CONVEX_HULL_METADATA)
    params = convex_hull_params(
        vol=vol,
        isoval=isoval,
        isorange=isorange,
        isocmask=isocmask,
        xform=xform,
        surface_input=surface_input,
        surf_vol=surf_vol,
        input_1d=input_1d,
        q_opt=q_opt,
        proj_xy=proj_xy,
        orig_coord=orig_coord,
        these_coords=these_coords,
        output_prefix=output_prefix,
        debug=debug,
        novolreg=novolreg,
        setenv=setenv,
    )
    return convex_hull_execute(params, execution)


__all__ = [
    "CONVEX_HULL_METADATA",
    "ConvexHullOutputs",
    "ConvexHullParameters",
    "convex_hull",
    "convex_hull_params",
]
