# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

DCM2NIIX_AFNI_METADATA = Metadata(
    id="7cf66629029a0771961d7c7125e4684dcd412a4d.boutiques",
    name="dcm2niix_afni",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


Dcm2niixAfniParameters = typing.TypedDict('Dcm2niixAfniParameters', {
    "__STYXTYPE__": typing.Literal["dcm2niix_afni"],
    "input_folder": str,
    "compression_level": typing.NotRequired[int | None],
    "adjacent_dicoms": typing.NotRequired[str | None],
    "bids_sidecar": typing.NotRequired[str | None],
    "anonymize_bids": typing.NotRequired[str | None],
    "comment": typing.NotRequired[str | None],
    "directory_search_depth": typing.NotRequired[int | None],
    "export_format": typing.NotRequired[str | None],
    "filename_template": typing.NotRequired[str | None],
    "generate_defaults": typing.NotRequired[str | None],
    "ignore_images": typing.NotRequired[str | None],
    "lossless_scale": typing.NotRequired[str | None],
    "merge_slices": typing.NotRequired[str | None],
    "series_crc_number": typing.NotRequired[list[str] | None],
    "output_directory": typing.NotRequired[str | None],
    "phillips_scaling": typing.NotRequired[str | None],
    "rename_dicoms": typing.NotRequired[str | None],
    "single_file_mode": typing.NotRequired[str | None],
    "up_to_date": bool,
    "verbose": typing.NotRequired[str | None],
    "write_behavior": typing.NotRequired[int | None],
    "crop_3d": typing.NotRequired[str | None],
    "gz_compress": typing.NotRequired[str | None],
    "big_endian": typing.NotRequired[str | None],
    "progress": typing.NotRequired[str | None],
    "ignore_trigger_times": bool,
    "terse": bool,
    "version": bool,
    "xml": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "dcm2niix_afni": dcm2niix_afni_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "dcm2niix_afni": dcm2niix_afni_outputs,
    }.get(t)


class Dcm2niixAfniOutputs(typing.NamedTuple):
    """
    Output object returned when calling `dcm2niix_afni(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    nifti_files: OutputPathType
    """The main output NIfTI files"""


def dcm2niix_afni_params(
    input_folder: str,
    compression_level: int | None = None,
    adjacent_dicoms: str | None = None,
    bids_sidecar: str | None = None,
    anonymize_bids: str | None = None,
    comment: str | None = None,
    directory_search_depth: int | None = None,
    export_format: str | None = None,
    filename_template: str | None = None,
    generate_defaults: str | None = None,
    ignore_images: str | None = None,
    lossless_scale: str | None = None,
    merge_slices: str | None = None,
    series_crc_number: list[str] | None = None,
    output_directory: str | None = None,
    phillips_scaling: str | None = None,
    rename_dicoms: str | None = None,
    single_file_mode: str | None = None,
    up_to_date: bool = False,
    verbose: str | None = None,
    write_behavior: int | None = None,
    crop_3d: str | None = None,
    gz_compress: str | None = None,
    big_endian: str | None = None,
    progress: str | None = None,
    ignore_trigger_times: bool = False,
    terse: bool = False,
    version: bool = False,
    xml_: bool = False,
) -> Dcm2niixAfniParameters:
    """
    Build parameters.
    
    Args:
        input_folder: Folder containing DICOM files.
        compression_level: GZ compression level (1=fastest..9=smallest, default\
            6).
        adjacent_dicoms: Adjacent DICOMs (images from same series always in\
            same folder) for faster conversion (n/y, default n).
        bids_sidecar: BIDS sidecar (y/n/o [o=only: no NIfTI], default y).
        anonymize_bids: Anonymize BIDS (y/n, default y).
        comment: Comment stored in NIfTI aux_file (provide up to 24 characters\
            e.g. '-c first_visit').
        directory_search_depth: Directory search depth. Convert DICOMs in\
            sub-folders of in_folder? (0..9, default 5).
        export_format: Export as NRRD (y) or MGH (o) instead of NIfTI (y/n/o,\
            default n).
        filename_template: Filename template for output (default '%f_%p_%t_%s').
        generate_defaults: Generate defaults file (y/n/o/i [o=only: reset and\
            write defaults; i=ignore: reset defaults], default n).
        ignore_images: Ignore derived, localizer and 2D images (y/n, default n).
        lossless_scale: Losslessly scale 16-bit integers to use dynamic range\
            (y/n/o, default o).
        merge_slices: Merge 2D slices from same series regardless of echo,\
            exposure, etc. (n/y or 0/1/2, default 2).
        series_crc_number: Only convert this series CRC number - can be used up\
            to 16 times (default convert all).
        output_directory: Output directory (omit to save to input folder).
        phillips_scaling: Philips precise float (not display) scaling (y/n,\
            default y).
        rename_dicoms: Rename instead of convert DICOMs (y/n, default n).
        single_file_mode: Single file mode, do not convert other images in\
            folder (y/n, default n).
        up_to_date: Up-to-date check.
        verbose: Verbose (n/y or 0/1/2, default 0).
        write_behavior: Write behavior for name conflicts (0=skip duplicates,\
            1=overwrite, 2=add suffix).
        crop_3d: Crop 3D acquisitions (y/n/i, default n, use 'i'gnore to\
            neither crop nor rotate 3D acquisitions).
        gz_compress: GZ compress images (y/o/i/n/3, default n) [y=pigz,\
            o=optimal pigz, i=internal:miniz, n=no, 3=no,3D].
        big_endian: Byte order (y/n/o, default o) [y=big-endian,\
            n=little-endian, o=optimal/native].
        progress: Slicer format progress information (y/n, default n).
        ignore_trigger_times: Disregard values in 0018, 1060 and 0020, 9153.
        terse: Omit filename post-fixes (can cause overwrites).
        version: Report version.
        xml_: Slicer format features.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "dcm2niix_afni",
        "input_folder": input_folder,
        "up_to_date": up_to_date,
        "ignore_trigger_times": ignore_trigger_times,
        "terse": terse,
        "version": version,
        "xml": xml_,
    }
    if compression_level is not None:
        params["compression_level"] = compression_level
    if adjacent_dicoms is not None:
        params["adjacent_dicoms"] = adjacent_dicoms
    if bids_sidecar is not None:
        params["bids_sidecar"] = bids_sidecar
    if anonymize_bids is not None:
        params["anonymize_bids"] = anonymize_bids
    if comment is not None:
        params["comment"] = comment
    if directory_search_depth is not None:
        params["directory_search_depth"] = directory_search_depth
    if export_format is not None:
        params["export_format"] = export_format
    if filename_template is not None:
        params["filename_template"] = filename_template
    if generate_defaults is not None:
        params["generate_defaults"] = generate_defaults
    if ignore_images is not None:
        params["ignore_images"] = ignore_images
    if lossless_scale is not None:
        params["lossless_scale"] = lossless_scale
    if merge_slices is not None:
        params["merge_slices"] = merge_slices
    if series_crc_number is not None:
        params["series_crc_number"] = series_crc_number
    if output_directory is not None:
        params["output_directory"] = output_directory
    if phillips_scaling is not None:
        params["phillips_scaling"] = phillips_scaling
    if rename_dicoms is not None:
        params["rename_dicoms"] = rename_dicoms
    if single_file_mode is not None:
        params["single_file_mode"] = single_file_mode
    if verbose is not None:
        params["verbose"] = verbose
    if write_behavior is not None:
        params["write_behavior"] = write_behavior
    if crop_3d is not None:
        params["crop_3d"] = crop_3d
    if gz_compress is not None:
        params["gz_compress"] = gz_compress
    if big_endian is not None:
        params["big_endian"] = big_endian
    if progress is not None:
        params["progress"] = progress
    return params


def dcm2niix_afni_cargs(
    params: Dcm2niixAfniParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("dcm2niix_afni")
    cargs.append(params.get("input_folder"))
    if params.get("compression_level") is not None:
        cargs.extend([
            "-1..-9",
            str(params.get("compression_level"))
        ])
    if params.get("adjacent_dicoms") is not None:
        cargs.extend([
            "-a",
            params.get("adjacent_dicoms")
        ])
    if params.get("bids_sidecar") is not None:
        cargs.extend([
            "-b",
            params.get("bids_sidecar")
        ])
    if params.get("anonymize_bids") is not None:
        cargs.extend([
            "-ba",
            params.get("anonymize_bids")
        ])
    if params.get("comment") is not None:
        cargs.extend([
            "-c",
            params.get("comment")
        ])
    if params.get("directory_search_depth") is not None:
        cargs.extend([
            "-d",
            str(params.get("directory_search_depth"))
        ])
    if params.get("export_format") is not None:
        cargs.extend([
            "-e",
            params.get("export_format")
        ])
    if params.get("filename_template") is not None:
        cargs.extend([
            "-f",
            params.get("filename_template")
        ])
    if params.get("generate_defaults") is not None:
        cargs.extend([
            "-g",
            params.get("generate_defaults")
        ])
    if params.get("ignore_images") is not None:
        cargs.extend([
            "-i",
            params.get("ignore_images")
        ])
    if params.get("lossless_scale") is not None:
        cargs.extend([
            "-l",
            params.get("lossless_scale")
        ])
    if params.get("merge_slices") is not None:
        cargs.extend([
            "-m",
            params.get("merge_slices")
        ])
    if params.get("series_crc_number") is not None:
        cargs.extend([
            "-n",
            *params.get("series_crc_number")
        ])
    if params.get("output_directory") is not None:
        cargs.extend([
            "-o",
            params.get("output_directory")
        ])
    if params.get("phillips_scaling") is not None:
        cargs.extend([
            "-p",
            params.get("phillips_scaling")
        ])
    if params.get("rename_dicoms") is not None:
        cargs.extend([
            "-r",
            params.get("rename_dicoms")
        ])
    if params.get("single_file_mode") is not None:
        cargs.extend([
            "-s",
            params.get("single_file_mode")
        ])
    if params.get("up_to_date"):
        cargs.append("-u")
    if params.get("verbose") is not None:
        cargs.extend([
            "-v",
            params.get("verbose")
        ])
    if params.get("write_behavior") is not None:
        cargs.extend([
            "-w",
            str(params.get("write_behavior"))
        ])
    if params.get("crop_3d") is not None:
        cargs.extend([
            "-x",
            params.get("crop_3d")
        ])
    if params.get("gz_compress") is not None:
        cargs.extend([
            "-z",
            params.get("gz_compress")
        ])
    if params.get("big_endian") is not None:
        cargs.extend([
            "--big-endian",
            params.get("big_endian")
        ])
    if params.get("progress") is not None:
        cargs.extend([
            "--progress",
            params.get("progress")
        ])
    if params.get("ignore_trigger_times"):
        cargs.append("--ignore_trigger_times")
    if params.get("terse"):
        cargs.append("--terse")
    if params.get("version"):
        cargs.append("--version")
    if params.get("xml"):
        cargs.append("--xml")
    return cargs


def dcm2niix_afni_outputs(
    params: Dcm2niixAfniParameters,
    execution: Execution,
) -> Dcm2niixAfniOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = Dcm2niixAfniOutputs(
        root=execution.output_file("."),
        nifti_files=execution.output_file("<OUTPUT_DIRECTORY>/*.nii"),
    )
    return ret


def dcm2niix_afni_execute(
    params: Dcm2niixAfniParameters,
    execution: Execution,
) -> Dcm2niixAfniOutputs:
    """
    DICOM to NIfTI converter optimized for AFNI.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `Dcm2niixAfniOutputs`).
    """
    params = execution.params(params)
    cargs = dcm2niix_afni_cargs(params, execution)
    ret = dcm2niix_afni_outputs(params, execution)
    execution.run(cargs)
    return ret


def dcm2niix_afni(
    input_folder: str,
    compression_level: int | None = None,
    adjacent_dicoms: str | None = None,
    bids_sidecar: str | None = None,
    anonymize_bids: str | None = None,
    comment: str | None = None,
    directory_search_depth: int | None = None,
    export_format: str | None = None,
    filename_template: str | None = None,
    generate_defaults: str | None = None,
    ignore_images: str | None = None,
    lossless_scale: str | None = None,
    merge_slices: str | None = None,
    series_crc_number: list[str] | None = None,
    output_directory: str | None = None,
    phillips_scaling: str | None = None,
    rename_dicoms: str | None = None,
    single_file_mode: str | None = None,
    up_to_date: bool = False,
    verbose: str | None = None,
    write_behavior: int | None = None,
    crop_3d: str | None = None,
    gz_compress: str | None = None,
    big_endian: str | None = None,
    progress: str | None = None,
    ignore_trigger_times: bool = False,
    terse: bool = False,
    version: bool = False,
    xml_: bool = False,
    runner: Runner | None = None,
) -> Dcm2niixAfniOutputs:
    """
    DICOM to NIfTI converter optimized for AFNI.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_folder: Folder containing DICOM files.
        compression_level: GZ compression level (1=fastest..9=smallest, default\
            6).
        adjacent_dicoms: Adjacent DICOMs (images from same series always in\
            same folder) for faster conversion (n/y, default n).
        bids_sidecar: BIDS sidecar (y/n/o [o=only: no NIfTI], default y).
        anonymize_bids: Anonymize BIDS (y/n, default y).
        comment: Comment stored in NIfTI aux_file (provide up to 24 characters\
            e.g. '-c first_visit').
        directory_search_depth: Directory search depth. Convert DICOMs in\
            sub-folders of in_folder? (0..9, default 5).
        export_format: Export as NRRD (y) or MGH (o) instead of NIfTI (y/n/o,\
            default n).
        filename_template: Filename template for output (default '%f_%p_%t_%s').
        generate_defaults: Generate defaults file (y/n/o/i [o=only: reset and\
            write defaults; i=ignore: reset defaults], default n).
        ignore_images: Ignore derived, localizer and 2D images (y/n, default n).
        lossless_scale: Losslessly scale 16-bit integers to use dynamic range\
            (y/n/o, default o).
        merge_slices: Merge 2D slices from same series regardless of echo,\
            exposure, etc. (n/y or 0/1/2, default 2).
        series_crc_number: Only convert this series CRC number - can be used up\
            to 16 times (default convert all).
        output_directory: Output directory (omit to save to input folder).
        phillips_scaling: Philips precise float (not display) scaling (y/n,\
            default y).
        rename_dicoms: Rename instead of convert DICOMs (y/n, default n).
        single_file_mode: Single file mode, do not convert other images in\
            folder (y/n, default n).
        up_to_date: Up-to-date check.
        verbose: Verbose (n/y or 0/1/2, default 0).
        write_behavior: Write behavior for name conflicts (0=skip duplicates,\
            1=overwrite, 2=add suffix).
        crop_3d: Crop 3D acquisitions (y/n/i, default n, use 'i'gnore to\
            neither crop nor rotate 3D acquisitions).
        gz_compress: GZ compress images (y/o/i/n/3, default n) [y=pigz,\
            o=optimal pigz, i=internal:miniz, n=no, 3=no,3D].
        big_endian: Byte order (y/n/o, default o) [y=big-endian,\
            n=little-endian, o=optimal/native].
        progress: Slicer format progress information (y/n, default n).
        ignore_trigger_times: Disregard values in 0018, 1060 and 0020, 9153.
        terse: Omit filename post-fixes (can cause overwrites).
        version: Report version.
        xml_: Slicer format features.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `Dcm2niixAfniOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(DCM2NIIX_AFNI_METADATA)
    params = dcm2niix_afni_params(
        input_folder=input_folder,
        compression_level=compression_level,
        adjacent_dicoms=adjacent_dicoms,
        bids_sidecar=bids_sidecar,
        anonymize_bids=anonymize_bids,
        comment=comment,
        directory_search_depth=directory_search_depth,
        export_format=export_format,
        filename_template=filename_template,
        generate_defaults=generate_defaults,
        ignore_images=ignore_images,
        lossless_scale=lossless_scale,
        merge_slices=merge_slices,
        series_crc_number=series_crc_number,
        output_directory=output_directory,
        phillips_scaling=phillips_scaling,
        rename_dicoms=rename_dicoms,
        single_file_mode=single_file_mode,
        up_to_date=up_to_date,
        verbose=verbose,
        write_behavior=write_behavior,
        crop_3d=crop_3d,
        gz_compress=gz_compress,
        big_endian=big_endian,
        progress=progress,
        ignore_trigger_times=ignore_trigger_times,
        terse=terse,
        version=version,
        xml_=xml_,
    )
    return dcm2niix_afni_execute(params, execution)


__all__ = [
    "DCM2NIIX_AFNI_METADATA",
    "Dcm2niixAfniOutputs",
    "Dcm2niixAfniParameters",
    "dcm2niix_afni",
    "dcm2niix_afni_params",
]
