# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

DICOM_HDR_METADATA = Metadata(
    id="06030930d3116d7bf58316357750a3ae68688ced.boutiques",
    name="dicom_hdr",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


DicomHdrParameters = typing.TypedDict('DicomHdrParameters', {
    "__STYXTYPE__": typing.Literal["dicom_hdr"],
    "files": list[InputPathType],
    "hex": bool,
    "noname": bool,
    "sexinfo": bool,
    "mulfram": bool,
    "v_dump": typing.NotRequired[float | None],
    "no_length": bool,
    "slice_times": bool,
    "slice_times_verb": bool,
    "siemens_csa_data": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "dicom_hdr": dicom_hdr_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class DicomHdrOutputs(typing.NamedTuple):
    """
    Output object returned when calling `dicom_hdr(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def dicom_hdr_params(
    files: list[InputPathType],
    hex_: bool = False,
    noname: bool = False,
    sexinfo: bool = False,
    mulfram: bool = False,
    v_dump: float | None = None,
    no_length: bool = False,
    slice_times: bool = False,
    slice_times_verb: bool = False,
    siemens_csa_data: bool = False,
) -> DicomHdrParameters:
    """
    Build parameters.
    
    Args:
        files: DICOM file(s) to read.
        hex_: Include hexadecimal printout for integer values.
        noname: Don't include element names in the printout.
        sexinfo: Dump Siemens EXtra INFO text (0029 1020), if present (can be\
            VERY lengthy).
        mulfram: Dump multi-frame information, if present (1 line per frame,\
            plus an XML-style header/footer). This option also implies -noname.
        v_dump: Dump n words of binary data also.
        no_length: Skip lengths and offsets (helps diffs).
        slice_times: Show slice times from Siemens mosaic images.
        slice_times_verb: Show slice times from Siemens mosaic images\
            verbosely. (multiple uses increase verbosity, can dump CSA data).
        siemens_csa_data: Same as 3 -slice_times_verb opts.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "dicom_hdr",
        "files": files,
        "hex": hex_,
        "noname": noname,
        "sexinfo": sexinfo,
        "mulfram": mulfram,
        "no_length": no_length,
        "slice_times": slice_times,
        "slice_times_verb": slice_times_verb,
        "siemens_csa_data": siemens_csa_data,
    }
    if v_dump is not None:
        params["v_dump"] = v_dump
    return params


def dicom_hdr_cargs(
    params: DicomHdrParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("dicom_hdr")
    cargs.extend([execution.input_file(f) for f in params.get("files")])
    if params.get("hex"):
        cargs.append("-hex")
    if params.get("noname"):
        cargs.append("-noname")
    if params.get("sexinfo"):
        cargs.append("-sexinfo")
    if params.get("mulfram"):
        cargs.append("-mulfram")
    if params.get("v_dump") is not None:
        cargs.extend([
            "-v",
            str(params.get("v_dump"))
        ])
    if params.get("no_length"):
        cargs.append("-no_length")
    if params.get("slice_times"):
        cargs.append("-slice_times")
    if params.get("slice_times_verb"):
        cargs.append("-slice_times_verb")
    if params.get("siemens_csa_data"):
        cargs.append("-siemens_csa_data")
    return cargs


def dicom_hdr_outputs(
    params: DicomHdrParameters,
    execution: Execution,
) -> DicomHdrOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = DicomHdrOutputs(
        root=execution.output_file("."),
    )
    return ret


def dicom_hdr_execute(
    params: DicomHdrParameters,
    execution: Execution,
) -> DicomHdrOutputs:
    """
    A tool to print DICOM file information to stdout.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `DicomHdrOutputs`).
    """
    params = execution.params(params)
    cargs = dicom_hdr_cargs(params, execution)
    ret = dicom_hdr_outputs(params, execution)
    execution.run(cargs)
    return ret


def dicom_hdr(
    files: list[InputPathType],
    hex_: bool = False,
    noname: bool = False,
    sexinfo: bool = False,
    mulfram: bool = False,
    v_dump: float | None = None,
    no_length: bool = False,
    slice_times: bool = False,
    slice_times_verb: bool = False,
    siemens_csa_data: bool = False,
    runner: Runner | None = None,
) -> DicomHdrOutputs:
    """
    A tool to print DICOM file information to stdout.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        files: DICOM file(s) to read.
        hex_: Include hexadecimal printout for integer values.
        noname: Don't include element names in the printout.
        sexinfo: Dump Siemens EXtra INFO text (0029 1020), if present (can be\
            VERY lengthy).
        mulfram: Dump multi-frame information, if present (1 line per frame,\
            plus an XML-style header/footer). This option also implies -noname.
        v_dump: Dump n words of binary data also.
        no_length: Skip lengths and offsets (helps diffs).
        slice_times: Show slice times from Siemens mosaic images.
        slice_times_verb: Show slice times from Siemens mosaic images\
            verbosely. (multiple uses increase verbosity, can dump CSA data).
        siemens_csa_data: Same as 3 -slice_times_verb opts.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `DicomHdrOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(DICOM_HDR_METADATA)
    params = dicom_hdr_params(
        files=files,
        hex_=hex_,
        noname=noname,
        sexinfo=sexinfo,
        mulfram=mulfram,
        v_dump=v_dump,
        no_length=no_length,
        slice_times=slice_times,
        slice_times_verb=slice_times_verb,
        siemens_csa_data=siemens_csa_data,
    )
    return dicom_hdr_execute(params, execution)


__all__ = [
    "DICOM_HDR_METADATA",
    "DicomHdrOutputs",
    "DicomHdrParameters",
    "dicom_hdr",
    "dicom_hdr_params",
]
