# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

DICOM_HINFO_METADATA = Metadata(
    id="86b86805a9240d1e9926ec2238c1b43833f0390d.boutiques",
    name="dicom_hinfo",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


DicomHinfoParameters = typing.TypedDict('DicomHinfoParameters', {
    "__STYXTYPE__": typing.Literal["dicom_hinfo"],
    "tag": list[str],
    "sepstr": typing.NotRequired[str | None],
    "full_entry": bool,
    "no_name": bool,
    "namelast": bool,
    "files": list[InputPathType],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "dicom_hinfo": dicom_hinfo_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class DicomHinfoOutputs(typing.NamedTuple):
    """
    Output object returned when calling `dicom_hinfo(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def dicom_hinfo_params(
    tag: list[str],
    files: list[InputPathType],
    sepstr: str | None = None,
    full_entry: bool = False,
    no_name: bool = False,
    namelast: bool = False,
) -> DicomHinfoParameters:
    """
    Build parameters.
    
    Args:
        tag: Specify one or more DICOM tags to print, in the format aaaa,bbbb\
            where aaaa and bbbb are hexadecimal digits.
        files: DICOM file(s) to process.
        sepstr: Use the specified string to separate fields instead of space.
        full_entry: Output the full entry if it is more than one word or\
            contains white space.
        no_name: Omit the filename from the output.
        namelast: Place the filename last in the output instead of first.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "dicom_hinfo",
        "tag": tag,
        "full_entry": full_entry,
        "no_name": no_name,
        "namelast": namelast,
        "files": files,
    }
    if sepstr is not None:
        params["sepstr"] = sepstr
    return params


def dicom_hinfo_cargs(
    params: DicomHinfoParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("dicom_hinfo")
    cargs.extend([
        "-tag",
        *params.get("tag")
    ])
    if params.get("sepstr") is not None:
        cargs.extend([
            "-sepstr",
            params.get("sepstr")
        ])
    if params.get("full_entry"):
        cargs.append("-full_entry")
    if params.get("no_name"):
        cargs.append("-no_name")
    if params.get("namelast"):
        cargs.append("-namelast")
    cargs.extend([execution.input_file(f) for f in params.get("files")])
    return cargs


def dicom_hinfo_outputs(
    params: DicomHinfoParameters,
    execution: Execution,
) -> DicomHinfoOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = DicomHinfoOutputs(
        root=execution.output_file("."),
    )
    return ret


def dicom_hinfo_execute(
    params: DicomHinfoParameters,
    execution: Execution,
) -> DicomHinfoOutputs:
    """
    Prints selected information from one or more DICOM files to stdout.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `DicomHinfoOutputs`).
    """
    params = execution.params(params)
    cargs = dicom_hinfo_cargs(params, execution)
    ret = dicom_hinfo_outputs(params, execution)
    execution.run(cargs)
    return ret


def dicom_hinfo(
    tag: list[str],
    files: list[InputPathType],
    sepstr: str | None = None,
    full_entry: bool = False,
    no_name: bool = False,
    namelast: bool = False,
    runner: Runner | None = None,
) -> DicomHinfoOutputs:
    """
    Prints selected information from one or more DICOM files to stdout.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        tag: Specify one or more DICOM tags to print, in the format aaaa,bbbb\
            where aaaa and bbbb are hexadecimal digits.
        files: DICOM file(s) to process.
        sepstr: Use the specified string to separate fields instead of space.
        full_entry: Output the full entry if it is more than one word or\
            contains white space.
        no_name: Omit the filename from the output.
        namelast: Place the filename last in the output instead of first.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `DicomHinfoOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(DICOM_HINFO_METADATA)
    params = dicom_hinfo_params(
        tag=tag,
        sepstr=sepstr,
        full_entry=full_entry,
        no_name=no_name,
        namelast=namelast,
        files=files,
    )
    return dicom_hinfo_execute(params, execution)


__all__ = [
    "DICOM_HINFO_METADATA",
    "DicomHinfoOutputs",
    "DicomHinfoParameters",
    "dicom_hinfo",
    "dicom_hinfo_params",
]
