# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

FAT_PROC_MAP_TO_DTI_METADATA = Metadata(
    id="2071c7c40db2fbca86d8b9d2a81d43349c721ca3.boutiques",
    name="fat_proc_map_to_dti",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


FatProcMapToDtiParameters = typing.TypedDict('FatProcMapToDtiParameters', {
    "__STYXTYPE__": typing.Literal["fat_proc_map_to_dti"],
    "source": InputPathType,
    "base": InputPathType,
    "prefix": str,
    "followers_nn": typing.NotRequired[list[InputPathType] | None],
    "followers_wsinc5": typing.NotRequired[list[InputPathType] | None],
    "followers_surf": typing.NotRequired[list[InputPathType] | None],
    "followers_ndset": typing.NotRequired[list[InputPathType] | None],
    "followers_spec": typing.NotRequired[list[InputPathType] | None],
    "matrix": typing.NotRequired[InputPathType | None],
    "workdir": typing.NotRequired[str | None],
    "no_cmd_out": bool,
    "no_clean": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "fat_proc_map_to_dti": fat_proc_map_to_dti_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class FatProcMapToDtiOutputs(typing.NamedTuple):
    """
    Output object returned when calling `fat_proc_map_to_dti(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def fat_proc_map_to_dti_params(
    source: InputPathType,
    base: InputPathType,
    prefix: str,
    followers_nn: list[InputPathType] | None = None,
    followers_wsinc5: list[InputPathType] | None = None,
    followers_surf: list[InputPathType] | None = None,
    followers_ndset: list[InputPathType] | None = None,
    followers_spec: list[InputPathType] | None = None,
    matrix: InputPathType | None = None,
    workdir: str | None = None,
    no_cmd_out: bool = False,
    no_clean: bool = False,
) -> FatProcMapToDtiParameters:
    """
    Build parameters.
    
    Args:
        source: T1w volume file (source volume).
        base: DWI reference volume file.
        prefix: Output prefix for files and snapshots.
        followers_nn: Follower data sets with NN interpolation.
        followers_wsinc5: Follower data sets with wsinc5 interpolation.
        followers_surf: Surface follower data sets.
        followers_ndset: NIML follower data sets.
        followers_spec: Spec follower data sets.
        matrix: Pre-made matrix file for transformation.
        workdir: Specify a working directory.
        no_cmd_out: Don't save the command line call of this program.
        no_clean: Do not delete temporary working directory.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "fat_proc_map_to_dti",
        "source": source,
        "base": base,
        "prefix": prefix,
        "no_cmd_out": no_cmd_out,
        "no_clean": no_clean,
    }
    if followers_nn is not None:
        params["followers_nn"] = followers_nn
    if followers_wsinc5 is not None:
        params["followers_wsinc5"] = followers_wsinc5
    if followers_surf is not None:
        params["followers_surf"] = followers_surf
    if followers_ndset is not None:
        params["followers_ndset"] = followers_ndset
    if followers_spec is not None:
        params["followers_spec"] = followers_spec
    if matrix is not None:
        params["matrix"] = matrix
    if workdir is not None:
        params["workdir"] = workdir
    return params


def fat_proc_map_to_dti_cargs(
    params: FatProcMapToDtiParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("fat_proc_map_to_dti")
    cargs.extend([
        "-source",
        execution.input_file(params.get("source"))
    ])
    cargs.extend([
        "-base",
        execution.input_file(params.get("base"))
    ])
    cargs.extend([
        "-prefix",
        params.get("prefix")
    ])
    if params.get("followers_nn") is not None:
        cargs.extend([
            "-followers_NN",
            *[execution.input_file(f) for f in params.get("followers_nn")]
        ])
    if params.get("followers_wsinc5") is not None:
        cargs.extend([
            "-followers_wsinc5",
            *[execution.input_file(f) for f in params.get("followers_wsinc5")]
        ])
    if params.get("followers_surf") is not None:
        cargs.extend([
            "-followers_surf",
            *[execution.input_file(f) for f in params.get("followers_surf")]
        ])
    if params.get("followers_ndset") is not None:
        cargs.extend([
            "-followers_ndset",
            *[execution.input_file(f) for f in params.get("followers_ndset")]
        ])
    if params.get("followers_spec") is not None:
        cargs.extend([
            "-followers_spec",
            *[execution.input_file(f) for f in params.get("followers_spec")]
        ])
    if params.get("matrix") is not None:
        cargs.extend([
            "-matrix",
            execution.input_file(params.get("matrix"))
        ])
    if params.get("workdir") is not None:
        cargs.extend([
            "-workdir",
            params.get("workdir")
        ])
    if params.get("no_cmd_out"):
        cargs.append("-no_cmd_out")
    if params.get("no_clean"):
        cargs.append("-no_clean")
    return cargs


def fat_proc_map_to_dti_outputs(
    params: FatProcMapToDtiParameters,
    execution: Execution,
) -> FatProcMapToDtiOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = FatProcMapToDtiOutputs(
        root=execution.output_file("."),
    )
    return ret


def fat_proc_map_to_dti_execute(
    params: FatProcMapToDtiParameters,
    execution: Execution,
) -> FatProcMapToDtiOutputs:
    """
    A program for mapping data sets into DWI space, suitable for aligning anatomical
    ROI maps or EPI data to a DWI reference volume.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `FatProcMapToDtiOutputs`).
    """
    params = execution.params(params)
    cargs = fat_proc_map_to_dti_cargs(params, execution)
    ret = fat_proc_map_to_dti_outputs(params, execution)
    execution.run(cargs)
    return ret


def fat_proc_map_to_dti(
    source: InputPathType,
    base: InputPathType,
    prefix: str,
    followers_nn: list[InputPathType] | None = None,
    followers_wsinc5: list[InputPathType] | None = None,
    followers_surf: list[InputPathType] | None = None,
    followers_ndset: list[InputPathType] | None = None,
    followers_spec: list[InputPathType] | None = None,
    matrix: InputPathType | None = None,
    workdir: str | None = None,
    no_cmd_out: bool = False,
    no_clean: bool = False,
    runner: Runner | None = None,
) -> FatProcMapToDtiOutputs:
    """
    A program for mapping data sets into DWI space, suitable for aligning anatomical
    ROI maps or EPI data to a DWI reference volume.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        source: T1w volume file (source volume).
        base: DWI reference volume file.
        prefix: Output prefix for files and snapshots.
        followers_nn: Follower data sets with NN interpolation.
        followers_wsinc5: Follower data sets with wsinc5 interpolation.
        followers_surf: Surface follower data sets.
        followers_ndset: NIML follower data sets.
        followers_spec: Spec follower data sets.
        matrix: Pre-made matrix file for transformation.
        workdir: Specify a working directory.
        no_cmd_out: Don't save the command line call of this program.
        no_clean: Do not delete temporary working directory.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FatProcMapToDtiOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(FAT_PROC_MAP_TO_DTI_METADATA)
    params = fat_proc_map_to_dti_params(
        source=source,
        base=base,
        prefix=prefix,
        followers_nn=followers_nn,
        followers_wsinc5=followers_wsinc5,
        followers_surf=followers_surf,
        followers_ndset=followers_ndset,
        followers_spec=followers_spec,
        matrix=matrix,
        workdir=workdir,
        no_cmd_out=no_cmd_out,
        no_clean=no_clean,
    )
    return fat_proc_map_to_dti_execute(params, execution)


__all__ = [
    "FAT_PROC_MAP_TO_DTI_METADATA",
    "FatProcMapToDtiOutputs",
    "FatProcMapToDtiParameters",
    "fat_proc_map_to_dti",
    "fat_proc_map_to_dti_params",
]
