# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

FAT_ROI_ROW_METADATA = Metadata(
    id="739c802e1b22c2e198a3d50de14679a6f269f722.boutiques",
    name="fat_roi_row",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


FatRoiRowParameters = typing.TypedDict('FatRoiRowParameters', {
    "__STYXTYPE__": typing.Literal["fat_roi_row"],
    "roi": str,
    "matrix_files": typing.NotRequired[str | None],
    "list_file": typing.NotRequired[InputPathType | None],
    "extern_labs_no": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "fat_roi_row": fat_roi_row_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "fat_roi_row": fat_roi_row_outputs,
    }.get(t)


class FatRoiRowOutputs(typing.NamedTuple):
    """
    Output object returned when calling `fat_roi_row(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Selected ROI row output file in .row format."""


def fat_roi_row_params(
    roi: str,
    matrix_files: str | None = None,
    list_file: InputPathType | None = None,
    extern_labs_no: bool = False,
) -> FatRoiRowParameters:
    """
    Build parameters.
    
    Args:
        roi: Specify which ROI's row of connectivity you want to select out. If\
            labeltables were used, you may select the ROI by either the string\
            label or the ROI mask number.
        matrix_files: Provide the set of matrix (*.grid or *.netcc) files by\
            searchable path. This can be a globbable entry in quotes containing\
            wildcard characters.
        list_file: Provide the set of matrix (*.grid or *.netcc) files by\
            explicit path in a text file. The LIST text file must contain at least\
            one column with the path to subject matrix file.
        extern_labs_no: Switch to turn off the writing/usage of user-defined\
            labels in the *.grid/*.netcc files.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "fat_roi_row",
        "roi": roi,
        "extern_labs_no": extern_labs_no,
    }
    if matrix_files is not None:
        params["matrix_files"] = matrix_files
    if list_file is not None:
        params["list_file"] = list_file
    return params


def fat_roi_row_cargs(
    params: FatRoiRowParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("fat_roi_row.py")
    cargs.extend([
        "-r",
        params.get("roi")
    ])
    if params.get("matrix_files") is not None:
        cargs.extend([
            "-m",
            params.get("matrix_files")
        ])
    if params.get("list_file") is not None:
        cargs.extend([
            "-l",
            execution.input_file(params.get("list_file"))
        ])
    if params.get("extern_labs_no"):
        cargs.append("-E")
    return cargs


def fat_roi_row_outputs(
    params: FatRoiRowParameters,
    execution: Execution,
) -> FatRoiRowOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = FatRoiRowOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("roi") + "_selected.row"),
    )
    return ret


def fat_roi_row_execute(
    params: FatRoiRowParameters,
    execution: Execution,
) -> FatRoiRowOutputs:
    """
    Select a single ROI's row out of a connectivity matrix file (*.grid or *.netcc)
    for viewing and/or further analysis.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `FatRoiRowOutputs`).
    """
    params = execution.params(params)
    cargs = fat_roi_row_cargs(params, execution)
    ret = fat_roi_row_outputs(params, execution)
    execution.run(cargs)
    return ret


def fat_roi_row(
    roi: str,
    matrix_files: str | None = None,
    list_file: InputPathType | None = None,
    extern_labs_no: bool = False,
    runner: Runner | None = None,
) -> FatRoiRowOutputs:
    """
    Select a single ROI's row out of a connectivity matrix file (*.grid or *.netcc)
    for viewing and/or further analysis.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        roi: Specify which ROI's row of connectivity you want to select out. If\
            labeltables were used, you may select the ROI by either the string\
            label or the ROI mask number.
        matrix_files: Provide the set of matrix (*.grid or *.netcc) files by\
            searchable path. This can be a globbable entry in quotes containing\
            wildcard characters.
        list_file: Provide the set of matrix (*.grid or *.netcc) files by\
            explicit path in a text file. The LIST text file must contain at least\
            one column with the path to subject matrix file.
        extern_labs_no: Switch to turn off the writing/usage of user-defined\
            labels in the *.grid/*.netcc files.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FatRoiRowOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(FAT_ROI_ROW_METADATA)
    params = fat_roi_row_params(
        roi=roi,
        matrix_files=matrix_files,
        list_file=list_file,
        extern_labs_no=extern_labs_no,
    )
    return fat_roi_row_execute(params, execution)


__all__ = [
    "FAT_ROI_ROW_METADATA",
    "FatRoiRowOutputs",
    "FatRoiRowParameters",
    "fat_roi_row",
    "fat_roi_row_params",
]
