# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

FILE_TOOL_METADATA = Metadata(
    id="3be01685ddee430df908b2cebb65205e7abd55ae.boutiques",
    name="file_tool",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


FileToolParameters = typing.TypedDict('FileToolParameters', {
    "__STYXTYPE__": typing.Literal["file_tool"],
    "help": bool,
    "version": bool,
    "hist": bool,
    "debug": typing.NotRequired[float | None],
    "infiles": list[InputPathType],
    "ge_all": bool,
    "ge_header": bool,
    "ge_extras": bool,
    "ge_uv17": bool,
    "ge_run": bool,
    "ge_off": bool,
    "ge4_all": bool,
    "ge4_image": bool,
    "ge4_series": bool,
    "ge4_study": bool,
    "def_ana_hdr": bool,
    "diff_ana_hdrs": bool,
    "disp_ana_hdr": bool,
    "hex": bool,
    "mod_ana_hdr": bool,
    "mod_field": typing.NotRequired[str | None],
    "prefix": typing.NotRequired[str | None],
    "overwrite": bool,
    "show_bad_all": bool,
    "show_bad_backslash": bool,
    "show_bad_char": bool,
    "show_file_type": bool,
    "fix_rich_quotes": typing.NotRequired[str | None],
    "test": bool,
    "length": typing.NotRequired[float | None],
    "mod_data": typing.NotRequired[str | None],
    "mod_type": typing.NotRequired[str | None],
    "offset": typing.NotRequired[float | None],
    "quiet": bool,
    "disp_hex": bool,
    "disp_hex1": bool,
    "disp_hex2": bool,
    "disp_hex4": bool,
    "disp_int2": bool,
    "disp_int4": bool,
    "disp_real4": bool,
    "swap_bytes": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "file_tool": file_tool_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "file_tool": file_tool_outputs,
    }.get(t)


class FileToolOutputs(typing.NamedTuple):
    """
    Output object returned when calling `file_tool(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    modified_file: OutputPathType | None
    """The modified output file"""


def file_tool_params(
    infiles: list[InputPathType],
    help_: bool = False,
    version: bool = False,
    hist: bool = False,
    debug: float | None = None,
    ge_all: bool = False,
    ge_header: bool = False,
    ge_extras: bool = False,
    ge_uv17: bool = False,
    ge_run: bool = False,
    ge_off: bool = False,
    ge4_all: bool = False,
    ge4_image: bool = False,
    ge4_series: bool = False,
    ge4_study: bool = False,
    def_ana_hdr: bool = False,
    diff_ana_hdrs: bool = False,
    disp_ana_hdr: bool = False,
    hex_: bool = False,
    mod_ana_hdr: bool = False,
    mod_field: str | None = None,
    prefix: str | None = None,
    overwrite: bool = False,
    show_bad_all: bool = False,
    show_bad_backslash: bool = False,
    show_bad_char: bool = False,
    show_file_type: bool = False,
    fix_rich_quotes: str | None = None,
    test: bool = False,
    length: float | None = None,
    mod_data: str | None = None,
    mod_type: str | None = None,
    offset: float | None = None,
    quiet: bool = False,
    disp_hex: bool = False,
    disp_hex1: bool = False,
    disp_hex2: bool = False,
    disp_hex4: bool = False,
    disp_int2: bool = False,
    disp_int4: bool = False,
    disp_real4: bool = False,
    swap_bytes: bool = False,
) -> FileToolParameters:
    """
    Build parameters.
    
    Args:
        infiles: Specify input files to display or modify.
        help_: Show help information.
        version: Show version information.
        hist: Show the program's modification history.
        debug: Print extra info along the way, default is 0, max is 2.
        ge_all: Display GE header and extras info.
        ge_header: Display GE header info.
        ge_extras: Display extra GE image info.
        ge_uv17: Display the value of uv17 (the run #).
        ge_run: Display the value of uv17 (the run #).
        ge_off: Display file offsets for various fields.
        ge4_all: Display GEMS 4.x series and image headers.
        ge4_image: Display GEMS 4.x image header.
        ge4_series: Display GEMS 4.x series header.
        ge4_study: Display GEMS 4.x study header.
        def_ana_hdr: Display the definition of an ANALYZE header.
        diff_ana_hdrs: Display field differences between 2 headers.
        disp_ana_hdr: Display ANALYZE headers.
        hex_: Display field values in hexadecimal.
        mod_ana_hdr: Modify ANALYZE headers.
        mod_field: Specify a field and value(s) to modify.
        prefix: Specify an output filename.
        overwrite: Specify to overwrite the input file(s).
        show_bad_all: Show lines with whitespace after '\\'.
        show_bad_backslash: Show lines with whitespace after '\\'.
        show_bad_char: Show any non-printable characters.
        show_file_type: Print file type of UNIX, Mac or DOS.
        fix_rich_quotes: Replace rich-text quotes with ASCII.
        test: Short for -show_bad_all. Check script files for known issues.
        length: Specify the number of bytes to print/modify.
        mod_data: Specify a string to modify the data to.
        mod_type: Specify the data type to write to the file.
        offset: Specify the offset into each file.
        quiet: Do not output header information.
        disp_hex: Display bytes in hex.
        disp_hex1: Display bytes in hex.
        disp_hex2: Display 2-byte integers in hex.
        disp_hex4: Display 4-byte integers in hex.
        disp_int2: Display 2-byte integers.
        disp_int4: Display 4-byte integers.
        disp_real4: Display 4-byte real numbers.
        swap_bytes: Use byte-swapping on numbers.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "file_tool",
        "help": help_,
        "version": version,
        "hist": hist,
        "infiles": infiles,
        "ge_all": ge_all,
        "ge_header": ge_header,
        "ge_extras": ge_extras,
        "ge_uv17": ge_uv17,
        "ge_run": ge_run,
        "ge_off": ge_off,
        "ge4_all": ge4_all,
        "ge4_image": ge4_image,
        "ge4_series": ge4_series,
        "ge4_study": ge4_study,
        "def_ana_hdr": def_ana_hdr,
        "diff_ana_hdrs": diff_ana_hdrs,
        "disp_ana_hdr": disp_ana_hdr,
        "hex": hex_,
        "mod_ana_hdr": mod_ana_hdr,
        "overwrite": overwrite,
        "show_bad_all": show_bad_all,
        "show_bad_backslash": show_bad_backslash,
        "show_bad_char": show_bad_char,
        "show_file_type": show_file_type,
        "test": test,
        "quiet": quiet,
        "disp_hex": disp_hex,
        "disp_hex1": disp_hex1,
        "disp_hex2": disp_hex2,
        "disp_hex4": disp_hex4,
        "disp_int2": disp_int2,
        "disp_int4": disp_int4,
        "disp_real4": disp_real4,
        "swap_bytes": swap_bytes,
    }
    if debug is not None:
        params["debug"] = debug
    if mod_field is not None:
        params["mod_field"] = mod_field
    if prefix is not None:
        params["prefix"] = prefix
    if fix_rich_quotes is not None:
        params["fix_rich_quotes"] = fix_rich_quotes
    if length is not None:
        params["length"] = length
    if mod_data is not None:
        params["mod_data"] = mod_data
    if mod_type is not None:
        params["mod_type"] = mod_type
    if offset is not None:
        params["offset"] = offset
    return params


def file_tool_cargs(
    params: FileToolParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("file_tool")
    if params.get("help"):
        cargs.append("-help")
    if params.get("version"):
        cargs.append("-version")
    if params.get("hist"):
        cargs.append("-hist")
    if params.get("debug") is not None:
        cargs.extend([
            "-debug",
            str(params.get("debug"))
        ])
    cargs.extend([
        "-infiles",
        *[execution.input_file(f) for f in params.get("infiles")]
    ])
    if params.get("ge_all"):
        cargs.append("-ge_all")
    if params.get("ge_header"):
        cargs.append("-ge_header")
    if params.get("ge_extras"):
        cargs.append("-ge_extras")
    if params.get("ge_uv17"):
        cargs.append("-ge_uv17")
    if params.get("ge_run"):
        cargs.append("-ge_run")
    if params.get("ge_off"):
        cargs.append("-ge_off")
    if params.get("ge4_all"):
        cargs.append("-ge4_all")
    if params.get("ge4_image"):
        cargs.append("-ge4_image")
    if params.get("ge4_series"):
        cargs.append("-ge4_series")
    if params.get("ge4_study"):
        cargs.append("-ge4_study")
    if params.get("def_ana_hdr"):
        cargs.append("-def_ana_hdr")
    if params.get("diff_ana_hdrs"):
        cargs.append("-diff_ana_hdrs")
    if params.get("disp_ana_hdr"):
        cargs.append("-disp_ana_hdr")
    if params.get("hex"):
        cargs.append("-hex")
    if params.get("mod_ana_hdr"):
        cargs.append("-mod_ana_hdr")
    if params.get("mod_field") is not None:
        cargs.extend([
            "-mod_field",
            params.get("mod_field")
        ])
    if params.get("prefix") is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix")
        ])
    if params.get("overwrite"):
        cargs.append("-overwrite")
    if params.get("show_bad_all"):
        cargs.append("-show_bad_all")
    if params.get("show_bad_backslash"):
        cargs.append("-show_bad_backslash")
    if params.get("show_bad_char"):
        cargs.append("-show_bad_char")
    if params.get("show_file_type"):
        cargs.append("-show_file_type")
    if params.get("fix_rich_quotes") is not None:
        cargs.extend([
            "-fix_rich_quotes",
            params.get("fix_rich_quotes")
        ])
    if params.get("test"):
        cargs.append("-test")
    if params.get("length") is not None:
        cargs.extend([
            "-length",
            str(params.get("length"))
        ])
    if params.get("mod_data") is not None:
        cargs.extend([
            "-mod_data",
            params.get("mod_data")
        ])
    if params.get("mod_type") is not None:
        cargs.extend([
            "-mod_type",
            params.get("mod_type")
        ])
    if params.get("offset") is not None:
        cargs.extend([
            "-offset",
            str(params.get("offset"))
        ])
    if params.get("quiet"):
        cargs.append("-quiet")
    if params.get("disp_hex"):
        cargs.append("-disp_hex")
    if params.get("disp_hex1"):
        cargs.append("-disp_hex1")
    if params.get("disp_hex2"):
        cargs.append("-disp_hex2")
    if params.get("disp_hex4"):
        cargs.append("-disp_hex4")
    if params.get("disp_int2"):
        cargs.append("-disp_int2")
    if params.get("disp_int4"):
        cargs.append("-disp_int4")
    if params.get("disp_real4"):
        cargs.append("-disp_real4")
    if params.get("swap_bytes"):
        cargs.append("-swap_bytes")
    return cargs


def file_tool_outputs(
    params: FileToolParameters,
    execution: Execution,
) -> FileToolOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = FileToolOutputs(
        root=execution.output_file("."),
        modified_file=execution.output_file(params.get("prefix")) if (params.get("prefix") is not None) else None,
    )
    return ret


def file_tool_execute(
    params: FileToolParameters,
    execution: Execution,
) -> FileToolOutputs:
    """
    Program to display or modify sections of a file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `FileToolOutputs`).
    """
    params = execution.params(params)
    cargs = file_tool_cargs(params, execution)
    ret = file_tool_outputs(params, execution)
    execution.run(cargs)
    return ret


def file_tool(
    infiles: list[InputPathType],
    help_: bool = False,
    version: bool = False,
    hist: bool = False,
    debug: float | None = None,
    ge_all: bool = False,
    ge_header: bool = False,
    ge_extras: bool = False,
    ge_uv17: bool = False,
    ge_run: bool = False,
    ge_off: bool = False,
    ge4_all: bool = False,
    ge4_image: bool = False,
    ge4_series: bool = False,
    ge4_study: bool = False,
    def_ana_hdr: bool = False,
    diff_ana_hdrs: bool = False,
    disp_ana_hdr: bool = False,
    hex_: bool = False,
    mod_ana_hdr: bool = False,
    mod_field: str | None = None,
    prefix: str | None = None,
    overwrite: bool = False,
    show_bad_all: bool = False,
    show_bad_backslash: bool = False,
    show_bad_char: bool = False,
    show_file_type: bool = False,
    fix_rich_quotes: str | None = None,
    test: bool = False,
    length: float | None = None,
    mod_data: str | None = None,
    mod_type: str | None = None,
    offset: float | None = None,
    quiet: bool = False,
    disp_hex: bool = False,
    disp_hex1: bool = False,
    disp_hex2: bool = False,
    disp_hex4: bool = False,
    disp_int2: bool = False,
    disp_int4: bool = False,
    disp_real4: bool = False,
    swap_bytes: bool = False,
    runner: Runner | None = None,
) -> FileToolOutputs:
    """
    Program to display or modify sections of a file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infiles: Specify input files to display or modify.
        help_: Show help information.
        version: Show version information.
        hist: Show the program's modification history.
        debug: Print extra info along the way, default is 0, max is 2.
        ge_all: Display GE header and extras info.
        ge_header: Display GE header info.
        ge_extras: Display extra GE image info.
        ge_uv17: Display the value of uv17 (the run #).
        ge_run: Display the value of uv17 (the run #).
        ge_off: Display file offsets for various fields.
        ge4_all: Display GEMS 4.x series and image headers.
        ge4_image: Display GEMS 4.x image header.
        ge4_series: Display GEMS 4.x series header.
        ge4_study: Display GEMS 4.x study header.
        def_ana_hdr: Display the definition of an ANALYZE header.
        diff_ana_hdrs: Display field differences between 2 headers.
        disp_ana_hdr: Display ANALYZE headers.
        hex_: Display field values in hexadecimal.
        mod_ana_hdr: Modify ANALYZE headers.
        mod_field: Specify a field and value(s) to modify.
        prefix: Specify an output filename.
        overwrite: Specify to overwrite the input file(s).
        show_bad_all: Show lines with whitespace after '\\'.
        show_bad_backslash: Show lines with whitespace after '\\'.
        show_bad_char: Show any non-printable characters.
        show_file_type: Print file type of UNIX, Mac or DOS.
        fix_rich_quotes: Replace rich-text quotes with ASCII.
        test: Short for -show_bad_all. Check script files for known issues.
        length: Specify the number of bytes to print/modify.
        mod_data: Specify a string to modify the data to.
        mod_type: Specify the data type to write to the file.
        offset: Specify the offset into each file.
        quiet: Do not output header information.
        disp_hex: Display bytes in hex.
        disp_hex1: Display bytes in hex.
        disp_hex2: Display 2-byte integers in hex.
        disp_hex4: Display 4-byte integers in hex.
        disp_int2: Display 2-byte integers.
        disp_int4: Display 4-byte integers.
        disp_real4: Display 4-byte real numbers.
        swap_bytes: Use byte-swapping on numbers.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FileToolOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(FILE_TOOL_METADATA)
    params = file_tool_params(
        help_=help_,
        version=version,
        hist=hist,
        debug=debug,
        infiles=infiles,
        ge_all=ge_all,
        ge_header=ge_header,
        ge_extras=ge_extras,
        ge_uv17=ge_uv17,
        ge_run=ge_run,
        ge_off=ge_off,
        ge4_all=ge4_all,
        ge4_image=ge4_image,
        ge4_series=ge4_series,
        ge4_study=ge4_study,
        def_ana_hdr=def_ana_hdr,
        diff_ana_hdrs=diff_ana_hdrs,
        disp_ana_hdr=disp_ana_hdr,
        hex_=hex_,
        mod_ana_hdr=mod_ana_hdr,
        mod_field=mod_field,
        prefix=prefix,
        overwrite=overwrite,
        show_bad_all=show_bad_all,
        show_bad_backslash=show_bad_backslash,
        show_bad_char=show_bad_char,
        show_file_type=show_file_type,
        fix_rich_quotes=fix_rich_quotes,
        test=test,
        length=length,
        mod_data=mod_data,
        mod_type=mod_type,
        offset=offset,
        quiet=quiet,
        disp_hex=disp_hex,
        disp_hex1=disp_hex1,
        disp_hex2=disp_hex2,
        disp_hex4=disp_hex4,
        disp_int2=disp_int2,
        disp_int4=disp_int4,
        disp_real4=disp_real4,
        swap_bytes=swap_bytes,
    )
    return file_tool_execute(params, execution)


__all__ = [
    "FILE_TOOL_METADATA",
    "FileToolOutputs",
    "FileToolParameters",
    "file_tool",
    "file_tool_params",
]
