# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

FIM2_METADATA = Metadata(
    id="821c0c76727aa989e97731a04d2596a66d166df2.boutiques",
    name="fim2",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


Fim2Parameters = typing.TypedDict('Fim2Parameters', {
    "__STYXTYPE__": typing.Literal["fim2"],
    "image_files": list[InputPathType],
    "pcnt": typing.NotRequired[float | None],
    "pcthresh": typing.NotRequired[float | None],
    "im1": typing.NotRequired[int | None],
    "num": typing.NotRequired[int | None],
    "non": bool,
    "coef": typing.NotRequired[float | None],
    "ort": typing.NotRequired[list[InputPathType] | None],
    "ideal": typing.NotRequired[list[InputPathType] | None],
    "polref": typing.NotRequired[int | None],
    "fimfile": typing.NotRequired[str | None],
    "corr": bool,
    "corfile": typing.NotRequired[str | None],
    "cnrfile": typing.NotRequired[str | None],
    "sigfile": typing.NotRequired[str | None],
    "fitfile": typing.NotRequired[str | None],
    "subort": typing.NotRequired[str | None],
    "flim": bool,
    "clean": bool,
    "clip": bool,
    "q": bool,
    "dfspace": bool,
    "regbase": typing.NotRequired[str | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "fim2": fim2_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "fim2": fim2_outputs,
    }.get(t)


class Fim2Outputs(typing.NamedTuple):
    """
    Output object returned when calling `fim2(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    activation_magnitudes: OutputPathType | None
    """Activation magnitudes output file"""
    correlation_image: OutputPathType | None
    """Correlation image output file"""
    contrast_to_noise_image: OutputPathType | None
    """Contrast-to-noise image output file"""
    std_deviation_image: OutputPathType | None
    """Standard deviation image output file"""
    ls_fit_coefficients: OutputPathType | None
    """Least squares fit coefficients image files"""
    subtracted_references: OutputPathType | None
    """Subtracted ortho reference time series images"""


def fim2_params(
    image_files: list[InputPathType],
    pcnt: float | None = None,
    pcthresh: float | None = None,
    im1: int | None = None,
    num: int | None = None,
    non: bool = False,
    coef: float | None = None,
    ort: list[InputPathType] | None = None,
    ideal: list[InputPathType] | None = None,
    polref: int | None = None,
    fimfile: str | None = None,
    corr: bool = False,
    corfile: str | None = None,
    cnrfile: str | None = None,
    sigfile: str | None = None,
    fitfile: str | None = None,
    subort: str | None = None,
    flim: bool = False,
    clean: bool = False,
    clip: bool = False,
    q: bool = False,
    dfspace: bool = False,
    regbase: str | None = None,
) -> Fim2Parameters:
    """
    Build parameters.
    
    Args:
        image_files: Input MRI image files.
        pcnt: Correlation coefficient threshold will be 1 - 0.01 * #.
        pcthresh: Correlation coefficient threshold will be #.
        im1: Index of image file to use as first in time series; default is 1.
        num: Number of images to actually use; default is to use all images.
        non: Turn off default normalization of the output activation image.
        coef: Scaling factor to convert the activation output from floats to\
            short ints.
        ort: Filename of a time series to which the image data will be\
            orthogonalized before correlations are computed.
        ideal: Filename of a time series to which the image data is to be\
            correlated.
        polref: Use polynomials of order 0..# as extra 'orts'; default is 0.
        fimfile: Filename to save activation magnitudes in.
        corr: Indicates to write correlation output to image file\
            'fimfile.CORR'.
        corfile: Filename to save correlation image in.
        cnrfile: Filename to save contrast-to-noise image in.
        sigfile: Filename to save standard deviation image in.
        fitfile: Image files of the least squares fit coefficients of all the\
            -ort and -polref time series.
        subort: Filename of the new timeseries of images with the orts and\
            polrefs subtracted out.
        flim: Write outputs in mrilib 'float' format.
        clean: Output images won't have the +/- 10000 values forced into their\
            corners for scaling purposes.
        clip: Set to zero regions of low intensity in output correlations, etc.
        q: Quiet operation mode.
        dfspace: Use the 'dfspace' filter to register the images spatially\
            before filtering.
        regbase: Read image in file 'fname' as the base image for registration.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "fim2",
        "image_files": image_files,
        "non": non,
        "corr": corr,
        "flim": flim,
        "clean": clean,
        "clip": clip,
        "q": q,
        "dfspace": dfspace,
    }
    if pcnt is not None:
        params["pcnt"] = pcnt
    if pcthresh is not None:
        params["pcthresh"] = pcthresh
    if im1 is not None:
        params["im1"] = im1
    if num is not None:
        params["num"] = num
    if coef is not None:
        params["coef"] = coef
    if ort is not None:
        params["ort"] = ort
    if ideal is not None:
        params["ideal"] = ideal
    if polref is not None:
        params["polref"] = polref
    if fimfile is not None:
        params["fimfile"] = fimfile
    if corfile is not None:
        params["corfile"] = corfile
    if cnrfile is not None:
        params["cnrfile"] = cnrfile
    if sigfile is not None:
        params["sigfile"] = sigfile
    if fitfile is not None:
        params["fitfile"] = fitfile
    if subort is not None:
        params["subort"] = subort
    if regbase is not None:
        params["regbase"] = regbase
    return params


def fim2_cargs(
    params: Fim2Parameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("fim2")
    cargs.extend([execution.input_file(f) for f in params.get("image_files")])
    if params.get("pcnt") is not None:
        cargs.extend([
            "-pcnt",
            str(params.get("pcnt"))
        ])
    if params.get("pcthresh") is not None:
        cargs.extend([
            "-pcthresh",
            str(params.get("pcthresh"))
        ])
    if params.get("im1") is not None:
        cargs.extend([
            "-im1",
            str(params.get("im1"))
        ])
    if params.get("num") is not None:
        cargs.extend([
            "-num",
            str(params.get("num"))
        ])
    if params.get("non"):
        cargs.append("-non")
    if params.get("coef") is not None:
        cargs.extend([
            "-coef",
            str(params.get("coef"))
        ])
    if params.get("ort") is not None:
        cargs.extend([
            "-ort",
            *[execution.input_file(f) for f in params.get("ort")]
        ])
    if params.get("ideal") is not None:
        cargs.extend([
            "-ideal",
            *[execution.input_file(f) for f in params.get("ideal")]
        ])
    if params.get("polref") is not None:
        cargs.extend([
            "-polref",
            str(params.get("polref"))
        ])
    if params.get("fimfile") is not None:
        cargs.extend([
            "-fimfile",
            params.get("fimfile")
        ])
    if params.get("corr"):
        cargs.append("-corr")
    if params.get("corfile") is not None:
        cargs.extend([
            "-corfile",
            params.get("corfile")
        ])
    if params.get("cnrfile") is not None:
        cargs.extend([
            "-cnrfile",
            params.get("cnrfile")
        ])
    if params.get("sigfile") is not None:
        cargs.extend([
            "-sigfile",
            params.get("sigfile")
        ])
    if params.get("fitfile") is not None:
        cargs.extend([
            "-fitfile",
            params.get("fitfile")
        ])
    if params.get("subort") is not None:
        cargs.extend([
            "-subort",
            params.get("subort")
        ])
    if params.get("flim"):
        cargs.append("-flim")
    if params.get("clean"):
        cargs.append("-clean")
    if params.get("clip"):
        cargs.append("-clip")
    if params.get("q"):
        cargs.append("-q")
    if params.get("dfspace"):
        cargs.append("-dfspace")
    if params.get("regbase") is not None:
        cargs.extend([
            "-regbase",
            params.get("regbase")
        ])
    return cargs


def fim2_outputs(
    params: Fim2Parameters,
    execution: Execution,
) -> Fim2Outputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = Fim2Outputs(
        root=execution.output_file("."),
        activation_magnitudes=execution.output_file(params.get("fimfile")) if (params.get("fimfile") is not None) else None,
        correlation_image=execution.output_file(params.get("corfile")) if (params.get("corfile") is not None) else None,
        contrast_to_noise_image=execution.output_file(params.get("cnrfile")) if (params.get("cnrfile") is not None) else None,
        std_deviation_image=execution.output_file(params.get("sigfile")) if (params.get("sigfile") is not None) else None,
        ls_fit_coefficients=execution.output_file(params.get("fitfile")) if (params.get("fitfile") is not None) else None,
        subtracted_references=execution.output_file(params.get("subort")) if (params.get("subort") is not None) else None,
    )
    return ret


def fim2_execute(
    params: Fim2Parameters,
    execution: Execution,
) -> Fim2Outputs:
    """
    Functional Imaging Mapping Tool.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `Fim2Outputs`).
    """
    params = execution.params(params)
    cargs = fim2_cargs(params, execution)
    ret = fim2_outputs(params, execution)
    execution.run(cargs)
    return ret


def fim2(
    image_files: list[InputPathType],
    pcnt: float | None = None,
    pcthresh: float | None = None,
    im1: int | None = None,
    num: int | None = None,
    non: bool = False,
    coef: float | None = None,
    ort: list[InputPathType] | None = None,
    ideal: list[InputPathType] | None = None,
    polref: int | None = None,
    fimfile: str | None = None,
    corr: bool = False,
    corfile: str | None = None,
    cnrfile: str | None = None,
    sigfile: str | None = None,
    fitfile: str | None = None,
    subort: str | None = None,
    flim: bool = False,
    clean: bool = False,
    clip: bool = False,
    q: bool = False,
    dfspace: bool = False,
    regbase: str | None = None,
    runner: Runner | None = None,
) -> Fim2Outputs:
    """
    Functional Imaging Mapping Tool.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        image_files: Input MRI image files.
        pcnt: Correlation coefficient threshold will be 1 - 0.01 * #.
        pcthresh: Correlation coefficient threshold will be #.
        im1: Index of image file to use as first in time series; default is 1.
        num: Number of images to actually use; default is to use all images.
        non: Turn off default normalization of the output activation image.
        coef: Scaling factor to convert the activation output from floats to\
            short ints.
        ort: Filename of a time series to which the image data will be\
            orthogonalized before correlations are computed.
        ideal: Filename of a time series to which the image data is to be\
            correlated.
        polref: Use polynomials of order 0..# as extra 'orts'; default is 0.
        fimfile: Filename to save activation magnitudes in.
        corr: Indicates to write correlation output to image file\
            'fimfile.CORR'.
        corfile: Filename to save correlation image in.
        cnrfile: Filename to save contrast-to-noise image in.
        sigfile: Filename to save standard deviation image in.
        fitfile: Image files of the least squares fit coefficients of all the\
            -ort and -polref time series.
        subort: Filename of the new timeseries of images with the orts and\
            polrefs subtracted out.
        flim: Write outputs in mrilib 'float' format.
        clean: Output images won't have the +/- 10000 values forced into their\
            corners for scaling purposes.
        clip: Set to zero regions of low intensity in output correlations, etc.
        q: Quiet operation mode.
        dfspace: Use the 'dfspace' filter to register the images spatially\
            before filtering.
        regbase: Read image in file 'fname' as the base image for registration.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `Fim2Outputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(FIM2_METADATA)
    params = fim2_params(
        image_files=image_files,
        pcnt=pcnt,
        pcthresh=pcthresh,
        im1=im1,
        num=num,
        non=non,
        coef=coef,
        ort=ort,
        ideal=ideal,
        polref=polref,
        fimfile=fimfile,
        corr=corr,
        corfile=corfile,
        cnrfile=cnrfile,
        sigfile=sigfile,
        fitfile=fitfile,
        subort=subort,
        flim=flim,
        clean=clean,
        clip=clip,
        q=q,
        dfspace=dfspace,
        regbase=regbase,
    )
    return fim2_execute(params, execution)


__all__ = [
    "FIM2_METADATA",
    "Fim2Outputs",
    "Fim2Parameters",
    "fim2",
    "fim2_params",
]
