# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

GEN_EPI_REVIEW_PY_METADATA = Metadata(
    id="d8d2bfa4cbebb23bdbab47bb389c8686d9524ec8.boutiques",
    name="gen_epi_review.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


GenEpiReviewPyParameters = typing.TypedDict('GenEpiReviewPyParameters', {
    "__STYXTYPE__": typing.Literal["gen_epi_review.py"],
    "datasets": list[str],
    "script_name": typing.NotRequired[str | None],
    "windows": typing.NotRequired[list[str] | None],
    "verbosity": typing.NotRequired[float | None],
    "image_size": typing.NotRequired[list[float] | None],
    "image_xoffset": typing.NotRequired[float | None],
    "image_yoffset": typing.NotRequired[float | None],
    "graph_size": typing.NotRequired[list[float] | None],
    "graph_xoffset": typing.NotRequired[float | None],
    "graph_yoffset": typing.NotRequired[float | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "gen_epi_review.py": gen_epi_review_py_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class GenEpiReviewPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `gen_epi_review_py(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def gen_epi_review_py_params(
    datasets: list[str],
    script_name: str | None = None,
    windows: list[str] | None = None,
    verbosity: float | None = None,
    image_size: list[float] | None = None,
    image_xoffset: float | None = None,
    image_yoffset: float | None = None,
    graph_size: list[float] | None = None,
    graph_xoffset: float | None = None,
    graph_yoffset: float | None = None,
) -> GenEpiReviewPyParameters:
    """
    Build parameters.
    
    Args:
        datasets: Specify input datasets for processing.
        script_name: Specify the name of the generated script.
        windows: Specify the image windows to open.
        verbosity: Specify a verbosity level.
        image_size: Set image dimensions, in pixels.
        image_xoffset: Set the X-offset for the image, in pixels.
        image_yoffset: Set the Y-offset for the image, in pixels.
        graph_size: Set graph dimensions, in pixels.
        graph_xoffset: Set the X-offset for the graph, in pixels.
        graph_yoffset: Set the Y-offset for the graph, in pixels.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "gen_epi_review.py",
        "datasets": datasets,
    }
    if script_name is not None:
        params["script_name"] = script_name
    if windows is not None:
        params["windows"] = windows
    if verbosity is not None:
        params["verbosity"] = verbosity
    if image_size is not None:
        params["image_size"] = image_size
    if image_xoffset is not None:
        params["image_xoffset"] = image_xoffset
    if image_yoffset is not None:
        params["image_yoffset"] = image_yoffset
    if graph_size is not None:
        params["graph_size"] = graph_size
    if graph_xoffset is not None:
        params["graph_xoffset"] = graph_xoffset
    if graph_yoffset is not None:
        params["graph_yoffset"] = graph_yoffset
    return params


def gen_epi_review_py_cargs(
    params: GenEpiReviewPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("gen_epi_review.py")
    cargs.extend([
        "-dsets",
        *params.get("datasets")
    ])
    if params.get("script_name") is not None:
        cargs.extend([
            "-script",
            params.get("script_name")
        ])
    if params.get("windows") is not None:
        cargs.extend([
            "-windows",
            *params.get("windows")
        ])
    if params.get("verbosity") is not None:
        cargs.extend([
            "-verb",
            str(params.get("verbosity"))
        ])
    if params.get("image_size") is not None:
        cargs.extend([
            "-im_size",
            *map(str, params.get("image_size"))
        ])
    if params.get("image_xoffset") is not None:
        cargs.extend([
            "-im_xoff",
            str(params.get("image_xoffset"))
        ])
    if params.get("image_yoffset") is not None:
        cargs.extend([
            "-im_yoff",
            str(params.get("image_yoffset"))
        ])
    if params.get("graph_size") is not None:
        cargs.extend([
            "-gr_size",
            *map(str, params.get("graph_size"))
        ])
    if params.get("graph_xoffset") is not None:
        cargs.extend([
            "-gr_xoff",
            str(params.get("graph_xoffset"))
        ])
    if params.get("graph_yoffset") is not None:
        cargs.extend([
            "-gr_yoff",
            str(params.get("graph_yoffset"))
        ])
    return cargs


def gen_epi_review_py_outputs(
    params: GenEpiReviewPyParameters,
    execution: Execution,
) -> GenEpiReviewPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = GenEpiReviewPyOutputs(
        root=execution.output_file("."),
    )
    return ret


def gen_epi_review_py_execute(
    params: GenEpiReviewPyParameters,
    execution: Execution,
) -> GenEpiReviewPyOutputs:
    """
    Generate an AFNI processing script to review EPI data.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `GenEpiReviewPyOutputs`).
    """
    params = execution.params(params)
    cargs = gen_epi_review_py_cargs(params, execution)
    ret = gen_epi_review_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def gen_epi_review_py(
    datasets: list[str],
    script_name: str | None = None,
    windows: list[str] | None = None,
    verbosity: float | None = None,
    image_size: list[float] | None = None,
    image_xoffset: float | None = None,
    image_yoffset: float | None = None,
    graph_size: list[float] | None = None,
    graph_xoffset: float | None = None,
    graph_yoffset: float | None = None,
    runner: Runner | None = None,
) -> GenEpiReviewPyOutputs:
    """
    Generate an AFNI processing script to review EPI data.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        datasets: Specify input datasets for processing.
        script_name: Specify the name of the generated script.
        windows: Specify the image windows to open.
        verbosity: Specify a verbosity level.
        image_size: Set image dimensions, in pixels.
        image_xoffset: Set the X-offset for the image, in pixels.
        image_yoffset: Set the Y-offset for the image, in pixels.
        graph_size: Set graph dimensions, in pixels.
        graph_xoffset: Set the X-offset for the graph, in pixels.
        graph_yoffset: Set the Y-offset for the graph, in pixels.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `GenEpiReviewPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(GEN_EPI_REVIEW_PY_METADATA)
    params = gen_epi_review_py_params(
        datasets=datasets,
        script_name=script_name,
        windows=windows,
        verbosity=verbosity,
        image_size=image_size,
        image_xoffset=image_xoffset,
        image_yoffset=image_yoffset,
        graph_size=graph_size,
        graph_xoffset=graph_xoffset,
        graph_yoffset=graph_yoffset,
    )
    return gen_epi_review_py_execute(params, execution)


__all__ = [
    "GEN_EPI_REVIEW_PY_METADATA",
    "GenEpiReviewPyOutputs",
    "GenEpiReviewPyParameters",
    "gen_epi_review_py",
    "gen_epi_review_py_params",
]
