# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

GIFTI_TOOL_METADATA = Metadata(
    id="e21384bfaf8b8bcf833d65f05be55ac0e9f035a6.boutiques",
    name="gifti_tool",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


GiftiToolParameters = typing.TypedDict('GiftiToolParameters', {
    "__STYXTYPE__": typing.Literal["gifti_tool"],
    "infile": InputPathType,
    "new_numda": typing.NotRequired[float | None],
    "new_dtype": typing.NotRequired[str | None],
    "new_intent": typing.NotRequired[str | None],
    "new_ndim": typing.NotRequired[float | None],
    "new_dims": typing.NotRequired[list[float] | None],
    "write_gifti": str,
    "set_extern_filelist": typing.NotRequired[list[str] | None],
    "mod_add_data": bool,
    "verb": typing.NotRequired[float | None],
    "show_gifti": bool,
    "read_das": typing.NotRequired[list[float] | None],
    "mod_gim_atr": typing.NotRequired[list[str] | None],
    "mod_gim_meta": typing.NotRequired[list[str] | None],
    "mod_da_atr": typing.NotRequired[list[str] | None],
    "mod_da_meta": typing.NotRequired[list[str] | None],
    "mod_das": typing.NotRequired[list[float] | None],
    "new_dset": bool,
    "compare_gifti": bool,
    "compare_data": bool,
    "compare_verb": typing.NotRequired[float | None],
    "approx_gifti": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "gifti_tool": gifti_tool_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "gifti_tool": gifti_tool_outputs,
    }.get(t)


class GiftiToolOutputs(typing.NamedTuple):
    """
    Output object returned when calling `gifti_tool(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_gifti: OutputPathType
    """Output GIFTI file"""


def gifti_tool_params(
    infile: InputPathType,
    write_gifti: str,
    new_numda: float | None = None,
    new_dtype: str | None = None,
    new_intent: str | None = None,
    new_ndim: float | None = None,
    new_dims: list[float] | None = None,
    set_extern_filelist: list[str] | None = None,
    mod_add_data: bool = False,
    verb: float | None = None,
    show_gifti: bool = False,
    read_das: list[float] | None = None,
    mod_gim_atr: list[str] | None = None,
    mod_gim_meta: list[str] | None = None,
    mod_da_atr: list[str] | None = None,
    mod_da_meta: list[str] | None = None,
    mod_das: list[float] | None = None,
    new_dset: bool = False,
    compare_gifti: bool = False,
    compare_data: bool = False,
    compare_verb: float | None = None,
    approx_gifti: bool = False,
) -> GiftiToolParameters:
    """
    Build parameters.
    
    Args:
        infile: Specify one or more GIFTI datasets as input.
        write_gifti: Write out dataset as gifti image.
        new_numda: New dataset will have NUMDA DataArray elements.
        new_dtype: Set data type to TYPE.
        new_intent: DA elements will have intent INTENT.
        new_ndim: Set Dimensionality to NUMDIMS.
        new_dims: Set dims[] to these 6 values.
        set_extern_filelist: Store data in external files.
        mod_add_data: Add data to empty DataArray elements.
        verb: Set verbose level.
        show_gifti: Show final gifti image.
        read_das: Read DataArray list indices.
        mod_gim_atr: Set the GIFTI NAME=VALUE attribute pair at GIFTI level.
        mod_gim_meta: Add this pair to the GIFTI MetaData.
        mod_da_atr: Set the DataArray NAME=VALUE attribute pair.
        mod_da_meta: Set the DataArray NAME=VALUE pair in DA's MetaData.
        mod_das: Specify the set of DataArrays to modify.
        new_dset: Create a new GIFTI dataset.
        compare_gifti: Compare two GIFTI datasets.
        compare_data: Flag to request comparison of the data.
        compare_verb: Set the verbose level of comparisons.
        approx_gifti: Approximate comparison of GIFTI datasets.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "gifti_tool",
        "infile": infile,
        "write_gifti": write_gifti,
        "mod_add_data": mod_add_data,
        "show_gifti": show_gifti,
        "new_dset": new_dset,
        "compare_gifti": compare_gifti,
        "compare_data": compare_data,
        "approx_gifti": approx_gifti,
    }
    if new_numda is not None:
        params["new_numda"] = new_numda
    if new_dtype is not None:
        params["new_dtype"] = new_dtype
    if new_intent is not None:
        params["new_intent"] = new_intent
    if new_ndim is not None:
        params["new_ndim"] = new_ndim
    if new_dims is not None:
        params["new_dims"] = new_dims
    if set_extern_filelist is not None:
        params["set_extern_filelist"] = set_extern_filelist
    if verb is not None:
        params["verb"] = verb
    if read_das is not None:
        params["read_das"] = read_das
    if mod_gim_atr is not None:
        params["mod_gim_atr"] = mod_gim_atr
    if mod_gim_meta is not None:
        params["mod_gim_meta"] = mod_gim_meta
    if mod_da_atr is not None:
        params["mod_da_atr"] = mod_da_atr
    if mod_da_meta is not None:
        params["mod_da_meta"] = mod_da_meta
    if mod_das is not None:
        params["mod_das"] = mod_das
    if compare_verb is not None:
        params["compare_verb"] = compare_verb
    return params


def gifti_tool_cargs(
    params: GiftiToolParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("gifti_tool")
    cargs.extend([
        "-infile",
        execution.input_file(params.get("infile"))
    ])
    if params.get("new_numda") is not None:
        cargs.extend([
            "-new_numDA",
            str(params.get("new_numda"))
        ])
    if params.get("new_dtype") is not None:
        cargs.extend([
            "-new_dtype",
            params.get("new_dtype")
        ])
    if params.get("new_intent") is not None:
        cargs.extend([
            "-new_intent",
            params.get("new_intent")
        ])
    if params.get("new_ndim") is not None:
        cargs.extend([
            "-new_ndim",
            str(params.get("new_ndim"))
        ])
    if params.get("new_dims") is not None:
        cargs.extend([
            "-new_dims",
            *map(str, params.get("new_dims"))
        ])
    cargs.extend([
        "-write_gifti",
        params.get("write_gifti")
    ])
    if params.get("set_extern_filelist") is not None:
        cargs.extend([
            "-set_extern_filelist",
            *params.get("set_extern_filelist")
        ])
    if params.get("mod_add_data"):
        cargs.append("-mod_add_data")
    if params.get("verb") is not None:
        cargs.extend([
            "-verb",
            str(params.get("verb"))
        ])
    if params.get("show_gifti"):
        cargs.append("-show_gifti")
    if params.get("read_das") is not None:
        cargs.extend([
            "-read_DAs",
            *map(str, params.get("read_das"))
        ])
    if params.get("mod_gim_atr") is not None:
        cargs.extend([
            "-mod_gim_atr",
            *params.get("mod_gim_atr")
        ])
    if params.get("mod_gim_meta") is not None:
        cargs.extend([
            "-mod_gim_meta",
            *params.get("mod_gim_meta")
        ])
    if params.get("mod_da_atr") is not None:
        cargs.extend([
            "-mod_DA_atr",
            *params.get("mod_da_atr")
        ])
    if params.get("mod_da_meta") is not None:
        cargs.extend([
            "-mod_DA_meta",
            *params.get("mod_da_meta")
        ])
    if params.get("mod_das") is not None:
        cargs.extend([
            "-mod_DAs",
            *map(str, params.get("mod_das"))
        ])
    if params.get("new_dset"):
        cargs.append("-new_dset")
    if params.get("compare_gifti"):
        cargs.append("-compare_gifti")
    if params.get("compare_data"):
        cargs.append("-compare_data")
    if params.get("compare_verb") is not None:
        cargs.extend([
            "-compare_verb",
            str(params.get("compare_verb"))
        ])
    if params.get("approx_gifti"):
        cargs.append("-approx_gifti")
    return cargs


def gifti_tool_outputs(
    params: GiftiToolParameters,
    execution: Execution,
) -> GiftiToolOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = GiftiToolOutputs(
        root=execution.output_file("."),
        output_gifti=execution.output_file(params.get("write_gifti")),
    )
    return ret


def gifti_tool_execute(
    params: GiftiToolParameters,
    execution: Execution,
) -> GiftiToolOutputs:
    """
    Tool for creating, displaying, modifying, or comparing GIFTI datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `GiftiToolOutputs`).
    """
    params = execution.params(params)
    cargs = gifti_tool_cargs(params, execution)
    ret = gifti_tool_outputs(params, execution)
    execution.run(cargs)
    return ret


def gifti_tool(
    infile: InputPathType,
    write_gifti: str,
    new_numda: float | None = None,
    new_dtype: str | None = None,
    new_intent: str | None = None,
    new_ndim: float | None = None,
    new_dims: list[float] | None = None,
    set_extern_filelist: list[str] | None = None,
    mod_add_data: bool = False,
    verb: float | None = None,
    show_gifti: bool = False,
    read_das: list[float] | None = None,
    mod_gim_atr: list[str] | None = None,
    mod_gim_meta: list[str] | None = None,
    mod_da_atr: list[str] | None = None,
    mod_da_meta: list[str] | None = None,
    mod_das: list[float] | None = None,
    new_dset: bool = False,
    compare_gifti: bool = False,
    compare_data: bool = False,
    compare_verb: float | None = None,
    approx_gifti: bool = False,
    runner: Runner | None = None,
) -> GiftiToolOutputs:
    """
    Tool for creating, displaying, modifying, or comparing GIFTI datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infile: Specify one or more GIFTI datasets as input.
        write_gifti: Write out dataset as gifti image.
        new_numda: New dataset will have NUMDA DataArray elements.
        new_dtype: Set data type to TYPE.
        new_intent: DA elements will have intent INTENT.
        new_ndim: Set Dimensionality to NUMDIMS.
        new_dims: Set dims[] to these 6 values.
        set_extern_filelist: Store data in external files.
        mod_add_data: Add data to empty DataArray elements.
        verb: Set verbose level.
        show_gifti: Show final gifti image.
        read_das: Read DataArray list indices.
        mod_gim_atr: Set the GIFTI NAME=VALUE attribute pair at GIFTI level.
        mod_gim_meta: Add this pair to the GIFTI MetaData.
        mod_da_atr: Set the DataArray NAME=VALUE attribute pair.
        mod_da_meta: Set the DataArray NAME=VALUE pair in DA's MetaData.
        mod_das: Specify the set of DataArrays to modify.
        new_dset: Create a new GIFTI dataset.
        compare_gifti: Compare two GIFTI datasets.
        compare_data: Flag to request comparison of the data.
        compare_verb: Set the verbose level of comparisons.
        approx_gifti: Approximate comparison of GIFTI datasets.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `GiftiToolOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(GIFTI_TOOL_METADATA)
    params = gifti_tool_params(
        infile=infile,
        new_numda=new_numda,
        new_dtype=new_dtype,
        new_intent=new_intent,
        new_ndim=new_ndim,
        new_dims=new_dims,
        write_gifti=write_gifti,
        set_extern_filelist=set_extern_filelist,
        mod_add_data=mod_add_data,
        verb=verb,
        show_gifti=show_gifti,
        read_das=read_das,
        mod_gim_atr=mod_gim_atr,
        mod_gim_meta=mod_gim_meta,
        mod_da_atr=mod_da_atr,
        mod_da_meta=mod_da_meta,
        mod_das=mod_das,
        new_dset=new_dset,
        compare_gifti=compare_gifti,
        compare_data=compare_data,
        compare_verb=compare_verb,
        approx_gifti=approx_gifti,
    )
    return gifti_tool_execute(params, execution)


__all__ = [
    "GIFTI_TOOL_METADATA",
    "GiftiToolOutputs",
    "GiftiToolParameters",
    "gifti_tool",
    "gifti_tool_params",
]
