# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

IM2NIML_METADATA = Metadata(
    id="2a0436ee9182dd43de4cbf9c42cb1f57c2e1fb60.boutiques",
    name="im2niml",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


Im2nimlParameters = typing.TypedDict('Im2nimlParameters', {
    "__STYXTYPE__": typing.Literal["im2niml"],
    "input_files": list[InputPathType],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "im2niml": im2niml_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "im2niml": im2niml_outputs,
    }.get(t)


class Im2nimlOutputs(typing.NamedTuple):
    """
    Output object returned when calling `im2niml(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    niml_output: OutputPathType
    """NIML element"""


def im2niml_params(
    input_files: list[InputPathType],
) -> Im2nimlParameters:
    """
    Build parameters.
    
    Args:
        input_files: Input image file(s) (e.g. image.jpg).
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "im2niml",
        "input_files": input_files,
    }
    return params


def im2niml_cargs(
    params: Im2nimlParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("im2niml")
    cargs.extend([execution.input_file(f) for f in params.get("input_files")])
    return cargs


def im2niml_outputs(
    params: Im2nimlParameters,
    execution: Execution,
) -> Im2nimlOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = Im2nimlOutputs(
        root=execution.output_file("."),
        niml_output=execution.output_file("stdout"),
    )
    return ret


def im2niml_execute(
    params: Im2nimlParameters,
    execution: Execution,
) -> Im2nimlOutputs:
    """
    Converts the input image(s) to a text-based NIML element and writes the result
    to stdout.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `Im2nimlOutputs`).
    """
    params = execution.params(params)
    cargs = im2niml_cargs(params, execution)
    ret = im2niml_outputs(params, execution)
    execution.run(cargs)
    return ret


def im2niml(
    input_files: list[InputPathType],
    runner: Runner | None = None,
) -> Im2nimlOutputs:
    """
    Converts the input image(s) to a text-based NIML element and writes the result
    to stdout.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_files: Input image file(s) (e.g. image.jpg).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `Im2nimlOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(IM2NIML_METADATA)
    params = im2niml_params(
        input_files=input_files,
    )
    return im2niml_execute(params, execution)


__all__ = [
    "IM2NIML_METADATA",
    "Im2nimlOutputs",
    "Im2nimlParameters",
    "im2niml",
    "im2niml_params",
]
