# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

IMCALC_METADATA = Metadata(
    id="0f1c33e4f0b22c6e5934a76021bc78779977e799.boutiques",
    name="imcalc",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


ImcalcParameters = typing.TypedDict('ImcalcParameters', {
    "__STYXTYPE__": typing.Literal["imcalc"],
    "datum_type": typing.NotRequired[str | None],
    "image_inputs": typing.NotRequired[list[InputPathType] | None],
    "expression": str,
    "output_name": typing.NotRequired[str | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "imcalc": imcalc_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "imcalc": imcalc_outputs,
    }.get(t)


class ImcalcOutputs(typing.NamedTuple):
    """
    Output object returned when calling `imcalc(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_image: OutputPathType | None
    """Output image file produced after applying the expression to input
    images"""


def imcalc_params(
    expression: str,
    datum_type: str | None = None,
    image_inputs: list[InputPathType] | None = None,
    output_name: str | None = None,
) -> ImcalcParameters:
    """
    Build parameters.
    
    Args:
        expression: Apply the expression within quotes to the input images, one\
            voxel at a time, to produce the output image. (e.g., "sqrt(a*b)" to\
            compute the geometric mean).
        datum_type: Coerce the output data to be stored as the given type:\
            byte, short, or float. Default is the datum of the first input image on\
            the command line.
        image_inputs: Read image 'dname' and call the voxel values 'a' in the\
            expression. 'a' may be any letter from 'a' to 'z'. If some letter name\
            is used in the expression but not present in one of the image options\
            here, then that variable is set to 0.
        output_name: Use 'name' for the output image filename. Default is\
            'imcalc.out'.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "imcalc",
        "expression": expression,
    }
    if datum_type is not None:
        params["datum_type"] = datum_type
    if image_inputs is not None:
        params["image_inputs"] = image_inputs
    if output_name is not None:
        params["output_name"] = output_name
    return params


def imcalc_cargs(
    params: ImcalcParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("imcalc")
    if params.get("datum_type") is not None:
        cargs.extend([
            "-datum type",
            params.get("datum_type")
        ])
    if params.get("image_inputs") is not None:
        cargs.extend([
            "-a",
            *[execution.input_file(f) for f in params.get("image_inputs")]
        ])
    cargs.extend([
        "-expr",
        params.get("expression")
    ])
    if params.get("output_name") is not None:
        cargs.extend([
            "-output",
            params.get("output_name")
        ])
    return cargs


def imcalc_outputs(
    params: ImcalcParameters,
    execution: Execution,
) -> ImcalcOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = ImcalcOutputs(
        root=execution.output_file("."),
        output_image=execution.output_file(params.get("output_name")) if (params.get("output_name") is not None) else None,
    )
    return ret


def imcalc_execute(
    params: ImcalcParameters,
    execution: Execution,
) -> ImcalcOutputs:
    """
    Tool for arithmetic operations on 2D images, pixel-by-pixel.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `ImcalcOutputs`).
    """
    params = execution.params(params)
    cargs = imcalc_cargs(params, execution)
    ret = imcalc_outputs(params, execution)
    execution.run(cargs)
    return ret


def imcalc(
    expression: str,
    datum_type: str | None = None,
    image_inputs: list[InputPathType] | None = None,
    output_name: str | None = None,
    runner: Runner | None = None,
) -> ImcalcOutputs:
    """
    Tool for arithmetic operations on 2D images, pixel-by-pixel.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        expression: Apply the expression within quotes to the input images, one\
            voxel at a time, to produce the output image. (e.g., "sqrt(a*b)" to\
            compute the geometric mean).
        datum_type: Coerce the output data to be stored as the given type:\
            byte, short, or float. Default is the datum of the first input image on\
            the command line.
        image_inputs: Read image 'dname' and call the voxel values 'a' in the\
            expression. 'a' may be any letter from 'a' to 'z'. If some letter name\
            is used in the expression but not present in one of the image options\
            here, then that variable is set to 0.
        output_name: Use 'name' for the output image filename. Default is\
            'imcalc.out'.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ImcalcOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(IMCALC_METADATA)
    params = imcalc_params(
        datum_type=datum_type,
        image_inputs=image_inputs,
        expression=expression,
        output_name=output_name,
    )
    return imcalc_execute(params, execution)


__all__ = [
    "IMCALC_METADATA",
    "ImcalcOutputs",
    "ImcalcParameters",
    "imcalc",
    "imcalc_params",
]
