# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

IMDUMP_METADATA = Metadata(
    id="459004bda38f190bf54b7b93ee1f69c9a1440cdf.boutiques",
    name="imdump",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


ImdumpParameters = typing.TypedDict('ImdumpParameters', {
    "__STYXTYPE__": typing.Literal["imdump"],
    "input_image": InputPathType,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "imdump": imdump_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "imdump": imdump_outputs,
    }.get(t)


class ImdumpOutputs(typing.NamedTuple):
    """
    Output object returned when calling `imdump(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    stdout: OutputPathType
    """Nonzero pixels in the format: x-index y-index value, one pixel per
    line."""


def imdump_params(
    input_image: InputPathType,
) -> ImdumpParameters:
    """
    Build parameters.
    
    Args:
        input_image: Input image file to be processed.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "imdump",
        "input_image": input_image,
    }
    return params


def imdump_cargs(
    params: ImdumpParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("imdump")
    cargs.append(execution.input_file(params.get("input_image")))
    return cargs


def imdump_outputs(
    params: ImdumpParameters,
    execution: Execution,
) -> ImdumpOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = ImdumpOutputs(
        root=execution.output_file("."),
        stdout=execution.output_file("stdout.txt"),
    )
    return ret


def imdump_execute(
    params: ImdumpParameters,
    execution: Execution,
) -> ImdumpOutputs:
    """
    Prints out nonzero pixels in an image.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `ImdumpOutputs`).
    """
    params = execution.params(params)
    cargs = imdump_cargs(params, execution)
    ret = imdump_outputs(params, execution)
    execution.run(cargs)
    return ret


def imdump(
    input_image: InputPathType,
    runner: Runner | None = None,
) -> ImdumpOutputs:
    """
    Prints out nonzero pixels in an image.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_image: Input image file to be processed.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ImdumpOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(IMDUMP_METADATA)
    params = imdump_params(
        input_image=input_image,
    )
    return imdump_execute(params, execution)


__all__ = [
    "IMDUMP_METADATA",
    "ImdumpOutputs",
    "ImdumpParameters",
    "imdump",
    "imdump_params",
]
