# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

IMROTATE_METADATA = Metadata(
    id="b1deba5a72945c551d4389c3320d0152b83b453a.boutiques",
    name="imrotate",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


ImrotateParameters = typing.TypedDict('ImrotateParameters', {
    "__STYXTYPE__": typing.Literal["imrotate"],
    "linear_interpolation": bool,
    "fourier_interpolation": bool,
    "dx": float,
    "dy": float,
    "phi": float,
    "input_image": InputPathType,
    "output_image": str,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "imrotate": imrotate_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "imrotate": imrotate_outputs,
    }.get(t)


class ImrotateOutputs(typing.NamedTuple):
    """
    Output object returned when calling `imrotate(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_image_file: OutputPathType
    """Path to the output image file"""


def imrotate_params(
    dx: float,
    dy: float,
    phi: float,
    input_image: InputPathType,
    output_image: str,
    linear_interpolation: bool = False,
    fourier_interpolation: bool = False,
) -> ImrotateParameters:
    """
    Build parameters.
    
    Args:
        dx: Pixels to shift rightwards (can be non-integer).
        dy: Pixels to shift downwards (can be non-integer).
        phi: Degrees to rotate clockwise.
        input_image: Input image file.
        output_image: Output image file.
        linear_interpolation: Use bilinear interpolation (default is bicubic).
        fourier_interpolation: Use Fourier interpolation.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "imrotate",
        "linear_interpolation": linear_interpolation,
        "fourier_interpolation": fourier_interpolation,
        "dx": dx,
        "dy": dy,
        "phi": phi,
        "input_image": input_image,
        "output_image": output_image,
    }
    return params


def imrotate_cargs(
    params: ImrotateParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("imrotate")
    if params.get("linear_interpolation"):
        cargs.append("-linear")
    if params.get("fourier_interpolation"):
        cargs.append("-Fourier")
    cargs.append(str(params.get("dx")))
    cargs.append(str(params.get("dy")))
    cargs.append(str(params.get("phi")))
    cargs.append(execution.input_file(params.get("input_image")))
    cargs.append(params.get("output_image"))
    return cargs


def imrotate_outputs(
    params: ImrotateParameters,
    execution: Execution,
) -> ImrotateOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = ImrotateOutputs(
        root=execution.output_file("."),
        output_image_file=execution.output_file(params.get("output_image")),
    )
    return ret


def imrotate_execute(
    params: ImrotateParameters,
    execution: Execution,
) -> ImrotateOutputs:
    """
    Shifts and rotates an image.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `ImrotateOutputs`).
    """
    params = execution.params(params)
    cargs = imrotate_cargs(params, execution)
    ret = imrotate_outputs(params, execution)
    execution.run(cargs)
    return ret


def imrotate(
    dx: float,
    dy: float,
    phi: float,
    input_image: InputPathType,
    output_image: str,
    linear_interpolation: bool = False,
    fourier_interpolation: bool = False,
    runner: Runner | None = None,
) -> ImrotateOutputs:
    """
    Shifts and rotates an image.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dx: Pixels to shift rightwards (can be non-integer).
        dy: Pixels to shift downwards (can be non-integer).
        phi: Degrees to rotate clockwise.
        input_image: Input image file.
        output_image: Output image file.
        linear_interpolation: Use bilinear interpolation (default is bicubic).
        fourier_interpolation: Use Fourier interpolation.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ImrotateOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(IMROTATE_METADATA)
    params = imrotate_params(
        linear_interpolation=linear_interpolation,
        fourier_interpolation=fourier_interpolation,
        dx=dx,
        dy=dy,
        phi=phi,
        input_image=input_image,
        output_image=output_image,
    )
    return imrotate_execute(params, execution)


__all__ = [
    "IMROTATE_METADATA",
    "ImrotateOutputs",
    "ImrotateParameters",
    "imrotate",
    "imrotate_params",
]
