# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

MAKE_PQ_SCRIPT_PY_METADATA = Metadata(
    id="92e2566b52307fc16bead6a8f031cd5f8c8b9b62.boutiques",
    name="make_pq_script.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


MakePqScriptPyParameters = typing.TypedDict('MakePqScriptPyParameters', {
    "__STYXTYPE__": typing.Literal["make_pq_script.py"],
    "dataset": InputPathType,
    "brick_index": float,
    "mask": InputPathType,
    "out_script": str,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "make_pq_script.py": make_pq_script_py_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "make_pq_script.py": make_pq_script_py_outputs,
    }.get(t)


class MakePqScriptPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `make_pq_script_py(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    script: OutputPathType
    """Generated output script"""


def make_pq_script_py_params(
    dataset: InputPathType,
    brick_index: float,
    mask: InputPathType,
    out_script: str,
) -> MakePqScriptPyParameters:
    """
    Build parameters.
    
    Args:
        dataset: Input dataset (no sub-brick selectors).
        brick_index: Volume sub-brick for specific t-stat.
        mask: Mask volume dataset.
        out_script: Name for output script to write.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "make_pq_script.py",
        "dataset": dataset,
        "brick_index": brick_index,
        "mask": mask,
        "out_script": out_script,
    }
    return params


def make_pq_script_py_cargs(
    params: MakePqScriptPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("make_pq_script.py")
    cargs.append(execution.input_file(params.get("dataset")))
    cargs.append(str(params.get("brick_index")))
    cargs.append(execution.input_file(params.get("mask")))
    cargs.append(params.get("out_script"))
    return cargs


def make_pq_script_py_outputs(
    params: MakePqScriptPyParameters,
    execution: Execution,
) -> MakePqScriptPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = MakePqScriptPyOutputs(
        root=execution.output_file("."),
        script=execution.output_file(params.get("out_script")),
    )
    return ret


def make_pq_script_py_execute(
    params: MakePqScriptPyParameters,
    execution: Execution,
) -> MakePqScriptPyOutputs:
    """
    Creates a script to compute p-value and q-value curves.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `MakePqScriptPyOutputs`).
    """
    params = execution.params(params)
    cargs = make_pq_script_py_cargs(params, execution)
    ret = make_pq_script_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def make_pq_script_py(
    dataset: InputPathType,
    brick_index: float,
    mask: InputPathType,
    out_script: str,
    runner: Runner | None = None,
) -> MakePqScriptPyOutputs:
    """
    Creates a script to compute p-value and q-value curves.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset: Input dataset (no sub-brick selectors).
        brick_index: Volume sub-brick for specific t-stat.
        mask: Mask volume dataset.
        out_script: Name for output script to write.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `MakePqScriptPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(MAKE_PQ_SCRIPT_PY_METADATA)
    params = make_pq_script_py_params(
        dataset=dataset,
        brick_index=brick_index,
        mask=mask,
        out_script=out_script,
    )
    return make_pq_script_py_execute(params, execution)


__all__ = [
    "MAKE_PQ_SCRIPT_PY_METADATA",
    "MakePqScriptPyOutputs",
    "MakePqScriptPyParameters",
    "make_pq_script_py",
    "make_pq_script_py_params",
]
