# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

NIFTI_TOOL_METADATA = Metadata(
    id="9789f342be7ffa2a9b170901d7f6938dde505424.boutiques",
    name="nifti_tool",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


NiftiToolParameters = typing.TypedDict('NiftiToolParameters', {
    "__STYXTYPE__": typing.Literal["nifti_tool"],
    "action": str,
    "input_files": typing.NotRequired[list[InputPathType] | None],
    "field": typing.NotRequired[str | None],
    "mod_field": typing.NotRequired[str | None],
    "prefix": typing.NotRequired[str | None],
    "debug": typing.NotRequired[float | None],
    "overwrite": bool,
    "convert2dtype": typing.NotRequired[str | None],
    "convert_fail_choice": typing.NotRequired[str | None],
    "convert_verify": bool,
    "add_comment_ext": typing.NotRequired[str | None],
    "rm_ext": typing.NotRequired[str | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "nifti_tool": nifti_tool_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "nifti_tool": nifti_tool_outputs,
    }.get(t)


class NiftiToolOutputs(typing.NamedTuple):
    """
    Output object returned when calling `nifti_tool(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType | None
    """The nifti file generated as output."""


def nifti_tool_params(
    action: str,
    input_files: list[InputPathType] | None = None,
    field: str | None = None,
    mod_field: str | None = None,
    prefix: str | None = None,
    debug: float | None = None,
    overwrite: bool = False,
    convert2dtype: str | None = None,
    convert_fail_choice: str | None = None,
    convert_verify: bool = False,
    add_comment_ext: str | None = None,
    rm_ext: str | None = None,
) -> NiftiToolParameters:
    """
    Build parameters.
    
    Args:
        action: Action type that defines what nifti_tool will do.
        input_files: One or more input nifti files.
        field: Field name to display, modify, or compare.
        mod_field: Field name and new value to modify.
        prefix: Prefix for the output file.
        debug: Debugging level (0-3).
        overwrite: Overwrite input files with modifications.
        convert2dtype: Convert data to a new datatype.
        convert_fail_choice: Action on conversion failure (ignore, warn, fail).
        convert_verify: Verify datatype conversion exactness.
        add_comment_ext: Add COMMENT-type extension to dataset.
        rm_ext: Remove extension by index or ALL.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "nifti_tool",
        "action": action,
        "overwrite": overwrite,
        "convert_verify": convert_verify,
    }
    if input_files is not None:
        params["input_files"] = input_files
    if field is not None:
        params["field"] = field
    if mod_field is not None:
        params["mod_field"] = mod_field
    if prefix is not None:
        params["prefix"] = prefix
    if debug is not None:
        params["debug"] = debug
    if convert2dtype is not None:
        params["convert2dtype"] = convert2dtype
    if convert_fail_choice is not None:
        params["convert_fail_choice"] = convert_fail_choice
    if add_comment_ext is not None:
        params["add_comment_ext"] = add_comment_ext
    if rm_ext is not None:
        params["rm_ext"] = rm_ext
    return params


def nifti_tool_cargs(
    params: NiftiToolParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("nifti_tool")
    cargs.append(params.get("action"))
    if params.get("input_files") is not None:
        cargs.extend([
            "-infiles",
            *[execution.input_file(f) for f in params.get("input_files")]
        ])
    if params.get("field") is not None:
        cargs.extend([
            "-field",
            params.get("field")
        ])
    if params.get("mod_field") is not None:
        cargs.extend([
            "-mod_field",
            params.get("mod_field")
        ])
    if params.get("prefix") is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix")
        ])
    if params.get("debug") is not None:
        cargs.extend([
            "-debug",
            str(params.get("debug"))
        ])
    if params.get("overwrite"):
        cargs.append("-overwrite")
    if params.get("convert2dtype") is not None:
        cargs.extend([
            "-convert2dtype",
            params.get("convert2dtype")
        ])
    if params.get("convert_fail_choice") is not None:
        cargs.extend([
            "-convert_fail_choice",
            params.get("convert_fail_choice")
        ])
    if params.get("convert_verify"):
        cargs.append("-convert_verify")
    if params.get("add_comment_ext") is not None:
        cargs.extend([
            "-add_comment_ext",
            params.get("add_comment_ext")
        ])
    if params.get("rm_ext") is not None:
        cargs.extend([
            "-rm_ext",
            params.get("rm_ext")
        ])
    return cargs


def nifti_tool_outputs(
    params: NiftiToolParameters,
    execution: Execution,
) -> NiftiToolOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = NiftiToolOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("prefix") + ".nii") if (params.get("prefix") is not None) else None,
    )
    return ret


def nifti_tool_execute(
    params: NiftiToolParameters,
    execution: Execution,
) -> NiftiToolOutputs:
    """
    Display, modify, or compare nifti headers.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `NiftiToolOutputs`).
    """
    params = execution.params(params)
    cargs = nifti_tool_cargs(params, execution)
    ret = nifti_tool_outputs(params, execution)
    execution.run(cargs)
    return ret


def nifti_tool(
    action: str,
    input_files: list[InputPathType] | None = None,
    field: str | None = None,
    mod_field: str | None = None,
    prefix: str | None = None,
    debug: float | None = None,
    overwrite: bool = False,
    convert2dtype: str | None = None,
    convert_fail_choice: str | None = None,
    convert_verify: bool = False,
    add_comment_ext: str | None = None,
    rm_ext: str | None = None,
    runner: Runner | None = None,
) -> NiftiToolOutputs:
    """
    Display, modify, or compare nifti headers.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        action: Action type that defines what nifti_tool will do.
        input_files: One or more input nifti files.
        field: Field name to display, modify, or compare.
        mod_field: Field name and new value to modify.
        prefix: Prefix for the output file.
        debug: Debugging level (0-3).
        overwrite: Overwrite input files with modifications.
        convert2dtype: Convert data to a new datatype.
        convert_fail_choice: Action on conversion failure (ignore, warn, fail).
        convert_verify: Verify datatype conversion exactness.
        add_comment_ext: Add COMMENT-type extension to dataset.
        rm_ext: Remove extension by index or ALL.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `NiftiToolOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(NIFTI_TOOL_METADATA)
    params = nifti_tool_params(
        action=action,
        input_files=input_files,
        field=field,
        mod_field=mod_field,
        prefix=prefix,
        debug=debug,
        overwrite=overwrite,
        convert2dtype=convert2dtype,
        convert_fail_choice=convert_fail_choice,
        convert_verify=convert_verify,
        add_comment_ext=add_comment_ext,
        rm_ext=rm_ext,
    )
    return nifti_tool_execute(params, execution)


__all__ = [
    "NIFTI_TOOL_METADATA",
    "NiftiToolOutputs",
    "NiftiToolParameters",
    "nifti_tool",
    "nifti_tool_params",
]
