# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

NIML_FEEDME_METADATA = Metadata(
    id="045d80f46fa43e5a4d550a5bf8daeb0c433c5c4f.boutiques",
    name="niml_feedme",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


NimlFeedmeParameters = typing.TypedDict('NimlFeedmeParameters', {
    "__STYXTYPE__": typing.Literal["niml_feedme"],
    "host": typing.NotRequired[str | None],
    "interval": typing.NotRequired[float | None],
    "verbose": bool,
    "accum": bool,
    "target_dataset": typing.NotRequired[str | None],
    "drive_cmds": typing.NotRequired[list[str] | None],
    "dataset": InputPathType,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "niml_feedme": niml_feedme_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class NimlFeedmeOutputs(typing.NamedTuple):
    """
    Output object returned when calling `niml_feedme(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def niml_feedme_params(
    dataset: InputPathType,
    host: str | None = None,
    interval: float | None = None,
    verbose: bool = False,
    accum: bool = False,
    target_dataset: str | None = None,
    drive_cmds: list[str] | None = None,
) -> NimlFeedmeParameters:
    """
    Build parameters.
    
    Args:
        dataset: Input dataset to be sent to AFNI.
        host: Send data, via TCP/IP, to AFNI running on the computer system\
            'sname'. By default, uses the current system (localhost), if you don't\
            use this option.
        interval: Tries to maintain an inter-transmit interval of 'ms'\
            milliseconds. The default is 1000 msec per volume.
        verbose: Be (very) talkative about actions.
        accum: Send sub-bricks so that they accumulate in AFNI. The default is\
            to create only a 1 volume dataset inside AFNI, and each sub-brick just\
            replaces that one volume when it is received.
        target_dataset: Change the dataset name transmitted to AFNI from\
            'niml_feedme' to 'nam'.
        drive_cmds: Send 'cmd' as a DRIVE_AFNI command. If cmd contains blanks,\
            it must be in 'quotes'. Multiple -drive options may be used. These\
            commands will be sent to AFNI just after the first volume is\
            transmitted. See file README.driver for a list of commands.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "niml_feedme",
        "verbose": verbose,
        "accum": accum,
        "dataset": dataset,
    }
    if host is not None:
        params["host"] = host
    if interval is not None:
        params["interval"] = interval
    if target_dataset is not None:
        params["target_dataset"] = target_dataset
    if drive_cmds is not None:
        params["drive_cmds"] = drive_cmds
    return params


def niml_feedme_cargs(
    params: NimlFeedmeParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("niml_feedme")
    if params.get("host") is not None:
        cargs.extend([
            "-host",
            params.get("host")
        ])
    if params.get("interval") is not None:
        cargs.extend([
            "-dt",
            str(params.get("interval"))
        ])
    if params.get("verbose"):
        cargs.append("-verb")
    if params.get("accum"):
        cargs.append("-accum")
    if params.get("target_dataset") is not None:
        cargs.extend([
            "-target",
            params.get("target_dataset")
        ])
    if params.get("drive_cmds") is not None:
        cargs.extend([
            "-drive",
            *params.get("drive_cmds")
        ])
    cargs.append(execution.input_file(params.get("dataset")))
    return cargs


def niml_feedme_outputs(
    params: NimlFeedmeParameters,
    execution: Execution,
) -> NimlFeedmeOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = NimlFeedmeOutputs(
        root=execution.output_file("."),
    )
    return ret


def niml_feedme_execute(
    params: NimlFeedmeParameters,
    execution: Execution,
) -> NimlFeedmeOutputs:
    """
    Sends volumes from the dataset to AFNI via the NIML socket interface.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `NimlFeedmeOutputs`).
    """
    params = execution.params(params)
    cargs = niml_feedme_cargs(params, execution)
    ret = niml_feedme_outputs(params, execution)
    execution.run(cargs)
    return ret


def niml_feedme(
    dataset: InputPathType,
    host: str | None = None,
    interval: float | None = None,
    verbose: bool = False,
    accum: bool = False,
    target_dataset: str | None = None,
    drive_cmds: list[str] | None = None,
    runner: Runner | None = None,
) -> NimlFeedmeOutputs:
    """
    Sends volumes from the dataset to AFNI via the NIML socket interface.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset: Input dataset to be sent to AFNI.
        host: Send data, via TCP/IP, to AFNI running on the computer system\
            'sname'. By default, uses the current system (localhost), if you don't\
            use this option.
        interval: Tries to maintain an inter-transmit interval of 'ms'\
            milliseconds. The default is 1000 msec per volume.
        verbose: Be (very) talkative about actions.
        accum: Send sub-bricks so that they accumulate in AFNI. The default is\
            to create only a 1 volume dataset inside AFNI, and each sub-brick just\
            replaces that one volume when it is received.
        target_dataset: Change the dataset name transmitted to AFNI from\
            'niml_feedme' to 'nam'.
        drive_cmds: Send 'cmd' as a DRIVE_AFNI command. If cmd contains blanks,\
            it must be in 'quotes'. Multiple -drive options may be used. These\
            commands will be sent to AFNI just after the first volume is\
            transmitted. See file README.driver for a list of commands.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `NimlFeedmeOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(NIML_FEEDME_METADATA)
    params = niml_feedme_params(
        host=host,
        interval=interval,
        verbose=verbose,
        accum=accum,
        target_dataset=target_dataset,
        drive_cmds=drive_cmds,
        dataset=dataset,
    )
    return niml_feedme_execute(params, execution)


__all__ = [
    "NIML_FEEDME_METADATA",
    "NimlFeedmeOutputs",
    "NimlFeedmeParameters",
    "niml_feedme",
    "niml_feedme_params",
]
