# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

NSIZE_METADATA = Metadata(
    id="a9d2ae05ed0705b6b163c901233146b3b789bc31.boutiques",
    name="nsize",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


NsizeParameters = typing.TypedDict('NsizeParameters', {
    "__STYXTYPE__": typing.Literal["nsize"],
    "image_in": InputPathType,
    "image_out": str,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "nsize": nsize_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "nsize": nsize_outputs,
    }.get(t)


class NsizeOutputs(typing.NamedTuple):
    """
    Output object returned when calling `nsize(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    image_out_file: OutputPathType
    """Zero padded output image file"""


def nsize_params(
    image_in: InputPathType,
    image_out: str,
) -> NsizeParameters:
    """
    Build parameters.
    
    Args:
        image_in: Input image file.
        image_out: Output padded image file.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "nsize",
        "image_in": image_in,
        "image_out": image_out,
    }
    return params


def nsize_cargs(
    params: NsizeParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("nsize")
    cargs.append(execution.input_file(params.get("image_in")))
    cargs.append(params.get("image_out"))
    return cargs


def nsize_outputs(
    params: NsizeParameters,
    execution: Execution,
) -> NsizeOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = NsizeOutputs(
        root=execution.output_file("."),
        image_out_file=execution.output_file(params.get("image_out")),
    )
    return ret


def nsize_execute(
    params: NsizeParameters,
    execution: Execution,
) -> NsizeOutputs:
    """
    Zero pads an input image to the nearest larger NxN dimensions.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `NsizeOutputs`).
    """
    params = execution.params(params)
    cargs = nsize_cargs(params, execution)
    ret = nsize_outputs(params, execution)
    execution.run(cargs)
    return ret


def nsize(
    image_in: InputPathType,
    image_out: str,
    runner: Runner | None = None,
) -> NsizeOutputs:
    """
    Zero pads an input image to the nearest larger NxN dimensions.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        image_in: Input image file.
        image_out: Output padded image file.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `NsizeOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(NSIZE_METADATA)
    params = nsize_params(
        image_in=image_in,
        image_out=image_out,
    )
    return nsize_execute(params, execution)


__all__ = [
    "NSIZE_METADATA",
    "NsizeOutputs",
    "NsizeParameters",
    "nsize",
    "nsize_params",
]
