# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

P2DSETSTAT_METADATA = Metadata(
    id="bf97782e51f33e92fa4f622b20ca100db34f1437.boutiques",
    name="p2dsetstat",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


P2dsetstatParameters = typing.TypedDict('P2dsetstatParameters', {
    "__STYXTYPE__": typing.Literal["p2dsetstat"],
    "dataset": str,
    "pvalue": float,
    "bisided": bool,
    "twosided": bool,
    "onesided": bool,
    "quiet": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "p2dsetstat": p2dsetstat_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "p2dsetstat": p2dsetstat_outputs,
    }.get(t)


class P2dsetstatOutputs(typing.NamedTuple):
    """
    Output object returned when calling `p2dsetstat(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    stat_value: OutputPathType
    """The converted statistic value."""


def p2dsetstat_params(
    dataset: str,
    pvalue: float,
    bisided: bool = False,
    twosided: bool = False,
    onesided: bool = False,
    quiet: bool = False,
) -> P2dsetstatParameters:
    """
    Build parameters.
    
    Args:
        dataset: Specify a dataset DDD and, if it has multiple sub-bricks, the\
            [i]th subbrick with the statistic of interest MUST be selected\
            explicitly; note the use of quotation marks around the brick selector\
            (because of the square-brackets). 'i' can be either a number or a\
            string label selector.
        pvalue: Input p-value P, which MUST be in the interval [0,1].
        bisided: Two-sided test.
        twosided: Two-sided test.
        onesided: One-sided test.
        quiet: Output only the final statistic value.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "p2dsetstat",
        "dataset": dataset,
        "pvalue": pvalue,
        "bisided": bisided,
        "twosided": twosided,
        "onesided": onesided,
        "quiet": quiet,
    }
    return params


def p2dsetstat_cargs(
    params: P2dsetstatParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("p2dsetstat")
    cargs.extend([
        "-inset",
        params.get("dataset")
    ])
    cargs.extend([
        "-pval",
        str(params.get("pvalue"))
    ])
    if params.get("bisided"):
        cargs.append("-bisided")
    if params.get("twosided"):
        cargs.append("-2sided")
    if params.get("onesided"):
        cargs.append("-1sided")
    if params.get("quiet"):
        cargs.append("-quiet")
    return cargs


def p2dsetstat_outputs(
    params: P2dsetstatParameters,
    execution: Execution,
) -> P2dsetstatOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = P2dsetstatOutputs(
        root=execution.output_file("."),
        stat_value=execution.output_file("stdout"),
    )
    return ret


def p2dsetstat_execute(
    params: P2dsetstatParameters,
    execution: Execution,
) -> P2dsetstatOutputs:
    """
    Convert a p-value to a statistic of choice with reference to a specific dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `P2dsetstatOutputs`).
    """
    params = execution.params(params)
    cargs = p2dsetstat_cargs(params, execution)
    ret = p2dsetstat_outputs(params, execution)
    execution.run(cargs)
    return ret


def p2dsetstat(
    dataset: str,
    pvalue: float,
    bisided: bool = False,
    twosided: bool = False,
    onesided: bool = False,
    quiet: bool = False,
    runner: Runner | None = None,
) -> P2dsetstatOutputs:
    """
    Convert a p-value to a statistic of choice with reference to a specific dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset: Specify a dataset DDD and, if it has multiple sub-bricks, the\
            [i]th subbrick with the statistic of interest MUST be selected\
            explicitly; note the use of quotation marks around the brick selector\
            (because of the square-brackets). 'i' can be either a number or a\
            string label selector.
        pvalue: Input p-value P, which MUST be in the interval [0,1].
        bisided: Two-sided test.
        twosided: Two-sided test.
        onesided: One-sided test.
        quiet: Output only the final statistic value.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `P2dsetstatOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(P2DSETSTAT_METADATA)
    params = p2dsetstat_params(
        dataset=dataset,
        pvalue=pvalue,
        bisided=bisided,
        twosided=twosided,
        onesided=onesided,
        quiet=quiet,
    )
    return p2dsetstat_execute(params, execution)


__all__ = [
    "P2DSETSTAT_METADATA",
    "P2dsetstatOutputs",
    "P2dsetstatParameters",
    "p2dsetstat",
    "p2dsetstat_params",
]
