# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

PLUGOUT_DRIVE_METADATA = Metadata(
    id="e564caf5f546dd15c16ce24766b0a63f303b6ca9.boutiques",
    name="plugout_drive",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


PlugoutDriveParameters = typing.TypedDict('PlugoutDriveParameters', {
    "__STYXTYPE__": typing.Literal["plugout_drive"],
    "host": typing.NotRequired[str | None],
    "shm": bool,
    "verbose": bool,
    "port": typing.NotRequired[float | None],
    "maxwait": typing.NotRequired[float | None],
    "name": typing.NotRequired[str | None],
    "command": typing.NotRequired[list[str] | None],
    "quit": bool,
    "np": typing.NotRequired[float | None],
    "npq": typing.NotRequired[float | None],
    "npb": typing.NotRequired[float | None],
    "max_port_bloc": bool,
    "max_port_bloc_quiet": bool,
    "num_assigned_ports": bool,
    "num_assigned_ports_quiet": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "plugout_drive": plugout_drive_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class PlugoutDriveOutputs(typing.NamedTuple):
    """
    Output object returned when calling `plugout_drive(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def plugout_drive_params(
    host: str | None = None,
    shm: bool = False,
    verbose: bool = False,
    port: float | None = None,
    maxwait: float | None = None,
    name: str | None = None,
    command: list[str] | None = None,
    quit_: bool = False,
    np: float | None = None,
    npq: float | None = None,
    npb: float | None = None,
    max_port_bloc: bool = False,
    max_port_bloc_quiet: bool = False,
    num_assigned_ports: bool = False,
    num_assigned_ports_quiet: bool = False,
) -> PlugoutDriveParameters:
    """
    Build parameters.
    
    Args:
        host: Connect to AFNI running on the specified host using TCP/IP.\
            Default is 'localhost'.
        shm: Connect to the current host using shared memory for large data\
            transfers.
        verbose: Verbose mode.
        port: Use TCP/IP port number. Default is 8099.
        maxwait: Maximum wait time in seconds for AFNI to connect. Default is 9\
            seconds.
        name: Name that AFNI assigns to this plugout. Default is a pre-defined\
            name.
        command: Command to be executed on AFNI. Example: '-com "SET_FUNCTION\
            SomeFunction"'.
        quit_: Quit after executing all -com commands. Default is to wait for\
            more commands.
        np: Provide a port offset to allow multiple instances of AFNI <-->\
            SUMA, etc., on the same machine.
        npq: Like -np but quieter in the face of adversity.
        npb: Similar to -np, but using a block for easier usage.
        max_port_bloc: Print the current value of MAX_BLOC and exit.
        max_port_bloc_quiet: Print MAX_BLOC value and exit quietly.
        num_assigned_ports: Print the number of assigned ports used by AFNI and\
            exit.
        num_assigned_ports_quiet: Print the number of assigned ports used by\
            AFNI and exit quietly.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "plugout_drive",
        "shm": shm,
        "verbose": verbose,
        "quit": quit_,
        "max_port_bloc": max_port_bloc,
        "max_port_bloc_quiet": max_port_bloc_quiet,
        "num_assigned_ports": num_assigned_ports,
        "num_assigned_ports_quiet": num_assigned_ports_quiet,
    }
    if host is not None:
        params["host"] = host
    if port is not None:
        params["port"] = port
    if maxwait is not None:
        params["maxwait"] = maxwait
    if name is not None:
        params["name"] = name
    if command is not None:
        params["command"] = command
    if np is not None:
        params["np"] = np
    if npq is not None:
        params["npq"] = npq
    if npb is not None:
        params["npb"] = npb
    return params


def plugout_drive_cargs(
    params: PlugoutDriveParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("plugout_drive")
    if params.get("host") is not None:
        cargs.extend([
            "-host",
            params.get("host")
        ])
    if params.get("shm"):
        cargs.append("-shm")
    if params.get("verbose"):
        cargs.append("-v")
    if params.get("port") is not None:
        cargs.extend([
            "-port",
            str(params.get("port"))
        ])
    if params.get("maxwait") is not None:
        cargs.extend([
            "-maxwait",
            str(params.get("maxwait"))
        ])
    if params.get("name") is not None:
        cargs.extend([
            "-name",
            params.get("name")
        ])
    if params.get("command") is not None:
        cargs.extend([
            "-com",
            *params.get("command")
        ])
    if params.get("quit"):
        cargs.append("-quit")
    if params.get("np") is not None:
        cargs.extend([
            "-np",
            str(params.get("np"))
        ])
    if params.get("npq") is not None:
        cargs.extend([
            "-npq",
            str(params.get("npq"))
        ])
    if params.get("npb") is not None:
        cargs.extend([
            "-npb",
            str(params.get("npb"))
        ])
    if params.get("max_port_bloc"):
        cargs.append("-max_port_bloc")
    if params.get("max_port_bloc_quiet"):
        cargs.append("-max_port_bloc_quiet")
    if params.get("num_assigned_ports"):
        cargs.append("-num_assigned_ports")
    if params.get("num_assigned_ports_quiet"):
        cargs.append("-num_assigned_ports_quiet")
    return cargs


def plugout_drive_outputs(
    params: PlugoutDriveParameters,
    execution: Execution,
) -> PlugoutDriveOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = PlugoutDriveOutputs(
        root=execution.output_file("."),
    )
    return ret


def plugout_drive_execute(
    params: PlugoutDriveParameters,
    execution: Execution,
) -> PlugoutDriveOutputs:
    """
    This program connects to AFNI and sends commands that the user specifies
    interactively or on command line over to AFNI to be executed.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `PlugoutDriveOutputs`).
    """
    params = execution.params(params)
    cargs = plugout_drive_cargs(params, execution)
    ret = plugout_drive_outputs(params, execution)
    execution.run(cargs)
    return ret


def plugout_drive(
    host: str | None = None,
    shm: bool = False,
    verbose: bool = False,
    port: float | None = None,
    maxwait: float | None = None,
    name: str | None = None,
    command: list[str] | None = None,
    quit_: bool = False,
    np: float | None = None,
    npq: float | None = None,
    npb: float | None = None,
    max_port_bloc: bool = False,
    max_port_bloc_quiet: bool = False,
    num_assigned_ports: bool = False,
    num_assigned_ports_quiet: bool = False,
    runner: Runner | None = None,
) -> PlugoutDriveOutputs:
    """
    This program connects to AFNI and sends commands that the user specifies
    interactively or on command line over to AFNI to be executed.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        host: Connect to AFNI running on the specified host using TCP/IP.\
            Default is 'localhost'.
        shm: Connect to the current host using shared memory for large data\
            transfers.
        verbose: Verbose mode.
        port: Use TCP/IP port number. Default is 8099.
        maxwait: Maximum wait time in seconds for AFNI to connect. Default is 9\
            seconds.
        name: Name that AFNI assigns to this plugout. Default is a pre-defined\
            name.
        command: Command to be executed on AFNI. Example: '-com "SET_FUNCTION\
            SomeFunction"'.
        quit_: Quit after executing all -com commands. Default is to wait for\
            more commands.
        np: Provide a port offset to allow multiple instances of AFNI <-->\
            SUMA, etc., on the same machine.
        npq: Like -np but quieter in the face of adversity.
        npb: Similar to -np, but using a block for easier usage.
        max_port_bloc: Print the current value of MAX_BLOC and exit.
        max_port_bloc_quiet: Print MAX_BLOC value and exit quietly.
        num_assigned_ports: Print the number of assigned ports used by AFNI and\
            exit.
        num_assigned_ports_quiet: Print the number of assigned ports used by\
            AFNI and exit quietly.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `PlugoutDriveOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(PLUGOUT_DRIVE_METADATA)
    params = plugout_drive_params(
        host=host,
        shm=shm,
        verbose=verbose,
        port=port,
        maxwait=maxwait,
        name=name,
        command=command,
        quit_=quit_,
        np=np,
        npq=npq,
        npb=npb,
        max_port_bloc=max_port_bloc,
        max_port_bloc_quiet=max_port_bloc_quiet,
        num_assigned_ports=num_assigned_ports,
        num_assigned_ports_quiet=num_assigned_ports_quiet,
    )
    return plugout_drive_execute(params, execution)


__all__ = [
    "PLUGOUT_DRIVE_METADATA",
    "PlugoutDriveOutputs",
    "PlugoutDriveParameters",
    "plugout_drive",
    "plugout_drive_params",
]
