# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

PLUGOUT_TTA_METADATA = Metadata(
    id="26a67b6d99edd0b87b407eb196b2417061d34e4e.boutiques",
    name="plugout_tta",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


PlugoutTtaParameters = typing.TypedDict('PlugoutTtaParameters', {
    "__STYXTYPE__": typing.Literal["plugout_tta"],
    "host": typing.NotRequired[str | None],
    "port": typing.NotRequired[int | None],
    "verbose": bool,
    "port_offset": typing.NotRequired[int | None],
    "port_offset_quiet": typing.NotRequired[int | None],
    "port_offset_bloc": typing.NotRequired[int | None],
    "max_port_bloc": bool,
    "max_port_bloc_quiet": bool,
    "num_assigned_ports": bool,
    "num_assigned_ports_quiet": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "plugout_tta": plugout_tta_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class PlugoutTtaOutputs(typing.NamedTuple):
    """
    Output object returned when calling `plugout_tta(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def plugout_tta_params(
    host: str | None = None,
    port: int | None = None,
    verbose: bool = False,
    port_offset: int | None = None,
    port_offset_quiet: int | None = None,
    port_offset_bloc: int | None = None,
    max_port_bloc: bool = False,
    max_port_bloc_quiet: bool = False,
    num_assigned_ports: bool = False,
    num_assigned_ports_quiet: bool = False,
) -> PlugoutTtaParameters:
    """
    Build parameters.
    
    Args:
        host: Connect to AFNI running on the specified computer using TCP/IP.\
            Use '-host localhost' to connect on current host with TCP/IP.
        port: Use TCP/IP port number 'pp'. Default is 8005.
        verbose: Verbose mode: prints out progress reports.
        port_offset: Provide a port offset to allow multiple instances of\
            programs to communicate on the same machine. All ports are assigned\
            numbers relative to PORT_OFFSET. Range: [1025, 65500].
        port_offset_quiet: Like -np, but more quiet in the face of adversity.
        port_offset_bloc: Provide a port offset block. Easier to use than -np.\
            Range: [0, MAX_BLOC]. Using this reduces chances of port conflicts.
        max_port_bloc: Print the current value of MAX_BLOC and exit.
        max_port_bloc_quiet: Print MAX_BLOC value and exit quietly.
        num_assigned_ports: Print the number of assigned ports used by AFNI\
            then quit.
        num_assigned_ports_quiet: Print the number of assigned ports used by\
            AFNI then quit quietly.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "plugout_tta",
        "verbose": verbose,
        "max_port_bloc": max_port_bloc,
        "max_port_bloc_quiet": max_port_bloc_quiet,
        "num_assigned_ports": num_assigned_ports,
        "num_assigned_ports_quiet": num_assigned_ports_quiet,
    }
    if host is not None:
        params["host"] = host
    if port is not None:
        params["port"] = port
    if port_offset is not None:
        params["port_offset"] = port_offset
    if port_offset_quiet is not None:
        params["port_offset_quiet"] = port_offset_quiet
    if port_offset_bloc is not None:
        params["port_offset_bloc"] = port_offset_bloc
    return params


def plugout_tta_cargs(
    params: PlugoutTtaParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("plugout_tta")
    if params.get("host") is not None:
        cargs.extend([
            "-host",
            params.get("host")
        ])
    if params.get("port") is not None:
        cargs.extend([
            "-port",
            str(params.get("port"))
        ])
    if params.get("verbose"):
        cargs.append("-v")
    if params.get("port_offset") is not None:
        cargs.extend([
            "-np",
            str(params.get("port_offset"))
        ])
    if params.get("port_offset_quiet") is not None:
        cargs.extend([
            "-npq",
            str(params.get("port_offset_quiet"))
        ])
    if params.get("port_offset_bloc") is not None:
        cargs.extend([
            "-npb",
            str(params.get("port_offset_bloc"))
        ])
    if params.get("max_port_bloc"):
        cargs.append("-max_port_bloc")
    if params.get("max_port_bloc_quiet"):
        cargs.append("-max_port_bloc_quiet")
    if params.get("num_assigned_ports"):
        cargs.append("-num_assigned_ports")
    if params.get("num_assigned_ports_quiet"):
        cargs.append("-num_assigned_ports_quiet")
    return cargs


def plugout_tta_outputs(
    params: PlugoutTtaParameters,
    execution: Execution,
) -> PlugoutTtaOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = PlugoutTtaOutputs(
        root=execution.output_file("."),
    )
    return ret


def plugout_tta_execute(
    params: PlugoutTtaParameters,
    execution: Execution,
) -> PlugoutTtaOutputs:
    """
    Connects to AFNI and receives notification whenever the user changes Talairach
    coordinates, then drives Netscape to display the closest figures from the
    Talairach-Tournoux atlas.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `PlugoutTtaOutputs`).
    """
    params = execution.params(params)
    cargs = plugout_tta_cargs(params, execution)
    ret = plugout_tta_outputs(params, execution)
    execution.run(cargs)
    return ret


def plugout_tta(
    host: str | None = None,
    port: int | None = None,
    verbose: bool = False,
    port_offset: int | None = None,
    port_offset_quiet: int | None = None,
    port_offset_bloc: int | None = None,
    max_port_bloc: bool = False,
    max_port_bloc_quiet: bool = False,
    num_assigned_ports: bool = False,
    num_assigned_ports_quiet: bool = False,
    runner: Runner | None = None,
) -> PlugoutTtaOutputs:
    """
    Connects to AFNI and receives notification whenever the user changes Talairach
    coordinates, then drives Netscape to display the closest figures from the
    Talairach-Tournoux atlas.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        host: Connect to AFNI running on the specified computer using TCP/IP.\
            Use '-host localhost' to connect on current host with TCP/IP.
        port: Use TCP/IP port number 'pp'. Default is 8005.
        verbose: Verbose mode: prints out progress reports.
        port_offset: Provide a port offset to allow multiple instances of\
            programs to communicate on the same machine. All ports are assigned\
            numbers relative to PORT_OFFSET. Range: [1025, 65500].
        port_offset_quiet: Like -np, but more quiet in the face of adversity.
        port_offset_bloc: Provide a port offset block. Easier to use than -np.\
            Range: [0, MAX_BLOC]. Using this reduces chances of port conflicts.
        max_port_bloc: Print the current value of MAX_BLOC and exit.
        max_port_bloc_quiet: Print MAX_BLOC value and exit quietly.
        num_assigned_ports: Print the number of assigned ports used by AFNI\
            then quit.
        num_assigned_ports_quiet: Print the number of assigned ports used by\
            AFNI then quit quietly.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `PlugoutTtaOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(PLUGOUT_TTA_METADATA)
    params = plugout_tta_params(
        host=host,
        port=port,
        verbose=verbose,
        port_offset=port_offset,
        port_offset_quiet=port_offset_quiet,
        port_offset_bloc=port_offset_bloc,
        max_port_bloc=max_port_bloc,
        max_port_bloc_quiet=max_port_bloc_quiet,
        num_assigned_ports=num_assigned_ports,
        num_assigned_ports_quiet=num_assigned_ports_quiet,
    )
    return plugout_tta_execute(params, execution)


__all__ = [
    "PLUGOUT_TTA_METADATA",
    "PlugoutTtaOutputs",
    "PlugoutTtaParameters",
    "plugout_tta",
    "plugout_tta_params",
]
