# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

PROMPT_POPUP_METADATA = Metadata(
    id="c24519073e7efb98045929a1a4d42a4a25f3e8ef.boutiques",
    name="prompt_popup",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


PromptPopupParameters = typing.TypedDict('PromptPopupParameters', {
    "__STYXTYPE__": typing.Literal["prompt_popup"],
    "message": str,
    "message_pause": typing.NotRequired[str | None],
    "buttons": typing.NotRequired[list[str] | None],
    "buttons_b": typing.NotRequired[list[str] | None],
    "timeout": typing.NotRequired[float | None],
    "timeout_to": typing.NotRequired[float | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "prompt_popup": prompt_popup_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class PromptPopupOutputs(typing.NamedTuple):
    """
    Output object returned when calling `prompt_popup(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def prompt_popup_params(
    message: str,
    message_pause: str | None = None,
    buttons: list[str] | None = None,
    buttons_b: list[str] | None = None,
    timeout: float | None = None,
    timeout_to: float | None = None,
) -> PromptPopupParameters:
    """
    Build parameters.
    
    Args:
        message: Pops a window prompting the user with MESSAGE. If MESSAGE is\
            '-', it is read from stdin.
        message_pause: Same as -message to match the old prompt_user.
        buttons: What do you want the buttons to say? You can give up to three\
            -button for three buttons. Returns integer 1, 2, or 3. If there is no\
            -button, there will be one button 'Ok'.
        buttons_b: Same as -button.
        timeout: Timeout in seconds of prompt message. Default answer is\
            returned if TT seconds elapse without user input.
        timeout_to: Same as -timeout TT.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "prompt_popup",
        "message": message,
    }
    if message_pause is not None:
        params["message_pause"] = message_pause
    if buttons is not None:
        params["buttons"] = buttons
    if buttons_b is not None:
        params["buttons_b"] = buttons_b
    if timeout is not None:
        params["timeout"] = timeout
    if timeout_to is not None:
        params["timeout_to"] = timeout_to
    return params


def prompt_popup_cargs(
    params: PromptPopupParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("prompt_popup")
    cargs.extend([
        "-message",
        params.get("message")
    ])
    if params.get("message_pause") is not None:
        cargs.extend([
            "-pause",
            params.get("message_pause")
        ])
    if params.get("buttons") is not None:
        cargs.extend([
            "-button",
            *params.get("buttons")
        ])
    if params.get("buttons_b") is not None:
        cargs.extend([
            "-b",
            *params.get("buttons_b")
        ])
    if params.get("timeout") is not None:
        cargs.extend([
            "-timeout",
            str(params.get("timeout"))
        ])
    if params.get("timeout_to") is not None:
        cargs.extend([
            "-to",
            str(params.get("timeout_to"))
        ])
    return cargs


def prompt_popup_outputs(
    params: PromptPopupParameters,
    execution: Execution,
) -> PromptPopupOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = PromptPopupOutputs(
        root=execution.output_file("."),
    )
    return ret


def prompt_popup_execute(
    params: PromptPopupParameters,
    execution: Execution,
) -> PromptPopupOutputs:
    """
    A command-line tool that pops up a window prompting user interaction with a
    message and buttons.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `PromptPopupOutputs`).
    """
    params = execution.params(params)
    cargs = prompt_popup_cargs(params, execution)
    ret = prompt_popup_outputs(params, execution)
    execution.run(cargs)
    return ret


def prompt_popup(
    message: str,
    message_pause: str | None = None,
    buttons: list[str] | None = None,
    buttons_b: list[str] | None = None,
    timeout: float | None = None,
    timeout_to: float | None = None,
    runner: Runner | None = None,
) -> PromptPopupOutputs:
    """
    A command-line tool that pops up a window prompting user interaction with a
    message and buttons.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        message: Pops a window prompting the user with MESSAGE. If MESSAGE is\
            '-', it is read from stdin.
        message_pause: Same as -message to match the old prompt_user.
        buttons: What do you want the buttons to say? You can give up to three\
            -button for three buttons. Returns integer 1, 2, or 3. If there is no\
            -button, there will be one button 'Ok'.
        buttons_b: Same as -button.
        timeout: Timeout in seconds of prompt message. Default answer is\
            returned if TT seconds elapse without user input.
        timeout_to: Same as -timeout TT.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `PromptPopupOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(PROMPT_POPUP_METADATA)
    params = prompt_popup_params(
        message=message,
        message_pause=message_pause,
        buttons=buttons,
        buttons_b=buttons_b,
        timeout=timeout,
        timeout_to=timeout_to,
    )
    return prompt_popup_execute(params, execution)


__all__ = [
    "PROMPT_POPUP_METADATA",
    "PromptPopupOutputs",
    "PromptPopupParameters",
    "prompt_popup",
    "prompt_popup_params",
]
