# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

QDELAUNAY_METADATA = Metadata(
    id="a916e82e97bc11f21ddb66b1db2b18fd597bc7b9.boutiques",
    name="qdelaunay",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


QdelaunayParameters = typing.TypedDict('QdelaunayParameters', {
    "__STYXTYPE__": typing.Literal["qdelaunay"],
    "input_file": InputPathType,
    "furthest_site": bool,
    "triangulated_output": bool,
    "joggled_input": bool,
    "joggle_range": typing.NotRequired[float | None],
    "search_simplex": bool,
    "point_infinity": bool,
    "delaunay_visible": typing.NotRequired[str | None],
    "delaunay_regions": typing.NotRequired[str | None],
    "trace_level": typing.NotRequired[float | None],
    "check": bool,
    "statistics": bool,
    "verify": bool,
    "output_stdout": bool,
    "facets_summary": typing.NotRequired[float | None],
    "input_file_option": typing.NotRequired[InputPathType | None],
    "output_file_option": typing.NotRequired[InputPathType | None],
    "trace_point": typing.NotRequired[float | None],
    "trace_merge": typing.NotRequired[float | None],
    "trace_merge_width": typing.NotRequired[float | None],
    "stop_point": typing.NotRequired[float | None],
    "stop_cone_point": typing.NotRequired[float | None],
    "centrum_radius": typing.NotRequired[float | None],
    "max_angle_cosine": typing.NotRequired[float | None],
    "perturb_factor": typing.NotRequired[float | None],
    "min_facet_width": typing.NotRequired[float | None],
    "facet_dump": bool,
    "geomview": bool,
    "vertices_incident": bool,
    "mathematica": bool,
    "off_format": bool,
    "point_coordinates": bool,
    "summary": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "qdelaunay": qdelaunay_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class QdelaunayOutputs(typing.NamedTuple):
    """
    Output object returned when calling `qdelaunay(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def qdelaunay_params(
    input_file: InputPathType,
    furthest_site: bool = False,
    triangulated_output: bool = False,
    joggled_input: bool = False,
    joggle_range: float | None = None,
    search_simplex: bool = False,
    point_infinity: bool = False,
    delaunay_visible: str | None = None,
    delaunay_regions: str | None = None,
    trace_level: float | None = None,
    check: bool = False,
    statistics_: bool = False,
    verify: bool = False,
    output_stdout: bool = False,
    facets_summary: float | None = None,
    input_file_option: InputPathType | None = None,
    output_file_option: InputPathType | None = None,
    trace_point: float | None = None,
    trace_merge: float | None = None,
    trace_merge_width: float | None = None,
    stop_point: float | None = None,
    stop_cone_point: float | None = None,
    centrum_radius: float | None = None,
    max_angle_cosine: float | None = None,
    perturb_factor: float | None = None,
    min_facet_width: float | None = None,
    facet_dump: bool = False,
    geomview: bool = False,
    vertices_incident: bool = False,
    mathematica: bool = False,
    off_format: bool = False,
    point_coordinates: bool = False,
    summary: bool = False,
) -> QdelaunayParameters:
    """
    Build parameters.
    
    Args:
        input_file: Input file containing point coordinates.
        furthest_site: Compute furthest-site Delaunay triangulation.
        triangulated_output: Triangulated output.
        joggled_input: Joggled input instead of merged facets.
        joggle_range: Randomly joggle input in range [-n,n].
        search_simplex: Search all points for the initial simplex.
        point_infinity: Add point-at-infinity to Delaunay triangulation.
        delaunay_visible: Print Delaunay region if visible from point n, -n if\
            not.
        delaunay_regions: Print Delaunay regions that include point n, -n if\
            not.
        trace_level: Trace at level n, 4=all, 5=mem/gauss, -1= events.
        check: Check frequently during execution.
        statistics_: Print statistics.
        verify: Verify result: structure, convexity, and in-circle test.
        output_stdout: Send all output to stdout.
        facets_summary: Report summary when n or more facets created.
        input_file_option: Input data from file, no spaces or single quotes.
        output_file_option: Output results to file, may be enclosed in single\
            quotes.
        trace_point: Turn on tracing when point n added to hull.
        trace_merge: Turn on tracing at merge n.
        trace_merge_width: Trace merge facets when width > n.
        stop_point: Stop Qhull after adding point n, -n for before.
        stop_cone_point: Stop Qhull after building cone for point n.
        centrum_radius: Radius of centrum (roundoff added). Merge facets if\
            non-convex.
        max_angle_cosine: Cosine of maximum angle. Merge facets if cosine > n\
            or non-convex.
        perturb_factor: Randomly perturb computations by a factor of [1-n,1+n].
        min_facet_width: Min facet width for outside point (before roundoff).
        facet_dump: Facet dump.
        geomview: Geomview output.
        vertices_incident: Vertices incident to each Delaunay region.
        mathematica: Mathematica output (2-d only, lifted to a paraboloid).
        off_format: OFF format (dim, points, and facets as a paraboloid).
        point_coordinates: Point coordinates (lifted to a paraboloid).
        summary: Summary (stderr).
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "qdelaunay",
        "input_file": input_file,
        "furthest_site": furthest_site,
        "triangulated_output": triangulated_output,
        "joggled_input": joggled_input,
        "search_simplex": search_simplex,
        "point_infinity": point_infinity,
        "check": check,
        "statistics": statistics_,
        "verify": verify,
        "output_stdout": output_stdout,
        "facet_dump": facet_dump,
        "geomview": geomview,
        "vertices_incident": vertices_incident,
        "mathematica": mathematica,
        "off_format": off_format,
        "point_coordinates": point_coordinates,
        "summary": summary,
    }
    if joggle_range is not None:
        params["joggle_range"] = joggle_range
    if delaunay_visible is not None:
        params["delaunay_visible"] = delaunay_visible
    if delaunay_regions is not None:
        params["delaunay_regions"] = delaunay_regions
    if trace_level is not None:
        params["trace_level"] = trace_level
    if facets_summary is not None:
        params["facets_summary"] = facets_summary
    if input_file_option is not None:
        params["input_file_option"] = input_file_option
    if output_file_option is not None:
        params["output_file_option"] = output_file_option
    if trace_point is not None:
        params["trace_point"] = trace_point
    if trace_merge is not None:
        params["trace_merge"] = trace_merge
    if trace_merge_width is not None:
        params["trace_merge_width"] = trace_merge_width
    if stop_point is not None:
        params["stop_point"] = stop_point
    if stop_cone_point is not None:
        params["stop_cone_point"] = stop_cone_point
    if centrum_radius is not None:
        params["centrum_radius"] = centrum_radius
    if max_angle_cosine is not None:
        params["max_angle_cosine"] = max_angle_cosine
    if perturb_factor is not None:
        params["perturb_factor"] = perturb_factor
    if min_facet_width is not None:
        params["min_facet_width"] = min_facet_width
    return params


def qdelaunay_cargs(
    params: QdelaunayParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("qdelaunay")
    cargs.append(execution.input_file(params.get("input_file")))
    if params.get("furthest_site"):
        cargs.append("Qu")
    if params.get("triangulated_output"):
        cargs.append("Qt")
    if params.get("joggled_input"):
        cargs.append("QJ")
    if params.get("joggle_range") is not None:
        cargs.extend([
            "QJn",
            str(params.get("joggle_range"))
        ])
    if params.get("search_simplex"):
        cargs.append("Qs")
    if params.get("point_infinity"):
        cargs.append("Qz")
    if params.get("delaunay_visible") is not None:
        cargs.extend([
            "QGn",
            params.get("delaunay_visible")
        ])
    if params.get("delaunay_regions") is not None:
        cargs.extend([
            "QVn",
            params.get("delaunay_regions")
        ])
    if params.get("trace_level") is not None:
        cargs.extend([
            "T4",
            str(params.get("trace_level"))
        ])
    if params.get("check"):
        cargs.append("Tc")
    if params.get("statistics"):
        cargs.append("Ts")
    if params.get("verify"):
        cargs.append("Tv")
    if params.get("output_stdout"):
        cargs.append("Tz")
    if params.get("facets_summary") is not None:
        cargs.extend([
            "TFn",
            str(params.get("facets_summary"))
        ])
    if params.get("input_file_option") is not None:
        cargs.extend([
            "TI",
            execution.input_file(params.get("input_file_option"))
        ])
    if params.get("output_file_option") is not None:
        cargs.extend([
            "TO",
            execution.input_file(params.get("output_file_option"))
        ])
    if params.get("trace_point") is not None:
        cargs.extend([
            "TPn",
            str(params.get("trace_point"))
        ])
    if params.get("trace_merge") is not None:
        cargs.extend([
            "TMn",
            str(params.get("trace_merge"))
        ])
    if params.get("trace_merge_width") is not None:
        cargs.extend([
            "TWn",
            str(params.get("trace_merge_width"))
        ])
    if params.get("stop_point") is not None:
        cargs.extend([
            "TVn",
            str(params.get("stop_point"))
        ])
    if params.get("stop_cone_point") is not None:
        cargs.extend([
            "TCn",
            str(params.get("stop_cone_point"))
        ])
    if params.get("centrum_radius") is not None:
        cargs.extend([
            "Cn",
            str(params.get("centrum_radius"))
        ])
    if params.get("max_angle_cosine") is not None:
        cargs.extend([
            "An",
            str(params.get("max_angle_cosine"))
        ])
    if params.get("perturb_factor") is not None:
        cargs.extend([
            "Rn",
            str(params.get("perturb_factor"))
        ])
    if params.get("min_facet_width") is not None:
        cargs.extend([
            "Wn",
            str(params.get("min_facet_width"))
        ])
    if params.get("facet_dump"):
        cargs.append("f")
    if params.get("geomview"):
        cargs.append("G")
    if params.get("vertices_incident"):
        cargs.append("i")
    if params.get("mathematica"):
        cargs.append("m")
    if params.get("off_format"):
        cargs.append("o")
    if params.get("point_coordinates"):
        cargs.append("p")
    if params.get("summary"):
        cargs.append("s")
    return cargs


def qdelaunay_outputs(
    params: QdelaunayParameters,
    execution: Execution,
) -> QdelaunayOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = QdelaunayOutputs(
        root=execution.output_file("."),
    )
    return ret


def qdelaunay_execute(
    params: QdelaunayParameters,
    execution: Execution,
) -> QdelaunayOutputs:
    """
    Compute the Delaunay triangulation using Qhull.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `QdelaunayOutputs`).
    """
    params = execution.params(params)
    cargs = qdelaunay_cargs(params, execution)
    ret = qdelaunay_outputs(params, execution)
    execution.run(cargs)
    return ret


def qdelaunay(
    input_file: InputPathType,
    furthest_site: bool = False,
    triangulated_output: bool = False,
    joggled_input: bool = False,
    joggle_range: float | None = None,
    search_simplex: bool = False,
    point_infinity: bool = False,
    delaunay_visible: str | None = None,
    delaunay_regions: str | None = None,
    trace_level: float | None = None,
    check: bool = False,
    statistics_: bool = False,
    verify: bool = False,
    output_stdout: bool = False,
    facets_summary: float | None = None,
    input_file_option: InputPathType | None = None,
    output_file_option: InputPathType | None = None,
    trace_point: float | None = None,
    trace_merge: float | None = None,
    trace_merge_width: float | None = None,
    stop_point: float | None = None,
    stop_cone_point: float | None = None,
    centrum_radius: float | None = None,
    max_angle_cosine: float | None = None,
    perturb_factor: float | None = None,
    min_facet_width: float | None = None,
    facet_dump: bool = False,
    geomview: bool = False,
    vertices_incident: bool = False,
    mathematica: bool = False,
    off_format: bool = False,
    point_coordinates: bool = False,
    summary: bool = False,
    runner: Runner | None = None,
) -> QdelaunayOutputs:
    """
    Compute the Delaunay triangulation using Qhull.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_file: Input file containing point coordinates.
        furthest_site: Compute furthest-site Delaunay triangulation.
        triangulated_output: Triangulated output.
        joggled_input: Joggled input instead of merged facets.
        joggle_range: Randomly joggle input in range [-n,n].
        search_simplex: Search all points for the initial simplex.
        point_infinity: Add point-at-infinity to Delaunay triangulation.
        delaunay_visible: Print Delaunay region if visible from point n, -n if\
            not.
        delaunay_regions: Print Delaunay regions that include point n, -n if\
            not.
        trace_level: Trace at level n, 4=all, 5=mem/gauss, -1= events.
        check: Check frequently during execution.
        statistics_: Print statistics.
        verify: Verify result: structure, convexity, and in-circle test.
        output_stdout: Send all output to stdout.
        facets_summary: Report summary when n or more facets created.
        input_file_option: Input data from file, no spaces or single quotes.
        output_file_option: Output results to file, may be enclosed in single\
            quotes.
        trace_point: Turn on tracing when point n added to hull.
        trace_merge: Turn on tracing at merge n.
        trace_merge_width: Trace merge facets when width > n.
        stop_point: Stop Qhull after adding point n, -n for before.
        stop_cone_point: Stop Qhull after building cone for point n.
        centrum_radius: Radius of centrum (roundoff added). Merge facets if\
            non-convex.
        max_angle_cosine: Cosine of maximum angle. Merge facets if cosine > n\
            or non-convex.
        perturb_factor: Randomly perturb computations by a factor of [1-n,1+n].
        min_facet_width: Min facet width for outside point (before roundoff).
        facet_dump: Facet dump.
        geomview: Geomview output.
        vertices_incident: Vertices incident to each Delaunay region.
        mathematica: Mathematica output (2-d only, lifted to a paraboloid).
        off_format: OFF format (dim, points, and facets as a paraboloid).
        point_coordinates: Point coordinates (lifted to a paraboloid).
        summary: Summary (stderr).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `QdelaunayOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(QDELAUNAY_METADATA)
    params = qdelaunay_params(
        input_file=input_file,
        furthest_site=furthest_site,
        triangulated_output=triangulated_output,
        joggled_input=joggled_input,
        joggle_range=joggle_range,
        search_simplex=search_simplex,
        point_infinity=point_infinity,
        delaunay_visible=delaunay_visible,
        delaunay_regions=delaunay_regions,
        trace_level=trace_level,
        check=check,
        statistics_=statistics_,
        verify=verify,
        output_stdout=output_stdout,
        facets_summary=facets_summary,
        input_file_option=input_file_option,
        output_file_option=output_file_option,
        trace_point=trace_point,
        trace_merge=trace_merge,
        trace_merge_width=trace_merge_width,
        stop_point=stop_point,
        stop_cone_point=stop_cone_point,
        centrum_radius=centrum_radius,
        max_angle_cosine=max_angle_cosine,
        perturb_factor=perturb_factor,
        min_facet_width=min_facet_width,
        facet_dump=facet_dump,
        geomview=geomview,
        vertices_incident=vertices_incident,
        mathematica=mathematica,
        off_format=off_format,
        point_coordinates=point_coordinates,
        summary=summary,
    )
    return qdelaunay_execute(params, execution)


__all__ = [
    "QDELAUNAY_METADATA",
    "QdelaunayOutputs",
    "QdelaunayParameters",
    "qdelaunay",
    "qdelaunay_params",
]
