# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

QUICKSPEC_METADATA = Metadata(
    id="46432d665730d07674145b924b55e89f5ce5660b.boutiques",
    name="quickspec",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


QuickspecParameters = typing.TypedDict('QuickspecParameters', {
    "__STYXTYPE__": typing.Literal["quickspec"],
    "tn": list[str],
    "tsn": list[str],
    "tsnad": typing.NotRequired[list[str] | None],
    "tsnadm": typing.NotRequired[list[str] | None],
    "tsnadl": typing.NotRequired[list[str] | None],
    "spec": typing.NotRequired[str | None],
    "help": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "quickspec": quickspec_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "quickspec": quickspec_outputs,
    }.get(t)


class QuickspecOutputs(typing.NamedTuple):
    """
    Output object returned when calling `quickspec(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_specfile: OutputPathType | None
    """The spec file output."""


def quickspec_params(
    tn: list[str],
    tsn: list[str],
    tsnad: list[str] | None = None,
    tsnadm: list[str] | None = None,
    tsnadl: list[str] | None = None,
    spec: str | None = None,
    help_: bool = False,
) -> QuickspecParameters:
    """
    Build parameters.
    
    Args:
        tn: Specify surface type and name.
        tsn: Specify surface type, state, and name.
        tsnad: Specify surface type, state, name, anatomical correctness, and\
            Local Domain Parent.
        tsnadm: Specify surface type, state, name, anatomical correctness,\
            Local Domain Parent, and node marker file.
        tsnadl: Specify surface type, state, name, anatomical correctness,\
            Local Domain Parent, and label dataset file.
        spec: Name of spec file output. Default is quick.spec.
        help_: Display help message.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "quickspec",
        "tn": tn,
        "tsn": tsn,
        "help": help_,
    }
    if tsnad is not None:
        params["tsnad"] = tsnad
    if tsnadm is not None:
        params["tsnadm"] = tsnadm
    if tsnadl is not None:
        params["tsnadl"] = tsnadl
    if spec is not None:
        params["spec"] = spec
    return params


def quickspec_cargs(
    params: QuickspecParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("quickspec")
    cargs.extend([
        "-tn",
        *params.get("tn")
    ])
    cargs.extend([
        "-tsn",
        *params.get("tsn")
    ])
    if params.get("tsnad") is not None:
        cargs.extend([
            "-tsnad",
            *params.get("tsnad")
        ])
    if params.get("tsnadm") is not None:
        cargs.extend([
            "-tsnadm",
            *params.get("tsnadm")
        ])
    if params.get("tsnadl") is not None:
        cargs.extend([
            "-tsnadl",
            *params.get("tsnadl")
        ])
    if params.get("spec") is not None:
        cargs.extend([
            "-spec",
            params.get("spec")
        ])
    if params.get("help"):
        cargs.append("-h")
    return cargs


def quickspec_outputs(
    params: QuickspecParameters,
    execution: Execution,
) -> QuickspecOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = QuickspecOutputs(
        root=execution.output_file("."),
        out_specfile=execution.output_file(params.get("spec")) if (params.get("spec") is not None) else None,
    )
    return ret


def quickspec_execute(
    params: QuickspecParameters,
    execution: Execution,
) -> QuickspecOutputs:
    """
    A quick and dirty way of loading a surface into SUMA or command line programs
    using a spec file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `QuickspecOutputs`).
    """
    params = execution.params(params)
    cargs = quickspec_cargs(params, execution)
    ret = quickspec_outputs(params, execution)
    execution.run(cargs)
    return ret


def quickspec(
    tn: list[str],
    tsn: list[str],
    tsnad: list[str] | None = None,
    tsnadm: list[str] | None = None,
    tsnadl: list[str] | None = None,
    spec: str | None = None,
    help_: bool = False,
    runner: Runner | None = None,
) -> QuickspecOutputs:
    """
    A quick and dirty way of loading a surface into SUMA or command line programs
    using a spec file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        tn: Specify surface type and name.
        tsn: Specify surface type, state, and name.
        tsnad: Specify surface type, state, name, anatomical correctness, and\
            Local Domain Parent.
        tsnadm: Specify surface type, state, name, anatomical correctness,\
            Local Domain Parent, and node marker file.
        tsnadl: Specify surface type, state, name, anatomical correctness,\
            Local Domain Parent, and label dataset file.
        spec: Name of spec file output. Default is quick.spec.
        help_: Display help message.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `QuickspecOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(QUICKSPEC_METADATA)
    params = quickspec_params(
        tn=tn,
        tsn=tsn,
        tsnad=tsnad,
        tsnadm=tsnadm,
        tsnadl=tsnadl,
        spec=spec,
        help_=help_,
    )
    return quickspec_execute(params, execution)


__all__ = [
    "QUICKSPEC_METADATA",
    "QuickspecOutputs",
    "QuickspecParameters",
    "quickspec",
    "quickspec_params",
]
