# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

REALTIME_RECEIVER_METADATA = Metadata(
    id="3861e74ecb1900a71d5f24f43aeca5e7e336549d.boutiques",
    name="realtime_receiver",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


RealtimeReceiverParameters = typing.TypedDict('RealtimeReceiverParameters', {
    "__STYXTYPE__": typing.Literal["realtime_receiver"],
    "show_data": typing.NotRequired[typing.Literal["yes", "no"] | None],
    "write_text_data": typing.NotRequired[str | None],
    "data_choice": typing.NotRequired[typing.Literal["motion", "motion_norm", "all_extras", "diff_ratio"] | None],
    "serial_port": typing.NotRequired[str | None],
    "show_demo_gui": typing.NotRequired[typing.Literal["yes", "no"] | None],
    "dc_params": typing.NotRequired[list[float] | None],
    "extras_on_one_line": typing.NotRequired[typing.Literal["yes", "no"] | None],
    "show_comm_times": bool,
    "show_demo_data": bool,
    "swap": bool,
    "tcp_port": typing.NotRequired[float | None],
    "verbosity": typing.NotRequired[float | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "realtime_receiver": realtime_receiver_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class RealtimeReceiverOutputs(typing.NamedTuple):
    """
    Output object returned when calling `realtime_receiver(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def realtime_receiver_params(
    show_data: typing.Literal["yes", "no"] | None = None,
    write_text_data: str | None = None,
    data_choice: typing.Literal["motion", "motion_norm", "all_extras", "diff_ratio"] | None = None,
    serial_port: str | None = None,
    show_demo_gui: typing.Literal["yes", "no"] | None = None,
    dc_params: list[float] | None = None,
    extras_on_one_line: typing.Literal["yes", "no"] | None = None,
    show_comm_times: bool = False,
    show_demo_data: bool = False,
    swap: bool = False,
    tcp_port: float | None = None,
    verbosity: float | None = None,
) -> RealtimeReceiverParameters:
    """
    Build parameters.
    
    Args:
        show_data: Display incoming data in terminal window.
        write_text_data: Write data to text file.
        data_choice: Pick which data to send as feedback.
        serial_port: Specify serial port file for feedback data.
        show_demo_gui: Demonstrate a feedback GUI.
        dc_params: Set data_choice parameters, e.g. for diff_ratio, params P1\
            P2.
        extras_on_one_line: Show 'extras' on one line only.
        show_comm_times: Display communication times.
        show_demo_data: Display feedback data in terminal window.
        swap: Swap bytes of incoming data.
        tcp_port: Specify TCP port for incoming connections.
        verbosity: Set the verbosity level.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "realtime_receiver",
        "show_comm_times": show_comm_times,
        "show_demo_data": show_demo_data,
        "swap": swap,
    }
    if show_data is not None:
        params["show_data"] = show_data
    if write_text_data is not None:
        params["write_text_data"] = write_text_data
    if data_choice is not None:
        params["data_choice"] = data_choice
    if serial_port is not None:
        params["serial_port"] = serial_port
    if show_demo_gui is not None:
        params["show_demo_gui"] = show_demo_gui
    if dc_params is not None:
        params["dc_params"] = dc_params
    if extras_on_one_line is not None:
        params["extras_on_one_line"] = extras_on_one_line
    if tcp_port is not None:
        params["tcp_port"] = tcp_port
    if verbosity is not None:
        params["verbosity"] = verbosity
    return params


def realtime_receiver_cargs(
    params: RealtimeReceiverParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("realtime_receiver.py")
    if params.get("show_data") is not None:
        cargs.extend([
            "-show_data",
            params.get("show_data")
        ])
    if params.get("write_text_data") is not None:
        cargs.extend([
            "-write_text_data",
            params.get("write_text_data")
        ])
    if params.get("data_choice") is not None:
        cargs.extend([
            "-data_choice",
            params.get("data_choice")
        ])
    if params.get("serial_port") is not None:
        cargs.extend([
            "-serial_port",
            params.get("serial_port")
        ])
    if params.get("show_demo_gui") is not None:
        cargs.extend([
            "-show_demo_gui",
            params.get("show_demo_gui")
        ])
    if params.get("dc_params") is not None:
        cargs.extend([
            "-dc_params",
            *map(str, params.get("dc_params"))
        ])
    if params.get("extras_on_one_line") is not None:
        cargs.extend([
            "-extras_on_one_line",
            params.get("extras_on_one_line")
        ])
    if params.get("show_comm_times"):
        cargs.append("-show_comm_times")
    if params.get("show_demo_data"):
        cargs.append("-show_demo_data")
    if params.get("swap"):
        cargs.append("-swap")
    if params.get("tcp_port") is not None:
        cargs.extend([
            "-tcp_port",
            str(params.get("tcp_port"))
        ])
    if params.get("verbosity") is not None:
        cargs.extend([
            "-verb",
            str(params.get("verbosity"))
        ])
    return cargs


def realtime_receiver_outputs(
    params: RealtimeReceiverParameters,
    execution: Execution,
) -> RealtimeReceiverOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = RealtimeReceiverOutputs(
        root=execution.output_file("."),
    )
    return ret


def realtime_receiver_execute(
    params: RealtimeReceiverParameters,
    execution: Execution,
) -> RealtimeReceiverOutputs:
    """
    Program to receive and display real-time plugin data from AFNI.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `RealtimeReceiverOutputs`).
    """
    params = execution.params(params)
    cargs = realtime_receiver_cargs(params, execution)
    ret = realtime_receiver_outputs(params, execution)
    execution.run(cargs)
    return ret


def realtime_receiver(
    show_data: typing.Literal["yes", "no"] | None = None,
    write_text_data: str | None = None,
    data_choice: typing.Literal["motion", "motion_norm", "all_extras", "diff_ratio"] | None = None,
    serial_port: str | None = None,
    show_demo_gui: typing.Literal["yes", "no"] | None = None,
    dc_params: list[float] | None = None,
    extras_on_one_line: typing.Literal["yes", "no"] | None = None,
    show_comm_times: bool = False,
    show_demo_data: bool = False,
    swap: bool = False,
    tcp_port: float | None = None,
    verbosity: float | None = None,
    runner: Runner | None = None,
) -> RealtimeReceiverOutputs:
    """
    Program to receive and display real-time plugin data from AFNI.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        show_data: Display incoming data in terminal window.
        write_text_data: Write data to text file.
        data_choice: Pick which data to send as feedback.
        serial_port: Specify serial port file for feedback data.
        show_demo_gui: Demonstrate a feedback GUI.
        dc_params: Set data_choice parameters, e.g. for diff_ratio, params P1\
            P2.
        extras_on_one_line: Show 'extras' on one line only.
        show_comm_times: Display communication times.
        show_demo_data: Display feedback data in terminal window.
        swap: Swap bytes of incoming data.
        tcp_port: Specify TCP port for incoming connections.
        verbosity: Set the verbosity level.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `RealtimeReceiverOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(REALTIME_RECEIVER_METADATA)
    params = realtime_receiver_params(
        show_data=show_data,
        write_text_data=write_text_data,
        data_choice=data_choice,
        serial_port=serial_port,
        show_demo_gui=show_demo_gui,
        dc_params=dc_params,
        extras_on_one_line=extras_on_one_line,
        show_comm_times=show_comm_times,
        show_demo_data=show_demo_data,
        swap=swap,
        tcp_port=tcp_port,
        verbosity=verbosity,
    )
    return realtime_receiver_execute(params, execution)


__all__ = [
    "REALTIME_RECEIVER_METADATA",
    "RealtimeReceiverOutputs",
    "RealtimeReceiverParameters",
    "realtime_receiver",
    "realtime_receiver_params",
]
