# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

SFIM_METADATA = Metadata(
    id="b0a8b5208cc61585402c5d268873f5a63b76a9e6.boutiques",
    name="sfim",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


SfimParameters = typing.TypedDict('SfimParameters', {
    "__STYXTYPE__": typing.Literal["sfim"],
    "input_images": list[InputPathType],
    "sfint_file": typing.NotRequired[str | None],
    "baseline_state": typing.NotRequired[str | None],
    "local_base_option": bool,
    "output_prefix": typing.NotRequired[str | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "sfim": sfim_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "sfim": sfim_outputs,
    }.get(t)


class SfimOutputs(typing.NamedTuple):
    """
    Output object returned when calling `sfim(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_files: OutputPathType | None
    """Output image file for interval 'i' with task state name."""


def sfim_params(
    input_images: list[InputPathType],
    sfint_file: str | None = None,
    baseline_state: str | None = None,
    local_base_option: bool = False,
    output_prefix: str | None = None,
) -> SfimParameters:
    """
    Build parameters.
    
    Args:
        input_images: Input image files in formats accepted by AFNI.
        sfint_file: Filename which contains the interval definitions. Default\
            is 'sfint'. Example: '3*# 5*rest 4*A 5*rest 4*B 5*rest 4*A 5*rest'.
        baseline_state: Task state name to use as the baseline. Default is\
            'rest'.
        local_base_option: Flag to indicate if each non-base task state\
            interval should have the mean of the two nearest base intervals\
            subtracted instead of the grand mean of all the base task intervals.
        output_prefix: Prefix for output image filenames for all states. The\
            i'th interval with task state name 'fred' will be written to file\
            'pname.fred.i'. Default is 'sfim'.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "sfim",
        "input_images": input_images,
        "local_base_option": local_base_option,
    }
    if sfint_file is not None:
        params["sfint_file"] = sfint_file
    if baseline_state is not None:
        params["baseline_state"] = baseline_state
    if output_prefix is not None:
        params["output_prefix"] = output_prefix
    return params


def sfim_cargs(
    params: SfimParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("sfim")
    cargs.extend([execution.input_file(f) for f in params.get("input_images")])
    if params.get("sfint_file") is not None:
        cargs.extend([
            "-sfint",
            params.get("sfint_file")
        ])
    if params.get("baseline_state") is not None:
        cargs.extend([
            "-base",
            params.get("baseline_state")
        ])
    if params.get("local_base_option"):
        cargs.append("-localbase")
    if params.get("output_prefix") is not None:
        cargs.extend([
            "-prefix",
            params.get("output_prefix")
        ])
    return cargs


def sfim_outputs(
    params: SfimParameters,
    execution: Execution,
) -> SfimOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = SfimOutputs(
        root=execution.output_file("."),
        output_files=execution.output_file(params.get("output_prefix") + ".*.i") if (params.get("output_prefix") is not None) else None,
    )
    return ret


def sfim_execute(
    params: SfimParameters,
    execution: Execution,
) -> SfimOutputs:
    """
    Stepwise Functional IMages.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `SfimOutputs`).
    """
    params = execution.params(params)
    cargs = sfim_cargs(params, execution)
    ret = sfim_outputs(params, execution)
    execution.run(cargs)
    return ret


def sfim(
    input_images: list[InputPathType],
    sfint_file: str | None = None,
    baseline_state: str | None = None,
    local_base_option: bool = False,
    output_prefix: str | None = None,
    runner: Runner | None = None,
) -> SfimOutputs:
    """
    Stepwise Functional IMages.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_images: Input image files in formats accepted by AFNI.
        sfint_file: Filename which contains the interval definitions. Default\
            is 'sfint'. Example: '3*# 5*rest 4*A 5*rest 4*B 5*rest 4*A 5*rest'.
        baseline_state: Task state name to use as the baseline. Default is\
            'rest'.
        local_base_option: Flag to indicate if each non-base task state\
            interval should have the mean of the two nearest base intervals\
            subtracted instead of the grand mean of all the base task intervals.
        output_prefix: Prefix for output image filenames for all states. The\
            i'th interval with task state name 'fred' will be written to file\
            'pname.fred.i'. Default is 'sfim'.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `SfimOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(SFIM_METADATA)
    params = sfim_params(
        input_images=input_images,
        sfint_file=sfint_file,
        baseline_state=baseline_state,
        local_base_option=local_base_option,
        output_prefix=output_prefix,
    )
    return sfim_execute(params, execution)


__all__ = [
    "SFIM_METADATA",
    "SfimOutputs",
    "SfimParameters",
    "sfim",
    "sfim_params",
]
