# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

SUMA_GLXDINO_METADATA = Metadata(
    id="db20e466e60a0e5e1fdf389e067115a796b337a4.boutiques",
    name="SUMA_glxdino",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


SumaGlxdinoParameters = typing.TypedDict('SumaGlxdinoParameters', {
    "__STYXTYPE__": typing.Literal["SUMA_glxdino"],
    "verbose": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "SUMA_glxdino": suma_glxdino_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class SumaGlxdinoOutputs(typing.NamedTuple):
    """
    Output object returned when calling `suma_glxdino(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def suma_glxdino_params(
    verbose: bool = False,
) -> SumaGlxdinoParameters:
    """
    Build parameters.
    
    Args:
        verbose: Switch on diagnostic messages.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "SUMA_glxdino",
        "verbose": verbose,
    }
    return params


def suma_glxdino_cargs(
    params: SumaGlxdinoParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("SUMA_glxdino")
    if params.get("verbose"):
        cargs.append("-v")
    return cargs


def suma_glxdino_outputs(
    params: SumaGlxdinoParameters,
    execution: Execution,
) -> SumaGlxdinoOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = SumaGlxdinoOutputs(
        root=execution.output_file("."),
    )
    return ret


def suma_glxdino_execute(
    params: SumaGlxdinoParameters,
    execution: Execution,
) -> SumaGlxdinoOutputs:
    """
    A simple openGL test program using GLX. If it does not run, then SUMA certainly
    won't.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `SumaGlxdinoOutputs`).
    """
    params = execution.params(params)
    cargs = suma_glxdino_cargs(params, execution)
    ret = suma_glxdino_outputs(params, execution)
    execution.run(cargs)
    return ret


def suma_glxdino(
    verbose: bool = False,
    runner: Runner | None = None,
) -> SumaGlxdinoOutputs:
    """
    A simple openGL test program using GLX. If it does not run, then SUMA certainly
    won't.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        verbose: Switch on diagnostic messages.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `SumaGlxdinoOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(SUMA_GLXDINO_METADATA)
    params = suma_glxdino_params(
        verbose=verbose,
    )
    return suma_glxdino_execute(params, execution)


__all__ = [
    "SUMA_GLXDINO_METADATA",
    "SumaGlxdinoOutputs",
    "SumaGlxdinoParameters",
    "suma_glxdino",
    "suma_glxdino_params",
]
